/*!
 * Font Awesome Pro 5.11.2 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 */
(function () {
  'use strict';

  var _WINDOW = {};
  var _DOCUMENT = {};

  try {
    if (typeof window !== 'undefined') _WINDOW = window;
    if (typeof document !== 'undefined') _DOCUMENT = document;
  } catch (e) {}

  var _ref = _WINDOW.navigator || {},
      _ref$userAgent = _ref.userAgent,
      userAgent = _ref$userAgent === void 0 ? '' : _ref$userAgent;

  var WINDOW = _WINDOW;
  var DOCUMENT = _DOCUMENT;
  var IS_BROWSER = !!WINDOW.document;
  var IS_DOM = !!DOCUMENT.documentElement && !!DOCUMENT.head && typeof DOCUMENT.addEventListener === 'function' && typeof DOCUMENT.createElement === 'function';
  var IS_IE = ~userAgent.indexOf('MSIE') || ~userAgent.indexOf('Trident/');

  var NAMESPACE_IDENTIFIER = '___FONT_AWESOME___';
  var PRODUCTION = function () {
    try {
      return "production" === 'production';
    } catch (e) {
      return false;
    }
  }();

  function bunker(fn) {
    try {
      fn();
    } catch (e) {
      if (!PRODUCTION) {
        throw e;
      }
    }
  }

  function _defineProperty(obj, key, value) {
    if (key in obj) {
      Object.defineProperty(obj, key, {
        value: value,
        enumerable: true,
        configurable: true,
        writable: true
      });
    } else {
      obj[key] = value;
    }

    return obj;
  }

  function _objectSpread(target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i] != null ? arguments[i] : {};
      var ownKeys = Object.keys(source);

      if (typeof Object.getOwnPropertySymbols === 'function') {
        ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
          return Object.getOwnPropertyDescriptor(source, sym).enumerable;
        }));
      }

      ownKeys.forEach(function (key) {
        _defineProperty(target, key, source[key]);
      });
    }

    return target;
  }

  var w = WINDOW || {};
  if (!w[NAMESPACE_IDENTIFIER]) w[NAMESPACE_IDENTIFIER] = {};
  if (!w[NAMESPACE_IDENTIFIER].styles) w[NAMESPACE_IDENTIFIER].styles = {};
  if (!w[NAMESPACE_IDENTIFIER].hooks) w[NAMESPACE_IDENTIFIER].hooks = {};
  if (!w[NAMESPACE_IDENTIFIER].shims) w[NAMESPACE_IDENTIFIER].shims = [];
  var namespace = w[NAMESPACE_IDENTIFIER];

  function defineIcons(prefix, icons) {
    var params = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    var _params$skipHooks = params.skipHooks,
        skipHooks = _params$skipHooks === void 0 ? false : _params$skipHooks;
    var normalized = Object.keys(icons).reduce(function (acc, iconName) {
      var icon = icons[iconName];
      var expanded = !!icon.icon;

      if (expanded) {
        acc[icon.iconName] = icon.icon;
      } else {
        acc[iconName] = icon;
      }

      return acc;
    }, {});

    if (typeof namespace.hooks.addPack === 'function' && !skipHooks) {
      namespace.hooks.addPack(prefix, normalized);
    } else {
      namespace.styles[prefix] = _objectSpread({}, namespace.styles[prefix] || {}, normalized);
    }
    /**
     * Font Awesome 4 used the prefix of `fa` for all icons. With the introduction
     * of new styles we needed to differentiate between them. Prefix `fa` is now an alias
     * for `fas` so we'll easy the upgrade process for our users by automatically defining
     * this as well.
     */


    if (prefix === 'fas') {
      defineIcons('fa', icons);
    }
  }

  var icons = {
    "abacus": [576, 512, [], "f640", ["M192 440h-32v-48h32zM160 72v48h32V72zm96 160v48h32v-48zm-96 0v48h32v-48zm96 208h160v-48H256zm96-160h128v-48H352zM544 0a32 32 0 0 0-32 32v464a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V32a32 32 0 0 0-32-32zM416 72H256v48h160zM32 0A32 32 0 0 0 0 32v464a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V32A32 32 0 0 0 32 0z", "M144 32h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm-96 160h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-96a16 16 0 0 0-16-16zm192 0h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-96a16 16 0 0 0-16-16zm-96 0h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-96a16 16 0 0 0-16-16zM464 32h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zM144 352h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-96a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-96a16 16 0 0 0-16-16zm224 0h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-96a16 16 0 0 0-16-16z"]],
    "acorn": [448, 512, [], "f6ae", ["M32 256h384a258.87 258.87 0 0 1-143.11 231.55L224 512l-48.89-24.45A258.87 258.87 0 0 1 32 256z", "M448 160v32a32 32 0 0 1-32 32H32a32 32 0 0 1-32-32v-32a96 96 0 0 1 96-96h106a132.41 132.41 0 0 1 29.41-58.64 15.7 15.7 0 0 1 11.31-5.3 15.44 15.44 0 0 1 12 4.72L266 16.1a16 16 0 0 1 .66 21.9 84.32 84.32 0 0 0-15.16 26H352a96 96 0 0 1 96 96z"]],
    "ad": [512, 512, [], "f641", ["M352 256a24 24 0 1 0 24 24 24 24 0 0 0-24-24zm-194.48 16h37L176 218.78zM464 64H48a48 48 0 0 0-48 48v288a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V112a48 48 0 0 0-48-48zM250.58 352h-16.94a16 16 0 0 1-15.12-10.75L211.15 320h-70.29l-7.38 21.25A16 16 0 0 1 118.36 352h-16.94a16 16 0 0 1-15.12-21.25L140 176.12A24 24 0 0 1 162.67 160h26.66A24 24 0 0 1 212 176.13l53.69 154.62A16 16 0 0 1 250.58 352zM424 336a16 16 0 0 1-16 16h-16a15.74 15.74 0 0 1-12-5.68A72 72 0 1 1 352 208a71.05 71.05 0 0 1 24 4.42V176a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16z", "M212 176.13A24 24 0 0 0 189.33 160h-26.66A24 24 0 0 0 140 176.12L86.3 330.75A16 16 0 0 0 101.42 352h16.94a16 16 0 0 0 15.12-10.75l7.38-21.25h70.29l7.37 21.25A16 16 0 0 0 233.64 352h16.94a16 16 0 0 0 15.11-21.25zM157.52 272L176 218.78 194.48 272zM408 160h-16a16 16 0 0 0-16 16v36.42a71.05 71.05 0 0 0-24-4.42 72 72 0 1 0 28 138.32 15.74 15.74 0 0 0 12 5.68h16a16 16 0 0 0 16-16V176a16 16 0 0 0-16-16zm-56 144a24 24 0 1 1 24-24 24 24 0 0 1-24 24z"]],
    "address-book": [448, 512, [], "f2b9", ["M416 48a48 48 0 0 0-48-48H48A48 48 0 0 0 0 48v416a48 48 0 0 0 48 48h320a48 48 0 0 0 48-48zm-208 80a64 64 0 1 1-64 64 64.06 64.06 0 0 1 64-64zm112 236.8c0 10.6-10 19.2-22.4 19.2H118.4C106 384 96 375.4 96 364.8v-19.2c0-31.8 30.1-57.6 67.2-57.6h5a103 103 0 0 0 79.6 0h5c37.1 0 67.2 25.8 67.2 57.6z", "M252.8 288h-5a103 103 0 0 1-79.6 0h-5c-37.1 0-67.2 25.8-67.2 57.6v19.2c0 10.6 10 19.2 22.4 19.2h179.2c12.4 0 22.4-8.6 22.4-19.2v-19.2c0-31.8-30.1-57.6-67.2-57.6zM208 256a64 64 0 1 0-64-64 64.06 64.06 0 0 0 64 64zm228-32h-20v64h20a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm0 128h-20v64h20a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm0-256h-20v64h20a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12z"]],
    "address-card": [576, 512, [], "f2bb", ["M528 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h480a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-352 96a64 64 0 1 1-64 64 64.06 64.06 0 0 1 64-64zm112 236.8c0 10.6-10 19.2-22.4 19.2H86.4C74 384 64 375.4 64 364.8v-19.2c0-31.8 30.1-57.6 67.2-57.6h5a103 103 0 0 0 79.6 0h5c37.1 0 67.2 25.8 67.2 57.6zM512 312a8 8 0 0 1-8 8H360a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h144a8 8 0 0 1 8 8zm0-64a8 8 0 0 1-8 8H360a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h144a8 8 0 0 1 8 8zm0-64a8 8 0 0 1-8 8H360a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h144a8 8 0 0 1 8 8z", "M176 256a64 64 0 1 0-64-64 64.06 64.06 0 0 0 64 64zm44.8 32h-5a103 103 0 0 1-79.6 0h-5C94.1 288 64 313.8 64 345.6v19.2c0 10.6 10 19.2 22.4 19.2h179.2c12.4 0 22.4-8.6 22.4-19.2v-19.2c0-31.8-30.1-57.6-67.2-57.6z"]],
    "adjust": [512, 512, [], "f042", ["M504 256c0 137-111 248-248 248V8c137 0 248 111 248 248z", "M256 8v496C119 504 8 393 8 256S119 8 256 8z"]],
    "air-freshener": [384, 512, [], "f5d0", ["M304 432v32H80v-32h224m32-48H48a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h288a16 16 0 0 0 16-16v-96a16 16 0 0 0-16-16z", "M378.94 321.41L284.7 224h49.22c15.3 0 23.66-16.6 13.86-27.53L234.45 70A47.45 47.45 0 0 0 240 48a48 48 0 0 0-96 0 47.45 47.45 0 0 0 5.55 22L36.22 196.47C26.42 207.4 34.78 224 50.08 224H99.3L5.06 321.41C-6.69 333.56 3.34 352 21.7 352H160v32h64v-32h138.3c18.36 0 28.39-18.44 16.64-30.59zM192 64a16 16 0 1 1 16-16 16 16 0 0 1-16 16z"]],
    "alarm-clock": [512, 512, [], "f34e", ["M474.49 462.06L434.55 422a223.25 223.25 0 0 0 44.61-134c0-123.71-99.9-224-223.14-224S32.88 164.29 32.88 288a223.25 223.25 0 0 0 44.61 134l-39.95 40.06a16.05 16.05 0 0 0 0 22.63l22.54 22.62a15.9 15.9 0 0 0 22.47.07l.07-.07 39.94-40.09a221.26 221.26 0 0 0 266.92 0l39.94 40.09a15.9 15.9 0 0 0 22.47.07l.07-.07 22.53-22.62a16 16 0 0 0 0-22.63zM346 355.51l-20 25a16 16 0 0 1-22.49 2.5L239 331.39a40 40 0 0 1-15-31.23V176a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v112.62L343.5 333a16 16 0 0 1 2.5 22.51z", "M1 96a95.08 95.08 0 0 0 15.24 51.26L161.57 25.68A95 95 0 0 0 96.62 0C43.83 0 1 43 1 96zm342.5 237L288 288.62V176a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v124.16a40 40 0 0 0 15 31.23L303.51 383a16 16 0 0 0 22.49-2.5l20-25a16 16 0 0 0-2.5-22.5zM415.38 0a95.08 95.08 0 0 0-64.93 25.66l145.33 121.57A95.13 95.13 0 0 0 511 96c0-53-42.83-96-95.62-96z"]],
    "alarm-exclamation": [512, 512, [], "f843", ["M434.55 422a223.27 223.27 0 0 0 44.61-134c0-123.71-99.9-224-223.14-224S32.88 164.29 32.88 288a223.27 223.27 0 0 0 44.61 134l-39.95 40.06a16.05 16.05 0 0 0 0 22.63l22.54 22.62a15.89 15.89 0 0 0 22.54 0l39.94-40.09a221.27 221.27 0 0 0 266.92 0l39.94 40.09a15.89 15.89 0 0 0 22.54 0l22.53-22.62a16 16 0 0 0 0-22.63zM256 416a32 32 0 1 1 31.88-32A31.91 31.91 0 0 1 256 416zm38.05-238.4l-12.75 128a15.91 15.91 0 0 1-15.82 14.4h-18.93a15.92 15.92 0 0 1-15.84-14.4L218 177.6a16 16 0 0 1 15.8-17.6h44.42a15.92 15.92 0 0 1 15.84 17.6z", "M1 96a95.11 95.11 0 0 0 15.24 51.26L161.57 25.68A95 95 0 0 0 96.62 0C43.83 0 1 43 1 96zM415.38 0a95.09 95.09 0 0 0-64.93 25.66l145.33 121.57A95.13 95.13 0 0 0 511 96c0-53-42.83-96-95.62-96zM256 352a32 32 0 1 0 31.88 32A31.91 31.91 0 0 0 256 352zm22.21-192H233.8a16 16 0 0 0-15.8 17.6l12.76 128a15.92 15.92 0 0 0 15.79 14.4h18.93a15.91 15.91 0 0 0 15.83-14.4l12.75-128a15.92 15.92 0 0 0-15.84-17.6z"]],
    "alarm-plus": [512, 512, [], "f844", ["M435.25 422A222.7 222.7 0 0 0 480 288c0-123.71-100.3-224-224-224S32 164.29 32 288a222.7 222.7 0 0 0 44.79 134l-40.1 40.09a16 16 0 0 0 0 22.63l22.62 22.62a16 16 0 0 0 22.63 0L122 467.22a222.82 222.82 0 0 0 268 0l40.1 40.09a16 16 0 0 0 22.63 0l22.62-22.62a16 16 0 0 0 0-22.63zM368 296a16 16 0 0 1-16 16h-72v72a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-72h-72a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h72v-72a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v72h72a16 16 0 0 1 16 16z", "M352 264h-72v-72a16 16 0 0 0-16-16h-16a16 16 0 0 0-16 16v72h-72a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h72v72a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16v-72h72a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zM96 0A96 96 0 0 0 0 96a94.81 94.81 0 0 0 15.3 51.26L161.2 25.68A95.61 95.61 0 0 0 96 0zm320 0a95.68 95.68 0 0 0-65.18 25.66l145.9 121.57A94.93 94.93 0 0 0 512 96a96 96 0 0 0-96-96z"]],
    "alarm-snooze": [512, 512, [], "f845", ["M434.55 422a223.27 223.27 0 0 0 44.61-134c0-123.71-99.91-224-223.14-224S32.88 164.29 32.88 288a223.21 223.21 0 0 0 44.61 134l-39.95 40.06a16.05 16.05 0 0 0 0 22.63l22.54 22.62a15.89 15.89 0 0 0 22.54 0l39.94-40.09a221.25 221.25 0 0 0 266.91 0l39.95 40.09a15.89 15.89 0 0 0 22.54 0l22.53-22.62a16 16 0 0 0 0-22.63zM338.4 223L242 344h77.77a16 16 0 0 1 15.93 16v16a16 16 0 0 1-15.93 16H192.23a24 24 0 0 1-18.67-39L270 232h-77.77a16 16 0 0 1-15.94-16v-16a16 16 0 0 1 15.94-16h127.51a24 24 0 0 1 18.66 39z", "M319.74 184H192.23a16 16 0 0 0-15.94 16v16a16 16 0 0 0 15.94 16H270l-96.44 121a24 24 0 0 0 18.67 39h127.51a16 16 0 0 0 15.93-16v-16a16 16 0 0 0-15.93-16H242l96.4-121a24 24 0 0 0-18.66-39zM1 96a95.11 95.11 0 0 0 15.24 51.26L161.57 25.68A95 95 0 0 0 96.62 0C43.83 0 1 43 1 96zM415.38 0a95.09 95.09 0 0 0-64.93 25.66l145.32 121.57A95.14 95.14 0 0 0 511 96c0-53-42.84-96-95.62-96z"]],
    "album": [448, 512, [], "f89f", ["M416 32H32A32 32 0 0 0 0 64v384a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32V64a32 32 0 0 0-32-32zM224 416a160 160 0 1 1 160-160 160 160 0 0 1-160 160z", "M224 96a160 160 0 1 0 160 160A160 160 0 0 0 224 96zm0 192a32 32 0 1 1 32-32 32 32 0 0 1-32 32z"]],
    "album-collection": [512, 512, [], "f8a0", ["M480 160H32A32 32 0 0 0 .13 194.9l26.19 288A32 32 0 0 0 58.18 512h395.64a32 32 0 0 0 31.86-29.1l26.19-288A32 32 0 0 0 480 160zM256 472.89c-94.26 0-174.39-54.53-179.2-125.15C71.71 273.1 151.82 209.4 256 209.4s184.29 63.7 179.2 138.34c-4.81 70.63-84.93 125.15-179.2 125.15z", "M480 24a24 24 0 0 0-24-24H56a24 24 0 0 0-24 24v24h448zm-8 56H40a24 24 0 0 0-24 24v24h480v-24a24 24 0 0 0-24-24zM256 209.4c-104.18 0-184.29 63.7-179.19 138.34 4.81 70.62 84.94 125.15 179.2 125.15s174.38-54.52 179.19-125.15C440.29 273.1 360.18 209.4 256 209.4zm0 160.06c-16.36 0-29.73-9.68-29.86-21.72s13.23-22.09 29.86-22.09 30 9.93 29.87 22.09-13.51 21.72-29.87 21.72z"]],
    "alicorn": [640, 512, [], "f6b0", ["M64.36 215.74A39.94 39.94 0 0 0 48 248v56a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-56a88 88 0 0 1 88-88h.45a95.57 95.57 0 0 0-24.09 55.74zM632 32H531.93a52.6 52.6 0 0 1-10.28 8.3c5.11 5.38 9.91 10.47 13.69 14.5a31.76 31.76 0 0 1 8.58 21.8v6.74l92.49-36.69A8 8 0 0 0 632 32z", "M535.34 54.8c-3.78-4-8.58-9.12-13.69-14.5 11.06-6.84 19.5-17.49 22.18-30.66A8.09 8.09 0 0 0 535.9 0h-120C346.67 0 288 64 288 128h-.08c-63.92 0-104.2-36.78-127.66-90.27-3.22-7.35-13.61-7.76-17-.5A158.37 158.37 0 0 0 128 105.1c0 67 51 136.25 128 150.9-96.87 0-138.75-73.3-153.39-109a96 96 0 0 0-8.16 147.09l-25.63 68.39a63.94 63.94 0 0 0-2.16 38l24.85 99.41A16 16 0 0 0 107 512h66a16 16 0 0 0 15.52-19.88l-26.33-105.26L186 323.27l102 22.31V496a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16V318.22A111.55 111.55 0 0 0 416 240c0-.22-.07-.42-.08-.64V136.89l16 7.11 18.9 37.7a32 32 0 0 0 40.49 15.37l32.55-13A32 32 0 0 0 544 154.31l-.06-77.71a31.76 31.76 0 0 0-8.6-21.8zM479.92 96a16 16 0 1 1 16-16 16 16 0 0 1-16 16z"]],
    "align-center": [448, 512, [], "f037", ["M108.1 96h231.81A12.09 12.09 0 0 0 352 83.9V44.09A12.09 12.09 0 0 0 339.91 32H108.1A12.09 12.09 0 0 0 96 44.09V83.9A12.1 12.1 0 0 0 108.1 96zm231.81 256A12.09 12.09 0 0 0 352 339.9v-39.81A12.09 12.09 0 0 0 339.91 288H108.1A12.09 12.09 0 0 0 96 300.09v39.81a12.1 12.1 0 0 0 12.1 12.1z", "M432 160H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0 256H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "align-justify": [448, 512, [], "f039", ["M432 416H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-256H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M432 288H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-256H16A16 16 0 0 0 0 48v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z"]],
    "align-left": [448, 512, [], "f036", ["M12.83 352h262.34A12.82 12.82 0 0 0 288 339.17v-38.34A12.82 12.82 0 0 0 275.17 288H12.83A12.82 12.82 0 0 0 0 300.83v38.34A12.82 12.82 0 0 0 12.83 352zm0-256h262.34A12.82 12.82 0 0 0 288 83.17V44.83A12.82 12.82 0 0 0 275.17 32H12.83A12.82 12.82 0 0 0 0 44.83v38.34A12.82 12.82 0 0 0 12.83 96z", "M432 160H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0 256H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "align-right": [448, 512, [], "f038", ["M435.17 32H172.83A12.82 12.82 0 0 0 160 44.83v38.34A12.82 12.82 0 0 0 172.83 96h262.34A12.82 12.82 0 0 0 448 83.17V44.83A12.82 12.82 0 0 0 435.17 32zm0 256H172.83A12.82 12.82 0 0 0 160 300.83v38.34A12.82 12.82 0 0 0 172.83 352h262.34A12.82 12.82 0 0 0 448 339.17v-38.34A12.82 12.82 0 0 0 435.17 288z", "M16 224h416a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm416 192H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "align-slash": [640, 512, [], "f846", ["M528 352h-31.46l-82.81-64H528a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16zM96 304v32a16 16 0 0 0 16 16h175.21l-82.8-64H112a16 16 0 0 0-16 16zM528 96a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16H112a15.82 15.82 0 0 0-15 11.18L165.31 96zM112 416a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h340.83L370 416zm416-256H248.12l82.81 64H528a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M633.82 458.1L45.46 3.38A16 16 0 0 0 23 6.19L3.37 31.46a16 16 0 0 0 2.81 22.45l588.36 454.72a16 16 0 0 0 22.46-2.81l19.64-25.27a16 16 0 0 0-2.82-22.45z"]],
    "allergies": [448, 512, [], "f461", ["M416 112a32.09 32.09 0 0 0-32 32v72a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8V64a32 32 0 0 0-64 0v152a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8V32a32 32 0 0 0-64 0v184a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8V64a32 32 0 1 0-64 0v241l-23.6-32.49a40 40 0 0 0-64.73 47.03L133.28 492.2a48.08 48.08 0 0 0 38.8 19.8H369.7a47.93 47.93 0 0 0 46.7-37l26.5-112.68A201.29 201.29 0 0 0 448 320V144a32.09 32.09 0 0 0-32-32zM176 288a16 16 0 1 1-16 16 16 16 0 0 1 16-16zm0 127.92a16 16 0 1 1 16-16 16 16 0 0 1-16 16zM240 448a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm0-96.07a16 16 0 1 1 16-16 16 16 0 0 1-16 16zM304 384a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm32 63.91a16 16 0 1 1 16-16 16 16 0 0 1-16 16zM368 320a16 16 0 1 1 16-16 16 16 0 0 1-16 16z", "M176 288a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm64 128a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm64-64a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm64-64a16 16 0 1 0 16 16 16 16 0 0 0-16-16z"]],
    "ambulance": [640, 512, [], "f0f9", ["M464 352a80 80 0 1 0 80 80 80 80 0 0 0-80-80zm-288 0a80 80 0 1 0 80 80 80 80 0 0 0-80-80zm120-224h-56V72a8 8 0 0 0-8-8h-48a8 8 0 0 0-8 8v56h-56a8 8 0 0 0-8 8v48a8 8 0 0 0 8 8h56v56a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8v-56h56a8 8 0 0 0 8-8v-48a8 8 0 0 0-8-8z", "M624 352h-16V243.9a48 48 0 0 0-14.1-33.9L494 110.1A48 48 0 0 0 460.1 96H416V48a48 48 0 0 0-48-48H48A48 48 0 0 0 0 48v320a48 48 0 0 0 48 48h18.16C74 361.93 119.78 320 176 320s102.54 41.86 110.38 96h67.24c7.85-54.14 54.1-96 110.38-96s102 41.93 109.84 96H624a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM304 184a8 8 0 0 1-8 8h-56v56a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-56h-56a8 8 0 0 1-8-8v-48a8 8 0 0 1 8-8h56V72a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8v56h56a8 8 0 0 1 8 8zm256 72H416V144h44.1l99.9 99.9z"]],
    "american-sign-language-interpreting": [640, 512, [], "f2a3", ["M638.14 227.07l-44.46-89.31a17.72 17.72 0 0 0-23.89-7.76l-66.41 33.49-92.8-8.66c-37.93 0-67.93 21.55-82 51.07-8.6 18 5.18 38.24 23.61 38.24-18.47 0-32.19 20.26-23.61 38.23 14.37 30.23 43 50.79 85.57 50.79a83.33 83.33 0 0 1-64.74-3.9 26.81 26.81 0 0 0-23.34 48.28c29.37 14.31 62 16.9 88.08 11.16A112.86 112.86 0 0 1 370 404a26.35 26.35 0 0 0-23 29.86c2.18 17.49 19.71 25.68 29.73 23.16a166.69 166.69 0 0 0 74.19-28.19 179.23 179.23 0 0 1-32.51 35.73 26.72 26.72 0 0 0 33.9 41.3A222.5 222.5 0 0 0 532 358.51L573.12 284l58.07-33.21a18.27 18.27 0 0 0 6.95-23.72zm-229.23 52.74a35.57 35.57 0 0 1-32.23-20.37 26.52 26.52 0 0 0-23.34-15.35 26.52 26.52 0 0 0 23.34-15.35 35.57 35.57 0 0 1 32.23-20.37c17.76 0 35.57 14.2 35.57 35.72v.22a35.54 35.54 0 0 1-35.57 35.5z", "M313.89 134.53c-29.37-14.31-62-16.9-88.08-11.16A112.54 112.54 0 0 1 270 108a26.72 26.72 0 0 0-6.67-53 166.79 166.79 0 0 0-74.19 28.18 179.46 179.46 0 0 1 32.51-35.72 26.73 26.73 0 0 0 3.61-37.67 26.44 26.44 0 0 0-37.51-3.63A222.47 222.47 0 0 0 108 153.5L66.88 228 8.81 261.22a18.27 18.27 0 0 0-6.95 23.72l44.46 89.3a17.72 17.72 0 0 0 23.89 7.81l66.41-33.48s93.91 8.65 94.47 8.65a89.4 89.4 0 0 0 80.3-51.07c8.59-18-5.19-38.23-23.62-38.23 18.47 0 32.19-20.26 23.62-38.23-14.37-30.23-43-50.79-85.58-50.79a83.29 83.29 0 0 1 64.74 3.91 26.81 26.81 0 0 0 23.34-48.28zm-82.8 97.67a35.57 35.57 0 0 1 32.23 20.37 26.52 26.52 0 0 0 23.34 15.35 26.52 26.52 0 0 0-23.34 15.35 35.59 35.59 0 0 1-32.23 20.37c-17.76 0-35.57-14.2-35.57-35.72v-.22a35.54 35.54 0 0 1 35.57-35.5z"]],
    "amp-guitar": [512, 512, [], "f8a1", ["M321 403a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm-64-128a16 16 0 0 0 16-16h-32a16 16 0 0 0 16 16zm-32 96a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm32-64a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm0 96a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm32-32a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm64 0a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm32 32a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm-64-128a16 16 0 0 0 16-16h-32a16 16 0 0 0 16 16zm0 32a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm32 0a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm-64 0a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm-160 0a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm-32 32a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm288-32a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm-256 96a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm288-96a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm-224-32a16 16 0 0 0 16-16h-32a16 16 0 0 0 16 16zm-32 32a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm64 0a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm-32 0a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm0 96a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm-32-32a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm-32-96a16 16 0 0 0 16-16h-32a16 16 0 0 0 16 16zm224 128a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm-32 32a16 16 0 0 0-16 16h32a16 16 0 0 0-16-16zm-64 0a16 16 0 0 0-16 16h32a16 16 0 0 0-16-16zm32-32a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm96 32a16 16 0 0 0-16 16h32a16 16 0 0 0-16-16zm32-32a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm16-144a16 16 0 0 0 16 16v-16zM225 403a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm208-80a16 16 0 0 0 16 16v-32a16 16 0 0 0-16 16zm0 64a16 16 0 0 0 16 16v-32a16 16 0 0 0-16 16zm-48-112a16 16 0 0 0 16-16h-32a16 16 0 0 0 16 16zm48 176h16v-16a16 16 0 0 0-16 16zM81 259H65v16a16 16 0 0 0 16-16zm0 64a16 16 0 0 0-16-16v32a16 16 0 0 0 16-16zm336 48a16 16 0 1 0-16-16 16 16 0 0 0 16 16zM97 307a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm-16 80a16 16 0 0 0-16-16v32a16 16 0 0 0 16-16zm48 48a16 16 0 0 0-16 16h32a16 16 0 0 0-16-16zm-64 0v16h16a16 16 0 0 0-16-16zm128 0a16 16 0 0 0-16 16h32a16 16 0 0 0-16-16zm-32-32a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm-64 0a16 16 0 1 0 16 16 16 16 0 0 0-16-16zM257 51c26.89 0 54 14.79 76.25 32h70.25C378.75 55.71 322.51 3 257 3S135.25 55.71 110.5 83h70.25C203 65.79 230.12 51 257 51z", "M465 83H49a48 48 0 0 0-48 48v336a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V131a48 48 0 0 0-48-48zm-120 64a24 24 0 1 1-24 24 24 24 0 0 1 24-24zm-176 0a24 24 0 1 1-24 24 24 24 0 0 1 24-24zm-80 0a24 24 0 1 1-24 24 24 24 0 0 1 24-24zm360 304H65V259h384zm-24-256a24 24 0 1 1 24-24 24 24 0 0 1-24 24z"]],
    "analytics": [576, 512, [], "f643", ["M510.62 92.63l-95.32 76.28a48.66 48.66 0 0 1 .7 7.09 48 48 0 0 1-96 0 47.44 47.44 0 0 1 .71-7.1l-95.33-76.27a45.11 45.11 0 0 1-29.66 1.59l-101.5 101.5A47.9 47.9 0 1 1 48 160a47.87 47.87 0 0 1 12.28 1.78l101.5-101.5A47.87 47.87 0 0 1 160 48a48 48 0 0 1 96 0 47.44 47.44 0 0 1-.71 7.1l95.32 76.26a46.5 46.5 0 0 1 34.76 0l95.34-76.27A48.66 48.66 0 0 1 480 48a48.36 48.36 0 1 1 30.62 44.63z", "M400 320h-64a16 16 0 0 0-16 16v160a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16V336a16 16 0 0 0-16-16zm160-128h-64a16 16 0 0 0-16 16v288a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16V208a16 16 0 0 0-16-16zm-320 0h-64a16 16 0 0 0-16 16v288a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16V208a16 16 0 0 0-16-16zM80 352H16a16 16 0 0 0-16 16v128a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16V368a16 16 0 0 0-16-16z"]],
    "anchor": [576, 512, [], "f13d", ["M372 192h-52v-5.47A96 96 0 0 0 384 96c0-52.22-42.36-95.25-94.58-96A96 96 0 0 0 256 186.54V192h-52a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h168a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zM288 64a32 32 0 1 1-32 32 32 32 0 0 1 32-32z", "M564 352h-32.51C509.63 454.62 394.61 512 288 512c-106.41 0-221.58-57.27-243.46-160H12a12 12 0 0 1-8.51-20.49l67.26-67a12.07 12.07 0 0 1 17 0l67.26 67a12 12 0 0 1-8.46 20.49h-35.26c20.37 54.34 85.47 86.62 144.61 94V288h64.22v158c59.36-7.43 124.26-39.7 144.62-94h-35.26a12 12 0 0 1-8.48-20.49l67.26-67a12.07 12.07 0 0 1 17 0l67.26 67A12 12 0 0 1 564 352z"]],
    "angel": [576, 512, [], "f779", ["M384 64c0 2.3-3.3 6.1-9.1 10.3a117.38 117.38 0 0 1 16.6 27.1C406.74 90.9 416 78 416 64c0-35.3-57.3-64-128-64S160 28.7 160 64c0 14 9.3 26.9 24.5 37.4a108.79 108.79 0 0 1 16.6-27.1c-5.8-4.1-9.1-7.9-9.1-10.3 0-8 34-32 96-32s96 24 96 32zm187.77 389.1l-38.17-78.6a49.38 49.38 0 0 1 0-43.1c4.79-9.8 8.69-16.7 11.89-22.1C555 292.7 560 282.8 560 256c0-51.1-46.87-96-100.35-96a93 93 0 0 0-66.26 28.1l-72.54 73.27a103.63 103.63 0 0 1 60 52.13L480 512h55.6a40.29 40.29 0 0 0 34.18-19 41.12 41.12 0 0 0 1.99-39.9zM116.34 160C62.86 160 16 204.9 16 256c0 26.8 5 36.7 14.52 53.3 3.2 5.4 7.1 12.3 11.89 22.1a49.38 49.38 0 0 1 0 43.1L4.23 453.1a41.12 41.12 0 0 0 2 39.9 40.29 40.29 0 0 0 34.17 19H96l99.22-198.5a103.63 103.63 0 0 1 60-52.13L182.6 188.1a93 93 0 0 0-66.26-28.1z", "M288 224a80 80 0 1 0-80-80 80 80 0 0 0 80 80zm93.4 89.54a104.58 104.58 0 0 0-186.8 0L96 512h384z"]],
    "angle-double-down": [320, 512, [], "f103", ["M143 256L7.05 120.37a23.78 23.78 0 0 1 0-33.8L29.64 64a23.94 23.94 0 0 1 33.89 0l96.37 96.13L256.27 64a23.94 23.94 0 0 1 33.89 0L313 86.47a23.78 23.78 0 0 1 0 33.8L177 255.88a23.94 23.94 0 0 1-34 .1z", "M143 447.89L7.05 312.34a23.77 23.77 0 0 1 0-33.79L29.74 256a23.94 23.94 0 0 1 33.89 0L160 352.11l96.47-96a23.94 23.94 0 0 1 33.89 0L313 278.65a23.77 23.77 0 0 1 0 33.79L177 448a24 24 0 0 1-34-.11z"]],
    "angle-double-left": [448, 512, [], "f100", ["M224 239l135.61-136a23.78 23.78 0 0 1 33.8 0L416 125.64a23.94 23.94 0 0 1 0 33.89l-96.16 96.37L416 352.27a23.94 23.94 0 0 1 0 33.89L393.53 409a23.78 23.78 0 0 1-33.8 0L224.12 273a23.94 23.94 0 0 1-.1-34z", "M32.11 239l135.55-136a23.77 23.77 0 0 1 33.79 0L224 125.74a23.94 23.94 0 0 1 0 33.89L127.89 256l96 96.47a23.94 23.94 0 0 1 0 33.89L201.35 409a23.77 23.77 0 0 1-33.79 0L32 273a24 24 0 0 1 .11-34z"]],
    "angle-double-right": [448, 512, [], "f101", ["M224 273L88.37 409a23.78 23.78 0 0 1-33.8 0L32 386.36a23.94 23.94 0 0 1 0-33.89l96.13-96.37L32 159.73a23.94 23.94 0 0 1 0-33.89l22.44-22.79a23.78 23.78 0 0 1 33.8 0L223.88 239a23.94 23.94 0 0 1 .1 34z", "M415.89 273L280.34 409a23.77 23.77 0 0 1-33.79 0L224 386.26a23.94 23.94 0 0 1 0-33.89L320.11 256l-96-96.47a23.94 23.94 0 0 1 0-33.89l22.52-22.59a23.77 23.77 0 0 1 33.79 0L416 239a24 24 0 0 1-.11 34z"]],
    "angle-double-up": [320, 512, [], "f102", ["M177 256l136 135.63a23.78 23.78 0 0 1 0 33.8L290.36 448a23.94 23.94 0 0 1-33.89 0l-96.37-96.16L63.73 448a23.94 23.94 0 0 1-33.89 0L7.05 425.53a23.78 23.78 0 0 1 0-33.8L143 256.12a23.94 23.94 0 0 1 34-.1z", "M177 64.11l136 135.55a23.77 23.77 0 0 1 0 33.79L290.26 256a23.94 23.94 0 0 1-33.89 0L160 159.89l-96.47 96a23.94 23.94 0 0 1-33.89 0L7.05 233.35a23.77 23.77 0 0 1 0-33.79L143 64a24 24 0 0 1 34 .11z"]],
    "angle-down": [320, 512, [], "f107", ["M160 256.14l-56.51 56.47-96.44-96.15a23.77 23.77 0 0 1-.18-33.61l.18-.18 22.59-22.51a23.94 23.94 0 0 1 33.85 0z", "M313 182.57L290.21 160a23.94 23.94 0 0 0-33.85 0L103.47 312.61 143 352l.06.06a24 24 0 0 0 33.93-.16L313 216.36l.18-.17a23.78 23.78 0 0 0-.18-33.62z"]],
    "angle-left": [256, 512, [], "f104", ["M223.83 352.44a24 24 0 0 1 0 33.86L201.32 409l-.18.18a23.76 23.76 0 0 1-33.6-.18l-96.15-96.5 56.47-56.5z", "M167.81 102.87l-.17.18L32.11 239a24 24 0 0 0-.17 33.93l.06.07 39.39 39.51L224 159.66a23.92 23.92 0 0 0 0-33.84l-22.54-22.74a23.77 23.77 0 0 0-33.62-.23z"]],
    "angle-right": [256, 512, [], "f105", ["M128.14 256l56.47 56.49L88.46 409a23.76 23.76 0 0 1-33.6.18l-.18-.18-22.51-22.68a23.92 23.92 0 0 1 0-33.84z", "M54.58 103.07L32 125.81a23.92 23.92 0 0 0 0 33.84L184.61 312.5 224 273l.06-.06a24 24 0 0 0-.16-33.94L88.37 103l-.17-.18a23.78 23.78 0 0 0-33.62.22z"]],
    "angle-up": [320, 512, [], "f106", ["M63.52 351.84a23.94 23.94 0 0 1-33.85 0L7.05 329.33l-.18-.18a23.77 23.77 0 0 1 .18-33.61l96.42-96.15L160 255.86z", "M313.13 295.81l-.18-.17L177 160.11a24 24 0 0 0-34-.11l-39.51 39.39L256.33 352a23.94 23.94 0 0 0 33.85 0L313 329.43a23.78 23.78 0 0 0 .13-33.62z"]],
    "angry": [496, 512, [], "f556", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8ZM136,240a31.87,31.87,0,0,1,10.22-23.43l-30.82-9.24a16,16,0,0,1,9.2-30.66l80,24A16,16,0,0,1,200,232h-1a32,32,0,1,1-63,8ZM304.32,394.05c-27.93-33.26-84.59-33.26-112.62,0-13.57,16.23-38.38-4.18-24.72-20.41a105.93,105.93,0,0,1,162,0C342.81,390.07,317.79,410.09,304.32,394.05ZM381.6,207.33,350,216.8A32,32,0,1,1,297,232a16,16,0,0,1-4.61-31.32l80-24a16,16,0,1,1,9.2,30.65h0Z", "M204.6,200.67l-80-24a16,16,0,0,0-9.2,30.66h0l30.82,9.24A32,32,0,1,0,199,232h1a16,16,0,0,0,4.59-31.33ZM392.33,187.4a16,16,0,0,0-19.93-10.72h0l-80,24A16,16,0,0,0,297,232a32,32,0,1,0,53-15.2l31.58-9.47a16,16,0,0,0,10.76-19.9h0Z"]],
    "ankh": [320, 512, [], "f644", ["M296 256H24a24 24 0 0 0-24 24v32a24 24 0 0 0 24 24h272a24 24 0 0 0 24-24v-32a24 24 0 0 0-24-24z", "M120 488a24 24 0 0 0 24 24h32a24 24 0 0 0 24-24V336h-80zM160 0C89.31 0 32 55.63 32 144c0 37.65 15.54 78 36.62 112h182.76C272.46 222 288 181.65 288 144 288 55.63 230.69 0 160 0zm0 244.87c-20.86-22.72-48-66.21-48-100.87 0-39.48 18.39-64 48-64s48 24.52 48 64c0 34.66-27.14 78.14-48 100.87z"]],
    "apple-alt": [448, 512, [], "f5d1", ["M295.92 88q-14 13-37 19a116.69 116.69 0 0 1-35 5l-15-1a128.32 128.32 0 0 1 0-32q4-36 23-55 14-13 37-19a116.69 116.69 0 0 1 35-5l15 1 1 15a117.29 117.29 0 0 1-5 35q-6 23-19 37z", "M350.86 129q39 7 63.92 42 22 31 30 78a248.7 248.7 0 0 1-1 86q-12 71-47.94 119-43 58-107.87 58-16 0-35-10a56.45 56.45 0 0 0-57.97 0q-19 10-35 10-64.85 0-107.8-58-36-48-47.94-119a248.7 248.7 0 0 1-1-86q8-47 30-78 25-35 63.92-42 24-4 65.92 7 36 10 60.93 24 25-14 60.93-24 41.93-11 65.9-7z"]],
    "apple-crate": [512, 512, [], "f6b1", ["M424.17 80.61c-18.13-3-51.9 6.18-72.49 17.69-17-9.52-42.45-17-61.15-17.79 1.82 2.21 3.83 4.17 5.5 6.58 20.84 30.15 25.74 72.3 22.17 104.91H478c5.25-39.47-5.16-102.65-53.83-111.39zM210.53 50.47C221.82 38.28 225 18.44 223.75.25c-12.88-.86-35.67-.12-50 13.28-16.55 16.6-13.75 46.36-13.24 50.22C179 65 198.28 61.9 210.53 50.47zm191.69 0c11.29-12.19 14.43-32 13.22-50.22-12.88-.86-35.67-.12-50 13.28-16.53 16.6-13.77 46.36-13.22 50.22 18.45 1.25 37.78-1.85 50-13.28zM232.48 80.61c-18.13-3-51.9 6.18-72.48 17.69-20.66-11.56-54.43-20.71-72.48-17.69C38.91 89.34 28.53 152.88 33.7 192h252.6c5.26-39.47-5.15-102.65-53.82-111.39z", "M496 224H16a16 16 0 0 0-16 16v112h512V240a16 16 0 0 0-16-16zM64 304a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm384 0a16 16 0 1 1 16-16 16 16 0 0 1-16 16zM0 496a16 16 0 0 0 16 16h480a16 16 0 0 0 16-16V384H0zm448-64a16 16 0 1 1-16 16 16 16 0 0 1 16-16zm-384 0a16 16 0 1 1-16 16 16 16 0 0 1 16-16z"]],
    "archive": [512, 512, [], "f187", ["M32 160v288a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32V160zm288 84a12 12 0 0 1-12 12H204a12 12 0 0 1-12-12v-8a12 12 0 0 1 12-12h104a12 12 0 0 1 12 12z", "M512 64v48a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16V64a32 32 0 0 1 32-32h448a32 32 0 0 1 32 32z"]],
    "archway": [576, 512, [], "f557", ["M576 16v32a16 16 0 0 1-16 16H16A16 16 0 0 1 0 48V16A16 16 0 0 1 16 0h544a16 16 0 0 1 16 16z", "M576 464v32a16 16 0 0 1-16 16H400a16 16 0 0 1-16-16V320a96 96 0 0 0-192 0v176a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h16V96h512v352h16a16 16 0 0 1 16 16z"]],
    "arrow-alt-circle-down": [512, 512, [], "f358", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm124.41 268.32L264.52 390.48a12.08 12.08 0 0 1-17 0L131.59 276.32c-7.67-7.49-2.22-20.48 8.57-20.48h71.51V140a12.08 12.08 0 0 1 12.1-12h64.56a12.08 12.08 0 0 1 12.1 12v115.84h71.41c10.79 0 16.24 12.89 8.57 20.48z", "M223.77 128h64.56a12.08 12.08 0 0 1 12.1 12v115.84h71.41c10.79 0 16.24 12.89 8.57 20.48L264.52 390.48a12.08 12.08 0 0 1-17 0L131.59 276.32c-7.67-7.49-2.22-20.48 8.57-20.48h71.51V140a12.08 12.08 0 0 1 12.1-12z"]],
    "arrow-alt-circle-left": [512, 512, [], "f359", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm128 280.33a12.08 12.08 0 0 1-12 12.1H256.16v71.41c0 10.79-12.89 16.24-20.48 8.57L121.52 264.52a12.08 12.08 0 0 1 0-17l114.16-115.93c7.49-7.67 20.48-2.22 20.48 8.57v71.51H372a12.08 12.08 0 0 1 12 12.1z", "M384 223.77v64.56a12.08 12.08 0 0 1-12 12.1H256.16v71.41c0 10.79-12.89 16.24-20.48 8.57L121.52 264.52a12.08 12.08 0 0 1 0-17l114.16-115.93c7.49-7.67 20.48-2.22 20.48 8.57v71.51H372a12.08 12.08 0 0 1 12 12.1z"]],
    "arrow-alt-circle-right": [512, 512, [], "f35a", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm134.48 256.52L276.32 380.41c-7.49 7.67-20.48 2.22-20.48-8.57v-71.51H140a12.08 12.08 0 0 1-12-12.1v-64.56a12.08 12.08 0 0 1 12-12.1h115.84v-71.41c0-10.79 12.89-16.24 20.48-8.57l114.16 115.89a12.08 12.08 0 0 1 0 17.04z", "M128 288.23v-64.56a12.08 12.08 0 0 1 12-12.1h115.84v-71.41c0-10.79 12.89-16.24 20.48-8.57l114.16 115.89a12.08 12.08 0 0 1 0 17L276.32 380.41c-7.49 7.67-20.48 2.22-20.48-8.57v-71.51H140a12.08 12.08 0 0 1-12-12.1z"]],
    "arrow-alt-circle-up": [512, 512, [], "f35b", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm115.84 248.16h-71.51V372a12.08 12.08 0 0 1-12.1 12h-64.56a12.08 12.08 0 0 1-12.1-12V256.16h-71.41c-10.79 0-16.24-12.89-8.57-20.48l115.89-114.16a12.08 12.08 0 0 1 17 0l115.93 114.16c7.67 7.49 2.22 20.48-8.57 20.48z", "M288.23 384h-64.56a12.08 12.08 0 0 1-12.1-12V256.16h-71.41c-10.79 0-16.24-12.89-8.57-20.48l115.89-114.16a12.08 12.08 0 0 1 17 0l115.93 114.16c7.67 7.49 2.22 20.48-8.57 20.48h-71.51V372a12.08 12.08 0 0 1-12.1 12z"]],
    "arrow-alt-down": [448, 512, [], "f354", ["M288,56V256H159.88V56a24,24,0,0,1,24-24H264A24,24,0,0,1,288,56Z", "M408.93,297,241,473a24.09,24.09,0,0,1-34,0L39.07,297c-15.11-15.09-4.4-41,17-41H391.93C413.35,256,424,281.76,408.93,297Z"]],
    "arrow-alt-from-bottom": [384, 512, [], "f346", ["M360 480H24a24 24 0 0 1-24-24v-16a24 24 0 0 1 24-24h336a24 24 0 0 1 24 24v16a24 24 0 0 1-24 24z", "M232 384h-80a23.94 23.94 0 0 1-24-24V224H40.3c-17.8 0-26.8-21.51-14.2-34.11L178.4 37.63a19.36 19.36 0 0 1 27.3 0l152.1 152.23c12.6 12.6 3.7 34.11-14.1 34.11H256V360a23.94 23.94 0 0 1-24 24z"]],
    "arrow-alt-from-left": [448, 512, [], "f347", ["M0 424V88a23.94 23.94 0 0 1 24-24h16a23.94 23.94 0 0 1 24 24v336a23.94 23.94 0 0 1-24 24H24a23.94 23.94 0 0 1-24-24z", "M96 296v-80a23.94 23.94 0 0 1 24-24h136v-87.8c0-17.8 21.51-26.7 34.11-14.1l152.26 152.2a19.36 19.36 0 0 1 0 27.3L290.14 421.8c-12.6 12.6-34.11 3.7-34.11-14.1V320H120a23.94 23.94 0 0 1-24-24z"]],
    "arrow-alt-from-right": [448, 512, [], "f348", ["M448 88v336a23.94 23.94 0 0 1-24 24h-16a23.94 23.94 0 0 1-24-24V88a23.94 23.94 0 0 1 24-24h16a23.94 23.94 0 0 1 24 24z", "M352 215.89V296a24 24 0 0 1-24 24H192v88c0 17.82-21.51 26.73-34.11 14.12L5.63 269.67a19.4 19.4 0 0 1 0-27.34L157.86 89.91C170.46 77.3 192 86.21 192 104v87.83h136a24 24 0 0 1 24 24.06z"]],
    "arrow-alt-from-top": [384, 512, [], "f349", ["M384 56v16a23.94 23.94 0 0 1-24 24H24A23.94 23.94 0 0 1 0 72V56a23.94 23.94 0 0 1 24-24h336a23.94 23.94 0 0 1 24 24z", "M151.89 128H232a24 24 0 0 1 24 24v136h88c17.82 0 26.73 21.51 14.12 34.11L205.67 474.37a19.4 19.4 0 0 1-27.34 0L25.91 322.14C13.3 309.54 22.21 288 40 288h87.83V152a24 24 0 0 1 24.06-24z"]],
    "arrow-alt-left": [448, 512, [], "f355", ["M424 320H224V191.89h200a24 24 0 0 1 24 24V296a24 24 0 0 1-24 24z", "M183 440.92L7 273a24.06 24.06 0 0 1 0-34L183 71.09c15.1-15.11 41-4.4 41 17v335.83c0 21.42-25.76 32.13-41 17z"]],
    "arrow-alt-right": [448, 512, [], "f356", ["M24 192h200v128.14H24a24 24 0 0 1-24-24V216a24 24 0 0 1 24-24z", "M265 71.11L441 239a24.08 24.08 0 0 1 0 34L265 440.94c-15.1 15.11-41 4.4-41-17V88.11c0-21.42 25.75-32.11 41-17z"]],
    "arrow-alt-square-down": [448, 512, [], "f350", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-51.58 244.32l-116 115.16a12.08 12.08 0 0 1-17 0L99.58 276.32c-7.66-7.49-2.21-20.32 8.57-20.32h71.49V140a12.07 12.07 0 0 1 12.1-12h64.52a12.07 12.07 0 0 1 12.1 12v116h71.49c10.78 0 16.23 12.83 8.57 20.32z", "M191.74 128h64.52a12.07 12.07 0 0 1 12.1 12v116h71.49c10.78 0 16.23 12.83 8.57 20.32l-116 115.16a12.08 12.08 0 0 1-17 0L99.58 276.32c-7.66-7.49-2.21-20.32 8.57-20.32h71.49V140a12.07 12.07 0 0 1 12.1-12z"]],
    "arrow-alt-square-left": [448, 512, [], "f351", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-48 256.26a12.07 12.07 0 0 1-12 12.1H224v71.49c0 10.78-12.83 16.23-20.32 8.57L88.52 264.47a12.08 12.08 0 0 1 0-17l115.16-115.89c7.49-7.66 20.32-2.21 20.32 8.57v71.49h116a12.07 12.07 0 0 1 12 12.1z", "M352 223.74v64.52a12.07 12.07 0 0 1-12 12.1H224v71.49c0 10.78-12.83 16.23-20.32 8.57L88.52 264.47a12.08 12.08 0 0 1 0-17l115.16-115.89c7.49-7.66 20.32-2.21 20.32 8.57v71.49h116a12.07 12.07 0 0 1 12 12.1z"]],
    "arrow-alt-square-right": [448, 512, [], "f352", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-40.52 232.57L244.32 380.42c-7.49 7.66-20.32 2.21-20.32-8.57v-71.49H108a12.07 12.07 0 0 1-12-12.1v-64.52a12.07 12.07 0 0 1 12-12.1h116v-71.49c0-10.78 12.83-16.23 20.32-8.57l115.16 116a12.08 12.08 0 0 1 0 16.99z", "M96 288.26v-64.52a12.07 12.07 0 0 1 12-12.1h116v-71.49c0-10.78 12.83-16.23 20.32-8.57l115.16 116a12.08 12.08 0 0 1 0 17L244.32 380.42c-7.49 7.66-20.32 2.21-20.32-8.57v-71.49H108a12.07 12.07 0 0 1-12-12.1z"]],
    "arrow-alt-square-up": [448, 512, [], "f353", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-60.15 224h-71.49v116a12.07 12.07 0 0 1-12.1 12h-64.52a12.07 12.07 0 0 1-12.1-12V256h-71.49c-10.78 0-16.23-12.83-8.57-20.32l116-115.16a12.08 12.08 0 0 1 17 0l115.84 115.16c7.66 7.49 2.21 20.32-8.57 20.32z", "M256.26 384h-64.52a12.07 12.07 0 0 1-12.1-12V256h-71.49c-10.78 0-16.23-12.83-8.57-20.32l116-115.16a12.08 12.08 0 0 1 17 0l115.84 115.16c7.66 7.49 2.21 20.32-8.57 20.32h-71.49v116a12.07 12.07 0 0 1-12.1 12z"]],
    "arrow-alt-to-bottom": [384, 512, [], "f34a", ["M360 480H24a24 24 0 0 1-24-24v-16a24 24 0 0 1 24-24h336a24 24 0 0 1 24 24v16a24 24 0 0 1-24 24z", "M151.92 32h80a23.94 23.94 0 0 1 24 24v136h87.7c17.8 0 26.8 21.51 14.2 34.11l-152.3 152.26a19.36 19.36 0 0 1-27.3 0L26.12 226.14c-12.6-12.6-3.7-34.11 14.1-34.11h87.7V56a23.94 23.94 0 0 1 24-24z"]],
    "arrow-alt-to-left": [448, 512, [], "f34b", ["M0 424V88a23.94 23.94 0 0 1 24-24h16a23.94 23.94 0 0 1 24 24v336a23.94 23.94 0 0 1-24 24H24a23.94 23.94 0 0 1-24-24z", "M448 215.9v80a23.94 23.94 0 0 1-24 24H288v87.8c0 17.8-21.51 26.7-34.11 14.1L101.63 269.6a19.36 19.36 0 0 1 0-27.3L253.86 90.1c12.6-12.6 34.14-3.7 34.14 14.1v87.7h136a23.94 23.94 0 0 1 24 24z"]],
    "arrow-alt-to-right": [448, 512, [], "f34c", ["M448 88v336a23.94 23.94 0 0 1-24 24h-16a23.94 23.94 0 0 1-24-24V88a23.94 23.94 0 0 1 24-24h16a23.94 23.94 0 0 1 24 24z", "M0 296.11V216a24 24 0 0 1 24-24h136v-88c0-17.82 21.51-26.73 34.11-14.12l152.26 152.45a19.4 19.4 0 0 1 0 27.34L194.14 422.09C181.54 434.7 160 425.79 160 408v-87.86H24a24 24 0 0 1-24-24.03z"]],
    "arrow-alt-to-top": [384, 512, [], "f34d", ["M24 32h336a23.94 23.94 0 0 1 24 23.88V72a23.94 23.94 0 0 1-23.88 24H24A23.94 23.94 0 0 1 0 72.12V56a23.94 23.94 0 0 1 23.88-24z", "M232.11 480H152a24 24 0 0 1-24-24V320H40c-17.82 0-26.73-21.51-14.12-34.11l152.45-152.26a19.4 19.4 0 0 1 27.34 0l152.42 152.23C370.7 298.46 361.79 320 344 320h-87.83v136a24 24 0 0 1-24 24z"]],
    "arrow-alt-up": [448, 512, [], "f357", ["M160,456V256H288.11V456a24,24,0,0,1-24,24H184A24,24,0,0,1,160,456Z", "M39.05,215,207,39a24.08,24.08,0,0,1,34,0L408.92,215c15.11,15.09,4.4,41-17,41H56.05C34.63,256,24,230.3,39.05,215Z"]],
    "arrow-circle-down": [512, 512, [], "f0ab", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm149.6 263.6L272.9 404.3a23.9 23.9 0 0 1-33.9 0L106.4 271.6a23.9 23.9 0 0 1 0-33.9l10.9-11a24 24 0 0 1 34.3.4l72.4 75.5V120a23.94 23.94 0 0 1 24-24h16a23.94 23.94 0 0 1 24 24v182.6l72.4-75.5a24 24 0 0 1 34.3-.4l10.9 11a23.9 23.9 0 0 1 0 33.9z", "M360.4 227.1a24 24 0 0 1 34.3-.4l10.9 11a23.9 23.9 0 0 1 0 33.9L272.9 404.3a23.9 23.9 0 0 1-33.9 0L106.4 271.6a23.9 23.9 0 0 1 0-33.9l10.9-11a24 24 0 0 1 34.3.4l72.4 75.5V120a23.94 23.94 0 0 1 24-24h16a23.94 23.94 0 0 1 24 24v182.6l72.4-75.5z"]],
    "arrow-circle-left": [512, 512, [], "f0a8", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm160 256a23.94 23.94 0 0 1-24 24H209.4l75.5 72.4a24 24 0 0 1 .4 34.3l-11 10.9a23.9 23.9 0 0 1-33.9 0L107.7 272.9a23.9 23.9 0 0 1 0-33.9l132.7-132.6a23.9 23.9 0 0 1 33.9 0l11 10.9a24 24 0 0 1-.4 34.3L209.4 224H392a23.94 23.94 0 0 1 24 24z", "M285.3 394.7l-11 10.9a23.9 23.9 0 0 1-33.9 0L107.7 272.9a23.9 23.9 0 0 1 0-33.9l132.7-132.6a23.9 23.9 0 0 1 33.9 0l11 10.9a24 24 0 0 1-.4 34.3L209.4 224H392a23.94 23.94 0 0 1 24 24v16a23.94 23.94 0 0 1-24 24H209.4l75.5 72.4a24 24 0 0 1 .4 34.3z"]],
    "arrow-circle-right": [512, 512, [], "f0a9", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm148.3 265L271.6 405.6a23.9 23.9 0 0 1-33.9 0l-11-10.9a24 24 0 0 1 .4-34.3l75.5-72.4H120a23.94 23.94 0 0 1-24-24v-16a23.94 23.94 0 0 1 24-24h182.6l-75.5-72.4a24.15 24.15 0 0 1-.4-34.4l11-10.9a23.9 23.9 0 0 1 33.9 0l132.7 132.8a23.9 23.9 0 0 1 0 33.9z", "M226.7 117.2l11-10.9a23.9 23.9 0 0 1 33.9 0l132.7 132.8a23.9 23.9 0 0 1 0 33.9L271.6 405.6a23.9 23.9 0 0 1-33.9 0l-11-10.9a24 24 0 0 1 .4-34.3l75.5-72.4H120a23.94 23.94 0 0 1-24-24v-16a23.94 23.94 0 0 1 24-24h182.6l-75.5-72.4a24.15 24.15 0 0 1-.4-34.4z"]],
    "arrow-circle-up": [512, 512, [], "f0aa", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm149.6 266.3l-10.9 11a24 24 0 0 1-34.3-.4L288 209.4V392a23.94 23.94 0 0 1-24 24h-16a23.94 23.94 0 0 1-24-24V209.4l-72.4 75.5a24.15 24.15 0 0 1-34.4.4l-10.9-11a23.9 23.9 0 0 1 0-33.9l132.8-132.7a23.9 23.9 0 0 1 33.9 0l132.6 132.7a23.9 23.9 0 0 1 0 33.9z", "M117.2 285.3l-10.9-11a23.9 23.9 0 0 1 0-33.9l132.8-132.7a23.9 23.9 0 0 1 33.9 0l132.6 132.7a23.9 23.9 0 0 1 0 33.9l-10.9 11a24 24 0 0 1-34.3-.4L288 209.4V392a23.94 23.94 0 0 1-24 24h-16a23.94 23.94 0 0 1-24-24V209.4l-72.4 75.5a24.15 24.15 0 0 1-34.4.4z"]],
    "arrow-down": [448, 512, [], "f063", ["M265 56v286.4L224 384l-41-41.59V56c0-13.3 11-24 24.63-24h32.82A24.22 24.22 0 0 1 265 56z", "M441.48 278.31c-.23.24-.47.48-.71.71L241.44 473a25 25 0 0 1-34.78 0L7.23 279a23.38 23.38 0 0 1-.7-33.11c.22-.24.46-.47.7-.7L30 223.06a25.13 25.13 0 0 1 35.18.4L224 384.19l158.8-160.73a24.94 24.94 0 0 1 35.18-.4l22.78 22.15a23.38 23.38 0 0 1 .72 33.1z"]],
    "arrow-from-bottom": [384, 512, [], "f342", ["M360 480H24a23.94 23.94 0 0 1-24-24v-16a23.94 23.94 0 0 1 24-24h336a23.94 23.94 0 0 1 24 24v16a23.94 23.94 0 0 1-24 24z", "M56.13 225.48l-17.06-17a23.86 23.86 0 0 1 0-33.91L175 39.05a24 24 0 0 1 34 0l135.93 135.52a23.86 23.86 0 0 1 0 33.91l-17.06 17a24 24 0 0 1-34 0l-65.81-65.61V360A24 24 0 0 1 204 384h-24.09a24 24 0 0 1-24.07-24V159.87L90 225.48a23.9 23.9 0 0 1-33.87 0z"]],
    "arrow-from-left": [448, 512, [], "f343", ["M0 424V88a23.94 23.94 0 0 1 24-24h16a23.94 23.94 0 0 1 24 24v336a23.94 23.94 0 0 1-24 24H24a23.94 23.94 0 0 1-24-24z", "M254.52 120.13l17-17.06a23.86 23.86 0 0 1 33.91 0L441 239a24 24 0 0 1 0 34L305.43 408.93a23.86 23.86 0 0 1-33.91 0l-17-17.06a24 24 0 0 1 0-34l65.61-65.81H120A24 24 0 0 1 96 268v-24.09a24 24 0 0 1 24-24.07h200.13L254.52 154a23.9 23.9 0 0 1 0-33.87z"]],
    "arrow-from-right": [448, 512, [], "f344", ["M448 88v336a23.94 23.94 0 0 1-24 24h-16a23.94 23.94 0 0 1-24-24V88a23.94 23.94 0 0 1 24-24h16a23.94 23.94 0 0 1 24 24z", "M193.48 391.87l-17 17.06a23.86 23.86 0 0 1-33.91 0L7.05 273a24 24 0 0 1 0-34l135.52-135.93a23.86 23.86 0 0 1 33.91 0l17 17.06a24 24 0 0 1 0 34l-65.61 65.81H328A24 24 0 0 1 352 244v24.08a24 24 0 0 1-24 24.07H127.87L193.48 358a23.9 23.9 0 0 1 0 33.87z"]],
    "arrow-from-top": [384, 512, [], "f345", ["M24 32h336a23.94 23.94 0 0 1 24 24v16a23.94 23.94 0 0 1-24 24H24A23.94 23.94 0 0 1 0 72V56a23.94 23.94 0 0 1 24-24z", "M327.87 286.52l17.06 17a23.86 23.86 0 0 1 0 33.91L209 473a24 24 0 0 1-34 0L39.07 337.43a23.86 23.86 0 0 1 0-33.91l17.06-17a24 24 0 0 1 34 0l65.81 65.61V152A24 24 0 0 1 180 128h24.08a24 24 0 0 1 24.07 24v200.13L294 286.52a23.9 23.9 0 0 1 33.87 0z"]],
    "arrow-left": [448, 512, [], "f060", ["M424 297H137.6L96 256l41.59-41H424c13.3 0 24 11 24 24.63v32.82A24.22 24.22 0 0 1 424 297z", "M201.69 473.48l-.71-.71L7 273.44a25 25 0 0 1 0-34.78L201 39.23a23.38 23.38 0 0 1 33.11-.7c.24.22.47.46.7.7L256.94 62a25.13 25.13 0 0 1-.4 35.18L95.81 256l160.73 158.8a24.94 24.94 0 0 1 .4 35.18l-22.15 22.78a23.38 23.38 0 0 1-33.1.72z"]],
    "arrow-right": [448, 512, [], "f061", ["M24 215h286.4l41.6 41-41.59 41H24c-13.3 0-24-11-24-24.63v-32.82A24.22 24.22 0 0 1 24 215z", "M246.31 38.52c.24.23.48.47.71.71L441 238.56a25 25 0 0 1 0 34.78L247 472.77a23.38 23.38 0 0 1-33.11.7c-.24-.22-.47-.46-.7-.7L191.06 450a25.13 25.13 0 0 1 .4-35.18L352.19 256 191.46 97.2a24.94 24.94 0 0 1-.4-35.18l22.15-22.78a23.38 23.38 0 0 1 33.1-.72z"]],
    "arrow-square-down": [448, 512, [], "f339", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-26.4 239.6L240.9 404.3a23.9 23.9 0 0 1-33.9 0L74.4 271.6a23.9 23.9 0 0 1 0-33.9l10.9-11a24 24 0 0 1 34.3.4l72.4 75.5V120a23.94 23.94 0 0 1 24-24h16a23.94 23.94 0 0 1 24 24v182.6l72.4-75.5a24 24 0 0 1 34.3-.4l10.9 11a23.9 23.9 0 0 1 0 33.9z", "M328.4 227.1a24 24 0 0 1 34.3-.4l10.9 11a23.9 23.9 0 0 1 0 33.9L240.9 404.3a23.9 23.9 0 0 1-33.9 0L74.4 271.6a23.9 23.9 0 0 1 0-33.9l10.9-11a24 24 0 0 1 34.3.4l72.4 75.5V120a23.94 23.94 0 0 1 24-24h16a23.94 23.94 0 0 1 24 24v182.6l72.4-75.5z"]],
    "arrow-square-left": [448, 512, [], "f33a", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-16 232a23.94 23.94 0 0 1-24 24H177.4l75.5 72.4a24 24 0 0 1 .4 34.3l-11 10.9a23.9 23.9 0 0 1-33.9 0L75.7 272.9a23.9 23.9 0 0 1 0-33.9l132.7-132.6a23.9 23.9 0 0 1 33.9 0l11 10.9a24 24 0 0 1-.4 34.3L177.4 224H360a23.94 23.94 0 0 1 24 24z", "M253.3 394.7l-11 10.9a23.9 23.9 0 0 1-33.9 0L75.7 272.9a23.9 23.9 0 0 1 0-33.9l132.7-132.6a23.9 23.9 0 0 1 33.9 0l11 10.9a24 24 0 0 1-.4 34.3L177.4 224H360a23.94 23.94 0 0 1 24 24v16a23.94 23.94 0 0 1-24 24H177.4l75.5 72.4a24 24 0 0 1 .4 34.3z"]],
    "arrow-square-right": [448, 512, [], "f33b", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-27.7 241L239.6 405.6a23.9 23.9 0 0 1-33.9 0l-11-10.9a24 24 0 0 1 .4-34.3l75.5-72.4H88a23.94 23.94 0 0 1-24-24v-16a23.94 23.94 0 0 1 24-24h182.6l-75.5-72.4a24.15 24.15 0 0 1-.4-34.4l11-10.9a23.9 23.9 0 0 1 33.9 0l132.7 132.8a23.9 23.9 0 0 1 0 33.9z", "M194.7 117.2l11-10.9a23.9 23.9 0 0 1 33.9 0l132.7 132.8a23.9 23.9 0 0 1 0 33.9L239.6 405.6a23.9 23.9 0 0 1-33.9 0l-11-10.9a24 24 0 0 1 .4-34.3l75.5-72.4H88a23.94 23.94 0 0 1-24-24v-16a23.94 23.94 0 0 1 24-24h182.6l-75.5-72.4a24.15 24.15 0 0 1-.4-34.4z"]],
    "arrow-square-up": [448, 512, [], "f33c", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-26.4 242.3l-10.9 11a24 24 0 0 1-34.3-.4L256 209.4V392a23.94 23.94 0 0 1-24 24h-16a23.94 23.94 0 0 1-24-24V209.4l-72.4 75.5a24.15 24.15 0 0 1-34.4.4l-10.9-11a23.9 23.9 0 0 1 0-33.9l132.8-132.7a23.9 23.9 0 0 1 33.9 0l132.6 132.7a23.9 23.9 0 0 1 0 33.9z", "M85.2 285.3l-10.9-11a23.9 23.9 0 0 1 0-33.9l132.8-132.7a23.9 23.9 0 0 1 33.9 0l132.6 132.7a23.9 23.9 0 0 1 0 33.9l-10.9 11a24 24 0 0 1-34.3-.4L256 209.4V392a23.94 23.94 0 0 1-24 24h-16a23.94 23.94 0 0 1-24-24V209.4l-72.4 75.5a24.15 24.15 0 0 1-34.4.4z"]],
    "arrow-to-bottom": [384, 512, [], "f33d", ["M360 480H24a23.94 23.94 0 0 1-24-23.88V440a23.94 23.94 0 0 1 23.88-24H360a23.94 23.94 0 0 1 24 23.88V456a23.94 23.94 0 0 1-23.88 24z", "M327.87 190.52l17.06 17a23.86 23.86 0 0 1 .17 33.74l-.17.17L209 377a24 24 0 0 1-33.94.06L175 377 39.07 241.43a23.86 23.86 0 0 1-.17-33.74l.17-.17 17.06-17a24 24 0 0 1 33.94-.06l.06.06 65.81 65.61V56a24 24 0 0 1 24-24h24.14a24 24 0 0 1 24.07 23.93v200.2L294 190.52a23.91 23.91 0 0 1 33.8-.07z"]],
    "arrow-to-left": [448, 512, [], "f33e", ["M0 424V88a23.94 23.94 0 0 1 24-24h16a23.94 23.94 0 0 1 24 24v336a23.94 23.94 0 0 1-24 24H24a23.94 23.94 0 0 1-24-24z", "M289.48 391.87l-17 17.06a23.86 23.86 0 0 1-33.91 0L103.05 273a24 24 0 0 1 0-34l135.52-135.93a23.86 23.86 0 0 1 33.91 0l17 17.06a24 24 0 0 1 0 34l-65.61 65.81H424A24 24 0 0 1 448 244v24.08a24 24 0 0 1-24 24.07H223.87L289.48 358a23.9 23.9 0 0 1 0 33.87z"]],
    "arrow-to-right": [448, 512, [], "f340", ["M448 88v336a23.94 23.94 0 0 1-24 24h-16a23.94 23.94 0 0 1-24-24V88a23.94 23.94 0 0 1 24-24h16a23.94 23.94 0 0 1 24 24z", "M158.52 120.13l17-17.06a23.86 23.86 0 0 1 33.91 0L345 239a24 24 0 0 1 0 34L209.43 408.93a23.86 23.86 0 0 1-33.91 0l-17-17.06a24 24 0 0 1 0-34l65.61-65.81H24A24 24 0 0 1 0 268v-24.09a24 24 0 0 1 24-24.07h200.13L158.52 154a23.9 23.9 0 0 1 0-33.87z"]],
    "arrow-to-top": [384, 512, [], "f341", ["M24 32h336a23.94 23.94 0 0 1 24 24v16a23.94 23.94 0 0 1-24 24H24A23.94 23.94 0 0 1 0 72V56a23.94 23.94 0 0 1 24-24z", "M56.13 321.48l-17.06-17a23.86 23.86 0 0 1 0-33.91L175 135.05a24 24 0 0 1 34 0l135.93 135.52a23.86 23.86 0 0 1 0 33.91l-17.06 17a24 24 0 0 1-34 0l-65.81-65.61V456A24 24 0 0 1 204 480h-24.09a24 24 0 0 1-24.07-24V255.87L90 321.48a23.9 23.9 0 0 1-33.87 0z"]],
    "arrow-up": [448, 512, [], "f062", ["M183 456V169.6l41-41.6 41 41.59V456c0 13.3-11 24-24.63 24h-32.82A24.22 24.22 0 0 1 183 456z", "M6.52 233.69c.23-.24.47-.48.71-.71L206.56 39a25 25 0 0 1 34.78 0l199.43 194a23.38 23.38 0 0 1 .7 33.11c-.22.24-.46.47-.7.7L418 288.94a25.13 25.13 0 0 1-35.18-.4L224 127.81 65.2 288.54a24.94 24.94 0 0 1-35.18.4L7.23 266.79a23.38 23.38 0 0 1-.71-33.1z"]],
    "arrows": [512, 512, [], "f047", ["M440 256l-34.68 32H288v117.34L256 440l-32-34.68V288H106.66L72 256l34.68-32H224V106.66L256 72l32 34.67V224h117.34z", "M128.57 170.71l-.46-.47-10.83-10.84a24 24 0 0 0-33.93 0l-74 74a32 32 0 0 0 0 45.24l74 74a24 24 0 0 0 33.93 0l10.83-10.84.46-.47a24 24 0 0 0-.93-33.92L72 256l55.66-51.37a24 24 0 0 0 .91-33.92zm374.05 62.67l-74-74a24 24 0 0 0-33.93 0l-10.83 10.84-.46.47a24 24 0 0 0 .93 33.92L440 256l-55.66 51.37a24 24 0 0 0-.93 33.92l.46.47 10.83 10.84a24 24 0 0 0 33.93 0l74-74a32 32 0 0 0 0-45.24zM341.76 383.89l-.47-.46a24 24 0 0 0-33.92.93L256 440l-51.37-55.66a24 24 0 0 0-33.92-.93l-.47.46-10.84 10.85a24 24 0 0 0 0 33.93l74 74a32 32 0 0 0 45.24 0l74-74a24 24 0 0 0 0-33.93zM278.62 9.38a32 32 0 0 0-45.24 0l-74 74a24 24 0 0 0 0 33.93l10.84 10.83.47.46a24 24 0 0 0 33.92-.93L256 72l51.37 55.66a24 24 0 0 0 33.92.93l.47-.46 10.84-10.83a24 24 0 0 0 0-33.93z"]],
    "arrows-alt": [512, 512, [], "f0b2", ["M384 288h-96v96h-64v-96h-96v-64h96v-96h64v96h96z", "M504.93 239.07l-79.7-79C410 145 384 155.67 384 177v158c0 21.34 26 32 41.23 16.93l79.7-79 .2-.2a23.8 23.8 0 0 0-.2-33.66zm-418.16-79l-79.7 79-.2.2a23.8 23.8 0 0 0 .2 33.66l79.7 79C102 367 128 356.33 128 335V177c0-21.34-26-32-41.23-16.93zM335 384H177c-21.34 0-32 26-16.93 41.23l79 79.7.2.2a23.8 23.8 0 0 0 33.66-.2l79-79.7C367 410 356.33 384 335 384zM272.93 7.07l-.2-.2a23.8 23.8 0 0 0-33.66.2l-79 79.7C145 102 155.67 128 177 128h158c21.34 0 32-26 16.93-41.23z"]],
    "arrows-alt-h": [512, 512, [], "f337", ["M134.1 216H378v80H134.1z", "M378 170v172c0 21.41 25.88 32.1 41 17l86-86a24 24 0 0 0 0-33.94L419 153c-15.17-15-41-4.36-41 17zM134.1 342V170.11c0-21.41-25.88-32.1-41-17l-86.1 86A24 24 0 0 0 7 273l86.1 86c15.15 15.06 41 4.37 41-17z"]],
    "arrows-alt-v": [256, 512, [], "f338", ["M88 378V134.08h80V378z", "M42 134.08h171.94c21.4 0 32.09-25.87 17-41L145 7a24 24 0 0 0-33.89 0L25 93.09c-15 15.15-4.32 40.99 17 40.99zM213.94 378H42.14c-21.4 0-32.09 25.88-17 41l86 86a24 24 0 0 0 33.86 0l85.93-86c15.07-15.23 4.4-41-16.99-41z"]],
    "arrows-h": [512, 512, [], "f07e", ["M405.66 288H106.34l-33.77-32 33.77-32h299.32l33.77 32z", "M358.59 146.37a23.93 23.93 0 0 0 .94 33.92l79.9 75.71-79.9 75.71a23.93 23.93 0 0 0-.94 33.92L369.9 377a24.15 24.15 0 0 0 34.1 0l98.65-98.36a31.92 31.92 0 0 0 0-45.24L404 135a24.15 24.15 0 0 0-34.05 0zM153.41 365.63a23.93 23.93 0 0 0-.94-33.92L72.57 256l79.9-75.71a23.93 23.93 0 0 0 .94-33.92L142.1 135a24.15 24.15 0 0 0-34 0L9.4 233.38a31.92 31.92 0 0 0 0 45.24L108.05 377a24.15 24.15 0 0 0 34.05 0z"]],
    "arrows-v": [256, 512, [], "f07d", ["M160 106.34v299.32l-32 33.77-32-33.77V106.34l32-33.77z", "M18.37 153.41a23.93 23.93 0 0 0 33.92-.94L128 72.57l75.71 79.9a23.93 23.93 0 0 0 33.92.94L249 142.1a24.15 24.15 0 0 0 0-34L150.62 9.4a31.92 31.92 0 0 0-45.24 0L7 108.05a24.15 24.15 0 0 0 0 34.05zm219.26 205.18a23.93 23.93 0 0 0-33.92.94L128 439.43l-75.71-79.9a23.93 23.93 0 0 0-33.92-.94L7 369.9A24.15 24.15 0 0 0 7 404l98.36 98.65a31.92 31.92 0 0 0 45.24 0L249 404a24.15 24.15 0 0 0 0-34.05z"]],
    "assistive-listening-systems": [512, 512, [], "f2a2", ["M160 320a32 32 0 1 0 32 32 32 32 0 0 0-32-32zM32 448a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm480-192.52c-1.88-115-75.8-217-184-254a28 28 0 1 0-18.1 53C395.79 83.86 454.5 165 456 256.46v3.55a28 28 0 0 0 56 0v-4.53zM39 393l80 80 34-34-80-80z", "M240 236a24 24 0 0 1 24 24 28 28 0 0 0 56 0 80 80 0 0 0-160 0 28 28 0 0 0 56 0 24 24 0 0 1 24-24zm0-152c-97 0-176 79-176 176a28 28 0 0 0 56 0 120 120 0 0 1 240 0c0 75.16-71 70.31-72 143.62v.38a52.06 52.06 0 0 1-52 52 28 28 0 0 0 0 56 108.12 108.12 0 0 0 108-107.77c.59-34.43 72-48.23 72-144.23 0-97-78.95-176-176-176z"]],
    "asterisk": [512, 512, [], "f069", ["M479 177.64l-.41.23-182.5 100.45 3.45 209.17A24 24 0 0 1 276.06 512h-39.55a24 24 0 0 1-24-24v-.52L216 278 33.47 177.91A24 24 0 0 1 24 145.32l.25-.45 19.5-33.74a24.07 24.07 0 0 1 32.89-8.75l.38.23L256 208l179-105.39a24.07 24.07 0 0 1 33.05 8.12l.23.4 19.5 33.74a24 24 0 0 1-8.78 32.77z", "M488 366.68l-.25.45-19.5 33.74a24.07 24.07 0 0 1-32.89 8.75l-.38-.23L256 304 77 409.39a24.07 24.07 0 0 1-33-8.12l-.23-.4-19.5-33.74a24 24 0 0 1 8.83-32.77l.41-.23 182.4-100.45-3.45-209.17A24 24 0 0 1 235.94 0h39.55a24 24 0 0 1 24 24v.52L296 234l182.53 100.09a24 24 0 0 1 9.47 32.59z"]],
    "at": [512, 512, [], "f1fa", ["M440 232c0-102.38-83.86-160-184-160-101.46 0-184 82.54-184 184s82.54 184 184 184a184.46 184.46 0 0 0 99.41-29.13 23.94 23.94 0 0 1 31.37 5.13L397 428.4a24.94 24.94 0 0 1 1.61 2.21 24 24 0 0 1-7.2 33.17A248.76 248.76 0 0 1 256 504C118.92 504 8 393.08 8 256S118.94 8 256 8c138 0 248 87.65 248 224 0 68.32-33.63 133.22-120 145.37v-62c35.72-5.27 56-45.37 56-83.37z", "M391.79 164.58a24 24 0 0 0-19-28.14 24.26 24.26 0 0 0-4.58-.44h-45a13.52 13.52 0 0 0-13.43 12v.09c-14.69-17.9-40.45-21.77-60-21.77-74.55 0-137.8 62.22-137.8 151.45 0 65.3 36.79 105.87 96 105.87 27 0 57.37-15.64 75-38.33 9.52 34.1 40.61 34.1 70.71 34.1a217.39 217.39 0 0 0 30.29-2v-62c-.72.1-1.44.22-2.17.3-17.35-.45-16.91-12.85-13.48-30zM234.32 312.43c-22.25 0-36.07-15.62-36.07-40.77 0-45 30.78-72.73 58.63-72.73 22.29 0 35.6 15.24 35.6 40.77 0 45.06-33.87 72.73-58.16 72.73z"]],
    "atlas": [448, 512, [], "f558", ["M96 448c-19.2 0-32-12.8-32-32s16-32 32-32h319.33c-1.93 16.24-1.76 48.38.53 64z", "M224 97.31c-7.69 7.45-20.77 34.42-23.43 78.69h46.87c-2.67-44.26-15.75-71.24-23.44-78.69zM318.38 208h-39.09c-1.49 27-6.54 51.35-14.21 70.41a95.85 95.85 0 0 0 53.3-70.41zm0-32a95.87 95.87 0 0 0-53.3-70.41c7.68 19.06 12.72 43.41 14.21 70.41zM182.92 278.41C175.24 259.35 170.2 235 168.71 208h-39.09a95.85 95.85 0 0 0 53.3 70.41zM247.43 208h-46.87c2.66 44.26 15.74 71.24 23.43 78.69 7.7-7.45 20.78-34.43 23.44-78.69zM96 384h328a24 24 0 0 0 24-24V32a32 32 0 0 0-32-32H96A96 96 0 0 0 0 96v320a96 96 0 0 0 96 96h328a24 24 0 0 0 24-24v-16a24 24 0 0 0-24-24H96c-19.2 0-32-12.8-32-32s16-32 32-32zM224 64A128 128 0 1 1 96 192 128 128 0 0 1 224 64zm-41.08 41.59a95.85 95.85 0 0 0-53.3 70.41h39.09c1.49-27 6.53-51.35 14.21-70.41z"]],
    "atom": [448, 512, [], "f5d2", ["M371 139.78a383.51 383.51 0 0 0-19.86-61.63c38.56-.12 69.15 11.36 85.18 35.28 33 49.19-6.09 135.37-88.62 208.33A501.57 501.57 0 0 0 352 256q0-12.88-.63-25.46c29.83-34.13 43.09-64.7 31.85-81.46a25.19 25.19 0 0 0-12.22-9.3zm12.88 192.14c4.46 12.6 4.49 23.27-.69 31-7.22 10.79-23.59 14.35-45.75 11.63-2 7.73-4.24 15.24-6.64 22.48v.07q-2.38 7.22-5 14.08l-.05.12q-3.93 10.32-8.38 19.78c54.26 8.29 98.5-1.95 119-32.51 19.19-28.64 14-69.81-10-113.62a428.39 428.39 0 0 1-42.46 46.97zM287 289.47q-13.14 10-27.56 19.69c-11.94 8-23.86 15.37-35.61 22-11.75-6.68-23.68-14-35.63-22C100.21 250.1 44.8 178.43 64.47 149.08s107-5.29 195 53.76c9.59 6.44 18.8 13 27.56 19.69-.12-2-.24-3.95-.38-5.92v-.37q-.18-2.61-.39-5.19c0-.34-.05-.68-.08-1q-.19-2.43-.42-4.83l-.06-.72q-.53-5.62-1.15-11.1c0-.19 0-.38-.07-.58-.19-1.62-.39-3.23-.59-4.83 0-.25-.06-.51-.1-.77q-1-8.1-2.3-15.85c0-.16-.06-.32-.08-.48-.27-1.61-.54-3.21-.82-4.8l-.06-.32q-1.38-7.73-3-15l-.06-.26a332.53 332.53 0 0 0-3.43-14.19c-111.13-67-225.69-78.07-262.69-22.86-39.35 58.69 23.9 170.12 141.26 248.85.59.41 1.19.8 1.79 1.19-44.09 15.5-78.48 16.5-89.93-.58-5.18-7.73-5.14-18.4-.68-31a427.57 427.57 0 0 1-42.42-47c-24 43.8-29.21 85-10 113.62 37 55.21 151.56 44.14 262.69-22.86 6.51-24.52 11.08-53.98 12.94-86.21z", "M256 256a32 32 0 1 0-32 32 32 32 0 0 0 32-32zm-91.7-69.28c-8.46-3.64-16.7-6.81-24.6-9.44-13.62-4.54-26.07-7.43-36.09-8.37q-1.33 7.38-2.45 15a190.32 190.32 0 0 0 18 24.11 368.85 368.85 0 0 0 41 40 541.33 541.33 0 0 1 4.14-61.3zM224 0c-28.86 0-55.49 19.11-76.91 51.35a382.81 382.81 0 0 1 62.12 17.81A25.41 25.41 0 0 1 224 64c35.35 0 64 86 64 192s-28.65 192-64 192a25.41 25.41 0 0 1-14.79-5.16 382.81 382.81 0 0 1-62.12 17.81C168.51 492.89 195.14 512 224 512c70.69 0 128-114.62 128-256S294.69 0 224 0z"]],
    "atom-alt": [448, 512, [], "f5d3", ["M224 80.64c83.21-51.73 163.1-64.92 201.7-26.33S451.09 172.79 399.37 256a514.73 514.73 0 0 0-37.88-52.89c27.77-47.21 36.63-86.73 19.38-104-29.4-29.39-123.46 17-210.09 103.65a651.68 651.68 0 0 0-26.58 28.19 430.51 430.51 0 0 1-28.13-40.75c-2.73-4.52-5.16-8.79-7.34-12.82q8.65-9.45 17.93-18.74a584.93 584.93 0 0 1 44.46-40.16q3.21-2.61 6.44-5.16l.26-.2q9.81-7.73 19.66-14.78l.2-.14q3-2.13 6-4.2l1.23-.84c1.68-1.16 3.37-2.31 5-3.44l1.43-1c1.76-1.17 3.52-2.33 5.28-3.46l1-.64q3.17-1.99 6.38-3.98zM224 224a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm53.22 85.22q-14 14-28.18 26.57a403.3 403.3 0 0 0 53 35.21c.17.1.34.18.51.27q9.45-8.65 18.74-17.93a582.54 582.54 0 0 0 40.15-44.45A466.42 466.42 0 0 0 324.83 256a625.1 625.1 0 0 1-47.61 53.22zm-106.1 84.28c-47.22 27.76-86.74 36.62-104 19.37s-8.39-56.77 19.37-104A516.23 516.23 0 0 1 48.64 256c-51.72 83.22-64.92 163.09-26.33 201.69S140.78 483.08 224 431.36a516.23 516.23 0 0 1-52.88-37.86z", "M425.69 457.69c-53.76 53.76-187.64 7-299-104.35S-31.45 108.07 22.31 54.31C60.91 15.72 140.78 28.92 224 80.64a516.23 516.23 0 0 0-52.87 37.86c-47.22-27.76-86.74-36.62-104-19.37-29.39 29.4 17 123.46 103.65 210.09s180.69 133 210.09 103.65-17-123.46-103.65-210.09q-14-14-28.2-26.58a433.78 433.78 0 0 1 40.76-28.13c4.52-2.73 8.79-5.16 12.82-7.34q9.45 8.66 18.74 17.93c111.39 111.39 158.11 245.27 104.35 299.03z"]],
    "audio-description": [512, 512, [], "f29e", ["M159 223.47c-1.22 5.24-2.59 10.82-3.87 15.24l-9 30.65h25.57l-8.83-30.65c-1.26-4.42-2.64-9.99-3.87-15.24zM464 64H48a48 48 0 0 0-48 48v288a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V112a48 48 0 0 0-48-48zM234.1 352h-29.17a12 12 0 0 1-11.53-8.6l-8.79-30h-51.37l-8.57 29.91a12 12 0 0 1-11.54 8.69H84a12 12 0 0 1-11.35-15.86l57.09-168a12 12 0 0 1 11.37-8.14H177a12 12 0 0 1 11.36 8.14l57.1 168A12 12 0 0 1 234.1 352zm97.1 0h-57.37a12 12 0 0 1-12-12V172a12 12 0 0 1 12-12h57.37c61 0 99 36.64 99 95.61 0 59.46-38 96.39-99 96.39zm-1.8-145.39h-14.52v98.78h14.52c29.77 0 46.17-17.68 46.17-49.78s-17.49-49-46.17-49z", "M188.36 168.14A12 12 0 0 0 177 160h-35.89a12 12 0 0 0-11.37 8.14l-57.09 168A12 12 0 0 0 84 352h29.13a12 12 0 0 0 11.54-8.69l8.57-29.91h51.37l8.79 30a12 12 0 0 0 11.53 8.6h29.17a12 12 0 0 0 11.36-15.86zm-42.22 101.22l9-30.65c1.28-4.42 2.65-10 3.87-15.24 1.22 5.25 2.6 10.82 3.87 15.24l8.83 30.65zM331.2 160h-57.37a12 12 0 0 0-12 12v168a12 12 0 0 0 12 12h57.37c61 0 99-36.93 99-96.39-.04-58.97-37.96-95.61-99-95.61zm-1.8 145.39h-14.52v-98.78h14.52c28.68 0 46.17 16.77 46.17 49s-16.4 49.78-46.17 49.78z"]],
    "award": [384, 512, [], "f559", ["M382.78 448.69L324 304.23a40.63 40.63 0 0 1-22.23 15.62C280 325.78 278.26 324.44 263 340a39.72 39.72 0 0 1-49.73 5.82 39.68 39.68 0 0 0-42.53 0A39.73 39.73 0 0 1 121 340c-14.73-15-16.4-14-38.73-20.12a40.54 40.54 0 0 1-22.07-15.4L1.2 448.7a16 16 0 0 0 15.43 22l52.69-2 36.22 38.3a16 16 0 0 0 22.62.61A16.23 16.23 0 0 0 132 502l60.15-147.1L252 502a16 16 0 0 0 26.43 5l36.25-38.28 52.69 2A16 16 0 0 0 384 455.33a16.23 16.23 0 0 0-1.22-6.64zM192 240a64 64 0 1 0-64-64 64 64 0 0 0 64 64z", "M366.62 152.72a41.51 41.51 0 0 0-10.42-39.59c-20.41-20.77-18.47-17.35-25.95-45.74a40.66 40.66 0 0 0-28.47-29c-27.88-7.61-24.52-5.62-45-26.41A39.79 39.79 0 0 0 218 1.39c-27.92 7.6-24 7.6-51.95 0A39.8 39.8 0 0 0 127.16 12c-20.41 20.78-17 18.8-44.94 26.41a40.66 40.66 0 0 0-28.47 29c-7.47 28.39-5.54 25-25.95 45.75a41.46 41.46 0 0 0-10.42 39.58c7.47 28.36 7.48 24.4 0 52.82a41.52 41.52 0 0 0 10.42 39.57c20.41 20.78 18.47 17.35 26 45.75a40.64 40.64 0 0 0 28.47 29C104.6 326 106.27 325 121 340a39.74 39.74 0 0 0 49.74 5.82 39.68 39.68 0 0 1 42.53 0A39.73 39.73 0 0 0 263 340c15.28-15.55 17-14.21 38.79-20.14a40.64 40.64 0 0 0 28.47-29c7.48-28.4 5.54-25 25.95-45.75a41.49 41.49 0 0 0 10.42-39.58c-7.48-28.36-7.49-24.4-.01-52.81zM192 272a96 96 0 1 1 96-96 96 96 0 0 1-96 96z"]],
    "axe": [640, 512, [], "f6b2", ["M592 160v32c0 97.05-79 176-176 176h-32v48h32c123.71 0 224-100.29 224-224v-32zM4.69 439.43a16 16 0 0 0 0 22.63L50 507.31a16 16 0 0 0 22.63 0l235.82-235.87-67.88-67.88zM507.31 72.57a16 16 0 0 0 0-22.63L462.06 4.69a16 16 0 0 0-22.63 0l-34.5 34.5 67.88 67.88z", "M384 301.74L233.37 151.11a32 32 0 0 1 0-45.25l96.49-96.49a32 32 0 0 1 45.26 0L525.74 160H560v32c0 79.4-64.6 144-144 144h-32z"]],
    "axe-battle": [512, 512, [], "f6b3", ["M512 160.92C505.16 99.16 478.4 44.29 438.94 4.7c-9.21-9.25-23.89-4.12-27.06 9-12 49.67-47.25 88.27-91.88 101.23v154.18c44.63 13 79.85 51.56 91.88 101.23 3.17 13.08 17.85 18.21 27.06 9 39.46-39.59 66.22-94.45 73.06-156.22L449.24 192zM101 13.66C97.86.58 83.32-4.54 74.2 4.7 28.67 50.83 0 117.62 0 192s28.67 141.17 74.2 187.3c9.13 9.25 23.66 4.12 26.8-9 11.92-49.67 46.79-88.27 91-101.23V114.89c-44.21-12.96-79.08-51.56-91-101.23z", "M288 80v416a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V80a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16z"]],
    "baby": [384, 512, [], "f77c", ["M272.07 288v48L216 400h-48l-55.93-64-.07-48z", "M192 160a80 80 0 1 0-80-80 80 80 0 0 0 80 80zm-52.46 259L168 400l-55.93-64v-.06l-.07.06-57.33 49a40 40 0 0 0-3 59.24l56 56a40 40 0 1 0 56.56-56.56zM376 143.19a39.81 39.81 0 0 0-55.86-7.88l-40.5 28.39a152.31 152.31 0 0 1-175.28 0l-40.47-28.39a40 40 0 0 0-48 63.9q1 .78 2.13 1.5l40.49 28.5A231.24 231.24 0 0 0 112 257.1V288h160v-30.9a231.24 231.24 0 0 0 53.49-27.89l40.51-28.5q1.09-.72 2.13-1.5a40.08 40.08 0 0 0 7.87-56.02zM328.33 385L272 336l-56 64 27.46 19-24.74 24.75a40 40 0 1 0 56.57 56.56l56-56a40 40 0 0 0-3-59.24z"]],
    "baby-carriage": [512, 512, [], "f77d", ["M96 384a64 64 0 1 0 64 64 64 64 0 0 0-64-64zm256 0a64 64 0 1 0 64 64 64 64 0 0 0-64-64zM90.8 7.61C35.3 51.91 0 118 0 192h256L144.8 17c-11.3-17.79-37.2-22.79-54-9.39z", "M496 96h-48a64.06 64.06 0 0 0-64 64v64H0a191.44 191.44 0 0 0 56.82 136.34 96.07 96.07 0 0 1 129.68 55.58c1.83.05 3.66.08 5.5.08h64c1.84 0 3.67 0 5.5-.08a96.07 96.07 0 0 1 129.68-55.58A191.44 191.44 0 0 0 448 224v-64h48a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "backpack": [448, 512, [], "f5d4", ["M320 320H128a32 32 0 0 0-32 32v32h256v-32a32 32 0 0 0-32-32zM136 208h176a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8H136a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8z", "M96 512h256v-96H96zM320 80h-8V56a56.06 56.06 0 0 0-56-56h-64a56.06 56.06 0 0 0-56 56v24h-8A128 128 0 0 0 0 208v240a64 64 0 0 0 64 64V352a64.07 64.07 0 0 1 64-64h192a64.07 64.07 0 0 1 64 64v160a64 64 0 0 0 64-64V208A128 128 0 0 0 320 80zM184 56a8 8 0 0 1 8-8h64a8 8 0 0 1 8 8v24h-80zm136 144a8 8 0 0 1-8 8H136a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h176a8 8 0 0 1 8 8z"]],
    "backspace": [640, 512, [], "f55a", ["M576 64H205.26A64 64 0 0 0 160 82.75L9.38 233.37a32 32 0 0 0 0 45.25L160 429.25A64 64 0 0 0 205.25 448H576a64 64 0 0 0 64-64V128a64 64 0 0 0-64-64zm-84.69 254.06a16 16 0 0 1 0 22.63l-22.62 22.62a16 16 0 0 1-22.63 0L384 301.25l-62.06 62.06a16 16 0 0 1-22.63 0l-22.62-22.62a16 16 0 0 1 0-22.63L338.75 256l-62.06-62.06a16 16 0 0 1 0-22.63l22.62-22.62a16 16 0 0 1 22.63 0L384 210.75l62.06-62.06a16 16 0 0 1 22.63 0l22.62 22.62a16 16 0 0 1 0 22.63L429.25 256z", "M491.31 318.06a16 16 0 0 1 0 22.63l-22.62 22.62a16 16 0 0 1-22.63 0L384 301.25l-62.06 62.06a16 16 0 0 1-22.63 0l-22.62-22.62a16 16 0 0 1 0-22.63L338.75 256l-62.06-62.06a16 16 0 0 1 0-22.63l22.62-22.62a16 16 0 0 1 22.63 0L384 210.75l62.06-62.06a16 16 0 0 1 22.63 0l22.62 22.62a16 16 0 0 1 0 22.63L429.25 256z"]],
    "backward": [512, 512, [], "f04a", ["M512 96v320c0 27.39-31.9 41.79-52.51 24.59L288 297.69v-83.38L459.49 71.45C480.1 54.25 512 68.65 512 96z", "M11.48 231.41l192-160C224.1 54.25 256 68.65 256 96v320c0 27.39-31.9 41.79-52.51 24.59l-192-160a32.07 32.07 0 0 1-.01-49.18z"]],
    "bacon": [576, 512, [], "f7e5", ["M9.09 407.62C-3.61 395-3 374 10.88 362.56c36.33-30 66.2-41.1 91.06-50.36 9.17-3.41 69-19.26 98.72-98.09 8.61-22.81 46.34-134.59 189-187.73 15.85-5.91 27.36-10.2 41-20.3a31 31 0 0 1 40.14 2.83l26.31 26.14C467 62.7 444.24 71.37 420.38 80.37 392.08 91 362.81 102 323 141.75s-50.76 69.05-61.37 97.34c-9.85 26.31-19.16 51.12-54.05 86s-59.65 44.16-85.91 54c-26 9.76-53 20.13-88.17 52.73zM566.92 104.4l-24.44-24.2c-35.19 32.64-62.17 43-88.24 52.8-26.26 9.85-51.06 19.16-85.95 54s-44.19 59.69-54 86c-10.64 28.33-21.62 57.56-61.41 97.34s-69 50.73-97.3 61.32c-23.85 9-46.59 17.65-76.68 45.3l26.32 26.14a31 31 0 0 0 40.18 2.82c13.6-10.06 25.09-14.34 40.94-20.24 142.19-53 180-164.11 188.93-187.7 29.73-78.79 89.52-94.67 98.73-98.11 24.87-9.28 54.74-20.41 91.11-50.42 13.89-11.4 14.51-32.45 1.81-45.05z", "M252.88 370.34c-39.79 39.78-69 50.73-97.3 61.32-23.86 9-46.6 17.66-76.71 45.33l-45.33-45.16c35.17-32.6 62.17-43 88.17-52.73 26.26-9.84 51.05-19.12 85.91-54s44.2-59.7 54.05-86c10.61-28.29 21.59-57.54 61.37-97.34s69-50.77 97.34-61.38c23.88-9 46.64-17.68 76.79-45.37l45.31 45.2c-35.19 32.64-62.17 43-88.24 52.8-26.26 9.85-51.06 19.16-85.95 54s-44.19 59.69-54 86c-10.64 28.32-21.62 57.55-61.41 97.33z"]],
    "badge": [512, 512, [], "f335", ["M512 256a88 88 0 0 0-57.09-82.41 88 88 0 0 0-116.5-116.5 88 88 0 0 0-164.82 0 88 88 0 0 0-116.5 116.5 88 88 0 0 0 0 164.82 88 88 0 0 0 116.5 116.5 88 88 0 0 0 164.82 0 88 88 0 0 0 116.5-116.5A88 88 0 0 0 512 256zm-122.23 55.42a55.67 55.67 0 0 1-78.36 78.37 55.68 55.68 0 0 1-110.82 0 55.68 55.68 0 0 1-78.36-78.37 55.69 55.69 0 0 1 0-110.84 55.68 55.68 0 0 1 78.36-78.37 55.68 55.68 0 0 1 110.82 0 55.68 55.68 0 0 1 78.36 78.37 55.69 55.69 0 0 1 0 110.84z", "M389.77 311.42a55.67 55.67 0 0 1-78.36 78.37 55.68 55.68 0 0 1-110.82 0 55.68 55.68 0 0 1-78.36-78.37 55.69 55.69 0 0 1 0-110.84 55.68 55.68 0 0 1 78.36-78.37 55.68 55.68 0 0 1 110.82 0 55.68 55.68 0 0 1 78.36 78.37 55.69 55.69 0 0 1 0 110.84z"]],
    "badge-check": [512, 512, [], "f336", ["M512 256a88 88 0 0 0-57.1-82.4A88 88 0 0 0 338.4 57.1a88 88 0 0 0-164.8 0A88 88 0 0 0 57.1 173.6a88 88 0 0 0 0 164.8 88 88 0 0 0 116.5 116.5 88 88 0 0 0 164.8 0 88 88 0 0 0 116.5-116.5A88 88 0 0 0 512 256zm-144.8-44.25l-131 130a11 11 0 0 1-15.55-.06l-75.72-76.33a11 11 0 0 1 .06-15.56L171 224a11 11 0 0 1 15.56.06l42.15 42.49 97.2-96.42a11 11 0 0 1 15.55.06l25.82 26a11 11 0 0 1-.08 15.56z", "M367.2 211.75l-131 130a11 11 0 0 1-15.55-.06l-75.72-76.33a11 11 0 0 1 .06-15.56L171 224a11 11 0 0 1 15.56.06l42.15 42.49 97.2-96.42a11 11 0 0 1 15.55.06l25.82 26a11 11 0 0 1-.06 15.56z"]],
    "badge-dollar": [512, 512, [], "f645", ["M512 256a88 88 0 0 0-57.1-82.4A88 88 0 0 0 338.4 57.1a88 88 0 0 0-164.8 0A88 88 0 0 0 57.1 173.6a88 88 0 0 0 0 164.8 88 88 0 0 0 116.5 116.5 88 88 0 0 0 164.8 0 88 88 0 0 0 116.5-116.5A88 88 0 0 0 512 256zm-232 94.44V368a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-17.73a73 73 0 0 1-31.78-11.46c-6.22-4.11-6.82-13.11-1.55-18.38l17.52-17.52c3.74-3.74 9.31-4.24 14.11-2a24.52 24.52 0 0 0 10.26 2.22h32.78a8.43 8.43 0 0 0 2.32-16.53l-50.07-14.3c-22.25-6.35-40-24.71-42.91-47.67a56.27 56.27 0 0 1 49.32-63V144a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v17.73a73 73 0 0 1 31.78 11.46c6.22 4.11 6.82 13.11 1.55 18.38l-17.52 17.52c-3.74 3.74-9.31 4.24-14.11 2a24.54 24.54 0 0 0-10.26-2.22h-32.78a8.43 8.43 0 0 0-2.32 16.53l50.07 14.3c22.25 6.36 40 24.71 42.91 47.67A56.27 56.27 0 0 1 280 350.44z", "M280 350.44V368a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-17.73a73 73 0 0 1-31.78-11.46c-6.22-4.11-6.82-13.11-1.55-18.38l17.52-17.52c3.74-3.74 9.31-4.24 14.11-2a24.52 24.52 0 0 0 10.26 2.22h32.78a8.43 8.43 0 0 0 2.32-16.53l-50.07-14.3c-22.25-6.35-40-24.71-42.91-47.67a56.27 56.27 0 0 1 49.32-63V144a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v17.73a73 73 0 0 1 31.78 11.46c6.22 4.11 6.82 13.11 1.55 18.38l-17.52 17.52c-3.74 3.74-9.31 4.24-14.11 2a24.54 24.54 0 0 0-10.26-2.22h-32.78a8.43 8.43 0 0 0-2.32 16.53l50.07 14.3c22.25 6.36 40 24.71 42.91 47.67a56.27 56.27 0 0 1-49.32 63z"]],
    "badge-percent": [512, 512, [], "f646", ["M512 256a88 88 0 0 0-57.1-82.4A88 88 0 0 0 338.4 57.1a88 88 0 0 0-164.8 0A88 88 0 0 0 57.1 173.6a88 88 0 0 0 0 164.8 88 88 0 0 0 116.5 116.5 88 88 0 0 0 164.8 0 88 88 0 0 0 116.5-116.5A88 88 0 0 0 512 256zm-320-96a32 32 0 1 1-32 32 32 32 0 0 1 32-32zm12.28 181.65a16 16 0 0 1-22.63 0l-11.31-11.31a16 16 0 0 1 0-22.63l137.37-137.37a16 16 0 0 1 22.63 0l11.31 11.31a16 16 0 0 1 0 22.63zM320 352a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M192 160a32 32 0 1 1-32 32 32 32 0 0 1 32-32zm12.28 181.65a16 16 0 0 1-22.63 0l-11.31-11.31a16 16 0 0 1 0-22.63l137.37-137.37a16 16 0 0 1 22.63 0l11.31 11.31a16 16 0 0 1 0 22.63zM320 352a32 32 0 1 1 32-32 32 32 0 0 1-32 32z"]],
    "badge-sheriff": [512, 512, [], "f8a2", ["M440 192a40 40 0 1 0-40-40 40 40 0 0 0 40 40zM72 320a40 40 0 1 0 40 40 40 40 0 0 0-40-40zm0-208a40 40 0 1 0 40 40 40 40 0 0 0-40-40zm368 208a40 40 0 1 0 40 40 40 40 0 0 0-40-40zM256 0a40 40 0 1 0 40 40 40 40 0 0 0-40-40zm0 432a40 40 0 1 0 40 40 40 40 0 0 0-40-40z", "M428.79 322.26l-39.46-66.32 39.43-66.21C412.26 184.8 400 170.11 400 152c0-2.84 1.05-5.33 1.62-8h-78.88l-43.15-72.55C272.9 76.47 265 80 256 80s-16.78-3.49-23.44-8.45L189.41 144h-79c.57 2.67 1.62 5.16 1.62 8 0 18.12-12.28 32.82-28.79 37.74l39.46 66.32-39.46 66.21C99.74 327.2 112 341.89 112 360c0 2.84-1 5.33-1.62 8h78.88l43.15 72.55C239.1 435.53 247 432 256 432s16.78 3.49 23.44 8.45L322.59 368h79c-.57-2.67-1.62-5.16-1.62-8 .03-18.12 12.31-32.82 28.82-37.74zM256 320a64 64 0 1 1 64-64 64 64 0 0 1-64 64z"]],
    "badger-honey": [640, 512, [], "f6b4", ["M619.83 124.94c-57.65-32.65-71-50.67-115.56-69.92A103.7 103.7 0 0 0 463 46.47a111.24 111.24 0 0 0-55.45 15.21c-17.06 9.79-35.9 16.79-55 16.79h-227a127.66 127.66 0 0 0-51.86 11c5.66 20.73 20.06 55 42.62 84.79 30.11 39.85 56.45 48.21 73.24 48.21h45.47a69.64 69.64 0 0 0 30-6.82l102-61.74.53-.25c29.8-14.33 59.14-27.19 90-27.19h164.71c-.78-.53-1.6-1.06-2.43-1.53zm-78.24 113.53l16 32 16-32 7-14.11-41.89 8.34z", "M622.25 126.47H457.58c-30.86 0-60.2 12.86-90 27.19l-.53.25-102 61.74a69.64 69.64 0 0 1-30 6.82h-45.47c-16.79 0-43.13-8.36-73.24-48.21-22.56-29.79-37-64.06-42.62-84.79a128 128 0 0 0-76.14 117v16a16 16 0 0 0 16 16h20c7.82 33.38 28.08 64.24 53.56 81.17l-21.49 57.3a64 64 0 0 0-2.16 38l14.09 35.41a16 16 0 0 0 15.52 12.12h63.77a15.48 15.48 0 0 0 3.84-.48 16 16 0 0 0 11.64-19.4l-15.55-41.26 33-66.86h105.69l23 115.14a16 16 0 0 0 15.69 12.86h63.37a16 16 0 0 0 15.69-19.1l-27-135c64-43.1 119.18-66.48 152.43-75.67l41.94-8.34c22.4-2.82 33-2.82 40.79-19 7.32-15.11 16.16-35.79 16.16-47.62.02-12.86-5.85-24.68-15.31-31.27zm-128.67 54a23.94 23.94 0 0 1-23.46-29H517a23.5 23.5 0 0 1 .54 5 24 24 0 0 1-23.96 24z"]],
    "bags-shopping": [576, 512, [], "f847", ["M448 192a32 32 0 0 0-32-32h-96V96a96 96 0 0 0-192 0v64H32a32 32 0 0 0-32 32v256a32 32 0 0 0 32 32h128V256a32 32 0 0 1 32-32h256zm-176-32h-96V96a48 48 0 0 1 96 0zm200 160h-16a8 8 0 0 0-8 8v24a64.07 64.07 0 0 1-70.38 63.69c-33.25-3.23-57.62-33.12-57.62-66.53V328a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v20.66c0 48.79 35 92.32 83.37 98.53A96.12 96.12 0 0 0 480 352v-24a8 8 0 0 0-8-8z", "M544 256H224a32 32 0 0 0-32 32v192a32 32 0 0 0 32 32h320a32 32 0 0 0 32-32V288a32 32 0 0 0-32-32zm-64 96a96.12 96.12 0 0 1-108.63 95.19C323 441 288 397.45 288 348.66V328a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v21.16c0 33.41 24.37 63.3 57.62 66.53A64.07 64.07 0 0 0 448 352v-24a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8z"]],
    "balance-scale": [640, 512, [], "f24e", ["M544 464v32a16 16 0 0 1-16 16H112a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h176V153.25A80.06 80.06 0 0 1 241.61 96H112a16 16 0 0 1-16-16V48a16 16 0 0 1 16-16h144.36a79.28 79.28 0 0 1 127.28 0H528a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16H398.39A80.06 80.06 0 0 1 352 153.25V448h176a16 16 0 0 1 16 16z", "M256 336c0-16.18 1.34-8.73-85-181.51-17.65-35.29-68.19-35.36-85.87 0C-2.06 328.75 0 320.33 0 336c0 44.18 57.31 80 128 80s128-35.82 128-80zM128 176l72 144H56zm512 160c0-16.18 1.34-8.73-85.05-181.51-17.65-35.29-68.19-35.36-85.87 0C381.94 328.75 384 320.33 384 336c0 44.18 57.31 80 128 80s128-35.82 128-80zm-200-16l72-144 72 144z"]],
    "balance-scale-left": [640, 512, [], "f515", ["M544 464v32a16 16 0 0 1-16 16H304a16 16 0 0 1-16-16V153.25a80.48 80.48 0 0 1-13-7.12l-142 47.63a16 16 0 0 1-20.26-10.08l-10.17-30.34a16 16 0 0 1 10.08-20.26L241 90a79.06 79.06 0 0 1-1-10 80 80 0 0 1 80-80c29.69 0 55.3 16.36 69.11 40.37L507 .84a16 16 0 0 1 20.26 10.08l10.17 30.34a16 16 0 0 1-10.08 20.26l-132 44.26A79.94 79.94 0 0 1 352 153.25V448h176a16 16 0 0 1 16 16z", "M640 304c0-16.18 1.34-8.73-85.05-181.51-17.65-35.29-68.19-35.36-85.87 0C381.94 296.75 384 288.33 384 304c0 44.18 57.31 80 128 80s128-35.82 128-80zm-200-16l72-144 72 144zm-269.07-37.51c-17.65-35.29-68.19-35.36-85.87 0C-2.06 424.75 0 416.33 0 432c0 44.18 57.31 80 128 80s128-35.82 128-80c0-16.18 1.32-8.73-85.07-181.51zM56 416l72-144 72 144z"]],
    "balance-scale-right": [640, 512, [], "f516", ["M112 448h176V153.24a79.91 79.91 0 0 1-43.38-47.47l-132-44.26a16 16 0 0 1-10.08-20.26l10.16-30.34A16 16 0 0 1 133 .83l117.89 39.54C264.7 16.36 290.31 0 320 0a80 80 0 0 1 80 80 79.06 79.06 0 0 1-1 10l128.4 43.05a16 16 0 0 1 10.08 20.26l-10.18 30.37a16 16 0 0 1-20.3 10.08l-142-47.63a80.48 80.48 0 0 1-13 7.12V496a16 16 0 0 1-16 16H112a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16z", "M0 304c0 44.18 57.31 80 128 80s128-35.82 128-80c0-15.67 2.08-7.25-85-181.51-17.68-35.36-68.22-35.29-85.87 0C-1.32 295.27 0 287.82 0 304zm56-16l72-144 72 144zm328 144c0 44.18 57.31 80 128 80s128-35.82 128-80c0-15.67 2.08-7.25-85.05-181.51-17.68-35.36-68.22-35.29-85.87 0C382.68 423.27 384 415.82 384 432zm56-16l72-144 72 144z"]],
    "ball-pile": [576, 512, [], "f77e", ["M176 168a80 80 0 1 0 80 80 80 80 0 0 0-80-80zm224 0a80 80 0 1 0 80 80 80 80 0 0 0-80-80z", "M80 352a80 80 0 1 0 80 80 80 80 0 0 0-80-80zM288 0a80 80 0 1 0 80 80 80 80 0 0 0-80-80zm0 352a80 80 0 1 0 80 80 80 80 0 0 0-80-80zm208 0a80 80 0 1 0 80 80 80 80 0 0 0-80-80z"]],
    "ballot": [384, 512, [], "f732", ["M360 0H24A23.94 23.94 0 0 0 0 24v464a23.94 23.94 0 0 0 24 24h336a23.94 23.94 0 0 0 24-24V24a23.94 23.94 0 0 0-24-24zM128 400a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16zm0-128a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16zm0-128a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16zm192 248a8 8 0 0 1-8 8H168a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h144a8 8 0 0 1 8 8zm0-128a8 8 0 0 1-8 8H168a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h144a8 8 0 0 1 8 8zm0-128a8 8 0 0 1-8 8H168a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h144a8 8 0 0 1 8 8z", "M112 352H80a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-128H80a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-128H80a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "ballot-check": [384, 512, [], "f733", ["M360 0H24A23.94 23.94 0 0 0 0 24v464a23.94 23.94 0 0 0 24 24h336a23.94 23.94 0 0 0 24-24V24a23.94 23.94 0 0 0-24-24zM161.7 202.4l12.6 12.7a5.37 5.37 0 0 1 0 7.6l-64.2 63.6a5.37 5.37 0 0 1-7.6 0L65.6 249a5.37 5.37 0 0 1 0-7.6l12.7-12.6a5.37 5.37 0 0 1 7.6 0l20.6 20.8 47.6-47.2a5.37 5.37 0 0 1 7.6 0zM64 112a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16zm64 288a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16zm192-8a8 8 0 0 1-8 8H168a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h144a8 8 0 0 1 8 8zm-9.6-120H170.2s29.2-30.2 30.4-32h109.7c5.3 0 9.6 3.6 9.6 8v16h.1c0 4.4-4.3 8-9.6 8zm9.6-136a8 8 0 0 1-8 8H168a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h144a8 8 0 0 1 8 8z", "M80 160h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H80a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm94.3 55.1l-12.6-12.7a5.37 5.37 0 0 0-7.6 0l-47.6 47.2-20.6-20.8a5.37 5.37 0 0 0-7.6 0l-12.7 12.6a5.37 5.37 0 0 0 0 7.6l36.9 37.3a5.37 5.37 0 0 0 7.6 0l64.2-63.6a5.37 5.37 0 0 0 0-7.6zM112 352H80a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "ban": [512, 512, [], "f05e", ["M406.78 361.53a186.53 186.53 0 0 1-45.25 45.25L105.22 150.47a186.53 186.53 0 0 1 45.25-45.25z", "M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm130.11 378.11A184 184 0 1 1 440 256a182.82 182.82 0 0 1-53.89 130.11z"]],
    "band-aid": [640, 512, [], "f462", ["M0 160v192a64.05 64.05 0 0 0 64 64h96V96H64a64.05 64.05 0 0 0-64 64zm576-64h-96v320h96a64.05 64.05 0 0 0 64-64V160a64.05 64.05 0 0 0-64-64zM192 416h256V96H192zm176-232a24 24 0 1 1-24 24 23.94 23.94 0 0 1 24-24zm0 96a24 24 0 1 1-24 24 23.94 23.94 0 0 1 24-24zm-96-96a24 24 0 1 1-24 24 23.94 23.94 0 0 1 24-24zm0 96a24 24 0 1 1-24 24 23.94 23.94 0 0 1 24-24z", "M160 416h32V96h-32zM448 96v320h32V96z"]],
    "banjo": [512, 512, [], "f8a3", ["M192 200A120 120 0 1 1 72 320a120.13 120.13 0 0 1 120-120m0-48a168 168 0 1 0 168 168 168 168 0 0 0-168-168z", "M194.34 381.66l11.31-11.31a8 8 0 0 0 0-11.32L153 306.35a8 8 0 0 0-11.32 0l-11.31 11.31a8 8 0 0 0 0 11.31L183 381.66a8 8 0 0 0 11.34 0zM502.63 39L473.05 9.37a32 32 0 0 0-45.26 0l-46.31 46.32A35.26 35.26 0 0 0 373 69.48l-12.19 36.59L286 180.79A168.81 168.81 0 0 1 331.29 226l74.88-74.88L442.52 139a35.12 35.12 0 0 0 13.79-8.52l46.32-46.31a32 32 0 0 0 0-45.17zM56.48 221.48a168.39 168.39 0 0 1 37-37l-.23-.23a26.18 26.18 0 0 0-37 37zm0 197l-.23.22a26.18 26.18 0 1 0 37 37l.23-.23a168 168 0 0 1-37-36.95zm-30.3-124.7a26.18 26.18 0 0 0 0 52.36h.46C25.29 337.59 24 329 24 320s1.29-17.59 2.64-26.18zm301.34 124.7a168 168 0 0 1-37 37l.23.23a26.18 26.18 0 1 0 37-37zm30.3-124.7h-.46C358.71 302.41 360 311 360 320s-1.29 17.59-2.64 26.18h.46a26.18 26.18 0 0 0 0-52.36zm-192 191.54v.46a26.18 26.18 0 0 0 52.36 0v-.46C209.59 486.71 201 488 192 488s-17.59-1.29-26.18-2.64zM192 128a26.18 26.18 0 0 0-26.18 26.18v.46C174.41 153.29 183 152 192 152s17.59 1.29 26.18 2.64v-.46A26.19 26.19 0 0 0 192 128z"]],
    "barcode": [512, 512, [], "f02a", ["M179.71 447.73h8.86V64h-8.86zm36 0h8.86V64h-8.86zm-116.85 0h8.85V64h-8.85zm-72 0H36V64h-9.14zM494 64v384h18V64zm-53.71 383.73h26.85V64h-26.85zm-144 0h18V64h-18zm72 0h18V64h-18z", "M134.86 447.73h17.71V64h-17.71zm62.85 0h8.86V64h-8.86zM0 448h18V64H0zm54-.27h8.86V64H54zm341.14 0h18V64h-18zM476 64v383.73h9.14V64zM251.43 447.73h18V64h-18zm80.86 0h18V64h-18z"]],
    "barcode-alt": [640, 512, [], "f463", ["M592 0H48A48 48 0 0 0 0 48v416a48 48 0 0 0 48 48h544a48 48 0 0 0 48-48V48a48 48 0 0 0-48-48zM160 408a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8V104a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8zm64 0a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8V104a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8zm64 0a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8V104a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8zm128 0a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8V104a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8zm128 0a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8V104a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8z", "M152 96h-48a8 8 0 0 0-8 8v304a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8V104a8 8 0 0 0-8-8zm64 0h-16a8 8 0 0 0-8 8v304a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8V104a8 8 0 0 0-8-8zm64 0h-16a8 8 0 0 0-8 8v304a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8V104a8 8 0 0 0-8-8zm128 0h-48a8 8 0 0 0-8 8v304a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8V104a8 8 0 0 0-8-8zm128 0h-48a8 8 0 0 0-8 8v304a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8V104a8 8 0 0 0-8-8z"]],
    "barcode-read": [640, 512, [], "f464", ["M144 448H64v-80a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v128a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-448H16A16 16 0 0 0 0 16v128a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V64h80a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16zm480 0H496a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h80v80a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16zm0 352h-32a16 16 0 0 0-16 16v80h-80a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16V368a16 16 0 0 0-16-16z", "M184 128h-48a8 8 0 0 0-8 8v240a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8V136a8 8 0 0 0-8-8zm64 0h-16a8 8 0 0 0-8 8v240a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8V136a8 8 0 0 0-8-8zm160 0h-48a8 8 0 0 0-8 8v240a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8V136a8 8 0 0 0-8-8zm-96 0h-16a8 8 0 0 0-8 8v240a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8V136a8 8 0 0 0-8-8zm192 0h-48a8 8 0 0 0-8 8v240a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8V136a8 8 0 0 0-8-8z"]],
    "barcode-scan": [640, 512, [], "f465", ["M280 0h-48a8 8 0 0 0-8 8v152h64V8a8 8 0 0 0-8-8zM152 0H72a8 8 0 0 0-8 8v152h96V8a8 8 0 0 0-8-8zM64 504a8 8 0 0 0 8 8h80a8 8 0 0 0 8-8V352H64zM472 0h-48a8 8 0 0 0-8 8v152h64V8a8 8 0 0 0-8-8zm96 0h-48a8 8 0 0 0-8 8v152h64V8a8 8 0 0 0-8-8zM376 0h-16a8 8 0 0 0-8 8v152h32V8a8 8 0 0 0-8-8zm136 504a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8V352h-64zm-288 0a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8V352h-64zm192 0a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8V352h-64zm-64 0a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8V352h-32z", "M640 232v48a8 8 0 0 1-8 8H8a8 8 0 0 1-8-8v-48a8 8 0 0 1 8-8h624a8 8 0 0 1 8 8z"]],
    "bars": [448, 512, [], "f0c9", ["M16 288h416a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16z", "M432 384H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-320H16A16 16 0 0 0 0 80v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16V80a16 16 0 0 0-16-16z"]],
    "baseball": [640, 512, [], "f432", ["M123 354.88L169 419c15.9-9.1 32.3-17.5 48.8-25.5L162 315.68c-12.63 13.5-25.53 26.6-39 39.2zm372-2.8a80 80 0 1 0 79.8 80 79.87 79.87 0 0 0-79.8-80z", "M629.67 56.08l-23.9-33.4A53.82 53.82 0 0 0 530 10.48l-212 156.3c-69.1 50.9-112.4 99.8-137.2 128.3l62.2 86.7c34.6-15.2 93.7-41.8 162.8-92.7l212.1-156.2c24.1-17.8 29.37-52.2 11.77-76.8zm-583.3 361.6c-19.2-24.1-36.6-9-37.4-8.4A24 24 0 0 0 5.27 443l47.9 60a23.87 23.87 0 0 0 33.7 3.7c2.8-2.2 17.5-16.5 2.3-35.6 8.2-5.9 24.6-18.2 56.4-37.9l-43.2-60.3c-30 25.98-47 38.18-56 44.78z"]],
    "baseball-ball": [496, 512, [], "f433", ["M441.77,101.1a213.51,213.51,0,0,0-44,60.42l-.12.24-28.75-14,.09-.19A245.85,245.85,0,0,1,420.13,77.5C323.91-15.33,171.4-15.14,75.4,77.91a244.73,244.73,0,0,1,50.72,68.79L97.51,160.9a212.83,212.83,0,0,0-43.58-59.31,248,248,0,0,0,.33,309.22,213.57,213.57,0,0,0,43.91-60.36l.11-.24L127,364.26l-.09.19a245.76,245.76,0,0,1-51.12,70c96.2,92.86,248.71,92.72,344.73-.32a244.66,244.66,0,0,1-50.76-68.83l28.65-14.25A212.72,212.72,0,0,0,442,410.46a248.06,248.06,0,0,0-.34-309.36ZM139.25,334.49l-30.33-10.2A212.09,212.09,0,0,0,120,256.52a214.18,214.18,0,0,0-11.69-69.79l30.26-10.4A245.62,245.62,0,0,1,152,256.52,243.74,243.74,0,0,1,139.25,334.49Zm218.13,1.14a245.26,245.26,0,0,1-.67-158.16L387,187.67a213.39,213.39,0,0,0,.6,137.56Z", "M98.17,350.45a214.1,214.1,0,0,1-43.91,60.36,250.37,250.37,0,0,0,21.56,23.67,245.93,245.93,0,0,0,51.13-70l.09-.19-28.76-14ZM97.51,160.9l28.65-14.25A244.73,244.73,0,0,0,75.44,77.86a249.19,249.19,0,0,0-21.52,23.71A213.3,213.3,0,0,1,97.51,160.9Zm300.28.62a213.51,213.51,0,0,1,44-60.42,250.36,250.36,0,0,0-21.57-23.66A245.73,245.73,0,0,0,369,147.52l-.09.19,28.75,14ZM376,255.44A212.18,212.18,0,0,1,387,187.67l-30.33-10.2a245.26,245.26,0,0,0,.67,158.16l30.26-10.4a213.85,213.85,0,0,1-11.71-69.79Zm22.5,95.63L369.8,365.32a244.59,244.59,0,0,0,50.77,68.84,250.19,250.19,0,0,0,21.51-23.7A212.63,212.63,0,0,1,398.45,351.07ZM108.32,186.73A214.44,214.44,0,0,1,120,256.52a212.1,212.1,0,0,1-11.09,67.77l30.33,10.2a243.61,243.61,0,0,0,12.76-78,245.62,245.62,0,0,0-13.43-80.19Z"]],
    "basketball-ball": [496, 512, [], "f434", ["M216,10.05A247,247,0,0,0,84.33,69.7l79.89,79.89A212.33,212.33,0,0,0,216,10.05ZM186.89,172.26,248,233.37,411.67,69.7A247,247,0,0,0,248,8v2a244.13,244.13,0,0,1-61.11,162.26ZM280,502a247,247,0,0,0,131.67-59.7l-79.89-79.89A212.38,212.38,0,0,0,280,502ZM434.3,92.33,270.63,256l61.11,61.11A244.18,244.18,0,0,1,494,256h2A247,247,0,0,0,434.3,92.33Zm0,327.34A247,247,0,0,0,494,288a212.33,212.33,0,0,0-139.54,51.78ZM309.11,339.74,248,278.63,84.33,442.3A247,247,0,0,0,248,504v-2A244.13,244.13,0,0,1,309.11,339.74ZM61.7,92.33A247,247,0,0,0,2.05,224a212.33,212.33,0,0,0,139.54-51.78ZM164.26,194.89A244.13,244.13,0,0,1,2,256H0A247,247,0,0,0,61.7,419.67L225.37,256Z", "M280,502a249.84,249.84,0,0,1-32,2v-2a244.13,244.13,0,0,1,61.11-162.26L248,278.63,84.33,442.3A249.14,249.14,0,0,1,61.7,419.67L225.37,256l-61.11-61.11A244.13,244.13,0,0,1,2,256H0a249.89,249.89,0,0,1,2.05-32,212.33,212.33,0,0,0,139.54-51.78L61.7,92.33A249.14,249.14,0,0,1,84.33,69.7l79.89,79.89A212.33,212.33,0,0,0,216,10.05,249.89,249.89,0,0,1,248,8v2a244.13,244.13,0,0,1-61.11,162.26L248,233.37,411.67,69.7A249.14,249.14,0,0,1,434.3,92.33L270.63,256l61.11,61.11A244.18,244.18,0,0,1,494,256h2a249.84,249.84,0,0,1-2,32,212.33,212.33,0,0,0-139.54,51.78l79.89,79.89a249.14,249.14,0,0,1-22.63,22.63l-79.89-79.89A212.39,212.39,0,0,0,280,502Z"]],
    "basketball-hoop": [640, 512, [], "f435", ["M192 176h256v-48H192zm446.83 26.76C638.13 200.72 571.32 0 320 0S1.87 200.72 1.17 202.76c-1.6 10.39-1.1-8.66-1.1 132.35 0 23.23 13.6 44 34.71 52.78L139 431.6 130.15 288H104a40 40 0 0 1-40-40v-32a40 40 0 0 1 40-40h56V96h320v80h56a40 40 0 0 1 40 40v32a40 40 0 0 1-40 40h-26.15L501 431.6l104.21-43.71c21.11-8.76 34.71-29.55 34.71-52.78.01-141.01.51-121.96-1.09-132.35z", "M445.27 319.9L408.63 288h-47.07L320 329.4 278.44 288h-47.07l-36.64 31.9-2.51-31.9H160l18.27 224L254 440.4l66 71.6 66.05-71.6 75.68 71.6L480 288h-32.22zm-240.5 124.3l-4.32-53.5 30 27.9zm48.38-48.2l-46.88-43.6 48.79-42.5 42.25 42.1zM320 458.1l-43.36-40.3L320 374.6l43.36 43.2zM342.69 352l42.25-42.1 48.79 42.5-46.88 43.6zm92.54 92.2l-25.69-25.6 30-27.9zM536 208H104a8 8 0 0 0-8 8v32a8 8 0 0 0 8 8h432a8 8 0 0 0 8-8v-32a8 8 0 0 0-8-8z"]],
    "bat": [640, 512, [], "f6b5", ["M411.83 175.3L320 230.4l-91.83-55.1L256 64l42.66 32h42.67L384 64z", "M640 320l-49.63-16.54a64 64 0 0 0-73.49 25.21L480 384l-11.82-11.82a64 64 0 0 0-90.51 0 65.74 65.74 0 0 0-5.95 6.86L320 448l-51.72-69a64 64 0 0 0-89.6-12.8 64.73 64.73 0 0 0-6.86 5.95L160 384l-36.89-55.33a64 64 0 0 0-73.49-25.21L0 320l81.55-190.31a32 32 0 0 1 42-16.8 32.58 32.58 0 0 1 3.86 2L320 230.4l192.56-115.53a32 32 0 0 1 43.91 11 32.58 32.58 0 0 1 2 3.86z"]],
    "bath": [512, 512, [], "f2cd", ["M80 256H32V112a80 80 0 0 1 145.74-45.51 67.84 67.84 0 0 1 64.18 15.36 12 12 0 0 1 16.42.49l11.32 11.32a12 12 0 0 1 0 17l-95 95a12 12 0 0 1-17 0l-11.32-11.32a12 12 0 0 1-.49-16.43 68 68 0 0 1-6.83-83A32 32 0 0 0 80 112z", "M512 280v16a24 24 0 0 1-24 24h-8v32a95.76 95.76 0 0 1-32 71.55V456a24 24 0 0 1-24 24h-16a24 24 0 0 1-24-24v-8H128v8a24 24 0 0 1-24 24H88a24 24 0 0 1-24-24v-32.45A95.76 95.76 0 0 1 32 352v-32h-8a24 24 0 0 1-24-24v-16a24 24 0 0 1 24-24h464a24 24 0 0 1 24 24z"]],
    "battery-bolt": [640, 512, [], "f376", ["M64 160h92.28l7.66-64H48a48 48 0 0 0-48 48v224a48 48 0 0 0 48 48h180.61l14.17-64H64zm552 0h-8v-16a48 48 0 0 0-48-48H405.38l-9.95 48h33.35a65.73 65.73 0 0 1 43.11 16H544v64h32v64h-32v64H427.17l-36.62 64H560a48 48 0 0 0 48-48v-16h8a24 24 0 0 0 24-24V184a24 24 0 0 0-24-24z", "M445.39 223.52l-140.77 246A19 19 0 0 1 288 480c-12.26 0-21.55-12.56-18.67-25.84l36.84-166.39h-95c-11.6 0-20.56-11.18-19-23.77l25.6-213.78C219 39.79 227.18 32 236.8 32h108.8c12.6 0 21.8 13.09 18.55 26.41L336.46 192h92.32c14.78 0 24.01 17.55 16.61 31.52z"]],
    "battery-empty": [640, 512, [], "f244", ["M616 160h-8v-16a48 48 0 0 0-48-48H48a48 48 0 0 0-48 48v224a48 48 0 0 0 48 48h512a48 48 0 0 0 48-48v-16h8a24 24 0 0 0 24-24V184a24 24 0 0 0-24-24zm-40 128h-32v64H64V160h480v64h32z", ""]],
    "battery-full": [640, 512, [], "f240", ["M616 160h-8v-16a48 48 0 0 0-48-48H48a48 48 0 0 0-48 48v224a48 48 0 0 0 48 48h512a48 48 0 0 0 48-48v-16h8a24 24 0 0 0 24-24V184a24 24 0 0 0-24-24zm-40 128h-32v64H64V160h480v64h32z", "M512 320H96V192h416z"]],
    "battery-half": [640, 512, [], "f242", ["M616 160h-8v-16a48 48 0 0 0-48-48H48a48 48 0 0 0-48 48v224a48 48 0 0 0 48 48h512a48 48 0 0 0 48-48v-16h8a24 24 0 0 0 24-24V184a24 24 0 0 0-24-24zm-40 128h-32v64H64V160h480v64h32z", "M320 320H96V192h224z"]],
    "battery-quarter": [640, 512, [], "f243", ["M616 160h-8v-16a48 48 0 0 0-48-48H48a48 48 0 0 0-48 48v224a48 48 0 0 0 48 48h512a48 48 0 0 0 48-48v-16h8a24 24 0 0 0 24-24V184a24 24 0 0 0-24-24zm-40 128h-32v64H64V160h480v64h32z", "M224 320H96V192h128z"]],
    "battery-slash": [640, 512, [], "f377", ["M165.31 96H560a48 48 0 0 1 48 48v16h8a24 24 0 0 1 24 24v144a24 24 0 0 1-24 24h-8v16a48 48 0 0 1-32.14 45.31L496.54 352H544v-64h32v-64h-32v-64H248.12zM64 352V179.49l-62.13-48A47.37 47.37 0 0 0 0 144v224a48 48 0 0 0 48 48h322l-82.81-64z", "M633.83 458.11L45.47 3.38A16 16 0 0 0 23 6.17L3.37 31.46a16 16 0 0 0 2.81 22.45l588.35 454.73a16 16 0 0 0 22.47-2.79l19.64-25.27a16 16 0 0 0-2.81-22.47z"]],
    "battery-three-quarters": [640, 512, [], "f241", ["M616 160h-8v-16a48 48 0 0 0-48-48H48a48 48 0 0 0-48 48v224a48 48 0 0 0 48 48h512a48 48 0 0 0 48-48v-16h8a24 24 0 0 0 24-24V184a24 24 0 0 0-24-24zm-40 128h-32v64H64V160h480v64h32z", "M416 320H96V192h320z"]],
    "bed": [640, 512, [], "f236", ["M528 128H304a16 16 0 0 0-16 16v144h352v-48a112 112 0 0 0-112-112zM176 96a80 80 0 1 0 80 80 80 80 0 0 0-80-80z", "M640 288v144a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-48H64v48a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16V80a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v208z"]],
    "beer": [448, 512, [], "f0fc", ["M368 96h-48V56a24 24 0 0 0-24-24H24A24 24 0 0 0 0 56v400a24 24 0 0 0 24 24h272a24 24 0 0 0 24-24v-42.11l80.61-36a80.08 80.08 0 0 0 47.39-73V176a80.09 80.09 0 0 0-80-80zM128 368a16 16 0 0 1-32 0V144a16 16 0 0 1 32 0zm96 0a16 16 0 0 1-32 0V144a16 16 0 0 1 32 0zm160-63.14a16 16 0 0 1-9.48 14.61L320 343.8V160h48a16 16 0 0 1 16 16z", "M208 128a16 16 0 0 0-16 16v224a16 16 0 0 0 32 0V144a16 16 0 0 0-16-16zm-96 0a16 16 0 0 0-16 16v224a16 16 0 0 0 32 0V144a16 16 0 0 0-16-16z"]],
    "bell": [448, 512, [], "f0f3", ["M448 384c-.1 16.4-13 32-32.1 32H32.08C13 416 .09 400.4 0 384a31.25 31.25 0 0 1 8.61-21.71c19.32-20.76 55.47-52 55.47-154.29 0-77.7 54.48-139.9 127.94-155.16V32a32 32 0 1 1 64 0v20.84C329.42 68.1 383.9 130.3 383.9 208c0 102.3 36.15 133.53 55.47 154.29A31.27 31.27 0 0 1 448 384z", "M160 448h128a64 64 0 0 1-128 0z"]],
    "bell-exclamation": [448, 512, [], "f848", ["M439.39 362.29c-19.32-20.76-55.47-52-55.47-154.29 0-77.7-54.48-139.9-127.94-155.16V32a32 32 0 1 0-64 0v20.84C118.56 68.1 64.08 130.3 64.08 208c0 102.3-36.15 133.53-55.47 154.29A31.24 31.24 0 0 0 0 384c.11 16.4 13 32 32.1 32h383.8c19.12 0 32-15.6 32.1-32a31.23 31.23 0 0 0-8.61-21.71zM224 352a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm38.2-206.4l-12.8 96a16 16 0 0 1-15.9 14.4h-19a16 16 0 0 1-15.9-14.4l-12.8-96a16.06 16.06 0 0 1 15.9-17.6h44.6a16 16 0 0 1 15.89 17.6z", "M160 448a64 64 0 1 0 128 0zm64-160a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm-9.5-32h19a16 16 0 0 0 15.9-14.4l12.8-96a16 16 0 0 0-15.9-17.6h-44.6a16.06 16.06 0 0 0-15.9 17.6l12.8 96a16 16 0 0 0 15.89 14.4z"]],
    "bell-plus": [448, 512, [], "f849", ["M439.39 361.29c-19.32-20.76-55.47-52-55.47-154.29 0-77.7-54.48-139.9-127.94-155.16V31a32 32 0 1 0-64 0v20.84C118.56 67.1 64.08 129.3 64.08 207c0 102.3-36.15 133.53-55.47 154.29A31.24 31.24 0 0 0 0 383c.11 16.4 13 32 32.1 32h383.8c19.12 0 32-15.6 32.1-32a31.23 31.23 0 0 0-8.61-21.71zM320 247a16 16 0 0 1-16 16h-56v56a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-56h-56a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h56v-56a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v56h56a16 16 0 0 1 16 16z", "M224 511a64 64 0 0 0 64-64H160a64 64 0 0 0 64 64zm80-296h-56v-56a16 16 0 0 0-16-16h-16a16 16 0 0 0-16 16v56h-56a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h56v56a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16v-56h56a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16z"]],
    "bell-school": [512, 512, [], "f5d5", ["M464 320a48 48 0 0 0-27.14 87.55A40.07 40.07 0 0 1 400 432h-48v48h48a88.08 88.08 0 0 0 86-69.56A47.86 47.86 0 0 0 464 320zM208 160a48 48 0 1 0 48 48 48 48 0 0 0-48-48z", "M208 0C93.12 0 0 93.12 0 208s93.12 208 208 208 208-93.12 208-208S322.88 0 208 0zm0 288a80 80 0 1 1 80-80 80.09 80.09 0 0 1-80 80zM64 399.54V480a32 32 0 0 0 32 32h224a32 32 0 0 0 32-32v-80.46a238.18 238.18 0 0 1-288 0z"]],
    "bell-school-slash": [640, 512, [], "f5d6", ["M486.36 344.13a48 48 0 1 1 75.23 58.14zM272 160a47.69 47.69 0 0 0-18.87 3.88l66.33 51.26A48 48 0 0 0 272 160zm78.19 240.67L66 181a209.13 209.13 0 0 0-2 27c0 114.88 93.12 208 208 208a207.23 207.23 0 0 0 78.19-15.33zM272 448a238.41 238.41 0 0 1-144-48.46V480a32 32 0 0 0 32 32h224a32 32 0 0 0 32-32v-28.47l-37.66-29.11A236.49 236.49 0 0 1 272 448zm-46.21-305.26a80 80 0 0 1 121 93.54l103 79.63A207 207 0 0 0 480 208C480 93.12 386.88 0 272 0a207.34 207.34 0 0 0-149.22 63.13z", "M633.82 458.09L45.47 3.38A16 16 0 0 0 23 6.17L3.37 31.46a16 16 0 0 0 2.81 22.45l588.34 454.71a16 16 0 0 0 22.48-2.79l19.64-25.27a16 16 0 0 0-2.82-22.47z"]],
    "bell-slash": [640, 512, [], "f1f6", ["M370 416H128.1c-19.12 0-32-15.6-32.1-32a31.24 31.24 0 0 1 8.61-21.71c16.21-17.42 44-42.79 52.62-110.75zm173.64-27.59A32.49 32.49 0 0 0 544 384a31.23 31.23 0 0 0-8.61-21.71c-19.32-20.76-55.47-52-55.47-154.29 0-77.7-54.48-139.9-127.94-155.16V32a32 32 0 1 0-64 0v20.84c-40.31 8.37-74.89 30.89-97.9 62.33zM320 512a64 64 0 0 0 64-64H256a64 64 0 0 0 64 64z", "M633.82 458.09L45.47 3.38A16 16 0 0 0 23 6.17L3.37 31.46a16 16 0 0 0 2.81 22.45l588.34 454.71a16 16 0 0 0 22.48-2.79l19.64-25.27a16 16 0 0 0-2.82-22.47z"]],
    "bells": [640, 512, [], "f77f", ["M117.3 119.08c-.8 2.1-14.7 40.5-15.4 42.71-29.2 80.31-66.4 94.55-87.4 105.28C-5.6 277.4-5 307.78 17.5 316l243.3 88.84c8.4-19.25 19.5-45.72-3.3-108.49L242 253.57c-27.9-76.91 5-161 73.7-200.34a130.82 130.82 0 0 0-27.4-14.17c-69.25-25.19-145.77 10.62-171 80.02zM543.77 411L428.1 453a63.76 63.76 0 0 0 115.67-42z", "M137.85 444.14a63.73 63.73 0 0 0 73.83-23.2L96.23 378.83a63.78 63.78 0 0 0 41.62 65.31zM625.55 299c-21-10.73-58.33-25-87.44-105.28-.8-2.2-14.7-40.61-15.4-42.72C497.4 81.63 420.88 45.84 351.64 71.1s-104.92 102-79.73 171.37c.8 2.11 14.81 40.52 15.61 42.72 29.21 80.32 9.7 115.22.5 137-8.8 20.76 11.21 43.72 33.72 35.5L622.45 348c20.55-7.55 24.9-37.74 3.1-49z"]],
    "betamax": [512, 512, [], "f8a4", ["M0 160v240a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V160zm144 224a80 80 0 1 1 80-80 80 80 0 0 1-80 80zm304 0H288V224h160z", "M496 64H16A16 16 0 0 0 0 80v80h512V80a16 16 0 0 0-16-16zM144 224a80 80 0 1 0 80 80 80 80 0 0 0-80-80zm0 112a32 32 0 1 1 32-32 32 32 0 0 1-32 32z"]],
    "bezier-curve": [640, 512, [], "f55b", ["M368 32h-96a32 32 0 0 0-32 32v96a32 32 0 0 0 32 32h96a32 32 0 0 0 32-32V64a32 32 0 0 0-32-32zM160 320H64a32 32 0 0 0-32 32v96a32 32 0 0 0 32 32h96a32 32 0 0 0 32-32v-96a32 32 0 0 0-32-32zm416 0h-96a32 32 0 0 0-32 32v96a32 32 0 0 0 32 32h96a32 32 0 0 0 32-32v-96a32 32 0 0 0-32-32z", "M208 88h-84.75a64 64 0 1 0 0 48H203A232.21 232.21 0 0 0 93.44 288h49.4a183.69 183.69 0 0 1 71-101.56A63.28 63.28 0 0 1 208 160zm368-40a63.93 63.93 0 0 0-59.25 40H432v72a63.43 63.43 0 0 1-5.88 26.44 183.69 183.69 0 0 1 71 101.56h49.4A232.21 232.21 0 0 0 437 136h79.73A64 64 0 1 0 576 48z"]],
    "bible": [448, 512, [], "f647", ["M96 448c-19.2 0-32-12.8-32-32s16-32 32-32h319.33c-1.93 16.24-1.76 48.38.53 64z", "M96 384h328a24 24 0 0 0 24-24V32a32 32 0 0 0-32-32H96A96 96 0 0 0 0 96v320a96 96 0 0 0 96 96h328a24 24 0 0 0 24-24v-16a24 24 0 0 0-24-24H96c-19.2 0-32-12.8-32-32s16-32 32-32zm48-240a16 16 0 0 1 16-16h48V80a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v48h48a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16h-48v112a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V192h-48a16 16 0 0 1-16-16z"]],
    "bicycle": [640, 512, [], "f206", ["M255 304h-48.61a79.82 79.82 0 0 0-19.64-38.23L212.63 224A127.74 127.74 0 0 1 255 304zm257-112a127.54 127.54 0 0 0-45.93 8.5l26.07 42a80.25 80.25 0 1 1-40.74 25.37l-26.09-42A128 128 0 1 0 512 192zM201.3 352a80 80 0 1 1-56.2-110.14l26.21-42.34A128 128 0 1 0 252 352z", "M495.83 339.45a16 16 0 0 0 22 5.16l13.6-8.44a16 16 0 0 0 5.15-22L388.39 75.34A24 24 0 0 0 368 64h-64a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h50.65l14.9 24H256v-16a16 16 0 0 0-16-16h-87.46c-13.44 0-24.77 11-24.53 24.44A24 24 0 0 0 152 152h48.73L99.6 315.37A24 24 0 0 0 120 352h184a24 24 0 0 0 20.41-11.37l86-138.86zM290.63 304H163.09l74.28-120h127.55z"]],
    "biking": [640, 512, [], "f84a", ["M512 256a128 128 0 1 0 128 128 128 128 0 0 0-128-128zm0 192a64 64 0 1 1 64-64 64 64 0 0 1-64 64zM128 256a128 128 0 1 0 128 128 128 128 0 0 0-128-128zm0 192a64 64 0 1 1 64-64 64 64 0 0 1-64 64z", "M400 96a48 48 0 1 0-48-48 48 48 0 0 0 48 48zm80 64h-52.78L356 103a31.94 31.94 0 0 0-40.81.68l-112 96a32 32 0 0 0 3.08 50.92L288 305.12V416a32 32 0 0 0 64 0V288a32 32 0 0 0-14.25-26.62l-41.36-27.57 58.25-49.92L396 217a31.9 31.9 0 0 0 20 7h64a32 32 0 0 0 0-64z"]],
    "biking-mountain": [640, 512, [], "f84b", ["M191.34 49.88l-58.12 48.76c-6.38 5.55-7 15.54-1.34 22.34l40.83 49.18c5.65 6.8 15.39 7.81 21.77 2.26L298.8 83.51c6.38-5.54 7-15.54 1.35-22.33-28.15-33.95-76.91-39.02-108.81-11.3zM240 352h-5.2a110.19 110.19 0 0 0-8.65-20.89l3.67-3.67a16 16 0 0 0 0-22.63l-22.63-22.63a16 16 0 0 0-22.63 0l-3.67 3.67A110.45 110.45 0 0 0 160 277.2V272a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v5.2a110.19 110.19 0 0 0-20.89 8.65l-3.67-3.67a16 16 0 0 0-22.63 0l-22.63 22.63a16 16 0 0 0 0 22.63l3.67 3.67A110.45 110.45 0 0 0 21.2 352H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h5.2a110.19 110.19 0 0 0 8.65 20.89l-3.67 3.67a16 16 0 0 0 0 22.63l22.63 22.63a16 16 0 0 0 22.63 0l3.67-3.67A110.94 110.94 0 0 0 96 490.8v5.2a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-5.2a110.56 110.56 0 0 0 20.9-8.65l3.66 3.67a16 16 0 0 0 22.63 0l22.63-22.63a16 16 0 0 0 0-22.63l-3.67-3.67a110.45 110.45 0 0 0 8.66-20.89H240a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-112 96a64 64 0 1 1 64-64 64 64 0 0 1-64 64zm496-96h-5.2a110.19 110.19 0 0 0-8.65-20.89l3.67-3.67a16 16 0 0 0 0-22.63l-22.63-22.63a16 16 0 0 0-22.63 0l-3.66 3.67a110.81 110.81 0 0 0-20.9-8.65V272a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v5.2a110.47 110.47 0 0 0-20.89 8.65l-3.66-3.67a16 16 0 0 0-22.63 0l-22.63 22.63a16 16 0 0 0 0 22.63l3.67 3.67a110.45 110.45 0 0 0-8.67 20.89H400a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h5.2a110.19 110.19 0 0 0 8.65 20.89l-3.67 3.67a16 16 0 0 0 0 22.63l22.63 22.63a16 16 0 0 0 22.63 0l3.66-3.67a110.94 110.94 0 0 0 20.9 8.65v5.2a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-5.2a110.56 110.56 0 0 0 20.9-8.65l3.67 3.67a16 16 0 0 0 22.63 0l22.63-22.63a16 16 0 0 0 0-22.63l-3.67-3.67A110.45 110.45 0 0 0 618.8 416h5.2a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-112 96a64 64 0 1 1 64-64 64 64 0 0 1-64 64z", "M400 96a48 48 0 1 0-48-48 48 48 0 0 0 48 48zm-4 121a32 32 0 0 0 20 7h64a32 32 0 0 0 0-64h-52.78L356 103a31.94 31.94 0 0 0-40.81.68l-112 96a32 32 0 0 0 3.07 50.92L288 305.12V416a32 32 0 0 0 64 0V288a32 32 0 0 0-14.25-26.62l-41.35-27.57 58.24-49.92z"]],
    "binoculars": [512, 512, [], "f1e5", ["M400 32h-64a16 16 0 0 0-16 16v48h96V48a16 16 0 0 0-16-16zm-224 0h-64a16 16 0 0 0-16 16v48h96V48a16 16 0 0 0-16-16zm48 256h64V128h-64z", "M63.91 160C61.4 253.84 3.46 274.22 0 404v44a32 32 0 0 0 32 32h96a32 32 0 0 0 32-32V288h32V128H95.84c-17.63 0-31.45 14.37-31.93 32zm384.18 0c-.48-17.62-14.3-32-31.93-32H320v160h32v160a32 32 0 0 0 32 32h96a32 32 0 0 0 32-32v-44c-3.46-129.78-61.4-150.16-63.91-244z"]],
    "biohazard": [576, 512, [], "f780", ["M206 80.83a89.75 89.75 0 0 0 29.5 40.69c16.51-5.7 34-9.5 52.51-9.5s36.2 3.8 52.81 9.6a89.75 89.75 0 0 0 29.5-40.69 207.71 207.71 0 0 0-164.32-.1zm-76.72 205.83a84 84 0 0 0-26.4-4.59 81.46 81.46 0 0 0-22.5 3.1 208.16 208.16 0 0 0 83.31 153.45 91.09 91.09 0 0 0 24.5-42.39 158.72 158.72 0 0 1-58.91-109.57zm343.94-4.59a85.81 85.81 0 0 0-26.6 4.69A158.8 158.8 0 0 1 387.91 396a91.4 91.4 0 0 0 24.5 42.49 207.53 207.53 0 0 0 83-153.45 83.1 83.1 0 0 0-22.19-2.97z", "M575.53 283.47c-13.1-39.09-39.5-72-74.1-92.37a162.36 162.36 0 0 0-55.31-19.9c6-17.69 10-36.39 10-56.18a173.9 173.9 0 0 0-41-112.16 7.84 7.84 0 0 0-10-1.8 8.26 8.26 0 0 0-3.6 9.69c4.5 13.8 6.6 26.29 6.6 38.49 0 67.78-53.8 122.86-120 122.86s-120-55.08-120-122.86c0-12.1 2.2-24.69 6.6-38.49a8.26 8.26 0 0 0-3.6-9.69 7.86 7.86 0 0 0-10 1.8 174.49 174.49 0 0 0-41 112.16c0 19.79 3.9 38.49 10 56.18a163.12 163.12 0 0 0-55.31 19.9c-34.6 20.49-61 53.28-74.3 92.37A8.32 8.32 0 0 0 4 293.26a7.82 7.82 0 0 0 10-1.6c9.4-10.79 19-19.09 29.2-25.09 57.31-33.89 130.82-13.69 163.92 45s13.4 134-43.9 167.84c-10.21 6.1-22 10.4-35.81 13.4a8.27 8.27 0 0 0-6.4 8.1 8.07 8.07 0 0 0 6.5 8 163.8 163.8 0 0 0 115.18-19.71c18-10.6 32.91-24.49 45.31-40.09 12.4 15.6 27.3 29.49 45.31 40.09a163.8 163.8 0 0 0 115.21 19.69 8.07 8.07 0 0 0 6.5-8 8.16 8.16 0 0 0-6.4-8.1c-13.9-2.9-25.6-7.3-35.81-13.4-57.3-33.89-77-109.16-43.9-167.84s106.61-78.88 163.92-45c10.2 6.1 19.8 14.3 29.2 25.09a7.82 7.82 0 0 0 10 1.6 8.27 8.27 0 0 0 3.5-9.77zM288 320.05a48 48 0 1 1 48-48 48 48 0 0 1-48 48z"]],
    "birthday-cake": [448, 512, [], "f1fd", ["M373.5 384c-28 0-31.39 32-74.75 32-43.55 0-46.6-32-74.75-32-27.28 0-31.66 32-74.5 32-43.5 0-46.8-32-74.75-32S43.36 416 0 416v96h448v-96c-43.25 0-47-32-74.5-32zM96 96c17.75 0 32-13.5 32-40S108 0 96 0c0 41-32 33-32 64a31.9 31.9 0 0 0 32 32zm128 0c17.75 0 32-13.5 32-40S236 0 224 0c0 41-32 33-32 64a31.9 31.9 0 0 0 32 32zm128 0c17.75 0 32-13.5 32-40S364 0 352 0c0 41-32 33-32 64a31.9 31.9 0 0 0 32 32z", "M448 384c-28 0-31.26-32-74.5-32-43.43 0-46.83 32-74.75 32-27.7 0-31.45-32-74.75-32-42.84 0-47.22 32-74.5 32-28.15 0-31.2-32-74.75-32S28.1 384 0 384v-80a48 48 0 0 1 48-48h16V112h64v144h64V112h64v144h64V112h64v144h16a48 48 0 0 1 48 48z"]],
    "blanket": [512, 512, [], "f498", ["M512 464v32a16 16 0 0 1-16 16H128C57.17 512-.41 454.17 0 383.25.41 312.62 58.78 256 129.41 256H432a80.09 80.09 0 0 1 80 80.79c-.43 44-37 79.21-81 79.21H128a32 32 0 0 1-32-32.9c.48-17.43 15.22-31.1 32.66-31.1H432a16 16 0 0 0 16-16.81c-.42-8.59-7.84-15.19-16.44-15.19H128a64.06 64.06 0 0 0-64 65c.53 35.12 29.84 63 65 63h367a16 16 0 0 1 16 16z", "M512 96s-.07 179.79-.28 233.47A80.1 80.1 0 0 0 432 256H129.41C58.78 256 .41 312.62 0 383.25v.73V96A96.14 96.14 0 0 1 96 0h320a96.14 96.14 0 0 1 96 96z"]],
    "blender": [512, 512, [], "f517", ["M328 288a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h114.18l17.46-64H328a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h140.36l17.46-64H328a8 8 0 0 1-8-8V72a8 8 0 0 1 8-8h166.55L512 0H48A48 48 0 0 0 0 48v160a48 48 0 0 0 48 48h103.27l8.73 96h256l17.45-64zM64 192V64h69.82l11.64 128z", "M416 384H160a64 64 0 0 0-64 64v32a32 32 0 0 0 32 32h320a32 32 0 0 0 32-32v-32a64 64 0 0 0-64-64zm-128 96a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm40-288h131.64l8.72-32H328a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8zm0 96h105.46l8.72-32H328a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8zm0-224a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h157.81l8.73-32z"]],
    "blender-phone": [576, 512, [], "f6b6", ["M497.46 288L480 352H192V0h384l-17.45 64H392a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h157.82l-17.45 64H392a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h131.64l-17.45 64H392a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8z", "M158.8 335L133 271.75a16.79 16.79 0 0 0-17.24-10.26l-45 4.42a214.78 214.78 0 0 1 0-147.72l45 4.42A16.81 16.81 0 0 0 133 112.35l25.8-63.26A16.3 16.3 0 0 0 152.12 29L112.84 4.92C98.51-3.87 80.09-.5 69 12a269.64 269.64 0 0 0 2.09 362.49c9.87 10.8 29.12 12.48 41.66 4.8l39.4-24.18A16.3 16.3 0 0 0 158.8 335zM480 384H192a64 64 0 0 0-64 64v32a32 32 0 0 0 32 32h352a32 32 0 0 0 32-32v-32a64 64 0 0 0-64-64zm-144 96a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm56-192h105.46l8.72-32H392a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8zm0-96h131.64l8.72-32H392a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8zm0-128a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h157.81l8.73-32z"]],
    "blind": [384, 512, [], "f29d", ["M380.15 510.84a8 8 0 0 1-11-2.68L243.83 301.72a31.91 31.91 0 0 0 13-9.48l126 207.61a8 8 0 0 1-2.68 11z", "M142.8 314.34l-32.54 89.48 36.12 88.29a32 32 0 0 0 59.24-24.23zM96 88a44 44 0 1 0-44-44 44 44 0 0 0 44 44zm154.84 169.13l-120-152A23.91 23.91 0 0 0 112 96H80a23.9 23.9 0 0 0-18.94 9.24L0 183.77v95.69c0 13.46 11 24.79 24.46 24.54A24 24 0 0 0 48 280v-79.77l16-20.57v140.7L9.93 469.05a32 32 0 0 0 59.91 22.51c.08-.21.16-.42.23-.63L136 309.64v-107.2l-31.41-39.82a4 4 0 0 1 6.27-5l102.3 129.22c9.15 11.59 24.37 11.34 33.71 4a24 24 0 0 0 4-33.71z"]],
    "blog": [512, 512, [], "f781", ["M511.9 303C503.4 139.82 372.2 8.62 209 0a16.1 16.1 0 0 0-17 16v31.6a15.84 15.84 0 0 0 15 15.9c129.4 7 233.4 112 240.9 241.5a16 16 0 0 0 15.9 15h32.1a16.1 16.1 0 0 0 16-17zM209.3 96a16.13 16.13 0 0 0-17.3 16.1v32.1a15.94 15.94 0 0 0 14.8 15.9c76.8 6.3 138 68.2 144.9 145.2a16.07 16.07 0 0 0 15.9 14.7h32.2a16.19 16.19 0 0 0 16.1-17.3C407.5 192.62 319.4 104.52 209.3 96z", "M172.2 226.82c75.5 15 129.9 89.3 112.5 172.2-11.4 54.3-55.3 98.3-109.7 109.7C82.1 528.22 0 457.52 0 368V120a23.94 23.94 0 0 1 24-24h48a23.94 23.94 0 0 1 24 24v248a48 48 0 1 0 64.7-45c-9.6-3.6-16.7-11.8-16.7-22v-50.4c0-14.9 13.6-26.7 28.2-23.8z"]],
    "bold": [384, 512, [], "f032", ["M32 32h32v80H32a16 16 0 0 1-16-16V48a16 16 0 0 1 16-16zm32 368v80H32a16 16 0 0 1-16-16v-48a16 16 0 0 1 16-16z", "M332.53 237.78c12.86-15.8 24.9-44.81 26.93-65C366.85 96.48 306.81 32 232 32H64v448h183.62C322.94 480 384 419.11 384 344a135.36 135.36 0 0 0-51.47-106.22zM144 112h88a48 48 0 1 1 0 96h-88zm88 288h-88V288h88a56 56 0 1 1 0 112z"]],
    "bolt": [320, 512, [], "f0e7", ["M224 24.19a23.89 23.89 0 0 1-.79 6L180.61 160l-37.9 128H24a24 24 0 0 1-24-24 24.45 24.45 0 0 1 .21-3.2l32-240A24 24 0 0 1 56 0h144a24.09 24.09 0 0 1 24 24.19z", "M319.93 184.07a23.93 23.93 0 0 1-3.22 11.93l-176 304a24 24 0 0 1-44.1-17.5l46.1-194.5 37.9-128H296a24 24 0 0 1 23.93 24.07z"]],
    "bomb": [512, 512, [], "f1e2", ["M500 60h-24a12 12 0 0 0 0 24h24a12 12 0 0 0 0-24zM440 0a12 12 0 0 0-12 12v24a12 12 0 0 0 24 0V12a12 12 0 0 0-12-12zm33.9 55l17-17a12 12 0 0 0-17-17l-17 17a12 12 0 0 0 17 17zm-67.8 0a12 12 0 0 0 17-17l-17-17a12 12 0 0 0-17 17zm67.8 34a12 12 0 0 0-17 17l17 17a12 12 0 0 0 17-17zm-102.5 34.5l17.1 17 52-52-17.1-17z", "M415 200.9a23.9 23.9 0 0 0 0-33.9l-70.1-70a23.9 23.9 0 0 0-33.9 0l-17.4 17.4A207.35 207.35 0 0 0 208 96C93.1 96 0 189.1 0 304s93.1 207.9 208 207.9 208-93.1 208-208a207.35 207.35 0 0 0-18.4-85.6zM176 208a64.06 64.06 0 0 0-64 64 16 16 0 0 1-32 0 96.15 96.15 0 0 1 96-96 16 16 0 0 1 0 32z"]],
    "bone": [640, 512, [], "f5d7", ["M598.88 244.56a12.79 12.79 0 0 0 0 22.88A74.38 74.38 0 0 1 640 334v7.64a74.38 74.38 0 0 1-145 23.5c-6.53-19.6-10.73-45.14-38.11-45.14H183.06c-26.51 0-30.43 22.11-38.11 45.14A74.38 74.38 0 0 1 0 341.61V334a74.39 74.39 0 0 1 41.12-66.53 12.79 12.79 0 0 0 0-22.88A74.39 74.39 0 0 1 0 178v-7.64a74.38 74.38 0 0 1 145-23.53c6.53 19.6 10.73 45.14 38.11 45.14h273.82c26.51 0 30.43-22.11 38.11-45.14a74.39 74.39 0 0 1 145 23.53V178a74.39 74.39 0 0 1-41.12 66.53z", ""]],
    "bone-break": [640, 512, [], "f5d8", ["M598.88 171.44A74.38 74.38 0 0 1 640 238v7.64a74.38 74.38 0 0 1-144.94 23.53l-7.75-23.26A32 32 0 0 0 457 224H352l32-64-32-64h105a32 32 0 0 0 30.36-21.88l7.75-23.26A74.38 74.38 0 0 1 640 74.39V82a74.39 74.39 0 0 1-41.12 66.53 12.79 12.79 0 0 0 0 22.91z", "M320 282.51L256 256l-26.5-64-63 63a32 32 0 0 1-36.94 6l-21.93-11a74.39 74.39 0 0 0-85.84 119.13l5.4 5.4a74.39 74.39 0 0 0 76.12 18 12.79 12.79 0 0 1 16.18 16.18 74.39 74.39 0 0 0 18 76.12l5.4 5.4A74.39 74.39 0 0 0 262 404.33l-11-21.93a32 32 0 0 1 6-36.94z"]],
    "bong": [448, 512, [], "f55c", ["M48 384c0-25.42 5.87-46.53 14.74-64h258.52c8.87 17.47 14.74 38.58 14.74 64a143 143 0 0 1-19.08 71.36A16.86 16.86 0 0 1 302.5 464h-221a16.86 16.86 0 0 1-14.42-8.64A143 143 0 0 1 48 384z", "M443.31 217.37l-52.69-52.69a16 16 0 0 0-22.63 0L356.68 176a16 16 0 0 0 0 22.63l9.38 9.38-39.41 39.41A193.53 193.53 0 0 0 288 217.9V63.74h16a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16L80 .26a16 16 0 0 0-16 16V48a16 16 0 0 0 16 16h16v153.89C38.67 251.1 0 313 0 384a190.15 190.15 0 0 0 25.5 95.34 64.77 64.77 0 0 0 56 32.66h221a64.75 64.75 0 0 0 56-32.66 191 191 0 0 0-1.94-194l43.44-43.4 9.38 9.38a16 16 0 0 0 22.63 0l11.3-11.32a16 16 0 0 0 0-22.63zm-126.39 238A16.86 16.86 0 0 1 302.5 464h-221a16.86 16.86 0 0 1-14.42-8.64A143 143 0 0 1 48 384c0-93.78 79.85-129.09 96-138.44V64.19h96v181.37c16.15 9.35 96 44.66 96 138.44a143 143 0 0 1-19.08 71.36z"]],
    "book": [448, 512, [], "f02d", ["M96 448c-19.2 0-32-12.8-32-32s16-32 32-32h319.33c-1.93 16.24-1.76 48.38.53 64z", "M96 384h328a24 24 0 0 0 24-24V32a32 32 0 0 0-32-32H96A96 96 0 0 0 0 96v320a96 96 0 0 0 96 96h328a24 24 0 0 0 24-24v-16a24 24 0 0 0-24-24H96c-19.2 0-32-12.8-32-32s16-32 32-32zm32-250a6 6 0 0 1 6-6h212a6 6 0 0 1 6 6v20a6 6 0 0 1-6 6H134a6 6 0 0 1-6-6zm0 64a6 6 0 0 1 6-6h212a6 6 0 0 1 6 6v20a6 6 0 0 1-6 6H134a6 6 0 0 1-6-6z"]],
    "book-alt": [448, 512, [], "f5d9", ["M96 448c-19.2 0-32-12.8-32-32s16-32 32-32h319.33c-1.93 16.24-1.76 48.38.53 64z", "M96 384h328a24 24 0 0 0 24-24V32a32 32 0 0 0-32-32H96A96 96 0 0 0 0 96v320a96 96 0 0 0 96 96h328a24 24 0 0 0 24-24v-16a24 24 0 0 0-24-24H96c-19.2 0-32-12.8-32-32s16-32 32-32z"]],
    "book-dead": [448, 512, [], "f6b7", ["M96 448c-19.2 0-32-12.8-32-32s16-32 32-32h319.33c-1.93 16.24-1.76 48.38.53 64z", "M208 136a16 16 0 1 0-16-16 16 16 0 0 0 16 16zM96 384h328a24 24 0 0 0 24-24V32a32 32 0 0 0-32-32H96A96 96 0 0 0 0 96v320a96 96 0 0 0 96 96h328a24 24 0 0 0 24-24v-16a24 24 0 0 0-24-24H96c-19.2 0-32-12.8-32-32s16-32 32-32zM240 56c44.2 0 80 28.7 80 64 0 20.9-12.7 39.2-32 50.9V184a16 16 0 0 1-16 16h-64a16 16 0 0 1-16-16v-13.1c-19.3-11.7-32-30-32-50.9 0-35.3 35.8-64 80-64zM124.8 223.3l6.3-14.7a8 8 0 0 1 10.5-4.2l98.3 42.1 98.4-42.1a8 8 0 0 1 10.5 4.2l6.3 14.7a8 8 0 0 1-4.2 10.5L280.6 264l70.3 30.1a8 8 0 0 1 4.2 10.5l-6.3 14.7a8 8 0 0 1-10.5 4.2L240 281.4l-98.3 42.2a8 8 0 0 1-10.5-4.2l-6.3-14.7a8 8 0 0 1 4.2-10.5l70.4-30.1-70.5-30.3a8 8 0 0 1-4.2-10.5zM272 136a16 16 0 1 0-16-16 16 16 0 0 0 16 16z"]],
    "book-heart": [448, 512, [], "f499", ["M96 448c-19.2 0-32-12.8-32-32s16-32 32-32h319.33c-1.93 16.24-1.76 48.38.53 64z", "M96 384h328a24 24 0 0 0 24-24V32a32 32 0 0 0-32-32H96A96 96 0 0 0 0 96v320a96 96 0 0 0 96 96h328a24 24 0 0 0 24-24v-16a24 24 0 0 0-24-24H96c-19.2 0-32-12.8-32-32s16-32 32-32zm53.8-274.9c24-20 59.7-16.4 81.6 5.8l8.6 8.7 8.6-8.7c22-22.2 57.7-25.8 81.6-5.8a60.65 60.65 0 0 1 4.3 89.1l-84.7 85.6a13.94 13.94 0 0 1-19.8 0l-84.7-85.6a60.74 60.74 0 0 1 4.5-89.1z"]],
    "book-medical": [448, 512, [], "f7e6", ["M96 448c-19.2 0-32-12.8-32-32s16-32 32-32h319.33c-1.93 16.24-1.76 48.38.53 64z", "M96 384h328a24 24 0 0 0 24-24V32a32 32 0 0 0-32-32H96A96 96 0 0 0 0 96v320a96 96 0 0 0 96 96h328a24 24 0 0 0 24-24v-16a24 24 0 0 0-24-24H96c-19.2 0-32-12.8-32-32s16-32 32-32zm48-216a8 8 0 0 1 8-8h56v-56a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8v56h56a8 8 0 0 1 8 8v48a8 8 0 0 1-8 8h-56v56a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-56h-56a8 8 0 0 1-8-8z"]],
    "book-open": [576, 512, [], "f518", ["M576 62.75v337.84c0 16.23-13.13 29.77-30 30.66-49.47 2.6-149.52 12.1-218.7 46.92-10.65 5.36-23.28-1.94-23.28-13.49V100.81a15.37 15.37 0 0 1 7.27-13.17c67.24-41.16 176.16-52.48 231-55.59C560.64 31 576 45 576 62.75z", "M264.73 87.64C197.5 46.48 88.58 35.17 33.78 32.05 15.36 31 0 45 0 62.75V400.6c0 16.24 13.13 29.78 30 30.66 49.49 2.6 149.59 12.11 218.77 46.95 10.62 5.35 23.21-1.94 23.21-13.46V100.63a15.05 15.05 0 0 0-7.25-12.99z"]],
    "book-reader": [512, 512, [], "f5da", ["M256 192a96 96 0 1 1 96-96 96 96 0 0 1-96 96z", "M233.59 241.1c-59.33-36.32-155.43-46.3-203.79-49C13.55 191.13 0 203.51 0 219.14v222.8c0 14.33 11.59 26.28 26.49 27.06 43.66 2.29 132 10.68 193 41.43 9.37 4.72 20.48-1.71 20.48-11.87v-246a13.31 13.31 0 0 0-6.38-11.46zm248.61-49c-48.35 2.74-144.46 12.73-203.78 49a13.56 13.56 0 0 0-6.42 11.63v245.79c0 10.19 11.14 16.63 20.54 11.9 61-30.72 149.32-39.11 193-41.4C500.42 468.24 512 456.29 512 442V219.14c0-15.63-13.55-28.01-29.8-27.09z"]],
    "book-spells": [448, 512, [], "f6b8", ["M96 448c-19.2 0-32-12.8-32-32s16-32 32-32h319.33c-1.93 16.24-1.76 48.38.53 64z", "M96 384h328a24 24 0 0 0 24-24V32a32 32 0 0 0-32-32H96A96 96 0 0 0 0 96v320a96 96 0 0 0 96 96h328a24 24 0 0 0 24-24v-16a24 24 0 0 0-24-24H96c-19.2 0-32-12.8-32-32s16-32 32-32zm176-224l26.66 53.33L352 240l-53.34 26.67L272 320l-26.66-53.33L192 240l53.34-26.67zM160 96l16-32 16 32 32 16-32 16-16 32-16-32-32-16z"]],
    "book-user": [448, 512, [], "f7e7", ["M96 448c-19.2 0-32-12.8-32-32s16-32 32-32h319.33c-1.93 16.24-1.76 48.38.53 64z", "M96 384h328a24 24 0 0 0 24-24V32a32 32 0 0 0-32-32H96A96 96 0 0 0 0 96v320a96 96 0 0 0 96 96h328a24 24 0 0 0 24-24v-16a24 24 0 0 0-24-24H96c-19.2 0-32-12.8-32-32s16-32 32-32zM240 64a64 64 0 1 1-64 64 64 64 0 0 1 64-64zM128 281.6c0-31.81 30.09-57.6 67.2-57.6h5a103.22 103.22 0 0 0 79.7 0h5c37.11 0 67.2 25.79 67.2 57.6v19.2c0 10.61-10 19.2-22.4 19.2H150.4c-12.4 0-22.4-8.6-22.4-19.2z"]],
    "bookmark": [384, 512, [], "f02e", ["M384 48v464L192 400 0 512V48A48 48 0 0 1 48 0h32v326.11a16 16 0 0 0 23.16 14.31L192 296l88.84 44.42A16 16 0 0 0 304 326.11V0h32a48 48 0 0 1 48 48z", "M304 0v326.11a16 16 0 0 1-23.16 14.31L192 296l-88.84 44.42A16 16 0 0 1 80 326.11V0z"]],
    "books": [576, 512, [], "f5db", ["M96 0H32A32 32 0 0 0 0 32v64h128V32A32 32 0 0 0 96 0zM0 384h128V128H0zm0 96a32 32 0 0 0 32 32h64a32 32 0 0 0 32-32v-64H0zm513.62-17.78L401.08 42.71l-60.26 16.14 112.35 418.8c.11.39.2.79.29 1.18l60.29-16.15c-.04-.15-.09-.3-.13-.46zM160 480a32 32 0 0 0 32 32h64a32 32 0 0 0 32-32v-64H160zM256 0h-64a32 32 0 0 0-32 32v64h124.79l-8-29.65a23.94 23.94 0 0 1 11.17-27V32A32 32 0 0 0 256 0zm-96 384h128V128H160z", "M0 416h128v-32H0zm0-288h128V96H0zm575.17 317.65L460.39 17.78a23.89 23.89 0 0 0-29.18-17h-.09L415.73 5a24 24 0 0 0-16.9 29.36l114.79 427.86a23.89 23.89 0 0 0 29.18 17h.09l15.38-4.22a24 24 0 0 0 16.9-29.35zM160 416h128v-32H160zM338.39 49.78a23.89 23.89 0 0 0-29.18-17h-.09L293.73 37a24 24 0 0 0-16.9 29.36l8 29.65H160v32h128V108l103.62 386.22a23.89 23.89 0 0 0 29.18 17h.09l15.38-4.22a24 24 0 0 0 16.9-29.33z"]],
    "books-medical": [640, 512, [], "f7e8", ["M160 0H96a32 32 0 0 0-32 32v76.33a160.25 160.25 0 0 1 128 0V32a32 32 0 0 0-32-32zm64 480a32 32 0 0 0 32 32h64a32 32 0 0 0 32-32v-64H224zm353.62-17.78L465.08 42.71l-60.26 16.14 112.35 418.8c.11.39.2.79.29 1.18l60.29-16.15c-.04-.15-.09-.3-.13-.46zM64 401.68V480a32 32 0 0 0 32 32h64a32 32 0 0 0 32-32v-78.32a160.33 160.33 0 0 1-128 0zm191-49.36A160.35 160.35 0 0 1 224 383v1h128V127.84l-126.7.16A160 160 0 0 1 255 352.32zM320 0h-64a32 32 0 0 0-32 32v64h124.79l-8-29.65a23.94 23.94 0 0 1 11.17-27V32A32 32 0 0 0 320 0z", "M128 127a128 128 0 1 0 128 128 128 128 0 0 0-128-128zm64 144a5.33 5.33 0 0 1-5.33 5.33h-37.34v37.34A5.33 5.33 0 0 1 144 319h-32a5.33 5.33 0 0 1-5.33-5.33v-37.33H69.33A5.33 5.33 0 0 1 64 271v-32a5.33 5.33 0 0 1 5.33-5.33h37.34v-37.33A5.33 5.33 0 0 1 112 191h32a5.33 5.33 0 0 1 5.33 5.33v37.34h37.34A5.33 5.33 0 0 1 192 239zM402.39 49.78a23.89 23.89 0 0 0-29.18-17h-.09L357.73 37a24 24 0 0 0-16.9 29.36l8 29.65H224v32h128V108l103.62 386.22a23.89 23.89 0 0 0 29.18 17h.09l15.38-4.22a24 24 0 0 0 16.9-29.33zm236.78 395.87L524.39 17.78a23.89 23.89 0 0 0-29.18-17h-.09L479.73 5a24 24 0 0 0-16.9 29.36l114.79 427.86a23.89 23.89 0 0 0 29.18 17h.09l15.38-4.22a24 24 0 0 0 16.9-29.35zM224 416h128v-32H224z"]],
    "boombox": [640, 512, [], "f8a5", ["M592 160H48a48 48 0 0 0-48 48v256a48 48 0 0 0 48 48h544a48 48 0 0 0 48-48V208a48 48 0 0 0-48-48zM176 448a112 112 0 1 1 112-112 112.12 112.12 0 0 1-112 112zm288 0a112 112 0 1 1 112-112 112.12 112.12 0 0 1-112 112z", "M552 0H88a56.07 56.07 0 0 0-56 56v106.94A47.5 47.5 0 0 1 48 160h32V56a8 8 0 0 1 8-8h464a8 8 0 0 1 8 8v104h32a47.5 47.5 0 0 1 16 2.94V56a56.06 56.06 0 0 0-56-56zM256 144a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v16h64zm192 0a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v16h64zm-96 0a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v16h64zm112 80a112 112 0 1 0 112 112 112.12 112.12 0 0 0-112-112zm0 176a64 64 0 1 1 64-64 64.07 64.07 0 0 1-64 64zM176 224a112 112 0 1 0 112 112 112.12 112.12 0 0 0-112-112zm0 176a64 64 0 1 1 64-64 64.07 64.07 0 0 1-64 64z"]],
    "boot": [512, 512, [], "f782", ["M0 448v32l32 32h64l32-32 32 32h64l32-32 32 32h64l32-32 32 32h64l32-32v-32zM352 80V16a16 16 0 0 0-16-16H16A16 16 0 0 0 0 16v80h336a16 16 0 0 0 16-16z", "M439.3 285.8L320 256h-56a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h56v-32h-56a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h56v-32H0v288h512v-37a96.07 96.07 0 0 0-72.7-93.2z"]],
    "booth-curtain": [512, 512, [], "f734", ["M480 0h-32v496a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V32a32 32 0 0 0-32-32zM0 32v464a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V64h32V0H32A32 32 0 0 0 0 32z", "M416 0v400a48 48 0 0 1-84.7 31 15.07 15.07 0 0 0-22.6 0 48.11 48.11 0 0 1-73.4 0 15.07 15.07 0 0 0-22.6 0 48 48 0 0 1-84.7-31V0z"]],
    "border-all": [448, 512, [], "f84c", ["M384 288H256v128h-64V288H64v-64h128V96h64v128h128z", "M416 32H32A32 32 0 0 0 0 64v384a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32V64a32 32 0 0 0-32-32zm-32 384H64V96h320z"]],
    "border-bottom": [448, 512, [], "f84d", ["M208 288h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm96 0h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm128-64h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-320 64h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm320 32h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-192h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM208 384h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm0-192h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm0-96h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm96 0h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm128-64h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zM16 288h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm0 96h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm0-192h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm0-96h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16H16A16 16 0 0 0 0 48v32a16 16 0 0 0 16 16zm96 0h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16z", "M432 416H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "border-center-h": [448, 512, [], "f89c", ["M208 480h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm96 0h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm128-64h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-320 64h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm320-160h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-192h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM208 384h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm0-192h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm0-96h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm96 0h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm128-64h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zM16 480h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm0-96h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm0-192h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm0-96h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16H16A16 16 0 0 0 0 48v32a16 16 0 0 0 16 16zm96 0h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16z", "M448 240v32a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h416a16 16 0 0 1 16 16z"]],
    "border-center-v": [448, 512, [], "f89d", ["M0 240v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16zm0 96v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16zm64 128v-32a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16zM0 144v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16zm160 320v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16zm192 0v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16zM96 240v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16zm192 0v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16zm96 0v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16zm0 96v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16zm64 128v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16zM0 48v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16H16A16 16 0 0 0 0 48zm96 0v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16zm192 0v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16zm96 0v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16zm0 96v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16z", "M256 48v416a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V48a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16z"]],
    "border-inner": [448, 512, [], "f84e", ["M48 416H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM16 192h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm288-96h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zM48 320H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm64-224h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm-96 0h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16H16A16 16 0 0 0 0 48v32a16 16 0 0 0 16 16zm320 320h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96-288h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-96h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zM144 416h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm288-96h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0 96h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M432 224H256V48a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v176H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h176v176a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V288h176a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "border-left": [448, 512, [], "f84f", ["M240 224h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-288 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96 192h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-96h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-192h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM240 320h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-192h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-96 288h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96-384h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm-288 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z", "M48 32H16A16 16 0 0 0 0 48v416a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z"]],
    "border-none": [448, 512, [], "f850", ["M240 224h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-288 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96 192h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-96h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-192h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM240 320h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-192h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-96 288h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96-384h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zM48 224H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0 192H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-96H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-192H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-96H16A16 16 0 0 0 0 48v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z", ""]],
    "border-outer": [448, 512, [], "f851", ["M208 288h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm96 0h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm-192 0h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm96 96h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm0-192h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16z", "M416 32H32A32 32 0 0 0 0 64v384a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32V64a32 32 0 0 0-32-32zm-32 384H64V96h320z"]],
    "border-right": [448, 512, [], "f852", ["M240 224h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-192 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96 192h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-96-96h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-192h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-96 288h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96-384h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zM48 224H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0 192H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-96H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-192H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-96H16A16 16 0 0 0 0 48v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z", "M432 32h-32a16 16 0 0 0-16 16v416a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z"]],
    "border-style": [448, 512, [], "f853", ["M240 416h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm192 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96-192h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0 96h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0 96h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-288h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M432 32H32A32 32 0 0 0 0 64v400a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V96h368a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z"]],
    "border-style-alt": [448, 512, [], "f854", ["M208 96h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm96 0h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm-192 0h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zM16 288h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm0-96h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm0-96h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16H16A16 16 0 0 0 0 48v32a16 16 0 0 0 16 16zm0 288h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16z", "M432 32h-32a16 16 0 0 0-16 16v368H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h400a32 32 0 0 0 32-32V48a16 16 0 0 0-16-16z"]],
    "border-top": [448, 512, [], "f855", ["M240 224h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-288 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96 192h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96 0h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-96h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-192h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM240 320h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-192h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-96 288h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM48 224H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0 192H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-96H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-192H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M432 32H16A16 16 0 0 0 0 48v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z"]],
    "bow-arrow": [512, 512, [], "f6b9", ["M282.33 150.47l46.61-46.61a255.3 255.3 0 0 0-275.1.73l-3.9-3.9a16 16 0 0 0-22.63 0L4.69 123.31a16 16 0 0 0 0 22.63L145.78 287 191 241.78l-90.54-90.58a192.49 192.49 0 0 1 181.87-.73zm125.08 307a255.3 255.3 0 0 0 .73-275.1L361.53 229a192.51 192.51 0 0 1-.73 181.88l-90.58-90.58L225 365.56l141.72 141.76a16 16 0 0 0 22.63 0L412 484.69a16 16 0 0 0 0-22.63z", "M511.71 18.78L486 147.37a15.7 15.7 0 0 1-26.49 8L425 120.92 174.39 371.56l16.61 49.7a20.56 20.56 0 0 1-5 21L122.32 506a20.56 20.56 0 0 1-34-8l-18.59-55.72-55.66-18.55a20.56 20.56 0 0 1-8-34L69.7 326a20.58 20.58 0 0 1 21-5l49.7 16.57L391.08 87l-34.47-34.48a15.7 15.7 0 0 1 8-26.49L493.22.31a15.72 15.72 0 0 1 18.49 18.47z"]],
    "bowling-ball": [496, 512, [], "f436", ["M232,240a32,32,0,1,1,32-32A32,32,0,0,1,232,240ZM216,64a32,32,0,1,0,32,32A32,32,0,0,0,216,64ZM120,192a32,32,0,1,0-32-32A32,32,0,0,0,120,192Z", "M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8ZM120,192a32,32,0,1,1,32-32A32,32,0,0,1,120,192Zm64-96a32,32,0,1,1,32,32A32,32,0,0,1,184,96Zm48,144a32,32,0,1,1,32-32A32,32,0,0,1,232,240Z"]],
    "bowling-pins": [448, 512, [], "f437", ["M133.17 160c.8-35.8 20.9-59.1 18.8-96C150.07 29.8 129.27.1 96 0 62.6.1 41.9 29.8 40 64c-2.1 36.9 18 60.2 18.8 96zm181.6 0h74.4c.8-35.7 20.9-59.1 18.8-96-1.9-34.3-22.6-63.9-56-64-33.3.1-54.1 29.8-56 64-2.1 36.9 18 60.2 18.8 96zm128.9 160c-10.8-48.1-39.9-82.8-50.7-128h-81.9c-10.8 45.2-39.9 79.9-50.7 128-11.5 51.1.6 140.5 26.7 192h130c26-51.5 38-141 26.6-192zm-306.8-128h-81.8c-10.8 45.2-40 79.9-50.7 128-11.5 51.1.5 140.5 26.6 192H161c26.1-51.5 38.1-140.9 26.7-192-10.83-48.1-40.03-82.8-50.83-128z", "M59 160l-4 32h82l-4-32zm330 0h-74l-4 32h82z"]],
    "box": [512, 512, [], "f466", ["M512 224v240a48 48 0 0 1-48 48H48a48 48 0 0 1-48-48V224z", "M53.1 32.8L2.5 184.6c-.8 2.4-.8 4.9-1.2 7.4H240V0H98.6a47.87 47.87 0 0 0-45.5 32.8zm456.4 151.8L458.9 32.8A47.87 47.87 0 0 0 413.4 0H272v192h238.7c-.4-2.5-.4-5-1.2-7.4z"]],
    "box-alt": [448, 512, [], "f49a", ["M256 32l32 128v112a16 16 0 0 1-16 16h-96a16 16 0 0 1-16-16V160l32-128z", "M446.7 160c.4-.5.5-.7.9-1.2L391.3 53.9A32 32 0 0 0 360.9 32H256l32 128zM160 160l32-128H87.1a32 32 0 0 0-30.4 21.9L.4 158.8c.4.5.5.7.9 1.2zm128 32v80a16 16 0 0 1-16 16h-96a16 16 0 0 1-16-16v-80H0v256a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32V192z"]],
    "box-ballot": [576, 512, [], "f735", ["M144 192l-.5-175.8A16.2 16.2 0 0 1 159.7 0l255.8.6a16 16 0 0 1 16 16L432 192z", "M0 320v160a32 32 0 0 0 32 32h512a32 32 0 0 0 32-32V320zm574.7-32a8.34 8.34 0 0 0 .8-1.2L520 148.2a32.07 32.07 0 0 0-29.7-20.1h-26.6l.2 64 16 32H95.5l16-32h.5l-.2-64H85.7A32.07 32.07 0 0 0 56 148.2L.4 286.8c.3.5.5.7.8 1.2z"]],
    "box-check": [640, 512, [], "f467", ["M448 128c-106 0-192 86-192 192s86 192 192 192 192-86 192-192-86-192-192-192zm114.1 147.8l-131 130a11 11 0 0 1-15.6-.1l-75.7-76.3a11 11 0 0 1 .1-15.6l26-25.8a11 11 0 0 1 15.6.1l42.1 42.5 97.2-96.4a11 11 0 0 1 15.6.1l25.8 26a11 11 0 0 1-.1 15.5z", "M240 0H98.6a47.87 47.87 0 0 0-45.5 32.8L2.5 184.6c-.8 2.4-.8 4.9-1.2 7.4H240zm208 80a221.93 221.93 0 0 1 27.2 1.7l-16.3-48.8A47.83 47.83 0 0 0 413.4 0H272v157.4C315.9 109.9 378.4 80 448 80zM208 320a238.53 238.53 0 0 1 20.2-96H0v240a48 48 0 0 0 48 48h256.6C246.1 468.2 208 398.6 208 320zm354.2-59.7l-25.8-26a11 11 0 0 0-15.6-.1l-97.2 96.4-42.1-42.5a11 11 0 0 0-15.6-.1l-26 25.8a11 11 0 0 0-.1 15.6l75.7 76.3a11 11 0 0 0 15.6.1l131-130a11 11 0 0 0 .1-15.5z"]],
    "box-fragile": [448, 512, [], "f49b", ["M416 32H32A32 32 0 0 0 0 64v384a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32V64a32 32 0 0 0-32-32zm-96 160c0 47.5-34.6 86.7-80 94.4V384h40a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8H168a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h40v-97.6a95.78 95.78 0 0 1-80-94.4v-80a16 16 0 0 1 16-16h160a16 16 0 0 1 16 16z", "M320 192c0 47.5-34.6 86.7-80 94.4V384h40a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8H168a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h40v-97.6a95.78 95.78 0 0 1-80-94.4v-80a16 16 0 0 1 16-16h60.4l24.5 27.6-64 32 91 68.4-37-59.6 64-32L260.1 96H304a16 16 0 0 1 16 16z"]],
    "box-full": [640, 512, [], "f49c", ["M439 382.1L576 343v82a32.07 32.07 0 0 1-24.2 31l-216.4 54.1a65 65 0 0 1-31 0L88.24 456A31.9 31.9 0 0 1 64 425v-82l137.1 39.2c28.6 8.2 48.3-10.9 54.7-21.6L320 254l64.3 106.6c6.54 10.8 26.24 29.7 54.7 21.5z", "M194.24 143.7A63.28 63.28 0 0 1 192 128a64 64 0 1 1 128 0 62.84 62.84 0 0 1-8.2 30.7l8.2 1L475.34 140 511 41.7a16 16 0 0 0-9.6-20.5L445.94 1a16 16 0 0 0-20.5 9.6L383.74 125C382 55.7 325.74 0 256 0a128 128 0 0 0-128 128c0 2.5.6 4.9.7 7.4zm444.1 128.1L586.84 169a16.33 16.33 0 0 0-16.7-8.9L320 192l91.7 152.1a16.44 16.44 0 0 0 18.5 7.3l197.9-56.5a16.47 16.47 0 0 0 10.24-23.1zM53.24 169L1.74 271.8a16.3 16.3 0 0 0 10.1 23l197.9 56.5a16.44 16.44 0 0 0 18.5-7.3L320 192 69.84 160.1a16.34 16.34 0 0 0-16.6 8.9z"]],
    "box-heart": [448, 512, [], "f49d", ["M0 192v256a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32V192zm305.1 149.2l-72.6 71.4a12.2 12.2 0 0 1-17 0l-72.6-71.4a49.59 49.59 0 0 1 3.7-74.2c20.5-16.7 51.1-13.7 70 4.8l7.4 7.3 7.4-7.3c18.8-18.5 49.4-21.5 70-4.8a49.66 49.66 0 0 1 3.7 74.2z", "M301.4 267c-20.6-16.7-51.2-13.7-70 4.8l-7.4 7.3-7.4-7.3c-18.9-18.5-49.5-21.5-70-4.8a49.59 49.59 0 0 0-3.7 74.2l72.6 71.4a12.2 12.2 0 0 0 17 0l72.6-71.4a49.66 49.66 0 0 0-3.7-74.2zm89.9-213.1A32 32 0 0 0 360.9 32H240v128h206.7c.4-.5.5-.7.9-1.2zM208 32H87.1a32 32 0 0 0-30.4 21.9L.4 158.8c.4.5.5.7.9 1.2H208z"]],
    "box-open": [640, 512, [], "f49e", ["M439 254.14L576 215v178a32.07 32.07 0 0 1-24.2 31l-216.4 54.1a65 65 0 0 1-31 0L88.24 424A31.9 31.9 0 0 1 64 393V215l137 39.2a46 46 0 0 0 13.3 1.9 48.64 48.64 0 0 0 41.5-23.5L320 126l64.3 106.6a48.47 48.47 0 0 0 41.4 23.4 46 46 0 0 0 13.3-1.86z", "M638.34 143.84L586.84 41a16.33 16.33 0 0 0-16.7-8.9L320 64l91.7 152.1a16.44 16.44 0 0 0 18.5 7.3l197.9-56.5a16.47 16.47 0 0 0 10.24-23.06zM53.24 41L1.74 143.84a16.3 16.3 0 0 0 10.1 23l197.9 56.5a16.44 16.44 0 0 0 18.5-7.3L320 64 69.84 32.14A16.34 16.34 0 0 0 53.24 41z"]],
    "box-up": [448, 512, [], "f49f", ["M416 32H32A32 32 0 0 0 0 64v384a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32V64a32 32 0 0 0-32-32zM57.8 179l64-80a8.28 8.28 0 0 1 12.5 0l64 80a8 8 0 0 1-6.2 13h-32v112a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V192H64a8 8 0 0 1-6.2-13zM384 408a8 8 0 0 1-8 8H72a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h304a8 8 0 0 1 8 8zm0-216h-32v112a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V192h-32a8 8 0 0 1-6.2-13l64-80a8.28 8.28 0 0 1 12.5 0l64 80a8.05 8.05 0 0 1-6.3 13z", "M134.3 99a8.28 8.28 0 0 0-12.5 0l-64 80a8 8 0 0 0 6.2 13h32.1v112a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V192h32a8 8 0 0 0 6.2-13zm256 80l-64-80a8.28 8.28 0 0 0-12.5 0l-64 80a8 8 0 0 0 6.2 13h32v112a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V192h32a8.05 8.05 0 0 0 6.3-13z"]],
    "box-usd": [448, 512, [], "f4a0", ["M0 192v256a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32V192zm240 223.9V432a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-16.3a57.66 57.66 0 0 1-31.4-11.3 8 8 0 0 1-.6-12.1l11.8-11.2a8.13 8.13 0 0 1 10.1-.7 24.4 24.4 0 0 0 12.8 3.7h28.1c6.5 0 11.8-5.9 11.8-13.2 0-6-3.6-11.2-8.8-12.7l-45-13.5c-18.6-5.6-31.6-23.4-31.6-43.4 0-24.5 19-44.4 42.7-45.1V240a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v16.3a57.66 57.66 0 0 1 31.4 11.3 8 8 0 0 1 .6 12.1L260.2 291a8.13 8.13 0 0 1-10.1.7 24.4 24.4 0 0 0-12.8-3.7h-28.1c-6.5 0-11.8 5.9-11.8 13.2 0 6 3.6 11.2 8.8 12.7l45 13.5c18.6 5.6 31.6 23.4 31.6 43.4-.1 24.5-19.2 44.5-42.8 45.1z", "M208 32H87.1a32 32 0 0 0-30.4 21.9L.4 158.8c.4.5.5.7.9 1.2H208zm43.2 295.4l-45-13.5c-5.2-1.5-8.8-6.7-8.8-12.7 0-7.3 5.3-13.2 11.8-13.2h28.1a24.4 24.4 0 0 1 12.8 3.7 8.13 8.13 0 0 0 10.1-.7l11.7-11.3a8 8 0 0 0-.6-12.1 57.66 57.66 0 0 0-31.4-11.3V240a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v16.2c-23.7.7-42.7 20.6-42.7 45.1 0 20 13 37.8 31.6 43.4l45 13.5c5.2 1.5 8.8 6.7 8.8 12.7 0 7.3-5.3 13.2-11.8 13.2h-28.1a24.4 24.4 0 0 1-12.8-3.7 8.13 8.13 0 0 0-10.1.7L176 392.3a8 8 0 0 0 .6 12.1 57.66 57.66 0 0 0 31.4 11.3V432a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-16.1c23.6-.6 42.7-20.6 42.8-45.1 0-20-13-37.8-31.6-43.4zM391.3 53.9A32 32 0 0 0 360.9 32H240v128h206.7c.4-.5.5-.7.9-1.2z"]],
    "boxes": [576, 512, [], "f468", ["M480 288v96l-32-21.3-32 21.3v-96zM320 0v96l-32-21.3L256 96V0zM160 288v96l-32-21.3L96 384v-96z", "M560 288h-80v96l-32-21.3-32 21.3v-96h-80a16 16 0 0 0-16 16v192a16 16 0 0 0 16 16h224a16 16 0 0 0 16-16V304a16 16 0 0 0-16-16zm-384-64h224a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-80v96l-32-21.3L256 96V0h-80a16 16 0 0 0-16 16v192a16 16 0 0 0 16 16zm64 64h-80v96l-32-21.3L96 384v-96H16a16 16 0 0 0-16 16v192a16 16 0 0 0 16 16h224a16 16 0 0 0 16-16V304a16 16 0 0 0-16-16z"]],
    "boxes-alt": [576, 512, [], "f4a1", ["M320 0v88a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8V0zm160 288v88a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-88zm-320 0v88a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-88z", "M176 224h224a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-80v88a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8V0h-80a16 16 0 0 0-16 16v192a16 16 0 0 0 16 16zm384 64h-80v88a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-88h-80a16 16 0 0 0-16 16v192a16 16 0 0 0 16 16h224a16 16 0 0 0 16-16V304a16 16 0 0 0-16-16zm-320 0h-80v88a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-88H16a16 16 0 0 0-16 16v192a16 16 0 0 0 16 16h224a16 16 0 0 0 16-16V304a16 16 0 0 0-16-16z"]],
    "boxing-glove": [448, 512, [], "f438", ["M352 400v80a32 32 0 0 1-32 32H64a32 32 0 0 1-32-32v-80h133.3l-40.5 30.4a8.09 8.09 0 0 0-1.6 11.2l9.6 12.8A8 8 0 0 0 144 456l48-36 48 36a8 8 0 0 0 11.2-1.6l9.6-12.8a8.08 8.08 0 0 0-1.6-11.2L218.7 400z", "M15.8 286.7A1161.36 1161.36 0 0 1 0 95.9C0 43.1 43.3 0 96 0h192a96 96 0 0 1 96 96v32.2c-29.1 0-67.6-5.6-96 32.5v-.5H141.2a92.8 92.8 0 0 1-60.5-22.3 8 8 0 0 0-10.9.4l-11.3 11.3a8 8 0 0 0 .4 11.7 124.45 124.45 0 0 0 82.3 30.8h132.5a84.28 84.28 0 0 0-1.6 16 80.12 80.12 0 0 0 71.2 79.5 8 8 0 0 0 8.8-8v-16a8.17 8.17 0 0 0-6.9-8.1 47.9 47.9 0 0 1-41.1-48.4c.5-26.3 22.5-47.1 48.8-47.1H384a64.06 64.06 0 0 1 64 64c0 13.8 2.8 61.1-37.5 101.5L352 384v16H218.7l40.5-30.4a8.09 8.09 0 0 0 1.6-11.2l-9.6-12.8A8 8 0 0 0 240 344l-48 36-48-36a8 8 0 0 0-11.2 1.6l-9.6 12.8a8 8 0 0 0 1.6 11.2l40.5 30.4H32v-16z"]],
    "brackets": [448, 512, [], "f7e9", ["M448 64v384a32 32 0 0 1-32 32H304a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h80V96h-80a16 16 0 0 1-16-16V48a16 16 0 0 1 16-16h112a32 32 0 0 1 32 32z", "M144 32H32A32 32 0 0 0 0 64v384a32 32 0 0 0 32 32h112a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H64V96h80a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z"]],
    "brackets-curly": [576, 512, [], "f7ea", ["M566.64 233.37a32 32 0 0 1 0 45.25l-45.25 45.25a32 32 0 0 0-9.39 22.64V384a96 96 0 0 1-96 96h-48a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h48a32 32 0 0 0 32-32v-37.48a96 96 0 0 1 28.13-67.89L498.76 256l-22.62-22.62A96 96 0 0 1 448 165.47V128a32 32 0 0 0-32-32h-48a16 16 0 0 1-16-16V48a16 16 0 0 1 16-16h48a96 96 0 0 1 96 96v37.48a32 32 0 0 0 9.38 22.65l45.25 45.24z", "M208 32h-48a96 96 0 0 0-96 96v37.48a32.12 32.12 0 0 1-9.38 22.65L9.38 233.37a32 32 0 0 0 0 45.25l45.25 45.25A32.05 32.05 0 0 1 64 346.51V384a96 96 0 0 0 96 96h48a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-48a32 32 0 0 1-32-32v-37.48a96 96 0 0 0-28.13-67.89L77.26 256l22.63-22.63A96 96 0 0 0 128 165.48V128a32 32 0 0 1 32-32h48a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z"]],
    "braille": [640, 512, [], "f2a1", ["M64 400a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm160-160a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm0 160a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm224-160a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm0 160a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm160-160a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm0 160a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm0-256a32 32 0 1 0-32-32 32 32 0 0 0 32 32z", "M64 208a64 64 0 1 0 64 64 64 64 0 0 0-64-64zm0-160a64 64 0 1 0 64 64 64 64 0 0 0-64-64zm160 0a64 64 0 1 0 64 64 64 64 0 0 0-64-64zm224 0a64 64 0 1 0 64 64 64 64 0 0 0-64-64z"]],
    "brain": [576, 512, [], "f5dc", ["M272 439.93a71.81 71.81 0 0 1-140 22.78 70.91 70.91 0 0 1-84-70.77 72.51 72.51 0 0 1 1.42-14.1A80 80 0 0 1 0 304c0-29.66 16.34-55.26 40.34-69.07A79.05 79.05 0 0 1 32 200a80 80 0 0 1 49.66-74A63.6 63.6 0 0 1 144 48c.75 0 1.45.2 2.2.22A63.87 63.87 0 0 1 272 64zM576 304c0-29.66-16.34-55.26-40.34-69.07A79.05 79.05 0 0 0 544 200a80 80 0 0 0-49.66-74A63.6 63.6 0 0 0 432 48c-.75 0-1.45.2-2.2.22A63.87 63.87 0 0 0 304 64v375.9a71.81 71.81 0 0 0 140 22.78 71.73 71.73 0 0 0 82.61-84.87A80 80 0 0 0 576 304z", "M304 439.93a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8V72a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8z"]],
    "bread-loaf": [640, 512, [], "f7eb", ["M420 256h-4v192a32 32 0 0 1-32 32H96a32 32 0 0 1-32-32V256h-4c-33.14 0-60-28.65-60-64C0 103.63 107.45 32 240 32s240 71.63 240 160c0 35.35-26.86 64-60 64z", "M640 192c0 35.35-26.86 64-60 64h-4v192a32 32 0 0 1-32 32H439.1a63.25 63.25 0 0 0 8.9-32V283.46c37.08-12.4 64-48.71 64-91.46 0-67.38-46.8-125.61-119.19-159.76 2.41 0 4.76-.24 7.19-.24 132.55 0 240 71.63 240 160z"]],
    "bread-slice": [576, 512, [], "f7ec", ["M288 0C108 0 0 93.4 0 169.14 0 199.44 24.24 224 64 224v256c0 17.67 16.12 32 36 32h376c19.88 0 36-14.33 36-32V224c39.76 0 64-24.56 64-54.86C576 93.4 468 0 288 0zM152 448a24 24 0 1 1 24-24 24 24 0 0 1-24 24zm0-96a24 24 0 1 1 24-24 24 24 0 0 1-24 24zm96 96a24 24 0 1 1 24-24 24 24 0 0 1-24 24z", "M152 400a24 24 0 1 0 24 24 24 24 0 0 0-24-24zm0-96a24 24 0 1 0 24 24 24 24 0 0 0-24-24zm96 96a24 24 0 1 0 24 24 24 24 0 0 0-24-24z"]],
    "briefcase": [512, 512, [], "f0b1", ["M320 288h192v144c0 25.6-22.4 48-48 48H48c-25.6 0-48-22.4-48-48V288h192v48a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16z", "M464 128h-80V80c0-25.6-22.4-48-48-48H176c-25.6 0-48 22.4-48 48v48H48c-25.6 0-48 22.4-48 48v80h512v-80c0-25.6-22.4-48-48-48zm-144 0H192V96h128z"]],
    "briefcase-medical": [512, 512, [], "f469", ["M192 128h-64V80a48 48 0 0 1 48-48h160a48 48 0 0 1 48 48v48h-64V96H192z", "M464 128H48a48 48 0 0 0-48 48v288a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V176a48 48 0 0 0-48-48zM352 344a8 8 0 0 1-8 8h-56v56a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-56h-56a8 8 0 0 1-8-8v-48a8 8 0 0 1 8-8h56v-56a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8v56h56a8 8 0 0 1 8 8z"]],
    "bring-forward": [512, 512, [], "f856", ["M512 208v256a48 48 0 0 1-48 48H208a48 48 0 0 1-48-48V352h64v96h224V224h-96v-64h112a48 48 0 0 1 48 48z", "M304 352H48a48 48 0 0 1-48-48V48A48 48 0 0 1 48 0h256a48 48 0 0 1 48 48v256a48 48 0 0 1-48 48z"]],
    "bring-front": [640, 512, [], "f857", ["M224 0H32A32 32 0 0 0 0 32v192a32 32 0 0 0 32 32h128v-64H64V64h128v34.74A47.92 47.92 0 0 1 208 96h48V32a32 32 0 0 0-32-32zm384 256H480v64h96v128H448v-34.74a47.92 47.92 0 0 1-16 2.74h-48v64a32 32 0 0 0 32 32h192a32 32 0 0 0 32-32V288a32 32 0 0 0-32-32z", "M480 144v224a48 48 0 0 1-48 48H208a48 48 0 0 1-48-48V144a48 48 0 0 1 48-48h224a48 48 0 0 1 48 48z"]],
    "broadcast-tower": [640, 512, [], "f519", ["M184.67 64h-33.73a16 16 0 0 0-15.41 11.23 188.52 188.52 0 0 0 0 105.53A16 16 0 0 0 150.94 192h33.73a15.76 15.76 0 0 0 14.86-21.18 125.2 125.2 0 0 1 0-85.64A15.75 15.75 0 0 0 184.67 64zM89.92 23.34A15.83 15.83 0 0 0 76 0H40.63a16.18 16.18 0 0 0-14.74 9.31A285.66 285.66 0 0 0 0 128c0 24.75 3.12 68.33 26.69 118.86A16.1 16.1 0 0 0 41.3 256h34.84a15.84 15.84 0 0 0 14-23.37c-49.83-93.32-16.76-178.15-.22-209.29zm524.14-14A16.17 16.17 0 0 0 599.33 0h-35.42a15.81 15.81 0 0 0-14 23.25c18.27 34.29 48.42 119.42.28 209.23A15.87 15.87 0 0 0 564.08 256h35.23a16.17 16.17 0 0 0 14.69-9.29 284.5 284.5 0 0 0 0-237.42zM489.06 64h-33.73a15.76 15.76 0 0 0-14.86 21.18 125.2 125.2 0 0 1 0 85.64A15.75 15.75 0 0 0 455.33 192h33.73a16 16 0 0 0 15.41-11.24 188.48 188.48 0 0 0 0-105.52A15.94 15.94 0 0 0 489.06 64z", "M503.26 477.53l-130.5-313.41a64 64 0 1 0-105.52 0l-130.5 313.41a16 16 0 0 0 8.61 20.92l29.51 12.31a16 16 0 0 0 20.91-8.61L245 384h150l49.2 118.15a16 16 0 0 0 20.91 8.61l29.51-12.31a16 16 0 0 0 8.64-20.92zM271.62 320L320 203.81 368.38 320z"]],
    "broom": [640, 512, [], "f51a", ["M636.53 31A16 16 0 0 1 634 53.47l-232.5 177.8-39.72-50L594.26 3.47A15.94 15.94 0 0 1 616.67 6l19.86 25z", "M93.17 257.71c-21.88 17.43-40.17 55.81-54.6 97.47L99 333.09a6 6 0 0 1 6.65 9.5L11 454.76c-7.2 32.29-11 55.43-11 55.43s206.66 13.66 266.63-34.12S343.2 326 343.2 326l-86.73-109.23S153.14 210 93.17 257.71zm342.42 16.48L327.64 138.3a11 11 0 0 0-18.59 2.21l-25.33 54.55 86.73 109.18 58.8-12.45a11 11 0 0 0 6.34-17.6z"]],
    "browser": [512, 512, [], "f37e", ["M76 160h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12H76a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12zM0 224v208a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V224z", "M464 32H48A48 48 0 0 0 0 80v144h512V80a48 48 0 0 0-48-48zM128 148a12 12 0 0 1-12 12H76a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm320 0a12 12 0 0 1-12 12H188a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h248a12 12 0 0 1 12 12z"]],
    "brush": [384, 512, [], "f55d", ["M384 32v224H0V32A32 32 0 0 1 32 0h320a32 32 0 0 1 32 32z", "M0 288v32a64 64 0 0 0 64 64h64v64a64 64 0 0 0 128 0v-64h64a64 64 0 0 0 64-64v-32zm192 184a24 24 0 1 1 24-24 24 24 0 0 1-24 24z"]],
    "bug": [512, 512, [], "f188", ["M369 112H145a112 112 0 0 1 224 0z", "M512 288.9c-.48 17.43-15.22 31.1-32.66 31.1H424v16a143.4 143.4 0 0 1-13.6 61.14l60.23 60.23a32 32 0 0 1-45.26 45.26l-54.73-54.74A143.42 143.42 0 0 1 280 480V236a12 12 0 0 0-12-12h-24a12 12 0 0 0-12 12v244a143.42 143.42 0 0 1-90.64-32.11l-54.73 54.74a32 32 0 0 1-45.26-45.26l60.23-60.23A143.4 143.4 0 0 1 88 336v-16H32.67C15.23 320 .49 306.33 0 288.9A32 32 0 0 1 32 256h56v-58.74l-46.63-46.63a32 32 0 0 1 45.26-45.26L141.25 160h229.49l54.63-54.63a32 32 0 0 1 45.26 45.26L424 197.26V256h56a32 32 0 0 1 32 32.9z"]],
    "building": [448, 512, [], "f1ad", ["M180 160h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm0 96h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm0-192h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12V76a12 12 0 0 0-12-12zm128 0h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12V76a12 12 0 0 0-12-12zm0 96h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm0 96h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12z", "M436 480h-20V24a24 24 0 0 0-24-24H56a24 24 0 0 0-24 24v456H12a12 12 0 0 0-12 12v20h448v-20a12 12 0 0 0-12-12zM128 76a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12v40a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12zm0 96a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12v40a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12zm52 148h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12v40a12 12 0 0 1-12 12zm76 160h-64v-84a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm64-172a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12V76a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12z"]],
    "bullhorn": [576, 512, [], "f0a1", ["M544 448c0 9.22-7.08 32-32 32a32 32 0 0 1-20-7l-85-68a242.82 242.82 0 0 0-119-50.79V125.84a242.86 242.86 0 0 0 119-50.79L492 7a31.93 31.93 0 0 1 20-7c25 0 32 23.26 32 32z", "M544 184.88v110.24a63.47 63.47 0 0 0 0-110.24zM0 192v96a64 64 0 0 0 64 64h33.7a243 243 0 0 0-2.18 32 253.32 253.32 0 0 0 25.56 110.94c5.19 10.69 16.52 17.06 28.4 17.06h74.28c26.05 0 41.69-29.84 25.9-50.56A127.35 127.35 0 0 1 223.51 384a121 121 0 0 1 4.41-32H256V128H64a64 64 0 0 0-64 64z"]],
    "bullseye": [496, 512, [], "f140", ["M248 8C111.03 8 0 119.03 0 256s111.03 248 248 248 248-111.03 248-248S384.97 8 248 8zm0 432c-101.69 0-184-82.29-184-184 0-101.69 82.29-184 184-184 101.69 0 184 82.29 184 184 0 101.69-82.29 184-184 184zm0-312c-70.69 0-128 57.31-128 128s57.31 128 128 128 128-57.31 128-128-57.31-128-128-128zm0 192c-35.29 0-64-28.71-64-64s28.71-64 64-64 64 28.71 64 64-28.71 64-64 64z", ""]],
    "bullseye-arrow": [496, 512, [], "f648", ["M248,320a64.07,64.07,0,0,1-64-64c0-28.95,19.45-53.19,45.88-61.07L285,139.79l-2.12-6.38C271.73,130.24,260.18,128,248,128A128,128,0,1,0,376,256c0-12.18-2.24-23.73-5.42-34.89L364.21,219l-55.14,55.14A63.85,63.85,0,0,1,248,320ZM484.43,181.1l-35.5,35.5a52.13,52.13,0,0,1-19.17,12.07c15.9,101.19-53.24,196.1-154.43,212s-196.1-53.25-212-154.43,53.25-196.1,154.43-212a185.71,185.71,0,0,1,57.88.05A52,52,0,0,1,287.4,55.07l35.5-35.5A247.87,247.87,0,0,0,248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256A247.87,247.87,0,0,0,484.43,181.1Z", "M310,77.7,373.68,14a20.56,20.56,0,0,1,34,8l18.55,55.65L481.89,96.2a20.56,20.56,0,0,1,8,34L426.3,194a20.58,20.58,0,0,1-21,5l-49.7-16.57L265,273a24,24,0,0,1-34-34l90.59-90.59L305,98.71A20.58,20.58,0,0,1,310,77.7Z"]],
    "bullseye-pointer": [496, 512, [], "f649", ["M312,256a64,64,0,0,1-28.93,53.43L262.3,382.53C326.18,375.35,376,321.78,376,256A128,128,0,0,0,248,128c-65.78,0-119.35,49.82-126.53,113.7l73.11-20.78A63.91,63.91,0,0,1,312,256ZM248,8C111.08,8,.11,119,.11,256c0,8.39.44,16.67,1.26,24.85a48.57,48.57,0,0,1,18-10.08L64.21,258c0-.68-.1-1.33-.1-2a184,184,0,1,1,184,184c-.68,0-1.34-.09-2-.1l-12.75,44.87a48.53,48.53,0,0,1-10,18c8.16.81,16.44,1.25,24.82,1.25C385,504,496,393,496,256S385,8,248,8Z", "M242.21,240.65a17.13,17.13,0,0,1,21.16,21.17L202.51,476c-4.31,15.17-25.08,17-31.91,2.73l-32.88-68.47L48.57,499.41a15.51,15.51,0,0,1-21.95,0l-.05,0-22-22a15.52,15.52,0,0,1-.05-22h0l.05,0,89.15-89.15L25.36,333.45c-14.25-6.82-12.44-27.61,2.74-31.92l214.13-60.88Z"]],
    "burger-soda": [640, 512, [], "f858", ["M336 128H206.73l20-80H272a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-51.5a40 40 0 0 0-38.81 30.3L157.26 128H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-44.62 96H38.27l25.78 258.29A31.87 31.87 0 0 0 96 512h160a31.59 31.59 0 0 0 13.65-3.36A79.55 79.55 0 0 1 256 464a47.93 47.93 0 0 1 17-36.61 63.91 63.91 0 0 1 4.58-91.27 64 64 0 0 1-14-17.9 64.71 64.71 0 0 1 3.74-66.82c6.68-9.87 15.04-18.86 24.06-27.4z", "M624 448H304a16 16 0 0 0-16 16 48 48 0 0 0 48 48h256a48 48 0 0 0 48-48 16 16 0 0 0-16-16zM319.27 320h289.46c25.35 0 40-29.27 25.54-50.59C604.8 226.13 539.94 192.07 464 192s-140.79 34.13-170.26 77.41c-14.53 21.32.19 50.59 25.53 50.59zM544 240a16 16 0 1 1-16 16 16 16 0 0 1 16-16zm-80-16a16 16 0 1 1-16 16 16 16 0 0 1 16-16zm-80 16a16 16 0 1 1-16 16 16 16 0 0 1 16-16zm-64 176h288a32 32 0 0 0 0-64H320a32 32 0 0 0 0 64z"]],
    "burn": [384, 512, [], "f46a", ["M192 0C79.7 101.3 0 220.9 0 300.5 0 425 79 512 192 512s192-87 192-211.5c0-79.9-80.2-199.6-192-300.5zm83 415.6c-21.15 20.9-50.64 32.4-83 32.4s-61.87-11.5-83-32.4-33-50.31-33-82.55c0-16.3 5.1-35.18 15.17-56.11 15-31.13 41-67 77.24-106.56L192 144.65l23.59 25.73c36.28 39.57 62.27 75.43 77.24 106.56C302.9 297.87 308 316.75 308 333.05c0 32.24-11.71 61.56-33 82.55z", "M276 333.05c0 48.83-34.56 82.95-84 82.95s-84-34.12-84-82.95c0-11.81 4-53.81 84-141 80 87.19 84 129.19 84 141z"]],
    "burrito": [512, 512, [], "f7ed", ["M351.83 224c-15.22 0-30 2.53-44.54 6.32C278.33 310.45 201.65 368 111.57 368A207 207 0 0 1 .72 335.76c-3.72 33.8 6.86 68.88 32.74 94.74L81 478a116.21 116.21 0 0 0 164.22 0l216-215.73A175.25 175.25 0 0 0 351.83 224zm-64.07-64a174.85 174.85 0 0 0-38.33-109.28l-216 215.73A115.42 115.42 0 0 0 9 302.83 175.23 175.23 0 0 0 111.57 336c97.14 0 176.19-78.95 176.19-176z", "M505.26 153.88A80 80 0 0 1 512 186c0 22-9.37 42-24.29 56.75A207.26 207.26 0 0 0 351.83 192a210 210 0 0 0-35.22 3A204.24 204.24 0 0 0 269 24.26C283.8 9.37 303.74 0 325.8 0A80 80 0 0 1 358 6.73a74.19 74.19 0 0 1 101.69 45.53A74.13 74.13 0 0 1 512 123a73.17 73.17 0 0 1-6.74 30.88z"]],
    "bus": [512, 512, [], "f207", ["M352 448v32a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32v-32zM64 480a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32v-32H64zm64-192h256a32 32 0 0 0 32-32V128a32 32 0 0 0-32-32H128a32 32 0 0 0-32 32v128a32 32 0 0 0 32 32z", "M488 128h-8V80c0-44.8-99.2-80-224-80S32 35.2 32 80v48h-8a24 24 0 0 0-24 24v80a24 24 0 0 0 24 24h8v160a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32V256h8a24 24 0 0 0 24-24v-80a24 24 0 0 0-24-24zm-392 0a32 32 0 0 1 32-32h256a32 32 0 0 1 32 32v128a32 32 0 0 1-32 32H128a32 32 0 0 1-32-32zm16 272a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm288 0a32 32 0 1 1 32-32 32 32 0 0 1-32 32z"]],
    "bus-alt": [512, 512, [], "f55e", ["M96 160v96a32 32 0 0 0 32 32h112V128H128a32 32 0 0 0-32 32zm320 96v-96a32 32 0 0 0-32-32H272v160h112a32 32 0 0 0 32-32zM64 480a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32v-32H64zm288-32v32a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32v-32z", "M488 128h-8V80c0-44.8-99.2-80-224-80S32 35.2 32 80v48h-8a24 24 0 0 0-24 24v80a24 24 0 0 0 24 24h8v160a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32V256h8a24 24 0 0 0 24-24v-80a24 24 0 0 0-24-24zM112 400a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm128-112H128a32 32 0 0 1-32-32v-96a32 32 0 0 1 32-32h112zM168 96a8 8 0 0 1-8-8V72a8 8 0 0 1 8-8h176a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8H168zm104 32h112a32 32 0 0 1 32 32v96a32 32 0 0 1-32 32H272zm128 272a32 32 0 1 1 32-32 32 32 0 0 1-32 32z"]],
    "bus-school": [512, 512, [], "f5dd", ["M64 480a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32v-32H64zm288-32v32a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32v-32zM112 160v64a32 32 0 0 0 32 32h96V128h-96a32 32 0 0 0-32 32zm288 64v-64a32 32 0 0 0-32-32h-96v128h96a32 32 0 0 0 32-32z", "M488 112h-24V80c0-44.8-92.11-80-208-80S48 35.2 48 80v32H24a24 24 0 0 0-24 24v80a24 24 0 0 0 24 24h24v20.9c-9.39 5.57-16 15.38-16 27.1v128a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32V288c0-11.72-6.61-21.52-16-27.1V240h24a24 24 0 0 0 24-24v-80a24 24 0 0 0-24-24zM160 72a8 8 0 0 1 8-8h176a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8H168a8 8 0 0 1-8-8zm-48 312a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm128-128h-96a32 32 0 0 1-32-32v-64a32 32 0 0 1 32-32h96zm32-128h96a32 32 0 0 1 32 32v64a32 32 0 0 1-32 32h-96zm128 256a32 32 0 1 1 32-32 32 32 0 0 1-32 32z"]],
    "business-time": [640, 512, [], "f64a", ["M496 224a144 144 0 1 0 144 144 143.92 143.92 0 0 0-144-144zm64 150.29a9.74 9.74 0 0 1-9.71 9.71h-60.57a9.74 9.74 0 0 1-9.71-9.71v-76.57a9.74 9.74 0 0 1 9.71-9.71h12.57a9.74 9.74 0 0 1 9.71 9.71V352h38.29a9.74 9.74 0 0 1 9.71 9.71z", "M326.82 320H208a16 16 0 0 1-16-16v-48H0v144c0 25.6 22.4 48 48 48h291.43a173.64 173.64 0 0 1-12.61-128zM512 192.81V144c0-25.6-22.4-48-48-48h-80V48c0-25.6-22.4-48-48-48H176c-25.6 0-48 22.4-48 48v48H48c-25.6 0-48 22.4-48 48v80h395.12A174.92 174.92 0 0 1 496 192c5.4 0 10.72.33 16 .81zM320 96H192V64h128zm230.29 256H512v-54.28a9.74 9.74 0 0 0-9.71-9.71h-12.57a9.74 9.74 0 0 0-9.71 9.71v76.57a9.74 9.74 0 0 0 9.71 9.71h60.57a9.74 9.74 0 0 0 9.71-9.71v-12.58a9.74 9.74 0 0 0-9.71-9.71z"]],
    "cabinet-filing": [512, 512, [], "f64b", ["M0 480a32 32 0 0 0 32 32h448a32 32 0 0 0 32-32V256H0zm160-112a16 16 0 0 1 16-16h160a16 16 0 0 1 16 16v40a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-24H192v24a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8zM480 0H32A32 32 0 0 0 0 32v192h512V32a32 32 0 0 0-32-32zM352 152a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-24H192v24a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-40a16 16 0 0 1 16-16h160a16 16 0 0 1 16 16z", "M336 96H176a16 16 0 0 0-16 16v40a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-24h128v24a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-40a16 16 0 0 0-16-16zm0 256H176a16 16 0 0 0-16 16v40a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-24h128v24a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-40a16 16 0 0 0-16-16z"]],
    "cactus": [512, 512, [], "f8a7", ["M224 144a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm64 224a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm176-144a48 48 0 0 0-48 48v64a16 16 0 0 1-16 16h-48v96h48a112.14 112.14 0 0 0 112-112v-64a48 48 0 0 0-48-48zM96 208v-64a48 48 0 0 0-96 0v64a112.14 112.14 0 0 0 112 112h48v-96h-48a16 16 0 0 1-16-16z", "M352 96a96 96 0 0 0-192 0v416h192zm-128 80a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm64 224a16 16 0 1 1 16-16 16 16 0 0 1-16 16z"]],
    "calculator": [448, 512, [], "f1ec", ["M115.2 384H76.8c-6.4 0-12.8 6.4-12.8 12.8v38.4c0 6.4 6.4 12.8 12.8 12.8h38.4c6.4 0 12.8-6.4 12.8-12.8v-38.4c0-6.4-6.4-12.8-12.8-12.8zm0-128H76.8c-6.4 0-12.8 6.4-12.8 12.8v38.4c0 6.4 6.4 12.8 12.8 12.8h38.4c6.4 0 12.8-6.4 12.8-12.8v-38.4c0-6.4-6.4-12.8-12.8-12.8zm128 128h-38.4c-6.4 0-12.8 6.4-12.8 12.8v38.4c0 6.4 6.4 12.8 12.8 12.8h38.4c6.4 0 12.8-6.4 12.8-12.8v-38.4c0-6.4-6.4-12.8-12.8-12.8zm0-128h-38.4c-6.4 0-12.8 6.4-12.8 12.8v38.4c0 6.4 6.4 12.8 12.8 12.8h38.4c6.4 0 12.8-6.4 12.8-12.8v-38.4c0-6.4-6.4-12.8-12.8-12.8zm128 0h-38.4c-6.4 0-12.8 6.4-12.8 12.8v166.4c0 6.4 6.4 12.8 12.8 12.8h38.4c6.4 0 12.8-6.4 12.8-12.8V268.8c0-6.4-6.4-12.8-12.8-12.8z", "M400 0H48C22.4 0 0 22.4 0 48v416c0 25.6 22.4 48 48 48h352c25.6 0 48-22.4 48-48V48c0-25.6-22.4-48-48-48zM128 435.2c0 6.4-6.4 12.8-12.8 12.8H76.8c-6.4 0-12.8-6.4-12.8-12.8v-38.4c0-6.4 6.4-12.8 12.8-12.8h38.4c6.4 0 12.8 6.4 12.8 12.8zm0-128c0 6.4-6.4 12.8-12.8 12.8H76.8c-6.4 0-12.8-6.4-12.8-12.8v-38.4c0-6.4 6.4-12.8 12.8-12.8h38.4c6.4 0 12.8 6.4 12.8 12.8zm128 128c0 6.4-6.4 12.8-12.8 12.8h-38.4c-6.4 0-12.8-6.4-12.8-12.8v-38.4c0-6.4 6.4-12.8 12.8-12.8h38.4c6.4 0 12.8 6.4 12.8 12.8zm0-128c0 6.4-6.4 12.8-12.8 12.8h-38.4c-6.4 0-12.8-6.4-12.8-12.8v-38.4c0-6.4 6.4-12.8 12.8-12.8h38.4c6.4 0 12.8 6.4 12.8 12.8zm128 128c0 6.4-6.4 12.8-12.8 12.8h-38.4c-6.4 0-12.8-6.4-12.8-12.8V268.8c0-6.4 6.4-12.8 12.8-12.8h38.4c6.4 0 12.8 6.4 12.8 12.8zm0-256c0 6.4-6.4 12.8-12.8 12.8H76.8c-6.4 0-12.8-6.4-12.8-12.8V76.8C64 70.4 70.4 64 76.8 64h294.4c6.4 0 12.8 6.4 12.8 12.8z"]],
    "calculator-alt": [512, 512, [], "f64c", ["M192 0H32A32 32 0 0 0 0 32v160a32 32 0 0 0 32 32h160a32 32 0 0 0 32-32V32a32 32 0 0 0-32-32zm-16 120a8 8 0 0 1-8 8H56a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h112a8 8 0 0 1 8 8zm16 168H32a32 32 0 0 0-32 32v160a32 32 0 0 0 32 32h160a32 32 0 0 0 32-32V320a32 32 0 0 0-32-32zm-29.09 140.29a8 8 0 0 1 0 11.31l-11.31 11.31a8 8 0 0 1-11.31 0L112 422.63l-28.29 28.29a8 8 0 0 1-11.31 0L61.09 439.6a8 8 0 0 1 0-11.31L89.37 400l-28.29-28.29a8 8 0 0 1 0-11.31l11.31-11.31a8 8 0 0 1 11.31 0l28.3 28.28 28.29-28.29a8 8 0 0 1 11.31 0l11.31 11.31a8 8 0 0 1 0 11.31L134.63 400zM480 0H320a32 32 0 0 0-32 32v160a32 32 0 0 0 32 32h160a32 32 0 0 0 32-32V32a32 32 0 0 0-32-32zm-16 120a8 8 0 0 1-8 8h-40v40a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-40h-40a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h40V56a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v40h40a8 8 0 0 1 8 8z", "M162.91 360.39l-11.31-11.31a8 8 0 0 0-11.31 0L112 377.37l-28.3-28.28a8 8 0 0 0-11.31 0L61.08 360.4a8 8 0 0 0 0 11.31L89.37 400l-28.28 28.29a8 8 0 0 0 0 11.31l11.31 11.32a8 8 0 0 0 11.31 0L112 422.63l28.29 28.28a8 8 0 0 0 11.31 0l11.31-11.31a8 8 0 0 0 0-11.31L134.63 400l28.28-28.3a8 8 0 0 0 0-11.31zM344 128h40v40a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-40h40a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8h-40V56a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v40h-40a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8zM168 96H56a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h112a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zm312 192H320a32 32 0 0 0-32 32v160a32 32 0 0 0 32 32h160a32 32 0 0 0 32-32V320a32 32 0 0 0-32-32zm-16 152a8 8 0 0 1-8 8H344a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h112a8 8 0 0 1 8 8zm0-64a8 8 0 0 1-8 8H344a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h112a8 8 0 0 1 8 8z"]],
    "calendar": [448, 512, [], "f133", ["M0 192v272a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V192zm304-64h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16zm-192 0h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16z", "M448 112v80H0v-80a48 48 0 0 1 48-48h48v48a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V64h128v48a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V64h48a48 48 0 0 1 48 48z"]],
    "calendar-alt": [448, 512, [], "f073", ["M0 192v272a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V192zm128 244a12 12 0 0 1-12 12H76a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-128a12 12 0 0 1-12 12H76a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm128 128a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-128a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm128 128a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-128a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm-80-180h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16zm-192 0h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16z", "M448 112v80H0v-80a48 48 0 0 1 48-48h48v48a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V64h128v48a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V64h48a48 48 0 0 1 48 48z"]],
    "calendar-check": [448, 512, [], "f274", ["M0 192v272a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V192zm345.26 113l-143 141.8a12 12 0 0 1-17 0l-82.6-83.26a12 12 0 0 1 .06-17l.08-.08 28.4-28.17a12 12 0 0 1 17 0l46 46.36 106-105.19a12 12 0 0 1 17 0L345.3 288a12 12 0 0 1-.04 17zM304 128h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16zm-192 0h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16z", "M345.33 288l-28.2-28.4a12 12 0 0 0-17-.1l-106 105.19-46-46.36a12 12 0 0 0-17-.09l-28.4 28.17a12 12 0 0 0-.1 17l82.6 83.26a12 12 0 0 0 17 .1l143-141.8a12 12 0 0 0 .1-17zM400 64h-48v48a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V64H160v48a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V64H48a48 48 0 0 0-48 48v80h448v-80a48 48 0 0 0-48-48z"]],
    "calendar-day": [448, 512, [], "f783", ["M0 192v272a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V192zm192 176a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16v-96a16 16 0 0 1 16-16h96a16 16 0 0 1 16 16zm112-240h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16zm-192 0h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16z", "M448 112v80H0v-80a48 48 0 0 1 48-48h48v48a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V64h128v48a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V64h48a48 48 0 0 1 48 48z"]],
    "calendar-edit": [448, 512, [], "f333", ["M0 192v272a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V192zm274.43 163.57l-95 95L131.2 456a10.17 10.17 0 0 1-11.2-9 9.93 9.93 0 0 1 0-2.18l5.4-48.2 95-95a5.07 5.07 0 0 1 7.17 0l46.8 46.8a5.07 5.07 0 0 1 .06 7.15zm55.67-55.67l-26 26a5.07 5.07 0 0 1-7.17 0l-46.8-46.8a5.07 5.07 0 0 1 0-7.17l26-26a20.22 20.22 0 0 1 28.6 0l25.4 25.4a20.22 20.22 0 0 1-.03 28.57zM112 128h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16zm192 0h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16z", "M330.1 271.3l-25.4-25.4a20.22 20.22 0 0 0-28.6 0l-26 26a5.07 5.07 0 0 0 0 7.17l46.8 46.8a5.07 5.07 0 0 0 7.17 0l26-26a20.22 20.22 0 0 0 0-28.6zm-55.7 77.1l-46.8-46.8a5.07 5.07 0 0 0-7.17 0l-95 95-5.43 48.2a10.17 10.17 0 0 0 9 11.2 9.93 9.93 0 0 0 2.18 0l48.2-5.4 95-95a5.07 5.07 0 0 0 0-7.17zM400 64h-48v48a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V64H160v48a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V64H48a48 48 0 0 0-48 48v80h448v-80a48 48 0 0 0-48-48z"]],
    "calendar-exclamation": [448, 512, [], "f334", ["M0 192v272a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V192zm196.18 48h55.02a12 12 0 0 1 12 12v.83l-7.2 112A12 12 0 0 1 244 376h-40a12 12 0 0 1-12-11.2l-7.2-112a12.1 12.1 0 0 1 11.38-12.8zM224 472a40 40 0 1 1 40-40 40 40 0 0 1-40 40zM112 128h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16zm192 0h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16z", "M224 392a40 40 0 1 0 40 40 40 40 0 0 0-40-40zm-20-16h40a12 12 0 0 0 12-11.2l7.2-112A12 12 0 0 0 252 240h-55.2a12.1 12.1 0 0 0-12 12.18v.62l7.2 112a12 12 0 0 0 12 11.2zM400 64h-48v48a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V64H160v48a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V64H48a48 48 0 0 0-48 48v80h448v-80a48 48 0 0 0-48-48z"]],
    "calendar-minus": [448, 512, [], "f272", ["M0 192v272a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V192zm328 180a12 12 0 0 1-12 12H132a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h184a12 12 0 0 1 12 12zm-24-244h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16zm-192 0h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16z", "M316 320H132a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h184a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm84-256h-48v48a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V64H160v48a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V64H48a48 48 0 0 0-48 48v80h448v-80a48 48 0 0 0-48-48z"]],
    "calendar-plus": [448, 512, [], "f271", ["M0 192v272a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V192zm328 180a12 12 0 0 1-12 12h-60v60a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-60h-60a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h60v-60a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12v60h60a12 12 0 0 1 12 12zm-24-244h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16zm-192 0h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16z", "M316 320h-60v-60a12 12 0 0 0-12-12h-40a12 12 0 0 0-12 12v60h-60a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h60v60a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-60h60a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm84-256h-48v48a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V64H160v48a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V64H48a48 48 0 0 0-48 48v80h448v-80a48 48 0 0 0-48-48z"]],
    "calendar-star": [448, 512, [], "f736", ["M0 192v272a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V192zm324.13 141.91a11.92 11.92 0 0 1-3.53 6.89L281 379.4l9.4 54.6a12 12 0 0 1-17.4 12.6l-49-25.8-48.9 25.8a12 12 0 0 1-17.4-12.6l9.4-54.6-39.6-38.6a12 12 0 0 1 6.6-20.5l54.7-8 24.5-49.6a12 12 0 0 1 21.5 0l24.5 49.6 54.7 8a12 12 0 0 1 10.13 13.61zM304 128h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16zm-192 0h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16z", "M314 320.3l-54.7-8-24.5-49.6a12 12 0 0 0-21.5 0l-24.5 49.6-54.7 8a12 12 0 0 0-6.6 20.5l39.6 38.6-9.4 54.6a12 12 0 0 0 17.4 12.6l48.9-25.8 49 25.8a12 12 0 0 0 17.4-12.6l-9.4-54.6 39.6-38.6a12 12 0 0 0-6.6-20.5zM400 64h-48v48a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V64H160v48a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V64H48a48 48 0 0 0-48 48v80h448v-80a48 48 0 0 0-48-48z"]],
    "calendar-times": [448, 512, [], "f273", ["M0 192v272a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V192zm317.4 208.1a12 12 0 0 1 0 17l-28.3 28.3a12 12 0 0 1-17 0L224 397.3l-48.1 48.1a12 12 0 0 1-17 0l-28.3-28.3a12 12 0 0 1 0-17l48.1-48.1-48.1-48.1a12 12 0 0 1 0-17l28.3-28.3a12 12 0 0 1 17 0l48.1 48.1 48.1-48.1a12 12 0 0 1 17 0l28.3 28.3a12 12 0 0 1 0 17L269.3 352zM304 128h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16zm-192 0h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16z", "M317.43 286.93l-28.3-28.3a12 12 0 0 0-17 0L224 306.7l-48.1-48.1a12 12 0 0 0-17 0l-28.3 28.3a12 12 0 0 0 0 17l48.1 48.1-48.1 48.1a12 12 0 0 0 0 17l28.3 28.3a12 12 0 0 0 17 0l48.1-48.1 48.1 48.1a12 12 0 0 0 17 0l28.3-28.3a12 12 0 0 0 0-17L269.3 352l48.1-48.1a12 12 0 0 0 .03-16.97zM400 64h-48v48a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V64H160v48a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V64H48a48 48 0 0 0-48 48v80h448v-80a48 48 0 0 0-48-48z"]],
    "calendar-week": [448, 512, [], "f784", ["M0 192v272a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V192zm384 144a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16v-64a16 16 0 0 1 16-16h288a16 16 0 0 1 16 16zm-80-208h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16zm-192 0h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16z", "M448 112v80H0v-80a48 48 0 0 1 48-48h48v48a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V64h128v48a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V64h48a48 48 0 0 1 48 48z"]],
    "camcorder": [576, 512, [], "f8a8", ["M336.2 160H96v-32a32 32 0 0 1 32-32h176a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16H128a96 96 0 0 0-96 96v34.89A47.66 47.66 0 0 0 0 207.8v224.4A47.81 47.81 0 0 0 47.8 480h288.4a47.81 47.81 0 0 0 47.8-47.8V207.8a47.81 47.81 0 0 0-47.8-47.8zM320 249.6a6.41 6.41 0 0 1-6.4 6.4H70.4a6.41 6.41 0 0 1-6.4-6.4v-19.2a6.41 6.41 0 0 1 6.4-6.4h243.2a6.41 6.41 0 0 1 6.4 6.4z", "M525.59 165.7L416 241.3v157.4l109.59 75.5c21.21 14.6 50.41-.29 50.41-25.79V191.5c0-25.41-29.09-40.41-50.41-25.8zM313.6 224H70.4a6.41 6.41 0 0 0-6.4 6.4v19.2a6.41 6.41 0 0 0 6.4 6.4h243.2a6.41 6.41 0 0 0 6.4-6.4v-19.2a6.41 6.41 0 0 0-6.4-6.4z"]],
    "camera": [512, 512, [], "f030", ["M344 288a88 88 0 1 1-88-88 88.13 88.13 0 0 1 88 88z", "M464 96h-88l-12.4-32.9A47.93 47.93 0 0 0 318.7 32H193.2a47.93 47.93 0 0 0-44.9 31.1L136 96H48a48 48 0 0 0-48 48v288a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V144a48 48 0 0 0-48-48zM256 408a120 120 0 1 1 120-120 120.1 120.1 0 0 1-120 120z"]],
    "camera-alt": [512, 512, [], "f332", ["M256 200a88 88 0 1 0 88 88 88.13 88.13 0 0 0-88-88zm0 56a32.09 32.09 0 0 0-32 32 16 16 0 0 1-32 0 64.06 64.06 0 0 1 64-64 16 16 0 0 1 0 32z", "M464 96h-88l-12.4-32.9A47.93 47.93 0 0 0 318.7 32H193.2a47.93 47.93 0 0 0-44.9 31.1L136 96H48a48 48 0 0 0-48 48v288a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V144a48 48 0 0 0-48-48zM256 408a120 120 0 1 1 120-120 120.1 120.1 0 0 1-120 120z"]],
    "camera-movie": [576, 512, [], "f8a9", ["M368.2 288H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h48v112.2a47.81 47.81 0 0 0 47.8 47.8h256.4a47.81 47.81 0 0 0 47.8-47.8V335.8a47.81 47.81 0 0 0-47.8-47.8zM128 192a64 64 0 1 0-64-64 64.07 64.07 0 0 0 64 64zm224 0a64 64 0 1 0-64-64 64.07 64.07 0 0 0 64 64z", "M535.68 260.59L448 321.07V447l87.68 60.4c17 11.68 40.32-.23 40.32-20.64V281.23c0-20.33-23.27-32.33-40.32-20.64zM352 0c-48.57 0-90.31 27.37-112 67.24C218.31 27.37 176.57 0 128 0a128 128 0 0 0 0 256h224a128 128 0 0 0 0-256zM128 192a64 64 0 1 1 64-64 64.07 64.07 0 0 1-64 64zm224 0a64 64 0 1 1 64-64 64.07 64.07 0 0 1-64 64z"]],
    "camera-polaroid": [576, 512, [], "f8aa", ["M570.63 343.94L512 256V80a48 48 0 0 0-48-48H112a48 48 0 0 0-48 48v176L5.38 343.94A31.8 31.8 0 0 0 1.57 352h572.86a32.12 32.12 0 0 0-3.8-8.06zM288 256a64 64 0 1 1 64-64 64.1 64.1 0 0 1-64 64zm152-112a8 8 0 0 1-8 8h-32a8 8 0 0 1-8-8v-32a8 8 0 0 1 8-8h32a8 8 0 0 1 8 8z", "M574.43 352H1.57A31.76 31.76 0 0 0 0 361.69V448a32 32 0 0 0 32 32h512a32 32 0 0 0 32-32v-86.31a31.76 31.76 0 0 0-1.57-9.69zM480 408a8 8 0 0 1-8 8H104a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h368a8 8 0 0 1 8 8zM288 256a64 64 0 1 0-64-64 64.1 64.1 0 0 0 64 64z"]],
    "camera-retro": [512, 512, [], "f083", ["M256 232a88 88 0 1 0 88 88 88 88 0 0 0-88-88zm0 56a32.09 32.09 0 0 0-32 32 16 16 0 0 1-32 0 64.06 64.06 0 0 1 64-64 16 16 0 0 1 0 32zM480 32H256l-64 48H16A16 16 0 0 0 0 96v64h512V64a32.09 32.09 0 0 0-32-32z", "M176 48a16 16 0 0 0-16-16H64a16 16 0 0 0-16 16v32h128zM0 160v272a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V160zm256 280a120 120 0 1 1 120-120 120 120 0 0 1-120 120z"]],
    "campfire": [512, 512, [], "f6ba", ["M320 32a377.71 377.71 0 0 0-36.14 37.48A489.51 489.51 0 0 0 220 0c-63.17 57-108 131.22-108 176a144 144 0 0 0 288 0c0-33.29-33.42-102-80-144zm-16.79 208.57A79.7 79.7 0 0 1 256 256c-44.11 0-80-30.49-80-80 0-24.66 14.86-46.39 44.5-83.52 4.23 5.09 60.42 80.06 60.42 80.06l35.84-42.72c2.53 4.37 4.83 8.65 6.89 12.76 16.71 33.33 9.66 75.99-20.44 97.99z", "M511.28 470.21l-9.35 30.55a15.61 15.61 0 0 1-19.62 10.5L256 439 29.69 511.26a15.61 15.61 0 0 1-19.62-10.5L.72 470.21a16.06 16.06 0 0 1 10.28-20l140-44.68-140-44.72a16.06 16.06 0 0 1-10.28-20l9.35-30.55a15.61 15.61 0 0 1 19.62-10.5L256 372l226.31-72.24a15.61 15.61 0 0 1 19.62 10.5l9.35 30.55a16.06 16.06 0 0 1-10.28 20l-140 44.68 140 44.68a16.06 16.06 0 0 1 10.28 20.04z"]],
    "campground": [640, 512, [], "f6bb", ["M640 464v32a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h608a16 16 0 0 1 16 16z", "M40.68 448l239.79-330.25-53.41-73.55a16 16 0 0 1 3.54-22.35l25.88-18.8a16 16 0 0 1 22.35 3.55L320 63.3l41.16-56.69a16 16 0 0 1 22.35-3.55l25.9 18.79A16 16 0 0 1 413 44.2l-53.41 73.55L599.32 448h-163L320 288 203.64 448z"]],
    "candle-holder": [448, 512, [], "f6bc", ["M160 192c45.93 0 78-32.61 78-79.29 0-30-32.59-74.89-78-112.71-45.62 38-78 82.84-78 112.71 0 46.68 32.07 79.29 78 79.29zm216 176a72.08 72.08 0 0 0-72 72 71.11 71.11 0 0 0 4.42 24H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h360a72 72 0 0 0 0-144zm0 96a24 24 0 1 1 24-24 24 24 0 0 1-24 24z", "M256 256v208H64V256a32 32 0 0 1 32-32h32v48a16 16 0 0 0 32 0v-48h64a32 32 0 0 1 32 32z"]],
    "candy-cane": [512, 512, [], "f786", ["M86.71 355.33l122.12 76.32 75.66-45-122.1-76.31zM15.57 397.6a32 32 0 0 0-11 43.9l32.8 54.9a32.05 32.05 0 0 0 27.5 15.6 32.7 32.7 0 0 0 16.4-4.5l96.62-57.45-122.13-76.33zm249.3-259.8a32.05 32.05 0 0 0 27.5 15.6 32.7 32.7 0 0 0 16.4-4.5l18.91-11.27-41.13-123.38a160 160 0 0 0-16 8.35L243.07 39a32 32 0 0 0-11 43.9zm95.54-8.8l93.11-93.11A160.26 160.26 0 0 0 316.87 4l41.5 124.51c.69.14 1.37.28 2.04.49zm137.06-37a162.39 162.39 0 0 0-21.26-33.58l-92.74 92.73c.26.89.48 1.79.66 2.69l123.2 41.07c8.27-33.67 5.82-69.75-9.86-102.91zM193.34 292l122.09 76.3 75.65-45L269 247zm175.83-104.5L300 228.62l122 76.28 6.55-3.9a173 173 0 0 0 68.17-75.89l-123-41a32 32 0 0 1-4.55 3.39z", "M336.27 132.5a31.46 31.46 0 0 1 16.4-4.5 31.89 31.89 0 0 1 5.7.52L316.87 4a159.24 159.24 0 0 0-30.32 10.24l41.13 123.38zM55.76 373.72l122.13 76.33 30.94-18.4-122.12-76.32zM380.17 143.6a31.62 31.62 0 0 1 3.3 7.55l92.74-92.73a159.17 159.17 0 0 0-22.69-22.57L360.41 129a32 32 0 0 1 19.76 14.6zM162.39 310.36l122.1 76.31 30.94-18.4L193.34 292zM269 247l122.06 76.28L422 304.9l-122-76.28zm115.11-93.17a32.2 32.2 0 0 1-10.35 30.28l123 41a167.3 167.3 0 0 0 10.59-30.2z"]],
    "candy-corn": [640, 512, [], "f6bd", ["M480 0C314.2 1.62 315.53 39.53 322.12 72.44c3.47 17.35 7.44 35.26 11.74 53.32 32.89-7 81.71-13.93 146.74-13.93 64.28 0 112.74 6.76 145.61 13.7 4.28-18 8.22-35.8 11.68-53.09C644.48 39.53 645.81 1.62 480 0zm-94 294.9c28.24 70.05 61.05 121 93.88 121h.12c32.87-.09 65.71-51.07 94-121.18-23.91-3.86-55-7-93.5-7-39.04.03-70.5 3.18-94.5 7.18zM288.81 409c-27.59 27.57-47.55 52-61.81 71.83 69.55 29.6 128.78 42.42 152 19.22l.08-.09c23.17-23.3 10.35-82.55-19.25-152.13C340.22 362 316 381.77 288.81 409zm-41-263.5c-18.62-27.94-44.5-55.68-162.89 60.38C-31.16 324.21-3.4 350.07 24.54 368.69c14.72 9.81 30.19 19.67 46 29.39 18.31-28.19 47.93-67.59 93.91-113.57C209.9 239.07 249 209.6 277.1 191.26c-9.69-15.74-19.5-31.12-29.28-45.78z", "M480.6 143.83c-61.87 0-108 6.6-139 13.15 12.58 48.29 27.69 96.43 44.41 137.92 24-3.92 55.46-7.11 94.5-7.11 38.49 0 69.59 3.1 93.5 7 16.73-41.47 31.85-89.63 44.44-138-31-6.57-76.75-13-137.85-13zM187.09 307.14c-43.75 43.74-71.7 81-89 107.55 43.06 25.31 87.8 48.62 128.91 66.14 14.24-19.76 34.2-44.23 61.79-71.82 27.22-27.21 51.41-47 71-61.18-17.5-41.15-40.87-85.89-66.15-129-26.42 17.25-63.36 45-106.57 88.27z"]],
    "cannabis": [512, 512, [], "f55f", ["M512 374.4a16 16 0 0 1-8.51 14.15c-2.49 1.29-60.77 31.72-133.49 31.72q-9.19 0-17.5-.31c11.36 22.23 16.52 38.31 16.81 39.22a16 16 0 0 1-20 20.1c-1.83-.58-37.72-12-77.3-39.29V280a8 8 0 0 0-8-8H248a8 8 0 0 0-8 8v160c-39.58 27.3-75.47 38.72-77.3 39.29a16 16 0 0 1-20-20.1c.29-.91 5.44-17 16.81-39.22-5.54.21-11.36.31-17.5.31-72.73 0-131-30.43-133.49-31.72a16 16 0 0 1 0-28.29c1.57-.82 32.39-16.89 76.78-25.81C21.06 259.32 1.26 172.77.38 168.8a16 16 0 0 1 19.05-19.09c3.89.86 86.55 19.6 160.58 79.76v-4.4c0-118.79 60-213.72 62.53-217.7a16 16 0 0 1 26.93 0c2.55 4 62.53 98.91 62.53 217.7v4.4c74-60.17 156.7-78.91 160.58-79.76a15.56 15.56 0 0 1 3.44-.38 16 16 0 0 1 15.62 19.47c-.88 4-20.68 90.52-84.93 165.64 44.39 8.92 75.22 25 76.78 25.81A16 16 0 0 1 512 374.4z", "M272 280v224a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8V280a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8z"]],
    "capsules": [576, 512, [], "f46b", ["M112 32A112 112 0 0 0 0 144v112h224V144A112 112 0 0 0 112 32zm312.2 80.8a114.33 114.33 0 0 0-159.3-28.1c-3.12 2.18-6.07 4.51-8.9 6.94v179.67l47 67.1 187.38-131.06z", "M0 368a112 112 0 0 0 224 0V256H0zm555.3-67.9l-64.92-92.75L303 338.41l65 92.79a114.31 114.31 0 1 0 187.3-131.1z"]],
    "car": [512, 512, [], "f1b9", ["M319.5 128a48 48 0 0 1 44.57 30.17L384 208H128l19.93-49.83A48 48 0 0 1 192.5 128zM80 384a63.82 63.82 0 0 1-47.57-21.2A31.82 31.82 0 0 0 32 368v48a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32v-32zm352 0h-48v32a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32v-48a31.82 31.82 0 0 0-.43-5.2A63.82 63.82 0 0 1 432 384z", "M500 176h-59.88l-16.64-41.6A111.43 111.43 0 0 0 319.5 64h-127a111.47 111.47 0 0 0-104 70.4L71.87 176H12A12 12 0 0 0 .37 190.91l6 24A12 12 0 0 0 18 224h20.08A63.55 63.55 0 0 0 16 272v48a64 64 0 0 0 64 64h352a64 64 0 0 0 64-64v-48a63.58 63.58 0 0 0-22.07-48H494a12 12 0 0 0 11.64-9.09l6-24A12 12 0 0 0 500 176zm-352.07-17.83A48 48 0 0 1 192.5 128h127a48 48 0 0 1 44.57 30.17L384 208H128zM96 256c19.2 0 48 28.71 48 47.85s-28.8 15.95-48 15.95-32-12.8-32-31.9S76.8 256 96 256zm272 47.85c0-19.14 28.8-47.85 48-47.85s32 12.76 32 31.9-12.8 31.9-32 31.9-48 3.2-48-15.95z"]],
    "car-alt": [480, 512, [], "f5de", ["M176.5,128h127a48,48,0,0,1,44.57,30.17L368,208H112l19.93-49.83A48,48,0,0,1,176.5,128ZM416,384H368v32a32,32,0,0,0,32,32h32a32,32,0,0,0,32-32V368a31.28,31.28,0,0,0-.43-5.2A63.81,63.81,0,0,1,416,384ZM64,384a63.81,63.81,0,0,1-47.57-21.2A31.28,31.28,0,0,0,16,368v48a32,32,0,0,0,32,32H80a32,32,0,0,0,32-32V384Z", "M438.66,212.33,407.49,134.4A111.47,111.47,0,0,0,303.5,64h-127a111.47,111.47,0,0,0-104,70.4L41.34,212.33A63.88,63.88,0,0,0,0,272v48a64,64,0,0,0,64,64H416a64,64,0,0,0,64-64V272A63.88,63.88,0,0,0,438.66,212.33ZM131.93,158.17A48,48,0,0,1,176.5,128h127a48,48,0,0,1,44.57,30.17L368,208H112ZM80,319.8c-19.2,0-32-12.76-32-31.9S60.8,256,80,256s48,28.71,48,47.85S99.2,319.8,80,319.8Zm320,0c-19.2,0-48,3.19-48-15.95S380.8,256,400,256s32,12.76,32,31.9S419.2,319.8,400,319.8Z"]],
    "car-battery": [512, 512, [], "f5df", ["M176 64H80a16 16 0 0 0-16 16v48h128V80a16 16 0 0 0-16-16zm256 0h-96a16 16 0 0 0-16 16v48h128V80a16 16 0 0 0-16-16z", "M480 128H32a32 32 0 0 0-32 32v256a32 32 0 0 0 32 32h448a32 32 0 0 0 32-32V160a32 32 0 0 0-32-32zM192 264a8 8 0 0 1-8 8H72a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h112a8 8 0 0 1 8 8zm256 0a8 8 0 0 1-8 8h-40v40a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-40h-40a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h40v-40a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v40h40a8 8 0 0 1 8 8z"]],
    "car-building": [640, 512, [], "f859", ["M213.52 455.07A88.41 88.41 0 0 1 192 397.24v-28.69a89.11 89.11 0 0 1 42.09-75.84l7.55-20.71H220a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a11.79 11.79 0 0 1 9.43 4.92A131.1 131.1 0 0 1 352 162.18V32a32 32 0 0 0-32-32H32A32 32 0 0 0 0 32v464a16 16 0 0 0 16 16h205.06a59.85 59.85 0 0 1-7.54-28.69zM208 92a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12v40a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12zm-64 296a12 12 0 0 1-12 12H92a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-128a12 12 0 0 1-12 12H92a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-128a12 12 0 0 1-12 12H92a12 12 0 0 1-12-12V92a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12z", "M604.58 315.56L600 304.2l-17.87-49.08a99.92 99.92 0 0 0-93.2-63.12H375.07a99.94 99.94 0 0 0-93.24 63.12L264 304.2l-4.55 11.35a57.41 57.41 0 0 0-35.42 53v28.69a57.05 57.05 0 0 0 21.51 44.46v41.61A28.71 28.71 0 0 0 274.21 512h28.69a28.69 28.69 0 0 0 28.68-28.69V448h200.83v35.31A28.7 28.7 0 0 0 561.1 512h28.69a28.7 28.7 0 0 0 28.69-28.69V441.7A57 57 0 0 0 640 397.24v-28.69a57.39 57.39 0 0 0-35.42-52.99zM335.11 284c6.53-16.92 22.36-28 40-28h113.82c17.6 0 33.42 11.1 40 28L541 320H323zM300 407.85c-14.4 0-24-9.57-24-23.93S285.6 360 300 360s36 21.53 36 35.89-21.6 11.96-36 11.96zm264 0c-14.4 0-36 2.39-36-12S549.6 360 564 360s24 9.57 24 23.92-9.6 23.93-24 23.93z"]],
    "car-bump": [576, 512, [], "f5e0", ["M329.76 150.49l-216.3 94.28L85.53 257l-2-55.14a49.27 49.27 0 0 1 29.79-46.89l65.2-28.42 56-24.39a50.64 50.64 0 0 1 55.26 9.83zM159.8 422.4l-45.79 20a67.43 67.43 0 0 1-54.33-.15 33.22 33.22 0 0 0 1.78 5.07l20.26 45.08a33.57 33.57 0 0 0 44 16.78l30.53-13.31a32.7 32.7 0 0 0 17-43.39zm326.48-166.12A65.93 65.93 0 0 1 449.84 296L404 316l13.55 30a33.58 33.58 0 0 0 44 16.77l30.53-13.3a32.71 32.71 0 0 0 17-43.39L488.88 261a32.85 32.85 0 0 0-2.6-4.72z", "M575.67 492.44c-9.07-43.75-48.42-76.67-95.58-76.67s-86.51 32.92-95.58 76.67c-2.06 9.92 5.84 19.27 16.13 19.27h158.9c10.28 0 18.19-9.36 16.13-19.27zm-91.78-283.23l-13.5-30.09-6.76-15c-11.53-25.7-37.74-40.31-64.62-38.9l-62.63-60.3a117.56 117.56 0 0 0-128.92-22.98L86.3 94.75c-43.95 19.16-71.23 62.11-69.51 109.43l3.15 86.22a65 65 0 0 0-14.25 73.29l6.75 15 13.5 30.08C40.86 442 80.29 457.06 114 442.36L449.84 296c33.72-14.71 48.97-53.57 34.05-86.79zM102.18 375.36c-18.32 8-35.92 1.31-44-16.69s-1.25-35.31 17.06-43.29 57.92 7 66 25-20.74 26.99-39.06 34.98zM85.53 257l-2-55.14a49.27 49.27 0 0 1 29.79-46.89l121.16-52.81a50.64 50.64 0 0 1 55.26 9.82l40 38.56zm322-14.66c-18.32 8-44.45 23-52.53 5s7.28-57 25.6-64.94 35.92-1.31 44 16.68 1.2 35.22-17.12 43.21z"]],
    "car-bus": [640, 512, [], "f85a", ["M176 0C78 0 0 27.66 0 62.86v259.81A29.33 29.33 0 0 0 29.34 352H40v32a32 32 0 0 0 32 32h23.17a32 32 0 0 0 32-32v-32h67c4.63-24.49 18.73-46.08 40-59.29l18-49.48a134.44 134.44 0 0 1 9.6-19.23H192V80h81.34A14.67 14.67 0 0 1 288 94.67v98.07a131.26 131.26 0 0 1 64-30.56V62.86C352 27.66 274.05 0 176 0zM80 312a24 24 0 1 1 24-24 24 24 0 0 1-24 24zm80-88H78.66A14.67 14.67 0 0 1 64 209.33V94.67A14.67 14.67 0 0 1 78.66 80H160z", "M604.58 315.56L600 304.2l-17.87-49.08a99.92 99.92 0 0 0-93.2-63.12H375.07a99.92 99.92 0 0 0-93.23 63.12L264 304.2l-4.55 11.36a57.39 57.39 0 0 0-35.42 53v28.69a57 57 0 0 0 21.52 44.46V480a32 32 0 0 0 32 32h22.07a32 32 0 0 0 32-32v-32h200.79v32a32 32 0 0 0 32 32h22.07a32 32 0 0 0 32-32v-38.3A57 57 0 0 0 640 397.24v-28.69a57.39 57.39 0 0 0-35.42-52.99zM335.11 284c6.53-16.92 22.36-28 40-28h113.82c17.6 0 33.42 11.1 40 28L541 320H323zM300 407.85c-14.4 0-24-9.57-24-23.92S285.6 360 300 360s36 21.53 36 35.89-21.6 11.96-36 11.96zm264 0c-14.4 0-36 2.39-36-12S549.6 360 564 360s24 9.57 24 23.93-9.6 23.92-24 23.92z"]],
    "car-crash": [640, 512, [], "f5e1", ["M545.44 262.61l-247.93-63.75 31.71-43.3a48 48 0 0 1 50.68-18.12l123 31.62a48 48 0 0 1 35.66 40.32zm-334.1-109.53l10.71-14.32 32.15-43c2.48-3.31 5.2-6.35 7.91-9.4l11.33-56.16a9 9 0 0 0-14.62-8.77l-60.4 49.71a9.06 9.06 0 0 1-13.29-2l-43.3-65.09a9.05 9.05 0 0 0-16.55 4.14l-7.55 77.86a9.05 9.05 0 0 1-10.8 8L30.25 78.61a9.05 9.05 0 0 0-8.78 14.62l49.71 60.41a9.06 9.06 0 0 1-2 13.29l-65.13 43.3a9 9 0 0 0 4.14 16.54l77.86 7.55a9 9 0 0 1 8 10.79l-15.44 76.68a9 9 0 0 0 14.62 8.77l35.2-29a94.29 94.29 0 0 1 2.41-34.39l12.42-46.37a96.46 96.46 0 0 1 68.08-67.72zM548.11 445l-46.49-12-8 31a32 32 0 0 0 23 39l31 8a32 32 0 0 0 39-23l12-46.49a32.9 32.9 0 0 0 .88-5.14 63.82 63.82 0 0 1-51.39 8.63zM207.2 357.36A63.8 63.8 0 0 1 166.4 325a32.23 32.23 0 0 0-1.71 4.93l-11.95 46.47a32 32 0 0 0 23 39l31 8a32 32 0 0 0 39-23l8-31z", "M612.8 284.4L602 201.16a111.45 111.45 0 0 0-83.18-94.08l-123-31.62a111.47 111.47 0 0 0-118.25 42.28L228 185.46A63.85 63.85 0 0 0 173.1 233l-4 15.5-8 31a64 64 0 0 0 46 77.92L548.11 445A64 64 0 0 0 626 399l8-31 4-15.5a63.84 63.84 0 0 0-25.2-68.1zM329.22 155.56a48 48 0 0 1 50.68-18.12l123 31.63a48 48 0 0 1 35.65 40.31l6.9 53.23-247.94-63.75zm-90.55 143.61c-18.59-4.78-27.81-20.33-23-38.87s20.34-27.7 38.93-22.92 39.34 39.76 34.57 58.29-31.9 8.33-50.5 3.5zm309.92 79.68c-18.59-4.78-47.28-8.86-42.51-27.4s39.81-39.17 58.4-34.39 27.82 20.33 23 38.87-20.29 27.7-38.89 22.92z"]],
    "car-garage": [640, 512, [], "f5e2", ["M428.07 254.18L441.6 288H198.4l13.53-33.82A48 48 0 0 1 256.5 224h127a48 48 0 0 1 44.57 30.18zM152 448a63.71 63.71 0 0 1-40-14.06V480a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32v-32zm479.76-279.77L331.67 3a24 24 0 0 0-23.34 0L8.24 168.23A16 16 0 0 0 2 190l7.8 14a16 16 0 0 0 21.79 6.22L320 51.53l288.41 158.73A16 16 0 0 0 630.2 204l7.8-14a16 16 0 0 0-6.24-21.77zM488 448h-56v32a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32v-46.06A63.71 63.71 0 0 1 488 448z", "M512.49 292.91l-5.07-12.67-19.93-49.83a111.47 111.47 0 0 0-104-70.4h-127a111.46 111.46 0 0 0-104 70.4l-19.93 49.82-5.07 12.67A64 64 0 0 0 88 352v32a64 64 0 0 0 64 64h336a64 64 0 0 0 64-64v-32a64 64 0 0 0-39.51-59.09zm-300.56-38.73A48 48 0 0 1 256.5 224h127a48 48 0 0 1 44.57 30.17L441.6 288H198.4zM160 399.8c-19.2 0-32-12.76-32-31.9s12.8-31.9 32-31.9 48 28.71 48 47.85-28.8 15.95-48 15.95zm352-31.9c0 19.14-12.8 31.9-32 31.9s-48 3.19-48-15.95S460.8 336 480 336s32 12.76 32 31.9z"]],
    "car-mechanic": [512, 512, [], "f5e3", ["M144 448v32a32 32 0 0 1-32 32H80a32 32 0 0 1-32-32v-46.06A63.71 63.71 0 0 0 88 448zm175.5-224h-127a48 48 0 0 0-44.57 30.17L134.4 288h243.2l-13.53-33.82A48 48 0 0 0 319.5 224zM424 448h-56v32a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32v-46.06A63.71 63.71 0 0 1 424 448zm79.91-344h-56l-24-24 24-24h56a8.09 8.09 0 0 0 7.25-11.64 79.52 79.52 0 0 0-86.85-42.87c-25.65 4.86-46.72 23-57.05 46.51H145C132.63 19.83 104.81 0 72.07 0A79.48 79.48 0 0 0 .84 44.37 8.09 8.09 0 0 0 8.09 56h56l24 24-24 24h-56a8.09 8.09 0 0 0-7.25 11.64 79.52 79.52 0 0 0 86.84 42.87c25.65-4.86 46.73-23 57-46.51H367c12.38 28.17 40.2 48 72.94 48a79.48 79.48 0 0 0 71.23-44.37 8.08 8.08 0 0 0-7.26-11.63z", "M448.49 292.91l-5.07-12.67-19.93-49.83a111.47 111.47 0 0 0-104-70.4h-127a111.46 111.46 0 0 0-104 70.4l-19.91 49.82-5.07 12.67A64 64 0 0 0 24 352v32a64 64 0 0 0 64 64h336a64 64 0 0 0 64-64v-32a64 64 0 0 0-39.51-59.09zm-300.56-38.73A48 48 0 0 1 192.5 224h127a48 48 0 0 1 44.57 30.17L377.6 288H134.4zM96 399.8c-19.2 0-32-12.76-32-31.9S76.8 336 96 336s48 28.71 48 47.85-28.8 15.95-48 15.95zm352-31.9c0 19.14-12.8 31.9-32 31.9s-48 3.19-48-15.95S396.8 336 416 336s32 12.76 32 31.9z"]],
    "car-side": [640, 512, [], "f5e4", ["M144 320a80 80 0 1 0 80 80 80 80 0 0 0-80-80zm352 0a80 80 0 1 0 80 80 80 80 0 0 0-80-80zM369.24 96H280v96h166zm-252.31 96H232V96h-76.67z", "M16 384h17.14a112 112 0 0 1 221.72 0h130.28a112 112 0 0 1 221.72 0H624a16 16 0 0 0 16-16v-80a96 96 0 0 0-96-96h-16L419.22 56a64 64 0 0 0-50-24H155.33a64 64 0 0 0-59.42 40.23L48 194.26A63.85 63.85 0 0 0 0 256v112a16 16 0 0 0 16 16zM280 96h89.24L446 192H280zm-124.67 0H232v96H116.93z"]],
    "car-tilt": [640, 512, [], "f5e5", ["M519.94 131a32.28 32.28 0 0 1 4 3.37l33.94 33.94a32 32 0 0 1 0 45.26l-22.63 22.62a32 32 0 0 1-45.25 0l-22.63-22.62 33.94-33.95A63.78 63.78 0 0 0 519.94 131zM293.57 68a48 48 0 0 0-52.85 10.18L150.92 168a48 48 0 0 0-10.18 52.85l21.14 49.32 181-181zM624 448H317.27a32 32 0 0 0-8.27-30.79l-22.63-22.62-33.94 33.94a63.86 63.86 0 0 1-48.62 18.65c.2.27.4.55.61.82H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h608a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M501.29 89.11l-22.63-22.62-11.31-11.32a63.86 63.86 0 0 0-71.42-13L318.78 9.15A111.44 111.44 0 0 0 195.47 32.9l-89.8 89.8A111.47 111.47 0 0 0 81.91 246L115 323.16a63.88 63.88 0 0 0 13 71.43l11.31 11.31 22.63 22.63a64 64 0 0 0 90.51 0l248.9-248.91a64 64 0 0 0-.06-90.51zm-283 282.71c-13.58 13.58-31.65 13.6-45.19.07s-13.5-31.61.07-45.18 54.24-13.64 67.78-.11-9.07 31.64-22.64 45.22zm-56.41-101.69l-21.14-49.32A48 48 0 0 1 150.92 168l89.8-89.81A48 48 0 0 1 293.57 68l49.33 21.11zm282.7-124.59c-13.58 13.58-31.69 36.2-45.22 22.67s-13.47-54.2.11-67.78 31.65-13.6 45.18-.07 13.51 31.64-.07 45.18z"]],
    "car-wash": [464, 512, [], "f5e6", ["M349.33,85.33C349.33,61.77,392,0,392,0s42.67,61.77,42.67,85.33a42.67,42.67,0,0,1-85.34,0ZM400,448H344v32a32,32,0,0,0,32,32h32a32,32,0,0,0,32-32V433.94A63.67,63.67,0,0,1,400,448ZM232,128a42.66,42.66,0,0,0,42.67-42.65v0C274.67,61.76,232,0,232,0s-42.67,61.77-42.67,85.33A42.69,42.69,0,0,0,232,128ZM340.07,254.18A48,48,0,0,0,295.5,224h-127a48,48,0,0,0-44.57,30.17L110.4,288H353.6ZM72,128a42.66,42.66,0,0,0,42.67-42.65v0C114.67,61.76,72,0,72,0S29.33,61.77,29.33,85.33A42.69,42.69,0,0,0,72,128ZM64,448a63.67,63.67,0,0,1-40-14.06V480a32,32,0,0,0,32,32H88a32,32,0,0,0,32-32V448Z", "M424.49,292.91l-5.07-12.67-19.93-49.83a111.47,111.47,0,0,0-104-70.4h-127a111.45,111.45,0,0,0-104,70.4L44.58,280.23,39.51,292.9A64,64,0,0,0,0,352v32a64,64,0,0,0,64,64H400a64,64,0,0,0,64-64V352A64,64,0,0,0,424.49,292.91ZM123.93,254.18A48,48,0,0,1,168.5,224h127a48,48,0,0,1,44.57,30.17L353.6,288H110.4ZM72,399.8c-19.2,0-32-12.76-32-31.9S52.8,336,72,336s48,28.71,48,47.85S91.2,399.8,72,399.8Zm352-31.9c0,19.14-12.8,31.9-32,31.9s-48,3.19-48-15.95S372.8,336,392,336,424,348.76,424,367.9Z"]],
    "caret-circle-down": [512, 512, [], "f32d", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm131.5 220.5l-123 123a12 12 0 0 1-17 0l-123-123A12 12 0 0 1 133 208h246a12 12 0 0 1 8.5 20.5z", "M387.5 228.5l-123 123a12 12 0 0 1-17 0l-123-123A12 12 0 0 1 133 208h246a12 12 0 0 1 8.5 20.5z"]],
    "caret-circle-left": [512, 512, [], "f32e", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm48 371a12 12 0 0 1-20.5 8.5l-123-123a12 12 0 0 1 0-17l123-123A12 12 0 0 1 304 133z", "M304 379a12 12 0 0 1-20.5 8.5l-123-123a12 12 0 0 1 0-17l123-123A12 12 0 0 1 304 133z"]],
    "caret-circle-right": [512, 512, [], "f330", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm95.5 256.5l-123 123A12 12 0 0 1 208 379V133a12 12 0 0 1 20.5-8.5l123 123a12 12 0 0 1 0 17z", "M351.5 264.5l-123 123A12 12 0 0 1 208 379V133a12 12 0 0 1 20.5-8.5l123 123a12 12 0 0 1 0 17z"]],
    "caret-circle-up": [512, 512, [], "f331", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm123 296H133a12 12 0 0 1-8.5-20.5l123-123a12 12 0 0 1 17 0l123 123A12 12 0 0 1 379 304z", "M379 304H133a12 12 0 0 1-8.5-20.5l123-123a12 12 0 0 1 17 0l123 123A12 12 0 0 1 379 304z"]],
    "caret-down": [320, 512, [], "f0d7", ["M160 168h128.92c17.85 0 26.8 22.48 14.17 35.63L174.17 337.89c-.26.28-.53.54-.8.8A19.41 19.41 0 0 1 160 344z", "M160 344a19.41 19.41 0 0 1-13.37-5.29c-.27-.26-.54-.52-.8-.8L16.91 203.63C4.28 190.48 13.23 168 31.08 168H160z"]],
    "caret-left": [192, 512, [], "f0d9", ["M184 256v128.91c0 17.85-22.48 26.8-35.63 14.17L14.1 270.16l-.8-.8A19.41 19.41 0 0 1 8 256z", "M8 256a19.39 19.39 0 0 1 5.29-13.36c.26-.28.53-.55.8-.81L148.36 112.9c13.15-12.63 35.63-3.68 35.63 14.17V256z"]],
    "caret-right": [192, 512, [], "f0da", ["M184 256a19.41 19.41 0 0 1-5.29 13.37l-.8.8L43.64 399.08C30.49 411.71 8 402.76 8 384.91V256z", "M8 256V127.07c0-17.85 22.48-26.8 35.63-14.17L177.9 241.82c.27.26.54.53.8.81A19.39 19.39 0 0 1 184 256z"]],
    "caret-square-down": [448, 512, [], "f150", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-51.37 182.31L232.06 348.16a10.38 10.38 0 0 1-16.12 0L99.37 214.31C92.17 206 97.28 192 107.43 192h233.14c10.15 0 15.26 14 8.06 22.31z", "M348.63 214.31L232.06 348.16a10.38 10.38 0 0 1-16.12 0L99.37 214.31C92.17 206 97.28 192 107.43 192h233.14c10.15 0 15.26 14 8.06 22.31z"]],
    "caret-square-left": [448, 512, [], "f191", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zM288 372.6c0 10.14-14.07 15.21-22.29 8L131.82 264a10.38 10.38 0 0 1 0-16.08l133.89-116.57c8.22-7.16 22.29-2.09 22.29 8.05z", "M288 372.6c0 10.14-14.07 15.21-22.29 8L131.82 264a10.38 10.38 0 0 1 0-16.08l133.89-116.57c8.22-7.16 22.29-2.09 22.29 8.05z"]],
    "caret-square-right": [448, 512, [], "f152", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-83.82 232L182.29 380.65c-8.22 7.16-22.29 2.09-22.29-8V139.4c0-10.14 14.06-15.21 22.29-8.05L316.18 248a10.38 10.38 0 0 1 0 16z", "M316.18 264L182.29 380.65c-8.22 7.16-22.29 2.09-22.29-8V139.4c0-10.14 14.07-15.21 22.29-8.05L316.18 248a10.38 10.38 0 0 1 0 16z"]],
    "caret-square-up": [448, 512, [], "f151", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-59.4 288H107.4c-10.14 0-15.21-14.07-8.05-22.29L216 163.82a10.38 10.38 0 0 1 16.08 0l116.57 133.89c7.16 8.22 2.09 22.29-8.05 22.29z", "M340.6 320H107.4c-10.14 0-15.21-14.07-8.05-22.29L216 163.82a10.38 10.38 0 0 1 16.08 0l116.57 133.89c7.16 8.22 2.09 22.29-8.05 22.29z"]],
    "caret-up": [320, 512, [], "f0d8", ["M160 168a19.41 19.41 0 0 1 13.37 5.29c.27.26.54.53.8.8l128.92 134.26c12.63 13.15 3.68 35.65-14.17 35.65H160z", "M160 344H31.08c-17.85 0-26.8-22.48-14.17-35.63l128.92-134.28c.26-.27.53-.54.8-.8A19.41 19.41 0 0 1 160 168z"]],
    "carrot": [512, 512, [], "f787", ["M298.15 156.6c-52.7-25.7-114.5-10.5-150.2 32.8l55.2 55.2a16 16 0 1 1-22.6 22.6l-50.2-50.2L2.25 479.7a22.68 22.68 0 0 0 0 19.7 22.48 22.48 0 0 0 30 10.3l133.6-65.2-49.2-49.2a15.87 15.87 0 0 1 0-22.6 16.06 16.06 0 0 1 22.6 0l57 57 102-49.8a124.23 124.23 0 0 0-.1-223.3z", "M390.25 121.7c40.7-19.5 88.8-9.4 121.7 30.3-41.6 50.3-107.5 52.5-151.9 7.9l-8-8C307.45 107.5 309.65 41.7 360 0c39.7 32.9 49.8 81 30.3 121.7z"]],
    "cars": [640, 512, [], "f85b", ["M252.13 243.23A131.77 131.77 0 0 1 375.07 160h38.41a57.49 57.49 0 0 0-32.9-36.44L376 112.2l-17.84-49.08A99.92 99.92 0 0 0 264.93 0H151.07a99.92 99.92 0 0 0-93.23 63.12L40 112.2l-4.55 11.36A57.39 57.39 0 0 0 0 176.55v28.69a57 57 0 0 0 21.52 44.46V288a32 32 0 0 0 32 32h22.07a32 32 0 0 0 32-32v-32h139.88zM111.11 92c6.53-16.92 22.36-28 40-28h113.82c17.6 0 33.42 11.1 40 28L317 128H99zM76 215.85c-14.4 0-24-9.57-24-23.92S61.6 168 76 168s36 21.53 36 35.89-21.6 11.96-36 11.96z", "M604.58 315.56L600 304.2l-17.87-49.08a99.92 99.92 0 0 0-93.2-63.12H375.07a99.92 99.92 0 0 0-93.23 63.12L264 304.2l-4.55 11.36a57.39 57.39 0 0 0-35.42 53v28.69a57 57 0 0 0 21.52 44.46V480a32 32 0 0 0 32 32h22.07a32 32 0 0 0 32-32v-32h200.79v32a32 32 0 0 0 32 32h22.07a32 32 0 0 0 32-32v-38.3A57 57 0 0 0 640 397.24v-28.69a57.39 57.39 0 0 0-35.42-52.99zM335.11 284c6.53-16.92 22.36-28 40-28h113.82c17.6 0 33.42 11.1 40 28L541 320H323zM300 407.85c-14.4 0-24-9.57-24-23.93S285.6 360 300 360s36 21.53 36 35.89-21.6 11.96-36 11.96zm264 0c-14.4 0-36 2.39-36-12S549.6 360 564 360s24 9.57 24 23.92-9.6 23.93-24 23.93z"]],
    "cart-arrow-down": [576, 512, [], "f218", ["M552 64H159.21l52.36 256h293.15a24 24 0 0 0 23.4-18.68l47.27-208a24 24 0 0 0-18.08-28.72A23.69 23.69 0 0 0 552 64zM444.42 196.48l-67.83 72a12.27 12.27 0 0 1-17.18 0l-67.83-72c-7.65-7.55-2.23-20.48 8.59-20.48h43.54v-52a12.07 12.07 0 0 1 12.14-12h24.29a12.07 12.07 0 0 1 12.15 12v52h43.54c10.82 0 16.24 12.93 8.59 20.48z", "M504.42 405.6l5.52-24.28a24 24 0 0 0-23.4-29.32H218.12L150 19.19A24 24 0 0 0 126.53 0H24A24 24 0 0 0 0 24v16a24 24 0 0 0 24 24h69.88l70.25 343.43a56 56 0 1 0 67.05 8.57h209.64a56 56 0 1 0 63.6-10.4zm-145-137.12a12.27 12.27 0 0 0 17.18 0l67.83-72c7.65-7.55 2.23-20.48-8.59-20.48h-43.55v-52a12.07 12.07 0 0 0-12.15-12h-24.29a12.07 12.07 0 0 0-12.14 12v52h-43.54c-10.82 0-16.24 12.93-8.59 20.48z"]],
    "cart-plus": [576, 512, [], "f217", ["M552 64H159.21l52.36 256h293.15a24 24 0 0 0 23.4-18.68l47.27-208a24 24 0 0 0-18.08-28.72A23.69 23.69 0 0 0 552 64zM448 200a16 16 0 0 1-16 16h-40v40a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-40h-40a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h40v-40a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v40h40a16 16 0 0 1 16 16z", "M504.42 405.6l5.52-24.28a24 24 0 0 0-23.4-29.32H218.12L150 19.19A24 24 0 0 0 126.53 0H24A24 24 0 0 0 0 24v16a24 24 0 0 0 24 24h69.88l70.25 343.43a56 56 0 1 0 67.05 8.57h209.64a56 56 0 1 0 63.6-10.4zM304 216h40v40a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16v-40h40a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16h-40v-40a16 16 0 0 0-16-16h-16a16 16 0 0 0-16 16v40h-40a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16z"]],
    "cash-register": [512, 512, [], "f788", ["M296.1 232a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm-48 128h16a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16h-16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16zm-16-112a16 16 0 0 0-16-16h-16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16zm-96 0a16 16 0 0 0-16-16h-16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16zm48 96v-16a16 16 0 0 0-16-16h-16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16zm160 88h-176a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h176a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zm16-120h-16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm48-80h-16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zM144 192l64 .1v-64h96a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16H48a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h96zM82 84V44h188v40z", "M511.2 378.8l-26.7-160a32 32 0 0 0-31.6-26.7L208 192v.06l-47.54-.06H59.2a32.09 32.09 0 0 0-31.6 26.7L.9 378.7a62 62 0 0 0-.9 10.5V480a32 32 0 0 0 32 32h448a32 32 0 0 0 32-32v-90.7a53.09 53.09 0 0 0-.8-10.5zM280.1 248a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v16a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16zm-32 64h16a16 16 0 0 1 16 16v16a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16zm-64-64a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v16a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16zm-64 32h-16a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v16a16 16 0 0 1-16 16zm16 64v-16a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v16a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16zm216 112a8 8 0 0 1-8 8h-176a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h176a8 8 0 0 1 8 8zm24-112a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16zm48-80a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16z"]],
    "cassette-tape": [512, 512, [], "f8ab", ["M147.78 384l-32 64h280.44l-32-64zM464 64H48a48 48 0 0 0-48 48v288a48 48 0 0 0 48 48h32l48-96h256l48 96h32a48 48 0 0 0 48-48V112a48 48 0 0 0-48-48zm-96 224H144a64 64 0 0 1 0-128h224a64 64 0 0 1 0 128z", "M368 160H144a64 64 0 0 0 0 128h224a64 64 0 0 0 0-128zm-224 80a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm61.73 0a57.52 57.52 0 0 0 0-32h100.54a57.52 57.52 0 0 0 0 32zM368 240a16 16 0 1 1 16-16 16 16 0 0 1-16 16z"]],
    "cat": [512, 512, [], "f6be", ["M448 96h-64l-64-64v134.4a96 96 0 0 0 192 0V32zm-72 80a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm80 0a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm-165.41 16a204.07 204.07 0 0 0-34.59 2.89V272l-43.15-64.73a183.93 183.93 0 0 0-44.37 26.17L192 304l-60.94-30.47L128 272v-80a96.1 96.1 0 0 0-96-96 32 32 0 0 0 0 64 32 32 0 0 1 32 32v256a64.06 64.06 0 0 0 64 64h176a16 16 0 0 0 16-16v-16a32 32 0 0 0-32-32h-32l128-96v144a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V289.86a126.78 126.78 0 0 1-32 4.54c-61.81 0-113.52-44.05-125.41-102.4z", "M376 144a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm80 0a16 16 0 1 0 16 16 16 16 0 0 0-16-16zM131.06 273.53L192 304l-23.52-70.56a192.06 192.06 0 0 0-37.42 40.09zM256 272v-77.11a198.62 198.62 0 0 0-43.15 12.38z"]],
    "cauldron": [448, 512, [], "f6bf", ["M160 0a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm112 32a48 48 0 1 0 48 48 48 48 0 0 0-48-48zM96 288a32 32 0 0 0 64 0V160H96z", "M434 224h-19.79c21.4 38.52 33.79 81.28 33.79 121.6 0 39.08-11.82 70.65-32 95.53V488a24 24 0 0 1-48 0v-7.49C329.05 501.81 278.86 512 224 512s-105-10.19-144-31.49V488a24 24 0 0 1-48 0v-46.87C11.82 416.25 0 384.68 0 345.6c0-40.32 12.39-83.08 33.79-121.6H14c-7.73 0-14-5.37-14-12v-40c0-6.63 6.27-12 14-12h82v128a32 32 0 0 0 64 0V160h274c7.73 0 14 5.37 14 12v40c0 6.63-6.27 12-14 12z"]],
    "cctv": [576, 512, [], "f8ac", ["M564.8 259.9l-57.2-25.15-153.78 96.11 150.68 66.25a18.74 18.74 0 0 0 24.69-9.61l45.22-102.91a18.74 18.74 0 0 0-9.61-24.69zM137.81 400H64v-32a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v128a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32h96a32 32 0 0 0 30-20.77l46.85-124.94-59.17-24.51z", "M4.23 183L99.57 16.13a32 32 0 0 1 39.67-13.84l378.2 166.29c24.33 9.73 27.29 43 5.08 56.85l-189.29 118.3a32 32 0 0 1-27.89 2.94L21.08 228.93A32 32 0 0 1 4.23 183z"]],
    "certificate": [512, 512, [], "f0a3", ["M458.63 255.92l46-45c13.71-13 7.34-36-10.66-40.34l-62.66-16 17.69-62c5-17.85-11.84-34.67-29.69-29.67l-62 17.65-16-62.67C337.09.2 313.75-6.28 301 7.23l-45 46.35-45-46.35C198.37-6.13 175 0 170.69 17.89l-16 62.67-62-17.65c-17.82-5-34.63 11.82-29.69 29.67l17.69 62-62.66 16c-18 4.3-24.37 27.36-10.66 40.34l46 45-46 45C-6.31 313.91.06 337 18.06 341.27l62.66 16-17.72 62c-5 17.84 11.84 34.67 29.69 29.67l62-17.67 16 62.67c4.43 18.58 27.68 24 40.31 10.67l45-46 45 46c12.5 13.49 36 7.49 40.31-10.67l16-62.67 62 17.67c17.85 5 34.66-11.83 29.66-29.67l-17.66-62 62.66-16c18-4.31 24.37-27.38 10.66-40.35zm-39.84 32.79a12 12 0 0 1-5.43 20.2l-45.95 11.73 12.71 44.63a12 12 0 0 1-14.83 14.83l-44.58-12.71-11.74 46a12 12 0 0 1-20.2 5.43L256 385.34l-32.75 33.47a12 12 0 0 1-20.25-5.43l-11.74-46-44.53 12.72a12 12 0 0 1-14.83-14.83l12.74-44.63-46-11.73a12 12 0 0 1-5.43-20.2L126.67 256 93.2 223.21A12 12 0 0 1 98.63 203l46-11.73-12.73-44.67a12 12 0 0 1 14.83-14.83l44.61 12.71L203 99a12 12 0 0 1 20.24-5.4L256 127.39l32.82-33.81A12 12 0 0 1 309.06 99l11.61 45.5 44.58-12.7a12 12 0 0 1 14.83 14.83l-12.71 44.63 46 11.74a12 12 0 0 1 5.43 20.2L385.34 256z", "M418.79 288.71a12 12 0 0 1-5.43 20.2l-45.95 11.73 12.71 44.63a12 12 0 0 1-14.83 14.83l-44.58-12.71-11.74 46a12 12 0 0 1-20.2 5.43L256 385.34l-32.75 33.47a12 12 0 0 1-20.25-5.43l-11.74-46-44.53 12.72a12 12 0 0 1-14.83-14.83l12.74-44.63-46-11.73a12 12 0 0 1-5.43-20.2L126.67 256 93.2 223.21A12 12 0 0 1 98.63 203l46-11.73-12.73-44.67a12 12 0 0 1 14.83-14.83l44.61 12.71L203 99a12 12 0 0 1 20.24-5.4L256 127.39l32.82-33.81A12 12 0 0 1 309.06 99l11.61 45.5 44.58-12.7a12 12 0 0 1 14.83 14.83l-12.71 44.63 46 11.74a12 12 0 0 1 5.43 20.2L385.34 256z"]],
    "chair": [448, 512, [], "f6c0", ["M112 256H64V128A128 128 0 0 1 192 0h64a128 128 0 0 1 128 128v128h-48V128c0-29.5-16.2-55-40-68.9V256h-48V48h-48v208h-48V59.1C128.24 73 112 98.5 112 128z", "M416.05 384v112a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V384H96v112a16 16 0 0 1-16 16H48a16 16 0 0 1-16-16V384a32.07 32.07 0 0 1-30.4-42.1l10.7-32A32 32 0 0 1 42.71 288h362.54a32 32 0 0 1 30.4 21.9l10.71 32a32 32 0 0 1-30.31 42.1z"]],
    "chair-office": [448, 512, [], "f6c1", ["M352 256H96V64a64 64 0 0 1 64-64h128a64 64 0 0 1 64 64z", "M64 224v-64a32 32 0 0 0-64 0v64a32 32 0 0 0 64 0zm352-96a32 32 0 0 0-32 32v64a32 32 0 0 0 64 0v-64a32 32 0 0 0-32-32zm-12.33 181.88A32 32 0 0 0 373.31 288H74.69a32 32 0 0 0-30.36 21.88l-10.67 32A32 32 0 0 0 64 384h128v67.36c-28.27 6-51 19.69-61.85 37.21-6.41 10.34 2.41 23.43 15 23.43h157.68c12.61 0 21.44-13.09 15-23.43-10.83-17.52-33.57-31.2-61.83-37.21V384h128a32 32 0 0 0 30.36-42.12z"]],
    "chalkboard": [640, 512, [], "f51b", ["M624 448h-16V40a40 40 0 0 0-40-40H72a40 40 0 0 0-40 40v408H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h608a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-528 0V64h448v384z", "M544 64v384h-64v-64H288v64H96V64z"]],
    "chalkboard-teacher": [640, 512, [], "f51c", ["M640 49.59v316.82c0 27.34-21.53 49.59-48 49.59H343.79c-.9-2.53-1.86-5.05-2.9-7.54A144.52 144.52 0 0 0 298.51 352H576V64H224v49.1a127 127 0 0 0-59.46-17h-.33c-1.4 0-2.8-.08-4.21-.08V49.59C160 22.25 181.53 0 208 0h384c26.47 0 48 22.25 48 49.59z", "M208 352a22.88 22.88 0 0 0-7.06 1.09A131.91 131.91 0 0 1 160 360a132 132 0 0 1-40.95-6.91 22.82 22.82 0 0 0-7-1.09A112 112 0 0 0 0 464.62C.14 490.88 21.73 512 48 512h224c26.27 0 47.86-21.12 48-47.38A112 112 0 0 0 208 352zm-48-32a96 96 0 1 0-96-96 96 96 0 0 0 96 96zm64-256v49.09a129 129 0 0 1 26.51 20.4 128 128 0 0 1 0 181 132.13 132.13 0 0 1-10.14 9.14A143.89 143.89 0 0 1 298.51 352H384v-64h128v64h64V64z"]],
    "charging-station": [576, 512, [], "f5e7", ["M256 0H96a64 64 0 0 0-64 64v384h288V64a64 64 0 0 0-64-64zm4.09 175.76l-93.7 139A12.41 12.41 0 0 1 156 320c-7.67 0-13.47-6.28-11.67-12.92l23-83.08H108c-7.25 0-12.85-5.59-11.89-11.89l16-107C112.9 99.9 118 96 124 96h68c7.88 0 13.62 6.54 11.6 13.21L192 160h57.7c9.24 0 15.01 8.78 10.39 15.76z", "M336 448H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM108 224h59.33l-23 83.08c-1.8 6.64 4 12.92 11.67 12.92a12.41 12.41 0 0 0 10.39-5.24l93.7-139c4.62-7-1.15-15.76-10.39-15.76H192l11.6-50.79c2-6.67-3.72-13.21-11.6-13.21h-68c-6 0-11.1 3.9-11.89 9.11l-16 107c-.96 6.3 4.64 11.89 11.89 11.89zm452-96h-16V80a16 16 0 0 0-32 0v48h-32V80a16 16 0 0 0-32 0v48h-16a16 16 0 0 0-16 16v32c0 35.76 23.62 65.69 56 75.93v118.49c0 13.95-9.5 26.92-23.26 29.19A28 28 0 0 1 416 372v-28a88 88 0 0 0-88-88h-8v48h8a40 40 0 0 1 40 40v24.61c0 39.67 28.92 75.16 68.41 79a76.08 76.08 0 0 0 83.22-68.18c.24-2.47.37-4.95.37-7.43V251.93c32.38-10.24 56-40.17 56-75.93v-32a16 16 0 0 0-16-16z"]],
    "chart-area": [512, 512, [], "f1fe", ["M500 384a12 12 0 0 1 12 12v40a12 12 0 0 1-12 12H12a12 12 0 0 1-12-12V76a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12v308z", "M390.1 164.2L480 352H96V248l86.8-144.7a12 12 0 0 1 19.9-1L288 216l84.7-56.5a12 12 0 0 1 17.4 4.7z"]],
    "chart-bar": [512, 512, [], "f080", ["M512 400v32a16 16 0 0 1-16 16H32a32 32 0 0 1-32-32V80a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v304h432a16 16 0 0 1 16 16z", "M275.2 96h-38.4c-6.4 0-12.8 6.4-12.8 12.8v198.4c0 6.4 6.4 12.8 12.8 12.8h38.4c6.4 0 12.8-6.4 12.8-12.8V108.8c0-6.4-6.4-12.8-12.8-12.8zm-96 128h-38.4c-6.4 0-12.8 6.4-12.8 12.8v70.4c0 6.4 6.4 12.8 12.8 12.8h38.4c6.4 0 12.8-6.4 12.8-12.8v-70.4c0-6.4-6.4-12.8-12.8-12.8zm288-160h-38.4c-6.4 0-12.8 6.4-12.8 12.8v230.4c0 6.4 6.4 12.8 12.8 12.8h38.4c6.4 0 12.8-6.4 12.8-12.8V76.8c0-6.4-6.4-12.8-12.8-12.8zm-96 96h-38.4c-6.4 0-12.8 6.4-12.8 12.8v134.4c0 6.4 6.4 12.8 12.8 12.8h38.4c6.4 0 12.8-6.4 12.8-12.8V172.8c0-6.4-6.4-12.8-12.8-12.8z"]],
    "chart-line": [512, 512, [], "f201", ["M512 400v32a16 16 0 0 1-16 16H32a32 32 0 0 1-32-32V80a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v304h432a16 16 0 0 1 16 16z", "M480 112v118.05c0 21.38-25.85 32.09-41 17l-32.4-32.4-96 96a32 32 0 0 1-45.25 0L192 237.25l-46.06 46.07a16 16 0 0 1-22.63 0l-22.62-22.62a16 16 0 0 1 0-22.63l68.69-68.69a32 32 0 0 1 45.25 0L288 242.75l73.37-73.38L329 137c-15.12-15.12-4.41-41 17-41h118a16 16 0 0 1 16 16z"]],
    "chart-line-down": [512, 512, [], "f64d", ["M512 400v32a16 16 0 0 1-16 16H32a32 32 0 0 1-32-32V80a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v304h432a16 16 0 0 1 16 16z", "M464 320H346c-21.38 0-32.09-25.85-17-41l32.4-32.4-73.4-73.35-73.37 73.38a32 32 0 0 1-45.25 0l-68.69-68.69a16 16 0 0 1 0-22.63l22.62-22.62a16 16 0 0 1 22.63 0L192 178.75l73.38-73.38a32 32 0 0 1 45.25 0l96 96L439 169c15.12-15.12 41-4.41 41 17v118a16 16 0 0 1-16 16z"]],
    "chart-network": [640, 512, [], "f78a", ["M64 240a64 64 0 1 0 64 64 64.06 64.06 0 0 0-64-64zm88 80h48v-32h-48zm294.4-106.8l19.2 25.6 48-36-19.2-25.6zM576 64a64 64 0 1 0 64 64 64.06 64.06 0 0 0-64-64z", "M576 384a63.84 63.84 0 0 0-38.3 13l-96-57.6a109.91 109.91 0 0 0 6.3-35.5 111.94 111.94 0 0 0-112-112 108.64 108.64 0 0 0-24.4 2.9l-40.8-87.4A63.84 63.84 0 1 0 224 128c1.1 0 2.1-.3 3.2-.3l41 87.8C241.5 235.9 224 267.8 224 304a111.71 111.71 0 0 0 193.2 76.7l95.8 57.5a63.87 63.87 0 1 0 63-54.2zm-240-32a48 48 0 1 1 48-48 48 48 0 0 1-48 48z"]],
    "chart-pie": [544, 512, [], "f200", ["M379.86 443.87c6.85 6.85 6.33 18.48-1.57 24.08A238.14 238.14 0 0 1 243 512C114.83 513.59 4.5 408.51.14 280.37-4.1 155.6 87 51.49 206.16 34.65c9.45-1.34 17.84 6.51 17.84 16.06V288z", "M512 223.2C503.72 103.74 408.26 8.28 288.8 0 279.68-.59 272 7.1 272 16.24V240h223.77c9.14 0 16.82-7.68 16.23-16.8zm15.79 64.8H290.5l158 158c6 6 16 6.53 22.19.68a239.5 239.5 0 0 0 73.13-140.86c1.37-9.43-6.48-17.82-16.03-17.82z"]],
    "chart-pie-alt": [512, 512, [], "f64e", ["M461.29 288c9.54 0 17.39 8.39 16.06 17.84C460.53 424.92 356.57 516 231.93 511.87 107.91 507.8 4.2 404.1.13 280.07c-4.09-124.64 87-228.6 206-245.42 9.48-1.33 17.87 6.51 17.87 16.06V288z", "M512 223.2c.62 9.11-7 16.8-16.19 16.8H272V16.24C272 7.1 279.68-.59 288.8 0 408.26 8.28 503.72 103.74 512 223.2z"]],
    "chart-scatter": [512, 512, [], "f7ee", ["M512 400v32a16 16 0 0 1-16 16H32a32 32 0 0 1-32-32V80a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v304h432a16 16 0 0 1 16 16z", "M160 256a32 32 0 1 0 32 32 32 32 0 0 0-32-32zM416 96a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm-224 0a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm192 160a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm-96-64a32 32 0 1 0 32 32 32 32 0 0 0-32-32z"]],
    "check": [512, 512, [], "f00c", ["M504.5 144.42L264.75 385.5 192 312.59l240.11-241a25.49 25.49 0 0 1 36.06-.14l.14.14L504.5 108a25.86 25.86 0 0 1 0 36.42z", "M264.67 385.59l-54.57 54.87a25.5 25.5 0 0 1-36.06.14l-.14-.14L7.5 273.1a25.84 25.84 0 0 1 0-36.41l36.2-36.41a25.49 25.49 0 0 1 36-.17l.16.17z"]],
    "check-circle": [512, 512, [], "f058", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm155.31 195.31l-184 184a16 16 0 0 1-22.62 0l-104-104a16 16 0 0 1 0-22.62l22.62-22.63a16 16 0 0 1 22.63 0L216 308.12l150.06-150.06a16 16 0 0 1 22.63 0l22.62 22.63a16 16 0 0 1 0 22.62z", "M227.31 387.31a16 16 0 0 1-22.62 0l-104-104a16 16 0 0 1 0-22.62l22.62-22.63a16 16 0 0 1 22.63 0L216 308.12l150.06-150.06a16 16 0 0 1 22.63 0l22.62 22.63a16 16 0 0 1 0 22.62l-184 184z"]],
    "check-double": [512, 512, [], "f560", ["M166.57 282.71L44 159.21a17.87 17.87 0 0 1 .18-25.2l42.1-41.77a17.87 17.87 0 0 1 25.2.18l68.23 68.77L336.87 5.11a17.88 17.88 0 0 1 25.21.18L404 47.41a17.88 17.88 0 0 1-.18 25.21L191.78 282.89a17.88 17.88 0 0 1-25.21-.18z", "M504.5 172a25.86 25.86 0 0 1 0 36.42L210.1 504.46a25.48 25.48 0 0 1-36.2 0L7.5 337.1a25.84 25.84 0 0 1 0-36.41l36.2-36.41a25.48 25.48 0 0 1 36.2 0L192 377l240.1-241.46a25.5 25.5 0 0 1 36.2 0L504.5 172z"]],
    "check-square": [448, 512, [], "f14a", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-20.69 165.94l-184 184a16 16 0 0 1-22.62 0l-104-104a16 16 0 0 1 0-22.63l22.62-22.62a16 16 0 0 1 22.63 0L184 302.75l150.06-150.06a16 16 0 0 1 22.63 0l22.62 22.62a16 16 0 0 1 0 22.63z", "M195.31 381.94a16 16 0 0 1-22.62 0l-104-104a16 16 0 0 1 0-22.63l22.62-22.62a16 16 0 0 1 22.63 0L184 302.74l150.06-150a16 16 0 0 1 22.63 0l22.62 22.62a16 16 0 0 1 0 22.63l-184 184z"]],
    "cheese": [512, 512, [], "f7ef", ["M299.83 32C418 38.22 512 136.13 512 256H0L278.7 39a32 32 0 0 1 21.13-7z", "M512 288v160a32 32 0 0 1-32 32H32a32 32 0 0 1-32-32V288z"]],
    "cheese-swiss": [512, 512, [], "f7f0", ["M299.83 32C418 38.22 512 136.13 512 256H0l141.84-110.44a47.91 47.91 0 0 0 75.1-58.48L278.7 39a32 32 0 0 1 21.13-7z", "M416 288a48 48 0 0 1-96 0H0v160a32 32 0 0 0 32 32h448a32 32 0 0 0 32-32V288zM176 432a48 48 0 1 1 48-48 48 48 0 0 1-48 48z"]],
    "cheeseburger": [512, 512, [], "f7f1", ["M58.6 224h394.7c34.6 0 54.6-43.9 34.8-75.9C448 83.2 359.5 32.1 256 32c-103.5.1-192 51.2-232.2 116.1-19.8 32 .3 75.9 34.8 75.9zM384 112a16 16 0 1 1-16 16 16 16 0 0 1 16-16zM256 80a16 16 0 1 1-16 16 16 16 0 0 1 16-16zm-128 32a16 16 0 1 1-16 16 16 16 0 0 1 16-16zm352 272H32a16 16 0 0 0-16 16v16a64.06 64.06 0 0 0 64 64h352a64.06 64.06 0 0 0 64-64v-16a16 16 0 0 0-16-16z", "M512 304a48 48 0 0 1-48 48H48a48 48 0 0 1 0-96h176l96 64 96-64h48a48 48 0 0 1 48 48z"]],
    "chess": [512, 512, [], "f439", ["M247.16 459.58L224 448v-16a16 16 0 0 0-16-16H48a16 16 0 0 0-16 16v16L8.84 459.58A16 16 0 0 0 0 473.89V496a16 16 0 0 0 16 16h224a16 16 0 0 0 16-16v-22.11a16 16 0 0 0-8.84-14.31zm256 0L480 448v-16a16 16 0 0 0-16-16H336a16 16 0 0 0-16 16v16l-23.16 11.58a16 16 0 0 0-8.84 14.31V496a16 16 0 0 0 16 16h192a16 16 0 0 0 16-16v-22.11a16 16 0 0 0-8.84-14.31z", "M200.91 96H144V64h24a8 8 0 0 0 8-8V40a8 8 0 0 0-8-8h-24V8a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v24H88a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h24v32H55.09a16 16 0 0 0-15 21.62L74 208H64a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h15.94A535.78 535.78 0 0 1 64 384h128a535.78 535.78 0 0 1-15.94-128H192a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16h-10l33.89-90.38A16 16 0 0 0 200.91 96zM490 192h-26.38a6 6 0 0 0-6 6v26h-24.71v-26a6 6 0 0 0-6-6H373.1a6 6 0 0 0-6 6v26h-24.71v-26a6 6 0 0 0-6-6H310a6 6 0 0 0-6 6v58.6a32 32 0 0 0 11.36 24.4l24.57 20.76-3.29 82.24h126.72l-3.29-82.21 24.6-20.79A32 32 0 0 0 496 256.54V198a6 6 0 0 0-6-6z"]],
    "chess-bishop": [320, 512, [], "f43a", ["M304 448H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h288a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M8 287.88c0 51.64 22.14 73.83 56 84.6V416h192v-43.52c33.86-10.77 56-33 56-84.6 0-30.61-10.73-67.1-26.69-102.56L185 285.65a8 8 0 0 1-11.31 0l-11.31-11.31a8 8 0 0 1 0-11.31L270.27 155.1c-20.8-37.91-46.47-72.1-70.87-92.59C213.4 59.09 224 47.05 224 32a32 32 0 0 0-32-32h-64a32 32 0 0 0-32 32c0 15 10.6 27.09 24.6 30.51C67.81 106.8 8 214.5 8 287.88z"]],
    "chess-bishop-alt": [256, 512, [], "f43b", ["M247.16 459.58L224 448v-16a16 16 0 0 0-16-16H48a16 16 0 0 0-16 16v16L8.85 459.58A16 16 0 0 0 0 473.89V496a16 16 0 0 0 16 16h224a16 16 0 0 0 16-16v-22.11a16 16 0 0 0-8.84-14.31z", "M64 288h14.89A535.84 535.84 0 0 1 64 384h128a535.84 535.84 0 0 1-14.89-96H192a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16h-11.67c16-6.67 26.48-25.09 26.48-50.43 0-19.32-7.2-42.34-17.73-63.33l-48.59 48.59a4 4 0 0 1-5.66 0l-5.66-5.66a4 4 0 0 1 0-5.65L181 111.7c-10.22-16.81-22.2-31.22-33.86-39.33C155.31 69.59 160 61.85 160 52.73 160 41.28 151.92 32 140.47 32h-24.94C104.08 32 96 41.28 96 52.73c0 9.12 4.69 16.86 12.87 19.64-28.58 19.87-59.68 76.75-59.68 117.2 0 25.34 10.49 43.76 26.48 50.43H64a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16z"]],
    "chess-board": [512, 512, [], "f43c", ["M512 256v-64h-64v64zM448 0h-64v64h64zm64 128V64h-64v64zm-256 64h-64v64h64zM320 0h-64v64h64zm192 384v-64h-64v64zm0 128v-64h-64v64zM256 128V64h-64v64zM64 512h64v-64H64zm128 0h64v-64h-64zM0 384v64h64v-64zm320 128h64v-64h-64zM0 128v64h64v-64zM0 0v64h64V0zm0 256v64h64v-64zM192 0h-64v64h64zm192 320h64v-64h-64zm-128-64v64h64v-64zm-128-64H64v64h64zm64 128v64h64v-64zm128 0v64h64v-64zm-192 0H64v64h64zm0-256H64v64h64zm256 128h64v-64h-64zM128 384v64h64v-64zm192-128h64v-64h-64zm128 128h-64v64h64zM192 256h-64v64h64zm128-64v-64h-64v64zm-64 192v64h64v-64zm128-256V64h-64v64zm-192 0h-64v64h64z", "M256 0h-64v64h64zM0 64v64h64V64zM128 0H64v64h64zm64 256v64h64v-64zM0 192v64h64v-64zM384 0h-64v64h64zm128 0h-64v64h64zM128 256H64v64h64zm384 192v-64h-64v64zm0-128v-64h-64v64zM384 512h64v-64h-64zm128-320v-64h-64v64zM128 512h64v-64h-64zM0 512h64v-64H0zm256 0h64v-64h-64zM0 320v64h64v-64zm320-192V64h-64v64zm-64 128h64v-64h-64zm-64 128v64h64v-64zm128-64h64v-64h-64zm0-128h64v-64h-64zm0 192v64h64v-64zm-256 0v64h64v-64zm128-256V64h-64v64zm192 256h64v-64h-64zM256 192v-64h-64v64zM384 64v64h64V64zM256 320v64h64v-64zm-64-128h-64v64h64zm192 64h64v-64h-64zM128 128H64v64h64zm0 192v64h64v-64z"]],
    "chess-clock": [640, 512, [], "f43d", ["M519.48 243a12 12 0 0 0-17 0l-50.9 50.89a12 12 0 0 0 0 17l5.66 5.66a12 12 0 0 0 17 0l50.9-50.9a12 12 0 0 0 0-17zm-339.19-18.86h-8a12 12 0 0 0-12 12v72a12 12 0 0 0 12 12h8a12 12 0 0 0 12-12v-72a12 12 0 0 0-12-12zM240.06 32h-128a16 16 0 0 0-16 16v15.94a16 16 0 0 0 16 16h40.19V128h48V79.94h39.81a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zM528 96H400a16 16 0 0 0-16 16v16h160v-16a16 16 0 0 0-16-16z", "M600 128H40a40 40 0 0 0-40 40v272a40 40 0 0 0 40 40h560a40 40 0 0 0 40-40V168a40 40 0 0 0-40-40zM176.29 416.06a112 112 0 1 1 112-111.95 111.95 111.95 0 0 1-112 111.95zm288 0a112 112 0 1 1 112-111.95 111.95 111.95 0 0 1-112 111.95z"]],
    "chess-clock-alt": [640, 512, [], "f43e", ["M231.12 243a12 12 0 0 0-17 0l-50.89 50.89a12 12 0 0 0 0 17l5.65 5.66a12 12 0 0 0 17 0l50.89-50.9a12 12 0 0 0 0-17zm236.7-18.84h-8a12 12 0 0 0-12 12v72a12 12 0 0 0 12 12h8a12 12 0 0 0 12-12v-72a12 12 0 0 0-12-12.02zM239.91 96h-128a16 16 0 0 0-16 16v16h160v-16a16 16 0 0 0-16-16zM528 32H400a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h39.75v48h48V80H528a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z", "M600 128H40a40.17 40.17 0 0 0-40 40.11V440a40 40 0 0 0 40 40h560a40 40 0 0 0 40-40V168.11A40.17 40.17 0 0 0 600 128zM175.93 416.06a112 112 0 1 1 112-111.95 111.95 111.95 0 0 1-112 111.95zm287.89 0a112 112 0 1 1 112-111.95 111.95 111.95 0 0 1-112 111.95z"]],
    "chess-king": [448, 512, [], "f43f", ["M400 448H48a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h352a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M416 160H256v-48h40a8 8 0 0 0 8-8V56a8 8 0 0 0-8-8h-40V8a8 8 0 0 0-8-8h-48a8 8 0 0 0-8 8v40h-40a8 8 0 0 0-8 8v48a8 8 0 0 0 8 8h40v48H32a32 32 0 0 0-30.52 41.54L74.56 416h298.88l73.08-214.46A32 32 0 0 0 416 160z"]],
    "chess-king-alt": [320, 512, [], "f440", ["M279.16 459.58L256 448v-16a16 16 0 0 0-16-16H80a16 16 0 0 0-16 16v16l-23.15 11.58A16 16 0 0 0 32 473.89V496a16 16 0 0 0 16 16h224a16 16 0 0 0 16-16v-22.11a16 16 0 0 0-8.84-14.31z", "M106 208H96a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h15.94A535.78 535.78 0 0 1 96 384h128a535.78 535.78 0 0 1-15.94-128H224a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16h-10l33.89-90.38a16 16 0 0 0-15-21.62H176V64h24a8 8 0 0 0 8-8V40a8 8 0 0 0-8-8h-24V8a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v24h-24a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h24v32H87.09a16 16 0 0 0-15 21.62z"]],
    "chess-knight": [384, 512, [], "f441", ["M368 448H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h352a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M159.94 32H12A12 12 0 0 0 0 44a16.9 16.9 0 0 0 1.79 7.58L16 80l-9 9a24 24 0 0 0-7 17v137.21a32 32 0 0 0 19 29.26l40.63 18.06a32 32 0 0 0 24.88.47l12.79-5.12a32 32 0 0 0 18.75-20.5l9.22-30.65a24 24 0 0 1 12.55-15.65L159.94 208v50.33a48 48 0 0 1-26.53 42.94L76.2 329.92A80 80 0 0 0 32 401.48V416h319.86V224c0-106-85.92-192-191.92-192zM52 168a20 20 0 1 1 20-20 20 20 0 0 1-20 20z"]],
    "chess-knight-alt": [320, 512, [], "f442", ["M320 473.89V496a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-22.11a16 16 0 0 1 8.85-14.31L32 448v-16a16 16 0 0 1 16-16h224a16 16 0 0 1 16 16v16l23.16 11.58a16 16 0 0 1 8.84 14.31z", "M45.55 235.52l28.83 12.86a22.59 22.59 0 0 0 17.67.34l9.09-3.65a22.79 22.79 0 0 0 13.33-14.62l6.53-21.87a17.09 17.09 0 0 1 8.92-11.15l14.2-5.43v37.21a28.58 28.58 0 0 1-16.9 26.09L80.68 279C40.87 299.22 32.42 352.42 64 384h192c7-7.85 16-18.31 16-32V203.16C272 126.62 209.38 64 132.84 64H40.52A8.54 8.54 0 0 0 32 72.56 12.14 12.14 0 0 0 33.27 78l10.1 20.28-6.37 6.35a17.21 17.21 0 0 0-5 12.11v97.9a22.86 22.86 0 0 0 13.55 20.88zM80.07 128a16 16 0 1 1-15.94 16 16 16 0 0 1 15.94-16z"]],
    "chess-pawn": [320, 512, [], "f443", ["M304 448H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h288a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M105.1 224H80a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h16v5.49c0 44-4.14 86.6-24 122.51h176c-19.89-35.91-24-78.51-24-122.51V288h16a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-25.1c29.39-18.38 49.1-50.78 49.1-88a104 104 0 0 0-208 0c0 37.22 19.71 69.62 49.1 88z"]],
    "chess-pawn-alt": [256, 512, [], "f444", ["M247.16 459.58L224 448v-16a16 16 0 0 0-16-16H48a16 16 0 0 0-16 16v16L8.85 459.58A16 16 0 0 0 0 473.89V496a16 16 0 0 0 16 16h224a16 16 0 0 0 16-16v-22.11a16 16 0 0 0-8.84-14.31z", "M64 288h14.89A535.84 535.84 0 0 1 64 384h128a535.84 535.84 0 0 1-14.89-96H192a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16h-16.44a80 80 0 1 0-95.12 0H64a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16z"]],
    "chess-queen": [512, 512, [], "f445", ["M432 448H80a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h352a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M256 112a56 56 0 1 0-56-56 56 56 0 0 0 56 56zm248.88 72.16l-28.52-15.92c-7.44-5-16.91-2.46-22.29 4.68a47.59 47.59 0 0 1-47.23 18.23C383.7 186.86 368 164.93 368 141.4a13.4 13.4 0 0 0-13.4-13.4h-38.77c-6 0-11.61 4-12.85 9.91a48 48 0 0 1-94 0c-1.24-5.92-6.81-9.91-12.85-9.91H157.4a13.4 13.4 0 0 0-13.4 13.4c0 25.69-19 48.75-44.67 50.49a47.49 47.49 0 0 1-41.54-19.15c-5.28-7.09-14.73-9.45-22.09-4.54l-28.58 16a16 16 0 0 0-5.43 20.47L104.24 416h303.52l102.55-211.37a16 16 0 0 0-5.43-20.47z"]],
    "chess-queen-alt": [256, 512, [], "f446", ["M256 473.89V496a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-22.11a16 16 0 0 1 8.85-14.31L32 448v-16a16 16 0 0 1 16-16h160a16 16 0 0 1 16 16v16l23.16 11.58a16 16 0 0 1 8.84 14.31z", "M128 48a24 24 0 1 0-24-24 24 24 0 0 0 24 24zm102.84 39.65l-10.06-6.71c-3.13-2.08-7.12-1-9.38 2a20.05 20.05 0 0 1-19.89 7.67c-9.74-1.81-16.35-11-16.35-21a5.65 5.65 0 0 0-5.64-5.61h-16.33a5.45 5.45 0 0 0-5.41 4.17 20.22 20.22 0 0 1-39.56 0 5.45 5.45 0 0 0-5.41-4.17H86.49a5.65 5.65 0 0 0-5.65 5.64c0 10.82-8 20.53-18.81 21.26a20 20 0 0 1-17.49-8.06 6.81 6.81 0 0 0-9.3-1.91l-10.08 6.72a6.73 6.73 0 0 0-2.29 8.62L67.37 192H64a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h16v14a535.76 535.76 0 0 1-16 130h128a535.76 535.76 0 0 1-16-130v-14h16a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16h-3.37l44.5-95.73a6.73 6.73 0 0 0-2.29-8.62z"]],
    "chess-rook": [384, 512, [], "f447", ["M368 448H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h352a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M384 48a16 16 0 0 0-16-16h-56a16 16 0 0 0-16 16v48h-48V48a16 16 0 0 0-16-16h-80a16 16 0 0 0-16 16v48H88.1V48a16 16 0 0 0-16-16H16A16 16 0 0 0 0 48v176l64 32c0 48.33-1.54 95-13.21 160h282.42C321.54 351 320 303.72 320 256l64-32zM224 320h-64v-64a32 32 0 0 1 64 0z"]],
    "chess-rook-alt": [320, 512, [], "f448", ["M320 473.89V496a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-22.11a16 16 0 0 1 8.85-14.31L32 448v-16a16 16 0 0 1 16-16h224a16 16 0 0 1 16 16v16l23.16 11.58a16 16 0 0 1 8.84 14.31z", "M71.81 210.32L57.33 384h205.34l-14.48-173.7 30.62-31.11a32 32 0 0 0 9.19-22.45V72a8 8 0 0 0-8-8h-35.18a8 8 0 0 0-8 8v40h-32.94V72a8 8 0 0 0-8-8h-71.75a8 8 0 0 0-8 8v40H83.19V72a8 8 0 0 0-8-8H40a8 8 0 0 0-8 8v84.82a32 32 0 0 0 9.21 22.47zm64.6 21.27a23.59 23.59 0 0 1 47.18 0v47.18h-47.18z"]],
    "chevron-circle-down": [512, 512, [], "f13a", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm152.5 226.4L273 369.9a24 24 0 0 1-34 0L103.5 234.4a23.9 23.9 0 0 1 0-33.9l17-17a23.9 23.9 0 0 1 33.9 0L256 285.1l101.6-101.6a23.9 23.9 0 0 1 33.9 0l17 17a23.9 23.9 0 0 1 0 33.9z", "M239 369.9L103.5 234.4a23.9 23.9 0 0 1 0-33.9l17-17a23.9 23.9 0 0 1 33.9 0L256 285.1l101.6-101.6a23.9 23.9 0 0 1 33.9 0l17 17a23.9 23.9 0 0 1 0 33.9L273 369.9a24 24 0 0 1-34 0z"]],
    "chevron-circle-left": [512, 512, [], "f137", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm72.5 349.6a23.9 23.9 0 0 1 0 33.9l-17 17a23.9 23.9 0 0 1-33.9 0L142.1 273a24 24 0 0 1 0-34l135.5-135.5a23.9 23.9 0 0 1 33.9 0l17 17a23.9 23.9 0 0 1 0 33.9L226.9 256z", "M142.1 239l135.5-135.5a23.9 23.9 0 0 1 33.9 0l17 17a23.9 23.9 0 0 1 0 33.9L226.9 256l101.6 101.6a23.9 23.9 0 0 1 0 33.9l-17 17a23.9 23.9 0 0 1-33.9 0L142.1 273a24 24 0 0 1 0-34z"]],
    "chevron-circle-right": [512, 512, [], "f138", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm113.9 265L234.4 408.5a23.9 23.9 0 0 1-33.9 0l-17-17a23.9 23.9 0 0 1 0-33.9L285.1 256 183.5 154.4a23.9 23.9 0 0 1 0-33.9l17-17a23.9 23.9 0 0 1 33.9 0L369.9 239a24 24 0 0 1 0 34z", "M369.9 273L234.4 408.5a23.9 23.9 0 0 1-33.9 0l-17-17a23.9 23.9 0 0 1 0-33.9L285.1 256 183.5 154.4a23.9 23.9 0 0 1 0-33.9l17-17a23.9 23.9 0 0 1 33.9 0L369.9 239a24 24 0 0 1 0 34z"]],
    "chevron-circle-up": [512, 512, [], "f139", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm152.5 303.5l-17 17a23.9 23.9 0 0 1-33.9 0L256 226.9 154.4 328.5a23.9 23.9 0 0 1-33.9 0l-17-17a23.9 23.9 0 0 1 0-33.9L239 142.1a24 24 0 0 1 34 0l135.5 135.5a23.9 23.9 0 0 1 0 33.9z", "M273 142.1l135.5 135.5a23.9 23.9 0 0 1 0 33.9l-17 17a23.9 23.9 0 0 1-33.9 0L256 226.9 154.4 328.5a23.9 23.9 0 0 1-33.9 0l-17-17a23.9 23.9 0 0 1 0-33.9L239 142.1a24 24 0 0 1 34 0z"]],
    "chevron-double-down": [448, 512, [], "f322", ["M207 285.54L12.7 91.14a23.9 23.9 0 0 1 0-33.9l22.7-22.7a24.08 24.08 0 0 1 33.9 0l154.7 154 154.7-154a23.9 23.9 0 0 1 33.9 0l22.7 22.7a23.9 23.9 0 0 1 0 33.9L241 285.54a24.2 24.2 0 0 1-34 0z", "M207 477.54L12.7 283.14a23.9 23.9 0 0 1 0-33.9l22.7-22.7a23.9 23.9 0 0 1 33.9 0l154.7 154 154.7-154a24.08 24.08 0 0 1 33.9 0l22.7 22.7a23.9 23.9 0 0 1 0 33.9L241 477.54a24.2 24.2 0 0 1-34 0z"]],
    "chevron-double-left": [512, 512, [], "f323", ["M226.56 239l194-194a23.84 23.84 0 0 1 33.73-.1l.1.1L477 67.7a24.06 24.06 0 0 1 0 33.85L323.36 256l153.58 154.45a23.87 23.87 0 0 1 .1 33.75l-.1.1-22.65 22.7a23.84 23.84 0 0 1-33.73.1l-.1-.1-193.9-194a24.17 24.17 0 0 1 0-34z", "M35 239L229 45a23.84 23.84 0 0 1 33.73-.1l.1.1 22.61 22.7a23.87 23.87 0 0 1 .1 33.75l-.1.1L131.76 256l153.68 154.45a24.06 24.06 0 0 1 0 33.85L262.79 467a23.84 23.84 0 0 1-33.73.1l-.1-.1L35 273a24.17 24.17 0 0 1 0-34z"]],
    "chevron-double-right": [512, 512, [], "f324", ["M285.6 273L90.79 467a24 24 0 0 1-33.88.1l-.1-.1-22.74-22.7a24 24 0 0 1 0-33.85L188.39 256 34.07 101.55A23.8 23.8 0 0 1 34 67.8l.11-.1L56.81 45a24 24 0 0 1 33.88-.1l.1.1L285.6 239a24.09 24.09 0 0 1 0 34z", "M478 273L283.19 467a24 24 0 0 1-33.87.1l-.1-.1-22.75-22.7a23.81 23.81 0 0 1-.1-33.75l.1-.1L380.8 256 226.47 101.55a24 24 0 0 1 0-33.85L249.22 45a24 24 0 0 1 33.87-.1.94.94 0 0 1 .1.1L478 239a24.09 24.09 0 0 1 0 34z"]],
    "chevron-double-up": [448, 512, [], "f325", ["M435 420.86a24 24 0 0 1 0 33.94l-22.63 22.67a23.93 23.93 0 0 1-33.85 0L224 323.5l-154.5 154a23.93 23.93 0 0 1-33.85 0L13 454.8a24 24 0 0 1 0-33.94l194-194.33a23.93 23.93 0 0 1 33.88 0z", "M435 228.86a24 24 0 0 1 0 33.94l-22.63 22.67a23.93 23.93 0 0 1-33.85 0L224 131.5l-154.5 154a23.93 23.93 0 0 1-33.85 0L13 262.8a24 24 0 0 1 0-33.94L207 34.53a23.93 23.93 0 0 1 33.88 0z"]],
    "chevron-down": [448, 512, [], "f078", ["M224.1 284.64l-56.89 56.78-154-154.31a24 24 0 0 1 0-33.94l22.65-22.7a23.93 23.93 0 0 1 33.84 0z", "M435 187.15L241 381.48a23.94 23.94 0 0 1-33.84 0l-40-40 211.34-211a23.93 23.93 0 0 1 33.84 0L435 153.21a24 24 0 0 1 0 33.94z"]],
    "chevron-left": [320, 512, [], "f053", ["M285.59 410.4a23.93 23.93 0 0 1 0 33.84l-22.7 22.65a24 24 0 0 1-33.94 0l-154.31-154L131.42 256z", "M262.85 45.06l22.7 22.65a23.93 23.93 0 0 1 0 33.84L74.58 312.9l-40-40a23.94 23.94 0 0 1 0-33.84l194.33-194a24 24 0 0 1 33.94 0z"]],
    "chevron-right": [320, 512, [], "f054", ["M188.74 256l56.78 56.89L91.21 466.9a24 24 0 0 1-33.94 0l-22.7-22.65a23.93 23.93 0 0 1 0-33.84z", "M91.25 45.06l194.33 194a23.93 23.93 0 0 1 0 33.84l-40 40-211-211.34a23.92 23.92 0 0 1 0-33.84l22.7-22.65a24 24 0 0 1 33.97-.01z"]],
    "chevron-square-down": [448, 512, [], "f329", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-23.51 194.43L241 361.94a24 24 0 0 1-33.94 0L71.52 226.43a24 24 0 0 1 0-33.94l17-17a24 24 0 0 1 33.94 0L224 277.09l101.57-101.58a24 24 0 0 1 33.95 0l17 17a24 24 0 0 1-.03 33.92z", "M71.52 192.49l17-17a24 24 0 0 1 33.94 0L224 277.09l101.57-101.58a24 24 0 0 1 33.95 0l17 17a24 24 0 0 1 0 34L241 361.94a24 24 0 0 1-33.94 0L71.52 226.43a24 24 0 0 1 0-33.94z"]],
    "chevron-square-left": [448, 512, [], "f32a", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-95.51 325.57a24 24 0 0 1 0 33.95l-17 17a24 24 0 0 1-33.95 0L118.06 273a24 24 0 0 1 0-33.94l135.51-135.54a24 24 0 0 1 33.95 0l17 17a24 24 0 0 1 0 33.94L202.91 256z", "M118.06 239l135.51-135.48a24 24 0 0 1 33.95 0l17 17a24 24 0 0 1 0 33.94L202.91 256l101.58 101.57a24 24 0 0 1 0 33.95l-17 17a24 24 0 0 1-33.95 0L118.06 273a24 24 0 0 1 0-34z"]],
    "chevron-square-right": [448, 512, [], "f32b", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-70.06 241L194.43 408.48a24 24 0 0 1-33.94 0l-17-17a24 24 0 0 1 0-33.94L245.09 256 143.52 154.43a24 24 0 0 1 0-33.94l17-17a24 24 0 0 1 33.94 0L329.94 239a24 24 0 0 1 0 34z", "M143.52 154.43a24 24 0 0 1 0-33.94l17-17a24 24 0 0 1 33.94 0L329.94 239a24 24 0 0 1 0 33.94L194.43 408.48a24 24 0 0 1-33.94 0l-17-17a24 24 0 0 1 0-33.94L245.09 256z"]],
    "chevron-square-up": [448, 512, [], "f32c", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-23.52 287.51l-17 17a24 24 0 0 1-33.94 0L224 234.91 122.43 336.48a24 24 0 0 1-33.94 0l-17-17a24 24 0 0 1 0-33.94L207 150.06a24 24 0 0 1 33.94 0l135.54 135.51a24 24 0 0 1 0 33.94z", "M71.52 285.57L207 150.06a24 24 0 0 1 33.94 0l135.54 135.51a24 24 0 0 1 0 33.94l-17 17a24 24 0 0 1-33.94 0L224 234.91 122.43 336.48a24 24 0 0 1-33.94 0l-17-17a24 24 0 0 1 .03-33.91z"]],
    "chevron-up": [448, 512, [], "f077", ["M69.66 381.49a23.93 23.93 0 0 1-33.84 0l-22.65-22.7a24 24 0 0 1 0-33.94l154.04-154.31 56.89 56.78z", "M435 358.75l-22.65 22.7a23.92 23.92 0 0 1-33.84 0l-211.34-211 40-40a23.93 23.93 0 0 1 33.84 0L435 324.81a24 24 0 0 1 0 33.94z"]],
    "child": [384, 512, [], "f1ae", ["M120 72a72 72 0 1 1 72 72 72 72 0 0 1-72-72z", "M9.37 118.63a32 32 0 0 1 45.26-45.26L141.25 160h101.5l86.62-86.63a32 32 0 0 1 45.26 45.26L280 213.25V480a32 32 0 0 1-32 32h-16a32 32 0 0 1-32-32V368h-16v112a32 32 0 0 1-32 32h-16a32 32 0 0 1-32-32V213.25z"]],
    "chimney": [512, 512, [], "f78b", ["M160 224H32v128h128zM32 512h288V384H32zm320 0h128V384H352zM192 224v128h288V224z", "M0 160V32A32 32 0 0 1 32 0h448a32 32 0 0 1 32 32v128a32 32 0 0 1-32 32H32a32 32 0 0 1-32-32z"]],
    "church": [640, 512, [], "f51d", ["M620.61 366.54L512 320v192h112a16 16 0 0 0 16-16V396a32 32 0 0 0-19.39-29.46zM0 396v100a16 16 0 0 0 16 16h112V320L19.39 366.54A32 32 0 0 0 0 396z", "M480 274.12V512h-96v-96a64 64 0 0 0-128 0v96h-96V274.12a32 32 0 0 1 15.54-27.44L288 179.2V128h-48a16 16 0 0 1-16-16V80a16 16 0 0 1 16-16h48V16a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v48h48a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16h-48v51.2l112.46 67.48A32 32 0 0 1 480 274.12z"]],
    "circle": [512, 512, [], "f111", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm0 424c-97.06 0-176-79-176-176S158.94 80 256 80s176 79 176 176-78.94 176-176 176z", "M256 432c-97.06 0-176-79-176-176S158.94 80 256 80s176 79 176 176-78.94 176-176 176z"]],
    "circle-notch": [512, 512, [], "f1ce", ["M504 257.28v.23C503.42 394 392.44 504.24 256 504v-64a184.09 184.09 0 0 0 177.16-134.42c27.44-97.84-29.63-199.41-127.47-226.85A24 24 0 0 1 288 55.66V39a24 24 0 0 1 30-23.22c107.4 27.65 186.61 125.38 186 241.5z", "M256 439.93v64C119.56 504.24 8.58 394 8 257.51v-.23C7.39 141.16 86.6 43.43 194 15.78A24 24 0 0 1 224 39v16.66a24 24 0 0 1-17.69 23.07c-97.84 27.44-154.91 129-127.47 226.85A184.07 184.07 0 0 0 256 439.93z"]],
    "city": [640, 512, [], "f64f", ["M116 352H76a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm0-96H76a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm0-96H76a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm128 192h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm0-96h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm0-96h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm320 192h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm0-96h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12z", "M616 192H480V24a24 24 0 0 0-24-24H312a24 24 0 0 0-24 24v72h-64V16a16 16 0 0 0-16-16h-16a16 16 0 0 0-16 16v80h-64V16A16 16 0 0 0 96 0H80a16 16 0 0 0-16 16v80H24a24 24 0 0 0-24 24v360a32 32 0 0 0 32 32h576a32 32 0 0 0 32-32V216a24 24 0 0 0-24-24zM128 404a12 12 0 0 1-12 12H76a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12H76a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12H76a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm128 192a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm160 96a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12V76a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm160 288a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12z"]],
    "clarinet": [640, 512, [], "f8ad", ["M630.13 129.22a16 16 0 0 0-17.44 3.47L569.38 176H101.2a32 32 0 0 0-10.13 1.64l-80.13 26.71A16 16 0 0 0 0 219.53v72.94a16 16 0 0 0 10.94 15.18l80.13 26.71A32 32 0 0 0 101.2 336h468.18l43.31 43.31A16 16 0 0 0 640 368V144a16 16 0 0 0-9.87-14.78zM272 280a24 24 0 1 1 24-24 24 24 0 0 1-24 24zm96 0a24 24 0 1 1 24-24 24 24 0 0 1-24 24zm96 0a24 24 0 1 1 24-24 24 24 0 0 1-24 24z", "M368 232a24 24 0 1 0 24 24 24 24 0 0 0-24-24zm-96 0a24 24 0 1 0 24 24 24 24 0 0 0-24-24zm232-120H232a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h24v32h32v-32h64v32h32v-32h64v32h32v-32h24a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zm-40 120a24 24 0 1 0 24 24 24 24 0 0 0-24-24z"]],
    "claw-marks": [512, 512, [], "f6c2", ["M7 224.51c-5-2.37-9.4 4.09-5.49 8l85.12 85.13A32 32 0 0 1 96 340.27V384h43.74a32 32 0 0 1 22.63 9.37l117.14 117.16c3.86 3.86 10.32-.56 8-5.49C206.4 333.11 63.36 251.26 7 224.51zM511.51 281C430.4 109.11 287.36 27.26 231 .51c-5-2.37-9.4 4.09-5.49 8l21.13 21.12A32 32 0 0 1 256 52.26V96h43.74a32 32 0 0 1 22.63 9.37l52.26 52.26a32 32 0 0 1 9.37 22.63V224h43.73a32 32 0 0 1 22.63 9.37l53.16 53.16c3.86 3.86 10.32-.53 7.99-5.53z", "M2.67 15.13C-4.28 8.18 3.54-3.3 12.42.91A1010.5 1010.5 0 0 1 116.89 59 32.4 32.4 0 0 0 134 64h58v31.29a31.44 31.44 0 0 0 12.27 25c105.31 81.65 224.13 204 306.86 379.3 4.14 8.77-7.34 16.62-14.2 9.76l-84-84a32 32 0 0 0-22.64-9.35H352v-38.29a32 32 0 0 0-9.37-22.63l-89.71-89.71a32 32 0 0 0-22.63-9.37H192v-38.28a32 32 0 0 0-9.37-22.63z"]],
    "clinic-medical": [576, 512, [], "f7f2", ["M288 115L69.48 307.72c-1.62 1.46-3.69 2.14-5.47 3.35V496a16 16 0 0 0 16 16H496a16 16 0 0 0 16-16V311.11c-1.7-1.16-3.72-1.82-5.26-3.2zm96 261a8 8 0 0 1-8 8h-56v56a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-56h-56a8 8 0 0 1-8-8v-48a8 8 0 0 1 8-8h56v-56a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8v56h56a8 8 0 0 1 8 8z", "M570.7 236.29l-255.94-226a39.85 39.85 0 0 0-53.45 0l-256 226a16 16 0 0 0-1.21 22.59l21.41 23.82a16 16 0 0 0 22.59 1.21L277.43 81.64a16 16 0 0 1 21.17 0l229.32 202.27a16 16 0 0 0 22.6-1.2l21.4-23.82a16 16 0 0 0-1.22-22.6zM376 320h-56v-56a8 8 0 0 0-8-8h-48a8 8 0 0 0-8 8v56h-56a8 8 0 0 0-8 8v48a8 8 0 0 0 8 8h56v56a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8v-56h56a8 8 0 0 0 8-8v-48a8 8 0 0 0-8-8z"]],
    "clipboard": [384, 512, [], "f328", ["M336 63h-80v1a64 64 0 0 1 64 64H64a64 64 0 0 1 64-64v-1H48a48 48 0 0 0-48 48v352a48 48 0 0 0 48 48h288a48 48 0 0 0 48-48V111a48 48 0 0 0-48-48z", "M256 64a64 64 0 0 0-128 0 64 64 0 0 0-64 64h256a64 64 0 0 0-64-64zm-64 24a24 24 0 1 1 24-24 23.94 23.94 0 0 1-24 24z"]],
    "clipboard-check": [384, 512, [], "f46c", ["M336 64h-80a64 64 0 0 1 64 64H64a64 64 0 0 1 64-64H48a48 48 0 0 0-48 48v352a48 48 0 0 0 48 48h288a48 48 0 0 0 48-48V112a48 48 0 0 0-48-48zm-22.8 207.8l-143 141.8a12 12 0 0 1-17-.1l-82.6-83.3a12 12 0 0 1 .1-17L99.1 285a12 12 0 0 1 17 .1l46 46.4 106-105.2a12 12 0 0 1 17 .1l28.2 28.4a12 12 0 0 1-.1 17z", "M285.1 226.4a12 12 0 0 0-17-.1l-106 105.2-46-46.4a12 12 0 0 0-17-.1l-28.4 28.2a12 12 0 0 0-.1 17l82.6 83.3a12 12 0 0 0 17 .1l143-141.8a12 12 0 0 0 .1-17zM256 64a64 64 0 0 0-128 0 64 64 0 0 0-64 64h256a64 64 0 0 0-64-64zm-64 24a24 24 0 1 1 24-24 23.94 23.94 0 0 1-24 24z"]],
    "clipboard-list": [384, 512, [], "f46d", ["M336 64h-80a64 64 0 0 1 64 64H64a64 64 0 0 1 64-64H48a48 48 0 0 0-48 48v352a48 48 0 0 0 48 48h288a48 48 0 0 0 48-48V112a48 48 0 0 0-48-48zM96 424a24 24 0 1 1 24-24 23.94 23.94 0 0 1-24 24zm0-96a24 24 0 1 1 24-24 23.94 23.94 0 0 1-24 24zm0-96a24 24 0 1 1 24-24 23.94 23.94 0 0 1-24 24zm224 176a8 8 0 0 1-8 8H168a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h144a8 8 0 0 1 8 8zm0-96a8 8 0 0 1-8 8H168a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h144a8 8 0 0 1 8 8zm0-96a8 8 0 0 1-8 8H168a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h144a8 8 0 0 1 8 8z", "M96 376a24 24 0 1 0 24 24 23.94 23.94 0 0 0-24-24zm0-96a24 24 0 1 0 24 24 23.94 23.94 0 0 0-24-24zm0-96a24 24 0 1 0 24 24 23.94 23.94 0 0 0-24-24zM256 64a64 64 0 0 0-128 0 64 64 0 0 0-64 64h256a64 64 0 0 0-64-64zm-64 24a24 24 0 1 1 24-24 23.94 23.94 0 0 1-24 24z"]],
    "clipboard-list-check": [384, 512, [], "f737", ["M336 64h-80a64 64 0 0 1 64 64H64a64 64 0 0 1 64-64H48a48 48 0 0 0-48 48v352a48 48 0 0 0 48 48h288a48 48 0 0 0 48-48V112a48 48 0 0 0-48-48zM65.6 241.4l12.7-12.6a5.37 5.37 0 0 1 7.6 0l20.6 20.8 47.6-47.2a5.37 5.37 0 0 1 7.6 0l12.6 12.7a5.37 5.37 0 0 1 0 7.6l-64.2 63.6a5.37 5.37 0 0 1-7.6 0L65.6 249a5.37 5.37 0 0 1 0-7.6zM96 392a24 24 0 1 1 24-24 23.94 23.94 0 0 1-24 24zm224-16a8 8 0 0 1-8 8H168a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h144a8 8 0 0 1 8 8zm0-96c0 4.4-4.3 8-9.6 8H154.1l32.3-32h124c5.3 0 9.6 3.6 9.6 8z", "M96 344a24 24 0 1 0 24 24 23.94 23.94 0 0 0-24-24zm65.7-141.6a5.37 5.37 0 0 0-7.6 0l-47.6 47.2-20.6-20.8a5.37 5.37 0 0 0-7.6 0l-12.7 12.6a5.37 5.37 0 0 0 0 7.6l36.9 37.3a5.37 5.37 0 0 0 7.6 0l64.2-63.6a5.37 5.37 0 0 0 0-7.6zM256 64a64 64 0 0 0-128 0 64 64 0 0 0-64 64h256a64 64 0 0 0-64-64zm-64 24a24 24 0 1 1 24-24 23.94 23.94 0 0 1-24 24z"]],
    "clipboard-prescription": [384, 512, [], "f5e8", ["M336 63h-80a64 64 0 0 1 64 64H64a64 64 0 0 1 64-64H48a48 48 0 0 0-48 48v352a48 48 0 0 0 48 48h288a48 48 0 0 0 48-48V111a48 48 0 0 0-48-48zm-32 369l-11.31 11.31a16 16 0 0 1-22.63 0L240 413.25l-30.06 30.06a16 16 0 0 1-22.63 0L176 432a16 16 0 0 1 0-22.63l30.06-30.06L146.74 320H128v48a16 16 0 0 1-16 16H96a16 16 0 0 1-16-16V208a16 16 0 0 1 16-16h80a63.8 63.8 0 0 1 30.54 119.92L240 345.38l29.9-29.9a16 16 0 0 1 22.63 0l11.3 11.31a16 16 0 0 1 0 22.63l-29.9 29.9L304 409.38a16 16 0 0 1 0 22.62zM192 256a16 16 0 0 1-16 16h-48v-32h48a16 16 0 0 1 16 16z", "M273.93 379.32l29.9-29.9a16 16 0 0 0 0-22.63l-11.3-11.31a16 16 0 0 0-22.63 0l-29.9 29.9-33.46-33.46A63.8 63.8 0 0 0 176 192H96a16 16 0 0 0-16 16v160a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16v-48h18.74l59.32 59.31L176 409.37a16 16 0 0 0 0 22.63l11.31 11.31a16 16 0 0 0 22.63 0L240 413.25l30.06 30.06a16 16 0 0 0 22.63 0L304 432a16 16 0 0 0 0-22.62zM176 272h-48v-32h48a16 16 0 0 1 0 32zm80-209a64 64 0 0 0-128 0 64 64 0 0 0-64 64h256a64 64 0 0 0-64-64zm-64 24a24 24 0 1 1 24-24 23.94 23.94 0 0 1-24 24z"]],
    "clipboard-user": [384, 512, [], "f7f3", ["M336 63h-80v1a64 64 0 0 1 64 64H64a64 64 0 0 1 64-64v-1H48a48 48 0 0 0-48 48v352a48 48 0 0 0 48 48h288a48 48 0 0 0 48-48V111a48 48 0 0 0-48-48zM192 192a64 64 0 1 1-64 64 64 64 0 0 1 64-64zm112 236.8c0 10.61-10 19.2-22.4 19.2H102.4C90 448 80 439.4 80 428.8v-19.2c0-31.81 30.09-57.6 67.2-57.6h5a103.22 103.22 0 0 0 79.7 0h5c37.11 0 67.2 25.79 67.2 57.6z", "M236.9 352h-5a103.22 103.22 0 0 1-79.7 0h-5c-37.11 0-67.2 25.79-67.2 57.6v19.2c0 10.6 10 19.2 22.4 19.2h179.2c12.4 0 22.4-8.59 22.4-19.2l.1-19.2c0-31.81-30.1-57.6-67.2-57.6zM128 256a64 64 0 1 0 64-64 64 64 0 0 0-64 64zM256 64a64 64 0 0 0-128 0 64 64 0 0 0-64 64h256a64 64 0 0 0-64-64zm-64 24a24 24 0 1 1 24-24 23.94 23.94 0 0 1-24 24z"]],
    "clock": [512, 512, [], "f017", ["M220 116a12 12 0 0 1 12-12h48a12 12 0 0 1 12 12v137.7l63.5 46.2a12 12 0 0 1 2.6 16.8l-28.2 38.8a12.08 12.08 0 0 1-16.8 2.6L224.9 294a12.08 12.08 0 0 1-4.9-9.7z", "M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm102.1 308.7l-28.2 38.8a12.08 12.08 0 0 1-16.8 2.6L224.9 294a12.08 12.08 0 0 1-4.9-9.7V116a12 12 0 0 1 12-12h48a12 12 0 0 1 12 12v137.7l63.5 46.2a12 12 0 0 1 2.6 16.8z"]],
    "clone": [512, 512, [], "f24d", ["M48 512a48 48 0 0 1-48-48V176a48 48 0 0 1 48-48h48v208a80.09 80.09 0 0 0 80 80h208v48a48 48 0 0 1-48 48H48z", "M512 48v288a48 48 0 0 1-48 48H176a48 48 0 0 1-48-48V48a48 48 0 0 1 48-48h288a48 48 0 0 1 48 48z"]],
    "closed-captioning": [512, 512, [], "f20a", ["M464 64H48a48 48 0 0 0-48 48v288a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V112a48 48 0 0 0-48-48zM246.3 324c-53.6 56.8-172.8 32.1-172.8-67.9 0-97.3 121.7-119.5 172.5-70.1 2.1 2 2.5 3.2 1 5.7l-17.5 30.5c-.11.18-.24.36-.37.54a6.23 6.23 0 0 1-8.73 1.16c-40.8-32-94.6-14.9-94.6 31.2.1 48 51.1 70.5 92.3 32.6a6.47 6.47 0 0 1 .57-.47 6.19 6.19 0 0 1 8.63 1.37l19.5 27.7a6 6 0 0 1-.5 7.7zm162.2-36.3a6.47 6.47 0 0 1 .57-.47 6.19 6.19 0 0 1 8.63 1.37l19.5 27.7a6 6 0 0 1-.5 7.7C383.2 380.9 264 356.1 264 256.1c0-97.3 121.7-119.5 172.5-70.1 2.1 2 2.5 3.2 1 5.7L420 222.2c-.11.18-.24.36-.37.54a6.23 6.23 0 0 1-8.73 1.16c-40.8-32-94.6-14.9-94.6 31.2 0 48 51 70.5 92.2 32.6z", "M227.3 288.6a6.19 6.19 0 0 0-8.63-1.37 6.47 6.47 0 0 0-.57.47c-41.2 37.9-92.2 15.4-92.3-32.6 0-46.1 53.8-63.2 94.6-31.2a6.23 6.23 0 0 0 8.73-1.16c.13-.18.26-.36.37-.54l17.5-30.5c1.5-2.5 1.1-3.7-1-5.7-50.8-49.4-172.5-27.2-172.5 70.1 0 100 119.2 124.7 172.8 67.9a6 6 0 0 0 .5-7.7zm190.4 0a6.19 6.19 0 0 0-8.63-1.37 6.47 6.47 0 0 0-.57.47c-41.2 37.9-92.2 15.4-92.2-32.6 0-46.1 53.8-63.2 94.6-31.2a6.23 6.23 0 0 0 8.73-1.16c.13-.18.26-.36.37-.54l17.5-30.5c1.5-2.5 1.1-3.7-1-5.7-50.8-49.4-172.5-27.2-172.5 70.1 0 100 119.2 124.8 172.7 67.9a6 6 0 0 0 .5-7.7z"]],
    "cloud": [640, 512, [], "f0c2", ["", "M640 352a128 128 0 0 1-128 128H144a144 144 0 0 1-47.8-279.9c-.1-2.7-.2-5.4-.2-8.1a160 160 0 0 1 298.7-79.8A95.95 95.95 0 0 1 544 192a96.66 96.66 0 0 1-6.4 34.6A128 128 0 0 1 640 352z"]],
    "cloud-download": [640, 512, [], "f0ed", ["M537.6 226.6A96.11 96.11 0 0 0 448 96a95.51 95.51 0 0 0-53.3 16.2A160 160 0 0 0 96 192c0 2.7.1 5.4.2 8.1A144 144 0 0 0 144 480h368a128 128 0 0 0 25.6-253.4zm-139.9 93L305 412.3a23.9 23.9 0 0 1-33.9 0l-92.7-92.7a23.9 23.9 0 0 1 0-33.9l10.8-10.8a24.09 24.09 0 0 1 34.5.5l32.4 34.5V184a23.94 23.94 0 0 1 24-24h16a23.94 23.94 0 0 1 24 24v125.9l32.4-34.5a24 24 0 0 1 34.5-.5l10.8 10.8a24.18 24.18 0 0 1-.1 33.9z", "M397.7 319.6L305 412.3a23.9 23.9 0 0 1-33.9 0l-92.7-92.7a23.9 23.9 0 0 1 0-33.9l10.8-10.8a24.09 24.09 0 0 1 34.5.5l32.4 34.5V184a23.94 23.94 0 0 1 24-24h16a23.94 23.94 0 0 1 24 24v125.9l32.4-34.5a24 24 0 0 1 34.5-.5l10.8 10.8a24.18 24.18 0 0 1-.1 33.9z"]],
    "cloud-download-alt": [640, 512, [], "f381", ["M537.6 226.6A96.11 96.11 0 0 0 448 96a95.51 95.51 0 0 0-53.3 16.2A160 160 0 0 0 96 192c0 2.7.1 5.4.2 8.1A144 144 0 0 0 144 480h368a128 128 0 0 0 25.6-253.4zm-132.9 88.7L299.3 420.7a16.06 16.06 0 0 1-22.6 0L171.3 315.3c-10.1-10.1-2.9-27.3 11.3-27.3H248V176a16 16 0 0 1 16-16h48a16 16 0 0 1 16 16v112h65.4c14.2 0 21.4 17.2 11.3 27.3z", "M404.7 315.3L299.3 420.7a16.06 16.06 0 0 1-22.6 0L171.3 315.3c-10.1-10.1-2.9-27.3 11.3-27.3H248V176a16 16 0 0 1 16-16h48a16 16 0 0 1 16 16v112h65.4c14.2 0 21.4 17.2 11.3 27.3z"]],
    "cloud-drizzle": [512, 512, [], "f738", ["M48 360a16 16 0 0 0-16 16v40a16 16 0 0 0 32 0v-40a16 16 0 0 0-16-16zm96 80a16 16 0 0 0-16 16v40a16 16 0 0 0 32 0v-40a16 16 0 0 0-16-16zm96-80a16 16 0 0 0-16 16v40a16 16 0 0 0 32 0v-40a16 16 0 0 0-16-16zm96 80a16 16 0 0 0-16 16v40a16 16 0 0 0 32 0v-40a16 16 0 0 0-16-16zm96-80a16 16 0 0 0-16 16v40a16 16 0 0 0 32 0v-40a16 16 0 0 0-16-16z", "M512 224a96 96 0 0 1-96 96H96a96 96 0 0 1-96-96c0-42.5 27.8-78.2 66.1-90.8A113.72 113.72 0 0 1 64 112 111.94 111.94 0 0 1 176 0c43.3 0 80.4 24.8 99 60.8C289.7 43.3 311.4 32 336 32a80 80 0 0 1 80 80 78.09 78.09 0 0 1-1.6 16.2c.5 0 1-.2 1.6-.2a96 96 0 0 1 96 96z"]],
    "cloud-hail": [512, 512, [], "f739", ["M384 352a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm-192 96a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm128 0a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm-64-96a32 32 0 1 0 32 32 32 32 0 0 0-32-32zM64 448a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm64-96a32 32 0 1 0 32 32 32 32 0 0 0-32-32z", "M512 224a96 96 0 0 1-96 96H96a96 96 0 0 1-96-96c0-42.5 27.8-78.2 66.1-90.8A113.72 113.72 0 0 1 64 112 111.94 111.94 0 0 1 176 0c43.3 0 80.4 24.8 99 60.8C289.7 43.3 311.4 32 336 32a80 80 0 0 1 80 80 78.09 78.09 0 0 1-1.6 16.2c.5 0 1-.2 1.6-.2a96 96 0 0 1 96 96z"]],
    "cloud-hail-mixed": [512, 512, [], "f73a", ["M183.89 370.13a15.88 15.88 0 0 0-21.8 6l-64 112a15.91 15.91 0 0 0 6 21.79 16 16 0 0 0 21.8-6l64-112a16 16 0 0 0-6-21.79zm95.3-.4a16 16 0 0 0-21.5 7.2l-16 32a16 16 0 0 0 7.2 21.5 16.88 16.88 0 0 0 7.2 1.7 16 16 0 0 0 14.3-8.8l16-32a16.23 16.23 0 0 0-7.2-21.6zm-192 0a16 16 0 0 0-21.5 7.2l-16 32a16 16 0 0 0 7.2 21.5 16.88 16.88 0 0 0 7.2 1.7 16 16 0 0 0 14.3-8.8l16-32a16.23 16.23 0 0 0-7.19-21.6zm384 0a16 16 0 0 0-21.5 7.2l-16 32a16 16 0 0 0 7.19 21.5 16.88 16.88 0 0 0 7.2 1.7 16 16 0 0 0 14.3-8.8l16-32a16.23 16.23 0 0 0-7.2-21.6zm-95.29.4a15.88 15.88 0 0 0-21.8 6l-64 112a15.91 15.91 0 0 0 6 21.79 16 16 0 0 0 21.8-6l64-112a16 16 0 0 0-6.01-21.79zM32 448a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm192 0a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm192 0a32 32 0 1 0 32 32 32 32 0 0 0-32-32z", "M512 224a96 96 0 0 1-96 96H96a96 96 0 0 1-96-96c0-42.5 27.8-78.2 66.1-90.8A113.72 113.72 0 0 1 64 112 111.94 111.94 0 0 1 176 0c43.3 0 80.4 24.8 99 60.8C289.7 43.3 311.4 32 336 32a80 80 0 0 1 80 80 78.09 78.09 0 0 1-1.6 16.2c.5 0 1-.2 1.6-.2a96 96 0 0 1 96 96z"]],
    "cloud-meatball": [512, 512, [], "f73b", ["M48 352a48 48 0 1 0 48 48 48 48 0 0 0-48-48zm416 0a48 48 0 1 0 48 48 48 48 0 0 0-48-48zm-119 11.1c4.6-14.5 1.6-30.8-9.8-42.3s-27.8-14.4-42.3-9.9c-7-13.5-20.7-23-36.9-23s-29.9 9.5-36.9 23c-14.5-4.6-30.8-1.6-42.3 9.9s-14.4 27.8-9.9 42.3c-13.5 7-23 20.7-23 36.9s9.5 29.9 23 36.9c-4.6 14.5-1.6 30.8 9.9 42.3a41.79 41.79 0 0 0 29.7 12.3 39.21 39.21 0 0 0 12.6-2.5c7 13.5 20.7 23 36.9 23s29.9-9.5 36.9-23c4.1 1.3 8.3 2.5 12.6 2.5a41.79 41.79 0 0 0 29.7-12.3c11.5-11.5 14.4-27.8 9.8-42.3 13.5-7 23-20.7 23-36.9s-9.5-29.9-23-36.9z", "M416 320h-43.4a70.78 70.78 0 0 0-14.8-21.8 72.44 72.44 0 0 0-50.8-21.3 72.67 72.67 0 0 0-102 0 71.9 71.9 0 0 0-65.6 43.1H96a96 96 0 0 1-96-96c0-42.5 27.8-78.2 66.1-90.8A113.72 113.72 0 0 1 64 112 111.94 111.94 0 0 1 176 0c43.3 0 80.4 24.8 99 60.8C289.7 43.3 311.4 32 336 32a80 80 0 0 1 80 80 78.09 78.09 0 0 1-1.6 16.2c.5 0 1-.2 1.6-.2a96 96 0 0 1 0 192z"]],
    "cloud-moon": [576, 512, [], "f6c3", ["M574 313.47A191.54 191.54 0 0 1 436.9 384a110.41 110.41 0 0 0-53.5-52.7 94.83 94.83 0 0 0 .6-10.72c0-53-43.1-96.17-96-96.17a95.1 95.1 0 0 0-36.4 7.21 124.78 124.78 0 0 0-16.7-14.22 188.15 188.15 0 0 1-1.8-25.05C233.1 86.06 319.1 0 425 0a197.47 197.47 0 0 1 35.1 3.21c8.2 1.6 10.1 12.62 2.8 16.73a150.63 150.63 0 0 0-76.1 131c0 94.17 85.4 165.7 178.5 148a9 9 0 0 1 8.7 14.53z", "M416 432a80 80 0 0 1-80 80H96a96 96 0 0 1-96-96c0-41.9 27.1-77.2 64.6-90.3-.1-1.9-.6-3.7-.6-5.7a96 96 0 0 1 96-96c36.2 0 67.4 20.3 83.7 49.9a63.83 63.83 0 0 1 99.1 78.8c40.9 3.5 73.2 37.4 73.2 79.3z"]],
    "cloud-moon-rain": [576, 512, [], "f73c", ["M567.9 223.8c-70.4 13.3-135-40.3-135-110.8a112.62 112.62 0 0 1 57.5-98.1 6.74 6.74 0 0 0-2.1-12.5A146.75 146.75 0 0 0 461.8 0c-77.9 0-141.1 61.2-144.4 137.9a111.46 111.46 0 0 1 58.9 61.7 111.81 111.81 0 0 1 70.2 86.8c5.1.5 10 1.5 15.2 1.5a145 145 0 0 0 112.6-53.3c4.2-4.8-.2-12-6.4-10.8zM364.5 418.1a16 16 0 0 0-21.8 6l-36.6 64a15.94 15.94 0 0 0 6 21.8 16 16 0 0 0 21.8-6l36.6-64a16 16 0 0 0-6-21.8zm-96 0a16 16 0 0 0-21.8 6l-36.6 64a15.94 15.94 0 0 0 6 21.8 16 16 0 0 0 21.8-6l36.6-64a16 16 0 0 0-6-21.8zm-96 0a16 16 0 0 0-21.8 6l-36.6 64a15.94 15.94 0 0 0 6 21.8 16 16 0 0 0 21.8-6l36.6-64a16 16 0 0 0-6-21.8zm-96 0a16 16 0 0 0-21.8 6l-36.6 64a15.94 15.94 0 0 0 6 21.8 16 16 0 0 0 21.8-6l36.6-64a16 16 0 0 0-6-21.8z", "M416 304a80 80 0 0 1-80 80H80a80 80 0 0 1-15.8-158.4c0-.5-.2-1.1-.2-1.6a95.82 95.82 0 0 1 173.7-56 79 79 0 0 1 34.3-8 80 80 0 0 1 78.5 65.5A79.79 79.79 0 0 1 416 304z"]],
    "cloud-music": [640, 512, [], "f8ae", ["M537.59 226.59a96 96 0 0 0-142.9-114.39A160 160 0 0 0 96 192c0 2.7.09 5.41.19 8.09A144 144 0 0 0 144 480h368a128 128 0 0 0 25.59-253.41zM384 352c0 17.67-21.5 32-48 32s-48-14.33-48-32 21.5-32 48-32a69.82 69.82 0 0 1 16 2v-76.36l-96 37.52V384c0 17.67-21.5 32-48 32s-48-14.33-48-32 21.5-32 48-32a69.82 69.82 0 0 1 16 2V239.25A16 16 0 0 1 235.19 224l128-47.25A16 16 0 0 1 384 192z", "M208 352a69.82 69.82 0 0 1 16 2V239.25A16 16 0 0 1 235.19 224l128-47.25A16 16 0 0 1 384 192v160c0 17.67-21.5 32-48 32s-48-14.33-48-32 21.5-32 48-32a69.82 69.82 0 0 1 16 2v-76.36l-96 37.52V384c0 17.67-21.5 32-48 32s-48-14.33-48-32 21.5-32 48-32z"]],
    "cloud-rain": [512, 512, [], "f73d", ["M88 374.22c-12.8 44.4-40 56.39-40 87.69C48 489.6 69.5 512 96 512s48-22.4 48-50.09c0-31.4-27.2-43.09-40-87.69a8.26 8.26 0 0 0-16 0zm160 0c-12.8 44.4-40 56.39-40 87.69 0 27.69 21.5 50.09 48 50.09s48-22.4 48-50.09c0-31.4-27.2-43.09-40-87.69a8.26 8.26 0 0 0-16 0zm176 0a8.26 8.26 0 0 0-16 0c-12.8 44.4-40 56.39-40 87.69 0 27.69 21.5 50.09 48 50.09s48-22.4 48-50.09c0-31.4-27.2-43.09-40-87.69z", "M512 224a96 96 0 0 1-96 96H96a96 96 0 0 1-96-96c0-42.5 27.8-78.2 66.1-90.8A113.72 113.72 0 0 1 64 112 111.94 111.94 0 0 1 176 0c43.3 0 80.4 24.8 99 60.8C289.7 43.3 311.4 32 336 32a80 80 0 0 1 80 80 78.09 78.09 0 0 1-1.6 16.2c.5 0 1-.2 1.6-.2a96 96 0 0 1 96 96z"]],
    "cloud-rainbow": [576, 512, [], "f73e", ["M430.8 304.9a125.07 125.07 0 0 1 26.9 20.3C487.1 292.8 529 272 576 272v-64a223.38 223.38 0 0 0-156.8 64.3 94.09 94.09 0 0 1 11.6 32.6zM238.6 173.6a142.8 142.8 0 0 1 56.6 31C359.6 119.4 461.3 64 576 64V0C437.1 0 314.2 68.7 238.6 173.6zm87.2 51.5c7.4-.8 36.7-5.4 68.4 18.9A255.37 255.37 0 0 1 576 168v-64c-101.3 0-191.6 47.4-250.2 121.1z", "M399.2 325.6c37.6 13 64.8 48.4 64.8 90.4a96 96 0 0 1-96 96H96a96 96 0 0 1-96-96c0-50.6 39.2-91.6 88.9-95.3-.2-2.9-.9-5.7-.9-8.7a111.87 111.87 0 0 1 213.9-46 63.81 63.81 0 0 1 98.1 54 53.91 53.91 0 0 1-.8 5.6z"]],
    "cloud-showers": [512, 512, [], "f73f", ["M48 368a16 16 0 0 0-16 16v80a16 16 0 0 0 32 0v-80a16 16 0 0 0-16-16zm96 32a16 16 0 0 0-16 16v80a16 16 0 0 0 32 0v-80a16 16 0 0 0-16-16zm96-32a16 16 0 0 0-16 16v80a16 16 0 0 0 32 0v-80a16 16 0 0 0-16-16zm96 32a16 16 0 0 0-16 16v80a16 16 0 0 0 32 0v-80a16 16 0 0 0-16-16zm96-32a16 16 0 0 0-16 16v80a16 16 0 0 0 32 0v-80a16 16 0 0 0-16-16z", "M512 224a96 96 0 0 1-96 96H96a96 96 0 0 1-96-96c0-42.5 27.8-78.2 66.1-90.8A113.72 113.72 0 0 1 64 112 111.94 111.94 0 0 1 176 0c43.3 0 80.4 24.8 99 60.8C289.7 43.3 311.4 32 336 32a80 80 0 0 1 80 80 78.09 78.09 0 0 1-1.6 16.2c.5 0 1-.2 1.6-.2a96 96 0 0 1 96 96z"]],
    "cloud-showers-heavy": [512, 512, [], "f740", ["M183.9 370.1a15.88 15.88 0 0 0-21.8 6l-64 112a15.92 15.92 0 0 0 6 21.8 16 16 0 0 0 21.8-6l64-112a16 16 0 0 0-6-21.8zm96 0a15.88 15.88 0 0 0-21.8 6l-64 112a15.92 15.92 0 0 0 6 21.8 16 16 0 0 0 21.8-6l64-112a16 16 0 0 0-6-21.8zm-192 0a15.88 15.88 0 0 0-21.8 6l-64 112a15.92 15.92 0 0 0 6 21.8 16 16 0 0 0 21.8-6l64-112a16 16 0 0 0-5.99-21.8zm384 0a15.88 15.88 0 0 0-21.8 6l-64 112a15.92 15.92 0 0 0 6 21.8 16 16 0 0 0 21.8-6l64-112a16 16 0 0 0-6.01-21.8zm-96 0a15.88 15.88 0 0 0-21.8 6l-64 112a15.92 15.92 0 0 0 6 21.8 16 16 0 0 0 21.8-6l64-112a16 16 0 0 0-6.01-21.8z", "M512 224a96 96 0 0 1-96 96H96a96 96 0 0 1-96-96c0-42.5 27.8-78.2 66.1-90.8A113.72 113.72 0 0 1 64 112 112 112 0 0 1 176 0c43.3 0 80.4 24.8 99 60.8C289.7 43.3 311.4 32 336 32a80 80 0 0 1 80 80 78.09 78.09 0 0 1-1.6 16.2c.5 0 1-.2 1.6-.2a96 96 0 0 1 96 96z"]],
    "cloud-sleet": [512, 512, [], "f741", ["M87.2 353.7a16.12 16.12 0 0 0-21.5 7.2l-64 128a16 16 0 0 0 7.2 21.5 16.88 16.88 0 0 0 7.2 1.7 16 16 0 0 0 14.3-8.8l64-128a16.23 16.23 0 0 0-7.2-21.6zm256 0a16.12 16.12 0 0 0-21.5 7.2l-64 128a16 16 0 0 0 7.2 21.5 16.88 16.88 0 0 0 7.2 1.7 16 16 0 0 0 14.3-8.8l64-128a16.23 16.23 0 0 0-7.2-21.6zM492 432l-27.9-16 27.9-16a8 8 0 0 0 2.9-10.9l-8-13.9a8 8 0 0 0-10.9-2.9l-28 16.1V360a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v28.4l-28-16.1a8 8 0 0 0-10.9 2.9l-8 13.9A8 8 0 0 0 372 400l27.9 16-27.9 16a8 8 0 0 0-2.9 10.9l8 13.9a8 8 0 0 0 10.9 2.9l28-16.1V472a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-28.4l28 16.1a8 8 0 0 0 10.9-2.9l8-13.9A8 8 0 0 0 492 432zm-253.1-42.9l-8-13.9a8 8 0 0 0-10.9-2.9l-28 16.1V360a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v28.4l-28-16.1a8 8 0 0 0-10.9 2.9l-8 13.9A8 8 0 0 0 116 400l27.9 16-27.9 16a8 8 0 0 0-2.9 10.9l8 13.9a8 8 0 0 0 10.9 2.9l28-16.1V472a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-28.4l28 16.1a8 8 0 0 0 10.9-2.9l8-13.9A8 8 0 0 0 236 432l-27.9-16 27.9-16a8 8 0 0 0 2.9-10.9z", "M416 320H96a96 96 0 0 1-96-96c0-42.5 27.8-78.2 66.1-90.8A113.72 113.72 0 0 1 64 112 111.94 111.94 0 0 1 176 0c43.3 0 80.4 24.8 99 60.8C289.7 43.3 311.4 32 336 32a80 80 0 0 1 80 80 78.09 78.09 0 0 1-1.6 16.2c.5 0 1-.2 1.6-.2a96 96 0 0 1 0 192z"]],
    "cloud-snow": [512, 512, [], "f742", ["M126.9 389.1l-8-13.9a8 8 0 0 0-10.9-2.9l-28 16.1V360a8 8 0 0 0-8-8H56a8 8 0 0 0-8 8v28.4l-28-16.1a8 8 0 0 0-10.9 2.9l-8 13.9A8 8 0 0 0 4 400l27.9 16L4 432a8 8 0 0 0-2.9 10.9l8 13.9a8 8 0 0 0 10.9 2.9l28-16.1V472a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-28.4l28 16.1a8 8 0 0 0 10.9-2.9l8-13.9A8 8 0 0 0 124 432l-27.9-16 27.9-16a8 8 0 0 0 2.9-10.9zm192 32l-8-13.9a8 8 0 0 0-10.9-2.9l-28 16.1V392a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v28.4l-28-16.1a8 8 0 0 0-10.9 2.9l-8 13.9A8 8 0 0 0 196 432l27.9 16-27.9 16a8 8 0 0 0-2.9 10.9l8 13.9a8 8 0 0 0 10.9 2.9l28-16.1V504a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-28.4l28 16.1a8 8 0 0 0 10.9-2.9l8-13.9A8 8 0 0 0 316 464l-27.9-16 27.9-16a8 8 0 0 0 2.9-10.9zM508 432l-27.9-16 27.9-16a8 8 0 0 0 2.9-10.9l-8-13.9a8 8 0 0 0-10.9-2.9l-28 16.1V360a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v28.4l-28-16.1a8 8 0 0 0-10.9 2.9l-8 13.9A8 8 0 0 0 388 400l27.9 16-27.9 16a8 8 0 0 0-2.9 10.9l8 13.9a8 8 0 0 0 10.9 2.9l28-16.1V472a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-28.4l28 16.1a8 8 0 0 0 10.9-2.9l8-13.9A8 8 0 0 0 508 432z", "M0 224c0-42.5 27.8-78.2 66.1-90.8A113.72 113.72 0 0 1 64 112 111.94 111.94 0 0 1 176 0c43.3 0 80.4 24.8 99 60.8C289.7 43.3 311.4 32 336 32a80 80 0 0 1 80 80 78.09 78.09 0 0 1-1.6 16.2c.5 0 1-.2 1.6-.2a96 96 0 0 1 0 192H96a96 96 0 0 1-96-96z"]],
    "cloud-sun": [640, 512, [], "f6c4", ["M366.8 61.89L279 91.18 237.5 8.4a15.13 15.13 0 0 0-27.1 0L169 91.18 81.1 61.89a15.23 15.23 0 0 0-19.2 19.19l29.3 87.79-82.8 41.49a15.12 15.12 0 0 0 0 27.09l82.8 41.4-29.3 87.78a15.16 15.16 0 0 0 19.2 19.19l76.1-25.29A129 129 0 0 1 180.8 327a110.27 110.27 0 0 1-36-24 112 112 0 1 1 180.7-125.53 143.5 143.5 0 0 1 30.7-7.5L386 81.08a15.16 15.16 0 0 0-19.2-19.19zM224 140a83.85 83.85 0 0 0-16.1 166.17 128.29 128.29 0 0 1 25.2-11.7 144.12 144.12 0 0 1 67.4-105A84.15 84.15 0 0 0 224 140z", "M575.2 325.64c37.6 13 64.8 48.29 64.8 90.38a96 96 0 0 1-96 96H272a96 96 0 0 1-96-96c0-50.59 39.3-91.58 88.9-95.28-.2-2.9-.9-5.7-.9-8.7a112 112 0 0 1 112-112c45.4 0 84.3 27.2 101.9 66A63.81 63.81 0 0 1 576 320a53.91 53.91 0 0 1-.8 5.6z"]],
    "cloud-sun-rain": [576, 512, [], "f743", ["M322 96.2l8.9-26.7a13 13 0 0 0-16.5-16.4l-75.3 25.1-35.5-71a13 13 0 0 0-23.3 0l-35.5 71-75.3-25.1a13 13 0 0 0-16.4 16.5l25.1 75.3-71 35.5a13 13 0 0 0 0 23.3l71 35.5-25.1 75.3A13.06 13.06 0 0 0 69.6 331l59.2-19.7c-.2-2.4-.7-4.7-.7-7.2a110.52 110.52 0 0 1 6.2-35.9 92.22 92.22 0 0 1-10.2-8.3 96.21 96.21 0 0 1 0-135.8c34.6-34.6 89.1-36.8 126.7-7.4A127.12 127.12 0 0 1 320 96c.7 0 1.3.2 2 .2zm-96.2 41.7A63.13 63.13 0 0 0 192 128a64.06 64.06 0 0 0-64 64 63.4 63.4 0 0 0 21.1 47.1 112.14 112.14 0 0 1 44.8-37.2 127.52 127.52 0 0 1 31.9-64zm298.7 280.2a16 16 0 0 0-21.8 6l-36.6 64a15.94 15.94 0 0 0 6 21.8 16 16 0 0 0 21.8-6l36.6-64a16 16 0 0 0-6-21.8zm-96 0a16 16 0 0 0-21.8 6l-36.6 64a15.94 15.94 0 0 0 6 21.8 16 16 0 0 0 21.8-6l36.6-64a16 16 0 0 0-6-21.8zm-96 0a16 16 0 0 0-21.8 6l-36.6 64a15.94 15.94 0 0 0 6 21.8 16 16 0 0 0 21.8-6l36.6-64a16 16 0 0 0-6-21.8zm-96 0a16 16 0 0 0-21.8 6l-36.6 64a15.94 15.94 0 0 0 6 21.8 16 16 0 0 0 21.8-6l36.6-64a16 16 0 0 0-6-21.8z", "M576 304a80 80 0 0 1-80 80H240a80 80 0 0 1-15.8-158.4c0-.5-.2-1.1-.2-1.6a95.82 95.82 0 0 1 173.7-56 79 79 0 0 1 34.3-8 80 80 0 0 1 78.5 65.5A79.79 79.79 0 0 1 576 304z"]],
    "cloud-upload": [640, 512, [], "f0ee", ["M537.6 226.6A96.11 96.11 0 0 0 448 96a95.51 95.51 0 0 0-53.3 16.2A160 160 0 0 0 96 192c0 2.7.1 5.4.2 8.1A144 144 0 0 0 144 480h368a128 128 0 0 0 25.6-253.4zm-139.9 63.7l-10.8 10.8a24.09 24.09 0 0 1-34.5-.5L320 266.1V392a23.94 23.94 0 0 1-24 24h-16a23.94 23.94 0 0 1-24-24V266.1l-32.4 34.5a24 24 0 0 1-34.5.5l-10.8-10.8a23.9 23.9 0 0 1 0-33.9l92.7-92.7a23.9 23.9 0 0 1 33.9 0l92.7 92.7a24 24 0 0 1 .1 33.9z", "M397.7 290.3l-10.8 10.8a24.09 24.09 0 0 1-34.5-.5L320 266.1V392a23.94 23.94 0 0 1-24 24h-16a23.94 23.94 0 0 1-24-24V266.1l-32.4 34.5a24 24 0 0 1-34.5.5l-10.8-10.8a23.9 23.9 0 0 1 0-33.9l92.7-92.7a23.9 23.9 0 0 1 33.9 0l92.7 92.7a24 24 0 0 1 .1 33.9z"]],
    "cloud-upload-alt": [640, 512, [], "f382", ["M537.6 226.6A96.11 96.11 0 0 0 448 96a95.51 95.51 0 0 0-53.3 16.2A160 160 0 0 0 96 192c0 2.7.1 5.4.2 8.1A144 144 0 0 0 144 480h368a128 128 0 0 0 25.6-253.4zM393.4 288H328v112a16 16 0 0 1-16 16h-48a16 16 0 0 1-16-16V288h-65.4a16 16 0 0 1-11.3-27.3l105.4-105.4a16.06 16.06 0 0 1 22.6 0l105.4 105.4c10.1 10.1 2.9 27.3-11.3 27.3z", "M393.4 288H328v112a16 16 0 0 1-16 16h-48a16 16 0 0 1-16-16V288h-65.4a16 16 0 0 1-11.3-27.3l105.4-105.4a16.06 16.06 0 0 1 22.6 0l105.4 105.4c10.1 10.1 2.9 27.3-11.3 27.3z"]],
    "clouds": [640, 512, [], "f744", ["M161.6 288H96a96 96 0 0 1 0-192c.6 0 1.1.2 1.6.2C105.3 41.9 151.6 0 208 0a111.61 111.61 0 0 1 104.5 72.7A95.07 95.07 0 0 1 352 64a96 96 0 0 1 96 96 93 93 0 0 1-7 34.7 110.5 110.5 0 0 0-31.6 11.8A142.54 142.54 0 0 0 304 160c-73.9 0-134.3 56.2-142.4 128z", "M640 416a96 96 0 0 1-96 96H224a96 96 0 0 1-96-96c0-42.5 27.8-78.2 66.1-90.8A113.72 113.72 0 0 1 192 304a111.94 111.94 0 0 1 112-112c43.2 0 80.4 24.9 99 60.8 14.7-17.5 36.4-28.8 61-28.8a80 80 0 0 1 80 80 78.09 78.09 0 0 1-1.6 16.2c.5 0 1-.2 1.6-.2a96 96 0 0 1 96 96z"]],
    "clouds-moon": [640, 512, [], "f745", ["M638.48 257.87A159.19 159.19 0 0 1 534.56 320a124.64 124.64 0 0 0-61.37-27.16 111.65 111.65 0 0 0-88.77-62.12 113.15 113.15 0 0 0-32.06-62.37c0-.7-.24-1.3-.27-2C349.13 77.53 418.1 3.12 506 .09a155.62 155.62 0 0 1 29.15 1.72A7.56 7.56 0 0 1 538 15.69a126.31 126.31 0 0 0-59.51 111.7c2.62 78.77 75.59 136.11 152.4 118.57 6.75-1.54 11.76 6.24 7.59 11.91z", "M448 320h-1.6a79.68 79.68 0 0 0-139.44-35.2c-18.61-35.9-55.82-60.8-99-60.8-58.38 0-105.7 44.7-110.96 101.6-37.85 12.9-65.16 48.3-65.16 90.4a96 96 0 0 0 96 96H448a96 96 0 1 0 0-192zM68 303.41c14.79-64.66 71.51-111.31 139-111.31a141.46 141.46 0 0 1 104.88 46.55 110.61 110.61 0 0 1 36.91-12.92c-6.76-37.34-39.1-65.66-78.11-65.66h-17.54a79.53 79.53 0 0 0-156 0H79.6c-44 0-79.6 35.83-79.6 80.08a80 80 0 0 0 50.75 74.47A131.22 131.22 0 0 1 68 303.41z"]],
    "clouds-sun": [640, 512, [], "f746", ["M314.45 53.1l-75.29 25.1-35.49-71a13 13 0 0 0-23.3 0l-35.49 71-75.29-25.1a13.06 13.06 0 0 0-16.5 16.5l25.1 75.3-71 35.5a13 13 0 0 0 0 23.3l71 35.5-25.1 75.3a13.06 13.06 0 0 0 16.5 16.5l42.69-14.2a124.47 124.47 0 0 1 20.1-13.6 141.91 141.91 0 0 1 10.5-29.1 94.9 94.9 0 0 1-18.7-150 96.18 96.18 0 0 1 135.78 0 93.93 93.93 0 0 1 24.1 42.4 110.08 110.08 0 0 1 20.59-18.6L331 69.5a13 13 0 0 0-16.55-16.4zM192.07 128a63.78 63.78 0 0 0-32.3 118.9A141.32 141.32 0 0 1 256 193.4c0-.5.1-.9.1-1.4a64.06 64.06 0 0 0-64.03-64z", "M512 320h-1.6a80 80 0 0 0-78.4-64c-24.6 0-46.3 11.3-61 28.8-18.6-35.9-55.8-60.8-99-60.8-58.3 0-105.6 44.7-110.9 101.6C123.3 338.5 96 373.9 96 416a96 96 0 0 0 96 96h320a96 96 0 0 0 0-192zm48-160h-17.58a80 80 0 0 0-156.78 0H368a79.77 79.77 0 0 0-66.19 35.1 142.52 142.52 0 0 1 75.59 43.3 110.34 110.34 0 0 1 54.6-14.5 112.41 112.41 0 0 1 102.09 65.9 127.06 127.06 0 0 1 55 24.4A79.81 79.81 0 0 0 560 160z"]],
    "club": [512, 512, [], "f327", ["M512 292a124 124 0 0 1-124 124c-41.36 0-77.55-20.54-100-51.69V272a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v92.31C201.55 395.46 165.36 416 124 416a124 124 0 0 1 0-248c5.8 0 11.36.94 16.95 1.71a124 124 0 1 1 230.1 0c5.59-.77 11.15-1.71 16.95-1.71a124 124 0 0 1 124 124z", "M367.31 486.59A32 32 0 0 1 336 512H176a32 32 0 0 1-13-61.3c52.19-23.2 60.91-38.9 61-75.61V272a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v103.09c.19 37.5 9.41 52.61 61 75.61a32.09 32.09 0 0 1 18.31 35.89z"]],
    "cocktail": [576, 512, [], "f561", ["M208 280.27L264.28 224H151.72zM432 0c-62.6 0-115.34 40.2-135.17 96h52.53C366 67.45 396.63 48 432 48a96 96 0 0 1 0 192 95 95 0 0 1-39.32-8.64l-35.26 35.26A144 144 0 1 0 432 0z", "M408.75 170.05c15.52-15.52 4.53-42.05-17.42-42.05H24.69c-22 0-32.94 26.53-17.42 42.05L176 338.78V464h-56a40 40 0 0 0-40 40 8 8 0 0 0 8 8h240a8 8 0 0 0 8-8 40 40 0 0 0-40-40h-56V338.78zM208 280.27L119.73 192h176.55z"]],
    "code": [640, 512, [], "f121", ["M422.12 18.16a12 12 0 0 1 8.2 14.9l-136.5 470.2a12 12 0 0 1-14.89 8.2l-61-17.7a12 12 0 0 1-8.2-14.9l136.5-470.2a12 12 0 0 1 14.89-8.2z", "M636.23 247.26l-144.11-135.2a12.11 12.11 0 0 0-17 .5L431.62 159a12 12 0 0 0 .81 17.2L523 256l-90.59 79.7a11.92 11.92 0 0 0-.81 17.2l43.5 46.4a12 12 0 0 0 17 .6l144.11-135.1a11.94 11.94 0 0 0 .02-17.54zm-427.8-88.2l-43.5-46.4a12 12 0 0 0-17-.5l-144.11 135a11.94 11.94 0 0 0 0 17.5l144.11 135.1a11.92 11.92 0 0 0 17-.5l43.5-46.4a12 12 0 0 0-.81-17.2L117 256l90.6-79.7a11.92 11.92 0 0 0 .83-17.24z"]],
    "code-branch": [384, 512, [], "f126", ["M328 220.33V224c0 32-6.69 47.26-20 63.8-28.2 35-76 39.5-118.2 43.4-25.7 2.4-49.9 4.6-66.1 12.8-3.82 1.94-9.25 6.44-13.44 13.94A80.16 80.16 0 0 0 56 355.67V156.33a80.31 80.31 0 0 0 48 0v144c23.9-11.5 53.1-14.3 81.3-16.9 35.9-3.3 69.8-6.5 85.2-25.7 6.34-7.83 9.5-17.7 9.5-33.7v-3.67a80.31 80.31 0 0 0 48 0z", "M80 0a80 80 0 1 0 80 80A80 80 0 0 0 80 0zm0 96a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm0 256a80 80 0 1 0 80 80 80 80 0 0 0-80-80zm0 96a16 16 0 1 1 16-16 16 16 0 0 1-16 16zM304 64a80 80 0 1 0 80 80 80 80 0 0 0-80-80zm0 96a16 16 0 1 1 16-16 16 16 0 0 1-16 16z"]],
    "code-commit": [640, 512, [], "f386", ["M628 224H509.4a189.29 189.29 0 0 1 2.6 32 200.23 200.23 0 0 1-2.6 32H628a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm-616 0a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h118.6a198.22 198.22 0 0 1 0-64z", "M320 96a160 160 0 1 0 160 160A160 160 0 0 0 320 96zm0 202a42 42 0 1 1 42-42 42 42 0 0 1-42 42z"]],
    "code-merge": [384, 512, [], "f387", ["M227.06 293.9A199.9 199.9 0 0 1 104 225.83v129.84a80.31 80.31 0 0 0-48 0V156.33a80.24 80.24 0 0 0 58.73-4.24 152.51 152.51 0 0 0 113.78 93.41 80 80 0 0 0-1.45 48.4z", "M80 0a80 80 0 1 0 80 80A80 80 0 0 0 80 0zm0 96a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm0 256a80 80 0 1 0 80 80 80 80 0 0 0-80-80zm0 96a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm224-256a80 80 0 1 0 80 80 80 80 0 0 0-80-80zm0 96a16 16 0 1 1 16-16 16 16 0 0 1-16 16z"]],
    "coffee": [640, 512, [], "f0f4", ["M559.76 480H48.36c-47.6 0-61-64-36-64h583.3c25 0 11.8 64-35.9 64z", "M512.06 32h-392a23.94 23.94 0 0 0-24 24v232a96 96 0 0 0 96 96h192a96 96 0 0 0 96-96h32a128 128 0 0 0 0-256zm0 192h-32V96h32a64 64 0 0 1 0 128z"]],
    "coffee-togo": [448, 512, [], "f6c5", ["M48 160h352l-8 96H56zm330.67 256H69.33l-11-131.76 16.56 198.42A32 32 0 0 0 106.78 512h234.44a32 32 0 0 0 31.89-29.34l16.54-198.42z", "M69.33 416h309.34L392 256H56zM432 64h-16l-23.16-46.31A32 32 0 0 0 364.22 0H83.78a32 32 0 0 0-28.62 17.69L32 64H16A16 16 0 0 0 0 80v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16V80a16 16 0 0 0-16-16z"]],
    "coffin": [384, 512, [], "f6c6", ["M288 192a16 16 0 0 1-16 16h-56v128a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16V208h-56a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h56v-48a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v48h56a16 16 0 0 1 16 16z", "M374.44 115.19L266.71 9.37a32.93 32.93 0 0 0-23-9.37H140.33a32.89 32.89 0 0 0-23 9.37L9.54 115.19A31.61 31.61 0 0 0 1 145.58l87.1 342.18A32.49 32.49 0 0 0 119.69 512h144.62a32.47 32.47 0 0 0 31.61-24.24L383 145.58a31.67 31.67 0 0 0-8.56-30.39zM288 192a16 16 0 0 1-16 16h-56v128a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16V208h-56a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h56v-48a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v48h56a16 16 0 0 1 16 16z"]],
    "cog": [512, 512, [], "f013", ["M487.75 315.6l-42.6-24.6a192.62 192.62 0 0 0 0-70.2l42.6-24.6a12.11 12.11 0 0 0 5.5-14 249.2 249.2 0 0 0-54.7-94.6 12 12 0 0 0-14.8-2.3l-42.6 24.6a188.83 188.83 0 0 0-60.8-35.1V25.7A12 12 0 0 0 311 14a251.43 251.43 0 0 0-109.2 0 12 12 0 0 0-9.4 11.7v49.2a194.59 194.59 0 0 0-60.8 35.1L89.05 85.4a11.88 11.88 0 0 0-14.8 2.3 247.66 247.66 0 0 0-54.7 94.6 12 12 0 0 0 5.5 14l42.6 24.6a192.62 192.62 0 0 0 0 70.2l-42.6 24.6a12.08 12.08 0 0 0-5.5 14 249 249 0 0 0 54.7 94.6 12 12 0 0 0 14.8 2.3l42.6-24.6a188.54 188.54 0 0 0 60.8 35.1v49.2a12 12 0 0 0 9.4 11.7 251.43 251.43 0 0 0 109.2 0 12 12 0 0 0 9.4-11.7v-49.2a194.7 194.7 0 0 0 60.8-35.1l42.6 24.6a11.89 11.89 0 0 0 14.8-2.3 247.52 247.52 0 0 0 54.7-94.6 12.36 12.36 0 0 0-5.6-14.1zm-231.4 36.2a95.9 95.9 0 1 1 95.9-95.9 95.89 95.89 0 0 1-95.9 95.9z", "M256.35 319.8a63.9 63.9 0 1 1 63.9-63.9 63.9 63.9 0 0 1-63.9 63.9z"]],
    "cogs": [640, 512, [], "f085", ["M638.41 387a12.34 12.34 0 0 0-12.2-10.3h-16.5a86.33 86.33 0 0 0-15.9-27.4L602 335a12.42 12.42 0 0 0-2.8-15.7 110.5 110.5 0 0 0-32.1-18.6 12.36 12.36 0 0 0-15.1 5.4l-8.2 14.3a88.86 88.86 0 0 0-31.7 0l-8.2-14.3a12.36 12.36 0 0 0-15.1-5.4 111.83 111.83 0 0 0-32.1 18.6 12.3 12.3 0 0 0-2.8 15.7l8.2 14.3a86.33 86.33 0 0 0-15.9 27.4h-16.5a12.43 12.43 0 0 0-12.2 10.4 112.66 112.66 0 0 0 0 37.1 12.34 12.34 0 0 0 12.2 10.3h16.5a86.33 86.33 0 0 0 15.9 27.4l-8.2 14.3a12.42 12.42 0 0 0 2.8 15.7 110.5 110.5 0 0 0 32.1 18.6 12.36 12.36 0 0 0 15.1-5.4l8.2-14.3a88.86 88.86 0 0 0 31.7 0l8.2 14.3a12.36 12.36 0 0 0 15.1 5.4 111.83 111.83 0 0 0 32.1-18.6 12.3 12.3 0 0 0 2.8-15.7l-8.2-14.3a86.33 86.33 0 0 0 15.9-27.4h16.5a12.43 12.43 0 0 0 12.2-10.4 112.66 112.66 0 0 0 .01-37.1zm-136.8 44.9c-29.6-38.5 14.3-82.4 52.8-52.8 29.59 38.49-14.3 82.39-52.8 52.79zm136.8-343.8a12.34 12.34 0 0 0-12.2-10.3h-16.5a86.33 86.33 0 0 0-15.9-27.4l8.2-14.3a12.42 12.42 0 0 0-2.8-15.7 110.5 110.5 0 0 0-32.1-18.6A12.36 12.36 0 0 0 552 7.19l-8.2 14.3a88.86 88.86 0 0 0-31.7 0l-8.2-14.3a12.36 12.36 0 0 0-15.1-5.4 111.83 111.83 0 0 0-32.1 18.6 12.3 12.3 0 0 0-2.8 15.7l8.2 14.3a86.33 86.33 0 0 0-15.9 27.4h-16.5a12.43 12.43 0 0 0-12.2 10.4 112.66 112.66 0 0 0 0 37.1 12.34 12.34 0 0 0 12.2 10.3h16.5a86.33 86.33 0 0 0 15.9 27.4l-8.2 14.3a12.42 12.42 0 0 0 2.8 15.7 110.5 110.5 0 0 0 32.1 18.6 12.36 12.36 0 0 0 15.1-5.4l8.2-14.3a88.86 88.86 0 0 0 31.7 0l8.2 14.3a12.36 12.36 0 0 0 15.1 5.4 111.83 111.83 0 0 0 32.1-18.6 12.3 12.3 0 0 0 2.8-15.7l-8.2-14.3a86.33 86.33 0 0 0 15.9-27.4h16.5a12.43 12.43 0 0 0 12.2-10.4 112.66 112.66 0 0 0 .01-37.1zm-136.8 45c-29.6-38.5 14.3-82.5 52.8-52.8 29.59 38.49-14.3 82.39-52.8 52.79z", "M420 303.79L386.31 287a173.78 173.78 0 0 0 0-63.5l33.7-16.8c10.1-5.9 14-18.2 10-29.1-8.9-24.2-25.9-46.4-42.1-65.8a23.93 23.93 0 0 0-30.3-5.3l-29.1 16.8a173.66 173.66 0 0 0-54.9-31.7V58a24 24 0 0 0-20-23.6 228.06 228.06 0 0 0-76 .1A23.82 23.82 0 0 0 158 58v33.7a171.78 171.78 0 0 0-54.9 31.7L74 106.59a23.91 23.91 0 0 0-30.3 5.3c-16.2 19.4-33.3 41.6-42.2 65.8a23.84 23.84 0 0 0 10.5 29l33.3 16.9a173.24 173.24 0 0 0 0 63.4L12 303.79a24.13 24.13 0 0 0-10.5 29.1c8.9 24.1 26 46.3 42.2 65.7a23.93 23.93 0 0 0 30.3 5.3l29.1-16.7a173.66 173.66 0 0 0 54.9 31.7v33.6a24 24 0 0 0 20 23.6 224.88 224.88 0 0 0 75.9 0 23.93 23.93 0 0 0 19.7-23.6v-33.6a171.78 171.78 0 0 0 54.9-31.7l29.1 16.8a23.91 23.91 0 0 0 30.3-5.3c16.2-19.4 33.7-41.6 42.6-65.8a24 24 0 0 0-10.5-29.1zm-151.3 4.3c-77 59.2-164.9-28.7-105.7-105.7 77-59.2 164.91 28.7 105.71 105.7z"]],
    "coin": [512, 512, [], "f85c", ["M0 208C0 128.44 114.67 64 256 64s256 64.44 256 144-114.67 144-256 144S0 287.56 0 208z", "M0 320c0 27.77 18 53.37 48 74.33V330c-18.85-12-35.4-25.36-48-40.38zm80 92.51c27.09 12.89 59.66 22.81 96 28.8V377c-35.39-6-67.81-15.88-96-29zM464 330v64.32c30.05-21 48-46.56 48-74.33v-30.36C499.4 304.65 482.85 318 464 330zM336 441.31c36.34-6 68.91-15.91 96-28.8V348c-28.19 13.12-60.61 23-96 29zM208 381.2v64.09c15.62 1.51 31.49 2.71 48 2.71s32.38-1.2 48-2.71V381.2a477.2 477.2 0 0 1-48 2.8 477.2 477.2 0 0 1-48-2.8z"]],
    "coins": [512, 512, [], "f51e", ["M416 311.4c57.3-11.1 96-31.7 96-55.4v-42.7c-23.2 16.4-57.3 27.6-96 34.5zm-4.7-95.1c60-10.8 100.7-32 100.7-56.3v-42.7c-35.5 25.1-96.5 38.6-160.7 41.8 29.5 14.3 51.2 33.5 60 57.2zM512 64c0-35.3-86-64-192-64S128 28.7 128 64s86 64 192 64 192-28.7 192-64z", "M192 320c106 0 192-35.8 192-80s-86-80-192-80S0 195.8 0 240s86 80 192 80zM0 405.3V448c0 35.3 86 64 192 64s192-28.7 192-64v-42.7C342.7 434.4 267.2 448 192 448S41.3 434.4 0 405.3zm0-104.9V352c0 35.3 86 64 192 64s192-28.7 192-64v-51.6c-41.3 34-116.9 51.6-192 51.6S41.3 334.4 0 300.4z"]],
    "columns": [512, 512, [], "f0db", ["M288 160v256h160V160zM64 416h160V160H64z", "M464 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zM224 416H64V160h160zm224 0H288V160h160z"]],
    "comment": [512, 512, [], "f075", ["M256 32C114.6 32 0 125.1 0 240c0 49.6 21.4 95 57 130.7C44.5 421.1 2.7 466 2.2 466.5c-2.2 2.3-2.8 5.7-1.5 8.7S4.8 480 8 480c66.3 0 116-31.8 140.6-51.4 32.7 12.3 69 19.4 107.4 19.4 141.4 0 256-93.1 256-208S397.4 32 256 32z", ""]],
    "comment-alt": [512, 512, [], "f27a", ["M448 0H64C28.7 0 0 28.7 0 64v288c0 35.3 28.7 64 64 64h96v84c0 9.8 11.2 15.5 19.1 9.7L304 416h144c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64z", ""]],
    "comment-alt-check": [512, 512, [], "f4a2", ["M448 0H64A64.06 64.06 0 0 0 0 64v288a64.06 64.06 0 0 0 64 64h96v84a12 12 0 0 0 19.1 9.7L304 416h144a64.06 64.06 0 0 0 64-64V64a64.06 64.06 0 0 0-64-64zm-77.9 163.8l-131 130a11 11 0 0 1-15.6-.1l-75.7-76.3a11 11 0 0 1 .1-15.6l26-25.8a11 11 0 0 1 15.6.1l42.1 42.5 97.2-96.4a11 11 0 0 1 15.6.1l25.8 26a11 11 0 0 1-.1 15.5z", "M370.1 163.8l-131 130a11 11 0 0 1-15.6-.1l-75.7-76.3a11 11 0 0 1 .1-15.6l26-25.8a11 11 0 0 1 15.6.1l42.1 42.5 97.2-96.4a11 11 0 0 1 15.6.1l25.8 26a11 11 0 0 1-.1 15.5z"]],
    "comment-alt-dollar": [512, 512, [], "f650", ["M448 0H64A64 64 0 0 0 0 64v288a64 64 0 0 0 64 64h96v84a12 12 0 0 0 19.13 9.65L304 416h144a64 64 0 0 0 64-64V64a64 64 0 0 0-64-64zM280 302.44V320a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-17.73a73 73 0 0 1-31.78-11.46c-6.22-4.11-6.82-13.11-1.55-18.38l17.52-17.52c3.74-3.74 9.31-4.24 14.11-2a24.52 24.52 0 0 0 10.26 2.22h32.78a8.43 8.43 0 0 0 2.32-16.53l-50.07-14.3c-22.25-6.35-40-24.71-42.91-47.67a56.27 56.27 0 0 1 49.32-63V96a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v17.73a73 73 0 0 1 31.78 11.46c6.22 4.11 6.82 13.11 1.55 18.38l-17.52 17.52c-3.74 3.74-9.31 4.24-14.11 2a24.54 24.54 0 0 0-10.26-2.22h-32.78a8.43 8.43 0 0 0-2.32 16.53l50.07 14.3c22.25 6.36 40 24.71 42.91 47.67A56.27 56.27 0 0 1 280 302.44z", "M280 302.44V320a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-17.73a73 73 0 0 1-31.78-11.46c-6.22-4.11-6.82-13.11-1.55-18.38l17.52-17.52c3.74-3.74 9.31-4.24 14.11-2a24.52 24.52 0 0 0 10.26 2.22h32.78a8.43 8.43 0 0 0 2.32-16.53l-50.07-14.3c-22.25-6.35-40-24.71-42.91-47.67a56.27 56.27 0 0 1 49.32-63V96a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v17.73a73 73 0 0 1 31.78 11.46c6.22 4.11 6.82 13.11 1.55 18.38l-17.52 17.52c-3.74 3.74-9.31 4.24-14.11 2a24.54 24.54 0 0 0-10.26-2.22h-32.78a8.43 8.43 0 0 0-2.32 16.53l50.07 14.3c22.25 6.36 40 24.71 42.91 47.67A56.27 56.27 0 0 1 280 302.44z"]],
    "comment-alt-dots": [512, 512, [], "f4a3", ["M448 0H64A64.06 64.06 0 0 0 0 64v288a64.06 64.06 0 0 0 64 64h96v84a12 12 0 0 0 19.1 9.7L304 416h144a64.06 64.06 0 0 0 64-64V64a64.06 64.06 0 0 0-64-64zM128 240a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm128 0a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm128 0a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M384 176a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm-128 0a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm-128 0a32 32 0 1 0 32 32 32 32 0 0 0-32-32z"]],
    "comment-alt-edit": [512, 512, [], "f4a4", ["M448 0H64A64.06 64.06 0 0 0 0 64v288a64.06 64.06 0 0 0 64 64h96v84a12 12 0 0 0 19.1 9.7L304 416h144a64.06 64.06 0 0 0 64-64V64a64.06 64.06 0 0 0-64-64zM215.4 310.6l-48.2 5.4a10.17 10.17 0 0 1-11.2-11.2l5.4-48.2 96.3-96.3 54 54zm150.7-150.7l-31.8 31.8-54-54 31.8-31.8a20.22 20.22 0 0 1 28.6 0l25.4 25.4a20.22 20.22 0 0 1 0 28.6z", "M161.4 256.6l-5.4 48.2a10.17 10.17 0 0 0 11.2 11.2l48.2-5.4 96.3-96.3-54-54zm204.7-125.3l-25.4-25.4a20.22 20.22 0 0 0-28.6 0l-31.8 31.8 54 54 31.8-31.8a20.22 20.22 0 0 0 0-28.6z"]],
    "comment-alt-exclamation": [512, 512, [], "f4a5", ["M448 0H64A64.06 64.06 0 0 0 0 64v288a64.06 64.06 0 0 0 64 64h96v84a12 12 0 0 0 19.1 9.7L304 416h144a64.06 64.06 0 0 0 64-64V64a64.06 64.06 0 0 0-64-64zM256 336a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm38.2-238.4l-12.8 128a16 16 0 0 1-15.9 14.4h-19a16 16 0 0 1-15.9-14.4l-12.8-128A16.06 16.06 0 0 1 233.7 80h44.6a16 16 0 0 1 15.9 17.6z", "M256 272a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm22.3-192h-44.6a16.06 16.06 0 0 0-15.9 17.6l12.8 128a16 16 0 0 0 15.9 14.4h19a16 16 0 0 0 15.9-14.4l12.8-128A16 16 0 0 0 278.3 80z"]],
    "comment-alt-lines": [512, 512, [], "f4a6", ["M448 0H64A64.06 64.06 0 0 0 0 64v288a64.06 64.06 0 0 0 64 64h96v84a12 12 0 0 0 19.1 9.7L304 416h144a64.06 64.06 0 0 0 64-64V64a64.06 64.06 0 0 0-64-64zM288 264a8 8 0 0 1-8 8H136a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h144a8 8 0 0 1 8 8zm96-96a8 8 0 0 1-8 8H136a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h240a8 8 0 0 1 8 8z", "M280 240H136a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h144a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zm96-96H136a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h240a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8z"]],
    "comment-alt-medical": [512, 512, [], "f7f4", ["M448 0H64A64 64 0 0 0 0 64v288a64 64 0 0 0 64 64h96v84a12 12 0 0 0 19.13 9.65L304 416h144a64 64 0 0 0 64-64V64a64 64 0 0 0-64-64zm-96 232a8 8 0 0 1-8 8h-56v56a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-56h-56a8 8 0 0 1-8-8v-48a8 8 0 0 1 8-8h56v-56a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8v56h56a8 8 0 0 1 8 8z", "M160 184a8 8 0 0 1 8-8h56v-56a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8v56h56a8 8 0 0 1 8 8v48a8 8 0 0 1-8 8h-56v56a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-56h-56a8 8 0 0 1-8-8z"]],
    "comment-alt-minus": [512, 512, [], "f4a7", ["M448 0H64A64.06 64.06 0 0 0 0 64v288a64.06 64.06 0 0 0 64 64h96v84a12 12 0 0 0 19.1 9.7L304 416h144a64.06 64.06 0 0 0 64-64V64a64.06 64.06 0 0 0-64-64zm-80 216a16 16 0 0 1-16 16H160a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h192a16 16 0 0 1 16 16z", "M144 200a16 16 0 0 1 16-16h192a16 16 0 0 1 16 16v16a16 16 0 0 1-16 16H160a16 16 0 0 1-16-16z"]],
    "comment-alt-music": [512, 512, [], "f8af", ["M448 0H64A64.05 64.05 0 0 0 0 64v288a64.06 64.06 0 0 0 64 64h96v84a12 12 0 0 0 19.09 9.7L304 416h144a64.06 64.06 0 0 0 64-64V64a64.05 64.05 0 0 0-64-64zm-96 256c0 17.68-21.5 32-48 32s-48-14.32-48-32 21.5-32 48-32a69.27 69.27 0 0 1 16 1.95v-76.32l-96 37.52V288c0 17.67-21.5 32-48 32s-48-14.33-48-32 21.5-32 48-32a69.27 69.27 0 0 1 16 2V143.24A16 16 0 0 1 203.19 128l128-47.24A16 16 0 0 1 352 96z", "M176 256a69.82 69.82 0 0 1 16 2V143.25A16 16 0 0 1 203.19 128l128-47.25A16 16 0 0 1 352 96v160c0 17.67-21.5 32-48 32s-48-14.33-48-32 21.5-32 48-32a69.82 69.82 0 0 1 16 2v-76.36l-96 37.52V288c0 17.67-21.5 32-48 32s-48-14.33-48-32 21.5-32 48-32z"]],
    "comment-alt-plus": [512, 512, [], "f4a8", ["M448 0H64A64.06 64.06 0 0 0 0 64v288a64.06 64.06 0 0 0 64 64h96v84a12 12 0 0 0 19.1 9.7L304 416h144a64.06 64.06 0 0 0 64-64V64a64.06 64.06 0 0 0-64-64zm-80 216a16 16 0 0 1-16 16h-72v72a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-72h-72a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h72v-72a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v72h72a16 16 0 0 1 16 16z", "M144 200a16 16 0 0 1 16-16h72v-72a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v72h72a16 16 0 0 1 16 16v16a16 16 0 0 1-16 16h-72v72a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-72h-72a16 16 0 0 1-16-16z"]],
    "comment-alt-slash": [640, 512, [], "f4a9", ["M75.89 26.89A64 64 0 0 1 128 0h384a64.06 64.06 0 0 1 64 64v288a63.75 63.75 0 0 1-19.81 46.23zM64 352a64.06 64.06 0 0 0 64 64h96v84a12 12 0 0 0 19.1 9.7L368 416h2L64 179.5z", "M636.67 480.52l-19.6 25.31a16.06 16.06 0 0 1-22.5 2.8L6.17 53.79a15.94 15.94 0 0 1-2.8-22.41L23 6.17a16.06 16.06 0 0 1 22.5-2.8l588.3 454.84a15.86 15.86 0 0 1 2.87 22.31z"]],
    "comment-alt-smile": [512, 512, [], "f4aa", ["M448 0H64A64.06 64.06 0 0 0 0 64v288a64.06 64.06 0 0 0 64 64h96v84a12 12 0 0 0 19.1 9.7L304 416h144a64.06 64.06 0 0 0 64-64V64a64.06 64.06 0 0 0-64-64zM320 133.2a26.8 26.8 0 1 1-26.8 26.8 26.8 26.8 0 0 1 26.8-26.8zm-128 0a26.8 26.8 0 1 1-26.8 26.8 26.8 26.8 0 0 1 26.8-26.8zm164.2 140.9a132.32 132.32 0 0 1-200.4 0 16 16 0 0 1 24.3-20.7 100.23 100.23 0 0 0 151.6-.1 16.07 16.07 0 0 1 24.5 20.8z", "M320 186.8a26.8 26.8 0 1 0-26.8-26.8 26.8 26.8 0 0 0 26.8 26.8zm-128 0a26.8 26.8 0 1 0-26.8-26.8 26.8 26.8 0 0 0 26.8 26.8zm162.3 64.7a16.11 16.11 0 0 0-22.6 1.8 100.23 100.23 0 0 1-151.6.1 16 16 0 0 0-24.3 20.7 132.32 132.32 0 0 0 200.4 0 16 16 0 0 0-1.9-22.6z"]],
    "comment-alt-times": [512, 512, [], "f4ab", ["M448 0H64A64.06 64.06 0 0 0 0 64v288a64.06 64.06 0 0 0 64 64h96v84a12 12 0 0 0 19.1 9.7L304 416h144a64.06 64.06 0 0 0 64-64V64a64.06 64.06 0 0 0-64-64zM340.9 281.5l-11.3 11.3a16.06 16.06 0 0 1-22.6 0l-51-50.9-50.9 50.9a16.06 16.06 0 0 1-22.6 0l-11.3-11.3a16.06 16.06 0 0 1 0-22.6l50.9-50.9-50.9-50.9a16.06 16.06 0 0 1 0-22.6l11.3-11.3a16.06 16.06 0 0 1 22.6 0l50.9 50.9 50.9-50.9a16.06 16.06 0 0 1 22.6 0l11.3 11.3a16.06 16.06 0 0 1 0 22.6L289.9 208l51 50.9a16.06 16.06 0 0 1 0 22.6z", "M340.9 281.5l-11.3 11.3a16.06 16.06 0 0 1-22.6 0l-51-50.9-50.9 50.9a16.06 16.06 0 0 1-22.6 0l-11.3-11.3a16.06 16.06 0 0 1 0-22.6l50.9-50.9-50.9-50.9a16.06 16.06 0 0 1 0-22.6l11.3-11.3a16.06 16.06 0 0 1 22.6 0l50.9 50.9 50.9-50.9a16.06 16.06 0 0 1 22.6 0l11.3 11.3a16.06 16.06 0 0 1 0 22.6L289.9 208l51 50.9a16.06 16.06 0 0 1 0 22.6z"]],
    "comment-check": [512, 512, [], "f4ac", ["M256 32C114.6 32 0 125.1 0 240c0 49.6 21.4 95 57 130.7C44.5 421.1 2.7 466 2.2 466.5a8 8 0 0 0-1.5 8.7A7.83 7.83 0 0 0 8 480c66.3 0 116-31.8 140.6-51.4A305 305 0 0 0 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zm114.1 163.8l-131 130a11 11 0 0 1-15.6-.1l-75.7-76.3a11 11 0 0 1 .1-15.6l26-25.8a11 11 0 0 1 15.6.1l42.1 42.5 97.2-96.4a11 11 0 0 1 15.6.1l25.8 26a11 11 0 0 1-.1 15.5z", "M370.1 195.8l-131 130a11 11 0 0 1-15.6-.1l-75.7-76.3a11 11 0 0 1 .1-15.6l26-25.8a11 11 0 0 1 15.6.1l42.1 42.5 97.2-96.4a11 11 0 0 1 15.6.1l25.8 26a11 11 0 0 1-.1 15.5z"]],
    "comment-dollar": [512, 512, [], "f651", ["M256 32C114.62 32 0 125.12 0 240c0 49.56 21.41 95 57 130.74C44.46 421.05 2.7 466 2.2 466.5A8 8 0 0 0 8 480c66.26 0 116-31.75 140.6-51.38A304.66 304.66 0 0 0 256 448c141.38 0 256-93.12 256-208S397.38 32 256 32zm24 302.44V352a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-17.73a73 73 0 0 1-31.78-11.46c-6.22-4.11-6.82-13.11-1.55-18.38l17.52-17.52c3.74-3.74 9.31-4.24 14.11-2a24.52 24.52 0 0 0 10.26 2.22h32.78a8.43 8.43 0 0 0 2.32-16.53l-50.07-14.3c-22.25-6.35-40-24.71-42.91-47.67a56.27 56.27 0 0 1 49.32-63V128a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v17.73a73 73 0 0 1 31.78 11.46c6.22 4.11 6.82 13.11 1.55 18.38l-17.52 17.52c-3.74 3.74-9.31 4.24-14.11 2a24.54 24.54 0 0 0-10.26-2.22h-32.78a8.43 8.43 0 0 0-2.32 16.53l50.07 14.3c22.25 6.36 40 24.71 42.91 47.67A56.27 56.27 0 0 1 280 334.44z", "M280 334.44V352a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-17.73a73 73 0 0 1-31.78-11.46c-6.22-4.11-6.82-13.11-1.55-18.38l17.52-17.52c3.74-3.74 9.31-4.24 14.11-2a24.52 24.52 0 0 0 10.26 2.22h32.78a8.43 8.43 0 0 0 2.32-16.53l-50.07-14.3c-22.25-6.35-40-24.71-42.91-47.67a56.27 56.27 0 0 1 49.32-63V128a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v17.73a73 73 0 0 1 31.78 11.46c6.22 4.11 6.82 13.11 1.55 18.38l-17.52 17.52c-3.74 3.74-9.31 4.24-14.11 2a24.54 24.54 0 0 0-10.26-2.22h-32.78a8.43 8.43 0 0 0-2.32 16.53l50.07 14.3c22.25 6.36 40 24.71 42.91 47.67A56.27 56.27 0 0 1 280 334.44z"]],
    "comment-dots": [512, 512, [], "f4ad", ["M256 32C114.6 32 0 125.1 0 240c0 49.6 21.4 95 57 130.7C44.5 421.1 2.7 466 2.2 466.5a8 8 0 0 0-1.5 8.7A7.83 7.83 0 0 0 8 480c66.3 0 116-31.8 140.6-51.4A305 305 0 0 0 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zM128 272a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm128 0a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm128 0a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M128 208a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm128 0a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm128 0a32 32 0 1 0 32 32 32 32 0 0 0-32-32z"]],
    "comment-edit": [512, 512, [], "f4ae", ["M256 32C114.6 32 0 125.1 0 240c0 49.6 21.4 95 57 130.7C44.5 421.1 2.7 466 2.2 466.5a8 8 0 0 0-1.5 8.7A7.83 7.83 0 0 0 8 480c66.3 0 116-31.8 140.6-51.4A305 305 0 0 0 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zm-40.6 310.6l-48.2 5.4a10.17 10.17 0 0 1-11.2-11.2l5.4-48.2 96.3-96.3 54 54zm150.7-150.7l-31.8 31.8-54-54 31.8-31.8a20.22 20.22 0 0 1 28.6 0l25.4 25.4a20.22 20.22 0 0 1 0 28.6z", "M366.1 163.3l-25.4-25.4a20.22 20.22 0 0 0-28.6 0l-31.8 31.8 54 54 31.8-31.8a20.22 20.22 0 0 0 0-28.6zM161.4 288.6l-5.4 48.2a10.17 10.17 0 0 0 11.2 11.2l48.2-5.4 96.3-96.3-54-54z"]],
    "comment-exclamation": [512, 512, [], "f4af", ["M256 32C114.6 32 0 125.1 0 240c0 49.6 21.4 95 57 130.7C44.5 421.1 2.7 466 2.2 466.5a8 8 0 0 0-1.5 8.7A7.83 7.83 0 0 0 8 480c66.3 0 116-31.8 140.6-51.4A305 305 0 0 0 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zm0 336a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm38.2-238.4l-12.8 128a16 16 0 0 1-15.9 14.4h-19a16 16 0 0 1-15.9-14.4l-12.8-128a16.06 16.06 0 0 1 15.9-17.6h44.6a16 16 0 0 1 15.9 17.6z", "M256 304a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm22.3-192h-44.6a16.06 16.06 0 0 0-15.9 17.6l12.8 128a16 16 0 0 0 15.9 14.4h19a16 16 0 0 0 15.9-14.4l12.8-128a16 16 0 0 0-15.9-17.6z"]],
    "comment-lines": [512, 512, [], "f4b0", ["M256 32C114.6 32 0 125.1 0 240c0 49.6 21.4 95 57 130.7C44.5 421.1 2.7 466 2.2 466.5a8 8 0 0 0-1.5 8.7A7.83 7.83 0 0 0 8 480c66.3 0 116-31.8 140.6-51.4A305 305 0 0 0 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zm32 264a8 8 0 0 1-8 8H136a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h144a8 8 0 0 1 8 8zm96-96a8 8 0 0 1-8 8H136a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h240a8 8 0 0 1 8 8z", "M376 176H136a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h240a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zm-96 96H136a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h144a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8z"]],
    "comment-medical": [512, 512, [], "f7f5", ["M256 32C114.62 32 0 125.12 0 240c0 49.56 21.41 95 57 130.74C44.46 421.05 2.7 466 2.2 466.5A8 8 0 0 0 8 480c66.26 0 116-31.75 140.6-51.38A304.64 304.64 0 0 0 256 448c141.39 0 256-93.12 256-208S397.39 32 256 32zm96 232a8 8 0 0 1-8 8h-56v56a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-56h-56a8 8 0 0 1-8-8v-48a8 8 0 0 1 8-8h56v-56a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8v56h56a8 8 0 0 1 8 8z", "M160 216a8 8 0 0 1 8-8h56v-56a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8v56h56a8 8 0 0 1 8 8v48a8 8 0 0 1-8 8h-56v56a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-56h-56a8 8 0 0 1-8-8z"]],
    "comment-minus": [512, 512, [], "f4b1", ["M256 32C114.6 32 0 125.1 0 240c0 49.6 21.4 95 57 130.7C44.5 421.1 2.7 466 2.2 466.5a8 8 0 0 0-1.5 8.7A7.83 7.83 0 0 0 8 480c66.3 0 116-31.8 140.6-51.4A305 305 0 0 0 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zm112 216a16 16 0 0 1-16 16H160a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h192a16 16 0 0 1 16 16z", "M368 248a16 16 0 0 1-16 16H160a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h192a16 16 0 0 1 16 16z"]],
    "comment-music": [512, 512, [], "f8b0", ["M256 32C114.59 32 0 125.09 0 240c0 49.59 21.41 95 57 130.7C44.5 421.09 2.69 466 2.19 466.5a8 8 0 0 0-1.5 8.7A7.87 7.87 0 0 0 8 480c66.31 0 116-31.8 140.59-51.41A304.63 304.63 0 0 0 256 448c141.41 0 256-93.09 256-208S397.41 32 256 32zm96 256c0 17.67-21.5 32-48 32s-48-14.33-48-32 21.5-32 48-32a69.82 69.82 0 0 1 16 2v-76.36l-96 37.52V320c0 17.67-21.5 32-48 32s-48-14.33-48-32 21.5-32 48-32a69.82 69.82 0 0 1 16 2V175.25A16 16 0 0 1 203.19 160l128-47.25A16 16 0 0 1 352 128z", "M176 288a69.82 69.82 0 0 1 16 2V175.25A16 16 0 0 1 203.19 160l128-47.25A16 16 0 0 1 352 128v160c0 17.67-21.5 32-48 32s-48-14.33-48-32 21.5-32 48-32a69.82 69.82 0 0 1 16 2v-76.36l-96 37.52V320c0 17.67-21.5 32-48 32s-48-14.33-48-32 21.5-32 48-32z"]],
    "comment-plus": [512, 512, [], "f4b2", ["M256 32C114.6 32 0 125.1 0 240c0 49.6 21.4 95 57 130.7C44.5 421.1 2.7 466 2.2 466.5a8 8 0 0 0-1.5 8.7A7.83 7.83 0 0 0 8 480c66.3 0 116-31.8 140.6-51.4A305 305 0 0 0 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zm112 216a16 16 0 0 1-16 16h-72v72a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-72h-72a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h72v-72a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v72h72a16 16 0 0 1 16 16z", "M368 248a16 16 0 0 1-16 16h-72v72a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-72h-72a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h72v-72a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v72h72a16 16 0 0 1 16 16z"]],
    "comment-slash": [640, 512, [], "f4b3", ["M150.21 84.35C195.39 51.79 254.84 32 320 32c141.4 0 256 93.1 256 208 0 49.23-21 94.46-56.23 130.08zM64 240c0 49.6 21.4 95 57 130.7-12.6 50.3-54.3 95.2-54.8 95.8A8 8 0 0 0 72 480c66.3 0 116-31.8 140.6-51.4A305 305 0 0 0 320 448a312.39 312.39 0 0 0 78.4-10L72.87 186.37A171.62 171.62 0 0 0 64 240z", "M636.67 480.52l-19.6 25.31a16.06 16.06 0 0 1-22.5 2.8L6.17 53.79a15.94 15.94 0 0 1-2.8-22.41L23 6.17a16.06 16.06 0 0 1 22.5-2.8l588.3 454.84a15.86 15.86 0 0 1 2.87 22.31z"]],
    "comment-smile": [512, 512, [], "f4b4", ["M256 32C114.6 32 0 125.1 0 240c0 49.6 21.4 95 57 130.7C44.5 421.1 2.7 466 2.2 466.5a8 8 0 0 0-1.5 8.7A7.83 7.83 0 0 0 8 480c66.3 0 116-31.8 140.6-51.4A305 305 0 0 0 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zm64 133.2a26.8 26.8 0 1 1-26.8 26.8 26.8 26.8 0 0 1 26.8-26.8zm-128 0a26.8 26.8 0 1 1-26.8 26.8 26.8 26.8 0 0 1 26.8-26.8zm164.2 140.9a132.32 132.32 0 0 1-200.4 0 16 16 0 1 1 24.3-20.7 100.23 100.23 0 0 0 151.6-.1 16.07 16.07 0 0 1 24.5 20.8z", "M320 218.8a26.8 26.8 0 1 0-26.8-26.8 26.8 26.8 0 0 0 26.8 26.8zm-128 0a26.8 26.8 0 1 0-26.8-26.8 26.8 26.8 0 0 0 26.8 26.8zm162.3 64.7a16.11 16.11 0 0 0-22.6 1.8 100.23 100.23 0 0 1-151.6.1 16 16 0 1 0-24.3 20.7 132.32 132.32 0 0 0 200.4 0 16 16 0 0 0-1.9-22.6z"]],
    "comment-times": [512, 512, [], "f4b5", ["M256 32C114.6 32 0 125.1 0 240c0 49.6 21.4 95 57 130.7C44.5 421.1 2.7 466 2.2 466.5a8 8 0 0 0-1.5 8.7A7.83 7.83 0 0 0 8 480c66.3 0 116-31.8 140.6-51.4A305 305 0 0 0 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zm84.9 281.5l-11.3 11.3a16.06 16.06 0 0 1-22.6 0l-51-50.9-50.9 50.9a16.06 16.06 0 0 1-22.6 0l-11.3-11.3a16.06 16.06 0 0 1 0-22.6l50.9-50.9-50.9-50.9a16.06 16.06 0 0 1 0-22.6l11.3-11.3a16.06 16.06 0 0 1 22.6 0l50.9 50.9 50.9-50.9a16.06 16.06 0 0 1 22.6 0l11.3 11.3a16.06 16.06 0 0 1 0 22.6L289.9 240l51 50.9a16.06 16.06 0 0 1 0 22.6z", "M340.9 313.5l-11.3 11.3a16.06 16.06 0 0 1-22.6 0l-51-50.9-50.9 50.9a16.06 16.06 0 0 1-22.6 0l-11.3-11.3a16.06 16.06 0 0 1 0-22.6l50.9-50.9-50.9-50.9a16.06 16.06 0 0 1 0-22.6l11.3-11.3a16.06 16.06 0 0 1 22.6 0l50.9 50.9 50.9-50.9a16.06 16.06 0 0 1 22.6 0l11.3 11.3a16.06 16.06 0 0 1 0 22.6L289.9 240l51 50.9a16.06 16.06 0 0 1 0 22.6z"]],
    "comments": [576, 512, [], "f086", ["M208 352c-41 0-79.1-9.3-111.3-25-21.8 12.7-52.1 25-88.7 25a7.83 7.83 0 0 1-7.3-4.8 8 8 0 0 1 1.5-8.7c.3-.3 22.4-24.3 35.8-54.5-23.9-26.1-38-57.7-38-92C0 103.6 93.1 32 208 32s208 71.6 208 160-93.1 160-208 160z", "M576 320c0 34.3-14.1 66-38 92 13.4 30.3 35.5 54.2 35.8 54.5a8 8 0 0 1 1.5 8.7 7.88 7.88 0 0 1-7.3 4.8c-36.6 0-66.9-12.3-88.7-25-32.2 15.8-70.3 25-111.3 25-86.2 0-160.2-40.4-191.7-97.9A299.82 299.82 0 0 0 208 384c132.3 0 240-86.1 240-192a148.61 148.61 0 0 0-1.3-20.1C522.5 195.8 576 253.1 576 320z"]],
    "comments-alt": [576, 512, [], "f4b6", ["M352 287.9H162.3L79.5 350a9.7 9.7 0 0 1-15.5-7.8V288a64.06 64.06 0 0 1-64-64V64A64.06 64.06 0 0 1 64 0h288a64.06 64.06 0 0 1 64 64v160a63.91 63.91 0 0 1-64 63.9z", "M576 224v160a64.06 64.06 0 0 1-64 64h-32v54.3a9.7 9.7 0 0 1-15.5 7.8L381.7 448H256a64.06 64.06 0 0 1-64-64v-64h160a96.15 96.15 0 0 0 96-96v-64h64a64.06 64.06 0 0 1 64 64z"]],
    "comments-alt-dollar": [576, 512, [], "f652", ["M416 224V64a64 64 0 0 0-64-64H64A64 64 0 0 0 0 64v160a64 64 0 0 0 64 64v54.23a9.75 9.75 0 0 0 15.54 7.84L162.33 288H352a64 64 0 0 0 64-64zm-192-.12V240a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-16.29a57.26 57.26 0 0 1-31.37-11.35 8 8 0 0 1-.57-12.14L171.81 189a8.21 8.21 0 0 1 10.13-.73 24.08 24.08 0 0 0 12.82 3.73h28.11c6.5 0 11.8-5.92 11.8-13.19 0-5.95-3.61-11.19-8.77-12.73l-45-13.5c-18.59-5.58-31.58-23.42-31.58-43.39 0-24.52 19.05-44.44 42.67-45.07V48a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v16.29a57.18 57.18 0 0 1 31.37 11.35 8 8 0 0 1 .57 12.14L244.18 99a8.21 8.21 0 0 1-10.13.73A24 24 0 0 0 221.23 96h-28.11c-6.5 0-11.8 5.92-11.8 13.19 0 6 3.61 11.19 8.77 12.73l45 13.5c18.59 5.58 31.58 23.42 31.58 43.39 0 24.53-19.05 44.44-42.67 45.07z", "M512 160h-64v64a96.11 96.11 0 0 1-96 96H192v64a64 64 0 0 0 64 64h125.67l82.79 62.07a9.75 9.75 0 0 0 15.54-7.84V448h32a64 64 0 0 0 64-64V224a64 64 0 0 0-64-64zm-320 80a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-16.12c23.62-.63 42.67-20.54 42.67-45.07 0-20-13-37.81-31.58-43.39l-45-13.5c-5.16-1.54-8.77-6.78-8.77-12.73 0-7.27 5.3-13.19 11.8-13.19h28.11a24 24 0 0 1 12.82 3.72 8.21 8.21 0 0 0 10.13-.72l11.75-11.21a8 8 0 0 0-.57-12.14A57.18 57.18 0 0 0 224 64.29V48a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v16.12c-23.62.63-42.67 20.55-42.67 45.07 0 20 13 37.81 31.58 43.39l45 13.5c5.16 1.54 8.77 6.78 8.77 12.73 0 7.27-5.3 13.19-11.8 13.19h-28.12a24.08 24.08 0 0 1-12.82-3.72 8.21 8.21 0 0 0-10.13.73l-11.75 11.21a8 8 0 0 0 .57 12.14A57.26 57.26 0 0 0 192 223.71z"]],
    "comments-dollar": [576, 512, [], "f653", ["M415.5 192c0-88.37-93.12-160-208-160S-.5 103.63-.5 192c0 34.27 14.13 65.95 38 92C24.11 314.22 2 338.16 1.7 338.5A8 8 0 0 0 7.5 352c36.58 0 66.93-12.25 88.73-25 32.2 15.74 70.29 25 111.27 25 114.88 0 208-71.63 208-160zm-224 96v-16.29a57.26 57.26 0 0 1-31.37-11.35 8 8 0 0 1-.57-12.14L171.31 237a8.21 8.21 0 0 1 10.13-.73 24.08 24.08 0 0 0 12.82 3.73h28.11c6.5 0 11.8-5.92 11.8-13.19 0-5.95-3.61-11.19-8.77-12.73l-45-13.5c-18.59-5.58-31.58-23.42-31.58-43.39 0-24.52 19.05-44.44 42.67-45.07V96a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v16.29a57.18 57.18 0 0 1 31.37 11.35 8 8 0 0 1 .57 12.14L243.68 147a8.21 8.21 0 0 1-10.13.73 24 24 0 0 0-12.82-3.73h-28.11c-6.5 0-11.8 5.92-11.8 13.19 0 5.95 3.61 11.19 8.77 12.73l45 13.5c18.59 5.58 31.58 23.42 31.58 43.39 0 24.53-19.05 44.44-42.67 45.07V288a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8z", "M537.51 412c23.86-26 38-57.72 38-92 0-66.94-53.49-124.2-129.33-148.07A155.17 155.17 0 0 1 447.5 192c0 105.87-107.66 192-240 192a298.24 298.24 0 0 1-31.73-1.88C207.3 439.63 281.27 480 367.5 480c41 0 79.07-9.24 111.27-25 21.8 12.73 52.15 25 88.73 25a8 8 0 0 0 5.79-13.51c-.29-.33-22.42-24.24-35.78-54.49zm-346-124a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-16.12c23.62-.63 42.67-20.54 42.67-45.07 0-20-13-37.81-31.58-43.39l-45-13.5c-5.16-1.54-8.77-6.78-8.77-12.73 0-7.27 5.3-13.19 11.8-13.19h28.11a24 24 0 0 1 12.82 3.72 8.21 8.21 0 0 0 10.13-.73l11.75-11.21a8 8 0 0 0-.57-12.14 57.18 57.18 0 0 0-31.37-11.35V96a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v16.12c-23.62.63-42.67 20.55-42.67 45.07 0 20 13 37.81 31.58 43.39l45 13.5c5.16 1.54 8.77 6.78 8.77 12.73 0 7.27-5.3 13.19-11.8 13.19h-28.12a24.08 24.08 0 0 1-12.82-3.72 8.21 8.21 0 0 0-10.13.73l-11.75 11.21a8 8 0 0 0 .57 12.14 57.26 57.26 0 0 0 31.37 11.35z"]],
    "compact-disc": [496, 512, [], "f51f", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8ZM88,256H56C56,150.1,142.1,64,248,64V96C159.8,96,88,167.8,88,256Zm160,96a96,96,0,1,1,96-96A96,96,0,0,1,248,352Z", "M248,160a96,96,0,1,0,96,96A96,96,0,0,0,248,160Zm0,128a32,32,0,1,1,32-32A32,32,0,0,1,248,288Z"]],
    "compass": [496, 512, [], "f14e", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8ZM374.14,156.05l-66,144.35a31.94,31.94,0,0,1-15.77,15.77L148,382.17c-16.65,7.61-33.81-9.55-26.2-26.2l66-144.35a31.94,31.94,0,0,1,15.77-15.77l144.34-66c16.66-7.6,33.81,9.55,26.2,26.2Z", "M348,129.85l-144.34,66a31.94,31.94,0,0,0-15.77,15.77L121.89,356c-7.61,16.65,9.55,33.81,26.2,26.2l144.34-66a32,32,0,0,0,15.77-15.8l66-144.35c7.55-16.65-9.6-33.8-26.2-26.2ZM270.63,278.62a32,32,0,1,1,0-45.25h0A32,32,0,0,1,270.63,278.62Z"]],
    "compass-slash": [640, 512, [], "f5e9", ["M145 80.3A247.18 247.18 0 0 1 320 8c137 0 248 111 248 248a246.76 246.76 0 0 1-33.83 125.08l-141-109 53-116c7.61-16.65-9.54-33.8-26.19-26.2L287.46 190.4zm75 301.84c-16.65 7.61-33.81-9.55-26.2-26.2l25.7-56.24-139-107.41A247.45 247.45 0 0 0 72 256c0 137 111 248 248 248a246.64 246.64 0 0 0 122.1-32.29L286.77 351.65z", "M636.64 480.55L617 505.82a16 16 0 0 1-22.46 2.81L6.18 53.9a16 16 0 0 1-2.81-22.45L23 6.18a16 16 0 0 1 22.47-2.81L633.82 458.1a16 16 0 0 1 2.82 22.45z"]],
    "compress": [448, 512, [], "f066", ["M436 128h-84V44a12 12 0 0 0-12-12h-40a12 12 0 0 0-12 12v124a23.94 23.94 0 0 0 24 24h124a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zM136 320H12a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h84v84a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12V344a23.94 23.94 0 0 0-24-24z", "M436 320H312a23.94 23.94 0 0 0-24 24v124a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-84h84a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zM148 32h-40a12 12 0 0 0-12 12v84H12a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h124a23.94 23.94 0 0 0 24-24V44a12 12 0 0 0-12-12z"]],
    "compress-alt": [448, 512, [], "f422", ["M224 280v112c0 21.38-25.8 32.09-40.92 17L152 376l-99.31 99.31a16 16 0 0 1-22.63 0L4.69 449.94a16 16 0 0 1 0-22.63L104 328l-32.92-31c-15.12-15.12-4.41-41 17-41h112A24 24 0 0 1 224 280z", "M443.31 62.06a16 16 0 0 1 0 22.63L344 184l32.92 31c15.12 15.12 4.41 41-17 41H248a24 24 0 0 1-24-24V120c0-21.38 25.8-32.09 40.92-17L296 136l99.31-99.31a16 16 0 0 1 22.63 0z"]],
    "compress-arrows-alt": [512, 512, [], "f78c", ["M507.25 30.05l-25.4-25.4a16.06 16.06 0 0 0-22.6 0L360 104l-31.1-33C313.8 55.9 288 66.6 288 88v112a23.94 23.94 0 0 0 24 24h112c21.4 0 32.1-25.9 17-41l-33-31 99.3-99.3a16.06 16.06 0 0 0-.05-22.65zM200 288H88c-21.4 0-32.1 25.8-17 41l32.9 31-99.2 99.3a16.06 16.06 0 0 0 0 22.6l25.4 25.4a16.06 16.06 0 0 0 22.6 0L152 408l31.1 33c15.1 15.1 40.9 4.4 40.9-17V312a23.94 23.94 0 0 0-24-24z", "M183 71.05L152 104 52.65 4.65a16.06 16.06 0 0 0-22.6 0l-25.4 25.4a16.06 16.06 0 0 0 0 22.6L104 152l-33 31.1C55.9 198.2 66.6 224 88 224h112a23.94 23.94 0 0 0 24-24V88c0-21.35-25.95-32-41-16.95zm324.3 388.3L408 360l33-31.1c15.1-15.1 4.4-40.9-17-40.9H312a23.94 23.94 0 0 0-24 24v112c0 21.4 25.9 32.1 41 17l31-32.9 99.3 99.3a16.06 16.06 0 0 0 22.6 0l25.4-25.4a16.06 16.06 0 0 0-.05-22.65z"]],
    "compress-wide": [512, 512, [], "f326", ["M500 160h-84V76a12 12 0 0 0-12-12h-40a12 12 0 0 0-12 12v124a23.94 23.94 0 0 0 24 24h124a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zM136 288H12a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h84v84a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12V312a23.94 23.94 0 0 0-24-24z", "M500 288H376a23.94 23.94 0 0 0-24 24v124a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-84h84a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zM148 64h-40a12 12 0 0 0-12 12v84H12a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h124a23.94 23.94 0 0 0 24-24V76a12 12 0 0 0-12-12z"]],
    "computer-classic": [448, 512, [], "f8b1", ["M32 496a16 16 0 0 0 16 16h352a16 16 0 0 0 16-16v-48H32zM416 0H32A32 32 0 0 0 0 32v368a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16V32a32 32 0 0 0-32-32zM80 356a20 20 0 1 1 20-20 20 20 0 0 1-20 20zm304-12a8 8 0 0 1-8 8H232a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h144a8 8 0 0 1 8 8zm0-120a32 32 0 0 1-32 32H96a32 32 0 0 1-32-32V96a32 32 0 0 1 32-32h256a32 32 0 0 1 32 32z", "M384 224a32 32 0 0 1-32 32H96a32 32 0 0 1-32-32V96a32 32 0 0 1 32-32h256a32 32 0 0 1 32 32z"]],
    "computer-speaker": [640, 512, [], "f8b2", ["M64 320h224V96H64zM592 32H368a48 48 0 0 0-48 48v352a48 48 0 0 0 48 48h224a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zM480 96a32 32 0 1 1-32 32 32 32 0 0 1 32-32zm0 320a96 96 0 1 1 96-96 96 96 0 0 1-96 96z", "M288 416H128a32 32 0 0 0 0 64h176.41A79.24 79.24 0 0 1 288 432zM0 80v256a48 48 0 0 0 48 48h240v-64H64V96h224V80a79.24 79.24 0 0 1 16.41-48H48A48 48 0 0 0 0 80zm480 80a32 32 0 1 0-32-32 32 32 0 0 0 32 32zm0 64a96 96 0 1 0 96 96 96 96 0 0 0-96-96zm0 144a48 48 0 1 1 48-48 48 48 0 0 1-48 48z"]],
    "concierge-bell": [512, 512, [], "f562", ["M512 400v32a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h480a16 16 0 0 1 16 16zM208 112h16v18.29a224.73 224.73 0 0 1 64 0V112h16a16 16 0 0 0 16-16V80a16 16 0 0 0-16-16h-96a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16z", "M480 352H32c0-123.71 100.29-224 224-224s224 100.29 224 224z"]],
    "construction": [640, 512, [], "f85d", ["M634.66 460.17L349.5 15.92c-13.62-21.23-45.38-21.23-59 0L5.34 460.17C-9.14 482.73 7.52 512 34.85 512h570.3c27.33 0 43.99-29.27 29.51-51.83zM308 160a28 28 0 1 1-28 28 28 28 0 0 1 28-28zm-4 272a16 16 0 0 1-32 0v-32.77l-46.31-29.92-18.25 66.89A16 16 0 0 1 192 448a15.64 15.64 0 0 1-4.22-.56 16 16 0 0 1-11.24-19.64l29.75-109.11 83.07 53.67A31.92 31.92 0 0 1 304 399.23zm48 16l12-29.94A16 16 0 0 1 378.83 408h35.64l-94.8-58.34s-.08 0-.11-.07l-103.95-64a16 16 0 0 1-4.41-23.22l11.61-15.49a47.88 47.88 0 0 1 48.83-18l24.58 7.28c17.45 3.82 31.84 18.53 35.56 37.14l10.55 52.7L430 380l21.16-42.44a16 16 0 0 1 27.78-1.5L550.8 448z", "M308 216a28 28 0 1 0-28-28 28 28 0 0 0 28 28zm-18.62 156.36l-83.07-53.67-29.75 109.11a16 16 0 0 0 11.24 19.64 15.64 15.64 0 0 0 4.2.56 16 16 0 0 0 15.42-11.8l18.25-66.89L272 399.23V432a16 16 0 0 0 32 0v-32.77a31.92 31.92 0 0 0-14.62-26.87zm74.6 45.7L352 448h198.8l-71.88-112a16 16 0 0 0-27.78 1.5L430 380l-87.67-54-10.55-52.7c-3.72-18.61-18.11-33.32-35.56-37.14l-24.58-7.28a47.88 47.88 0 0 0-48.83 18l-11.61 15.53a16 16 0 0 0 4.41 23.22l104 64 .11.07 94.75 58.3h-35.64A16 16 0 0 0 364 418.06z"]],
    "container-storage": [640, 512, [], "f4b7", ["M16 96v320h608V96zm96 288H80V128h32zm112 0h-32V128h32zm112 0h-32V128h32zm112 0h-32V128h32zm112 0h-32V128h32z", "M624 416H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h608a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-384H16A16 16 0 0 0 0 48v32a16 16 0 0 0 16 16h608a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z"]],
    "conveyor-belt": [640, 512, [], "f46e", ["M128 240V16a16 16 0 0 1 16-16h352a16 16 0 0 1 16 16v224a16 16 0 0 1-16 16H144a16 16 0 0 1-16-16z", "M544 320H96a96 96 0 0 0 0 192h448a96 96 0 0 0 0-192zM128 448a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm192 0a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm192 0a32 32 0 1 1 32-32 32 32 0 0 1-32 32zM384 128V0H256v128l64-32z"]],
    "conveyor-belt-alt": [640, 512, [], "f46f", ["M304 0H80a16 16 0 0 0-16 16v224a16 16 0 0 0 16 16h224a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16zm256 64H400a16 16 0 0 0-16 16v160a16 16 0 0 0 16 16h160a16 16 0 0 0 16-16V80a16 16 0 0 0-16-16z", "M544 320H96a96 96 0 0 0 0 192h448a96 96 0 0 0 0-192zM128 448a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm192 0a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm192 0a32 32 0 1 1 32-32 32 32 0 0 1-32 32z"]],
    "cookie": [512, 512, [], "f563", ["M510.37 254.78l-12.08-76.26a132.53 132.53 0 0 0-37.16-73l-54.76-54.7a132 132 0 0 0-72.7-37L257 1.62a131.88 131.88 0 0 0-80.52 12.76l-69.14 35.21a132.35 132.35 0 0 0-57.79 57.8l-35.1 68.88a132.63 132.63 0 0 0-12.82 80.94l12.08 76.28a132.56 132.56 0 0 0 37.16 72.95l54.76 54.75a132.12 132.12 0 0 0 72.7 37.05L255 510.38a132 132 0 0 0 80.52-12.75l69.11-35.21a132.35 132.35 0 0 0 57.79-57.8l35.1-68.87a132.72 132.72 0 0 0 12.85-80.97zM176 368a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm32-160a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm160 128a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M368 272a32 32 0 1 0 32 32 32 32 0 0 0-32-32zM208 144a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm-32 160a32 32 0 1 0 32 32 32 32 0 0 0-32-32z"]],
    "cookie-bite": [512, 512, [], "f564", ["M510.52 255.81A127.93 127.93 0 0 1 384.05 128 127.92 127.92 0 0 1 256.19 1.51a132 132 0 0 0-79.72 12.81l-69.13 35.22a132.32 132.32 0 0 0-57.79 57.81l-35.1 68.88a132.64 132.64 0 0 0-12.82 81l12.08 76.27a132.56 132.56 0 0 0 37.16 73l54.77 54.76a132.1 132.1 0 0 0 72.71 37.06l76.71 12.15a131.92 131.92 0 0 0 80.53-12.76l69.13-35.21a132.32 132.32 0 0 0 57.79-57.81l35.1-68.88a132.59 132.59 0 0 0 12.91-80zM176 368a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm32-160a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm160 128a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M368 272a32 32 0 1 0 32 32 32 32 0 0 0-32-32zM208 144a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm-32 160a32 32 0 1 0 32 32 32 32 0 0 0-32-32z"]],
    "copy": [448, 512, [], "f0c5", ["M352 96V0H152a24 24 0 0 0-24 24v368a24 24 0 0 0 24 24h272a24 24 0 0 0 24-24V96z", "M96 392V96H24a24 24 0 0 0-24 24v368a24 24 0 0 0 24 24h272a24 24 0 0 0 24-24v-40H152a56.06 56.06 0 0 1-56-56zM441 73L375 7a24 24 0 0 0-17-7h-6v96h96v-6.06A24 24 0 0 0 441 73z"]],
    "copyright": [512, 512, [], "f1f9", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm117.13 346.75c-1.59 1.87-39.77 45.73-109.85 45.73-84.69 0-144.48-63.26-144.48-145.56 0-81.31 62-143.4 143.76-143.4 67 0 102 37.31 103.42 38.9a12 12 0 0 1 1.24 14.58l-22.38 34.7a12 12 0 0 1-16.59 3.57 11.79 11.79 0 0 1-1.64-1.27c-.24-.21-26.53-23.88-61.88-23.88-46.12 0-73.92 33.58-73.92 76.08 0 39.61 25.52 79.7 74.28 79.7 38.7 0 65.28-28.34 65.54-28.63a12 12 0 0 1 16.95-.73h.05a12.2 12.2 0 0 1 1.55 1.74l24.55 33.58a12 12 0 0 1-.6 14.85z", "M373.13 354.75c-1.59 1.87-39.77 45.73-109.85 45.73-84.69 0-144.48-63.26-144.48-145.56 0-81.31 62-143.4 143.76-143.4 67 0 102 37.31 103.42 38.9a12 12 0 0 1 1.24 14.58l-22.38 34.7a12 12 0 0 1-16.59 3.57 11.79 11.79 0 0 1-1.64-1.27c-.24-.21-26.53-23.88-61.88-23.88-46.12 0-73.92 33.58-73.92 76.08 0 39.61 25.52 79.7 74.28 79.7 38.7 0 65.28-28.34 65.54-28.63a12 12 0 0 1 16.95-.73h.05a12.2 12.2 0 0 1 1.55 1.74l24.55 33.58a12 12 0 0 1-.6 14.85z"]],
    "corn": [512, 512, [], "f6c7", ["M206.68 111.08a39.13 39.13 0 0 1 45.42-13 40.21 40.21 0 0 1 57.28-32.95 39.86 39.86 0 0 1 61.13-26.57A40.07 40.07 0 0 1 398 11.7a39.12 39.12 0 0 1 38.41 9.6 40.13 40.13 0 0 1 75.51 20.8v3.2a40.51 40.51 0 0 1-22.1 34.53 40.33 40.33 0 0 1 9 38.41 41.29 41.29 0 0 1-27.2 27.19 39.49 39.49 0 0 1 2.88 37.77 40.2 40.2 0 0 1-30.08 23.05 39 39 0 0 1-1.59 37.44 39.79 39.79 0 0 1-31.69 19.85 39.15 39.15 0 0 1-4.79 36.8 39.86 39.86 0 0 1-4.87 5.31c-51.23-28.5-110.09-37.49-166.48-28.13a256.52 256.52 0 0 0-28.32-166.44z", "M423.85 360c-88-76.52-221.49-72.92-305.21 10.79l-67.88 67.83L96 483.88a96 96 0 0 0 135.76 0l90.51-90.51 97.66-19.53c6.44-1.29 8.86-9.59 3.92-13.84zM201 284.85c15.42-67.76-.79-141.26-49-196.71-4.29-4.94-12.58-2.51-13.87 3.91l-19.54 97.68-90.47 90.51a96 96 0 0 0 0 135.77L96 348.12a254.29 254.29 0 0 1 105-63.27z"]],
    "couch": [640, 512, [], "f4b8", ["M96 160H64a96 96 0 0 1 96-96h320a96 96 0 0 1 96 96h-32a64.06 64.06 0 0 0-64 64v64H160v-64a64.06 64.06 0 0 0-64-64z", "M640 256a63.84 63.84 0 0 1-32 55.1V432a16 16 0 0 1-16 16h-64a16 16 0 0 1-16-16v-16H128v16a16 16 0 0 1-16 16H48a16 16 0 0 1-16-16V311.1A63.79 63.79 0 0 1 64 192h32a32 32 0 0 1 32 32v96h384v-96a32 32 0 0 1 32-32h32a64.06 64.06 0 0 1 64 64z"]],
    "cow": [640, 512, [], "f6c8", ["M97.37 114.78A40.06 40.06 0 0 0 72 152v104a64 64 0 0 1-64 64H0v-32a63.61 63.61 0 0 1 24-49.59V152a88.1 88.1 0 0 1 88-88h48a64 64 0 0 0-62.63 50.78zm236.36 186.33A79.83 79.83 0 0 0 272 272c-49.29 0-78.11 40.73-79.9 75.89-.06 1.36-.1 2.73-.1 4.11a109 109 0 0 0 32 21.87v25.68c0 8.62 6.63 16 15.23 16.43A16 16 0 0 0 256 400v-17.31c9.1 1.12 12.81 2.36 32 0v16.87c0 8.62 6.63 16 15.23 16.43A16 16 0 0 0 320 400v-26.18A108.92 108.92 0 0 0 352 352a79.7 79.7 0 0 0-18.27-50.89z", "M634 276.72l-10-13.81v-77a16 16 0 0 0-23-14.39c-10.89 5.41-19.6 13.62-26.47 23.09l-65.82-90.9A96 96 0 0 0 431 64H160a64 64 0 0 0-64 64v304a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16v-80a80 80 0 0 1 160 0v80.79A16 16 0 0 0 368 448h64a16 16 0 0 0 16-16V256l32 32v41.48A64 64 0 0 0 490.71 365L532 427a47.24 47.24 0 0 0 85.66-17l21.73-108.6a31.56 31.56 0 0 0-5.39-24.68zM377.23 167.36l-22.89 22.76A116.65 116.65 0 0 1 272.08 224h-.16a116.66 116.66 0 0 1-82.26-33.88l-22.89-22.76C151.05 151.73 164.47 128 189 128h166c24.53 0 38 23.73 22.23 39.36zM576 352a16 16 0 1 1 16-16 16 16 0 0 1-16 16z"]],
    "cowbell": [448, 512, [], "f8b3", ["M176.32 96H112.2V48a48.1 48.1 0 0 1 48.09-48h128.23a48.1 48.1 0 0 1 48.09 48v48h-64.12V64h-96.17z", "M447.49 474.35A32 32 0 0 1 415.93 512H32.07A32 32 0 0 1 .51 474.35l63.29-352A32.06 32.06 0 0 1 95.36 96h257.28a32.06 32.06 0 0 1 31.56 26.35z"]],
    "cowbell-more": [640, 512, [], "f8b4", ["M480 192a160 160 0 1 0 160 160 160 160 0 0 0-160-160zm80 168a8 8 0 0 1-8 8h-56v56a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-56h-56a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h56v-56a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v56h56a8 8 0 0 1 8 8zM336.81 96V48a48.05 48.05 0 0 0-48-48h-128a48.05 48.05 0 0 0-48 48v48h64V64h96v32z", "M552 336h-56v-56a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v56h-56a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h56v56a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-56h56a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zM394.7 180.24l-10.41-57.89A32.06 32.06 0 0 0 352.73 96H95.38a32 32 0 0 0-31.56 26.35l-63.31 352A32 32 0 0 0 32.07 512h342c-51.93-34.42-86.27-93.26-86.27-160-.02-75.21 43.64-140.27 106.9-171.76z"]],
    "credit-card": [576, 512, [], "f09d", ["M0 432a48 48 0 0 0 48 48h480a48 48 0 0 0 48-48V256H0zm192-68a12 12 0 0 1 12-12h136a12 12 0 0 1 12 12v40a12 12 0 0 1-12 12H204a12 12 0 0 1-12-12zm-128 0a12 12 0 0 1 12-12h72a12 12 0 0 1 12 12v40a12 12 0 0 1-12 12H76a12 12 0 0 1-12-12zM528 32H48A48 48 0 0 0 0 80v48h576V80a48 48 0 0 0-48-48z", "M576 256H0V128h576z"]],
    "credit-card-blank": [576, 512, [], "f389", ["M340 352H204a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h136a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm-192 0H76a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h72a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12z", "M528 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h480a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zM160 404a12 12 0 0 1-12 12H76a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h72a12 12 0 0 1 12 12zm192 0a12 12 0 0 1-12 12H204a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h136a12 12 0 0 1 12 12z"]],
    "credit-card-front": [576, 512, [], "f38a", ["M268 256h-64a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h64a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm-104 0H76a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h88a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm208 0h-64a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h64a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm128 0h-88a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h88a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12z", "M528 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h480a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zM192 268a12 12 0 0 1 12-12h64a12 12 0 0 1 12 12v40a12 12 0 0 1-12 12h-64a12 12 0 0 1-12-12zm-32 136a12 12 0 0 1-12 12H76a12 12 0 0 1-12-12v-8a12 12 0 0 1 12-12h72a12 12 0 0 1 12 12zm16-96a12 12 0 0 1-12 12H76a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h88a12 12 0 0 1 12 12zm176 96a12 12 0 0 1-12 12H204a12 12 0 0 1-12-12v-8a12 12 0 0 1 12-12h136a12 12 0 0 1 12 12zm32-96a12 12 0 0 1-12 12h-64a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h64a12 12 0 0 1 12 12zm128 0a12 12 0 0 1-12 12h-88a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h88a12 12 0 0 1 12 12zm0-140a23.94 23.94 0 0 1-24 24h-80a23.94 23.94 0 0 1-24-24v-48a23.94 23.94 0 0 1 24-24h80a23.94 23.94 0 0 1 24 24z"]],
    "cricket": [640, 512, [], "f449", ["M421.48 321.52L158 506c-8.9 6.2-20.5 7.9-30.4 3.5A216.24 216.24 0 0 1 .08 327.42c-.8-10.8 4.8-21.2 13.7-27.4l263.5-184.5-30.9 175.1z", "M496 352a80 80 0 1 0 80 80 80 80 0 0 0-80-80zM635.7 30.4l-15.2-20.2A24.14 24.14 0 0 0 587 4.32l-144 100.5a32.07 32.07 0 0 1-44.6-7.9l-21.9-31.3a16 16 0 0 0-22.3-3.9l-21.3 14.9-30.9 175.1 175.1 30.9 21.3-14.9a16 16 0 0 0 3.9-22.3l-24.5-35a32.07 32.07 0 0 1 7.9-44.6l144.1-101.9a24.14 24.14 0 0 0 5.88-33.5z"]],
    "croissant": [512, 512, [], "f7f6", ["M13.15 265.48a62.71 62.71 0 0 1-8.55-3.57 215.11 215.11 0 0 0 39.6 173.5 32 32 0 0 0 21.38 12.33 32.43 32.43 0 0 0 4.06.26 32 32 0 0 0 19.76-6.83l122.32-96c5.1-4 8.11-9.58 10.05-15.6-.21-.06-.42 0-.62-.09zM447.71 65.63a32 32 0 0 0-12.33-21.43A214.91 214.91 0 0 0 261.17 4.48c1.41 2.93 3.3 5.52 4.28 8.7l64 208c.06.2 0 .41.09.62 6-1.93 11.62-5 15.61-10l96-122.32a32.06 32.06 0 0 0 6.56-23.85z", "M509.89 180.66A215.77 215.77 0 0 0 465.7 110l-77.79 99.1 86.8 14.47a32 32 0 0 0 35.18-42.91zm-275-158.07A32 32 0 0 0 196.52 1 268.34 268.34 0 0 0 1 196.55a32 32 0 0 0 21.56 38.35l208 64a32 32 0 0 0 32-8l28.32-28.31a32 32 0 0 0 8-32zm-25.8 365.35L110 465.73a215.37 215.37 0 0 0 70.67 44.19 32 32 0 0 0 42.91-35.18z"]],
    "crop": [512, 512, [], "f125", ["M512 376v48a24 24 0 0 1-24 24h-40v-96h40a24 24 0 0 1 24 24zM416 64a32 32 0 0 1 32 32v13.25l59.31-59.31a16 16 0 0 0 0-22.63L484.69 4.69a16 16 0 0 0-22.63 0L402.75 64zm-64 141.25V160h-45.25L160 306.75V24a24 24 0 0 0-24-24H88a24 24 0 0 0-24 24v392a32 32 0 0 0 32 32h224v-96H205.25z", "M416 64H192v96h160v328a24 24 0 0 0 24 24h48a24 24 0 0 0 24-24V96a32 32 0 0 0-32-32zM0 88v48a24 24 0 0 0 24 24h40V64H24A24 24 0 0 0 0 88z"]],
    "crop-alt": [512, 512, [], "f565", ["M160 24a24 24 0 0 0-24-24H88a24 24 0 0 0-24 24v392a32 32 0 0 0 32 32h224v-96H160zm328 328h-40v96h40a24 24 0 0 0 24-24v-48a24 24 0 0 0-24-24z", "M416 64H192v96h160v328a24 24 0 0 0 24 24h48a24 24 0 0 0 24-24V96a32 32 0 0 0-32-32zM0 88v48a24 24 0 0 0 24 24h40V64H24A24 24 0 0 0 0 88z"]],
    "cross": [384, 512, [], "f654", ["M384 160v64a32 32 0 0 1-32 32h-96v224a32 32 0 0 1-32 32h-64a32 32 0 0 1-32-32V256H32a32 32 0 0 1-32-32v-64a32 32 0 0 1 32-32h96V32a32 32 0 0 1 32-32h64a32 32 0 0 1 32 32v96h96a32 32 0 0 1 32 32z", ""]],
    "crosshairs": [512, 512, [], "f05b", ["M256 40C136.71 40 40 136.71 40 256s96.71 216 216 216 216-96.71 216-216S375.29 40 256 40zm107.48 323.48A152 152 0 1 1 408 256a151 151 0 0 1-44.52 107.48z", "M256 224a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm16 128h-32a16 16 0 0 0-16 16v128a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V368a16 16 0 0 0-16-16zM144 224H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm352 0H368a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM272 0h-32a16 16 0 0 0-16 16v128a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16z"]],
    "crow": [640, 512, [], "f520", ["M447.27 487.67a12 12 0 0 1-7.17 15.38l-22.55 8.21a12 12 0 0 1-15.38-7.17l-44.65-120.17a192 192 0 0 0 48.73-7.7zM312.87 384H261l45.22 120.1a12 12 0 0 0 15.38 7.17l22.55-8.21a12 12 0 0 0 7.17-15.38zM640 96c0-35.35-43-64-96-64h-16a79.67 79.67 0 0 1 16 48v32z", "M464 0a80 80 0 0 0-80 80v21L12.09 393.57a30.22 30.22 0 0 0 31.64 51.2L165.27 384H352c106 0 192-86 192-192V80a80 80 0 0 0-80-80zm0 104a24 24 0 1 1 24-24 24 24 0 0 1-24 24z"]],
    "crown": [640, 512, [], "f521", ["M544 464v32a16 16 0 0 1-16 16H112a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h416a16 16 0 0 1 16 16z", "M640 176a48 48 0 0 1-48 48 49 49 0 0 1-7.7-.8L512 416H128L55.7 223.2a49 49 0 0 1-7.7.8 48.36 48.36 0 1 1 43.7-28.2l72.3 43.4a32 32 0 0 0 44.2-11.6L289.7 85a48 48 0 1 1 60.6 0l81.5 142.6a32 32 0 0 0 44.2 11.6l72.4-43.4A47 47 0 0 1 544 176a48 48 0 0 1 96 0z"]],
    "crutch": [512, 512, [], "f7f7", ["M281 49.91a16 16 0 0 1 0-22.63l22.69-22.6a16 16 0 0 1 22.62 0l181 181a16 16 0 0 1-.06 22.6l-22.62 22.63a16 16 0 0 1-22.63 0z", "M382.91 197l-55.1 55.12-67.89-67.92L315 129.1l-45.23-45.25L160.1 193.52a96.05 96.05 0 0 0-25.67 46.29l-27.74 120.26-102 102a16 16 0 0 0 0 22.63l22.62 22.62a16 16 0 0 0 22.63 0l102-102 120.25-27.75a95.85 95.85 0 0 0 46.29-25.65l109.68-109.68zM273.24 306.66a32 32 0 0 1-15.45 8.54l-79.3 18.32 18.3-79.3a32.23 32.23 0 0 1 8.56-15.45l9.31-9.31 67.89 67.89z"]],
    "crutches": [640, 512, [], "f7f8", ["M635.28 185.7l-181-181a16 16 0 0 0-22.62 0L409 27.3a16 16 0 0 0 0 22.63l181 181a16 16 0 0 0 22.63 0l22.62-22.63a16 16 0 0 0 .03-22.6zm-128 276.36L441 395.75a128 128 0 0 1-33.67 13L371.71 417 462 507.31a16 16 0 0 0 22.63 0l22.62-22.63a16 16 0 0 0 0-22.62zM231 49.93a16 16 0 0 0 0-22.62L208.3 4.68a16 16 0 0 0-22.62 0l-181 181a16 16 0 0 0 0 22.62l22.6 22.7a16 16 0 0 0 22.63 0l11.32-11.31 132.29 132.24c.68.68 1.57 1.06 2.27 1.71l9.69-9.69 13.22-57.32-112.22-112.24 67.89-67.89 78.75 78.75a128.23 128.23 0 0 1 12.29-14.34L297.34 139l-77.72-77.75z", "M510.84 197l-55.1 55.12-67.89-67.89 55.1-55.1-45.25-45.26L288 193.54a96.13 96.13 0 0 0-25.67 46.29l-27.71 120.26-102 102a16 16 0 0 0 0 22.63l22.62 22.62a16 16 0 0 0 22.63 0l102-102 120.25-27.75a95.85 95.85 0 0 0 46.29-25.65l109.68-109.68zM401.17 306.68a31.94 31.94 0 0 1-15.45 8.54l-79.3 18.32 18.3-79.3a32.31 32.31 0 0 1 8.56-15.45l9.31-9.31 67.89 67.89z"]],
    "cube": [512, 512, [], "f1b2", ["M480.85 85.58l-208-78a47.17 47.17 0 0 0-33.7-.1l-208 78a48.06 48.06 0 0 0-31.1 45v225.1a48 48 0 0 0 26.5 42.9l208 104a47.66 47.66 0 0 0 42.9 0l208-104a47.91 47.91 0 0 0 26.5-42.9v-225.1a47.93 47.93 0 0 0-31.1-44.9zM448 345.16l-160 80v-148.9l160-65zm.05-202.48l-192 78-192-78v-1.1l192-72 192 72z", "M448 345.16l-160 80v-148.9l160-65z"]],
    "cubes": [512, 512, [], "f1b3", ["M488.6 250.2L392 214V105.52a36 36 0 0 0-23.4-33.7l-100-37.5a35.68 35.68 0 0 0-25.3 0l-100 37.5a36 36 0 0 0-23.4 33.7V214l-96.6 36.2A36 36 0 0 0 0 283.9V394a36 36 0 0 0 19.9 32.2l100 50a35.86 35.86 0 0 0 32.2 0l103.9-52 103.9 52a35.86 35.86 0 0 0 32.2 0l100-50A36 36 0 0 0 512 394V283.9a36 36 0 0 0-23.4-33.7zM238 395.18l-85 42.5v-79.09l85-38.8zm0-112l-102 41.41L34 283.2v-.6l102-38.2 102 38.2zm-84-178.46v-.6l102-38.2 102 38.2v.6l-102 41.39zm119 73.79l85-37v73.29l-85 31.9zm205 216.67l-85 42.5v-79.09l85-38.8zm0-112l-102 41.41-102-41.39v-.6l102-38.2 102 38.2z", "M153 437.68l85-42.5v-75.39l-85 38.8zm240-79.09v79.09l85-42.5v-75.39zM273 246.7l85-31.9v-73.29l-85 37z"]],
    "curling": [640, 512, [], "f44a", ["M0 416a96 96 0 0 0 96 96h448a96 96 0 0 0 96-96v-32H0zm544-176H96a96 96 0 0 0-96 96v16h640v-16a96 96 0 0 0-96-96z", "M554.1 192H85.9c13.2-37.2 48.4-64 90.1-64h48v-16A111.94 111.94 0 0 1 336 0h128a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16c-117.7 0-176-11.4-176 48v16h176c41.7 0 76.9 26.8 90.1 64z"]],
    "cut": [448, 512, [], "f0c4", ["M96 224a96.49 96.49 0 0 0 13.36-.93L142.29 256l67.88-67.88-24.85-24.86A96 96 0 1 0 96 224zm0-128a32 32 0 1 1-32 32 32 32 0 0 1 32-32zm348.48 326.43a12 12 0 0 1 0 17 84 84 0 0 1-118.79 0L210.17 323.88 278.06 256z", "M444.48 89.57a12 12 0 0 0 0-17 84 84 0 0 0-118.79 0L109.36 288.93a95.9 95.9 0 1 0 76 59.81zM96 416a32 32 0 1 1 32-32 32 32 0 0 1-32 32z"]],
    "dagger": [384, 512, [], "f6cb", ["M128 428.84V224h128v204.84l-50.68 76a16 16 0 0 1-26.63 0z", "M290.94 192H93.06A47.92 47.92 0 1 1 48 128h112V16a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v112h112a48 48 0 1 1-45.06 64z"]],
    "database": [448, 512, [], "f1c0", ["M447 73.14v45.72C447 159.14 346.67 192 223 192S-1 159.14-1 118.86V73.14C-1 32.86 99.33 0 223 0s224 32.86 224 73.14z", "M-1 336v102.86C-1 479.14 99.33 512 223 512s224-32.86 224-73.14V336c-48.13 33.14-136.21 48.57-224 48.57S47.12 369.14-1 336zm224-111.43c-87.79 0-175.88-15.43-224-48.57v102.86C-1 319.14 99.33 352 223 352s224-32.86 224-73.14V176c-48.13 33.14-136.21 48.57-224 48.57z"]],
    "deaf": [512, 512, [], "f2a4", ["M508.48 31.8L480.2 3.51a12 12 0 0 0-17 0l-87 87a12 12 0 0 0 0 17l28.28 28.29a12 12 0 0 0 17 0l87-87a12 12 0 0 0 0-17zM169 314.74a12 12 0 0 0-17 0L3.51 463.23a12 12 0 0 0 0 17l28.29 28.25a12 12 0 0 0 17 0L197.26 360a12 12 0 0 0 0-17z", "M240 84c-97 0-176 79-176 176a28 28 0 0 0 56 0 120 120 0 0 1 240 0c0 75.16-71 70.31-72 143.62v.38a52.06 52.06 0 0 1-52 52 28 28 0 0 0 0 56 108.13 108.13 0 0 0 108-107.77c.59-34.43 72-48.23 72-144.23 0-97-78.95-176-176-176zm0 152a24 24 0 0 1 24 24 28 28 0 0 0 56 0 80 80 0 0 0-160 0 28 28 0 0 0 56 0 24 24 0 0 1 24-24z"]],
    "debug": [512, 512, [], "f7f9", ["M159.12 338.69l24.8-16.54a78.87 78.87 0 0 1-6.77-22.72l-30.88 4.41a16 16 0 0 1-4.54-31.68l34.27-4.9v-.76l98.94 98.95a76.89 76.89 0 0 1-71.68-17.73l-26.39 17.59c-.15.11-.31.21-.47.31a16 16 0 0 1-17.28-26.93zm224.72-48.42a16 16 0 0 0-13.57-18.11l-34.27-4.9V244.9l34.27-4.9a16 16 0 1 0-4.54-31.68l-30.54 4.36a79.31 79.31 0 0 0-6.85-22.85l24.54-16.36a16 16 0 1 0-17.29-26.93l-.46.31-26 17.34a79.9 79.9 0 0 0-102.64-3l139.83 139.88 19.41 2.77a16 16 0 0 0 18.11-13.57z", "M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm0 432c-101.46 0-184-82.54-184-184a182.84 182.84 0 0 1 33.38-105.37l256 256A182.86 182.86 0 0 1 256 440zm150.62-78.63l-256-256A182.84 182.84 0 0 1 256 72c101.46 0 184 82.54 184 184a182.84 182.84 0 0 1-33.38 105.37z"]],
    "deer": [512, 512, [], "f78e", ["M223.9 55.8V8a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v47.8a16 16 0 0 0 11.7 15.4l16.1 4.5 16.8-20.9a16 16 0 0 0 3.5-10V8a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v36.8a48.05 48.05 0 0 1-10.5 30l-8.3 10.3 33.8 9.5 42.6-21.3A47 47 0 0 0 412.1 57l18-27.2a7.94 7.94 0 0 1 11.1-2.2l13.3 8.9a7.94 7.94 0 0 1 2.2 11.1l-18.1 27.2a80.24 80.24 0 0 1-30.7 27.1l-12 5.59-19.19-5.33A32 32 0 0 0 339.36 119l-2.36 4.82L258.9 102a48 48 0 0 1-35-46.2z", "M488.7 133.3l-112-31.14A32 32 0 0 0 339.36 119L304 192H64a64 64 0 0 0-64 64v64l32-20v47.6l-11.9 31.8a64.08 64.08 0 0 0-2.2 38l24.9 82.5A16 16 0 0 0 58.3 512h63.8a16 16 0 0 0 15.5-19.9l-26.3-88.4 19.4-51.7H288v144a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16V288l32-64h64a32 32 0 0 0 32-32v-27.9a32.13 32.13 0 0 0-23.3-30.8zM416 176a16 16 0 1 1 16-16 16 16 0 0 1-16 16z"]],
    "deer-rudolph": [512, 512, [], "f78f", ["M191.9 55.8V8a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v47.8a16 16 0 0 0 11.7 15.4l16.1 4.5 16.8-20.9a16 16 0 0 0 3.5-10V8a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v36.8a48.05 48.05 0 0 1-10.5 30l-8.3 10.3 33.8 9.5 42.6-21.3A47 47 0 0 0 380.1 57l18-27.2a7.94 7.94 0 0 1 11.1-2.2l13.3 8.9a7.94 7.94 0 0 1 2.2 11.1l-18.1 27.2a80.24 80.24 0 0 1-30.7 27.1l-12 5.59-19.19-5.33A32 32 0 0 0 307.36 119l-2.36 4.82L226.9 102a48 48 0 0 1-35-46.2zM480 96a32 32 0 0 0-32 32c0 1 .05 2 .14 2.92l8.56 2.38a32.15 32.15 0 0 1 23 26.69h.3a32 32 0 0 0 0-64z", "M456.7 133.3l-112-31.14A32 32 0 0 0 307.36 119L272 192H64a64 64 0 0 0-64 64v64l32-20v47.6l-11.9 31.8a64.08 64.08 0 0 0-2.2 38l24.9 82.5A16 16 0 0 0 58.3 512h63.8a16 16 0 0 0 15.5-19.9l-26.3-88.4 19.4-51.7H256v144a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16V288l32-64h64a32 32 0 0 0 32-32v-27.9a32.13 32.13 0 0 0-23.3-30.8zM384 176a16 16 0 1 1 16-16 16 16 0 0 1-16 16z"]],
    "democrat": [640, 512, [], "f747", ["M544 352v144a16 16 0 0 1-16 16h-64a16 16 0 0 1-16-16v-80H288v80a16 16 0 0 1-16 16h-64a16 16 0 0 1-16-16V352z", "M637.29 256.86l-19.6-29.4A151.18 151.18 0 0 0 491.59 160H256l-81.2-81.2a58.73 58.73 0 0 0 7.5-73.9 9.87 9.87 0 0 0-15.2-1.5l-41.8 41.8L82.39 2.36A8.07 8.07 0 0 0 70 3.56 48.08 48.08 0 0 0 76.09 64c3.3 3.3 7.3 5.3 11.3 7.5-2.2 1.7-4.7 3.1-6.4 5.4l-74.6 99.3a32 32 0 0 0-3 33.5l14.3 28.6a32.05 32.05 0 0 0 28.6 17.7h31a31.94 31.94 0 0 0 22.6-9.4L138 212l54 108h352v-77.8c16.2 12.2 18.3 17.6 40.1 50.3a16 16 0 0 0 22.2 4.4l26.6-17.7a16.18 16.18 0 0 0 4.39-22.34zm-341.1-13.6l-16.5 16.1 3.9 22.7a5 5 0 0 1-7.2 5.3L256 276.66l-20.4 10.7a5 5 0 0 1-7.2-5.3l3.9-22.7-16.5-16.1a5 5 0 0 1 2.8-8.5l22.8-3.3 10.2-20.7a5 5 0 0 1 9 0l10.2 20.7 22.8 3.3a5 5 0 0 1 2.59 8.5zm112 0l-16.5 16.1 3.9 22.7a5 5 0 0 1-7.2 5.3L368 276.66l-20.4 10.7a5 5 0 0 1-7.2-5.3l3.9-22.7-16.5-16.1a5 5 0 0 1 2.8-8.5l22.8-3.3 10.2-20.7a5 5 0 0 1 9 0l10.2 20.7 22.8 3.3a5 5 0 0 1 2.59 8.5zm112 0l-16.5 16.1 3.9 22.7a5 5 0 0 1-7.2 5.3L480 276.66l-20.4 10.7a5 5 0 0 1-7.2-5.3l3.9-22.7-16.5-16.1a5 5 0 0 1 2.8-8.5l22.8-3.3 10.2-20.7a5 5 0 0 1 9 0l10.2 20.7 22.8 3.3a5 5 0 0 1 2.59 8.5z"]],
    "desktop": [576, 512, [], "f108", ["M528 0H48A48 48 0 0 0 0 48v320a48 48 0 0 0 48 48h480a48 48 0 0 0 48-48V48a48 48 0 0 0-48-48zm-16 352H64V64h448z", "M424 464h-72l-16-48h-96l-16 48h-72a24 24 0 0 0 0 48h272a24 24 0 0 0 0-48zM64 64v288h448V64z"]],
    "desktop-alt": [576, 512, [], "f390", ["M528 0H48A48 48 0 0 0 0 48v320a48 48 0 0 0 48 48h480a48 48 0 0 0 48-48V48a48 48 0 0 0-48-48zm-16 288H64V64h448z", "M64 64v224h448V64zm360 400h-72l-16-48h-96l-16 48h-72a24 24 0 0 0 0 48h272a24 24 0 0 0 0-48z"]],
    "dewpoint": [512, 512, [], "f748", ["M416 0a96 96 0 1 0 96 96 96.15 96.15 0 0 0-96-96zm0 128a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M384 333.9c0 98.4-85.9 178.1-192 178.1S0 432.3 0 333.9C0 222.69 109.1 179.79 160.1 22.09c9.8-30.1 55.1-28.8 63.8 0 51.2 158.5 160.1 200 160.1 311.81z"]],
    "dharmachakra": [512, 512, [], "f655", ["M162.5 277.84l-64.42 4a161.92 161.92 0 0 1 0-51.74l64.42 4q-.6 2.55-1.06 5.18l-.09.6c-.11.64-.22 1.29-.31 1.95l-.12.82c-.08.58-.16 1.17-.23 1.75 0 .31-.07.62-.1.93-.07.56-.12 1.12-.17 1.68l-.09 1c-.05.56-.08 1.13-.12 1.69l-.06 1c0 .6-.06 1.2-.08 1.81v7c0 .61.05 1.21.08 1.81l.06 1c0 .56.07 1.13.12 1.69l.09 1c.05.56.1 1.12.17 1.68 0 .31.07.62.1.93.07.58.15 1.17.23 1.75l.12.82c.09.66.2 1.31.31 1.95l.09.6q.47 2.55 1.06 5.1zm11.95-72.5a96.68 96.68 0 0 1 8.09-11.13 96.52 96.52 0 0 1 22.79-19.74L162.63 126A161.73 161.73 0 0 0 126 162.62zM256 96a162 162 0 0 0-25.87 2.08l4 64.42c1.7-.4 3.43-.75 5.17-1.05l.62-.11c.64-.11 1.28-.21 1.93-.3l.84-.12 1.74-.23.94-.1c.55-.07 1.11-.12 1.67-.17l1-.09c.56-.05 1.13-.08 1.69-.12l1-.06 1.81-.08h7l1.81.08 1 .06c.56 0 1.13.07 1.69.12l1 .09c.56.05 1.12.1 1.67.17l.94.1 1.74.23.84.12c.65.09 1.29.19 1.93.3l.62.11c1.74.3 3.47.65 5.17 1.05l4-64.42A162 162 0 0 0 256 96zm25.87 317.92l-4-64.42c-1.7.4-3.43.75-5.17 1.05l-.62.11c-.64.11-1.28.21-1.93.3l-.84.12-1.74.23-.93.1-1.68.17-1 .09c-.56.05-1.13.08-1.69.12l-1 .06-1.81.08h-7l-1.81-.08-1-.06c-.56 0-1.13-.07-1.69-.12l-1-.09-1.69-.17-.92-.1-1.77-.23-.8-.12c-.66-.09-1.32-.2-2-.31l-.58-.09q-2.61-.46-5.18-1.06l-4 64.42a162 162 0 0 0 51.75 0zm68.69-174.58l.09.6c.11.64.22 1.29.31 1.95l.12.82c.08.58.16 1.17.23 1.75 0 .31.07.62.1.93.07.56.12 1.12.17 1.68l.09 1c.05.56.08 1.13.12 1.69l.06 1c0 .6.06 1.2.08 1.81v7c0 .6-.05 1.2-.08 1.81l-.06 1c0 .56-.07 1.12-.12 1.68l-.09 1c-.05.56-.1 1.12-.17 1.67 0 .32-.07.63-.1.94-.07.58-.15 1.16-.23 1.73 0 .28-.07.57-.12.85-.09.64-.19 1.28-.3 1.91 0 .21-.07.43-.11.64-.14.84-.3 1.68-.47 2.52-.18.89-.37 1.77-.58 2.64l64.42 4a161.92 161.92 0 0 0 0-51.74l-64.42 4q.6 2.49 1.06 5.12zm83.53-119.2l12.78-11.27a16 16 0 0 0 .73-23.31L426.44 64.4a16 16 0 0 0-23.31.73l-11.28 12.78a224.93 224.93 0 0 1 42.24 42.23zm-228.76 217.4a96.39 96.39 0 0 1-30.88-30.88L126 349.37a161.82 161.82 0 0 0 16.82 19.77 163.52 163.52 0 0 0 19.8 16.86l42.71-48.41zm132.23-30.89a96.64 96.64 0 0 1-19.75 22.8 94.54 94.54 0 0 1-11.14 8.1L349.38 386a163.52 163.52 0 0 0 19.76-16.82A161.82 161.82 0 0 0 386 349.37zM32 256a226.63 226.63 0 0 1 2-29.88l-17-1.06A16 16 0 0 0 0 241v30a16 16 0 0 0 17 16l17-1.06A226.63 226.63 0 0 1 32 256zm414.88 147.12l-12.78-11.28a225 225 0 0 1-42.24 42.25l11.27 12.78a16 16 0 0 0 23.31.73l21.17-21.17a16 16 0 0 0-.73-23.31zM495 225.06l-17 1.06a225.32 225.32 0 0 1 0 59.76l17 1.06a16 16 0 0 0 17-16V241a16 16 0 0 0-17-15.94zM285.88 478a225.32 225.32 0 0 1-59.76 0l-1.06 17a16 16 0 0 0 16 17H271a16 16 0 0 0 16-17zm63.49-352l-42.71 48.41a96.33 96.33 0 0 1 22.79 19.75 95.58 95.58 0 0 1 8.1 11.13L386 162.62A161.73 161.73 0 0 0 349.37 126zM226.12 34a225.32 225.32 0 0 1 59.76 0l1.06-17A16 16 0 0 0 271 0h-30a16 16 0 0 0-16 17zm-161 74.88l12.78 11.27a225.58 225.58 0 0 1 42.25-42.25l-11.27-12.77a16 16 0 0 0-23.31-.73L64.4 85.56a16 16 0 0 0 .73 23.31zm12.77 283l-12.76 11.24a16 16 0 0 0-.73 23.31l21.17 21.17a16 16 0 0 0 23.31-.73l11.27-12.77a225.39 225.39 0 0 1-42.25-42.25z", "M256 32C132.29 32 32 132.29 32 256s100.29 224 224 224 224-100.29 224-224S379.71 32 256 32zm113.14 337.14A160 160 0 1 1 416 256a159 159 0 0 1-46.86 113.14zM256 160a96 96 0 1 0 96 96 96 96 0 0 0-96-96zm0 128a32 32 0 1 1 32-32 32 32 0 0 1-32 32z"]],
    "diagnoses": [640, 512, [], "f470", ["M320 176a88 88 0 1 0-88-88 88.13 88.13 0 0 0 88 88zm268 116.3c-11.9-7.1-29.7-17-51.1-27.4-28.1 46.1-99.4 17.8-87.7-35.1C409.3 217.2 365.1 208 320 208c-57 0-112.9 14.5-160 32.2-.2 40.2-47.6 63.3-79.2 36-11.2 6-21.3 11.6-28.7 16-17.6 10.5-18.8 31.8-10 45.1L59.8 364a31.88 31.88 0 0 0 42.9 9.8A599.33 599.33 0 0 1 208 325.2V416h224v-90.7a591.93 591.93 0 0 1 105.3 48.6 32.08 32.08 0 0 0 42.9-9.8l17.8-26.7c8.8-13.2 7.6-34.6-10-45.1zM272 296a24 24 0 1 1 24-24 23.94 23.94 0 0 1-24 24zm96 64a24 24 0 1 1 24-24 23.94 23.94 0 0 1-24 24z", "M112 256a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm384 0a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm128 192H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h608a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "diamond": [448, 512, [], "f219", ["M442.14 240.34l-200-232a24 24 0 0 0-36.36 0l-200 232a23.84 23.84 0 0 0 0 31.3l200 232a24 24 0 0 0 36.36 0l200-232a23.84 23.84 0 0 0 0-31.3zm-94.05 26l-111.9 128.15a16.23 16.23 0 0 1-24.38 0L99.91 266.38a15.74 15.74 0 0 1 0-20.76l111.9-128.11a16.23 16.23 0 0 1 24.38 0l111.9 128.11a15.74 15.74 0 0 1 0 20.76z", "M348.09 245.62a15.74 15.74 0 0 1 0 20.76l-111.9 128.11a16.23 16.23 0 0 1-24.38 0L99.91 266.38a15.74 15.74 0 0 1 0-20.76l111.9-128.11a16.23 16.23 0 0 1 24.38 0z"]],
    "dice": [640, 512, [], "f522", ["M433.63 189.3L258.7 14.37a49.07 49.07 0 0 0-69.39 0L14.37 189.3a49.07 49.07 0 0 0 0 69.39L189.3 433.63a49.07 49.07 0 0 0 69.39 0L433.63 258.7a49.08 49.08 0 0 0 0-69.4zM96 248a24 24 0 1 1 24-24 24 24 0 0 1-24 24zm128 128a24 24 0 1 1 24-24 24 24 0 0 1-24 24zm0-128a24 24 0 1 1 24-24 24 24 0 0 1-24 24zm0-128a24 24 0 1 1 24-24 24 24 0 0 1-24 24zm128 128a24 24 0 1 1 24-24 24 24 0 0 1-24 24z", "M592 192H473.26a81.07 81.07 0 0 1-17 89.32L320 417.58V464a48 48 0 0 0 48 48h224a48 48 0 0 0 48-48V240a48 48 0 0 0-48-48zM480 376a24 24 0 1 1 24-24 24 24 0 0 1-24 24zM96 200a24 24 0 1 0 24 24 24 24 0 0 0-24-24zm256 48a24 24 0 1 0-24-24 24 24 0 0 0 24 24zm-128 80a24 24 0 1 0 24 24 24 24 0 0 0-24-24zm0-256a24 24 0 1 0 24 24 24 24 0 0 0-24-24zm0 128a24 24 0 1 0 24 24 24 24 0 0 0-24-24z"]],
    "dice-d10": [512, 512, [], "f6cd", ["M509 240.86L317.19 7c-6-7.37-17.39-.66-14.46 8.55L370.52 228l130.38 27.29c7.89 1.71 13.32-8.04 8.1-14.43zM194.8 7L3 240.86c-5.24 6.39.2 16.08 8.08 14.42L141.47 228l67.78-212.5c2.95-9.17-8.4-15.89-14.45-8.5zM248 6l-73.4 230.12 81.4 56.74 81.43-56.71L264 6a8.36 8.36 0 0 0-16 0z", "M505.19 292.27l-144.06-30.11-88.2 61.44v179.54c0 7.59 8.55 11.65 14 6.66l222.15-202.2c5.31-4.82 3-13.89-3.89-15.33zm-498.38 0c-6.89 1.44-9.2 10.51-3.9 15.33l222.14 202.19c5.48 5 14 .93 14-6.67V323.6l-88.2-61.44z"]],
    "dice-d12": [512, 512, [], "f6ce", ["M7.54 176.92l123.62 123.62L240 246.11V139.24L59 74.07zM453 74.07l-181 65.17v106.87l108.84 54.42 123.62-123.62zM333.51 6.76A63.87 63.87 0 0 0 304.89 0H207.1a63.91 63.91 0 0 0-28.62 6.76L89.72 51.14 256 111l166.28-59.86z", "M256 273.89l-108.59 54.29L206.23 512h99.53l58.82-183.82zM0 214.62v90.27a63.87 63.87 0 0 0 6.76 28.62l47.7 95.4a63.92 63.92 0 0 0 28.62 28.62L169 500.47l-55-171.91zm398.05 114L343 500.48l85.88-42.94a64 64 0 0 0 28.62-28.62l47.7-95.4a64.07 64.07 0 0 0 6.8-28.62v-90.27z"]],
    "dice-d20": [480, 512, [], "f6cf", ["M240 0a15.88 15.88 0 0 0-13.63 7.62L130.79 176h218.42L253.63 7.62A15.88 15.88 0 0 0 240 0zm-71.38 11.74L17.81 110.35a4 4 0 0 0 .13 6.78l81.53 48.69L179.4 22.88c4.34-7.06-3.59-15.25-10.78-11.14zm293.57 98.6l-150.81-98.6c-7.19-4.11-15.12 4.08-10.78 11.14l79.93 142.94 81.53-48.7a4 4 0 0 0 .13-6.78z", "M106.75 215.06L1.2 371a8 8 0 0 0 5.93 12.14l208.26 22.07zM7.41 315.43L82.7 193.08l-76.64-46A4 4 0 0 0 0 150.53v162.81a4 4 0 0 0 7.41 2.09zM18.25 423.6l194.4 87.66A8 8 0 0 0 224 504v-65.67L20.45 416a4 4 0 0 0-2.2 7.6zM139.57 208L240 383.75 340.43 208zM480 313.34V150.53a4 4 0 0 0-6.06-3.43l-76.64 46 75.29 122.35a4 4 0 0 0 7.41-2.11zM478.81 371L373.25 215.06l-108.63 190.1 208.26-22.07a8 8 0 0 0 5.93-12.09zm-19.26 45L256 438.32V504a8 8 0 0 0 11.35 7.26l194.4-87.66a4 4 0 0 0-2.2-7.6z"]],
    "dice-d4": [512, 512, [], "f6d0", ["M239.81 8.53v494.94c0 7.15-7.87 11.11-13.17 6.64L3 321.3a8.82 8.82 0 0 1-1.35-11.82L225.28 3.34C230-3.1 239.8.4 239.81 8.53z", "M272.2 503.47V8.53c0-8.13 9.8-11.63 14.52-5.19l223.6 306.14A8.79 8.79 0 0 1 509 321.3L285.37 510.11c-5.3 4.47-13.17.51-13.17-6.64z"]],
    "dice-d6": [448, 512, [], "f6d1", ["M25.87 124.42a8.54 8.54 0 0 1-.06-14.42l166-100.88a61.72 61.72 0 0 1 64.43 0L422.19 110a8.54 8.54 0 0 1-.05 14.47L224 242.55z", "M0 161.83v197.7c0 23.77 12.11 45.74 31.79 57.7L184 509.71c10.67 6.48 24.05-1.54 24.05-14.44V271.46L12 154.58c-5.36-3.17-12 .85-12 7.25zm436-7.25L240 271.46v223.82c0 12.89 13.39 20.92 24.05 14.43l152.16-92.48c19.68-12 31.79-33.94 31.79-57.7v-197.7c0-6.41-6.64-10.42-12-7.25z"]],
    "dice-d8": [512, 512, [], "f6d2", ["M225.53 2.52L2.36 233.83a8.45 8.45 0 0 0 3.1 13.77l234.13 85.06V8.39a8.19 8.19 0 0 0-14.06-5.87zm284.11 231.31L286.47 2.52a8.19 8.19 0 0 0-14.06 5.88v324.27l234.13-85.06a8.46 8.46 0 0 0 3.1-13.78z", "M469.87 296.61l-197.46 71.68V503.6a8.19 8.19 0 0 0 14.06 5.88l192-199.1c6.12-6.38-.39-16.75-8.6-13.77zM33.53 310.38l192 199.1a8.19 8.19 0 0 0 14.06-5.88V368.29L42.13 296.61c-8.21-2.98-14.72 7.39-8.6 13.77z"]],
    "dice-five": [448, 512, [], "f523", ["M384 32H64A64 64 0 0 0 0 96v320a64 64 0 0 0 64 64h320a64 64 0 0 0 64-64V96a64 64 0 0 0-64-64zM128 384a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm0-192a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm96 96a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm96 96a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm0-192a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M320 192a32 32 0 1 0-32-32 32 32 0 0 0 32 32zm0 128a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm-96-96a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm-96-96a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm0 192a32 32 0 1 0 32 32 32 32 0 0 0-32-32z"]],
    "dice-four": [448, 512, [], "f524", ["M384 32H64A64 64 0 0 0 0 96v320a64 64 0 0 0 64 64h320a64 64 0 0 0 64-64V96a64 64 0 0 0-64-64zM128 384a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm0-192a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm192 192a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm0-192a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M128 320a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm0-192a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm192 192a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm0-128a32 32 0 1 0-32-32 32 32 0 0 0 32 32z"]],
    "dice-one": [448, 512, [], "f525", ["M384 32H64A64 64 0 0 0 0 96v320a64 64 0 0 0 64 64h320a64 64 0 0 0 64-64V96a64 64 0 0 0-64-64zM224 288a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M256 256a32 32 0 1 1-32-32 32 32 0 0 1 32 32z"]],
    "dice-six": [448, 512, [], "f526", ["M384 32H64A64 64 0 0 0 0 96v320a64 64 0 0 0 64 64h320a64 64 0 0 0 64-64V96a64 64 0 0 0-64-64zM128 384a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm0-96a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm0-96a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm192 192a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm0-96a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm0-96a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M320 192a32 32 0 1 0-32-32 32 32 0 0 0 32 32zm0 32a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm0 96a32 32 0 1 0 32 32 32 32 0 0 0-32-32zM128 128a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm0 96a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm0 96a32 32 0 1 0 32 32 32 32 0 0 0-32-32z"]],
    "dice-three": [448, 512, [], "f527", ["M384 32H64A64 64 0 0 0 0 96v320a64 64 0 0 0 64 64h320a64 64 0 0 0 64-64V96a64 64 0 0 0-64-64zM128 192a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm96 96a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm96 96a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M320 320a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm-96-96a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm-96-96a32 32 0 1 0 32 32 32 32 0 0 0-32-32z"]],
    "dice-two": [448, 512, [], "f528", ["M384 32H64A64 64 0 0 0 0 96v320a64 64 0 0 0 64 64h320a64 64 0 0 0 64-64V96a64 64 0 0 0-64-64zM128 192a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm192 192a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M128 128a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm192 192a32 32 0 1 0 32 32 32 32 0 0 0-32-32z"]],
    "digging": [576, 512, [], "f85e", ["M311.07 416a32 32 0 0 0-30.36 21.88L256 512h320L474.07 305.68c-11.29-22.59-43.07-23.81-56.07-2.15L352 416z", "M272 96a48 48 0 1 0-48-48 48 48 0 0 0 48 48zm-62.24 261.36q-38.7-25.78-79.55-48.09l-71.56-39-57.42 201a32 32 0 1 0 61.56 17.59l36.6-128.16L160 401.11V480a32 32 0 0 0 64 0v-96a32 32 0 0 0-14.24-26.64zm176.39.46l-65.3-35.62-24-121.2a129.78 129.78 0 0 0-69.72-91.2c-1-.5-2.11-.66-3.11-1.13a31 31 0 0 0-7.22-2.67c-15.34-6.1-31.56-10-48.07-10H96a32 32 0 0 0-24.07 10.92l-56 64a25.89 25.89 0 0 0-2.3 3.16c-8.83 14.1-3 32.86 11.62 40.85l336.6 184.3zM105.9 205l-23.49-12.85L110.54 160h34.33zm93.74 51.13l34.73-41.23 13.5 67.54z"]],
    "digital-tachograph": [640, 512, [], "f566", ["M296 336H72a8 8 0 0 0-8 8v8a8 8 0 0 0 8 8h224a8 8 0 0 0 8-8v-8a8 8 0 0 0-8-8zm272 0H344a8 8 0 0 0-8 8v8a8 8 0 0 0 8 8h224a8 8 0 0 0 8-8v-8a8 8 0 0 0-8-8zM288 160H80a16 16 0 0 0-16 16v48a16 16 0 0 0 16 16h208a16 16 0 0 0 16-16v-48a16 16 0 0 0-16-16z", "M608 96H32a32 32 0 0 0-32 32v256a32 32 0 0 0 32 32h576a32 32 0 0 0 32-32V128a32 32 0 0 0-32-32zM304 352a8 8 0 0 1-8 8H72a8 8 0 0 1-8-8v-8a8 8 0 0 1 8-8h224a8 8 0 0 1 8 8zM72 288v-16a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8H80a8 8 0 0 1-8-8zm64 0v-16a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8zm64 0v-16a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8zm64 0v-16a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8zm40-64a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16v-48a16 16 0 0 1 16-16h208a16 16 0 0 1 16 16zm272 128a8 8 0 0 1-8 8H344a8 8 0 0 1-8-8v-8a8 8 0 0 1 8-8h224a8 8 0 0 1 8 8z"]],
    "diploma": [640, 512, [], "f5ea", ["M608.64 63.56c-6.78-11.5-22-17.88-37-14.77l-127 42.78c-9.44 3.18-19 5.93-28.65 8.37v144.12L467 332l104.6 35.24c15 3.1 30.25-3.27 37-14.77 41.85-70.96 41.85-217.97.04-288.91zM68.39 48.78c-15-3.1-30.25 3.27-37 14.77-41.81 70.94-41.81 218 0 288.89 6.78 11.5 22 17.88 37 14.77L173 332l51-87.91V99.94c-9.64-2.45-19.21-5.19-28.65-8.37z", "M384 112v140.67l95.16 164A11.13 11.13 0 0 1 468.43 432h-36.64l-25.2 28.52a11.13 11.13 0 0 1-18.39-3.45L320 336l-68.19 121.07a11.13 11.13 0 0 1-18.39 3.45L208.21 432h-36.64a11.13 11.13 0 0 1-10.73-15.32l95.16-164V112z"]],
    "directions": [512, 512, [], "f5eb", ["M502.61 233.32L278.68 9.39a32.08 32.08 0 0 0-45.36 0L9.39 233.32a32.08 32.08 0 0 0 0 45.36L233.32 502.6a32.06 32.06 0 0 0 45.35 0l223.94-223.92a32.08 32.08 0 0 0 0-45.36zm-101 12.56l-84.21 77.73a8 8 0 0 1-13.4-5.88V264h-96v64a8 8 0 0 1-8 8h-32a8 8 0 0 1-8-8v-80a32 32 0 0 1 32-32h112v-53.73a8 8 0 0 1 13.43-5.88l84.21 77.73a8 8 0 0 1 .44 11.3c-.14.16-.29.31-.45.46z", "M401.63 245.88l-84.21 77.73a8 8 0 0 1-13.42-5.88V264h-96v64a8 8 0 0 1-8 8h-32a8 8 0 0 1-8-8v-80a32 32 0 0 1 32-32h112v-53.73a8 8 0 0 1 13.43-5.88l84.21 77.73a8 8 0 0 1 .44 11.3c-.14.16-.29.31-.45.46z"]],
    "disc-drive": [512, 512, [], "f8b5", ["M256 96a160 160 0 1 0 160 160A160 160 0 0 0 256 96zm0 192a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M496 416h-16V96a64 64 0 0 0-64-64H96a64 64 0 0 0-64 64v320H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h480a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-240 0a160 160 0 1 1 160-160 160 160 0 0 1-160 160z"]],
    "disease": [512, 512, [], "f7fa", ["M472.27 196l-67.06-23c-19.28-6.6-33.54-20.92-38.14-38.31l-16-60.45c-11.58-43.77-76.57-57.13-110-22.62L195 99.29c-13.26 13.71-33.54 20.93-54.2 19.31L68.88 113c-52-4.07-86.93 44.89-59 82.84l38.54 52.42c11.08 15.07 12.82 33.86 4.64 50.24l-28.43 57C4 396.72 47.44 440.34 98.09 429.28l70-15.28c20.11-4.39 41.45 0 57.07 11.73l54.32 40.83c39.32 29.56 101 7.57 104.45-37.22l4.7-61.86c1.35-17.8 12.8-33.87 30.63-43l62-31.74c44.84-22.96 39.55-80.17-8.99-96.74zM160 256.05a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm128 96a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm16-128a16 16 0 1 1 16-16 16 16 0 0 1-16 16z", "M304 224.05a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm-16 64a32 32 0 1 0 32 32 32 32 0 0 0-32-32z"]],
    "divide": [448, 512, [], "f529", ["M224 160a64 64 0 1 0-64-64 64 64 0 0 0 64 64zm0 192a64 64 0 1 0 64 64 64 64 0 0 0-64-64z", "M0 240a32 32 0 0 1 32-32h384a32 32 0 0 1 32 32v32a32 32 0 0 1-32 32H32a32 32 0 0 1-32-32z"]],
    "dizzy": [496, 512, [], "f567", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8ZM152,214.6l-28.7,28.7c-14.8,14.8-37.8-7.5-22.6-22.6L129.4,192l-28.7-28.7c-15-15,7.7-37.6,22.6-22.6L152,169.4l28.7-28.7c15-15,37.6,7.7,22.6,22.6L174.6,192l28.7,28.7c15.2,15.2-7.9,37.4-22.6,22.6ZM248,416a64,64,0,1,1,64-64A64,64,0,0,1,248,416ZM372.7,243.3,344,214.6l-28.7,28.7c-14.8,14.8-37.8-7.5-22.6-22.6L321.4,192l-28.7-28.7c-15-15,7.7-37.6,22.6-22.6L344,169.4l28.7-28.7c15-15,37.6,7.7,22.6,22.6L366.6,192l28.7,28.7C410.5,235.9,387.4,258.1,372.7,243.3Z", "M395.3,220.7,366.6,192l28.7-28.7c15-14.9-7.6-37.6-22.6-22.6L344,169.4l-28.7-28.7c-14.9-15-37.6,7.6-22.6,22.6L321.4,192l-28.7,28.7c-15.2,15.1,7.8,37.4,22.6,22.6L344,214.6l28.7,28.7c14.7,14.8,37.8-7.4,22.6-22.6ZM174.6,192l28.7-28.7c15-14.9-7.6-37.6-22.6-22.6L152,169.4l-28.7-28.7c-14.9-15-37.6,7.6-22.6,22.6L129.4,192l-28.7,28.7c-15.2,15.1,7.8,37.4,22.6,22.6L152,214.6l28.7,28.7c14.7,14.8,37.8-7.4,22.6-22.6Z"]],
    "dna": [448, 512, [], "f471", ["M222.18 269.08a480.54 480.54 0 0 0 45.22-25.63Q253 235 237.72 227.37c-39.79-19.83-73.72-44.13-100.82-72.23A284.35 284.35 0 0 1 92.86 96H416V31H67.55C66 24.32 65 18.49 64.27 13.75A16 16 0 0 0 48.32 0L16.05.14A16 16 0 0 0 .12 18.1c2.34 18.82 8.65 50.68 25.65 87.38a342.64 342.64 0 0 0 63 92c30.64 32.23 68.34 60.09 112.14 82.91q10.18-5.76 21.27-11.31zM447.87 494c-2.35-18.84-8.71-50.72-25.82-87.43a342.8 342.8 0 0 0-63.45-92.12 383.16 383.16 0 0 0-30-28.12 515.71 515.71 0 0 1-58.47 35.61q8.53 6.35 16.51 13.06H96v48h236.71A272.08 272.08 0 0 1 362 430.47a238.2 238.2 0 0 1 21.27 67.77A16.11 16.11 0 0 0 399.2 512h32.68a16 16 0 0 0 15.99-18z", "M447.88 18c-2.35 18.84-8.68 50.72-25.72 87.44A342.76 342.76 0 0 1 359 197.51c-32.61 34.23-73.18 63.54-120.59 87.11C160.43 323.39 117.15 373 93.11 416h261.35q4 7.14 7.52 14.47A247.24 247.24 0 0 1 379.71 480H67.87c-1.69 7.1-2.79 13.25-3.49 18.21A16.06 16.06 0 0 1 48.45 512H16.09a16 16 0 0 1-16-18c2.35-18.84 8.68-50.72 25.72-87.44A342.76 342.76 0 0 1 89 314.49c32.61-34.23 73.18-63.54 120.59-87.11 32.21-16 58.49-33.89 79.95-52.38h-131.6q-11.12-9.58-21-19.86A295 295 0 0 1 113 127h221.7c35.39-47.16 45.84-91.55 48.92-113.21A16.06 16.06 0 0 1 399.55 0h32.36a16 16 0 0 1 15.97 18z"]],
    "do-not-enter": [496, 512, [], "f5ec", ["M56,288V224a16,16,0,0,1,16-16H424a16,16,0,0,1,16,16v64a16,16,0,0,1-16,16H72A16,16,0,0,1,56,288Z", "M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8ZM424,304H72a16,16,0,0,1-16-16V224a16,16,0,0,1,16-16H424a16,16,0,0,1,16,16v64A16,16,0,0,1,424,304Z"]],
    "dog": [512, 512, [], "f6d3", ["M416 278l-149-54 21-26 128 46z", "M96 224a32 32 0 0 1-32-32 32 32 0 0 0-64 0c0 41.66 26.83 76.85 64 90.1V496a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16V384h160v112a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16V277.55L266.05 224zM496 96h-64l-7.16-14.31A32 32 0 0 0 396.22 64H342.6l-27.28-27.28C305.23 26.64 288 33.78 288 48v149.87l128 45.71V208h32a64 64 0 0 0 64-64v-32a16 16 0 0 0-16-16zm-112 48a16 16 0 1 1 16-16 16 16 0 0 1-16 16z"]],
    "dog-leashed": [512, 512, [], "f6d4", ["M416 244v34l-128-46.39V384h-48V224L6.17 41.25a16 16 0 0 1-2.8-22.45l9.82-12.62a16 16 0 0 1 22.45-2.81L288 192z", "M64 192a32 32 0 0 0-64 0c0 41.66 26.83 76.85 64 90.1V496a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16V384h80V224H96a32 32 0 0 1-32-32zm224 192h32v112a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16V277.55l-128-45.71zM496 96h-64l-7.16-14.31A32 32 0 0 0 396.22 64H342.6l-27.28-27.28C305.23 26.64 288 33.78 288 48v144l128 51.58V208h32a64 64 0 0 0 64-64v-32a16 16 0 0 0-16-16zm-112 48a16 16 0 1 1 16-16 16 16 0 0 1-16 16z"]],
    "dollar-sign": [288, 512, [], "f155", ["M176,64H112V16A16,16,0,0,1,128,0h32a16,16,0,0,1,16,16ZM112,448v48a16,16,0,0,0,16,16h32a16,16,0,0,0,16-16V448Z", "M281.72,375.1c-15.4,44.1-59.11,71.8-105.72,72.7l-64,.2a141.39,141.39,0,0,1-86.51-30c-7.9-6.1-8.9-17.6-1.8-24.5l34.81-34a15.6,15.6,0,0,1,19.5-2A61,61,0,0,0,112.19,368H178.5a29.49,29.49,0,0,0,8.3-57.8l-102.52-30c-44.4-13-79.61-50.5-83.81-96.6A109.57,109.57,0,0,1,99.55,64.46h0c3.3-.3,6.61-.46,9.92-.46H176a141.44,141.44,0,0,1,86.52,30c7.9,6.1,8.9,17.6,1.8,24.5l-34.81,34a15.6,15.6,0,0,1-19.5,2A61.1,61.1,0,0,0,175.8,144H109.49a29.49,29.49,0,0,0-8.3,57.8l108,31.6C267.12,250.3,303.23,313.5,281.72,375.1Z"]],
    "dolly": [576, 512, [], "f472", ["M515.3 228.4L454.9 47.2a16 16 0 0 0-20.2-10.1l-183.4 61a16 16 0 0 0-10.1 20.2l53 159.4a145.7 145.7 0 0 1 49.5 24.7l161.5-53.8a16 16 0 0 0 10.1-20.2zM256 320a96 96 0 1 0 96 96 96 96 0 0 0-96-96zm0 128a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M575.2 326.4L565 296a16 16 0 0 0-20.2-10.1l-181.38 60.49a127.12 127.12 0 0 1 20.27 60.76L565 346.6a16 16 0 0 0 10.2-20.2zM128 0H16A16 16 0 0 0 0 16v32a16 16 0 0 0 16 16h88.9l81.49 244.57a127.23 127.23 0 0 1 60.81-20.26L158.4 21.9A32 32 0 0 0 128 0zm245.6 57.5l-60.7 20.1L346 177l60.7-20.1z"]],
    "dolly-empty": [576, 512, [], "f473", ["M256 320a96 96 0 1 0 96 96 96 96 0 0 0-96-96zm0 128a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M128 0H16A16 16 0 0 0 0 16v32a16 16 0 0 0 16 16h88.9l81.49 244.57a127.23 127.23 0 0 1 60.81-20.26L158.4 21.9A32 32 0 0 0 128 0zm447.2 326.4L565 296a16 16 0 0 0-20.2-10.1l-181.38 60.49a127.12 127.12 0 0 1 20.27 60.76L565 346.6a16 16 0 0 0 10.2-20.2z"]],
    "dolly-flatbed": [640, 512, [], "f474", ["M450.74 448a48 48 0 1 0 90.52 0zm-288 0a48 48 0 1 0 90.52 0zM592 32H448v128l-48-32-48 32V32H208a16 16 0 0 0-16 16v256a16 16 0 0 0 16 16h384a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z", "M448 160V32h-96v128l48-32zm176 224H128V16a16 16 0 0 0-16-16H16A16 16 0 0 0 0 16v32a16 16 0 0 0 16 16h48v368a16 16 0 0 0 16 16h544a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "dolly-flatbed-alt": [640, 512, [], "f475", ["M432 160h96a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-96a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16zM368 32H208a16 16 0 0 0-16 16v256a16 16 0 0 0 16 16h160a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm224 160H432a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h160a16 16 0 0 0 16-16v-96a16 16 0 0 0-16-16zM450.74 448a48 48 0 1 0 90.52 0zm-288 0a48 48 0 1 0 90.52 0z", "M640 400v32a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16V64H16A16 16 0 0 1 0 48V16A16 16 0 0 1 16 0h96a16 16 0 0 1 16 16v368h496a16 16 0 0 1 16 16z"]],
    "dolly-flatbed-empty": [640, 512, [], "f476", ["M162.74 448a48 48 0 1 0 90.52 0zm378.52 0h-90.52a48 48 0 1 0 90.52 0z", "M640 400v32a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16V64H16A16 16 0 0 1 0 48V16A16 16 0 0 1 16 0h96a16 16 0 0 1 16 16v368h496a16 16 0 0 1 16 16z"]],
    "donate": [512, 512, [], "f4b9", ["M256 416c114.9 0 208-93.1 208-208S370.9 0 256 0 48 93.1 48 208s93.1 208 208 208zM233.8 97.4V80.6A16.56 16.56 0 0 1 250.4 64h11.1a16.56 16.56 0 0 1 16.6 16.6v17a78.84 78.84 0 0 1 43 15.4 11.21 11.21 0 0 1 1.2 17.1L306 145.6c-3.8 3.7-9.5 3.8-14 1a32.91 32.91 0 0 0-17.8-5.1h-38.9c-9 0-16.3 8.2-16.3 18.3 0 8.2 5 15.5 12.1 17.6l62.3 18.7c25.7 7.7 43.7 32.4 43.7 60.1 0 34-26.4 61.5-59.1 62.4v16.8a16.56 16.56 0 0 1-16.6 16.6h-11.1a16.56 16.56 0 0 1-16.6-16.6v-17a78.84 78.84 0 0 1-43-15.4 11.21 11.21 0 0 1-1.2-17.1l16.3-15.5c3.8-3.7 9.5-3.8 14-1a32.91 32.91 0 0 0 17.8 5.1h38.9c9 0 16.3-8.2 16.3-18.3 0-8.2-5-15.5-12.1-17.6l-62.3-18.7c-25.7-7.7-43.7-32.4-43.7-60.1.1-34 26.4-61.5 59.1-62.4z", "M218.4 219.9l62.3 18.7c7.1 2.1 12.1 9.4 12.1 17.6 0 10.1-7.3 18.3-16.3 18.3h-38.9a32.91 32.91 0 0 1-17.8-5.1c-4.5-2.8-10.2-2.7-14 1l-16.3 15.5a11.21 11.21 0 0 0 1.2 17.1 78.84 78.84 0 0 0 43 15.4v17a16.56 16.56 0 0 0 16.6 16.6h11.1a16.56 16.56 0 0 0 16.6-16.6v-16.8c32.7-.9 59.1-28.4 59.1-62.4 0-27.7-18-52.4-43.7-60.1l-62.3-18.7c-7.1-2.1-12.1-9.4-12.1-17.6 0-10.1 7.3-18.3 16.3-18.3h38.9a32.91 32.91 0 0 1 17.8 5.1c4.5 2.8 10.2 2.7 14-1l16.3-15.5a11.21 11.21 0 0 0-1.2-17.1 78.84 78.84 0 0 0-43-15.4v-17A16.56 16.56 0 0 0 261.5 64h-11.1a16.56 16.56 0 0 0-16.6 16.6v16.8c-32.7.9-59 28.4-59.1 62.4 0 27.7 18 52.4 43.7 60.1zM480 352h-32.5a242.37 242.37 0 0 1-73 64h63.8c5.3 0 9.6 3.6 9.6 8v16c0 4.4-4.3 8-9.6 8H73.6c-5.3 0-9.6-3.6-9.6-8v-16c0-4.4 4.3-8 9.6-8h63.8a243.57 243.57 0 0 1-73-64H32a32 32 0 0 0-32 32v96a32 32 0 0 0 32 32h448a32 32 0 0 0 32-32v-96a32 32 0 0 0-32-32z"]],
    "door-closed": [640, 512, [], "f52a", ["M640 464v32a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h608a16 16 0 0 1 16 16z", "M464 0H176c-26.47 0-48 22.78-48 50.8V448h384V50.8C512 22.78 490.47 0 464 0zm-48 288a32 32 0 1 1 32-32 32 32 0 0 1-32 32z"]],
    "door-open": [640, 512, [], "f52b", ["M0 464v32a16 16 0 0 0 16 16h336v-64H16a16 16 0 0 0-16 16zm624-16h-80V113.45C544 86.19 522.47 64 496 64H384v64h96v384h144a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M312.24 1l-192 49.74C106 54.44 96 67.7 96 82.92V448h256V33.18C352 11.6 332.44-4.23 312.24 1zM264 288c-13.25 0-24-14.33-24-32s10.75-32 24-32 24 14.33 24 32-10.75 32-24 32z"]],
    "dot-circle": [512, 512, [], "f192", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm124.45 372.45A176 176 0 1 1 432 256a174.85 174.85 0 0 1-51.55 124.45z", "M256 336a80 80 0 1 1 80-80 80.09 80.09 0 0 1-80 80z"]],
    "dove": [512, 512, [], "f4ba", ["M400 64a80.07 80.07 0 0 0-80 80.1v59.4A271.57 271.57 0 0 1 87 41.75c-5.5-12.5-23.2-13.2-29-.9a269.8 269.8 0 0 0-26 115.7c0 70.8 34.1 136.9 85.1 185.9a406.94 406.94 0 0 0 38.9 32.8l-143.9 36a16.1 16.1 0 0 0-9.5 24.4C20 462.55 63 508.15 155.88 512a32.09 32.09 0 0 0 22.1-7.9l65.2-56.1H320a159.86 159.86 0 0 0 160-159.74V128l32-64zm.05 96.1H400a11.31 11.31 0 1 1 .05 0z", "M320 176.69v26.81a271.52 271.52 0 0 1-174.12-76.79c1.12-5.68 2.44-11.34 4-17A269.78 269.78 0 0 1 206.16 5.35C215.07-4.94 231.92.51 233.85 14A271.5 271.5 0 0 0 320 176.69z"]],
    "download": [512, 512, [], "f019", ["M320 24v168h87.7c17.8 0 26.7 21.5 14.1 34.1L269.7 378.3a19.37 19.37 0 0 1-27.3 0L90.1 226.1c-12.6-12.6-3.7-34.1 14.1-34.1H192V24a23.94 23.94 0 0 1 24-24h80a23.94 23.94 0 0 1 24 24z", "M488 352H341.3l-49 49a51.24 51.24 0 0 1-72.6 0l-49-49H24a23.94 23.94 0 0 0-24 24v112a23.94 23.94 0 0 0 24 24h464a23.94 23.94 0 0 0 24-24V376a23.94 23.94 0 0 0-24-24zm-120 96a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm64 0a16 16 0 1 1 16-16 16 16 0 0 1-16 16z"]],
    "drafting-compass": [512, 512, [], "f568", ["M12.5 249.86c-4.86-7.67-1.89-18 6.05-22.39l28.07-15.57c7.48-4.15 16.61-1.46 21.26 5.72a223.89 223.89 0 0 0 35.75 42.55L71 316.68a288.08 288.08 0 0 1-58.5-66.82zm487 0c4.86-7.67 1.89-18-6.05-22.39l-28.07-15.57c-7.48-4.15-16.61-1.46-21.26 5.72a223.95 223.95 0 0 1-257.77 91.26l-32.53 56.35A287.42 287.42 0 0 0 256 384a288.42 288.42 0 0 0 243.5-134.14z", "M457.21 344.75a318.63 318.63 0 0 1-82.85 48.51l54.5 94.4 53.95 23A16 16 0 0 0 505 497.9l7-58.25zM340.9 143.3a96.5 96.5 0 1 0-169.29-.88L0 439.65l7 58.25a16 16 0 0 0 22.17 12.8l54-23 170.11-294.76c1.07 0 2.14.06 3.22.06h2.24l50.49 87.47a191.71 191.71 0 0 0 82.65-48.85zM256.5 128A31.5 31.5 0 1 1 288 96.5a31.5 31.5 0 0 1-31.5 31.5z"]],
    "dragon": [640, 512, [], "f6d5", ["M320 194.35v42.27A247.35 247.35 0 0 0 334.73 320H112c-14.25 0-21.39-17.23-11.31-27.31L192 224 18.32 255.82C2.36 258.1-6.57 238 5.81 227.68l117.4-116.34a64 64 0 0 1 77.06-4.59z", "M575.19 289.88l-100.66-50.31A48 48 0 0 1 448 196.65V160h64l28.09 22.63a32 32 0 0 0 22.63 9.37h31a32 32 0 0 0 28.62-17.69l14.31-28.62a32 32 0 0 0-3-33.51l-74.58-99.42A32 32 0 0 0 533.47 0H296a8 8 0 0 0-5.66 13.61L352 64l-59.58 24.8a8 8 0 0 0 0 14.31L352 128v108.58A215.61 215.61 0 0 0 448 416c-195.59 6.81-344.56 41-434.1 60.91A17.78 17.78 0 0 0 17.76 512h499.08c63.29 0 119.61-47.56 123-110.76a116.7 116.7 0 0 0-64.65-111.36zm-86-223.63l45.65 11.41c-2.75 10.91-12.47 18.89-24.13 18.26-12.97-.71-25.86-12.53-21.53-29.67z"]],
    "draw-circle": [512, 512, [], "f5ed", ["M39.9 196.71A224.68 224.68 0 0 1 196.71 39.9a64 64 0 0 0 9.34 64.1A160.73 160.73 0 0 0 104 206.06a64 64 0 0 0-64.1-9.35zM320 64a63.76 63.76 0 0 1-14 40 160.73 160.73 0 0 1 102 102.06 64 64 0 0 1 64.1-9.35A224.68 224.68 0 0 0 315.29 39.9 63.73 63.73 0 0 1 320 64zm128 256a63.76 63.76 0 0 1-40-14 160.73 160.73 0 0 1-102 102 64 64 0 0 1 9.34 64.1A224.68 224.68 0 0 0 472.1 315.29 63.73 63.73 0 0 1 448 320zM192 448a63.76 63.76 0 0 1 14.05-40A160.73 160.73 0 0 1 104 306a64 64 0 0 1-64.1 9.34A224.68 224.68 0 0 0 196.71 472.1 63.73 63.73 0 0 1 192 448z", "M256 384a64 64 0 1 0 64 64 64 64 0 0 0-64-64zm0 80a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm0-464a64 64 0 1 0 64 64 64 64 0 0 0-64-64zm0 80a16 16 0 1 1 16-16 16 16 0 0 1-16 16zM64 192a64 64 0 1 0 64 64 64 64 0 0 0-64-64zm0 80a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm384-80a64 64 0 1 0 64 64 64 64 0 0 0-64-64zm0 80a16 16 0 1 1 16-16 16 16 0 0 1-16 16z"]],
    "draw-polygon": [448, 512, [], "f5ee", ["M32 360.58V151.42a64 64 0 0 0 64 0v209.16a64 64 0 0 0-64 0zM119.42 64a64 64 0 0 1 0 64h208.06l-38.41 64A64 64 0 0 1 344 224.94l39-65a64 64 0 0 1-54.35-96zm209.16 384a64 64 0 0 1 54.35-96l-39-65a64 64 0 0 1-54.86 33l38.41 64H119.42a64 64 0 0 1 0 64z", "M64 32a64 64 0 1 0 64 64 64 64 0 0 0-64-64zm0 80a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm320 48a64 64 0 1 0-64-64 64 64 0 0 0 64 64zm0-80a16 16 0 1 1-16 16 16 16 0 0 1 16-16zM64 352a64 64 0 1 0 64 64 64 64 0 0 0-64-64zm0 80a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm320-80a64 64 0 1 0 64 64 64 64 0 0 0-64-64zm0 80a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm-32-176a64 64 0 1 0-64 64 64 64 0 0 0 64-64zm-64 16a16 16 0 1 1 16-16 16 16 0 0 1-16 16z"]],
    "draw-square": [448, 512, [], "f5ef", ["M32 360.58V151.42a64 64 0 0 0 64 0v209.16a64 64 0 0 0-64 0zM119.42 64a64 64 0 0 1 0 64h209.16a64 64 0 0 1 0-64zM384 160a63.68 63.68 0 0 1-32-8.58v209.16a64 64 0 0 1 64 0V151.42a63.68 63.68 0 0 1-32 8.58zm-55.42 288a64 64 0 0 1 0-64H119.42a64 64 0 0 1 0 64z", "M64 32a64 64 0 1 0 64 64 64 64 0 0 0-64-64zm0 80a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm320 48a64 64 0 1 0-64-64 64 64 0 0 0 64 64zm0-80a16 16 0 1 1-16 16 16 16 0 0 1 16-16zm0 272a64 64 0 1 0 64 64 64 64 0 0 0-64-64zm0 80a16 16 0 1 1 16-16 16 16 0 0 1-16 16zM64 352a64 64 0 1 0 64 64 64 64 0 0 0-64-64zm0 80a16 16 0 1 1 16-16 16 16 0 0 1-16 16z"]],
    "dreidel": [448, 512, [], "f792", ["M443.3 82l-109 109 72 71.9a33.38 33.38 0 0 1 0 47.3l-68.7 68.7-236.4-236.45 68.7-68.7a33.38 33.38 0 0 1 47.3 0l71.9 71.9 109-109a16.06 16.06 0 0 1 22.6 0l22.6 22.6a16 16 0 0 1 0 22.75z", "M78.5 165.05l236.4 236.4-58.9 58.9A66.83 66.83 0 0 1 208.7 480H66.9A66.83 66.83 0 0 1 0 413.05v-141.8A66.49 66.49 0 0 1 19.6 224z"]],
    "drone": [512, 512, [], "f85f", ["M300.34 160l38.86-28.06a64.05 64.05 0 1 1 40.86 40.86L352 211.66v1.56A111.93 111.93 0 1 0 298.78 160zm-88.68 192L172 380.64a64.06 64.06 0 1 1-40.25-41.17L160 300.34v-1.08A111.93 111.93 0 1 0 212.22 352zM111 0a112 112 0 1 0 49 212.74v-1.08l-28.25-39.13A64 64 0 1 1 172 131.36L211.66 160h.56A112 112 0 0 0 111 0zm289 288a111.58 111.58 0 0 0-48 10.78v1.56l28.06 38.86a64.05 64.05 0 1 1-40.86 40.86L300.34 352h-1.56A112 112 0 1 0 400 288z", "M432 399.19a31.91 31.91 0 1 1-63.8 1.81l-67.86-49h-88.68l-67.86 49a31.91 31.91 0 1 1-32.8-32.8l49-67.86v-88.68l-49-67.86a31.91 31.91 0 1 1 32.8-32.8l67.86 49h88.68l67.86-49a31.91 31.91 0 1 1 32.8 32.8l-49 67.86v88.68l49 67.86a31.9 31.9 0 0 1 31 30.99z"]],
    "drone-alt": [640, 512, [], "f860", ["M264 112H24a24 24 0 0 0 0 48h240a24 24 0 0 0 0-48zm352 0H376a24 24 0 0 0 0 48h240a24 24 0 0 0 0-48z", "M472 192v45.65l-96.83-29.05a191.93 191.93 0 0 0-110.34 0L168 237.65V192h-48v64.05a32 32 0 0 0 32 32h45.41a179 179 0 0 0-53.33 110.24 16.14 16.14 0 0 0 16 17.71h16.26c8.33 0 14.75-6.58 15.68-14.87a130 130 0 0 1 53.66-91.38l32.93 32.93a32 32 0 0 0 22.62 9.37h37.49a32 32 0 0 0 22.63-9.37l32.93-32.93A130 130 0 0 1 448 401.13c.93 8.29 7.35 14.85 15.68 14.87h16.22a16.13 16.13 0 0 0 16-17.71 178.94 178.94 0 0 0-53.32-110.24H488a32 32 0 0 0 32-32V192zM144 96a23.68 23.68 0 0 0-22.23 16h44.5A23.72 23.72 0 0 0 144 96zm352 0a23.68 23.68 0 0 0-22.23 16h44.5A23.72 23.72 0 0 0 496 96z"]],
    "drum": [512, 512, [], "f569", ["M256 352a24 24 0 0 0-24 24v103.47c7.91.32 15.9.53 24 .53s16.09-.21 24-.53V376a24 24 0 0 0-24-24zM96 320a24 24 0 0 0-24 24v101.76a327.89 327.89 0 0 0 48 17V344a24 24 0 0 0-24-24zm320 0a24 24 0 0 0-24 24v118.77a327.89 327.89 0 0 0 48-17V344a24 24 0 0 0-24-24zm93.31-267.56l-8.87-13.31a16 16 0 0 0-22.19-4.44L232.88 192.94a16 16 0 0 0-4.44 22.19l8.87 13.31a16 16 0 0 0 22.19 4.44L504.88 74.63a16 16 0 0 0 4.43-22.19z", "M512 208v160c0 30.23-27.5 57.61-72 77.76V344a24 24 0 0 0-48 0v118.77c-33.05 9.1-71.07 15-112 16.7V376a24 24 0 0 0-48 0v103.47c-40.93-1.67-78.95-7.6-112-16.7V344a24 24 0 0 0-48 0v101.76C27.5 425.61 0 398.23 0 368V208a37.5 37.5 0 0 1 1.33-10.38C15.09 101.32 214.73 96 256 96c17.58 0 63.9 1 112.32 9.58l-62.55 40.34c-16-1.21-32.58-1.92-49.77-1.92-114.87 0-208 28.65-208 64s93.13 64 208 64 208-28.65 208-64c0-21.27-33.87-40.07-85.77-51.7l53.23-34.3c40.86 15 73.91 38.5 79.21 75.65A37.5 37.5 0 0 1 512 208z"]],
    "drum-steelpan": [576, 512, [], "f56a", ["M172 90l25.6 44.34a73.16 73.16 0 0 1-20.94 96.53C100.23 217.46 48 190.78 48 160c0-30.16 50.11-56.39 124-70zm116 70a64.07 64.07 0 0 0 64-64V83c-20.4-1.88-41.8-3-64-3s-43.6 1.08-64 3v13a64.07 64.07 0 0 0 64 64zm110.93 70.9C475.6 217.54 528 190.83 528 160c0-30.21-50.28-56.5-124.44-70.1l-25.65 44.42a73.13 73.13 0 0 0 21 96.58zm-50 6.4c-8.1-26.13-32.19-45.3-60.93-45.3s-52.83 19.17-60.89 45.3c19.48 1.7 39.81 2.7 60.89 2.7s41.41-1 60.89-2.7z", "M288 32C128.94 32 0 89.31 0 160v192c0 70.69 128.94 128 288 128s288-57.31 288-128V160c0-70.69-128.94-128-288-128zm-83 158.36a73 73 0 0 1-28.31 40.48C100.23 217.46 48 190.78 48 160c0-30.16 50.11-56.39 124-70l25.6 44.34a73.39 73.39 0 0 1 7.4 56.02zM288 240c-21.08 0-41.41-1-60.89-2.7 8.06-26.13 32.15-45.3 60.89-45.3s52.83 19.17 60.89 45.3C329.41 239 309.08 240 288 240zm64-144a64 64 0 0 1-128 0V83c20.4-1.88 41.8-3 64-3s43.6 1.08 64 3zm46.93 134.9a73.13 73.13 0 0 1-21-96.58l25.63-44.42C477.72 103.5 528 129.79 528 160c0 30.83-52.4 57.54-129.07 70.9z"]],
    "drumstick": [512, 512, [], "f6d6", ["M193.7 392.5c-9.7 9.8-11.1 24-6 36.8 12.4 30.9-2.6 66-33.6 78.4-22.4 9-48.1 3.7-65.2-13.4-15.3-15.3-19.6-36.5-15.1-56.1-19.6 4.5-40.8.2-56.1-15.1-23.6-23.5-23.7-61.7-.2-85.3 17.1-17.2 42.7-22.4 65.2-13.4 12.8 5.1 27 3.7 36.8-6l40.5-40.5V288c0 35.3 28.7 64 64 64h10.2l-40.5 40.5z", "M160.1 192c0-64 27.6-107 63.1-142.4 66.1-66.1 173.2-66 239.3 0s66 173.2 0 239.3C427 324.3 384 352 320.1 352H224c-35.3 0-64-28.7-64-64l.1-96z"]],
    "drumstick-bite": [512, 512, [], "f6d7", ["M193.69 392.5c-9.72 9.75-11.09 24-6 36.75a60.32 60.32 0 0 1-98.73 65c-15.27-15.27-19.58-36.5-15.09-56.1-19.6 4.49-40.83.18-56.1-15.09a60.31 60.31 0 0 1 65-98.72c12.76 5.07 27.05 3.69 36.76-6L160 277.87V288a64 64 0 0 0 64 64h10.2z", "M160.06 192c0-64 27.7-107 63.18-142.43a169.5 169.5 0 0 1 239.55 0c34.32 34.28 50.44 79.6 49.14 124.56-42-22.66-94.38-17.56-128.77 16.8-40.88 40.84-40.69 107.17-1.05 151.07a187.7 187.7 0 0 1-61.9 10H224a64 64 0 0 1-64-64z"]],
    "dryer": [448, 512, [], "f861", ["M216 272c0-22.64-11.95-34.59-20.69-43.33-5.83-5.82-9.24-9.45-10.61-14.62A8 8 0 0 0 177 208h-16.29a8.17 8.17 0 0 0-8 9.53c2.77 16.64 12.51 26.38 19.93 33.8C180.53 259.17 184 263 184 272s-3.47 12.86-11.31 20.7C164 301.47 152 313.42 152 336.06s11.95 34.57 20.69 43.28c5.82 5.82 9.23 9.44 10.6 14.59A8 8 0 0 0 191 400h16.32a8.15 8.15 0 0 0 7.94-9.53c-2.76-16.61-12.5-26.35-19.92-33.75C187.47 348.88 184 345 184 336.06s3.47-12.86 11.31-20.7C204.05 306.63 216 294.67 216 272zm48 64c0-9 3.47-12.86 11.31-20.7 8.74-8.67 20.69-20.63 20.69-43.3s-11.95-34.59-20.69-43.33c-5.83-5.82-9.24-9.45-10.61-14.62A8 8 0 0 0 257 208h-16.29a8.17 8.17 0 0 0-8 9.53c2.77 16.64 12.51 26.38 19.93 33.8C260.53 259.17 264 263 264 272s-3.47 12.86-11.31 20.7C244 301.47 232 313.42 232 336.06s11.95 34.57 20.69 43.28c5.82 5.82 9.23 9.44 10.6 14.59A8 8 0 0 0 271 400h16.32a8.15 8.15 0 0 0 7.94-9.53c-2.76-16.61-12.5-26.35-19.92-33.75C267.47 348.88 264 345 264 336.06z", "M384 0H64A64 64 0 0 0 0 64v416a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32V64a64 64 0 0 0-64-64zM184 64a24 24 0 1 1-24 24 24 24 0 0 1 24-24zM64 88a24 24 0 1 1 24 24 24 24 0 0 1-24-24zm160 360a144 144 0 1 1 144-144 144 144 0 0 1-144 144z"]],
    "dryer-alt": [448, 512, [], "f862", ["M224 192a112 112 0 1 0 112 112 112 112 0 0 0-112-112zm0 192a80 80 0 0 1-78.39-64H184a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8h-38.39A80 80 0 1 1 224 384z", "M384 0H64A64 64 0 0 0 0 64v416a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32V64a64 64 0 0 0-64-64zM184 64a24 24 0 1 1-24 24 24 24 0 0 1 24-24zM64 88a24 24 0 1 1 24 24 24 24 0 0 1-24-24zm160 360a144 144 0 1 1 144-144 144 144 0 0 1-144 144z"]],
    "duck": [512, 512, [], "f6d8", ["M512 128a96 96 0 0 1-96 96h-27c37.28-13.18 59-54.2 59-96z", "M401.31 277.43A41.38 41.38 0 0 1 384 243.8a39.9 39.9 0 0 1 5-19.8c37.28-13.18 59-54.2 59-96a96 96 0 0 0-192 0 94.05 94.05 0 0 0 22.1 60.59 41.44 41.44 0 0 1 9.9 26.53A40.88 40.88 0 0 1 247.13 256h-21.69c-31.51 0-80.18-13.2-101.68-36.24C113.74 209 96 216.17 96 230.63A153.38 153.38 0 0 0 249.38 384h-32c-76 0-138.67-55.44-150.82-128h-50.4C7 256-.63 263.66 0 272.75 8.62 388.64 105.36 480 223.43 480h107.2c55.51 0 110.81-44.52 116.72-99.71a111.23 111.23 0 0 0-46.04-102.86zM352 144a16 16 0 1 1 16-16 16 16 0 0 1-16 16z"]],
    "dumbbell": [640, 512, [], "f44b", ["M32 288H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h16zm352-64H256v64h128zm240 0h-16v64h16a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M232 32h-48a23.94 23.94 0 0 0-24 24v400a23.94 23.94 0 0 0 24 24h48a23.94 23.94 0 0 0 24-24V56a23.94 23.94 0 0 0-24-24zm224 0h-48a23.94 23.94 0 0 0-24 24v400a23.94 23.94 0 0 0 24 24h48a23.94 23.94 0 0 0 24-24V56a23.94 23.94 0 0 0-24-24zm128 64h-48a23.94 23.94 0 0 0-24 24v272a23.94 23.94 0 0 0 24 24h48a23.94 23.94 0 0 0 24-24V120a23.94 23.94 0 0 0-24-24zm-480 0H56a23.94 23.94 0 0 0-24 24v272a23.94 23.94 0 0 0 24 24h48a23.94 23.94 0 0 0 24-24V120a23.94 23.94 0 0 0-24-24z"]],
    "dumpster": [576, 512, [], "f793", ["M576 240v32a16 16 0 0 1-16 16h-28l-20 160v16a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-16H128v16a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16v-16L44 288H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h20l-4-32h512l-4 32h20a16 16 0 0 1 16 16z", "M24.5 44.1l-24 96A16 16 0 0 0 16 160h97.3l25.6-128H40a16 16 0 0 0-15.5 12.1zM145.9 160H272V32H171.5zM304 32v128h126.1L404.5 32zm271.5 108.1l-24-96A16 16 0 0 0 536 32h-98.9l25.6 128H560a16 16 0 0 0 15.5-19.9z"]],
    "dumpster-fire": [640, 512, [], "f794", ["M288 321.6c0 48.5 18.6 92.7 48.8 126.4H128v16a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16v-16L44 288H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h20l-4-32h308.6c-32.7 46.7-52.6 93.7-52.6 129.6z", "M461.72 104.14a606.78 606.78 0 0 1 51.15 51.46c5.7-5.59 11.41-11.09 17.32-16.28l21.32-19 21.32 19c1.1.9 2.1 2.09 3.1 3.09a17.5 17.5 0 0 0 0-2.29l-24-95.93a15.85 15.85 0 0 0-15.44-12.09h-99l12.31 61.45zM146 160h126.24V32.1h-100.6zM24.5 44.19l-24 95.93A16 16 0 0 0 16 160h97.4L139 32.1H40a16.05 16.05 0 0 0-15.5 12.09zm526.7 119A419.31 419.31 0 0 0 511 204.4a538.72 538.72 0 0 0-71-76.4c-70.2 62.7-120 144.3-120 193.6 0 87.5 71.6 158.4 160 158.4s160-70.9 160-158.4c.1-36.6-37-112.2-88.8-158.4zM532.6 392.6a89 89 0 0 1-52.5 17c-49 0-88.9-33.5-88.9-88 0-27.1 16.5-51 49.4-91.9 4.7 5.6 67.1 88.1 67.1 88.1l39.8-47c2.8 4.8 5.4 9.5 7.7 14 18.6 36.7 10.8 83.6-22.6 107.8zM419.08 104.14l.2-.2L404.87 32h-100.6v127.9h60.86a543.28 543.28 0 0 1 53.95-55.76z"]],
    "dungeon": [512, 512, [], "f6d9", ["M304 189.36V472a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8V219.13a96.32 96.32 0 0 0-32-29.77zm-64-11.74V472a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8V177.62a94.83 94.83 0 0 0-16-1.62 94.83 94.83 0 0 0-16 1.62zm-64 41.51V472a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8V189.36a96.32 96.32 0 0 0-32 29.77z", "M112 288H16a16 16 0 0 0-16 16v64a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16v-64a16 16 0 0 0-16-16zm16.73-92.68l-82.81-51.76c-8-5-19-2.17-22.93 6.45A254.32 254.32 0 0 0 .54 239.28C0 248.37 7.59 256 16.69 256h97.13c8 0 14.08-6.25 15-14.16a126.36 126.36 0 0 1 6.24-26.94c2.57-7.34.26-15.46-6.33-19.58zM453 93.11a257.4 257.4 0 0 0-71.61-59.89c-8.28-4.68-18.88-.52-22.42 8.31l-36.32 90.8c-2.85 7.12 0 14.88 6.3 19.28a127.56 127.56 0 0 1 16.79 14c5.44 5.41 13.6 6.86 20.11 2.79l82.93-51.83c8.1-4.98 10.32-16.14 4.22-23.46zM496 416h-96a16 16 0 0 0-16 16v64a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16v-64a16 16 0 0 0-16-16zM153 41.53c-3.53-8.83-14.13-13-22.42-8.31A257.4 257.4 0 0 0 59 93.11c-6.06 7.32-3.85 18.48 4.22 23.52l82.93 51.83c6.51 4.07 14.66 2.62 20.11-2.79a127.56 127.56 0 0 1 16.79-14c6.28-4.41 9.15-12.17 6.3-19.29zM112 416H16a16 16 0 0 0-16 16v64a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16v-64a16 16 0 0 0-16-16zm384-128h-96a16 16 0 0 0-16 16v64a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16v-64a16 16 0 0 0-16-16zm-97.82-32h97.13c9.1 0 16.74-7.63 16.15-16.72A254.05 254.05 0 0 0 489 150c-3.94-8.62-14.89-11.47-22.93-6.45l-82.81 51.76c-6.59 4.12-8.9 12.24-6.34 19.58a125.9 125.9 0 0 1 6.24 26.94c.94 7.92 7.06 14.17 15.02 14.17zM319 8a252.3 252.3 0 0 0-126 0c-9.17 2.35-13.91 12.6-10.39 21.39l37.47 104a16 16 0 0 0 15 10.58h41.8A16 16 0 0 0 292 133.42l37.47-104C332.94 20.6 328.2 10.36 319 8z"]],
    "ear": [384, 512, [], "f5f0", ["M192 0C86 0 0 86 0 192v176a144 144 0 0 0 288 0v-9.9c57.33-33.21 96-95.1 96-166.1C384 86 298 0 192 0zm128 200a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-8a96 96 0 0 0-192 0 32 32 0 0 0 32 32h32a64 64 0 0 1 0 128h-8a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h8a32 32 0 0 0 0-64h-32a64.06 64.06 0 0 1-64-64 128 128 0 0 1 256 0z", "M320 200a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-8a96 96 0 0 0-192 0 32 32 0 0 0 32 32h32a64 64 0 0 1 0 128h-8a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h8a32 32 0 0 0 0-64h-32a64.06 64.06 0 0 1-64-64 128 128 0 0 1 256 0z"]],
    "ear-muffs": [640, 512, [], "f795", ["M83.44 200.9C102.24 87.1 200.94 0 319.94 0s217.8 87.2 236.5 201a69.63 69.63 0 0 0-15.7-2 72.82 72.82 0 0 0-18 2.3 71.77 71.77 0 0 0-16.5-6.8C485.74 110.6 410.14 48 319.94 48s-165.8 62.6-186.3 146.6a73.62 73.62 0 0 0-16 6.5 72.82 72.82 0 0 0-18-2.3 67.89 67.89 0 0 0-16.2 2.1z", "M639 335a39.92 39.92 0 0 0-21.4-26.9 39 39 0 0 0-8-33.6 40.3 40.3 0 0 0-31.7-14.7 39.6 39.6 0 0 0-23.4-26.2c-12.7-5-26.1-2.5-36.8 4.5-7.3-8.4-17.8-14.1-29.9-14.1a40 40 0 0 0-40 40c0 10.1 4.1 19 10.2 26a39.5 39.5 0 0 0-10.2 26.1 39.05 39.05 0 0 0 9.6 25.9 39.74 39.74 0 0 0 0 51.8 39.05 39.05 0 0 0-9.6 25.9 39.5 39.5 0 0 0 10.2 26.1 39.63 39.63 0 0 0 59.1 52.8 40.47 40.47 0 0 0 22 6.5 33.57 33.57 0 0 0 14.7-2.9 38.75 38.75 0 0 0 23.4-25.9 41.17 41.17 0 0 0 32-14.4 40.39 40.39 0 0 0 8.3-33.6 40.36 40.36 0 0 0 21.1-26.9 39 39 0 0 0-7.4-33.3A39.19 39.19 0 0 0 639 335zM151.94 224a39.23 39.23 0 0 0-29.6 13.7c-10.6-6.9-23.8-9.3-36.4-4.4a41.06 41.06 0 0 0-23.7 26.2 39.81 39.81 0 0 0-40 48 39.93 39.93 0 0 0-13.7 60.2 39.79 39.79 0 0 0 13.7 60.5 38.59 38.59 0 0 0 8 33.3 40.3 40.3 0 0 0 31.7 14.7 40.26 40.26 0 0 0 23.4 26.2 42 42 0 0 0 15 2.9 39.46 39.46 0 0 0 22.1-6.8 39.35 39.35 0 0 0 29.5 13.5 40 40 0 0 0 40-40 39.3 39.3 0 0 0-10.1-25.9 39.3 39.3 0 0 0 10.1-25.9 39.84 39.84 0 0 0-9.6-26.2 39.74 39.74 0 0 0 0-51.8 39.05 39.05 0 0 0 9.6-25.9 39.5 39.5 0 0 0-10.2-26.1 39.65 39.65 0 0 0-29.8-66.2z"]],
    "eclipse": [640, 512, [], "f749", ["M295.2 377.2c-44.2 14.3-94.6 4.4-129.7-30.7a128.13 128.13 0 0 1 0-181c35.1-35.1 85.5-45 129.8-30.7a203.26 203.26 0 0 1 25.1-28.9L271.5 9.6a17.31 17.31 0 0 0-31 0l-47.3 94.7L92.7 70.8c-13.6-4.5-26.5 8.4-21.9 21.9l33.5 100.4-94.7 47.4a17.31 17.31 0 0 0 0 31l94.7 47.3-33.5 100.5c-4.5 13.6 8.4 26.5 21.9 21.9l100.4-33.5 47.3 94.7a17.31 17.31 0 0 0 31 0l47.3-94.7 5.3 1.8a205.94 205.94 0 0 1-28.8-32.3zM256 160a96 96 0 1 0 22.3 189.1 205.49 205.49 0 0 1 0-186.2A96.63 96.63 0 0 0 256 160z", "M640 256A176 176 0 1 1 464 80a176 176 0 0 1 176 176z"]],
    "eclipse-alt": [512, 512, [], "f74a", ["M502.42 240.5l-94.7-47.3 33.5-100.4c4.5-13.6-8.4-26.5-21.9-21.9l-100.4 33.5-47.41-94.8a17.31 17.31 0 0 0-31 0l-47.3 94.7L92.7 70.8c-13.6-4.5-26.5 8.4-21.9 21.9l33.51 100.4L9.6 240.5a17.31 17.31 0 0 0 0 31l94.71 47.3L70.8 419.3c-4.5 13.6 8.4 26.5 21.9 21.9l100.41-33.5 47.3 94.7a17.31 17.31 0 0 0 31 0l47.31-94.7 100.4 33.5c13.6 4.5 26.5-8.4 21.9-21.9l-33.5-100.4 94.7-47.3a17.33 17.33 0 0 0 .2-31.1zm-155.9 106c-49.91 49.9-131.11 49.9-181 0a128.13 128.13 0 0 1 0-181c49.9-49.9 131.1-49.9 181 0a128.13 128.13 0 0 1 0 181z", "M330.4 316.5A96 96 0 1 1 255.9 160a93.4 93.4 0 0 1 17.5 1.6 4.49 4.49 0 0 1 1.4 8.3 75.21 75.21 0 0 0-38 65.4c0 47.1 42.8 82.8 89.3 73.9a4.5 4.5 0 0 1 4.3 7.3z"]],
    "edit": [576, 512, [], "f044", ["M564.6 60.2l-48.8-48.8a39.11 39.11 0 0 0-55.2 0l-35.4 35.4a9.78 9.78 0 0 0 0 13.8l90.2 90.2a9.78 9.78 0 0 0 13.8 0l35.4-35.4a39.11 39.11 0 0 0 0-55.2zM427.5 297.6l-40 40a12.3 12.3 0 0 0-3.5 8.5v101.8H64v-320h229.8a12.3 12.3 0 0 0 8.5-3.5l40-40a12 12 0 0 0-8.5-20.5H48a48 48 0 0 0-48 48v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V306.1a12 12 0 0 0-20.5-8.5z", "M492.8 173.3a9.78 9.78 0 0 1 0 13.8L274.4 405.5l-92.8 10.3a19.45 19.45 0 0 1-21.5-21.5l10.3-92.8L388.8 83.1a9.78 9.78 0 0 1 13.8 0z"]],
    "egg": [384, 512, [], "f7fb", ["M304 320a112 112 0 0 1-224 0c0-18.32 4.26-44.4 11.69-71.56a471.69 471.69 0 0 1 33.84-88c14-27.45 29.29-49.88 44.29-64.87l.36-.36a31 31 0 0 1 43.64 0l.36.36c15 15 30.31 37.42 44.29 64.87a471.69 471.69 0 0 1 33.84 88C299.74 275.6 304 301.68 304 320z", "M192 0C86 0 0 214 0 320s86 192 192 192 192-86 192-192S298 0 192 0zm0 432A112.12 112.12 0 0 1 80 320c0-18.32 4.26-44.4 11.69-71.56a471.69 471.69 0 0 1 33.84-88c14-27.45 29.29-49.88 44.29-64.87l.36-.36a31 31 0 0 1 43.64 0l.36.36c15 15 30.31 37.42 44.29 64.87a471.69 471.69 0 0 1 33.84 88C299.74 275.6 304 301.68 304 320a112.12 112.12 0 0 1-112 112z"]],
    "egg-fried": [512, 512, [], "f7fc", ["M478.31 150.45c-39.5-40.71-100.74-46.29-144.41-82.24C284.09 27.2 245.77-9.25 175.34 2.1c-86.79 14-111.73 80-125 157.14-11.1 64.34-54.42 127-50 192.91s52.84 128.43 115 150.74c93 33.39 147-31.71 204.67-86.45 43.69-41.44 93.41-37.72 141-73.89 56.2-42.82 71.63-140.55 17.3-192.1zM224 352.38c-61.75 0-112-50.3-112-112.11s50.27-112.12 112-112.12 112 50.29 112 112.12a112.14 112.14 0 0 1-112 112.11z", "M224 128a112 112 0 1 0 112 112 112.15 112.15 0 0 0-112-112zm-8 63.78a40 40 0 0 0-40 40 16 16 0 0 1-32 0 72.05 72.05 0 0 1 72-71.92 16 16 0 1 1 0 32z"]],
    "eject": [448, 512, [], "f052", ["M448 384v64a32 32 0 0 1-32 32H32a32 32 0 0 1-32-32v-64a32 32 0 0 1 32-32h384a32 32 0 0 1 32 32z", "M259.38 47.56l175.94 192c28.2 30.77 6.27 80.44-35.38 80.44H48.05c-41.73 0-63.52-49.73-35.38-80.44l176-192a48 48 0 0 1 70.71 0z"]],
    "elephant": [640, 512, [], "f6da", ["M512 32.15h-72.65A63.9 63.9 0 1 0 352 119.24v72.86a32 32 0 0 0 28.78 31.83H408a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8l-24 .12a64.06 64.06 0 0 1-64-64v-56.73a96 96 0 0 1-32-71.18 94.71 94.71 0 0 1 5.9-32H192c-106 0-192 86-192 191.94v112a16 16 0 0 0 16 16h16V496a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16V388.19C160.35 405.73 198.72 416 240 416s79.65-10.3 112-27.84V496a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16V288.07h64c23.44 0 45.11-6.76 64-17.74v97.31A16.26 16.26 0 0 1 560.14 384 16 16 0 0 1 544 368.19v-.14c0-8.78-7.64-16-16.42-16H496a16 16 0 0 0-16 16 80.07 80.07 0 0 0 88.36 79.54C610 443.34 640 405.14 640 363.32V160.11A128 128 0 0 0 512 32.15zm16 128a16 16 0 1 1 16-16 16 16 0 0 1-16 15.96z", "M528 128a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm-176 64.16v-72.88A63.89 63.89 0 0 1 328.54 32l-34.64.16a94.77 94.77 0 0 0-5.9 32 96 96 0 0 0 32 71.2v56.8A64.07 64.07 0 0 0 379.74 256H408a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8h-27.22A32 32 0 0 1 352 192.16z"]],
    "ellipsis-h": [512, 512, [], "f141", ["M256 184a72 72 0 1 0 72 72 72 72 0 0 0-72-72z", "M432 184a72 72 0 1 0 72 72 72 72 0 0 0-72-72zm-352 0a72 72 0 1 0 72 72 72 72 0 0 0-72-72z"]],
    "ellipsis-h-alt": [512, 512, [], "f39b", ["M80 184a72 72 0 1 0 72 72 72 72 0 0 0-72-72zm0 96a24 24 0 1 1 24-24 24 24 0 0 1-24 24zm352-96a72 72 0 1 0 72 72 72 72 0 0 0-72-72zm0 96a24 24 0 1 1 24-24 24 24 0 0 1-24 24zm-176-96a72 72 0 1 0 72 72 72 72 0 0 0-72-72zm0 96a24 24 0 1 1 24-24 24 24 0 0 1-24 24z", "M80 232a24 24 0 1 0 24 24 24 24 0 0 0-24-24zm176 0a24 24 0 1 0 24 24 24 24 0 0 0-24-24zm176 0a24 24 0 1 0 24 24 24 24 0 0 0-24-24z"]],
    "ellipsis-v": [192, 512, [], "f142", ["M96 184a72 72 0 1 0 72 72 72 72 0 0 0-72-72z", "M96 152a72 72 0 1 0-72-72 72 72 0 0 0 72 72zm0 208a72 72 0 1 0 72 72 72 72 0 0 0-72-72z"]],
    "ellipsis-v-alt": [192, 512, [], "f39c", ["M168 80a72 72 0 1 0-72 72 72 72 0 0 0 72-72zm-96 0a24 24 0 1 1 24 24 24 24 0 0 1-24-24zm96 352a72 72 0 1 0-72 72 72 72 0 0 0 72-72zm-96 0a24 24 0 1 1 24 24 24 24 0 0 1-24-24zm96-176a72 72 0 1 0-72 72 72 72 0 0 0 72-72zm-96 0a24 24 0 1 1 24 24 24 24 0 0 1-24-24z", "M120 80a24 24 0 1 0-24 24 24 24 0 0 0 24-24zm0 176a24 24 0 1 0-24 24 24 24 0 0 0 24-24zm0 176a24 24 0 1 0-24 24 24 24 0 0 0 24-24z"]],
    "empty-set": [512, 512, [], "f656", ["M76.6 390.15A223 223 0 0 1 32 256C32 132.29 132.29 32 256 32a223 223 0 0 1 134.15 44.6l-57.46 57.46a144.07 144.07 0 0 0-198.63 198.63zm301.34-210.83a144.07 144.07 0 0 1-198.62 198.62l-57.46 57.47A223 223 0 0 0 256 480c123.71 0 224-100.29 224-224a223 223 0 0 0-44.6-134.15z", "M507.31 50L50 507.32a16 16 0 0 1-22.63 0L4.69 484.69a16 16 0 0 1 0-22.63L462.06 4.69a16 16 0 0 1 22.63 0l22.62 22.62a16 16 0 0 1 0 22.69z"]],
    "engine-warning": [640, 512, [], "f5f2", ["M320 32C196.3 32 96 132.3 96 256s100.3 224 224 224 224-100.24 224-224S443.7 32 320 32zm0 352a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm38.24-238.41l-12.8 128A16 16 0 0 1 329.52 288h-19a16 16 0 0 1-15.92-14.41l-12.8-128A16 16 0 0 1 297.68 128h44.64a16 16 0 0 1 15.92 17.59z", "M101.33 69.63l-12.2-10.41c-6.91-5.9-17.62-5.06-23.15 2.15a320.08 320.08 0 0 0 0 389.25c5.53 7.21 16.23 8.05 23.15 2.16l12.19-10.4a15.88 15.88 0 0 0 2-21.86 272.17 272.17 0 0 1 0-329 15.87 15.87 0 0 0-1.99-21.89zm471.4-9.92c-5.58-7.18-16.29-8-23.17-2l-12.15 10.51a15.87 15.87 0 0 0-1.88 21.87 272 272 0 0 1 0 331.86 15.87 15.87 0 0 0 1.88 21.87l12.15 10.5c6.87 5.95 17.59 5.18 23.17-2a320.08 320.08 0 0 0 0-392.61zM342.32 128h-44.64a16 16 0 0 0-15.92 17.59l12.8 128A16 16 0 0 0 310.48 288h19a16 16 0 0 0 15.92-14.41l12.8-128A16 16 0 0 0 342.32 128zM320 320a32 32 0 1 0 32 32 32 32 0 0 0-32-32z"]],
    "envelope": [512, 512, [], "f0e0", ["M256.47 352h-.94c-30.1 0-60.41-23.42-82.54-40.52C169.39 308.7 24.77 202.7 0 183.33V400a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V183.36c-24.46 19.17-169.4 125.34-173 128.12-22.12 17.1-52.43 40.52-82.53 40.52zM464 64H48a48 48 0 0 0-48 48v19a24.08 24.08 0 0 0 9.2 18.9c30.6 23.9 40.7 32.4 173.4 128.7 16.8 12.2 50.2 41.8 73.4 41.4 23.2.4 56.6-29.2 73.4-41.4 132.7-96.3 142.8-104.7 173.4-128.7A23.93 23.93 0 0 0 512 131v-19a48 48 0 0 0-48-48z", "M512 131v52.36c-24.46 19.17-169.4 125.34-173 128.12-22.12 17.1-52.43 40.52-82.53 40.52h-.94c-30.1 0-60.41-23.42-82.54-40.52C169.39 308.7 24.77 202.7 0 183.33V131a24.08 24.08 0 0 0 9.2 18.9c30.6 23.9 40.7 32.4 173.4 128.7 16.69 12.12 49.75 41.4 72.93 41.4h.94c23.18 0 56.24-29.28 72.93-41.4 132.7-96.3 142.8-104.7 173.4-128.7A23.93 23.93 0 0 0 512 131z"]],
    "envelope-open": [512, 512, [], "f2b6", ["M492.61 163c-24.89-19.52-45.51-35.38-164.2-121.51C311.6 29.17 278.2-.35 255 0c-23.2-.35-56.59 29.17-73.41 41.44C62.89 127.58 42.3 143.42 17.39 163 7.24 170.9-1 187.83-1 200.72V464a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V200.72c0-12.89-8.24-29.82-18.39-37.72zm-40 128.61c-22.89 16.9-55.46 40.69-105.31 76.87C327 383.23 290.72 416.24 255 416c-35.74.24-72-32.79-92.26-47.57-49.85-36.18-82.42-60-105.31-76.87a9 9 0 0 1-3.24-6.44 9.44 9.44 0 0 1 1.4-4.53l9.08-13.2a8 8 0 0 1 11.33-1.9c22.85 16.87 55.47 40.71 105.59 77.08 16.85 12.28 50.2 41.77 73.41 41.43 23.2.35 56.59-29.17 73.41-41.43 50.12-36.38 82.74-60.21 105.59-77.08a8 8 0 0 1 11.33 1.9l9.08 13.2a9.44 9.44 0 0 1 1.4 4.53 9 9 0 0 1-3.24 6.44z", "M455.81 285.12a9 9 0 0 1-3.24 6.44c-22.89 16.9-55.46 40.69-105.31 76.87C327 383.23 290.72 416.24 255 416c-35.74.24-72-32.79-92.26-47.57-49.85-36.18-82.42-60-105.31-76.87a9 9 0 0 1-3.24-6.44 9.44 9.44 0 0 1 1.4-4.53l9.08-13.2a8 8 0 0 1 11.33-1.9c22.85 16.87 55.47 40.71 105.59 77.08 16.85 12.28 50.2 41.77 73.41 41.43 23.2.35 56.59-29.17 73.41-41.43 50.12-36.38 82.74-60.21 105.59-77.08a8 8 0 0 1 11.33 1.9l9.08 13.2a9.44 9.44 0 0 1 1.4 4.53z"]],
    "envelope-open-dollar": [512, 512, [], "f657", ["M416 64H96a32 32 0 0 0-32 32v161.62L227.91 376a47.89 47.89 0 0 0 56.21 0L448 257.62V96a32 32 0 0 0-32-32z", "M248 319h16a8 8 0 0 0 8-8v-16.12c23.62-.63 42.67-20.54 42.67-45.07 0-20-13-37.81-31.58-43.39l-45-13.5c-5.16-1.55-8.77-6.78-8.77-12.73 0-7.27 5.3-13.19 11.8-13.19h28.11a24.14 24.14 0 0 1 12.82 3.72 8.19 8.19 0 0 0 10.13-.73l11.75-11.21a8 8 0 0 0-.57-12.14A57.29 57.29 0 0 0 272 135.29V119a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v16.12c-23.62.63-42.67 20.55-42.67 45.07 0 20 13 37.81 31.58 43.39l45 13.5c5.16 1.55 8.77 6.78 8.77 12.73 0 7.27-5.3 13.19-11.8 13.19h-28.11a24 24 0 0 1-12.77-3.72 8.22 8.22 0 0 0-10.13.73l-11.75 11.21a8 8 0 0 0-.34 11.31 7.17 7.17 0 0 0 .91.83A57.13 57.13 0 0 0 240 294.71V311a8 8 0 0 0 8 8zm81.4-277.56C312.6 29.18 279.2-.35 256 0c-23.2-.35-56.59 29.17-73.41 41.44L152 64h208zM64 129c-23.88 17.69-42.67 31.65-45.61 34A48 48 0 0 0 0 200.72v10.65l64 46.24zm429.61 34c-2.94-2.3-21.73-16.26-45.61-33.93v128.54l64-46.24v-10.65A48 48 0 0 0 493.61 163zM256 417.13a79.83 79.83 0 0 1-46.86-15.19L0 250.86V464a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V250.86L302.86 401.94A80 80 0 0 1 256 417.13z"]],
    "envelope-open-text": [512, 512, [], "f658", ["M448 96v161.62L284.12 376a47.89 47.89 0 0 1-56.21 0L64 257.62V96a32 32 0 0 1 32-32h320a32 32 0 0 1 32 32z", "M336 224H176a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h160a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm16-64a16 16 0 0 0-16-16H176a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h160a16 16 0 0 0 16-16zM329.41 41.44C312.6 29.18 279.2-.35 256 0c-23.2-.35-56.59 29.17-73.41 41.44L152 64h208zM64 129c-23.88 17.69-42.67 31.65-45.61 34A48 48 0 0 0 0 200.72v10.65l64 46.24zm429.61 34c-2.94-2.3-21.73-16.26-45.61-33.93v128.54l64-46.24v-10.65A48 48 0 0 0 493.61 163zM256 417.13a79.83 79.83 0 0 1-46.86-15.19L0 250.86V464a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V250.86L302.86 401.94A80 80 0 0 1 256 417.13z"]],
    "envelope-square": [448, 512, [], "f199", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-16 328a24 24 0 0 1-24 24H88a24 24 0 0 1-24-24V152a24 24 0 0 1 24-24h272a24 24 0 0 1 24 24z", "M224 320c-26.72.13-50.54-21.67-64.7-32C97.33 243 78 228.57 64 217.77V360a24 24 0 0 0 24 24h272a24 24 0 0 0 24-24V217.77c-14 10.8-33.33 25.24-95.28 70.2C275 298 250.88 320.13 224 320zm136-192H88a24 24 0 0 0-24 24v25.17c24.35 19 23.43 19.12 114.12 84.93 10.51 7.67 31.38 26.12 45.88 25.9 14.49.22 35.38-18.24 45.88-25.9 90.69-65.81 89.75-66 114.12-84.93V152a24 24 0 0 0-24-24z"]],
    "equals": [448, 512, [], "f52c", ["M448 336v32a32 32 0 0 1-32 32H32a32 32 0 0 1-32-32v-32a32 32 0 0 1 32-32h384a32 32 0 0 1 32 32z", "M448 144v32a32 32 0 0 1-32 32H32a32 32 0 0 1-32-32v-32a32 32 0 0 1 32-32h384a32 32 0 0 1 32 32z"]],
    "eraser": [512, 512, [], "f12d", ["M512 428v40a12 12 0 0 1-12 12H144a48 48 0 0 1-33.94-14.06l-96-96a48 48 0 0 1 0-67.88l136-136 227.88 227.88L355.88 416H500a12 12 0 0 1 12 12z", "M377.94 393.94l120-120a48 48 0 0 0 0-67.88l-160-160a48 48 0 0 0-67.88 0l-120 120 45.25 45.25z"]],
    "ethernet": [512, 512, [], "f796", ["M512 208v224a16 16 0 0 1-16 16h-80V320h-32v128h-64V320h-32v128h-64V320h-32v128h-64V320H96v128H16a16 16 0 0 1-16-16V208a16 16 0 0 1 16-16h48v-48a16 16 0 0 1 16-16h48V80a16 16 0 0 1 16-16h224a16 16 0 0 1 16 16v48h48a16 16 0 0 1 16 16v48h48a16 16 0 0 1 16 16z", "M192 448h32V320h-32zm-96 0h32V320H96zm192 0h32V320h-32zm96-128v128h32V320z"]],
    "euro-sign": [320, 512, [], "f153", ["M249.46 272H12a12 12 0 0 0-12 12v28.37a12 12 0 0 0 12 12h231.08a12 12 0 0 0 11.71-9.37l6.37-28.37a12.16 12.16 0 0 0 .29-2.62A12 12 0 0 0 249.46 272zm19-96H12a12 12 0 0 0-12 12v29.76a12 12 0 0 0 12 12h250a12 12 0 0 0 11.67-9.44l6.51-29.75a12.26 12.26 0 0 0 .28-2.57 12 12 0 0 0-12-12z", "M310.74 472.22a249.39 249.39 0 0 1-61.1 7.79c-287.91 0-290.74-448 0-448a290.17 290.17 0 0 1 52.68 5.21 12 12 0 0 1 9.53 14c-.06.29-.12.58-.2.87l-12 44.37a12 12 0 0 1-14 8.62c-234.25-48.79-225.48 354 10.63 299.3a12 12 0 0 1 14.36 9c0 .11.05.22.07.33l8.81 44.49a12 12 0 0 1-8.78 14.02z"]],
    "exchange": [512, 512, [], "f0ec", ["M488 384H106l30.47 27.73a24 24 0 0 1 .47 34.4L126.13 457a24 24 0 0 1-33.94 0L9.37 374.63a32 32 0 0 1 0-45.26L92.19 247a24 24 0 0 1 33.94 0L137 257.87a24 24 0 0 1-.47 34.4L106 320h382a24 24 0 0 1 24 24v16a24 24 0 0 1-24 24z", "M0 168v-16a24 24 0 0 1 24-24h382l-30.5-27.73a24 24 0 0 1-.47-34.4L385.87 55a24 24 0 0 1 33.94 0l82.82 82.34a32 32 0 0 1 0 45.26L419.81 265a24 24 0 0 1-33.94 0L375 254.13a24 24 0 0 1 .47-34.4L406 192H24a24 24 0 0 1-24-24z"]],
    "exchange-alt": [512, 512, [], "f362", ["M128 272v48h360a24 24 0 0 1 24 24v16a24 24 0 0 1-24 24H128v48c0 21.44-25.94 32-41 17L7 369a24 24 0 0 1 0-33.94l80-80c15.14-15.12 41-4.35 41 16.94z", "M505 143.05a24 24 0 0 1 0 33.95l-80 80c-15 15-41 4.49-41-17v-48H24a24 24 0 0 1-24-24v-16a24 24 0 0 1 24-24h360V80c0-21.36 25.9-32 41-17z"]],
    "exclamation": [192, 512, [], "f12a", ["M96 512a80 80 0 1 1 80-80 80.09 80.09 0 0 1-80 80z", "M49.22 0h93.56a24 24 0 0 1 24 25.2l-13.63 272a24 24 0 0 1-24 22.8H62.84a24 24 0 0 1-24-22.8l-13.59-272A24 24 0 0 1 49.22 0z"]],
    "exclamation-circle": [512, 512, [], "f06a", ["M256 8C119 8 8 119.08 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm0 376a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm38.24-238.41l-12.8 128A16 16 0 0 1 265.52 288h-19a16 16 0 0 1-15.92-14.41l-12.8-128A16 16 0 0 1 233.68 128h44.64a16 16 0 0 1 15.92 17.59z", "M278.32 128h-44.64a16 16 0 0 0-15.92 17.59l12.8 128A16 16 0 0 0 246.48 288h19a16 16 0 0 0 15.92-14.41l12.8-128A16 16 0 0 0 278.32 128zM256 320a32 32 0 1 0 32 32 32 32 0 0 0-32-32z"]],
    "exclamation-square": [448, 512, [], "f321", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zM224 384a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm38.24-238.41l-12.8 128A16 16 0 0 1 233.52 288h-19a16 16 0 0 1-15.92-14.41l-12.8-128A16 16 0 0 1 201.68 128h44.64a16 16 0 0 1 15.92 17.59z", "M246.32 128h-44.64a16 16 0 0 0-15.92 17.59l12.8 128A16 16 0 0 0 214.48 288h19a16 16 0 0 0 15.92-14.41l12.8-128A16 16 0 0 0 246.32 128zM224 320a32 32 0 1 0 32 32 32 32 0 0 0-32-32z"]],
    "exclamation-triangle": [576, 512, [], "f071", ["M569.52 440L329.58 24c-18.44-32-64.69-32-83.16 0L6.48 440c-18.42 31.94 4.64 72 41.57 72h479.89c36.87 0 60.06-40 41.58-72zM288 448a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm38.24-238.41l-12.8 128A16 16 0 0 1 297.52 352h-19a16 16 0 0 1-15.92-14.41l-12.8-128A16 16 0 0 1 265.68 192h44.64a16 16 0 0 1 15.92 17.59z", "M310.32 192h-44.64a16 16 0 0 0-15.92 17.59l12.8 128A16 16 0 0 0 278.48 352h19a16 16 0 0 0 15.92-14.41l12.8-128A16 16 0 0 0 310.32 192zM288 384a32 32 0 1 0 32 32 32 32 0 0 0-32-32z"]],
    "expand": [448, 512, [], "f065", ["M148 32H24A23.94 23.94 0 0 0 0 56v124a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12V96h84a12 12 0 0 0 12-12V44a12 12 0 0 0-12-12zm288 288h-40a12 12 0 0 0-12 12v84h-84a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h124a23.94 23.94 0 0 0 24-24V332a12 12 0 0 0-12-12z", "M148 416H64v-84a12 12 0 0 0-12-12H12a12 12 0 0 0-12 12v124a23.94 23.94 0 0 0 24 24h124a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zM424 32H300a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h84v84a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12V56a23.94 23.94 0 0 0-24-24z"]],
    "expand-alt": [448, 512, [], "f424", ["M0 456V344c0-21.38 25.8-32.09 40.92-17L72 360l92.69-92.69a16 16 0 0 1 22.62 0l25.38 25.38a16 16 0 0 1 0 22.62L120 408l32.92 31c15.12 15.12 4.41 41-17 41H24a24 24 0 0 1-24-24z", "M235.31 196.69L328 104l-32.92-31c-15.12-15.12-4.41-41 17-41h112A24 24 0 0 1 448 56v112c0 21.38-25.8 32.09-40.92 17L376 152l-92.69 92.69a16 16 0 0 1-22.62 0l-25.38-25.38a16 16 0 0 1 0-22.62z"]],
    "expand-arrows": [448, 512, [], "f31d", ["M0 200V64a32 32 0 0 1 32-32h136a23.94 23.94 0 0 1 24 24v15.3a24 24 0 0 1-24.7 24L101 93.4l123 123-39.6 39.6-123-123 1.9 66.3a24 24 0 0 1-24 24.7H24a23.94 23.94 0 0 1-24-24zm424 88h-15.3a24 24 0 0 0-24 24.7l1.9 66.3-123-123-39.6 39.6 123 123-66.3-1.9a24 24 0 0 0-24.7 24V456a23.94 23.94 0 0 0 24 24h136a32 32 0 0 0 32-32V312a23.94 23.94 0 0 0-24-24z", "M101 418.6l66.3-1.9a24 24 0 0 1 24.7 24V456a23.94 23.94 0 0 1-24 24H32a32 32 0 0 1-32-32V312a23.94 23.94 0 0 1 24-24h15.3a24 24 0 0 1 24 24.7L61.4 379 347 93.4l-66.3 1.9a24 24 0 0 1-24.7-24V56a23.94 23.94 0 0 1 24-24h136a32 32 0 0 1 32 32v136a23.94 23.94 0 0 1-24 24h-15.3a24 24 0 0 1-24-24.7l1.9-66.3z"]],
    "expand-arrows-alt": [448, 512, [], "f31e", ["M.05 168V56a23.94 23.94 0 0 1 24-24h112c21.4 0 32.1 25.9 17 41l-36.2 36.2 107.2 107.2L184.4 256 77.15 148.75 41.05 185c-15.05 15.05-41 4.35-41-17zm407 159.1L371 363.25 263.7 256l-39.65 39.65 107.2 107.2-36.2 36.2c-15.1 15.1-4.4 41 17 41h112a23.94 23.94 0 0 0 24-24v-112c0-21.4-25.9-32.05-41-17z", "M370.9 148.8L116.8 402.9 153 439c15.1 15.1 4.4 41-17 41H24a23.94 23.94 0 0 1-24-24V344c0-21.4 25.9-32.1 41-17l36.2 36.2 254.1-254.1L295.1 73c-15.1-15.1-4.4-41 17-41h112a23.94 23.94 0 0 1 24 24v112c0 21.4-25.9 32.1-41 17z"]],
    "expand-wide": [512, 512, [], "f320", ["M148 64H24A23.94 23.94 0 0 0 0 88v124a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-84h84a12 12 0 0 0 12-12V76a12 12 0 0 0-12-12zm352 224h-40a12 12 0 0 0-12 12v84h-84a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h124a23.94 23.94 0 0 0 24-24V300a12 12 0 0 0-12-12z", "M148 384H64v-84a12 12 0 0 0-12-12H12a12 12 0 0 0-12 12v124a23.94 23.94 0 0 0 24 24h124a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zM488 64H364a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h84v84a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12V88a23.94 23.94 0 0 0-24-24z"]],
    "external-link": [512, 512, [], "f08e", ["M400 320h32a16 16 0 0 1 16 16v128a48 48 0 0 1-48 48H48a48 48 0 0 1-48-48V112a48 48 0 0 1 48-48h160a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16H64v320h320V336a16 16 0 0 1 16-16z", "M484 224h-17.88a28 28 0 0 1-28-28v-.78L440 128 192.91 376.91A24 24 0 0 1 159 377l-.06-.06L135 353.09a24 24 0 0 1 0-33.94l.06-.06L384 72l-67.21 1.9A28 28 0 0 1 288 46.68V28a28 28 0 0 1 28-28h158.67A37.33 37.33 0 0 1 512 37.33V196a28 28 0 0 1-28 28z"]],
    "external-link-alt": [512, 512, [], "f35d", ["M400 320h32a16 16 0 0 1 16 16v128a48 48 0 0 1-48 48H48a48 48 0 0 1-48-48V112a48 48 0 0 1 48-48h160a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16H64v320h320V336a16 16 0 0 1 16-16z", "M512 24v128c0 21.47-26 32-41 17l-35.71-35.71L191.8 376.77a24 24 0 0 1-33.94 0l-22.63-22.63a24 24 0 0 1 0-33.94L378.76 76.68 343.05 41C328 25.9 338.66 0 360 0h128a24 24 0 0 1 24 24z"]],
    "external-link-square": [448, 512, [], "f14c", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-16 227.33a23.34 23.34 0 0 1-23.33 23.34h-14.91a23.34 23.34 0 0 1-23.32-24l1.59-56-205.94 207.42a20 20 0 0 1-28.33.05l-19.9-19.9a20 20 0 0 1 0-28.33L277.31 156l-56 1.59a23.34 23.34 0 0 1-24-23.32v-14.94A23.34 23.34 0 0 1 220.67 96h132.22A31.11 31.11 0 0 1 384 127.11z", "M69.91 361.91L277.31 156l-56 1.59a23.34 23.34 0 0 1-24-23.32v-14.94A23.34 23.34 0 0 1 220.67 96h132.22A31.11 31.11 0 0 1 384 127.11v132.22a23.34 23.34 0 0 1-23.33 23.34h-14.91a23.34 23.34 0 0 1-23.32-24l1.59-56-205.94 207.42a20 20 0 0 1-28.33.05l-19.9-19.9a20 20 0 0 1 .05-28.33z"]],
    "external-link-square-alt": [448, 512, [], "f360", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-16 200c0 21.45-25.94 32-41 17l-32-32-195.48 195.48a12 12 0 0 1-17 0l-31-31a12 12 0 0 1 0-17L263 169l-32-32c-15.11-15.11-4.34-41 17-41h112a24 24 0 0 1 24 24z", "M384 232c0 21.44-25.94 32-41 17l-32-32-195.48 195.48a12 12 0 0 1-17 0l-31-31a12 12 0 0 1 0-17L263 169l-32-32c-15.11-15.11-4.34-41 17-41h112a24 24 0 0 1 24 24z"]],
    "eye": [576, 512, [], "f06e", ["M572.52 241.4C518.29 135.59 410.93 64 288 64S57.68 135.64 3.48 241.41a32.35 32.35 0 0 0 0 29.19C57.71 376.41 165.07 448 288 448s230.32-71.64 284.52-177.41a32.35 32.35 0 0 0 0-29.19zM288.14 400H288a143.93 143.93 0 1 1 .14 0z", "M380.66 280.87a95.78 95.78 0 1 1-184.87-50.18 47.85 47.85 0 0 0 66.9-66.9 95.3 95.3 0 0 1 118 117.08z"]],
    "eye-dropper": [512, 512, [], "f1fb", ["M32 512L0 480l32-56v-45.5c0-17 6.7-33.3 18.8-45.3l126.6-126.6 128 128-126.7 126.7c-12 12-28.3 18.7-45.2 18.7H88l-56 32z", "M483.9 163.9L406.8 241l13.1 13.1c9.4 9.4 9.4 24.6 0 33.9l-41 41c-9.4 9.3-24.5 9.3-33.9 0L183 167c-9.4-9.4-9.4-24.6 0-33.9l41-41c9.4-9.4 24.6-9.4 33.9 0l13.1 13.2 77.1-77.1c37.5-37.5 98.3-37.5 135.8 0s37.5 98.2 0 135.7z"]],
    "eye-evil": [640, 512, [], "f6db", ["M344.35 222.25A81 81 0 0 1 352 256c-.49 42.66-32 64-32 64s-31.48-21.34-32-64a81.1 81.1 0 0 1 7.64-33.75 170.14 170.14 0 0 0 48.68 0z", "M627 239.08l-111.87-30.3c-4.79-6.56-10.15-13.4-16.13-20.45 1.35-2.07 55.18-88 55.18-88 8.98-14.33-6.06-31.33-22.41-25.4L412 118.29A215 215 0 0 0 381.36 106l-44.47-95.27c-6.68-14.31-27.08-14.31-33.76 0L258.66 106A213.81 213.81 0 0 0 228 118.29L108.24 74.93C91.89 69 76.86 86 85.79 100.35c0 0 53.84 85.92 55.18 88q-8.43 9.93-16.13 20.45L13 239.08c-17.29 4.68-17.29 29.15 0 33.83l111.87 30.3c4.78 6.54 10.11 13.35 16.07 20.38-1.34 2.09-55.12 88.05-55.12 88.05-8.97 14.36 6.07 31.36 22.42 25.43L228 393.71A213.81 213.81 0 0 0 258.66 406l44.47 95.24c6.68 14.31 27.08 14.31 33.76 0L381.36 406A213.81 213.81 0 0 0 412 393.71l119.77 43.36c16.35 5.92 31.39-11.11 22.45-25.43 0 0-53.78-86-55.12-88.05 6-7 11.29-13.84 16.07-20.38l111.87-30.3c17.29-4.68 17.29-29.14-.04-33.83zM320 352a96 96 0 0 1-80-149.08C261.92 216.1 289.72 224 320 224s58.08-7.9 80-21.08A96 96 0 0 1 320 352z"]],
    "eye-slash": [640, 512, [], "f070", ["M172.12 101.27A311.47 311.47 0 0 1 320 64c122.93 0 230.29 71.59 284.52 177.4a32.35 32.35 0 0 1 0 29.19 332.58 332.58 0 0 1-81 102.25l-72.81-56.27a144 144 0 0 0-222.2-171.73zm239 184.73c.55-1.68 1.07-3.38 1.54-5.11a95 95 0 0 0-118-117.08 47.73 47.73 0 0 1 8.21 38.55zM320 400c-75.85 0-137.25-58.71-142.9-133.11L72.2 185.82c-13.79 17.3-26.48 35.59-36.72 55.59a32.35 32.35 0 0 0 0 29.19C89.71 376.41 197.07 448 320 448c26.91 0 52.87-4 77.89-10.46L346 397.39a143.62 143.62 0 0 1-26 2.61z", "M636.64 480.55L617 505.82a16 16 0 0 1-22.45 2.8L6.18 53.9a16 16 0 0 1-2.81-22.45L23 6.18a16 16 0 0 1 22.45-2.8L633.82 458.1a16 16 0 0 1 2.82 22.45z"]],
    "fan": [512, 512, [], "f863", ["M352.57 128c-28.09 0-54.09 4.52-77.06 12.86l12.41-123.11C289 7.31 279.81-1.18 269.33.13 189.63 10.13 128 77.64 128 159.43c0 28.09 4.52 54.09 12.86 77.06L17.75 224.08C7.31 223-1.18 232.19.13 242.67c10 79.7 77.51 141.33 159.3 141.33 28.09 0 54.09-4.52 77.06-12.86l-12.41 123.11c-1.05 10.43 8.11 18.93 18.59 17.62 79.7-10 141.33-77.51 141.33-159.3 0-28.09-4.52-54.09-12.86-77.06l123.11 12.41c10.44 1.05 18.93-8.11 17.62-18.59-10-79.7-77.51-141.33-159.3-141.33zM256 292a36 36 0 1 1 36-36 36 36 0 0 1-36 36z", "M256 292a36 36 0 1 1 36-36 36 36 0 0 1-36 36z"]],
    "farm": [576, 512, [], "f864", ["M190.24 120.94l-55.48 111a64.35 64.35 0 0 0-6.76 28.6V512H0V112a111.93 111.93 0 0 1 221.87-21.09l-.37.17a64.12 64.12 0 0 0-31.26 29.86z", "M572.62 246.22l-55.49-111a32 32 0 0 0-15.62-14.93L381 66.76a32 32 0 0 0-26 0l-120.51 53.56a32 32 0 0 0-15.62 14.93l-55.49 111a32.08 32.08 0 0 0-3.38 14.29V512h128v-96h160v96h128V260.54a32.08 32.08 0 0 0-3.38-14.32zM416 320h-96v-96h96z"]],
    "fast-backward": [512, 512, [], "f049", ["M64 285.31V436a12 12 0 0 1-12 12H12a12 12 0 0 1-12-12V76a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12v209.3z", "M512 96v320c0 27.4-31.9 41.7-52.5 24.6L288 285.31V416c0 27.4-31.9 41.7-52.5 24.6L96 314.28V198.71l139.5-127.3C256.1 54.31 288 68.61 288 96v131.9L459.5 71.41C480.1 54.31 512 68.61 512 96z"]],
    "fast-forward": [512, 512, [], "f050", ["M512 76v360a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12V76a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12z", "M416 313.31l-139.5 127.3c-20.6 17.2-52.5 2.8-52.5-24.6v-131.9L52.5 440.61C31.9 457.81 0 443.41 0 416V96c0-27.4 31.9-41.7 52.5-24.6L224 226.81V96c0-27.4 31.9-41.7 52.5-24.6L416 197.81z"]],
    "fax": [512, 512, [], "f1ac", ["M480 96v96H128V32a32 32 0 0 1 32-32h224v80a16 16 0 0 0 16 16z", "M64 128H32a32 32 0 0 0-32 32v320a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32V160a32 32 0 0 0-32-32zm416 64H128v288a32 32 0 0 0 32 32h320a32 32 0 0 0 32-32V224a32 32 0 0 0-32-32zM288 432a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16zm0-128a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16zm128 128a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16zm0-128a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16zM400 96h80v-4.58a17.92 17.92 0 0 0-5.25-12.67l-73.43-73.5A18 18 0 0 0 388.57 0H384v80a16 16 0 0 0 16 16z"]],
    "feather": [512, 512, [], "f52d", ["M483.4 244.2L351.85 288h97.78c-9.92 10.68 3.68-3.07-46.3 46.86L255.75 384h98.19c-74.94 73.11-194.52 70.65-246.82 54.94l-.06-.05L305 241a24 24 0 0 0-34-34L73.19 404.87l-.2-.21c-12.13-40.37-26.12-166.28 56.11-248.43 24.78-24.74 7.15-7.14 85.75-85.66 90.61-90.51 189.73-88.21 252.28-25.73 50.58 50.52 61.7 124.9 16.27 199.36z", "M24 512a24 24 0 0 1-17-41l264-264a24 24 0 0 1 34 34L41 505a23.92 23.92 0 0 1-17 7z"]],
    "feather-alt": [512, 512, [], "f56b", ["M458.38 234.79L351.83 288H433a396.85 396.85 0 0 1-30.46 47.12L255.73 384h101c-35.57 30.07-79.11 51.1-132.59 56.54a1130.32 1130.32 0 0 1-125.99 7.36h-.06L305 241a24 24 0 0 0-34-34L64 414c.08-62.81 4-100.05 7-126.44C96.44 38.2 460.21 3.56 512 0c-1.81 26.26-11.71 132.86-53.62 234.79z", "M24 512a24 24 0 0 1-17-41l264-264a24 24 0 0 1 34 34L41 505a23.92 23.92 0 0 1-17 7z"]],
    "female": [256, 512, [], "f182", ["M64 64a64 64 0 1 1 64 64 64 64 0 0 1-64-64z", "M80 144h11.37a87.91 87.91 0 0 0 73.28 0H176a24 24 0 0 1 23.28 18.18l48 192A24 24 0 0 1 224 384h-56v104a24 24 0 0 1-24 24h-32a24 24 0 0 1-24-24V384H32a24 24 0 0 1-23.27-29.82l48-192A24 24 0 0 1 80 144z"]],
    "field-hockey": [640, 512, [], "f44c", ["M628 0h-67.3a11.57 11.57 0 0 0-8.4 3.6L479 76.9 592 190l44.5-44.6a12.3 12.3 0 0 0 3.5-8.5V12a12 12 0 0 0-12-12zM480.2 320a96 96 0 1 0 95.9 96 95.94 95.94 0 0 0-95.9-96z", "M0 319.2a190.68 190.68 0 0 1 56.2-135.8 79.94 79.94 0 0 1 113 113.1c-29.8 29.9 15.2 75.2 45.2 45.3l230.7-231 113 113.1-50.8 50.8c-99.6-19.1-187.4 68-168.1 168.5-14.9 14.8-61.3 68-147.4 68-106.2 0-191.8-86-191.8-192z"]],
    "fighter-jet": [640, 512, [], "f0fb", ["M168 192h176L227.16 44h39.51c11.66 0 21.33-2.62 21.33-6s-9.67-6-21.33-6H152v12h16zm0 128v148h-16v12h114.67c11.66 0 21.33-2.62 21.33-6s-9.67-6-21.33-6h-39.51L344 320z", "M640 256c0 5.42 0 10.67-96 32l-128 16-48 16H106.67l-53.34 64H18.67L8 373.33V304h8v-16h48v-2.67l-64-8v-42.66l64-8V224H16v-16H8v-69.33L18.67 128h34.66l53.34 64H368l48 16 128 16c96 21.33 96 26.58 96 32z"]],
    "file": [384, 512, [], "f15b", ["M256 0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128H272a16 16 0 0 1-16-16z", "M384 121.9v6.1H272a16 16 0 0 1-16-16V0h6.1a24 24 0 0 1 17 7l97.9 98a23.9 23.9 0 0 1 7 16.9z"]],
    "file-alt": [384, 512, [], "f15c", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zm-96 244a12 12 0 0 1-12 12H108a12 12 0 0 1-12-12v-8a12 12 0 0 1 12-12h168a12 12 0 0 1 12 12zm0-64a12 12 0 0 1-12 12H108a12 12 0 0 1-12-12v-8a12 12 0 0 1 12-12h168a12 12 0 0 1 12 12zm0-64a12 12 0 0 1-12 12H108a12 12 0 0 1-12-12v-8a12 12 0 0 1 12-12h168a12 12 0 0 1 12 12z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zM276 352H108a12 12 0 0 0-12 12v8a12 12 0 0 0 12 12h168a12 12 0 0 0 12-12v-8a12 12 0 0 0-12-12zm0-64H108a12 12 0 0 0-12 12v8a12 12 0 0 0 12 12h168a12 12 0 0 0 12-12v-8a12 12 0 0 0-12-12zm0-64H108a12 12 0 0 0-12 12v8a12 12 0 0 0 12 12h168a12 12 0 0 0 12-12v-8a12 12 0 0 0-12-12z"]],
    "file-archive": [384, 512, [], "f1c6", ["M272 128a16 16 0 0 1-16-16V0h-96v32h-32V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zM95.9 32h32v32h-32zm83.47 342.08a52.43 52.43 0 1 1-102.74-21L96 256v-32h32v-32H96v-32h32v-32H96V96h32V64h32v32h-32v32h32v32h-32v32h32v32h-32v32h22.33a12.08 12.08 0 0 1 11.8 9.7l17.3 87.7a52.54 52.54 0 0 1-.06 20.68z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zM127.9 32h-32v32h32zM96 160v32h32v-32zM160 0h-32v32h32zM96 96v32h32V96zm83.43 257.4l-17.3-87.7a12.08 12.08 0 0 0-11.8-9.7H128v-32H96v32l-19.37 97.1a52.43 52.43 0 1 0 102.8.3zm-51.1 36.6c-17.9 0-32.5-12-32.5-27s14.5-27 32.4-27 32.5 12.1 32.5 27-14.5 27-32.4 27zM160 192h-32v32h32zm0-64h-32v32h32zm0-64h-32v32h32z"]],
    "file-audio": [384, 512, [], "f1c7", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zM160 404a12 12 0 0 1-20.5 8.5L104 376H76a12 12 0 0 1-12-12v-56a12 12 0 0 1 12-12h28l35.5-36.48A12 12 0 0 1 160 268zm33.24-51.13a24.05 24.05 0 0 0 0-33.57c-22.08-22.91 12.2-56.48 34.38-33.66a72.64 72.64 0 0 1 0 100.9c-21.78 22.38-56.86-10.48-34.38-33.7zm86.2 83.66c-21.67 22.4-56.66-10.31-34.19-33.52a96.39 96.39 0 0 0 0-133.85c-22-22.81 12.22-56.32 34.19-33.51 54.08 55.87 54.08 144.94 0 200.85z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zM148 256a12 12 0 0 0-8.53 3.53L104 296H76a12 12 0 0 0-12 12v56a12 12 0 0 0 12 12h28l35.5 36.48A12 12 0 0 0 160 404V268a12 12 0 0 0-12-12zm79.59 29.61c-22.18-22.82-56.46 10.75-34.38 33.66a24.05 24.05 0 0 1 0 33.57c-22.48 23.22 12.6 56.08 34.38 33.67a72.64 72.64 0 0 0 .03-100.9zm51.82-50c-22-22.81-56.16 10.7-34.19 33.51a96.39 96.39 0 0 1 0 133.85c-22.47 23.21 12.52 55.92 34.19 33.52 54.08-55.91 54.08-145 0-200.88z"]],
    "file-certificate": [512, 512, [], "f5f3", ["M512 128v360.12A23.94 23.94 0 0 1 488 512H224v-91.19a61.78 61.78 0 0 0 35.49-41.11c.38-1.42.72-2.72 1-3.94.66-2.56 1.4-5.39 1.89-7 1.14-1.23 3.12-3.24 4.92-5.06l2.91-2.94A62.5 62.5 0 0 0 286 301.38c-.37-1.41-.72-2.71-1-3.92-.69-2.61-1.46-5.5-1.84-7.16.38-1.68 1.16-4.6 1.86-7.25.31-1.18.65-2.45 1-3.83a62.45 62.45 0 0 0-15.63-59.28l-2.76-2.81c-1.85-1.88-3.9-3.95-5.05-5.2-.49-1.64-1.23-4.51-1.91-7.1q-.47-1.8-1-3.9a61.69 61.69 0 0 0-43.13-43.7h-.11l-3.75-1c-2.44-.66-5.13-1.39-6.75-1.88-1.23-1.18-3.22-3.21-5-5.05-.84-.86-1.73-1.78-2.71-2.77a60.88 60.88 0 0 0-59.47-16.31h-.05l-3.77 1c-2.4.66-5 1.39-6.69 1.79V23.88A23.94 23.94 0 0 1 152 0h232v112a16 16 0 0 0 16 16z", "M505 105L407.1 7a24 24 0 0 0-17-7H384v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zM255 271.09a30.14 30.14 0 0 0-7.58-28.79c-14.86-15.12-13.42-12.61-18.86-33.3a29.57 29.57 0 0 0-20.71-21c-20.28-5.53-17.84-4.1-32.69-19.21a28.92 28.92 0 0 0-28.28-7.79c-20.32 5.54-17.46 5.53-37.75 0a28.94 28.94 0 0 0-28.28 7.71c-14.91 15.18-12.5 13.7-32.68 19.21A29.53 29.53 0 0 0 27.46 209c-5.46 20.74-4 18.13-18.87 33.27A30.15 30.15 0 0 0 1 271.09c5.45 20.71 5.42 17.79 0 38.41a30.12 30.12 0 0 0 7.58 28.78c14.86 15.11 13.42 12.61 18.88 33.27a29.52 29.52 0 0 0 20.71 21.07c14.3 3.9 11.52 3 15.83 5V512l64-32 64 32V397.63c4.31-2 1.52-1.1 15.84-5a29.53 29.53 0 0 0 20.7-21.07c5.47-20.74 4-18.13 18.88-33.27a30.12 30.12 0 0 0 7.58-28.78c-5.43-20.65-5.44-17.74 0-38.42zM128 352a64 64 0 1 1 64-64 64 64 0 0 1-64 64z"]],
    "file-chart-line": [384, 512, [], "f659", ["M272 128a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zM128 435.2c0 6.4-6.4 12.8-12.8 12.8H76.8c-6.4 0-12.8-6.4-12.8-12.8v-70.4c0-6.4 6.4-12.8 12.8-12.8h38.4c6.4 0 12.8 6.4 12.8 12.8zm96 0c0 6.4-6.4 12.8-12.8 12.8h-38.4c-6.4 0-12.8-6.4-12.8-12.8V236.8c0-6.4 6.4-12.8 12.8-12.8h38.4c6.4 0 12.8 6.4 12.8 12.8zm96 0c0 6.4-6.4 12.8-12.8 12.8h-38.4c-6.4 0-12.8-6.4-12.8-12.8V300.8c0-6.4 6.4-12.8 12.8-12.8h38.4c6.4 0 12.8 6.4 12.8 12.8z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zM115.2 352H76.8c-6.4 0-12.8 6.4-12.8 12.8v70.4c0 6.4 6.4 12.8 12.8 12.8h38.4c6.4 0 12.8-6.4 12.8-12.8v-70.4c0-6.4-6.4-12.8-12.8-12.8zm96-128h-38.4c-6.4 0-12.8 6.4-12.8 12.8v198.4c0 6.4 6.4 12.8 12.8 12.8h38.4c6.4 0 12.8-6.4 12.8-12.8V236.8c0-6.4-6.4-12.8-12.8-12.8zm96 64h-38.4c-6.4 0-12.8 6.4-12.8 12.8v134.4c0 6.4 6.4 12.8 12.8 12.8h38.4c6.4 0 12.8-6.4 12.8-12.8V300.8c0-6.4-6.4-12.8-12.8-12.8z"]],
    "file-chart-pie": [384, 512, [], "f65a", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zM136.47 438.5a111.26 111.26 0 0 1-63-63c-30-77.36 17.44-150.7 86.53-164.84V352h141.34c-14.14 69.09-87.48 116.58-164.87 86.5zM192 320V199.86A120.12 120.12 0 0 1 312.14 320z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zM160 210.66C90.91 224.8 43.42 298.14 73.47 375.5a111.26 111.26 0 0 0 63 63c77.39 30.08 150.73-17.41 164.87-86.5H160z"]],
    "file-check": [384, 512, [], "f316", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zm-70.7 158.67l-143 141.81a12 12 0 0 1-17 0l-82.6-83.31a12 12 0 0 1 .07-17L99.17 300a12 12 0 0 1 17 0l46 46.35 106-105.18a12 12 0 0 1 17 0l28.17 28.4a12 12 0 0 1-.04 17.1z", "M285.17 241.3a12 12 0 0 0-17 0l-106 105.18-46-46.35a12 12 0 0 0-17 0l-28.4 28.2a12 12 0 0 0-.07 17l82.57 83.27a12 12 0 0 0 17 0l143-141.81a12 12 0 0 0 0-17zM377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9z"]],
    "file-code": [384, 512, [], "f1c9", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zM141.79 379.54l-19.58 20.84a5.41 5.41 0 0 1-7.64.24l-64.86-60.69a5.37 5.37 0 0 1-.24-7.6l.25-.25 64.86-60.7a5.42 5.42 0 0 1 7.64.24l19.58 20.85a5.4 5.4 0 0 1-.25 7.62l-.13.12L100.65 336l40.76 35.8a5.4 5.4 0 0 1 .49 7.62zm31.71 71.25l-27.45-8a5.38 5.38 0 0 1-3.67-6.67l61.49-211.24a5.38 5.38 0 0 1 6.68-3.64l27.45 8a5.4 5.4 0 0 1 3.63 6.67l-61.45 211.2a5.4 5.4 0 0 1-6.68 3.68zm161-111.12l-.25.25-64.86 60.69a5.42 5.42 0 0 1-7.64-.23l-19.58-20.84a5.37 5.37 0 0 1 .26-7.6l.13-.12L283.35 336l-40.76-35.8a5.4 5.4 0 0 1-.49-7.62l.11-.12 19.58-20.85a5.42 5.42 0 0 1 7.64-.24l64.86 60.7a5.36 5.36 0 0 1 .25 7.6z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zM141.41 371.8L100.65 336l40.76-35.8.13-.12a5.4 5.4 0 0 0 .25-7.62l-19.58-20.85a5.42 5.42 0 0 0-7.64-.24l-64.86 60.7-.25.25a5.37 5.37 0 0 0 .24 7.6l64.86 60.69a5.41 5.41 0 0 0 7.64-.24l19.58-20.84.11-.12a5.4 5.4 0 0 0-.48-7.61zm100.22-135.93a5.4 5.4 0 0 0-3.63-6.67l-27.45-8a5.38 5.38 0 0 0-6.68 3.64l-61.5 211.29a5.38 5.38 0 0 0 3.63 6.67l27.45 8a5.4 5.4 0 0 0 6.68-3.68l61.44-211.22zm92.66 96.2l-64.86-60.7a5.42 5.42 0 0 0-7.64.24l-19.58 20.85-.11.12a5.4 5.4 0 0 0 .49 7.62l40.76 35.8-40.76 35.8-.13.12a5.37 5.37 0 0 0-.26 7.6l19.58 20.84a5.42 5.42 0 0 0 7.64.23l64.86-60.69.25-.25a5.36 5.36 0 0 0-.25-7.6z"]],
    "file-contract": [384, 512, [], "f56c", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zM64 72a8 8 0 0 1 8-8h80a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8H72a8 8 0 0 1-8-8zm0 64a8 8 0 0 1 8-8h80a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8H72a8 8 0 0 1-8-8zm240 280h-47.19a43 43 0 0 1-38.64-23.86 11.08 11.08 0 0 0-10.17-6.52 10.91 10.91 0 0 0-10 6.19l-7.67 15.34A16 16 0 0 1 176 416a8.77 8.77 0 0 1-1.14-.05 16 16 0 0 1-14-10.89L144 354.59l-10.61 31.88a43.17 43.17 0 0 1-41 29.53H80a16 16 0 0 1 0-32h12.39a11.21 11.21 0 0 0 10.61-7.66l18.19-54.64a24 24 0 0 1 45.55 0l13.88 41.64c19.8-16.19 54.08-9.7 66 14.16a11.39 11.39 0 0 0 10.16 6.5H304a16 16 0 0 1 0 32z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zm-73 279h-47.19a11.39 11.39 0 0 1-10.16-6.5c-12-23.86-46.23-30.35-66-14.16l-13.91-41.64a24 24 0 0 0-45.55 0L103 376.34A11.21 11.21 0 0 1 92.39 384H80a16 16 0 0 0 0 32h12.39a43.17 43.17 0 0 0 41-29.53L144 354.59l16.86 50.47a16 16 0 0 0 14 10.89 8.77 8.77 0 0 0 1.14.05 16 16 0 0 0 14.33-8.85l7.67-15.34a10.91 10.91 0 0 1 10-6.19 11.08 11.08 0 0 1 10.17 6.52A43 43 0 0 0 256.81 416H304a16 16 0 0 0 0-32z"]],
    "file-csv": [384, 512, [], "f6dd", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zM128 280a8 8 0 0 1-8 8h-8a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h8a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8h-8a48 48 0 0 1-48-48v-32a48 48 0 0 1 48-48h8a8 8 0 0 1 8 8zm44.27 104H160a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h12.27c5.95 0 10.41-3.5 10.41-6.62a5.28 5.28 0 0 0-2.12-3.84l-21.89-18.77a37.11 37.11 0 0 1-13.33-28.14c0-21.3 19-38.62 42.41-38.62H200a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8h-12.27c-5.95 0-10.41 3.5-10.41 6.62a5.28 5.28 0 0 0 2.12 3.84l21.89 18.77a37.12 37.12 0 0 1 13.33 28.13c.01 21.29-19 38.63-42.39 38.63zM320 284.8c0 35.48-12.88 68.89-36.28 94.09-.27.29-.54.56-.83.83a16 16 0 0 1-22.61-.83c-23.4-25.2-36.28-58.61-36.28-94.09V264a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v20.8a109 109 0 0 0 16 56.88 109 109 0 0 0 16-56.88V264a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zM120 256h-8a48 48 0 0 0-48 48v32a48 48 0 0 0 48 48h8a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8h-8a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h8a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zm192 0h-16a8 8 0 0 0-8 8v20.8a109 109 0 0 1-16 56.88 109 109 0 0 1-16-56.88V264a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v20.8c0 35.48 12.88 68.89 36.28 94.09a16 16 0 0 0 22.61.83c.29-.27.56-.54.83-.83 23.4-25.2 36.28-58.61 36.28-94.09V264a8 8 0 0 0-8-8zm-110.67 61.24l-21.89-18.77a5.28 5.28 0 0 1-2.12-3.84c0-3.12 4.46-6.62 10.41-6.62H200a8 8 0 0 0 8-8V264a8 8 0 0 0-8-8h-12.25c-23.39 0-42.41 17.32-42.41 38.62a37.11 37.11 0 0 0 13.33 28.14l21.89 18.77a5.28 5.28 0 0 1 2.12 3.84c0 3.12-4.46 6.62-10.41 6.62H160a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h12.27c23.39 0 42.4-17.33 42.39-38.62a37.12 37.12 0 0 0-13.33-28.13z"]],
    "file-download": [384, 512, [], "f56d", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zm-83.55 219.36L204 443.06a17.06 17.06 0 0 1-24 0l-96.42-95.7C73.42 337.29 80.54 320 94.82 320H160v-80a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v80h65.18c14.28 0 21.4 17.29 11.27 27.36z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zm-87.82 215H224v-80a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v80H94.82c-14.28 0-21.4 17.29-11.24 27.36l96.42 95.7a17.06 17.06 0 0 0 24 0l96.45-95.7c10.13-10.07 3.01-27.36-11.27-27.36z"]],
    "file-edit": [384, 512, [], "f31c", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zM242.4 323.6l-95 95-48.2 5.4a9.93 9.93 0 0 1-2.2 0 10.17 10.17 0 0 1-9-11.2l5.4-48.2 95-95a5.07 5.07 0 0 1 7.17 0l46.8 46.8a5.07 5.07 0 0 1 .03 7.2zm55.7-55.7l-26 26a5.07 5.07 0 0 1-7.17 0l-46.8-46.8a5.07 5.07 0 0 1 0-7.17l26-26a20.22 20.22 0 0 1 28.6 0l25.4 25.4a20.22 20.22 0 0 1-.03 28.57z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zM242.4 316.4l-46.8-46.8a5.07 5.07 0 0 0-7.17 0l-95 95L88 412.8a10.17 10.17 0 0 0 9 11.2 9.93 9.93 0 0 0 2.18 0l48.2-5.4 95-95a5.07 5.07 0 0 0 0-7.17zm55.7-77.1l-25.4-25.4a20.22 20.22 0 0 0-28.6 0l-26 26a5.07 5.07 0 0 0 0 7.17l46.8 46.8a5.07 5.07 0 0 0 7.17 0l26-26a20.22 20.22 0 0 0 0-28.6z"]],
    "file-excel": [384, 512, [], "f1c3", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zM280.51 446.09A12 12 0 0 1 274 448h-34.9a12 12 0 0 1-10.6-6.3C208.9 405.5 192 373 192 373c-6.4 14.8-10 20-36.6 68.8a11.89 11.89 0 0 1-10.5 6.3H110a12 12 0 0 1-10.1-18.5l60.3-93.5-60.3-93.5a12 12 0 0 1 10.1-18.5h34.8a12 12 0 0 1 10.6 6.3c26.1 48.8 20 33.6 36.6 68.5 0 0 6.1-11.7 36.6-68.5a12 12 0 0 1 10.6-6.3H274a11.93 11.93 0 0 1 10.1 18.4L224 336l60.1 93.5a12 12 0 0 1-3.59 16.59z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zM224 336l60.1-93.5a11.93 11.93 0 0 0-10.1-18.4h-34.8a12 12 0 0 0-10.6 6.3c-30.5 56.8-36.6 68.5-36.6 68.5-16.6-34.9-10.5-19.7-36.6-68.5a12 12 0 0 0-10.6-6.3H110a12 12 0 0 0-10.1 18.5l60.3 93.5-60.3 93.5a12 12 0 0 0 10.1 18.5h34.9a11.89 11.89 0 0 0 10.5-6.3c26.6-48.8 30.2-54 36.6-68.8 0 0 16.9 32.5 36.5 68.7a12 12 0 0 0 10.6 6.3H274a12 12 0 0 0 10.1-18.5z"]],
    "file-exclamation": [384, 512, [], "f31a", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zm-219.2 80h55.23a12 12 0 0 1 11.17 12.8l-7.2 112a12 12 0 0 1-12 11.2h-40a12 12 0 0 1-12-11.2l-7.2-112v-.83a12 12 0 0 1 12-11.97zM192 440a40 40 0 1 1 40-40 40 40 0 0 1-40 40z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zM160 332.8a12 12 0 0 0 12 11.2h40a12 12 0 0 0 12-11.2l7.2-112A12 12 0 0 0 220 208h-55.2a12 12 0 0 0-12 12v.83zm32 27.2a40 40 0 1 0 40 40 40 40 0 0 0-40-40z"]],
    "file-export": [576, 512, [], "f56e", ["M384 352.05v136.07A23.94 23.94 0 0 1 360 512H23.88A23.94 23.94 0 0 1 0 488V23.88A23.94 23.94 0 0 1 24 0h232v112a16 16 0 0 0 16 16h112v160.05H208a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16z", "M272 128h112v-6.1a23.9 23.9 0 0 0-7-16.9L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16zm299 180.05l-95.61-96.5c-10.1-10.1-27.41-3-27.41 11.3v65.2H208a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h239.93v65.1c0 14.3 17.31 21.4 27.41 11.3l95.71-96.4a17 17 0 0 0-.05-24z"]],
    "file-image": [384, 512, [], "f1c5", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zm-271.46 48a48 48 0 1 1-48 48 48 48 0 0 1 48-48zm208 240h-256l.46-48.48L104.51 328c4.69-4.69 11.8-4.2 16.49.48L160.54 368 264 264.48a12 12 0 0 1 17 0L320.54 304z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zM112.54 272a48 48 0 1 0-48-48 48 48 0 0 0 48 48zM264 264.45L160.54 368 121 328.48c-4.69-4.68-11.8-5.17-16.49-.48L65 367.52 64.54 416h256V304L281 264.48a12 12 0 0 0-17-.03z"]],
    "file-import": [512, 512, [], "f56f", ["M512 488v.12A23.94 23.94 0 0 1 488 512H151.88A23.94 23.94 0 0 1 128 488V352h127.63v64.9c0 14.27 17.28 21.34 27.37 11.27L378.56 332a17 17 0 0 0 0-23.93l-95.49-96.25c-10.09-10.07-27.37-3-27.37 11.27v65H128V23.88A23.94 23.94 0 0 1 152 0h232v112a16 16 0 0 0 16 16h112z", "M505 105L407.1 7a24 24 0 0 0-17-7H384v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zM283.07 211.82c-10.09-10.07-27.37-3-27.37 11.27v65H16a16 16 0 0 0-16 16V336a16 16 0 0 0 16 16h239.63v64.9c0 14.27 17.28 21.34 27.37 11.27L378.56 332a17 17 0 0 0 0-23.93z"]],
    "file-invoice": [384, 512, [], "f570", ["M96 320h192v-64H96zm288-192H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zM64 72a8 8 0 0 1 8-8h80a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8H72a8 8 0 0 1-8-8zm0 64a8 8 0 0 1 8-8h80a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8H72a8 8 0 0 1-8-8zm256 304a8 8 0 0 1-8 8h-80a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h80a8 8 0 0 1 8 8zm0-104a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16v-96a16 16 0 0 1 16-16h224a16 16 0 0 1 16 16z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zm-73 119H80a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h224a16 16 0 0 0 16-16v-96a16 16 0 0 0-16-16zm-16 96H96v-64h192zm24 96h-80a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h80a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8z"]],
    "file-invoice-dollar": [384, 512, [], "f571", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zM64 72a8 8 0 0 1 8-8h80a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8H72a8 8 0 0 1-8-8zm0 80v-16a8 8 0 0 1 8-8h80a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8H72a8 8 0 0 1-8-8zm144 263.88V440a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-24.29a57.32 57.32 0 0 1-31.37-11.35 8 8 0 0 1-.57-12.14L155.81 381a8.22 8.22 0 0 1 10.13-.73 24.06 24.06 0 0 0 12.82 3.73h28.11c6.5 0 11.8-5.92 11.8-13.19 0-5.95-3.61-11.19-8.77-12.73l-45-13.5c-18.59-5.58-31.58-23.42-31.58-43.39 0-24.52 19.05-44.44 42.67-45.07V232a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v24.29a57.17 57.17 0 0 1 31.37 11.35 8 8 0 0 1 .57 12.14L228.18 291a8.22 8.22 0 0 1-10.13.73 24 24 0 0 0-12.82-3.73h-28.11c-6.5 0-11.8 5.92-11.8 13.19 0 5.95 3.61 11.19 8.77 12.73l45 13.5c18.59 5.58 31.58 23.42 31.58 43.39 0 24.53-19 44.44-42.67 45.07z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zM219.09 327.42l-45-13.5c-5.16-1.54-8.77-6.78-8.77-12.73 0-7.27 5.3-13.19 11.8-13.19h28.11a24 24 0 0 1 12.82 3.73 8.22 8.22 0 0 0 10.13-.73l11.76-11.22a8 8 0 0 0-.57-12.14A57.17 57.17 0 0 0 208 256.29V232a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v24.12c-23.62.63-42.67 20.55-42.67 45.07 0 20 13 37.81 31.58 43.39l45 13.5c5.16 1.54 8.77 6.78 8.77 12.73 0 7.27-5.3 13.19-11.8 13.19h-28.12a24.06 24.06 0 0 1-12.82-3.73 8.22 8.22 0 0 0-10.13.73l-11.75 11.22a8 8 0 0 0 .57 12.14A57.32 57.32 0 0 0 176 415.71V440a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-24.12c23.67-.63 42.67-20.54 42.67-45.07 0-19.97-12.99-37.81-31.58-43.39z"]],
    "file-medical": [384, 512, [], "f477", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zm-96 216a8 8 0 0 1-8 8h-56v56a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-56h-56a8 8 0 0 1-8-8v-48a8 8 0 0 1 8-8h56v-56a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8v56h56a8 8 0 0 1 8 8z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zm-97 183h-56v-56a8 8 0 0 0-8-8h-48a8 8 0 0 0-8 8v56h-56a8 8 0 0 0-8 8v48a8 8 0 0 0 8 8h56v56a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8v-56h56a8 8 0 0 0 8-8v-48a8 8 0 0 0-8-8z"]],
    "file-medical-alt": [448, 512, [], "f478", ["M448 488v.12A23.94 23.94 0 0 1 424 512H87.88A23.94 23.94 0 0 1 64 488V320h70.1l34.8 69.5a8 8 0 0 0 14.3 0L240 275.8l22.1 44.2h89.48a16.27 16.27 0 0 0 16.3-14 16.82 16.82 0 0 0 .13-2 16 16 0 0 0-16-16H281.8l-34.7-69.5a8 8 0 0 0-14.3 0L176 332.2l-19.9-39.8a8.14 8.14 0 0 0-7.2-4.4H64V23.88A23.94 23.94 0 0 1 88 0h232v112a16 16 0 0 0 16 16h112z", "M441 105L343.1 7a24 24 0 0 0-17-7H320v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zm-89 183h-70.2l-34.7-69.5a8 8 0 0 0-14.3 0L176 332.2l-19.9-39.8a8.14 8.14 0 0 0-7.2-4.4H8a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h126.1l34.8 69.5a8 8 0 0 0 14.3 0L240 275.8l22.1 44.2h89.48a16.27 16.27 0 0 0 16.3-14 16.82 16.82 0 0 0 .13-2A16 16 0 0 0 352 288z"]],
    "file-minus": [384, 512, [], "f318", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zm-88 212a12 12 0 0 1-12 12H100a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h184a12 12 0 0 1 12 12z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zm-93 183H100a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h184a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12z"]],
    "file-music": [384, 512, [], "f8b6", ["M377 105L279.09 7a24 24 0 0 0-17-7H256v128h128v-6.09a23.91 23.91 0 0 0-7-16.91zm-153 31V0H24A23.94 23.94 0 0 0 0 24v464a23.94 23.94 0 0 0 24 24h336a23.94 23.94 0 0 0 24-24V160H248a24.08 24.08 0 0 1-24-24zm64 88v160c0 17.67-21.5 32-48 32s-48-14.33-48-32 21.5-32 48-32a69.82 69.82 0 0 1 16 2v-76.36l-96 37.52V416c0 17.67-21.5 32-48 32s-48-14.33-48-32 21.5-32 48-32a69.82 69.82 0 0 1 16 2V271.25A16 16 0 0 1 139.19 256l128-47.25A16 16 0 0 1 288 224z", "M288 224v160c0 17.67-21.5 32-48 32s-48-14.33-48-32 21.5-32 48-32a69.82 69.82 0 0 1 16 2v-76.36l-96 37.52V416c0 17.67-21.5 32-48 32s-48-14.33-48-32 21.5-32 48-32a69.82 69.82 0 0 1 16 2V271.25A16 16 0 0 1 139.19 256l128-47.25A16 16 0 0 1 288 224z"]],
    "file-pdf": [384, 512, [], "f1c1", ["M86.1 428.1c0 .8 13.2-5.4 34.9-40.2-6.7 6.3-29.1 24.5-34.9 40.2zm93.8-218.9c-2.9 0-3 30.9 2 46.9 5.6-10 6.4-46.9-2-46.9zm80.2 142.1c37.1 15.8 42.8 9 42.8 9 4.1-2.7-2.5-11.9-42.8-9zm-79.9-48c-7.7 20.2-17.3 43.3-28.4 62.7 18.3-7 39-17.2 62.9-21.9-12.7-9.6-24.9-23.4-34.5-40.8zM272 128a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zm21.9 254.4c-16.9 0-42.3-7.7-64-19.5-24.9 4.1-53.2 14.7-79 23.2-25.4 43.8-43.2 61.8-61.1 61.8-5.5 0-15.9-3.1-21.5-10-19.1-23.5 27.4-54.1 54.5-68 .1 0 .1-.1.2-.1 12.1-21.2 29.2-58.2 40.8-85.8-8.5-32.9-13.1-58.7-8.1-77 5.4-19.7 43.1-22.6 47.8 6.8 5.4 17.6-1.7 45.7-6.2 64.2 9.4 24.8 22.7 41.6 42.7 53.8 19.3-2.5 59.7-6.4 73.6 7.2 11.5 11.4 9.5 43.4-19.7 43.4z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zM240 331.8c-20-12.2-33.3-29-42.7-53.8 4.5-18.5 11.6-46.6 6.2-64.2-4.7-29.4-42.4-26.5-47.8-6.8-5 18.3-.4 44.1 8.1 77-11.6 27.6-28.7 64.6-40.8 85.8-.1 0-.1.1-.2.1-27.1 13.9-73.6 44.5-54.5 68 5.6 6.9 16 10 21.5 10 17.9 0 35.7-18 61.1-61.8 25.8-8.5 54.1-19.1 79-23.2 21.7 11.8 47.1 19.5 64 19.5 29.2 0 31.2-32 19.7-43.4-13.9-13.6-54.3-9.7-73.6-7.2zM86.1 428.1c5.8-15.7 28.2-33.9 34.9-40.2-21.7 34.8-34.9 41-34.9 40.2zm93.8-218.9c8.4 0 7.6 36.9 2 46.9-5-16-4.9-46.9-2-46.9zM151.8 366c11.1-19.4 20.7-42.5 28.4-62.7 9.6 17.4 21.8 31.2 34.5 40.8-23.9 4.7-44.6 14.9-62.9 21.9zm151.1-5.7s-5.7 6.8-42.8-9c40.3-2.9 46.9 6.3 42.8 9z"]],
    "file-plus": [384, 512, [], "f319", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zm-88 212a12 12 0 0 1-12 12h-60v60a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-60h-60a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h60v-60a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12v60h60a12 12 0 0 1 12 12z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zm-93 183h-60v-60a12 12 0 0 0-12-12h-40a12 12 0 0 0-12 12v60h-60a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h60v60a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-60h60a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12z"]],
    "file-powerpoint": [384, 512, [], "f1c4", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zM165.9 378.8V436a12 12 0 0 1-12 12h-30.8a12 12 0 0 1-12-12V236.2a12 12 0 0 1 12-12h81c44.5 0 72.9 32.8 72.9 77 0 90.3-88.8 77.6-111.1 77.6zm27.8-107.6h-27.9v60.7h26.9c9.2 0 16.2-2.9 21.1-8.5 10-11.4 9.8-33.2.2-44.1-4.8-5.4-11.5-8.1-20.3-8.1z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zM204.1 224.2h-81a12 12 0 0 0-12 12V436a12 12 0 0 0 12 12h30.8a12 12 0 0 0 12-12v-57.2c22.3 0 111.1 12.7 111.1-77.6 0-44.2-28.4-77-72.9-77zm9.7 99.2c-4.9 5.6-11.9 8.5-21.1 8.5h-26.9v-60.7h27.9c8.8 0 15.5 2.7 20.3 8.1 9.6 10.9 9.8 32.7-.2 44.1z"]],
    "file-prescription": [384, 512, [], "f572", ["M176 240h-48v32h48a16 16 0 0 0 0-32zm96-112a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zm32 304l-11.31 11.32a16 16 0 0 1-22.63 0L240 413.25l-30.06 30.06a16 16 0 0 1-22.63 0L176 432a16 16 0 0 1 0-22.63l30.06-30.06L146.74 320H128v48a16 16 0 0 1-16 16H96a16 16 0 0 1-16-16V208a16 16 0 0 1 16-16h80a63.8 63.8 0 0 1 30.54 119.92L240 345.38l29.9-29.9a16 16 0 0 1 22.63 0l11.31 11.31a16 16 0 0 1 0 22.63l-29.9 29.9L304 409.38a16 16 0 0 1 0 22.62z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zM273.94 379.32l29.9-29.9a16 16 0 0 0 0-22.63l-11.31-11.31a16 16 0 0 0-22.63 0l-29.9 29.9-33.46-33.46A63.8 63.8 0 0 0 176 192H96a16 16 0 0 0-16 16v160a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16v-48h18.74l59.32 59.31L176 409.37a16 16 0 0 0 0 22.63l11.31 11.31a16 16 0 0 0 22.63 0L240 413.25l30.06 30.07a16 16 0 0 0 22.63 0L304 432a16 16 0 0 0 0-22.62zM176 272h-48v-32h48a16 16 0 0 1 0 32z"]],
    "file-search": [640, 512, [], "f865", ["M300.59 257.71a160.1 160.1 0 0 0 83.41 209v21.45A23.94 23.94 0 0 1 360 512H23.88A23.94 23.94 0 0 1 0 488V23.88A23.94 23.94 0 0 1 24 0h232v112a16 16 0 0 0 16 16h112v45.33a160.34 160.34 0 0 0-83.41 84.38z", "M384 121.9a23.9 23.9 0 0 0-7-16.9L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112zm251.31 340.16l-77.41-77.41A126.65 126.65 0 0 0 576 320a128 128 0 1 0-128 128c23.7 0 45.61-6.88 64.65-18.11l77.41 77.42a16 16 0 0 0 22.63 0l22.62-22.62a16 16 0 0 0 0-22.63zM448 384a64 64 0 1 1 64-64 64 64 0 0 1-64 64z"]],
    "file-signature": [576, 512, [], "f573", ["M64 400a16 16 0 0 0 16 16h12.39a43.17 43.17 0 0 0 41-29.53L144 354.59l16.83 50.47c4.45 13.46 23.11 14.87 29.48 2.09l7.69-15.34a10.91 10.91 0 0 1 10-6.19 11.08 11.08 0 0 1 10.17 6.52A43 43 0 0 0 256 416h101l27-27.19v99.31A23.94 23.94 0 0 1 360 512H23.88A23.94 23.94 0 0 1 0 488V23.88A23.94 23.94 0 0 1 24 0h232v112a16 16 0 0 0 16 16h112v123.67L288 347v37h-32a11.63 11.63 0 0 1-9.35-6.5c-11.94-23.86-46.25-30.35-66-14.16l-13.88-41.64a24 24 0 0 0-45.55 0L103 376.34A11.21 11.21 0 0 1 92.39 384H80a16 16 0 0 0-16 16z", "M384 121.9a23.9 23.9 0 0 0-7-16.9L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112zM288 347v69h69l161.67-162.78-67.88-67.88zm280.56-179.65l-31.87-31.87a25.48 25.48 0 0 0-36 0l-27.25 27.25 67.88 67.88 27.25-27.25a25.45 25.45 0 0 0-.01-36.01z"]],
    "file-spreadsheet": [384, 512, [], "f65b", ["M272 128a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zm56 304a16 16 0 0 1-16 16H72a16 16 0 0 1-16-16V240a16 16 0 0 1 16-16h240a16 16 0 0 1 16 16z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zm-65 119H72a16 16 0 0 0-16 16v192a16 16 0 0 0 16 16h240a16 16 0 0 0 16-16V240a16 16 0 0 0-16-16zM136 416H88v-48h48zm0-80H88v-48h48zm80 80h-48v-48h48zm0-80h-48v-48h48zm80 80h-48v-48h48zm0-80h-48v-48h48z"]],
    "file-times": [384, 512, [], "f317", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zm-98.6 240.1a12 12 0 0 1 0 17l-28.3 28.3a12 12 0 0 1-17 0L192 365.3l-48.1 48.1a12 12 0 0 1-17 0l-28.3-28.3a12 12 0 0 1 0-17l48.1-48.1-48.1-48.1a12 12 0 0 1 0-17l28.3-28.3a12 12 0 0 1 17 0l48.1 48.1 48.1-48.1a12 12 0 0 1 17 0l28.3 28.3a12 12 0 0 1 0 17L237.3 320z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zm-91.57 166.87a12 12 0 0 0 0-17l-28.3-28.3a12 12 0 0 0-17 0L192 274.7l-48.1-48.1a12 12 0 0 0-17 0l-28.3 28.3a12 12 0 0 0 0 17l48.1 48.1-48.1 48.1a12 12 0 0 0 0 17l28.3 28.3a12 12 0 0 0 17 0l48.1-48.1 48.1 48.1a12 12 0 0 0 17 0l28.33-28.33a12 12 0 0 0 0-17L237.3 320l48.1-48.1z"]],
    "file-upload": [384, 512, [], "f574", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zm-94.82 224H224v80a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-80H94.82c-14.28 0-21.41-17.29-11.27-27.36L180 229a17.06 17.06 0 0 1 24 0l96.43 95.65c10.15 10.07 3 27.35-11.25 27.35z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zM204 229a17.06 17.06 0 0 0-24 0l-96.45 95.64C73.41 334.71 80.54 352 94.82 352H160v80a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-80h65.18c14.25 0 21.4-17.29 11.25-27.36z"]],
    "file-user": [384, 512, [], "f65c", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zm-192 64a64 64 0 1 1-64 64 64 64 0 0 1 64-64zm112 236.8c0 10.61-10 19.2-22.4 19.2H102.4C90 448 80 439.4 80 428.8v-19.2c0-31.81 30.09-57.6 67.1-57.6h5a103.22 103.22 0 0 0 79.7 0h5c37.11 0 67.2 25.79 67.2 57.6z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zM192 320a64 64 0 1 0-64-64 64 64 0 0 0 64 64zm44.8 32h-5a103.22 103.22 0 0 1-79.7 0h-5c-37 0-67.1 25.79-67.1 57.6v19.2c0 10.6 10 19.2 22.4 19.2h179.2c12.37 0 22.4-8.59 22.4-19.2v-19.2c0-31.81-30.09-57.6-67.2-57.6z"]],
    "file-video": [384, 512, [], "f1c8", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zm-64 264c0 21.44-25.94 32-41 17l-55-55v38a24 24 0 0 1-24 24H88a24 24 0 0 1-24-24V280a24 24 0 0 1 24-24h112a24 24 0 0 1 24 24v38.06l55-55c15-15.06 41-4.5 41 16.94z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zm-98 158.06l-55 55V280a24 24 0 0 0-24-24H88a24 24 0 0 0-24 24v112a24 24 0 0 0 24 24h112a24 24 0 0 0 24-24v-38l55 55c15.06 15 41 4.44 41-17V280c0-21.44-26-32-41-16.94z"]],
    "file-word": [384, 512, [], "f1c2", ["M384 128H272a16 16 0 0 1-16-16V0H24A23.94 23.94 0 0 0 0 23.88V488a23.94 23.94 0 0 0 23.88 24H360a23.94 23.94 0 0 0 24-23.88V128zm-67.3 142.7l-38 168A11.9 11.9 0 0 1 267 448h-38a12 12 0 0 1-11.6-9.1c-25.8-103.5-20.8-81.2-25.6-110.5h-.5c-1.1 14.3-2.4 17.4-25.6 110.5a12 12 0 0 1-11.6 9.1H117a12 12 0 0 1-11.7-9.4l-37.8-168A12 12 0 0 1 79.2 256h24.5a12 12 0 0 1 11.8 9.7c15.6 78 20.1 109.5 21 122.2 1.6-10.2 7.3-32.7 29.4-122.7a11.9 11.9 0 0 1 11.7-9.1h29.1a12 12 0 0 1 11.7 9.2c24 100.4 28.8 124 29.6 129.4-.2-11.2-2.6-17.8 21.6-129.2a11.59 11.59 0 0 1 11.5-9.5H305a12 12 0 0 1 12 12 11.8 11.8 0 0 1-.3 2.7z", "M377 105L279.1 7a24 24 0 0 0-17-7H256v112a16 16 0 0 0 16 16h112v-6.1a23.9 23.9 0 0 0-7-16.9zm-72 151h-23.9a11.59 11.59 0 0 0-11.5 9.5c-24.2 111.4-21.8 118-21.6 129.2-.8-5.4-5.6-29-29.6-129.4a12 12 0 0 0-11.7-9.2h-29.1a11.9 11.9 0 0 0-11.7 9.1c-22.1 90-27.8 112.5-29.4 122.7-.9-12.7-5.4-44.2-21-122.2a12 12 0 0 0-11.8-9.7H79.2a12 12 0 0 0-11.7 14.6l37.8 168A12 12 0 0 0 117 448h37.1a12 12 0 0 0 11.6-9.1c23.2-93.1 24.5-96.2 25.6-110.5h.5c4.8 29.3-.2 7 25.6 110.5A12 12 0 0 0 229 448h38a11.9 11.9 0 0 0 11.7-9.3l38-168a11.8 11.8 0 0 0 .3-2.7 12 12 0 0 0-12-12z"]],
    "files-medical": [448, 512, [], "f7fd", ["M352 96V0H152a24 24 0 0 0-24 24v368a24 24 0 0 0 24 24h272a24 24 0 0 0 24-24V96zm32 184a8 8 0 0 1-8 8h-56v56a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-56h-56a8 8 0 0 1-8-8v-48a8 8 0 0 1 8-8h56v-56a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8v56h56a8 8 0 0 1 8 8z", "M96 392V96H24a24 24 0 0 0-24 24v368a24 24 0 0 0 24 24h272a24 24 0 0 0 24-24v-40H152a56.06 56.06 0 0 1-56-56zm280-168h-56v-56a8 8 0 0 0-8-8h-48a8 8 0 0 0-8 8v56h-56a8 8 0 0 0-8 8v48a8 8 0 0 0 8 8h56v56a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8v-56h56a8 8 0 0 0 8-8v-48a8 8 0 0 0-8-8zm65-151L375 7a24 24 0 0 0-17-7h-6v96h96v-6.06A24 24 0 0 0 441 73z"]],
    "fill": [512, 512, [], "f575", ["M386.39 288L235.78 438.61a32 32 0 0 1-45.22 0L73.37 321.4A31.86 31.86 0 0 1 64 298.78 32.59 32.59 0 0 1 65.87 288z", "M502.63 217L294.94 9.34a32 32 0 0 0-45.25 0l-81.58 81.58L81.93 4.73a16 16 0 0 0-22.62 0L36.69 27.35a16 16 0 0 0 0 22.62l86.19 86.18-94.76 94.76a96 96 0 0 0 0 135.75l117.19 117.19a96 96 0 0 0 135.74 0l221.57-221.57a32 32 0 0 0 .01-45.28zM235.78 438.61a32 32 0 0 1-45.22 0L73.37 321.4a32 32 0 0 1 0-45.24l94.75-94.74 58.6 58.58A32 32 0 0 0 272 194.77l-58.6-58.6 58.92-58.93 162.42 162.41z"]],
    "fill-drip": [576, 512, [], "f576", ["M387.39 288L236.78 438.61a32 32 0 0 1-45.22 0L74.37 321.4A31.86 31.86 0 0 1 65 298.78 32.59 32.59 0 0 1 66.87 288zM512 320s-64 92.65-64 128a64 64 0 0 0 128 0c0-35.35-64-128-64-128z", "M503.63 217L295.94 9.34a32 32 0 0 0-45.25 0l-81.58 81.58L82.93 4.73a16 16 0 0 0-22.62 0L37.69 27.35a16 16 0 0 0 0 22.62l86.19 86.18-94.76 94.76a96 96 0 0 0 0 135.75l117.19 117.19a96 96 0 0 0 135.74 0l221.57-221.57a32 32 0 0 0 .01-45.28zM236.78 438.61a32 32 0 0 1-45.22 0L74.37 321.4a32 32 0 0 1 0-45.24l94.75-94.74 58.6 58.58A32 32 0 0 0 273 194.77l-58.6-58.6 58.92-58.93 162.42 162.41z"]],
    "film": [512, 512, [], "f008", ["M356 280H156a12 12 0 0 0-12 12v96a12 12 0 0 0 12 12h200a12 12 0 0 0 12-12v-96a12 12 0 0 0-12-12zm0-168H156a12 12 0 0 0-12 12v96a12 12 0 0 0 12 12h200a12 12 0 0 0 12-12v-96a12 12 0 0 0-12-12z", "M488 64h-8v20a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12V64H96v20a12 12 0 0 1-12 12H44a12 12 0 0 1-12-12V64h-8A23.94 23.94 0 0 0 0 88v336a23.94 23.94 0 0 0 24 24h8v-20a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12v20h320v-20a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12v20h8a23.94 23.94 0 0 0 24-24V88a23.94 23.94 0 0 0-24-24zM96 372a12 12 0 0 1-12 12H44a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12H44a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12H44a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm272 208a12 12 0 0 1-12 12H156a12 12 0 0 1-12-12v-96a12 12 0 0 1 12-12h200a12 12 0 0 1 12 12zm0-168a12 12 0 0 1-12 12H156a12 12 0 0 1-12-12v-96a12 12 0 0 1 12-12h200a12 12 0 0 1 12 12zm112 152a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12z"]],
    "film-alt": [512, 512, [], "f3a0", ["M369 448H143V64h226z", "M488.12 64H480v20a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12V64h-47v384h47v-20a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12v20h8a23.94 23.94 0 0 0 24-23.88V88a23.94 23.94 0 0 0-23.88-24zM480 372a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zM96 84a12 12 0 0 1-12 12H44a12 12 0 0 1-12-12V64h-8A23.94 23.94 0 0 0 0 87.88V424a23.94 23.94 0 0 0 23.88 24H32v-20a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12v20h47V64H96zm0 288a12 12 0 0 1-12 12H44a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12H44a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12H44a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12z"]],
    "film-canister": [576, 512, [], "f8b7", ["M320 448H32V96h288z", "M544 128H320v288h160a32 32 0 0 0 32-32v-32a32 32 0 0 1 32-32 32 32 0 0 0 32-32V160a32 32 0 0 0-32-32zM440 360a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16zm0-160a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16zm96 0a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16zM16 96h320a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-80V16a16 16 0 0 0-16-16H112a16 16 0 0 0-16 16v16H16A16 16 0 0 0 0 48v32a16 16 0 0 0 16 16zm320 352H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "filter": [512, 512, [], "f0b0", ["M505 41L320 225.93V488c0 19.51-22 30.71-37.76 19.66l-80-56A24 24 0 0 1 192 432V226L7 41C-8 25.87 2.69 0 24 0h464c21.33 0 32 25.9 17 41z", ""]],
    "fingerprint": [512, 512, [], "f577", ["M506.1 203.57a24 24 0 1 0-46.87 10.34c4.71 21.41 4.91 37.41 4.7 61.6a24 24 0 0 0 23.8 24.2h.2a24 24 0 0 0 24-23.8c.18-22.18.4-44.11-5.83-72.34zM256.11 246a24 24 0 0 0-24 24 731.23 731.23 0 0 1-27.7 211.55c-2.73 9.72 2.15 30.49 23.12 30.49a24 24 0 0 0 23.09-17.52A774 774 0 0 0 280.1 270a24 24 0 0 0-23.99-24zM144.56 144.45a24 24 0 0 0-33.76 3.48 173.44 173.44 0 0 0-38.75 112A580.75 580.75 0 0 1 62.94 372a24 24 0 0 0 19.36 27.87c20.11 3.5 27.07-14.81 27.89-19.36a629 629 0 0 0 9.86-121.33 123.59 123.59 0 0 1 28-81 24 24 0 0 0-3.49-33.73z", "M466 112.85A266 266 0 0 0 252.8 0C183-.82 118.46 24.91 70.45 72.94A238.49 238.49 0 0 0 .13 246.65L0 268.12a24 24 0 0 0 23.28 24.69H24a24 24 0 0 0 24-23.3l.16-23.64a190.77 190.77 0 0 1 56.28-139C143.18 68.09 195.76 47.22 252.1 48a217.86 217.86 0 0 1 174.62 92.39A24 24 0 1 0 466 112.85zM254 82.12a178.75 178.75 0 0 0-45.78 5 24 24 0 1 0 11.06 46.72 143.52 143.52 0 0 1 34-3.69c75.43 1.13 137.73 61.5 138.88 134.58a881.07 881.07 0 0 1-5.58 113.63 24 24 0 0 0 21.11 26.58c16.72 1.95 25.51-11.88 26.58-21.11A929.94 929.94 0 0 0 440.19 264C438.63 165.2 355.12 83.62 254 82.12zm1.22 82.11c-61.26-.07-104 47.07-103.16 101.09a656.09 656.09 0 0 1-13.37 142.55 24 24 0 1 0 47 9.72 704 704 0 0 0 14.37-153c-.41-25.95 19.92-52.49 54.45-52.34 31.31.47 57.15 25.34 57.62 55.47a804 804 0 0 1-10.61 143.55 24 24 0 0 0 19.76 27.58c20 3.33 26.81-15.1 27.58-19.77A853 853 0 0 0 360.16 267c-.88-55.85-47.94-101.93-104.91-102.77z"]],
    "fire": [384, 512, [], "f06d", ["M216 23.86C216 9.06 204.15 0 192 0a24 24 0 0 0-20.1 10.82C48 191.85 224 200 224 288v.81A64 64 0 0 1 160 352h-.87C124 351.5 96 322.18 96 287v-85.5c0-14.52-11.83-24-24.15-24a23.63 23.63 0 0 0-17.28 7.5C27.8 213.16 0 261.33 0 320c0 105.87 86.13 192 192 192s192-86.13 192-192c0-170.29-168-193-168-296.14zM192 444a123.61 123.61 0 0 1-87.78-36.5l2.63 1.21a129.9 129.9 0 0 0 51.39 11.23h1.78A132 132 0 0 0 292 289.71V288c0-27.83-8.69-54.44-25.84-79.11l-.3-.43c10.81 11 20.62 22.28 28.61 34.68C309.16 265.92 316 290.34 316 320a124.15 124.15 0 0 1-124 124z", "M265.86 208.46c10.81 11 20.62 22.28 28.61 34.68C309.16 265.92 316 290.34 316 320a123.94 123.94 0 0 1-211.78 87.5l2.63 1.21a129.9 129.9 0 0 0 51.39 11.23h1.78A132 132 0 0 0 292 289.71V288c0-27.83-8.69-54.44-25.84-79.11l-.3-.43"]],
    "fire-alt": [448, 512, [], "f7e4", ["M323.56 51.2a597.38 597.38 0 0 0-56.22 60C240.08 73.62 206.28 35.53 168 0 69.74 91.17 0 210 0 281.6 0 408.85 100.29 512 224 512s224-103.15 224-230.4c0-53.27-52-163.14-124.44-230.4zm-1.12 366.87A165.81 165.81 0 0 1 226.86 448c-43.93 0-84.43-14.89-114.06-41.92a146.18 146.18 0 0 1-35.88-50.39C68.35 335.82 64 314 64 290.75c0-59.43 42.8-106.39 104.3-180.12 30 34.59 18.49 19.78 100.7 124.59l62-70.74c24.32 40.25 27.78 45.59 34.84 59.1a157.93 157.93 0 0 1 15 104.62c-7.49 36.85-28.24 68.8-58.4 89.87z", "M304.09 391.85A134.39 134.39 0 0 1 226.86 416C154.71 416 96 368.26 96 290.75c0-38.61 24.31-72.63 72.79-130.75 6.93 8 98.83 125.34 98.83 125.34l58.63-66.88c4.14 6.85 7.91 13.55 11.27 20 27.35 52.19 15.81 119-33.43 153.42z"]],
    "fire-extinguisher": [448, 512, [], "f134", ["M256 67.09V72c0-1.18-.1-2.94 0-4.91zM46.29 184.91a24 24 0 0 1-44.57-17.82c14.67-36.67 38-77.84 90.05-90.89C77.63 39.68 104.57 0 144 0a56 56 0 0 1 53.67 72H256v48h-40v26a96.87 96.87 0 0 0-48 0v-26c-61 0-92.94-7-121.71 64.91zM144 72a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm112 53.54V120a51.87 51.87 0 0 0 0 5.54z", "M434 26.33l-168 28c-8.15 1.36-9.77 7.73-10 12.76v58.45c.38 4.79 2.24 10.83 10 12.13l168 28a12 12 0 0 0 14-11.84V38.17a12 12 0 0 0-14-11.84zM192 143a96 96 0 0 0-96 96v241a32 32 0 0 0 32 32h128a32 32 0 0 0 32-32V239a96 96 0 0 0-96-96z"]],
    "fire-smoke": [640, 512, [], "f74b", ["M195.7 283.2a145 145 0 0 0-44.5-21.3A171.61 171.61 0 0 1 144 213c0-54.2 54.8-144.1 132-213 30.1 26.9 56.6 55.7 77.9 84a458.59 458.59 0 0 1 44.2-45.4c57 50.8 97.8 133.9 97.8 174.2a171.61 171.61 0 0 1-7.2 48.9 145 145 0 0 0-44.5 21.3 160.46 160.46 0 0 0-36.5-32.8 99.68 99.68 0 0 0-5.1-77.8c-2.5-4.9-5.3-10.1-8.4-15.4l-43.8 51.7s-68.6-90.7-73.8-96.9c-36.2 45-54.4 71.3-54.4 101.1a103.85 103.85 0 0 0 7.4 39.3 161 161 0 0 0-33.9 31z", "M640 400a111.94 111.94 0 0 1-112 112H112a112 112 0 0 1 0-224c37.1 0 69.7 18.3 90.1 46.1a128 128 0 0 1 235.8 0c20.4-27.8 53-46.1 90.1-46.1a111.94 111.94 0 0 1 112 112z"]],
    "fireplace": [640, 512, [], "f79a", ["M371.2 281.6a289.37 289.37 0 0 0-28.9 30 390.58 390.58 0 0 0-51.1-55.6c-50.5 45.6-86.4 105-86.4 140.8a115.2 115.2 0 0 0 230.4 0c0-26.6-26.7-81.6-64-115.2zm-13.4 166.9a64.22 64.22 0 0 1-37.8 12.3c-35.3 0-64-24.4-64-64 0-19.7 11.9-37.1 35.6-66.8 3.4 4.1 48.3 64.1 48.3 64.1l28.7-34.2c2 3.5 3.9 6.9 5.5 10.2 13.4 26.6 7.8 60.8-16.3 78.4z", "M624 0H16A16 16 0 0 0 0 16v64a16 16 0 0 0 16 16h608a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16zM32 512h96V384c0-106 86-192 192-192s192 86 192 192v128h96V128H32z"]],
    "first-aid": [576, 512, [], "f479", ["M64 480h64V32H64zM448 32v448h64V32z", "M128 480h320V32H128zm64-248a8 8 0 0 1 8-8h56v-56a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8v56h56a8 8 0 0 1 8 8v48a8 8 0 0 1-8 8h-56v56a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-56h-56a8 8 0 0 1-8-8zM0 80v352a48 48 0 0 0 48 48h16V32H48A48 48 0 0 0 0 80zm528-48h-16v448h16a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48z"]],
    "fish": [576, 512, [], "f578", ["M327.1 96c-90 0-168.54 54.77-212.27 101.63l-87.33-66c-12.13-9.18-30.24.6-27.14 14.66L24.54 256 .35 365.77c-3.1 14.06 15 23.83 27.14 14.66l87.33-66.05C158.55 361.23 237.13 416 327.1 416 464.56 416 576 288 576 256S464.56 96 327.1 96zm87.43 192a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M446.53 256a32 32 0 1 1-32-32 32 32 0 0 1 32 32z"]],
    "fish-cooked": [640, 512, [], "f7fe", ["M363.43 64c-100 0-187.26 65.72-235.85 122l-97-79.26C17.07 95.68-3 107.42.39 124.29L27.26 256 .38 387.73C-3 404.6 17.06 416.32 30.53 405.32l97-79.26C176.16 382.28 263.47 448 363.43 448 516.17 448 640 294.4 640 256S516.17 64 363.43 64zM245.68 261.68l-11.31-11.31a8 8 0 0 1 0-11.31L319 154.34a8 8 0 0 1 11.31 0l11.32 11.32a8 8 0 0 1 0 11.31L257 261.65a8 8 0 0 1-11.32.03zm59.28 80a8 8 0 0 1-11.31 0l-11.31-11.31a8 8 0 0 1 0-11.31L431 170.34a8 8 0 0 1 11.31 0l11.32 11.32a8 8 0 0 1 0 11.31zM501.69 273L417 357.65a8 8 0 0 1-11.31 0l-11.31-11.31a8 8 0 0 1 0-11.31L479 250.34a8 8 0 0 1 11.31 0l11.32 11.32a8 8 0 0 1 .06 11.34z", "M453.63 193a8 8 0 0 0 0-11.31l-11.33-11.36a8 8 0 0 0-11.31 0L282.34 319a8 8 0 0 0 0 11.31l11.31 11.31a8 8 0 0 0 11.31 0L453.62 193zm-112-16a8 8 0 0 0 0-11.31l-11.33-11.36a8 8 0 0 0-11.31 0L234.34 239a8 8 0 0 0 0 11.31l11.31 11.31a8 8 0 0 0 11.31 0L341.62 177zm160 84.69l-11.33-11.36a8 8 0 0 0-11.31 0L394.37 335a8 8 0 0 0 0 11.31l11.31 11.31a8 8 0 0 0 11.31 0L501.65 273a8 8 0 0 0-.03-11.35z"]],
    "fist-raised": [384, 512, [], "f6de", ["M64 512v-64l-26.5-26.51A128 128 0 0 1 0 331v-77.95A47.26 47.26 0 0 0 16 256h32a47.65 47.65 0 0 0 32-12.49A47.65 47.65 0 0 0 112 256h32a47.4 47.4 0 0 0 21.87-5.52 64.34 64.34 0 0 0 38.87 34.45c-17.11 14.82-31.58 34.48-47.31 58.08l-6.31 9.47a8 8 0 0 0 2.22 11.08l13.31 8.88a8 8 0 0 0 11.08-2.22l6.31-9.47c31.89-47.84 51.53-70.27 96.05-72.55a8.22 8.22 0 0 0 7.88-8V264c0-4.42-3.52-8-13.2-8h-35.25A47.59 47.59 0 0 1 192 208.41v-.56A15.86 15.86 0 0 1 207.85 192H320a64 64 0 0 1 64 64v88.22a96 96 0 0 1-28.12 67.91L320 448v64z", "M144 32h-32a16 16 0 0 0-16 16v160a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zM48 64H16A16 16 0 0 0 0 80v128a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V80a16 16 0 0 0-16-16zm288-32h-32a16 16 0 0 0-16 16v112h32a94.76 94.76 0 0 1 32 5.9V48a16 16 0 0 0-16-16zM240 0h-32a16 16 0 0 0-16 16v146.93a47.56 47.56 0 0 1 16-2.93h48V16a16 16 0 0 0-16-16z"]],
    "flag": [512, 512, [], "f024", ["M512 91.33v277c0 11.31-7.1 21.88-18.5 26.47C317.7 465 281.7 331.25 96 416V102a56.57 56.57 0 0 0 14.64-15c194.19-74.48 184.75 58.25 352-20.08C485.2 56.31 512 68.26 512 91.33z", "M120 56a55.93 55.93 0 0 1-24 46v388a22 22 0 0 1-22 22H54a22 22 0 0 1-22-22V102a56 56 0 1 1 88-46z"]],
    "flag-alt": [512, 512, [], "f74c", ["M512 30.83v301.29a31.39 31.39 0 0 1-18.5 28.8C317.7 437.33 281.7 291.83 96 384V32.42c209.4-94.59 195.3 59.1 366.6-28.19 22.6-11.5 49.4 1.5 49.4 26.6z", "M64 32v464a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16V32a32 32 0 0 1 64 0z"]],
    "flag-checkered": [512, 512, [], "f11e", ["M96 298.66v95c28.3-12.1 63.6-22.1 114.4-22.1a144.77 144.77 0 0 1 29.6 3.26v-95a144.77 144.77 0 0 0-29.6-3.26c-50.8 0-86.1 10-114.4 22.1zM184.3 64c-19.3 0-42.3 0-68.14 12.36A56.18 56.18 0 0 1 96 102v93.66c28.3-12.1 63.6-22.1 114.4-22.1a144.77 144.77 0 0 1 29.6 3.26V71.64C223 67.2 204.69 64 184.3 64zm191.3 342.36c48.2 0 86.7-16.3 122.5-40.9a31.88 31.88 0 0 0 13.8-26.4v-76c-35.79 24.58-88.14 48.3-136.3 48.3-2.57 0-5.09-.07-7.6-.16v95c2.51.09 5 .16 7.6.16zm136.3-246.3V96c.1-23.35-24.2-38.85-45.4-29-29.1 13.4-63.89 27-98.5 30.76V208.2c2.51.09 5 .16 7.6.16 48.16 0 100.51-23.72 136.3-48.3zM240 176.82v103c39.58 8.25 77.24 29.4 128 31.38v-103c-50.76-1.98-88.42-23.13-128-31.38z", "M210.4 173.6c-50.8 0-86.1 10-114.4 22.1V102a56 56 0 1 0-64 0v388a22 22 0 0 0 22 22h20a22 22 0 0 0 22-22V298.7c28.3-12.1 63.6-22.1 114.4-22.1a144.77 144.77 0 0 1 29.6 3.26v-103a144.77 144.77 0 0 0-29.6-3.26zM240 374.82c39.58 8.25 77.24 29.4 128 31.38v-95c-50.76-2-88.42-23.13-128-31.38zM368 97.76a169.27 169.27 0 0 1-18.5 1c-37.32 0-70.17-16.92-109.5-27.17v105.23c39.58 8.25 77.24 29.4 128 31.38zm143.9 146.3v-84c-35.79 24.58-88.14 48.3-136.3 48.3-2.57 0-5.09-.07-7.6-.16v103c2.51.09 5 .16 7.6.16 48.2 0 100.6-23.76 136.4-48.36v-17.16c-.06-.57-.09-1.16-.1-1.78z"]],
    "flag-usa": [512, 512, [], "f74d", ["M299.9 303.62c-57.2-15.09-111.7-28.79-203.9 11.1V384c185.7-92.2 221.7 53.3 397.5-23.11a31.39 31.39 0 0 0 18.5-28.8v-36c-43.6 17.3-80.2 24.1-112.1 24.1-37.4-.07-68.9-8.36-100-16.57zm9.5-221.89c51.8 15.6 97.4 29 202.6-20.11V30.83c0-25.1-26.8-38.1-49.4-26.6-89.25 45.48-128.17 25.54-174.6 9.39v158c6.76 1.66 13.45 3.4 20.1 5.14 57.2 15 111.7 28.7 203.9-11.1V96.73c-53.6 23.5-93.3 31.39-126.1 31.39s-59-7.79-85.7-15.89c-4-1.21-8.1-2.4-12.1-3.5V75.52c7.2 2 14.3 4.1 21.3 6.21zm-9.5 125.89c-57.2-15.09-111.7-28.79-203.9 11.1v61.5c94.8-37.6 154.6-22.69 212.1-7.6 57.2 15.1 111.7 28.8 203.9-11.09V200c-43.6 17.3-80.2 24.09-112.1 24.09-37.4.03-68.9-8.26-100-16.47z", "M32 0A32 32 0 0 0 0 32v464a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V32A32 32 0 0 0 32 0zm64 32.4v151.93c83.83-33.17 140.29-25.43 192-12.75v-158C245.32-1.23 196.3-12.89 96 32.42zm64 95.7a16 16 0 1 1 16-16 16 16 0 0 1-16 16.02zm0-55.79a16 16 0 1 1 16-16 16 16 0 0 1-16 16.02zm64 47.9a16 16 0 1 1 16-16 16 16 0 0 1-16 16.02zm0-55.9a16 16 0 1 1 16-16 16 16 0 0 1-16 16.02z"]],
    "flame": [384, 512, [], "f6df", ["M192 0C79.7 101.33 0 220.92 0 300.55 0 425.05 79 512 192 512s192-86.95 192-211.45C384 220.6 303.78 100.86 192 0zm0 448c-70.58 0-128-52.89-128-117.89 0-44.11 25.84-71.51 34.34-79.76A8 8 0 0 1 112 256v40a56 56 0 0 0 112 0c0-72-112.64-64.77-39.43-164.33a9.37 9.37 0 0 1 10.58-3.17c1.62.53 5.38 2.24 5.38 6.78 0 33.55 25 55 51.57 77.63 33.38 28.54 67.9 58 67.9 117.21C320 395.11 262.58 448 192 448z", "M252.09 212.92c33.38 28.54 67.9 58 67.9 117.21 0 65-57.41 117.87-128 117.87S64 395.11 64 330.11c0-44.11 25.84-71.51 34.34-79.76A8 8 0 0 1 112 256v40a56 56 0 0 0 112 0c0-72-112.64-64.77-39.43-164.33a9.37 9.37 0 0 1 10.58-3.17c1.62.53 5.38 2.24 5.38 6.78 0 33.56 25 55 51.56 77.64z"]],
    "flashlight": [640, 512, [], "f8b8", ["M400.13 149.25L384 160H32a32 32 0 0 0-32 32v128a32 32 0 0 0 32 32h352l16.13 10.75A317 317 0 0 0 576 416V96a317 317 0 0 0-175.87 53.25zM288 288h-32a32 32 0 0 1 0-64h32a32 32 0 0 1 0 64z", "M608 96h-32v320h32a32 32 0 0 0 32-32V128a32 32 0 0 0-32-32zM288 224h-32a32 32 0 0 0 0 64h32a32 32 0 0 0 0-64z"]],
    "flask": [448, 512, [], "f0c3", ["M138.07 320h171.84l72.93 117.29a6.4 6.4 0 0 1 .09 7.12 6.11 6.11 0 0 1-5.88 3.52H70.89a6.08 6.08 0 0 1-5.89-3.46 6.45 6.45 0 0 1 .11-7.18z", "M112 64h224a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16H112a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm325.19 339.5L320 215V96h-64v137.27l126.85 204a6.4 6.4 0 0 1 .09 7.12 6.11 6.11 0 0 1-5.88 3.52H70.89a6.08 6.08 0 0 1-5.89-3.44 6.45 6.45 0 0 1 .11-7.18L192 233.27V96h-64v119L10.79 403.5c-29.3 47.1 4.5 108.5 60.1 108.5h306.2c55.7 0 89.4-61.5 60.1-108.5z"]],
    "flask-poison": [416, 512, [], "f6e0", ["M208 224c-61.86 0-112 39.4-112 88 0 29.87 19 56.17 48 72.08V416a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16v-31.92c29-15.91 48-42.21 48-72.08 0-48.6-50.17-88-112-88zm-40 112a24 24 0 1 1 24-24 24 24 0 0 1-24 24zm80 0a24 24 0 1 1 24-24 24 24 0 0 1-24 24z", "M96 64h224a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16H96a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm208 105.05V96H112v72.12C45.61 202.85 0 271.88 0 352a207.15 207.15 0 0 0 53.93 139.7 63.44 63.44 0 0 0 47 20.3H315a64 64 0 0 0 47.57-20.85A207.15 207.15 0 0 0 416 356.67c1.71-79.95-44.8-151.49-112-187.62zm-32 215V416a16 16 0 0 1-16 16h-96a16 16 0 0 1-16-16v-31.92c-29-15.91-48-42.21-48-72.08 0-48.6 50.13-88 112-88s112 39.4 112 88c0 29.87-19 56.17-48 72.08z"]],
    "flask-potion": [416, 512, [], "f6e1", ["M64 352a154.39 154.39 0 0 1 1.92-24.48c61.84-24.46 131.65-20.73 181 4 36.58 18.29 78.12 20.41 105 20.56v3.23A143.83 143.83 0 0 1 315.29 448h-214.6A143.6 143.6 0 0 1 64 352z", "M304 169.05V96h-64v111.3c24.51 13.18 114.1 49.87 112 148a143.82 143.82 0 0 1-36.71 92.7h-214.6A143.6 143.6 0 0 1 64 352c0-99.51 88.31-132.74 112-145.13V96h-64v72.12C45.61 202.85 0 271.88 0 352a207.15 207.15 0 0 0 53.93 139.7 63.44 63.44 0 0 0 47 20.3H315a64 64 0 0 0 47.57-20.85A207.15 207.15 0 0 0 416 356.67c1.71-79.95-44.8-151.49-112-187.62zM96 64h224a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16H96a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16z"]],
    "flower": [512, 512, [], "f7ff", ["M435.86,256C462.7,232.54,480,198.45,480,160A128,128,0,0,0,352,32c-38.45,0-72.54,17.3-96,44.14C232.54,49.3,198.45,32,160,32A128,128,0,0,0,32,160c0,38.45,17.3,72.54,44.14,96C49.3,279.46,32,313.55,32,352A128,128,0,0,0,160,480c38.45,0,72.54-17.3,96-44.14C279.46,462.7,313.55,480,352,480A128,128,0,0,0,480,352C480,313.55,462.7,279.46,435.86,256ZM335.2,335.2A112,112,0,1,1,368,256,112,112,0,0,1,335.2,335.2Z", "M336,256a80,80,0,1,1-80-80A80,80,0,0,1,336,256Z"]],
    "flower-daffodil": [512, 512, [], "f800", ["M511.93 336.84C501.94 435 405.57 512 288.17 512h-64.34C106.43 512 10.06 435 .07 336.84-.87 327.72 6.94 320 16.13 320h47.26c63 0 119.82 22.23 160.61 57.92v-96.58A80.33 80.33 0 0 0 256 256a80.33 80.33 0 0 0 32 25.34v96.58C328.79 342.23 385.61 320 448.61 320h47.26c9.19 0 16.98 7.72 16.06 16.84z", "M368 144A80 80 0 1 0 256 32a80 80 0 1 0-112 112 80 80 0 1 0 112 112 80 80 0 1 0 112-112zm-112 48a48 48 0 1 1 48-48 48 48 0 0 1-48 48z"]],
    "flower-tulip": [512, 512, [], "f801", ["M511.94 336.84C502 435 405.58 512 288.18 512h-64.34C106.44 512 10.07 435 .08 336.84-.86 327.72 7 320 16.14 320H63.4c63 0 119.82 22.23 160.61 57.92V256h64v121.92C328.8 342.23 385.62 320 448.62 320h47.26c9.19 0 16.98 7.72 16.06 16.84z", "M224 256A128 128 0 0 1 96 128V32l80 48 81.15-80L336 80l80-48v96a128 128 0 0 1-128 128z"]],
    "flushed": [496, 512, [], "f579", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8ZM80,224a72,72,0,1,1,72,72,72,72,0,0,1-72-72ZM312,400H184c-21.2,0-21.2-32,0-32H312C333.2,368,333.2,400,312,400Zm32-104a72,72,0,1,1,72-72,72,72,0,0,1-72,72Z", "M152,200a23.94,23.94,0,1,0,.12,0Zm192,0a23.94,23.94,0,1,0,.12,0Z"]],
    "flute": [640, 512, [], "f8b9", ["M608 176H96v160h512a32 32 0 0 0 32-32v-96a32 32 0 0 0-32-32z", "M320 232a24 24 0 1 0 24 24 24 24 0 0 0-24-24zM0 208v96a32 32 0 0 0 32 32h64V176H32a32 32 0 0 0-32 32zm416 24a24 24 0 1 0 24 24 24 24 0 0 0-24-24zm96 0a24 24 0 1 0 24 24 24 24 0 0 0-24-24z"]],
    "flux-capacitor": [448, 512, [], "f8ba", ["M248 352a24 24 0 0 1-48 0v-41.32a48 48 0 1 0 48 0zM128 112a48 48 0 0 0 0 96 47.36 47.36 0 0 0 12.27-1.79L111 177a24 24 0 0 1 34-34l29.24 29.24A47.36 47.36 0 0 0 176 160a48.05 48.05 0 0 0-48-48zm240-80H80a80.09 80.09 0 0 0-80 80v288a80.09 80.09 0 0 0 80 80h288a80.09 80.09 0 0 0 80-80V112a80.09 80.09 0 0 0-80-80zm-48 208a79.11 79.11 0 0 1-36.74-9.32L248 265.94v10.13c32.38 10.24 56 40.17 56 75.93a80 80 0 0 1-160 0c0-35.76 23.62-65.69 56-75.93v-10.13l-35.26-35.26A79.11 79.11 0 0 1 128 240a80 80 0 1 1 80-80 79.12 79.12 0 0 1-9.33 36.74L224 222.06l25.33-25.32A79.12 79.12 0 0 1 240 160a80 80 0 1 1 80 80zm0-128a48.05 48.05 0 0 0-48 48 47.36 47.36 0 0 0 1.79 12.27L303 143a24 24 0 0 1 34 34l-29.24 29.24A47.36 47.36 0 0 0 320 208a48 48 0 0 0 0-96z", "M337 177l-89 89v86a24 24 0 0 1-48 0v-86.06l-89-89A24 24 0 0 1 145 143l79 79 79-79a24 24 0 0 1 34 34z"]],
    "fog": [640, 512, [], "f74e", ["M208 464H80a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm416 0H288a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h336a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm-48-64v-16a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h544a16 16 0 0 0 16-16z", "M64 224c0-42.5 27.8-78.2 66.1-90.8A113.72 113.72 0 0 1 128 112 111.94 111.94 0 0 1 240 0c43.3 0 80.4 24.8 99 60.8C353.7 43.3 375.4 32 400 32a80 80 0 0 1 80 80 78.09 78.09 0 0 1-1.6 16.2c.5 0 1-.2 1.6-.2a96 96 0 0 1 0 192H160a96 96 0 0 1-96-96z"]],
    "folder": [512, 512, [], "f07b", ["M464 128H272l-64-64H48C21.49 64 0 85.49 0 112v288c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V176c0-26.51-21.49-48-48-48z", ""]],
    "folder-minus": [512, 512, [], "f65d", ["M464 128H272l-64-64H48a48 48 0 0 0-48 48v288a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V176a48 48 0 0 0-48-48zm-96 168a16 16 0 0 1-16 16H160a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h192a16 16 0 0 1 16 16z", "M368 280v16a16 16 0 0 1-16 16H160a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h192a16 16 0 0 1 16 16z"]],
    "folder-open": [576, 512, [], "f07c", ["M69.08 271.63L0 390.05V112a48 48 0 0 1 48-48h160l64 64h160a48 48 0 0 1 48 48v48H152a96.31 96.31 0 0 0-82.92 47.63z", "M152 256h400a24 24 0 0 1 20.73 36.09l-72.46 124.16A64 64 0 0 1 445 448H45a24 24 0 0 1-20.73-36.09l72.45-124.16A64 64 0 0 1 152 256z"]],
    "folder-plus": [512, 512, [], "f65e", ["M464 128H272l-64-64H48a48 48 0 0 0-48 48v288a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V176a48 48 0 0 0-48-48zm-96 168a16 16 0 0 1-16 16h-72v72a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-72h-72a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h72v-72a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v72h72a16 16 0 0 1 16 16z", "M144 280a16 16 0 0 1 16-16h72v-72a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v72h72a16 16 0 0 1 16 16v16a16 16 0 0 1-16 16h-72v72a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-72h-72a16 16 0 0 1-16-16z"]],
    "folder-times": [512, 512, [], "f65f", ["M464 128H272l-64-64H48a48 48 0 0 0-48 48v288a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V176a48 48 0 0 0-48-48zM340.85 338.91a16 16 0 0 1 0 22.63l-11.31 11.31a16 16 0 0 1-22.63 0L256 321.94l-50.91 50.91a16 16 0 0 1-22.63 0l-11.31-11.31a16 16 0 0 1 0-22.63L222.06 288l-50.91-50.91a16 16 0 0 1 0-22.63l11.31-11.31a16 16 0 0 1 22.63 0L256 254.06l50.91-50.91a16 16 0 0 1 22.63 0l11.31 11.31a16 16 0 0 1 0 22.63L289.94 288z", "M171.15 237.09a16 16 0 0 1 0-22.63l11.31-11.31a16 16 0 0 1 22.63 0L256 254.06l50.91-50.91a16 16 0 0 1 22.63 0l11.31 11.31a16 16 0 0 1 0 22.63L289.94 288l50.91 50.91a16 16 0 0 1 0 22.63l-11.31 11.31a16 16 0 0 1-22.63 0L256 321.94l-50.91 50.91a16 16 0 0 1-22.63 0l-11.31-11.31a16 16 0 0 1 0-22.63L222.06 288z"]],
    "folder-tree": [576, 512, [], "f802", ["M0 416V16A16 16 0 0 1 16 0h32a16 16 0 0 1 16 16v80h192v64H64v224h192v64H32a32 32 0 0 1-32-32z", "M544 320H432l-32-32h-80a32 32 0 0 0-32 32v160a32 32 0 0 0 32 32h224a32 32 0 0 0 32-32V352a32 32 0 0 0-32-32zm0-288H432L400 0h-80a32 32 0 0 0-32 32v160a32 32 0 0 0 32 32h224a32 32 0 0 0 32-32V64a32 32 0 0 0-32-32z"]],
    "folders": [640, 512, [], "f660", ["M640 112v224a48 48 0 0 1-48 48H176a48 48 0 0 1-48-48V48a48 48 0 0 1 48-48h160l64 64h192a48 48 0 0 1 48 48z", "M48 512a48 48 0 0 1-48-48V176a48 48 0 0 1 48-48h48v208a80.09 80.09 0 0 0 80 80h336v48a48 48 0 0 1-48 48z"]],
    "font": [448, 512, [], "f031", ["M432 416H304a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-288 0H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M147.72 352h152.56l23.31 64h85L277.87 53.69C273.81 41.72 260.22 32 247.59 32h-47.18c-12.63 0-26.22 9.72-30.29 21.69L39.41 416h85zM224 142.52L271.16 272h-94.32z"]],
    "font-awesome-logo-full": [3992, 512, ["Font Awesome"], "f4e6", ["", "M454.6 0H57.4C25.9 0 0 25.9 0 57.4v397.3C0 486.1 25.9 512 57.4 512h397.3c31.4 0 57.4-25.9 57.4-57.4V57.4C512 25.9 486.1 0 454.6 0zm-58.9 324.9c0 4.8-4.1 6.9-8.9 8.9-19.2 8.1-39.7 15.7-61.5 15.7-40.5 0-68.7-44.8-163.2 2.5v51.8c0 30.3-45.7 30.2-45.7 0v-250c-9-7-15-17.9-15-30.3 0-21 17.1-38.2 38.2-38.2 21 0 38.2 17.1 38.2 38.2 0 12.2-5.8 23.2-14.9 30.2v21c37.1-12 65.5-34.4 146.1-3.4 26.6 11.4 68.7-15.7 76.5-15.7 5.5 0 10.3 4.1 10.3 8.9v160.4zm432.9-174.2h-137v70.1H825c39.8 0 40.4 62.2 0 62.2H691.6v105.6c0 45.5-70.7 46.4-70.7 0V128.3c0-22 18-39.8 39.8-39.8h167.8c39.6 0 40.5 62.2.1 62.2zm191.1 23.4c-169.3 0-169.1 252.4 0 252.4 169.9 0 169.9-252.4 0-252.4zm0 196.1c-81.6 0-82.1-139.8 0-139.8 82.5 0 82.4 139.8 0 139.8zm372.4 53.4c-17.5 0-31.4-13.9-31.4-31.4v-117c0-62.4-72.6-52.5-99.1-16.4v133.4c0 41.5-63.3 41.8-63.3 0V208c0-40 63.1-41.6 63.1 0v3.4c43.3-51.6 162.4-60.4 162.4 39.3v141.5c.3 30.4-31.5 31.4-31.7 31.4zm179.7 2.9c-44.3 0-68.3-22.9-68.3-65.8V235.2H1488c-35.6 0-36.7-55.3 0-55.3h15.5v-37.3c0-41.3 63.8-42.1 63.8 0v37.5h24.9c35.4 0 35.7 55.3 0 55.3h-24.9v108.5c0 29.6 26.1 26.3 27.4 26.3 31.4 0 52.6 56.3-22.9 56.3zM1992 123c-19.5-50.2-95.5-50-114.5 0-107.3 275.7-99.5 252.7-99.5 262.8 0 42.8 58.3 51.2 72.1 14.4l13.5-35.9H2006l13 35.9c14.2 37.7 72.1 27.2 72.1-14.4 0-10.1 5.3 6.8-99.1-262.8zm-108.9 179.1l51.7-142.9 51.8 142.9h-103.5zm591.3-85.6l-53.7 176.3c-12.4 41.2-72 41-84 0l-42.3-135.9-42.3 135.9c-12.4 40.9-72 41.2-84.5 0l-54.2-176.3c-12.5-39.4 49.8-56.1 60.2-16.9L2213 342l45.3-139.5c10.9-32.7 59.6-34.7 71.2 0l45.3 139.5 39.3-142.4c10.3-38.3 72.6-23.8 60.3 16.9zm275.4 75.1c0-42.4-33.9-117.5-119.5-117.5-73.2 0-124.4 56.3-124.4 126 0 77.2 55.3 126.4 128.5 126.4 31.7 0 93-11.5 93-39.8 0-18.3-21.1-31.5-39.3-22.4-49.4 26.2-109 8.4-115.9-43.8h148.3c16.3 0 29.3-13.4 29.3-28.9zM2571 277.7c9.5-73.4 113.9-68.6 118.6 0H2571zm316.7 148.8c-31.4 0-81.6-10.5-96.6-31.9-12.4-17 2.5-39.8 21.8-39.8 16.3 0 36.8 22.9 77.7 22.9 27.4 0 40.4-11 40.4-25.8 0-39.8-142.9-7.4-142.9-102 0-40.4 35.3-75.7 98.6-75.7 31.4 0 74.1 9.9 87.6 29.4 10.8 14.8-1.4 36.2-20.9 36.2-15.1 0-26.7-17.3-66.2-17.3-22.9 0-37.8 10.5-37.8 23.8 0 35.9 142.4 6 142.4 103.1-.1 43.7-37.4 77.1-104.1 77.1zm266.8-252.4c-169.3 0-169.1 252.4 0 252.4 170.1 0 169.6-252.4 0-252.4zm0 196.1c-81.8 0-82-139.8 0-139.8 82.5 0 82.4 139.8 0 139.8zm476.9 22V268.7c0-53.8-61.4-45.8-85.7-10.5v134c0 41.3-63.8 42.1-63.8 0V268.7c0-52.1-59.5-47.4-85.7-10.1v133.6c0 41.5-63.3 41.8-63.3 0V208c0-40 63.1-41.6 63.1 0v3.4c9.9-14.4 41.8-37.3 78.6-37.3 35.3 0 57.7 16.4 66.7 43.8 13.9-21.8 45.8-43.8 82.6-43.8 44.3 0 70.7 23.4 70.7 72.7v145.3c.5 17.3-13.5 31.4-31.9 31.4 3.5.1-31.3 1.1-31.3-31.3zM3992 291.6c0-42.4-32.4-117.5-117.9-117.5-73.2 0-127.5 56.3-127.5 126 0 77.2 58.3 126.4 131.6 126.4 31.7 0 91.5-11.5 91.5-39.8 0-18.3-21.1-31.5-39.3-22.4-49.4 26.2-110.5 8.4-117.5-43.8h149.8c16.3 0 29.1-13.4 29.3-28.9zm-180.5-13.9c9.7-74.4 115.9-68.3 120.1 0h-120.1z"]],
    "font-case": [640, 512, [], "f866", ["M624 160h-32a16 16 0 0 0-16 16v1.81c-18.9-11-40.58-17.81-64-17.81a128.14 128.14 0 0 0-128 128v32a128.14 128.14 0 0 0 128 128c23.42 0 45.1-6.78 64-17.81V432a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V176a16 16 0 0 0-16-16zm-64 160a48 48 0 0 1-96 0v-32a48 48 0 0 1 96 0z", "M229.88 85.69A32 32 0 0 0 199.58 64h-47.16a32 32 0 0 0-30.3 21.69L.85 426.89A16 16 0 0 0 16 448h50.62a16 16 0 0 0 15.16-10.89L100.85 384h150.3l19.07 53.11A16 16 0 0 0 285.38 448H336a16 16 0 0 0 15.16-21.11zM129.58 304L176 174.74 222.42 304z"]],
    "football-ball": [496, 512, [], "f44e", ["M0,328.41v1.53L174.06,504h1.53a321.72,321.72,0,0,0,60.6-5.75L5.75,267.81A321.72,321.72,0,0,0,0,328.41ZM496,182.06,321.94,8h-1.53a321.72,321.72,0,0,0-60.6,5.75L490.25,244.19a321.72,321.72,0,0,0,5.75-60.6Z", "M14.5,451.7a52.8,52.8,0,0,0,37.3,37.4c49.3,13.2,88.49,14.9,122.26,14.9L0,329.94C0,363.51,1.47,402.26,14.5,451.7Zm467-391.4a52.8,52.8,0,0,0-37.3-37.4C394.9,9.7,355.71,8.05,321.94,8L496,182.06c0-33.57-1.47-72.32-14.5-121.76ZM5.75,267.81,236.19,498.25c128.35-24.57,229.49-125.71,254.06-254.06L259.81,13.75C131.46,38.32,30.32,139.46,5.75,267.81Zm288.91-81.69,29.21-29.42a8.29,8.29,0,0,1,11.67,0l11.66,11.66a8.29,8.29,0,0,1,0,11.67L318,209.24l29.21,29.21a8.29,8.29,0,0,1,0,11.67l-11.66,11.66a8.29,8.29,0,0,1-11.67,0l-29.21-29.21L271.33,256l29.21,29.21a8.29,8.29,0,0,1,0,11.67l-11.66,11.66a8.29,8.29,0,0,1-11.67,0L248,279.33l-23.33,23.33,29.21,29.21a8.29,8.29,0,0,1,0,11.67L242.22,355.2a8.29,8.29,0,0,1-11.67,0L201.34,326l-29.21,29.2a8.29,8.29,0,0,1-11.67,0L148.8,343.54a8.29,8.29,0,0,1,0-11.67L178,302.66l-29.2-29.11a8.29,8.29,0,0,1,0-11.67l11.66-11.66a8.29,8.29,0,0,1,11.67,0l29.21,29.21,23.33-23.33-29.21-29.21a8.28,8.28,0,0,1,0-11.66l11.66-11.67a8.29,8.29,0,0,1,11.67,0L248,232.77l23.33-23.32-29.21-29.22a8.28,8.28,0,0,1,0-11.66l11.66-11.67a8.29,8.29,0,0,1,11.67,0Z"]],
    "football-helmet": [512, 512, [], "f44f", ["M480 320H355.46l-15.2-76-31.8 4.1 14.4 71.9h-49.3s18.7 46.8 12.8 32h42.9l9.5 47.3c9.5 47.4 48 85.3 95.9 91.3 44 5.5 42.5 5.4 45.3 5.4 22.5 0 32-19.7 32-32V352A32 32 0 0 0 480 320zm0 144l-41.3-5.2a79.72 79.72 0 0 1-60.1-40.7H480zm0-80H368.26l-6.4-32H480z", "M491 207.46C466.2 82.56 347.9-8.64 211.9 10.56c-107.3 15.1-194.1 102-209.3 209.3-10.2 72.1 10.7 139.1 51.1 190a16.26 16.26 0 0 0 12.8 6.1H120l85.7 45a65.58 65.58 0 0 0 75.7-12.3c36.2-36.2 10.9-81.9 5-96.7l-23.1-57.7a32 32 0 0 1 25.6-43.6l188.2-24.5c8.96-1.16 15.56-9.8 13.9-18.7zM176 360a24 24 0 1 1 24-24 23.94 23.94 0 0 1-24 24z"]],
    "forklift": [640, 512, [], "f47a", ["M96 352a80 80 0 1 0 80 80 80 80 0 0 0-80-80zm528 32h-80V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v416a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-272-32a80 80 0 1 0 80 80 80 80 0 0 0-80-80z", "M410.8 211.9L332.5 29.1A48 48 0 0 0 288.3 0H144a48 48 0 0 0-48 48v112H48a48 48 0 0 0-48 48v166.23a113.49 113.49 0 0 1 16.8-21.43 112 112 0 0 1 158.4 0 111.19 111.19 0 0 1 31.67 63.2h34.26A112 112 0 0 1 416 340.06v-103a64.23 64.23 0 0 0-5.2-25.16zM352 256h-96l-96-96V64h117.8L352 237.1z"]],
    "forward": [512, 512, [], "f04e", ["M224 297.69L52.5 440.61C31.9 457.81 0 443.41 0 416V96c0-27.4 31.9-41.7 52.5-24.6L224 214.32z", "M500.5 231.41a32.11 32.11 0 0 1 0 49.2l-192 160c-20.6 17.2-52.5 2.8-52.5-24.6V96c0-27.4 31.9-41.7 52.5-24.6z"]],
    "fragile": [288, 512, [], "f4bb", ["M192.21 0l30.6 63.7-85.5 56 49.4 104.3-121.5-119.7 85.5-56L117.91 0z", "M160 350.3V480h53.9c24.5 0 33.1 32 20 32H54.11c-13.2 0-4.5-32 20-32H128V350.3C51.31 341.6-6.59 272.7.61 192.7l16-178.1A15.79 15.79 0 0 1 32.31 0h85.6l32.8 48.3-85.5 56L186.71 224l-49.4-104.3 85.5-56L192.21 0h63.5a15.79 15.79 0 0 1 15.7 14.6l16 178.1c7.2 80-50.7 148.8-127.41 157.6z"]],
    "french-fries": [512, 512, [], "f803", ["M169.57.3a16.22,16.22,0,0,0-6.72,3L134.34,24.9a16,16,0,0,0-6.07,15.68l36.9,197.22c5.3,7.59,14.49,14.87,26.83,20.75V33.19l-3.76-20.11A16,16,0,0,0,169.57.3Zm109.6,17.4-32-16A16,16,0,0,0,224,16V268.79a160.37,160.37,0,0,0,64,0V32A16,16,0,0,0,279.17,17.7ZM84.61,80.7A16,16,0,0,0,64.25,98.78L80.55,192H114c3.6,0,7,1,10.35,1.75l-20-107.16ZM370.75,32.27a16.38,16.38,0,0,0-7.33.43L329.14,43c-4.24,1.27-7.17,4.51-9.13,8.33V258.55c17.55-8.38,29.15-19.54,31.54-30.39.4-1.79,1.46-3.22,2.06-4.92L383.76,50.78A16,16,0,0,0,370.75,32.27Zm64,48a16.38,16.38,0,0,0-7.33.43l-17.31,5.17L391.36,193.13c2.24-.32,4.33-1.12,6.63-1.12h33.47l16.3-93.23A16,16,0,0,0,434.75,80.27Z", "M64,240a16,16,0,0,1,16-16h34c6.92,0,13.7,4.24,15.19,11,8.6,39,62.09,69,126.79,69s118.2-30,126.8-69c1.49-6.73,8.27-11,15.19-11h34a16,16,0,0,1,16,16,16.16,16.16,0,0,1-.38,3.46L393.48,487A32,32,0,0,1,362.28,512H149.73A32,32,0,0,1,118.48,487L64.38,243.48A16.18,16.18,0,0,1,64,240Z"]],
    "frog": [576, 512, [], "f52e", ["M576 464a16 16 0 0 1-16 16h-90.38L351.09 354.09c5.07-54.15-29.93-85.06-40.8-93.21a104.78 104.78 0 0 0-125.13 0L150.38 287a16 16 0 0 0 19.22 25.6l32.76-24.6c20.69-15.53 48.35-20.81 72.24-10.88 44.06 18.32 57.85 70.37 33.71 106.6L272.51 432H352a32 32 0 0 1 32 32 16 16 0 0 1-16 16H64c-34.92 0-63.89-28-64-63-.5-166.8 126.69-303.9 289.33-319.45-.21 1.15-.4 2.32-.56 3.49a82.14 82.14 0 0 0-.77 11c0 47.54 39.29 80 80 80 46 0 80-37.61 80-80a81.4 81.4 0 0 0-1.34-14.53c3 1 59.41 19.62 98.86 41.23a58.22 58.22 0 0 1 .77 102l-154.44 86.61L490.37 432H544a32 32 0 0 1 32 32z", "M368 32a80 80 0 1 0 80 80 80 80 0 0 0-80-80zm0 48a32 32 0 0 1 32 32h-64a32 32 0 0 1 32-32z"]],
    "frosty-head": [384, 512, [], "f79b", ["M357 329.4a165 165 0 0 0-13.7-41.4H40.4A169.38 169.38 0 0 0 24 360.9c0 59.9 31.3 112.1 78.2 142 10.2 6.5 22.5 9.1 34.6 9.1h109.6a71.86 71.86 0 0 0 41.1-13c51.4-35.8 82.2-99.4 69.5-169.6zm-226.3 33.3a21.3 21.3 0 1 1 21.3-21.3 21.32 21.32 0 0 1-21.3 21.3zM192 464s-32-46.3-32-64a32 32 0 0 1 64 0c0 17.7-32 64-32 64zm61.3-101.3a21.3 21.3 0 1 1 21.3-21.3 21.32 21.32 0 0 1-21.3 21.3z", "M368 240H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h352a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zM320 16a16 16 0 0 0-16-16H80a16 16 0 0 0-16 16v192h256z"]],
    "frown": [496, 512, [], "f119", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8Zm80,168a32,32,0,1,1-32,32A32,32,0,0,1,328,176Zm-160,0a32,32,0,1,1-32,32A32,32,0,0,1,168,176ZM338.2,394.2a117.5,117.5,0,0,0-180.4,0c-13.5,16.3-38.1-4.2-24.6-20.5a149.34,149.34,0,0,1,229.5.1C376.3,390,351.7,410.5,338.2,394.2Z", "M168,176a32,32,0,1,0,32,32A32,32,0,0,0,168,176Zm160,0a32,32,0,1,0,32,32A32,32,0,0,0,328,176Z"]],
    "frown-open": [496, 512, [], "f57a", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8ZM136,208a32,32,0,1,1,32,32A32,32,0,0,1,136,208ZM323.3,391.3C292.1,381.7,263.9,376,248,376s-44.1,5.7-75.3,15.3a16,16,0,0,1-20.5-18.1c7-40,60.1-61.2,95.8-61.2s88.8,21.3,95.8,61.2a16,16,0,0,1-20.5,18.1ZM328,240a32,32,0,1,1,32-32A32,32,0,0,1,328,240Z", "M168,176a32,32,0,1,0,32,32A32,32,0,0,0,168,176Zm160,0a32,32,0,1,0,32,32A32,32,0,0,0,328,176Z"]],
    "function": [640, 512, [], "f661", ["M334.59 152.91l-24.69-21c-7-6-17.83-5.09-23.38 2.23a307.46 307.46 0 0 0 0 371.68c5.56 7.32 16.38 8.18 23.38 2.23l24.69-21c6.59-5.61 7.31-15.2 2.15-22.14a242.8 242.8 0 0 1 0-289.89c5.17-6.91 4.45-16.51-2.15-22.11zm242.89-18.75c-5.56-7.32-16.38-8.18-23.38-2.23l-24.69 21c-6.59 5.61-7.31 15.2-2.15 22.14a242.82 242.82 0 0 1 0 289.9c-5.17 6.94-4.45 16.54 2.15 22.14l24.69 21c7 5.95 17.83 5.09 23.38-2.23a307.48 307.48 0 0 0 0-371.69z", "M477.25 320l46.06-46.06a16 16 0 0 0 0-22.63l-22.62-22.62a16 16 0 0 0-22.63 0L432 274.75l-46.06-46.06a16 16 0 0 0-22.63 0l-22.62 22.62a16 16 0 0 0 0 22.63L386.75 320l-46.06 46.06a16 16 0 0 0 0 22.63l22.62 22.62a16 16 0 0 0 22.63 0L432 365.25l46.06 46.06a16 16 0 0 0 22.63 0l22.62-22.62a16 16 0 0 0 0-22.63zM208 0h-48A104 104 0 0 0 56 104v64H16a16 16 0 0 0-16 16v48a16 16 0 0 0 16 16h40v128a24.07 24.07 0 0 1-24 24H16a16 16 0 0 0-16 16v48a16 16 0 0 0 16 16h16a104 104 0 0 0 104-104V248h40a16 16 0 0 0 16-16v-48a16 16 0 0 0-16-16h-40v-64a24.07 24.07 0 0 1 24-24h48a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16z"]],
    "funnel-dollar": [640, 512, [], "f662", ["M480 192a160 160 0 1 0 160 160 160 160 0 0 0-160-160zm16 239.88V448a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-16.29a57.26 57.26 0 0 1-31.37-11.35 8 8 0 0 1-.57-12.14L443.81 397a8.21 8.21 0 0 1 10.13-.73 24.08 24.08 0 0 0 12.82 3.73h28.11c6.5 0 11.8-5.92 11.8-13.19 0-5.95-3.61-11.19-8.77-12.73l-45-13.5c-18.59-5.58-31.58-23.42-31.58-43.39 0-24.52 19.05-44.44 42.67-45.07V256a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v16.29a57.18 57.18 0 0 1 31.37 11.35 8 8 0 0 1 .57 12.14L516.18 307a8.21 8.21 0 0 1-10.13.73 24 24 0 0 0-12.82-3.73h-28.11c-6.5 0-11.8 5.92-11.8 13.19 0 5.95 3.61 11.19 8.77 12.73l45 13.5c18.59 5.58 31.58 23.42 31.58 43.39 0 24.53-19.04 44.44-42.67 45.07z", "M507.09 343.42l-45-13.5c-5.16-1.54-8.77-6.78-8.77-12.73 0-7.27 5.3-13.19 11.8-13.19h28.11a24 24 0 0 1 12.82 3.72 8.21 8.21 0 0 0 10.13-.73l11.75-11.21a8 8 0 0 0-.57-12.14A57.18 57.18 0 0 0 496 272.29V256a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v16.12c-23.62.63-42.67 20.55-42.67 45.07 0 20 13 37.81 31.58 43.39l45 13.5c5.16 1.54 8.77 6.78 8.77 12.73 0 7.27-5.3 13.19-11.8 13.19h-28.12a24.08 24.08 0 0 1-12.82-3.72 8.21 8.21 0 0 0-10.13.73l-11.75 11.21a8 8 0 0 0 .57 12.14A57.26 57.26 0 0 0 464 431.71V448a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-16.12c23.63-.63 42.67-20.54 42.67-45.07 0-19.97-12.99-37.81-31.58-43.39zM288 352c0-89.79 62.05-165.17 145.46-186.06l101.2-111.87c20-20 5.82-54.07-22.4-54.07H31.74C3.52 0-10.61 34.12 9.34 54.07L192 256v155.92a40 40 0 0 0 16 32l80 60c20.86 15.64 48.47 7 59.22-13.57A191.33 191.33 0 0 1 288 352z"]],
    "futbol": [512, 512, [], "f1e3", ["M452 104v-.05.05zm51.88 159.77A246.7 246.7 0 0 1 461 395.61l-7.15-31.45-109.5 13.43-46.69 100.1L325 494l.06.23a248.87 248.87 0 0 1-138.06 0V494l27.37-16.28-46.69-100.1-109.52-13.46L51 395.61a246.7 246.7 0 0 1-42.87-131.8l24.17 21.08 80.61-75.24-20.83-108.5L60 104a248.5 248.5 0 0 1 111.65-81.26l.35.26-12.4 29.11 96.4 53.41 96.4-53.41-12.65-29.6A248.6 248.6 0 0 1 452 104l-31.7-2.84-21.16 108.5 80.62 75.24zM356.32 228L256 155.33 155.68 228l38.45 117.44h124.09z", "M352.4 52.11l-12.65-29.6a249 249 0 0 0-167.5 0l-12.65 29.6 96.4 53.41zm-34.18 293.37L356.32 228 256 155.33 155.68 228l38.45 117.44zM92.08 101.15L60 104A246.92 246.92 0 0 0 8 256c0 2.61.05 5.21.13 7.81l24.17 21.08 80.61-75.24zm252.26 276.44l-46.69 100.1 27.69 16.47A248.45 248.45 0 0 0 461 395.61l-7.15-31.45zM58.16 364.16L51 395.61a248.45 248.45 0 0 0 135.65 98.55l27.69-16.47-46.69-100.1zM452 104l-31.7-2.84-21.16 108.5 80.62 75.24 24.16-21.08c.08-2.6.13-5.2.13-7.81A246.92 246.92 0 0 0 452 104z"]],
    "game-board": [512, 512, [], "f867", ["M480 0H32A32 32 0 0 0 0 32v448a32 32 0 0 0 32 32h448a32 32 0 0 0 32-32V32a32 32 0 0 0-32-32zm-31.8 448H64v-96h.2v-96H64v-96h.2V64h384z", "M256 256v-96h-95.9V64.1h-96v96H160V256H64.2v96h96v-96zm0 96h-95.8v96h96v-96H352v-96h-96zm96.1 96.1h96v-96h-96zm.1-288.1v96h96v-96zm-96-96v96h96V64z"]],
    "game-board-alt": [512, 512, [], "f868", ["M480 0H32A32 32 0 0 0 0 32v448a32 32 0 0 0 32 32h448a32 32 0 0 0 32-32V32a32 32 0 0 0-32-32zm-31.8 448h-384V64h384z", "M256 64v192h192V64zM64 448h192V256H64z"]],
    "game-console-handheld": [384, 512, [], "f8bb", ["M352 0H32A32 32 0 0 0 0 32v448a32 32 0 0 0 32 32h256a96 96 0 0 0 96-96V32a32 32 0 0 0-32-32zM160 344a8 8 0 0 1-8 8h-24v24a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-24H72a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h24v-24a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v24h24a8 8 0 0 1 8 8zm72 40a24 24 0 1 1 24-24 24 24 0 0 1-24 24zM112 224a16 16 0 0 1-16-16V80a16 16 0 0 1 16-16h160a16 16 0 0 1 16 16v112a32 32 0 0 1-32 32zm184 112a24 24 0 1 1 24-24 24 24 0 0 1-24 24z", "M112 224a16 16 0 0 1-16-16V80a16 16 0 0 1 16-16h160a16 16 0 0 1 16 16v112a32 32 0 0 1-32 32z"]],
    "gamepad": [640, 512, [], "f11b", ["M480.07 96H160a160 160 0 1 0 114.24 272h91.52A160 160 0 1 0 480.07 96zM248 268a12 12 0 0 1-12 12h-52v52a12 12 0 0 1-12 12h-24a12 12 0 0 1-12-12v-52H84a12 12 0 0 1-12-12v-24a12 12 0 0 1 12-12h52v-52a12 12 0 0 1 12-12h24a12 12 0 0 1 12 12v52h52a12 12 0 0 1 12 12zm216 76a40 40 0 1 1 40-40 40 40 0 0 1-40 40zm64-96a40 40 0 1 1 40-40 40 40 0 0 1-40 40z", "M248 268a12 12 0 0 1-12 12h-52v52a12 12 0 0 1-12 12h-24a12 12 0 0 1-12-12v-52H84a12 12 0 0 1-12-12v-24a12 12 0 0 1 12-12h52v-52a12 12 0 0 1 12-12h24a12 12 0 0 1 12 12v52h52a12 12 0 0 1 12 12z"]],
    "gamepad-alt": [640, 512, [], "f8bc", ["M638.59 368.22l-33.37-211.59c-8.86-50.26-48.4-90.77-100.66-103.13h-.07a803.19 803.19 0 0 0-369 0C83.17 65.86 43.64 106.36 34.78 156.63L1.41 368.22C-8.9 426.73 38.8 480 101.51 480c49.67 0 93.77-30.07 109.48-74.64l7.52-21.36h203l7.49 21.36C444.72 449.93 488.82 480 538.49 480c62.71 0 110.41-53.27 100.1-111.78zM280 236a12 12 0 0 1-12 12h-52v52a12 12 0 0 1-12 12h-24a12 12 0 0 1-12-12v-52h-52a12 12 0 0 1-12-12v-24a12 12 0 0 1 12-12h52v-52a12 12 0 0 1 12-12h24a12 12 0 0 1 12 12v52h52a12 12 0 0 1 12 12zm152 76a40 40 0 1 1 40-40 40 40 0 0 1-40 40zm64-96a40 40 0 1 1 40-40 40 40 0 0 1-40 40z", "M280 236a12 12 0 0 1-12 12h-52v52a12 12 0 0 1-12 12h-24a12 12 0 0 1-12-12v-52h-52a12 12 0 0 1-12-12v-24a12 12 0 0 1 12-12h52v-52a12 12 0 0 1 12-12h24a12 12 0 0 1 12 12v52h52a12 12 0 0 1 12 12z"]],
    "gas-pump": [512, 512, [], "f52f", ["M256 0H96a64.06 64.06 0 0 0-64 64v384h288V64a64.06 64.06 0 0 0-64-64zm0 192H96V64h160z", "M256 64H96v128h160zm80 384H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm157.2-340.7l-81-81a16.06 16.06 0 0 0-22.6 0l-11.3 11.3a16.06 16.06 0 0 0 0 22.6L416 97.9V160a55.9 55.9 0 0 0 48 55.2V376a24 24 0 0 1-48 0v-32a88 88 0 0 0-88-88h-8v48h8a40 40 0 0 1 40 40v27.8c0 37.7 27 72 64.5 75.9A72.2 72.2 0 0 0 512 376V152.6a64.15 64.15 0 0 0-18.8-45.3z"]],
    "gas-pump-slash": [640, 512, [], "f5f4", ["M442.3 60.2a16.06 16.06 0 0 1 0-22.6l11.3-11.3a16.06 16.06 0 0 1 22.6 0l81 81a64.12 64.12 0 0 1 18.8 45.3V376a71.45 71.45 0 0 1-7.39 31.7L528 376.3V215.2a55.91 55.91 0 0 1-48-55.2V97.9zM370 416L96 204.21V416zM160 91.89V64h160v128h-30.47l190.33 147.11A88 88 0 0 0 392 256h-8V64a64.06 64.06 0 0 0-64-64H160a64.1 64.1 0 0 0-61 44.72zM400 448H80a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M636.64 480.55L617 505.82a16 16 0 0 1-22.46 2.81L6.18 53.9a16 16 0 0 1-2.81-22.45L23 6.18a16 16 0 0 1 22.47-2.81L633.82 458.1a16 16 0 0 1 2.82 22.45z"]],
    "gavel": [512, 512, [], "f0e3", ["M442.75 182.39L329.61 295.53 290 255.93l-81 81L175 303l81-81-39.6-39.6L329.61 69.26z", "M169 297.37a31.9 31.9 0 0 0-45.16 0L9.35 412.12a32 32 0 0 0 0 45.25l45.17 45.26a31.91 31.91 0 0 0 45.17 0l114.52-114.75a32 32 0 0 0 0-45.25zm7.49-109.32a23.92 23.92 0 0 0 33.87 0L334.61 63.6a24 24 0 0 0 0-33.94L312 7a23.93 23.93 0 0 0-33.88 0L153.94 131.48a24 24 0 0 0 0 33.94zM504 199.36l-22.6-22.62a23.9 23.9 0 0 0-33.87 0L323.32 301.19a24 24 0 0 0 0 33.94l22.58 22.62a23.91 23.91 0 0 0 33.88 0L504 233.3a24 24 0 0 0 0-33.94z"]],
    "gem": [576, 512, [], "f3a5", ["M100.7 192H0l218.7 255a3 3 0 0 0 5-3.3zm374.6 0l-123 251.7a3 3 0 0 0 5 3.2L576 192zm-327.1 0l137.1 318.2a3 3 0 0 0 5.5 0l137-318.2z", "M90.5 0L0 160h101.1L170.3 0zm395 0h-79.8l69.2 160H576zm-267 0l-69.2 160h277.4L357.5 0z"]],
    "genderless": [288, 512, [], "f22d", ["M144,336a80,80,0,1,1,80-80A80,80,0,0,1,144,336Z", "M144,112A144,144,0,1,0,288,256,144,144,0,0,0,144,112Zm0,224a80,80,0,1,1,80-80A80,80,0,0,1,144,336Z"]],
    "ghost": [384, 512, [], "f6e2", ["M186.1.09C81 3.24 0 94.92 0 200.05V464a16 16 0 0 0 27.31 11.31l24.92-18.53A16 16 0 0 1 73.74 459l43 48.35a16 16 0 0 0 22.63 0L180 461.46a16 16 0 0 1 23.92 0l40.72 45.85a16 16 0 0 0 22.63 0L310.26 459a16 16 0 0 1 21.51-2.21l24.92 18.53C366.77 485.36 384 478.22 384 464V192C384 84 294.83-3.17 186.1.09zM128 224a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm128 0a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M128 160a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm128 0a32 32 0 1 0 32 32 32 32 0 0 0-32-32z"]],
    "gift": [512, 512, [], "f06b", ["M224 320v160H64a32 32 0 0 1-32-32V320zm0-160H32a32 32 0 0 0-32 32v80a16 16 0 0 0 16 16h208zm256 0H288v128h208a16 16 0 0 0 16-16v-80a32 32 0 0 0-32-32zM288 480h160a32 32 0 0 0 32-32V320H288z", "M224 480h64V320h-64zM359.54 32c-41.82 0-68.86 21.3-103.54 68.3-34.68-47-61.72-68.3-103.54-68.3C103.71 32 64 71.5 64 120a85.65 85.65 0 0 0 10.15 40h78.21a40 40 0 1 1 0-80c20 0 34.78 3.3 86.55 80H224v128h64V160h-15c51.67-76.5 66-80 86.55-80a40 40 0 1 1 0 80h78.31A86.86 86.86 0 0 0 448 120c0-48.5-39.71-88-88.46-88z"]],
    "gift-card": [576, 512, [], "f663", ["M0 416h576v48a48 48 0 0 1-48 48H48a48 48 0 0 1-48-48zm528-288h-57.66a88.38 88.38 0 0 1-78.61 48h-48.48l62.41 51.71a16 16 0 0 1 0 22.63l-11.31 11.31a16 16 0 0 1-22.63 0L288 188.07l-83.73 73.59a16 16 0 0 1-22.63 0l-11.31-11.31a16 16 0 0 1 0-22.63L232.75 176h-48.48a88.38 88.38 0 0 1-78.61-48H48a48 48 0 0 0-48 48v144h576V176a48 48 0 0 0-48-48z", "M0 320v96h576v-96zm184.27-144h48.48l-62.41 51.72a16 16 0 0 0 0 22.63l11.31 11.31a16 16 0 0 0 22.63 0L288 188.07l83.71 73.58a16 16 0 0 0 22.63 0l11.31-11.31a16 16 0 0 0 0-22.63L343.25 176h48.48C440.4 176 480 136.52 480 88S440.4 0 391.73 0c-17.4 0-38.41 2.65-62.2 22.31C317.35 32.37 304.27 47 288 68.89c-16.32-22-29.51-36.61-41.87-46.75C222.37 2.63 201.52 0 184.27 0 135.6 0 96 39.48 96 88s39.6 88 88.27 88zM391.73 48a40 40 0 1 1 0 80h-86.67c51.74-76.5 66.14-80 86.67-80zm-207.46 0c20 0 34.83 3.3 86.67 80h-86.67a40 40 0 1 1 0-80z"]],
    "gifts": [640, 512, [], "f79c", ["M27 51.72l9.3-13A16 16 0 0 1 58.6 35l32.1 22.8-11.5-30.58a15.89 15.89 0 0 1 9.3-20.6l15-5.6a16 16 0 0 1 20.6 9.4l19.9 53.1 19.9-53a16 16 0 0 1 20.6-9.4l15 5.6a16 16 0 0 1 9.4 20.6l-11.5 30.6 32-22.9a15.9 15.9 0 0 1 22.3 3.7l9.3 13A15.9 15.9 0 0 1 257.3 74l-30.67 22H61.37L30.7 74A16 16 0 0 1 27 51.72zM224 256v88h184v-88h-65.88a68.15 68.15 0 0 1-44.4-16.33h-.05l-.06-.06-.2-.17-.2-.18A75.7 75.7 0 0 1 284 224h-28a32 32 0 0 0-32 32zm232 256h152a32 32 0 0 0 32-32v-88H456zm152-288h-28a75.7 75.7 0 0 1-13.21 15.18l-.2.18-.2.17-.07.06h-.05A68.15 68.15 0 0 1 521.88 256H456v88h184v-88a32 32 0 0 0-32-32zM224 392v88a32 32 0 0 0 32 32h152V392z", "M240.6 194.12c1.9-30.8 17.3-61.2 44-79.8A31.71 31.71 0 0 0 256 96H32a32 32 0 0 0-32 32v352a32 32 0 0 0 32 32h168.9a63.54 63.54 0 0 1-8.9-32V256a64 64 0 0 1 48.6-61.88zM456 344v-88h65.88a68.15 68.15 0 0 0 44.4-16.33h.05l.07-.06.2-.17.2-.18a73.09 73.09 0 0 0 25.2-55.55A74.58 74.58 0 0 0 576.29 138a69.14 69.14 0 0 0-24.07-19.58A72.41 72.41 0 0 0 519.9 111c-29.34 0-50.57 18.68-63.22 34.35C445.18 159.62 437 175.6 432 187c-5-11.46-13.23-27.52-24.75-41.76-12.62-15.6-33.82-34.2-63.15-34.2a72.41 72.41 0 0 0-32.32 7.35A69.14 69.14 0 0 0 287.71 138 74.58 74.58 0 0 0 272 183.71a73.09 73.09 0 0 0 25.16 55.47l.2.18.2.17.06.06h.05A68.15 68.15 0 0 0 342.12 256H408v88H224v48h184v120h48V392h184v-48zm63.9-184.65c17.7 0 24.1 14.6 24.1 24.36a24.78 24.78 0 0 1-8.8 19.13l-.06.06a20.35 20.35 0 0 1-13.26 4.77H475.4c8.8-20.43 25.8-48.32 44.5-48.32zm-177.78 48.32a20.35 20.35 0 0 1-13.26-4.77l-.06-.06a24.78 24.78 0 0 1-8.8-19.13c0-9.76 6.4-24.36 24.1-24.36 18.7 0 35.6 27.58 44.5 48.32z"]],
    "gingerbread-man": [416, 512, [], "f79d", ["M322.21 304H352a64.07 64.07 0 0 0 63.11-74.8c-5.1-31.5-34.71-53.2-66.51-53.2h-65.89a7.86 7.86 0 0 1-5.5-13.5c20.8-21.6 31.6-52.79 24.9-86.29-7.5-37.5-38.5-67.8-76-74.6C165-9.38 112 37.12 112 96a95.56 95.56 0 0 0 26.7 66.29c5 5.2 1.7 13.7-5.5 13.7H67.38C35.48 176 6 197.81.87 229.21A64.07 64.07 0 0 0 64 304h29.79a18.2 18.2 0 0 1 18.2 18.2 18.43 18.43 0 0 1-4.2 11.7l-58.21 69.8c-23.3 27.9-21.6 72.4 7.1 94.7A63 63 0 0 0 96 512a63.92 63.92 0 0 0 49.2-23l38.31-45.9a32 32 0 0 1 49.2 0L271 489a64.06 64.06 0 0 0 88.51 9.5c28.7-22.4 30.4-66.8 7.1-94.7l-58.2-69.8a18.43 18.43 0 0 1-4.2-11.7 18 18 0 0 1 18-18.3zM176 96a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm32 272a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm0-64a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm0-64a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm32-144a16 16 0 1 1 16-16 16 16 0 0 1-16 16z", "M208 240a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm0 32a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm0 64a16 16 0 1 0 16 16 16 16 0 0 0-16-16z"]],
    "glass": [384, 512, [], "f804", ["M93.8 448L73.22 160h237.55L290.2 448z", "M317.63 64L290.2 448H93.8L66.37 64h251.26M352 0H32A32 32 0 0 0 0 32c0 .67 0 1.33.06 2l32 448A32 32 0 0 0 64 512h256a32 32 0 0 0 31.94-30l32-448A32 32 0 0 0 354 .06c-.67 0-1.34-.06-2-.06z"]],
    "glass-champagne": [256, 512, [], "f79e", ["M64.44 221L78 128h100l13.59 93a55.77 55.77 0 0 1-10.26 39.82c-25.64 35.81-81.15 35.65-106.67 0A55.67 55.67 0 0 1 64.44 221z", "M216 464h-56V347.7c60.7-15.2 103.3-72 95-135.4L228 27.4A32.07 32.07 0 0 0 196.33 0H59.73A32.07 32.07 0 0 0 28 27.4L1 212.3c-8.3 63.4 34.3 120.2 95 135.4V464H40a40 40 0 0 0-40 40 8 8 0 0 0 8 8h240a8 8 0 0 0 8-8 40 40 0 0 0-40-40zM74.7 260.82A55.67 55.67 0 0 1 64.44 221L87.37 64h81.33l22.93 157a55.77 55.77 0 0 1-10.26 39.82c-25.64 35.81-81.15 35.65-106.67 0z"]],
    "glass-cheers": [640, 512, [], "f79f", ["M378.84 156.05l84.21-34.93 45.6 76a51.11 51.11 0 0 1 5.35 37.41c-9 39.24-56 59-90.43 37.72a51.21 51.21 0 0 1-22.77-30.13zm-252.68 78.48c9 39.24 56 59 90.42 37.72a51.18 51.18 0 0 0 22.78-30.13l22-86-84.23-34.94-45.57 76a51.15 51.15 0 0 0-5.4 37.35z", "M639.39 433.59a39.84 39.84 0 0 0-52.2-21.6l-22.09 9.2-38.7-101.88c47.89-35 64.79-100.29 34.5-152.78L474.3 16.05a32.1 32.1 0 0 0-40-13.59L320 49.85 205.71 2.46A31.71 31.71 0 0 0 193.46 0a32.05 32.05 0 0 0-27.75 16.05L79.12 166.53c-30.2 52.49-13.4 117.78 34.5 152.68l-38.7 101.88-22.1-9.2a39.84 39.84 0 0 0-52.2 21.6A8 8 0 0 0 4.92 444l162.29 67.39a8.13 8.13 0 0 0 3.1.62 7.88 7.88 0 0 0 7.3-4.92 40.08 40.08 0 0 0-21.61-52.3l-22.09-9.2L173.31 342c4.4.5 8.8 1.3 13.1 1.3 51.7 0 99.4-33.09 113.4-85.28L320 182.63 340.21 258c14 52.19 61.69 85.28 113.39 85.28 4.3 0 8.7-.8 13.1-1.3L506 445.59l-22.1 9.2a40 40 0 0 0-21.6 52.29 8 8 0 0 0 7.35 4.92 7.81 7.81 0 0 0 3.05-.62L635.09 444a8 8 0 0 0 4.3-10.41zm-400-191.47a51.18 51.18 0 0 1-22.78 30.13c-34.4 21.29-81.39 1.52-90.42-37.72a51.15 51.15 0 0 1 5.38-37.38l75-125 68.95 28.76zM514 234.53c-9 39.24-56 59-90.43 37.72a51.21 51.21 0 0 1-22.77-30.13l-36.04-141.18 68.94-28.76 74.95 125a51.11 51.11 0 0 1 5.35 37.35z"]],
    "glass-citrus": [512, 512, [], "f869", ["M512 144c0 78.32-62.61 141.73-140.48 143.64l4.85-48.49c49-4.31 87.63-45.08 87.63-95.15a96.11 96.11 0 0 0-96-96c-35.37 0-66 19.45-82.64 48h-52.54C252.65 40.2 305.39 0 368 0a144 144 0 0 1 144 144zM256 448l20.57-192H73.23L93.8 448z", "M283.43 192L256 448H93.8L66.37 192h217.06m34.37-64H32a32 32 0 0 0-32 32c0 .67 0 1.33.06 2l32 320A32 32 0 0 0 64 512h221.8a32 32 0 0 0 31.94-30l32-320a32 32 0 0 0-29.93-33.94c-.68 0-1.35-.06-2.01-.06z"]],
    "glass-martini": [512, 512, [], "f000", ["M405.12 64L256 213.13 106.84 64z", "M502 57.6C523.28 36.34 508.23 0 478.18 0H33.78C3.73 0-11.32 36.34 10 57.6l214 214V464h-56a40 40 0 0 0-40 40 8 8 0 0 0 8 8h240a8 8 0 0 0 8-8 40 40 0 0 0-40-40h-56V271.64zM256 213.13L106.84 64h298.28z"]],
    "glass-martini-alt": [512, 512, [], "f57b", ["M256 213.13L154.84 112h202.27z", "M405.12 64L256 213.13 106.84 64h298.28m73.06-64H33.78C3.73 0-11.32 36.34 10 57.6l214 214V464h-56a40 40 0 0 0-40 40 8 8 0 0 0 8 8h240a8 8 0 0 0 8-8 40 40 0 0 0-40-40h-56V271.64l214-214C523.28 36.34 508.23 0 478.18 0z"]],
    "glass-whiskey": [512, 512, [], "f7a0", ["M119.53 415.15L89.52 224h333.15l-29.81 191.22-.07.43v.31H119.73l-.06-.4z", "M442.63 96l-49.77 319.22-.07.43v.31H119.73l-.06-.4-.07-.44L69.42 96h373.21M480 32H32A32 32 0 0 0 .32 68.51l56 356.58A64 64 0 0 0 119.71 480h273a64.07 64.07 0 0 0 63.4-54.91l55.57-356.58A32 32 0 0 0 480 32z"]],
    "glass-whiskey-rocks": [512, 512, [], "f7a1", ["M119.6 415.59l.06.4h273.06v-.31l.07-.43L427.66 192H84.49l35 223.15zM327.43 233.7l46.87 46.89a33.19 33.19 0 0 1 0 46.89l-46.87 46.89a33.14 33.14 0 0 1-46.86 0l-46.87-46.89a33.19 33.19 0 0 1 0-46.89l46.87-46.89a33.15 33.15 0 0 1 46.86 0zM128 256a32 32 0 0 1 32-32h64a31.86 31.86 0 0 1 16.47 4.55L211.07 258a65.24 65.24 0 0 0 0 92.13L213 352h-53a32 32 0 0 1-32-32z", "M442.63 96l-49.77 319.22-.07.43v.31H119.73l-.06-.4-.07-.44L69.42 96h373.21M480 32H32A32 32 0 0 0 .32 68.51l56 356.58A64 64 0 0 0 119.71 480h273a64.07 64.07 0 0 0 63.4-54.91l55.57-356.58A32 32 0 0 0 480 32z"]],
    "glasses": [576, 512, [], "f530", ["M64 328.58v37.54C64 393.63 87 416 115.2 416h37.12c26.66 0 49.09-20.3 51.06-46.21l3.13-41.22a196.2 196.2 0 0 0-69.93-12.92A217.08 217.08 0 0 0 64 328.58zm448 37.55v-37.54a217.07 217.07 0 0 0-72.55-12.93 196.27 196.27 0 0 0-69.95 12.92l3.13 41.22c2 25.91 24.39 46.21 51.06 46.21h37.11C489 416 512 393.64 512 366.13z", "M574.1 280.38L528.75 98.67a87.94 87.94 0 0 0-113.19-62.14l-15.25 5.08a16 16 0 0 0-10.12 20.24L395.25 77a16 16 0 0 0 20.23 10.12l13.18-4.39c10.87-3.62 23-3.57 33.16 1.73a39.62 39.62 0 0 1 20.37 25.82l38.46 153.82a276.75 276.75 0 0 0-81.2-12.46c-34.77 0-74 7-114.85 26.74h-73.18c-40.87-19.74-80.08-26.75-114.86-26.75a276.76 276.76 0 0 0-81.21 12.46l38.46-153.8a39.59 39.59 0 0 1 20.38-25.81c10.16-5.3 22.28-5.35 33.15-1.73l13.17 4.39A16 16 0 0 0 180.74 77l5.06-15.18a16 16 0 0 0-10.12-20.22l-15.25-5.08A87.95 87.95 0 0 0 47.24 98.65L1.9 280.38A64.16 64.16 0 0 0 0 295.87v70.25C0 429 51.58 480 115.2 480h37.12c60.28 0 110.37-45.94 114.88-105.37l2.93-38.63h35.75l2.93 38.63C313.31 434.07 363.4 480 423.68 480h37.12c63.62 0 115.2-51 115.2-113.87v-70.25a64.24 64.24 0 0 0-1.9-15.5zM203.38 369.8c-2 25.91-24.4 46.21-51.06 46.21H115.2C87 416 64 393.63 64 366.12v-37.54a217.08 217.08 0 0 1 72.58-12.92 196.2 196.2 0 0 1 69.93 12.92zM460.8 416h-37.12c-26.67 0-49.1-20.3-51.06-46.21l-3.13-41.22a196.27 196.27 0 0 1 69.95-12.92A217.07 217.07 0 0 1 512 328.59v37.54c0 27.51-23 49.87-51.2 49.87z"]],
    "glasses-alt": [576, 512, [], "f5f5", ["M136 272a72 72 0 1 0 72 72 72.08 72.08 0 0 0-72-72zm304 0a72 72 0 1 0 72 72 72.08 72.08 0 0 0-72-72z", "M560.51 225.9L528.75 98.64C522.05 71.78 495 32 443.33 32c-15.63 0-23 2.94-43 9.6a16 16 0 0 0-10.12 20.24L395.25 77a16 16 0 0 0 15.18 11c3.54 0 4.82-.74 18.23-5.21 26.07-8.68 48.2 6.13 53.53 27.54L511.86 229A134.81 134.81 0 0 0 440 208c-55.09 0-102.27 32.91-123.65 80h-56.7c-21.38-47.09-68.56-80-123.65-80a134.89 134.89 0 0 0-71.86 21l29.67-118.72c5.32-21.41 27.46-36.22 53.53-27.54C160.76 87.21 162 88 165.57 88a16 16 0 0 0 15.18-11l5.06-15.18a16 16 0 0 0-10.12-20.24c-20-6.65-27.39-9.59-43-9.59C81 32 54 71.78 47.25 98.64L15.49 225.9C2.16 279.34 0 300.12 0 344a136 136 0 0 0 136 136c72.37 0 131-56.69 135.19-128h33.61c4.2 71.31 62.82 128 135.2 128a136 136 0 0 0 136-136c0-43.88-2.16-64.66-15.49-118.1zM136 416a72 72 0 1 1 72-72 72.08 72.08 0 0 1-72 72zm304 0a72 72 0 1 1 72-72 72.08 72.08 0 0 1-72 72z"]],
    "globe": [496, 512, [], "f0ac", ["M340.45,320H155.55a579.08,579.08,0,0,1,0-128h184.9A575,575,0,0,1,344,256,575,575,0,0,1,340.45,320ZM160.2,160H335.8c-.41-2.31-.84-4.62-1.28-6.91-6-30.85-14.42-58.37-25.13-81.78C299.54,49.77,288,32.54,276.05,21.48,266.38,12.53,256.94,8,248,8s-18.38,4.53-28,13.48c-12,11.06-23.49,28.29-33.34,49.83C176,94.72,167.5,122.24,161.53,153.09,161,155.38,160.61,157.69,160.2,160ZM120,256a608,608,0,0,1,3.34-64H8.35a249.52,249.52,0,0,0,0,128h115A608,608,0,0,1,120,256Zm367.62-64h-115A608.06,608.06,0,0,1,376,256a608,608,0,0,1-3.34,64h115a249.52,249.52,0,0,0,0-128ZM476.7,160A248.62,248.62,0,0,0,315.58,17.32c24.13,33,42.89,83.15,52.75,142.68ZM315.58,494.68A248.59,248.59,0,0,0,476.71,352H368.33C358.47,411.53,339.71,461.68,315.58,494.68ZM335.8,352H160.2c.41,2.31.84,4.62,1.28,6.91,6,30.85,14.42,58.37,25.13,81.78,9.85,21.54,21.38,38.77,33.34,49.83,9.67,9,19.11,13.48,28.05,13.48s18.38-4.53,28.05-13.48c12-11.06,23.49-28.29,33.34-49.83,10.71-23.41,19.16-50.93,25.13-81.78C335,356.62,335.39,354.31,335.8,352ZM180.42,17.32A248.59,248.59,0,0,0,19.29,160H127.67C137.53,100.47,156.29,50.32,180.42,17.32ZM19.29,352A248.59,248.59,0,0,0,180.42,494.68c-24.13-33-42.89-83.15-52.75-142.68Z", "M376,256a608,608,0,0,0-3.34-64h115a245.72,245.72,0,0,0-10.92-32H368.33c-9.86-59.53-28.62-109.68-52.75-142.68A248.23,248.23,0,0,0,248,8c8.94,0,18.38,4.53,28.05,13.48,12,11.06,23.49,28.29,33.34,49.83,10.71,23.41,19.16,50.93,25.13,81.78.44,2.29.87,4.6,1.28,6.91H160.2c.41-2.31.84-4.62,1.28-6.91,6-30.85,14.42-58.37,25.13-81.78C196.46,49.77,208,32.54,220,21.48,229.62,12.53,239.06,8,248,8a248.23,248.23,0,0,0-67.58,9.32c-24.13,33-42.89,83.15-52.75,142.68H19.29A245.72,245.72,0,0,0,8.37,192h115a613.93,613.93,0,0,0,0,128H8.37a245.72,245.72,0,0,0,10.92,32H127.67c9.86,59.53,28.62,109.68,52.75,142.68A248.23,248.23,0,0,0,248,504c-8.94,0-18.38-4.53-28.05-13.48-12-11.06-23.49-28.29-33.34-49.83-10.71-23.41-19.16-50.93-25.13-81.78-.44-2.29-.87-4.6-1.28-6.91H335.8c-.41,2.31-.84,4.62-1.28,6.91-6,30.85-14.42,58.37-25.13,81.78-9.85,21.54-21.38,38.77-33.34,49.83-9.67,9-19.11,13.48-28.05,13.48a248.23,248.23,0,0,0,67.58-9.32c24.13-33,42.89-83.15,52.75-142.68H476.71a245.72,245.72,0,0,0,10.92-32h-115A605.37,605.37,0,0,0,376,256Zm-35.54,64H155.55a579.08,579.08,0,0,1,0-128h184.9A575,575,0,0,1,344,256a575,575,0,0,1-3.55,64Z"]],
    "globe-africa": [496, 512, [], "f57c", ["M491.33,208H423.5A15.5,15.5,0,0,0,408,223.5h0v6.93a15.49,15.49,0,0,1-8.57,13.86L384,252a15.49,15.49,0,0,1-15.53-1L350.3,238.88a15.52,15.52,0,0,0-13.5-1.81l-2.65.88a15.47,15.47,0,0,0-9.83,19.56,15.83,15.83,0,0,0,1.83,3.74l13.24,19.86a15.49,15.49,0,0,0,12.89,6.9h8.21a15.5,15.5,0,0,1,15.5,15.5v11.34a15.52,15.52,0,0,1-3.1,9.3l-18.74,25a15.57,15.57,0,0,0-2.83,6.43L347,378.39a15.53,15.53,0,0,1-4.76,8.56,159.61,159.61,0,0,0-25,29.16l-13,19.55a27.77,27.77,0,0,1-47.91-3A78.82,78.82,0,0,1,248,397.39V367.5A15.5,15.5,0,0,0,232.5,352H206.62A54.63,54.63,0,0,1,152,297.37V283.31a54.65,54.65,0,0,1,21.85-43.7l27.58-20.69A54.6,54.6,0,0,1,234.2,208h.89a54.52,54.52,0,0,1,24.43,5.77l14.72,7.36a15.49,15.49,0,0,0,11.83.84l47.31-15.77a15.5,15.5,0,0,0-4.9-30.2H318.39a15.5,15.5,0,0,1-11-4.54l-6.92-6.92a15.5,15.5,0,0,0-11-4.54h-90A15.5,15.5,0,0,1,184,144.5v-4.4a15.52,15.52,0,0,1,11.74-15l14.45-3.61a15.53,15.53,0,0,0,9.14-6.44l8.08-12.11A15.47,15.47,0,0,1,240.3,96h24.21A15.5,15.5,0,0,0,280,80.49V10.05A249.89,249.89,0,0,0,248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256A249.51,249.51,0,0,0,491.33,208Z", "M423.5,208A15.5,15.5,0,0,0,408,223.5h0v6.93a15.49,15.49,0,0,1-8.57,13.86L384,252a15.49,15.49,0,0,1-15.53-1L350.3,238.88a15.52,15.52,0,0,0-13.5-1.81l-2.65.88a15.47,15.47,0,0,0-9.83,19.56,15.83,15.83,0,0,0,1.83,3.74l13.24,19.86a15.49,15.49,0,0,0,12.89,6.9h8.21a15.5,15.5,0,0,1,15.5,15.5v11.34a15.52,15.52,0,0,1-3.1,9.3l-18.74,25a15.57,15.57,0,0,0-2.83,6.43L347,378.39a15.53,15.53,0,0,1-4.76,8.56,159.61,159.61,0,0,0-25,29.16l-13,19.55a27.77,27.77,0,0,1-47.91-3A78.82,78.82,0,0,1,248,397.39V367.5A15.5,15.5,0,0,0,232.5,352H206.62A54.63,54.63,0,0,1,152,297.37V283.31a54.65,54.65,0,0,1,21.85-43.7l27.58-20.69A54.6,54.6,0,0,1,234.2,208h.89a54.52,54.52,0,0,1,24.43,5.77l14.72,7.36a15.49,15.49,0,0,0,11.83.84l47.31-15.77a15.5,15.5,0,0,0-4.9-30.2H318.39a15.5,15.5,0,0,1-11-4.54l-6.92-6.92a15.5,15.5,0,0,0-11-4.54h-90A15.5,15.5,0,0,1,184,144.5v-4.4a15.52,15.52,0,0,1,11.74-15l14.45-3.61a15.53,15.53,0,0,0,9.14-6.44l8.08-12.11A15.47,15.47,0,0,1,240.3,96h24.21A15.5,15.5,0,0,0,280,80.49V10.05C386,23.7,471,104.24,491.34,208Z"]],
    "globe-americas": [496, 512, [], "f57d", ["M489.55,312.41C464,422.22,365.59,504,248,504,111,504,0,393,0,256A247,247,0,0,1,56,99v45.71a50,50,0,0,0,8.55,27.95c11.72,17.39,28.38,42.07,35.67,52.77a114.79,114.79,0,0,0,18.06,20.74l.8.72a144.26,144.26,0,0,0,31.65,21.75c14,7.05,34.44,18.16,48.81,26.11a31.9,31.9,0,0,1,16.46,28v32a32,32,0,0,0,9.37,22.63c15,15,24.32,38.63,22.63,51.25V457.7a21,21,0,0,0,23.49,20.85c1.75-.21,3.49-.44,5.23-.7a20.91,20.91,0,0,0,17.17-15.76L308,404.46c2-5.49,3.26-11.21,4.77-16.87A23.9,23.9,0,0,1,319,376.88c3.32-3.33,7.41-7.4,11.31-11.28a46.46,46.46,0,0,0,13.72-33A30.49,30.49,0,0,0,335.1,311l-13.71-13.67A32,32,0,0,0,298.76,288H232c-9.41-4.71-21.48-32-32-32a67.72,67.72,0,0,1-30.31-7.16l-11.08-5.54a12,12,0,0,1,1.56-22l31.17-10.39A16,16,0,0,1,206.9,214l9.28,8.06a8,8,0,0,0,5.24,2h5.64a8,8,0,0,0,7.15-11.58l-15.59-31.19A8,8,0,0,1,220.2,172l9.92-9.65A8,8,0,0,1,235.7,160h9a8,8,0,0,0,5.66-2.34l8-8a8,8,0,0,0,0-11.31l-4.69-4.69a8,8,0,0,1,0-11.31L264,112l4.69-4.68a16,16,0,0,0,0-22.63h0l-24.4-24.4a12.38,12.38,0,0,0-9.55-3.61c-2.53.17-5.05.38-7.58.65A12.41,12.41,0,0,0,216,69.66a16.35,16.35,0,0,1-11.59,15.83,16,16,0,0,1-11.57-1.07,66.09,66.09,0,0,1-16-11.24L136.26,34.54A247,247,0,0,1,248,8C351.83,8,440.71,71.76,477.67,162.27l-36.51,3.15a76.22,76.22,0,0,0-27.48,7.74,24.05,24.05,0,0,0-9.24,8.15l-19.59,29.38a24,24,0,0,0,0,26.62l18,27a24,24,0,0,0,10.54,8.78l20.52,10.1Z", "M321.39,297.36A32,32,0,0,0,298.76,288H232c-9.41-4.71-21.48-32-32-32a67.72,67.72,0,0,1-30.31-7.16l-11.08-5.54a12,12,0,0,1,1.56-22l31.17-10.39A16,16,0,0,1,206.9,214l9.28,8.06a8,8,0,0,0,5.24,2h5.64a8,8,0,0,0,7.15-11.58l-15.59-31.19A8,8,0,0,1,220.2,172l9.92-9.65A8,8,0,0,1,235.7,160h9a8,8,0,0,0,5.66-2.34l8-8a8,8,0,0,0,0-11.31l-4.69-4.69a8,8,0,0,1,0-11.31L264,112l4.69-4.68a16,16,0,0,0,0-22.63h0l-24.4-24.4a12.38,12.38,0,0,0-9.55-3.61c-2.53.17-5.05.38-7.58.65A12.41,12.41,0,0,0,216,69.66a16.35,16.35,0,0,1-11.59,15.83,16,16,0,0,1-11.57-1.07,66.09,66.09,0,0,1-16-11.24L136.26,34.54A249,249,0,0,0,56,99v45.71a50,50,0,0,0,8.55,27.95c11.72,17.39,28.38,42.07,35.67,52.77a114.79,114.79,0,0,0,18.06,20.74l.8.72a144.26,144.26,0,0,0,31.65,21.75c14,7.05,34.44,18.16,48.81,26.11a31.9,31.9,0,0,1,16.46,28v32a32,32,0,0,0,9.37,22.63c15,15,24.32,38.63,22.63,51.25V457.7a21,21,0,0,0,23.49,20.85c1.75-.21,3.49-.44,5.23-.7a20.91,20.91,0,0,0,17.17-15.76L308,404.46c2-5.49,3.26-11.21,4.77-16.87A23.9,23.9,0,0,1,319,376.88c3.32-3.33,7.41-7.4,11.31-11.28a46.46,46.46,0,0,0,13.72-33A30.49,30.49,0,0,0,335.1,311ZM477.67,162.27l-36.51,3.15a76.22,76.22,0,0,0-27.48,7.74,24.05,24.05,0,0,0-9.24,8.15l-19.59,29.38a24,24,0,0,0,0,26.62l18,27a24,24,0,0,0,10.54,8.78l20.52,10.1,55.64,29.22a249.21,249.21,0,0,0-11.88-150.14Z"]],
    "globe-asia": [496, 512, [], "f57e", ["M312,16.35V50.73a28,28,0,0,1-11.12,22.35l-41.41,31.27a8,8,0,0,0,.86,13.81l10.83,5.41A16,16,0,0,1,280,137.88V216a8,8,0,0,1-8,8h-3.06a8,8,0,0,1-7.15-4.42,4.47,4.47,0,0,0-1.72-1.86,4.42,4.42,0,0,0-6.06,1.54h0l-17.34,29A16,16,0,0,1,222.94,256h-.31a16,16,0,0,0-11.32,4.69l-5.66,5.66a8,8,0,0,0,0,11.31l5.66,5.66A16,16,0,0,1,216,294.63V304a16,16,0,0,1-16,16h-6.1a16,16,0,0,1-14.28-8.85L157,265.92a8,8,0,0,0-10.72-3.6h0a8.14,8.14,0,0,0-2.11,1.53l-19.47,19.46A16,16,0,0,1,113.38,288H2.05C17.74,409.88,121.84,504,248,504c137,0,248-111,248-248C496,141.13,418,44.56,312,16.35Zm96,342.08a16,16,0,0,1-4.69,11.31l-9.57,9.57A16,16,0,0,1,382.43,384H367.27a16,16,0,0,1-11.36-4.74l-13-13a26.78,26.78,0,0,0-25.42-7l-21.27,5.32a15.86,15.86,0,0,1-3.88.48H282a16,16,0,0,1-11.24-4.69l-11.91-11.91a8,8,0,0,1-2.34-5.66V332.6a8,8,0,0,1,5-7.43l39.34-15.74a26.35,26.35,0,0,0,5.59-3.05l23.71-16.89a8,8,0,0,1,4.64-1.48h12.14a8,8,0,0,1,7.39,4.93l5.35,12.85a4,4,0,0,0,3.69,2.46h3.8a4,4,0,0,0,3.84-2.88l4.16-14.49A4,4,0,0,1,379,288h6.06a4,4,0,0,1,4,4v13a8,8,0,0,0,2.34,5.66l11.91,11.91A16,16,0,0,1,408,333.83Z", "M260.07,217.72a4.47,4.47,0,0,1,1.72,1.86,8,8,0,0,0,7.15,4.42H272a8,8,0,0,0,8-8V137.88a16,16,0,0,0-8.84-14.31l-10.83-5.41a8,8,0,0,1-.86-13.81l41.41-31.27A28,28,0,0,0,312,50.73V16.35A248.23,248.23,0,0,0,248,8C111,8,0,119,0,256a249.89,249.89,0,0,0,2.05,32H113.38a16,16,0,0,0,11.31-4.69l19.47-19.46A8,8,0,0,1,157,265.92l22.62,45.23A16,16,0,0,0,193.9,320H200a16,16,0,0,0,16-16v-9.37a16,16,0,0,0-4.69-11.31l-5.66-5.66a8,8,0,0,1,0-11.31l5.66-5.66A16,16,0,0,1,222.63,256h.31a16,16,0,0,0,13.72-7.77L254,219.28a4.42,4.42,0,0,1,6.05-1.57Zm143.24,104.8L391.4,310.61a8,8,0,0,1-2.34-5.66V292a4,4,0,0,0-4-4H379a4,4,0,0,0-3.84,2.88L371,305.37a4,4,0,0,1-3.84,2.88h-3.8a4,4,0,0,1-3.69-2.46l-5.35-12.85a8,8,0,0,0-7.39-4.93H334.79a8,8,0,0,0-4.64,1.48l-23.71,16.89a26.35,26.35,0,0,1-5.59,3.05l-39.34,15.74a8,8,0,0,0-5,7.43v10.2a8,8,0,0,0,2.34,5.66l11.91,11.91A16,16,0,0,0,282,365.06h10.34a15.86,15.86,0,0,0,3.88-.48l21.27-5.32a26.78,26.78,0,0,1,25.42,7l13,13A16,16,0,0,0,367.27,384h15.16a16,16,0,0,0,11.31-4.69l9.57-9.57A16,16,0,0,0,408,358.43v-24.6a16,16,0,0,0-4.69-11.31Z"]],
    "globe-europe": [496, 512, [], "f7a2", ["M487.54,320.4H438.9a15.8,15.8,0,0,1-11.4-4.8l-32-32.6a11.92,11.92,0,0,1,.1-16.7l12.5-12.5v-8.7a11.37,11.37,0,0,0-3.3-8l-9.4-9.4a11.37,11.37,0,0,0-8-3.3h-16a11.31,11.31,0,0,1-8-19.3l9.4-9.4a11.37,11.37,0,0,1,8-3.3h32a11.35,11.35,0,0,0,11.3-11.3v-9.4a11.35,11.35,0,0,0-11.3-11.3H376.1a16,16,0,0,0-16,16v4.5a16,16,0,0,1-10.9,15.2l-31.6,10.5a8,8,0,0,0-5.5,7.6v2.2a8,8,0,0,1-8,8h-16a8,8,0,0,1-8-8,8,8,0,0,0-8-8H269a8.14,8.14,0,0,0-7.2,4.4l-9.4,18.7a15.94,15.94,0,0,1-14.3,8.8H216a16,16,0,0,1-16-16V199a16,16,0,0,1,4.7-11.3l20.1-20.1a24.77,24.77,0,0,0,7.2-17.5,8,8,0,0,1,5.5-7.6l40-13.3a11.66,11.66,0,0,0,4.4-2.7l26.8-26.8a11.31,11.31,0,0,0-8-19.3H280l-16,16v8a8,8,0,0,1-8,8H240a8,8,0,0,1-8-8v-20a8.05,8.05,0,0,1,3.2-6.4l82.42-60.08A247.79,247.79,0,0,0,248,8C111,8,0,119,0,256S111,504,248,504a251.57,251.57,0,0,0,32.1-2.06V448.4a16,16,0,0,0-16-16H243.9c-10.8,0-26.7-5.3-35.4-11.8l-22.2-16.7a45.42,45.42,0,0,1-18.2-36.4V343.6a45.46,45.46,0,0,1,22.1-39l42.9-25.7a46.13,46.13,0,0,1,23.4-6.5h31.2a45.62,45.62,0,0,1,29.6,10.9l43.2,37.1h18.3a32,32,0,0,1,22.6,9.4l17.3,17.3.08.08C432,359.06,440,375.62,440,393.37V413A247.11,247.11,0,0,0,487.54,320.4ZM187.4,157.1a11.37,11.37,0,0,1-8,3.3h-16a11.31,11.31,0,0,1-8-19.3l25.4-25.4a11.31,11.31,0,0,1,19.3,8v16a11.37,11.37,0,0,1-3.3,8Z", "M187.4,157.1l9.4-9.4a11.37,11.37,0,0,0,3.3-8v-16a11.31,11.31,0,0,0-19.3-8l-25.4,25.4a11.31,11.31,0,0,0,8,19.3h16A11.37,11.37,0,0,0,187.4,157.1ZM418.78,347.18l-.08-.08-17.3-17.3a32,32,0,0,0-22.6-9.4H360.5l-43.2-37.1a45.62,45.62,0,0,0-29.6-10.9H256.5a46.13,46.13,0,0,0-23.4,6.5l-42.9,25.7a45.46,45.46,0,0,0-22.1,39v23.9a45.42,45.42,0,0,0,18.2,36.4l22.2,16.7c8.7,6.5,24.6,11.8,35.4,11.8h20.2a16,16,0,0,1,16,16v53.54A247.57,247.57,0,0,0,440,413V393.37C440,375.62,432,359.06,418.78,347.18ZM317.62,17.92,235.2,78a8.05,8.05,0,0,0-3.2,6.4v20a8,8,0,0,0,8,8h16a8,8,0,0,0,8-8v-8l16-16h20.7a11.31,11.31,0,0,1,8,19.3l-26.8,26.8a11.66,11.66,0,0,1-4.4,2.7l-40,13.3a8,8,0,0,0-5.5,7.6,24.77,24.77,0,0,1-7.2,17.5l-20.1,20.1A16,16,0,0,0,200,199v25.3a16,16,0,0,0,16,16h22.1a15.94,15.94,0,0,0,14.3-8.8l9.4-18.7a8.14,8.14,0,0,1,7.2-4.4h3.1a8,8,0,0,1,8,8,8,8,0,0,0,8,8h16a8,8,0,0,0,8-8v-2.2a8,8,0,0,1,5.5-7.6l31.6-10.5a16,16,0,0,0,10.9-15.2v-4.5a16,16,0,0,1,16-16h36.7a11.35,11.35,0,0,1,11.3,11.3v9.4a11.35,11.35,0,0,1-11.3,11.3h-32a11.37,11.37,0,0,0-8,3.3l-9.4,9.4a11.31,11.31,0,0,0,8,19.3h16a11.37,11.37,0,0,1,8,3.3l9.4,9.4a11.37,11.37,0,0,1,3.3,8v8.7l-12.5,12.5a11.92,11.92,0,0,0-.1,16.7l32,32.6a15.8,15.8,0,0,0,11.4,4.8h48.64A248.29,248.29,0,0,0,496,256C496,143.18,420.71,48,317.62,17.92Z"]],
    "globe-snow": [448, 512, [], "f7a3", ["M67.9 384H192v-32h-57.9c-14.2 0-22-15-12.9-24.9l65.5-71.1h-30.1c-10.7 0-16.5-11.2-9.7-18.7l67.4-73.2a13.35 13.35 0 0 1 19.3 0l67.4 73.2c6.8 7.4 1 18.7-9.7 18.7h-30.1l65.5 71.1c9.1 9.9 1.3 24.9-12.9 24.9H256v32h124.1c41.7-40.6 67.9-97.1 67.9-160C448 100.3 347.7 0 224 0S0 100.3 0 224c0 62.9 26.1 119.4 67.9 160zM336 160a16 16 0 1 1-16 16 16 16 0 0 1 16-16zm-96-96a16 16 0 1 1-16 16 16 16 0 0 1 16-16zM80 224a16 16 0 1 1-16 16 16 16 0 0 1 16-16z", "M134.1 352H192v32h64v-32h57.8c14.2 0 22-15 12.9-24.9L261.2 256h30.1c10.7 0 16.5-11.3 9.7-18.7l-67.4-73.2a13.35 13.35 0 0 0-19.3 0l-67.4 73.2c-6.8 7.5-1 18.7 9.7 18.7h30.1l-65.5 71.1c-9.1 9.9-1.3 24.9 12.9 24.9zm297.3 135.1L384 416H64l-47.4 71.1A16 16 0 0 0 29.9 512h388.2a16 16 0 0 0 13.3-24.9z"]],
    "globe-stand": [448, 512, [], "f5f6", ["M94.87 305.14a160 160 0 1 1 226.27 0 160 160 0 0 1-226.27 0z", "M4.69 377.38l59.5-59.5c2.82 3.23 5 6.81 8.07 9.88a192.1 192.1 0 0 0 271.62 0c74.89-74.86 74.89-196.67 0-271.53-3-3-6.23-5.74-9.41-8.53l43-43a16 16 0 0 1 22.64 0L411.45 16a16 16 0 0 1 0 22.63l-10.7 10.7c69.82 93.94 62.34 227.16-22.91 312.38A238.35 238.35 0 0 1 256.09 427v37h92a36 36 0 0 1 36 36 12 12 0 0 1-12 12H76a12 12 0 0 1-12-12 36 36 0 0 1 36-36h92v-32.75a239.42 239.42 0 0 1-126.65-46.64l-26.71 26.7a16 16 0 0 1-22.64 0L4.69 400a16 16 0 0 1 0-22.62z"]],
    "golf-ball": [416, 512, [], "f450", ["M208 0C93.1 0 0 93.1 0 208c0 74.2 39 139.2 97.5 176h221C377 347.2 416 282.2 416 208 416 93.1 322.9 0 208 0zm-3 229.8c26.3 9.4 51.5-15.1 41.9-41.9a32.91 32.91 0 1 1-41.9 41.9zm46.9 102.1a32.88 32.88 0 0 1-30.9-22.1c26.3 9.4 51.5-15.1 41.9-41.9a32.91 32.91 0 0 1-11 64zm64-64a32.88 32.88 0 0 1-30.9-22.1c26.3 9.4 51.5-15.1 41.9-41.9a32.91 32.91 0 0 1-11 64z", "M326.9 203.9c9.6 26.8-15.6 51.3-41.9 41.9a32.91 32.91 0 1 0 41.9-41.9zM221 309.8a32.91 32.91 0 1 0 41.9-41.9c9.6 26.8-15.6 51.3-41.9 41.9zm14.9-57.9a32.91 32.91 0 0 0 11-64c9.6 26.8-15.6 51.3-41.9 41.9a32.88 32.88 0 0 0 30.9 22.1zM128 448h16a32 32 0 0 1 32 32v20a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-20a32 32 0 0 1 32-32h16a32 32 0 0 0 32-32H96a32 32 0 0 0 32 32z"]],
    "golf-club": [640, 512, [], "f451", ["M64 205.15a64 64 0 0 0-64 64v26.9h120a8 8 0 0 1 8 8v32a8 8 0 0 1-8 8H0v48h120a8 8 0 0 1 8 8v32a8 8 0 0 1-8 8H0v8a64.06 64.06 0 0 0 64 64h302.6a64 64 0 0 0 57.7-36.26l90-187.42-438.5-82.12a64 64 0 0 0-11.8-1.1z", "M120 392.05H0v48h120a8 8 0 0 0 8-8v-32a8 8 0 0 0-8-8zm0-96H0v48h120a8 8 0 0 0 8-8v-32a8 8 0 0 0-8-8zM631 8.59l-14.4-6.94-.18-.09a15.91 15.91 0 0 0-21.22 7.49L465.55 279.24l48.76 9.13L638.4 30A16.14 16.14 0 0 0 631 8.59z"]],
    "gopuram": [512, 512, [], "f664", ["M160 224h32v-96h-32zm-32 128h32V224h-32zM96 512h32V352H96zm256-288v128h32V224zm-32-96v96h32v-96zm64 224v160h32V352z", "M496 352h-16V240a16 16 0 0 0-16-16h-16v-80a16 16 0 0 0-16-16h-16V16a16 16 0 0 0-32 0v16h-64V16a16 16 0 0 0-32 0v16h-64V16a16 16 0 0 0-32 0v16h-64V16a16 16 0 0 0-32 0v112H80a16 16 0 0 0-16 16v80H48a16 16 0 0 0-16 16v112H16a16 16 0 0 0-16 16v128a16 16 0 0 0 16 16h80V352h32V224h32v-96h32v96h-32v128h-32v160h80v-80a16 16 0 0 1 16-16h64a16 16 0 0 1 16 16v80h80V352h-32V224h-32v-96h32v96h32v128h32v160h80a16 16 0 0 0 16-16V368a16 16 0 0 0-16-16zM232 176a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v48h-48zm56 176h-64v-64a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16z"]],
    "graduation-cap": [640, 512, [], "f19d", ["M323.07 175.7L118.8 215.6a48.1 48.1 0 0 0-38.74 44.73 32 32 0 0 1 2.21 53.94l25.4 114.26A16 16 0 0 1 92 448H35.94a16 16 0 0 1-15.61-19.47l25.39-114.27a32 32 0 0 1 2.33-54 80.16 80.16 0 0 1 64.62-76.07l204.26-39.89a16 16 0 1 1 6.14 31.4z", "M622.33 198.8l-279 85.7a80 80 0 0 1-46.79 0L99.67 224a47.84 47.84 0 0 1 19.13-8.39l204.27-39.9a16 16 0 1 0-6.14-31.4l-204.26 39.88a79.87 79.87 0 0 0-47.57 29.18l-47.44-14.58c-23.54-7.23-23.54-38.36 0-45.59L296.6 67.5a79.92 79.92 0 0 1 46.8 0l278.93 85.7c23.55 7.24 23.55 38.36 0 45.6zM352.79 315.09a111.94 111.94 0 0 1-65.59 0l-145-44.55L128 384c0 35.35 86 64 192 64s192-28.65 192-64l-14.19-113.47z"]],
    "gramophone": [384, 512, [], "f8bd", ["M69.56 317.08c62.84-43.05 161.76-94.4 238.6-73.8A26.79 26.79 0 0 1 328 269.15a34.81 34.81 0 0 1-34.78 34.77H184a24 24 0 0 0-24 24v24h133.22A82.88 82.88 0 0 0 376 269.15a74.89 74.89 0 0 0-55.41-72.27C243.17 176.13 183 80.83 150.84 13.62 141.2-6.5 111.76-3.68 106 17.79L32.82 291.06c-5.82 21.62 18.53 38.49 36.74 26.02z", "M368 448h-16v-32a32 32 0 0 0-32-32H64a32 32 0 0 0-32 32v32H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h352a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "greater-than": [384, 512, [], "f531", ["M18.49 358L237 256.1 18.53 154.25A32.09 32.09 0 0 1 3 111.61l13.58-29.08A32.09 32.09 0 0 1 59.22 67l306.3 142.84a32 32 0 0 1 18.49 29v34.23a32 32 0 0 1-18.48 29L59.06 445a32 32 0 0 1-42.53-15.48L3 400.52A32 32 0 0 1 18.49 358z", ""]],
    "greater-than-equal": [448, 512, [], "f532", ["M24 400h400a24 24 0 0 1 24 24v48a24 24 0 0 1-24 24H24a24 24 0 0 1-24-24v-48a24 24 0 0 1 24-24z", "M55.34 243.83l175.44-68.05-175.56-68.09c-18.29-6-27.74-24.26-21.1-40.79L46.15 37C52.79 20.45 73 11.92 91.3 17.92L393 137.9c13.77 4.52 23 16.61 23 30.17v16c0 13.56-9.21 25.65-23 30.17L91.61 334.06c-18.39 6-38.7-2.54-45.38-19.15l-12.09-30.08c-6.68-16.61 2.86-34.97 21.2-41z"]],
    "grimace": [496, 512, [], "f57f", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8ZM144,400h-8a32,32,0,0,1-32-32v-8h40Zm0-56H104v-8a32,32,0,0,1,32-32h8Zm-8-136a32,32,0,1,1,32,32A32,32,0,0,1,136,208Zm72,192H160V360h48Zm0-56H160V304h48Zm64,56H224V360h48Zm0-56H224V304h48Zm64,56H288V360h48Zm0-56H288V304h48Zm-8-104a32,32,0,1,1,32-32A32,32,0,0,1,328,240Zm64,128a32,32,0,0,1-32,32h-8V360h40Zm0-24H352V304h8a32,32,0,0,1,32,32Z", "M168,176a32,32,0,1,0,32,32A32,32,0,0,0,168,176Zm160,0a32,32,0,1,0,32,32A32,32,0,0,0,328,176Z"]],
    "grin": [496, 512, [], "f580", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8Zm80,168a32,32,0,1,1-32,32A32,32,0,0,1,328,176Zm-160,0a32,32,0,1,1-32,32A32,32,0,0,1,168,176ZM391.8,338.7c-9.3,55-83.2,93.3-143.8,93.3s-134.5-38.3-143.8-93.3a16,16,0,0,1,20.7-17.9C155.1,330.5,200,336,248,336s92.9-5.5,123.1-15.2c11.3-3.7,22.6,6.1,20.7,17.9Z", "M168,176a32,32,0,1,0,32,32A32,32,0,0,0,168,176Zm160,0a32,32,0,1,0,32,32A32,32,0,0,0,328,176Z"]],
    "grin-alt": [496, 512, [], "f581", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8Zm63.7,128.7a19.76,19.76,0,0,1,32.7,0c12.4,18.4,15.1,36.9,15.7,55.3-.5,18.4-3.3,36.9-15.7,55.3a19.76,19.76,0,0,1-32.7,0c-12.4-18.4-15.1-36.9-15.7-55.3C296.5,173.6,299.3,155.1,311.7,136.7Zm-160,0a19.76,19.76,0,0,1,32.7,0c12.4,18.4,15.1,36.9,15.7,55.3-.5,18.4-3.3,36.9-15.7,55.3a19.76,19.76,0,0,1-32.7,0c-12.4-18.4-15.1-36.9-15.7-55.3C136.5,173.6,139.3,155.1,151.7,136.7Zm240.1,202c-9.3,55-83.2,93.3-143.8,93.3s-134.5-38.3-143.8-93.3a16,16,0,0,1,20.7-17.9C155.1,330.5,200,336,248,336s92.9-5.5,123.1-15.2a16,16,0,0,1,20.7,17.9Z", "M151.7,136.7c-12.4,18.4-15.2,36.9-15.7,55.3.6,18.4,3.3,36.9,15.7,55.3a19.76,19.76,0,0,0,32.7,0c12.4-18.4,15.2-36.9,15.7-55.3-.6-18.4-3.3-36.9-15.7-55.3a19.76,19.76,0,0,0-32.7,0Zm192.7,0a19.76,19.76,0,0,0-32.7,0c-12.4,18.4-15.2,36.9-15.7,55.3.6,18.4,3.3,36.9,15.7,55.3a19.76,19.76,0,0,0,32.7,0c12.4-18.4,15.2-36.9,15.7-55.3C359.5,173.6,356.8,155.1,344.4,136.7Z"]],
    "grin-beam": [496, 512, [], "f582", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8Zm24.2,215.4c3.1-42.1,32-71.4,55.8-71.4s52.7,29.3,56,71.4c.7,8.6-10.8,11.9-14.9,4.5l-9.5-17c-7.7-13.7-19.2-21.6-31.5-21.6s-23.8,7.9-31.5,21.6l-9.5,17C283,235.2,271.5,231.9,272.2,223.4Zm-160,0c3.1-42.1,32-71.4,55.8-71.4s52.7,29.3,56,71.4c.7,8.6-10.8,11.9-14.9,4.5l-9.5-17c-7.7-13.7-19.2-21.6-31.5-21.6s-23.8,7.9-31.5,21.6l-9.5,17C122.9,235.3,111.5,231.9,112.2,223.4ZM391.8,338.7c-9.3,55-83.2,93.3-143.8,93.3s-134.5-38.3-143.8-93.3a16,16,0,0,1,20.7-17.9C155.1,330.5,200,336,248,336s92.9-5.5,123.1-15.2a16,16,0,0,1,20.7,17.9Z", "M168,152c-23.8,0-52.7,29.3-55.8,71.4-.7,8.5,10.7,11.9,14.9,4.5l9.5-17c7.7-13.7,19.2-21.6,31.5-21.6s23.8,7.9,31.5,21.6l9.5,17c4.1,7.4,15.6,4.1,14.9-4.5-3.3-42.1-32.2-71.4-56-71.4Zm216,71.4c-3.3-42.1-32.2-71.4-56-71.4s-52.7,29.3-55.8,71.4c-.7,8.5,10.8,11.8,14.9,4.5l9.5-17c7.7-13.7,19.2-21.6,31.5-21.6s23.8,7.9,31.5,21.6l9.5,17C373.2,235.3,384.7,232,384,223.4Z"]],
    "grin-beam-sweat": [504, 512, [], "f583", ["M456,160c-44.1,0-80-35.4-80-79,0-4.41.3-14.2,8.1-32.2A246.82,246.82,0,0,0,248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256a247.08,247.08,0,0,0-20.5-98.61A83.3,83.3,0,0,1,456,160ZM272.2,223.4c3.1-42.09,32-71.4,55.8-71.4s52.7,29.31,56,71.4c.7,8.6-10.8,12-14.9,4.5l-9.5-17c-7.7-13.69-19.2-21.59-31.5-21.59s-23.8,7.9-31.5,21.59l-9.5,17c-4.1,7.43-15.6,4-14.9-4.48Zm-160,0c3.1-42.09,32-71.4,55.8-71.4s52.7,29.31,56,71.4c.7,8.6-10.8,12-14.9,4.5l-9.5-17c-7.7-13.69-19.2-21.59-31.5-21.59s-23.8,7.9-31.5,21.59l-9.5,17c-4.2,7.43-15.6,4-14.9-4.48ZM391.8,338.72C382.5,393.72,308.6,432,248,432s-134.5-38.3-143.8-93.3a16,16,0,0,1,20.7-17.9C155.1,330.51,200,336,248,336s92.9-5.5,123.1-15.19a16.05,16.05,0,0,1,20.7,17.92Z", "M462.4,3.2a8,8,0,0,0-11.2-1.6h0a7.58,7.58,0,0,0-1.6,1.6C436.5,20.59,408,61,408,81c0,26,21.5,47,48,47s48-21,48-47C504,61,475.5,20.59,462.4,3.2ZM168,152c-23.8,0-52.7,29.31-55.8,71.4-.7,8.5,10.7,11.91,14.9,4.5l9.5-17c7.7-13.69,19.2-21.59,31.5-21.59s23.8,7.9,31.5,21.59l9.5,17c4.1,7.5,15.6,4.1,14.9-4.5-3.3-42.07-32.2-71.4-56-71.4Zm160,0c-23.8,0-52.7,29.31-55.8,71.4-.7,8.5,10.8,11.91,14.9,4.5l9.5-17c7.7-13.69,19.2-21.59,31.5-21.59s23.8,7.9,31.5,21.59l9.5,17c4.1,7.5,15.6,4.1,14.9-4.5C380.7,181.31,351.8,152,328,152Z"]],
    "grin-hearts": [496, 512, [], "f584", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8ZM90.4,183.6c6.7-17.6,26.7-26.7,44.9-21.9l7.1,1.9,2-7.1c5-18.1,22.8-30.9,41.5-27.9a35.38,35.38,0,0,1,29.71,40.26h0a35.93,35.93,0,0,1-.91,4.24L195.3,243a8.59,8.59,0,0,1-10.5,6l-70.2-18.2a35.49,35.49,0,0,1-25.47-43.25h0A34.27,34.27,0,0,1,90.4,183.6ZM391.8,338.7c-9.3,55-83.2,93.3-143.8,93.3s-134.5-38.3-143.8-93.3a16,16,0,0,1,20.7-17.9C155.1,330.5,200,336,248,336s92.9-5.5,123.1-15.2a16.08,16.08,0,0,1,20.7,17.9Zm-10.4-108-70.2,18.2a8.68,8.68,0,0,1-10.5-6L281.3,173a35.38,35.38,0,0,1,24.54-43.59h0a35.93,35.93,0,0,1,4.24-.91c18.6-3,36.4,9.8,41.5,27.9l2,7.1,7.1-1.9c18.2-4.7,38.2,4.3,44.9,21.9a35.42,35.42,0,0,1-20.1,45.88,36.92,36.92,0,0,1-4.1,1.32Z", "M185.9,128.6c-18.7-3-36.5,9.8-41.5,27.9l-2,7.1-7.1-1.9c-18.2-4.8-38.2,4.3-44.9,21.9a35.5,35.5,0,0,0,20.25,45.93,36.32,36.32,0,0,0,3.95,1.27L184.8,249a8.59,8.59,0,0,0,10.5-6l19.4-69.9a35.38,35.38,0,0,0-24.54-43.59h0a35.93,35.93,0,0,0-4.24-.91Zm219.7,54.9c-6.7-17.6-26.7-26.6-44.9-21.9l-7.1,1.9-2-7.1c-5.1-18.1-22.9-30.9-41.5-27.9a35.38,35.38,0,0,0-29.71,40.26h0a35.93,35.93,0,0,0,.91,4.24l19.4,69.9a8.68,8.68,0,0,0,10.5,6l70.2-18.2a35.4,35.4,0,0,0,25.52-43.08v0a36.92,36.92,0,0,0-1.32-4.1Z"]],
    "grin-squint": [496, 512, [], "f585", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8Zm33.8,189.7,80-48c11.6-6.9,24,7.7,15.4,18L343.6,208l33.6,40.3c8.7,10.4-3.9,24.8-15.4,18l-80-48a12.07,12.07,0,0,1,0-20.6Zm-147.6-48,80,48a12,12,0,0,1,0,20.6l-80,48c-11.5,6.8-24-7.6-15.4-18L152.4,208l-33.6-40.3c-8.6-10.3,3.8-24.9,15.4-18Zm257.6,189c-9.3,55-83.2,93.3-143.8,93.3s-134.5-38.3-143.8-93.3a16,16,0,0,1,20.7-17.9C155.1,330.5,200,336,248,336s92.9-5.5,123.1-15.2a16.06,16.06,0,0,1,20.7,17.9Z", "M214.2,197.7l-80-48c-11.6-6.9-24,7.7-15.4,18L152.4,208l-33.6,40.3c-8.6,10.4,3.9,24.8,15.4,18l80-48a12,12,0,0,0,0-20.6Zm163,50.6L343.6,208l33.6-40.3c8.6-10.3-3.8-24.9-15.4-18l-80,48a12.07,12.07,0,0,0,0,20.6l80,48C373.3,273.1,385.9,258.7,377.2,248.3Z"]],
    "grin-squint-tears": [512, 512, [], "f586", ["M414.12 143.6c-33 3.9-48.6-25.1-45.7-45.7 3.4-24 7.4-42.1 11.5-56.5-94.8-54.8-218.1-41.9-299.3 39.2s-94 204.4-39.2 299.3c14.4-4.1 32.4-8 56.5-11.5 33.2-3.9 48.6 25.2 45.7 45.7-3.4 24-7.4 42.1-11.5 56.5 94.8 54.8 218.1 41.9 299.3-39.2s94-204.4 39.2-299.3c-14.4 4.1-32.5 8-56.5 11.5zm-180.9 53l22.5-90.6c3.3-13.2 22.4-11.5 23.6 1.8l4.8 52.3 52.3 4.8c13.4 1.2 14.9 20.3 1.8 23.6l-90.5 22.6a12 12 0 0 1-14.5-14.5zm-68.4 139.7L160 284l-52.3-4.8c-13.4-1.2-14.9-20.3-1.8-23.6l90.5-22.6a12 12 0 0 1 14.5 14.5L188.32 338c-3.1 13.2-22.2 11.7-23.5-1.7zm215.7 44.2c-29.3 29.3-75.7 50.4-116.7 50.4-18.9 0-36.6-4.5-51-14.7a15.92 15.92 0 0 1 2-27.2c28.3-14.6 63.9-42.4 97.8-76.3s61.7-69.6 76.3-97.8a16 16 0 0 1 27.3-2c32.3 45.3 7.1 124.7-35.7 167.6z", "M102.42 400.1c-22.6 3.2-73.5 12-88.3 26.8-19.1 19.1-18.8 50.6.8 70.2s51 19.9 70.2.7c14.8-14.8 23.5-65.7 26.8-88.3a8.31 8.31 0 0 0-9.5-9.4zm94-167.1l-90.5 22.6c-13.1 3.3-11.6 22.4 1.8 23.6L160 284l4.8 52.3c1.3 13.4 20.4 14.9 23.5 1.7l22.6-90.5a12 12 0 0 0-14.48-14.5zm140-68.1l-52.3-4.8-4.8-52.3c-1.2-13.3-20.3-15-23.6-1.8l-22.5 90.6a12 12 0 0 0 14.5 14.5l90.5-22.6c13.1-3.3 11.6-22.4-1.8-23.6zm160.8-150C477.62-4.7 446-5 426.92 14.2c-14.8 14.8-23.5 65.7-26.8 88.3a8.31 8.31 0 0 0 9.5 9.4c22.6-3.2 73.5-12 88.3-26.8 19.2-19.2 18.9-50.6-.7-70.2z"]],
    "grin-stars": [496, 512, [], "f587", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8ZM94.6,168.9l34.9-5L145,132.3a7.73,7.73,0,0,1,13.9,0l15.5,31.6,34.9,5a7.78,7.78,0,0,1,4.3,13.2l-25.4,24.6,6,34.9a7.48,7.48,0,0,1-11,7.9L152,233.3l-31.3,16.3a7.48,7.48,0,0,1-11-7.9l6-34.9L90.3,182.2a7.85,7.85,0,0,1,4.3-13.3ZM391.8,338.7c-9.3,55-83.2,93.3-143.8,93.3s-134.5-38.3-143.8-93.3a16.06,16.06,0,0,1,20.7-17.9C155.1,330.5,200,336,248,336s92.9-5.5,123.1-15.2a16,16,0,0,1,20.7,17.9Zm13.9-156.6-25.4,24.6,6,34.9a7.48,7.48,0,0,1-11,7.9L344,233.3l-31.3,16.3a7.48,7.48,0,0,1-11-7.9l6-34.9-25.4-24.6a7.81,7.81,0,0,1,4.3-13.2l34.9-5L337,132.4a7.73,7.73,0,0,1,13.9,0L366.4,164l34.9,5a7.7,7.7,0,0,1,4.4,13.1Z", "M209.3,168.9l-34.9-5-15.5-31.6a7.73,7.73,0,0,0-13.9,0l-15.5,31.6-34.9,5a7.85,7.85,0,0,0-4.3,13.3l25.4,24.6-6,34.9a7.48,7.48,0,0,0,11,7.9L152,233.3l31.2,16.2a7.48,7.48,0,0,0,11-7.9l-6-34.9,25.4-24.6a7.78,7.78,0,0,0-4.3-13.2Zm192,.1-34.9-5-15.5-31.6a7.73,7.73,0,0,0-13.9,0L321.5,164l-34.9,5a7.81,7.81,0,0,0-6.47,8.95V178a7.92,7.92,0,0,0,2.16,4.24l25.4,24.6-6,34.9a7.48,7.48,0,0,0,11,7.9L344,233.3l31.3,16.2a7.48,7.48,0,0,0,11-7.9l-6-34.9,25.4-24.6a7.68,7.68,0,0,0-4.4-13.1Z"]],
    "grin-tears": [640, 512, [], "f588", ["M496.42 270.1a40.45 40.45 0 0 1 45.7-45.7c8.9 1.3 16.8 2.7 24.3 4.1C552.72 104.5 447.72 8 320 8S87.32 104.5 73.62 228.5c7.5-1.4 15.4-2.8 24.3-4.1 33.2-3.9 48.6 25.3 45.7 45.7-11.8 82.3-29.9 100.4-35.8 106.4-.9.9-2 1.6-3 2.5 42.7 74.6 123 125 215.2 125s172.5-50.4 215.2-125.1a36.12 36.12 0 0 1-3-2.5c-5.9-5.9-24-24-35.8-106.3zm-152.2-46.7c3.1-42.1 32-71.4 55.8-71.4s52.7 29.3 56 71.4c.7 8.6-10.8 12-14.9 4.5l-9.5-17c-7.7-13.7-19.2-21.6-31.5-21.6s-23.8 7.9-31.5 21.6l-9.5 17c-4.2 7.4-15.6 4-14.9-4.5zm-160 0c3.1-42.1 32-71.4 55.8-71.4s52.7 29.3 56 71.4c.7 8.6-10.8 12-14.9 4.5l-9.5-17c-7.7-13.7-19.2-21.6-31.5-21.6s-23.8 7.9-31.5 21.6l-9.5 17c-4.2 7.4-15.6 4-14.9-4.5zm279.6 115.3c-9.3 55-83.2 93.3-143.8 93.3s-134.5-38.3-143.8-93.3a16 16 0 0 1 20.7-17.9C227.12 330.5 272 336 320 336s92.9-5.5 123.1-15.2a16.05 16.05 0 0 1 20.72 17.9z", "M102.42 256.1c-22.6 3.2-73.5 12-88.3 26.8-19.1 19.1-18.8 50.6.8 70.2s51 19.9 70.2.7c14.8-14.8 23.5-65.7 26.8-88.3a8.31 8.31 0 0 0-9.5-9.4zM240 152c-23.8 0-52.7 29.3-55.8 71.4-.7 8.5 10.7 11.9 14.9 4.5l9.5-17c7.7-13.7 19.2-21.6 31.5-21.6s23.8 7.9 31.5 21.6l9.5 17c4.1 7.5 15.6 4.1 14.9-4.5-3.28-42.1-32.18-71.4-56-71.4zm385.8 130.9c-14.8-14.8-65.7-23.5-88.3-26.8a8.38 8.38 0 0 0-9.5 9.5c3.2 22.6 12 73.5 26.8 88.3 19.2 19.2 50.6 18.9 70.2-.7s20-51.2.82-70.3zM400 152c-23.8 0-52.7 29.3-55.8 71.4-.7 8.5 10.7 11.9 14.9 4.5l9.5-17c7.7-13.7 19.2-21.6 31.5-21.6s23.8 7.9 31.5 21.6l9.5 17c4.1 7.5 15.6 4.1 14.9-4.5-3.28-42.1-32.18-71.4-56-71.4z"]],
    "grin-tongue": [496, 512, [], "f589", ["M248,8C111,8,0,119,0,256.06c0,106.32,67,196.73,161,232a95.5,95.5,0,0,1-9-40V402.58c-24.7-16.2-43.5-38.1-47.8-63.81a16.06,16.06,0,0,1,20.7-17.9c30.2,9.7,75.1,15.2,123.1,15.2s92.9-5.5,123.1-15.2a16.08,16.08,0,0,1,20.7,17.9c-4.3,25.71-23.1,47.61-47.8,63.81v45.51a95.5,95.5,0,0,1-9,40c94-35.31,161-125.72,161-232C496,119,385,8,248,8ZM168,240a32,32,0,1,1,32-32A32,32,0,0,1,168,240Zm160,0a32,32,0,1,1,32-32A32,32,0,0,1,328,240Z", "M258.5,392.28l-1.8,7.8c-2.1,9.21-15.2,9.21-17.3,0l-1.8-7.8c-3.5-15.4-20.2-24.1-34.6-17.6-.9.4.3-.2-18.9,9.4v63c0,35.21,28,64.51,63.1,64.91a64,64,0,0,0,64.89-63.22V384c-19.5-9.6-18.2-8.9-19-9.3-14.4-6.5-31.1,2.2-34.6,17.6ZM200,208a32,32,0,1,0-32,32A32,32,0,0,0,200,208Zm128-32a32,32,0,1,0,32,32A32,32,0,0,0,328,176Z"]],
    "grin-tongue-squint": [496, 512, [], "f58a", ["M248,8C111,8,0,119,0,256.06c0,106.32,67,196.73,161,232a95.5,95.5,0,0,1-9-40V402.58c-24.7-16.2-43.5-38.1-47.8-63.81a16,16,0,0,1,20.7-17.9c30.2,9.7,75.1,15.2,123.1,15.2s92.9-5.5,123.1-15.2a16,16,0,0,1,20.7,17.9c-4.3,25.71-23.1,47.61-47.8,63.81v45.51a95.5,95.5,0,0,1-9,40c94-35.31,161-125.72,161-232C496,119,385,8,248,8ZM214.2,218.35l-80,48c-11.5,6.8-24-7.6-15.4-18L152.4,208l-33.6-40.32c-8.6-10.3,3.8-24.9,15.4-18l80,48a12.07,12.07,0,0,1,4,16.59,12.2,12.2,0,0,1-4,4Zm147.6,48-80-48a12,12,0,0,1,0-20.6l80-48c11.7-6.9,23.9,7.7,15.4,18L343.6,208l33.6,40.31c8.7,10.4-3.9,24.8-15.4,18Z", "M214.2,197.75l-80-48c-11.6-6.9-24,7.7-15.4,18L152.4,208l-33.6,40.31c-8.6,10.4,3.9,24.8,15.4,18l80-48a12.05,12.05,0,0,0,0-20.6Zm44.3,194.53-1.8,7.8c-2.1,9.21-15.2,9.21-17.3,0l-1.8-7.8c-3.5-15.4-20.2-24.1-34.6-17.6-.9.4.3-.2-18.9,9.4v63c0,35.21,28,64.51,63.1,64.91a64,64,0,0,0,64.89-63.22V384c-19.5-9.6-18.2-8.9-19-9.3-14.39-6.53-31.09,2.17-34.59,17.57ZM377.2,248.36,343.6,208l33.6-40.32c8.5-10.3-3.7-24.9-15.4-18l-80,48a12,12,0,0,0,0,20.6l80,48c11.5,6.8,24.1-7.6,15.4-18Z"]],
    "grin-tongue-wink": [496, 512, [], "f58b", ["M248,8C111,8,0,119,0,256.07c0,106.33,67,196.75,161,232a95.5,95.5,0,0,1-9-40V402.6c-24.7-16.2-43.5-38.1-47.8-63.81a16.06,16.06,0,0,1,20.7-17.9c30.2,9.7,75.1,15.2,123.1,15.2s92.9-5.5,123.1-15.2a16,16,0,0,1,20.7,17.9c-4.3,25.71-23.1,47.61-47.8,63.81v45.52a95.5,95.5,0,0,1-9,40c94-35.31,161-125.73,161-232C496,119,385,8,248,8ZM192,233l-9.5-8.5c-14.8-13.2-46.2-13.2-61,0L112,233c-8.5,7.4-21.6.3-19.8-10.8,4-25.2,34.2-42.11,59.9-42.11S208,197,212,222.26C213.6,233.36,200.4,240.46,192,233Zm152,39a45.25,45.25,0,1,1,.05.05H344Z", "M212,222.26c-4-25.2-34.2-42.11-59.9-42.11S96.2,197,92.2,222.26c-1.8,11.1,11.3,18.2,19.8,10.8l9.5-8.5c14.8-13.2,46.2-13.2,61,0L192,233c8.4,7.4,21.6.3,20-10.8Zm46.5,170-1.8,7.8c-2.1,9.22-15.2,9.22-17.3,0l-1.8-7.8c-3.5-15.4-20.2-24.1-34.6-17.6-.9.4.3-.2-18.9,9.4v63c0,35.21,28,64.51,63.1,64.91a64,64,0,0,0,64.89-63.22V384c-19.5-9.6-18.2-8.9-19-9.3C278.7,368.2,262,376.9,258.5,392.3ZM344,184a23.94,23.94,0,1,0,.12,0Z"]],
    "grin-wink": [496, 512, [], "f58c", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8Zm20.2,214.2c4-25.2,34.2-42.1,59.9-42.1S384,197,388,222.2c1.6,11-11.5,18.2-20,10.8l-9.5-8.5c-14.8-13.2-46.2-13.2-61,0L288,233C279.7,240.4,266.4,233.4,268.2,222.2ZM168,176a32,32,0,1,1-32,32A32,32,0,0,1,168,176ZM391.8,338.7c-9.2,55-83.2,93.3-143.8,93.3s-134.5-38.3-143.8-93.3a16,16,0,0,1,20.7-17.9C155.1,330.5,200,336,248,336s92.9-5.5,123.1-15.2a16,16,0,0,1,20.7,17.9Z", "M168,176a32,32,0,1,0,32,32A32,32,0,0,0,168,176Zm220,46.2c-4-25.2-34.2-42.1-59.9-42.1s-55.9,16.9-59.9,42.1c-1.8,11.2,11.5,18.2,19.8,10.8l9.5-8.5c14.8-13.2,46.2-13.2,61,0L368,233c8.5,7.4,21.6.2,20-10.8Z"]],
    "grip-horizontal": [448, 512, [], "f58d", ["M96 288H32a32 32 0 0 0-32 32v64a32 32 0 0 0 32 32h64a32 32 0 0 0 32-32v-64a32 32 0 0 0-32-32zm160 0h-64a32 32 0 0 0-32 32v64a32 32 0 0 0 32 32h64a32 32 0 0 0 32-32v-64a32 32 0 0 0-32-32zm160 0h-64a32 32 0 0 0-32 32v64a32 32 0 0 0 32 32h64a32 32 0 0 0 32-32v-64a32 32 0 0 0-32-32z", "M416 96h-64a32 32 0 0 0-32 32v64a32 32 0 0 0 32 32h64a32 32 0 0 0 32-32v-64a32 32 0 0 0-32-32zM96 96H32a32 32 0 0 0-32 32v64a32 32 0 0 0 32 32h64a32 32 0 0 0 32-32v-64a32 32 0 0 0-32-32zm160 0h-64a32 32 0 0 0-32 32v64a32 32 0 0 0 32 32h64a32 32 0 0 0 32-32v-64a32 32 0 0 0-32-32z"]],
    "grip-lines": [512, 512, [], "f7a4", ["M512 304v32a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h480a16 16 0 0 1 16 16z", "M512 176v32a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h480a16 16 0 0 1 16 16z"]],
    "grip-lines-vertical": [256, 512, [], "f7a5", ["M224,16V496a16,16,0,0,1-16,16H176a16,16,0,0,1-16-16V16A16,16,0,0,1,176,0h32A16,16,0,0,1,224,16Z", "M96,16V496a16,16,0,0,1-16,16H48a16,16,0,0,1-16-16V16A16,16,0,0,1,48,0H80A16,16,0,0,1,96,16Z"]],
    "grip-vertical": [320, 512, [], "f58e", ["M288 352h-64a32 32 0 0 0-32 32v64a32 32 0 0 0 32 32h64a32 32 0 0 0 32-32v-64a32 32 0 0 0-32-32zm0-320h-64a32 32 0 0 0-32 32v64a32 32 0 0 0 32 32h64a32 32 0 0 0 32-32V64a32 32 0 0 0-32-32zm0 160h-64a32 32 0 0 0-32 32v64a32 32 0 0 0 32 32h64a32 32 0 0 0 32-32v-64a32 32 0 0 0-32-32z", "M96 352H32a32 32 0 0 0-32 32v64a32 32 0 0 0 32 32h64a32 32 0 0 0 32-32v-64a32 32 0 0 0-32-32zm0-160H32a32 32 0 0 0-32 32v64a32 32 0 0 0 32 32h64a32 32 0 0 0 32-32v-64a32 32 0 0 0-32-32zm0-160H32A32 32 0 0 0 0 64v64a32 32 0 0 0 32 32h64a32 32 0 0 0 32-32V64a32 32 0 0 0-32-32z"]],
    "guitar": [512, 512, [], "f7a6", ["M348.88 267.67c7.72 33.39.86 66.87-22 89.75a82.56 82.56 0 0 1-33.47 20.25c-18.54 6-32.67 23.29-34.43 42.15-2.28 23.8-11.48 45.82-28.45 62.7C185 528 103.08 519.94 47.57 464.45s-63.67-137.45-18-183c16.87-17 38.9-26.17 62.59-28.44 18.95-1.77 36.13-15.9 42.15-34.46a82.45 82.45 0 0 1 20.24-33.47c22.9-22.91 56.42-29.81 89.86-22 14.62 3.41 28 10.39 40.15 19.17l-74 74c-.85 0-1.65-.25-2.52-.25a48 48 0 1 0 48 48c0-.84-.21-1.62-.25-2.45l74-74.06c8.74 12.2 15.72 25.51 19.09 40.18z", "M502.63 84.22l-46.32 46.32a35.26 35.26 0 0 1-13.79 8.53l-36.47 12.16-150.33 150.35a47.77 47.77 0 0 0-45.22-45.29L360.79 106 373 69.49a35.26 35.26 0 0 1 8.53-13.79l46.26-46.33a32 32 0 0 1 45.26 0L502.63 39a32 32 0 0 1 0 45.22z"]],
    "guitar-electric": [512, 512, [], "f8be", ["M243.76 223.27a39.45 39.45 0 0 1-3.18-38.42l17.29-37.13a18.82 18.82 0 0 0-30.38-21.23l-38.31 38.27a77.49 77.49 0 0 0-18.24 28.83A77.6 77.6 0 0 1 130.42 238L54 273.33C-3.23 296.19-18.4 370 25.16 413.54l73.39 73.33c43.56 43.51 117.45 28.36 140.35-28.78l35.4-76.38a77.64 77.64 0 0 1 44.41-40.48A77.77 77.77 0 0 0 347.57 323l21.57-21.55a19.87 19.87 0 0 0-20.11-33L325.32 276a39.67 39.67 0 0 1-36.76-7.11zm-62.1 171.09l-11.31 11.31a8 8 0 0 1-11.32 0L106.34 353a8 8 0 0 1 0-11.31l11.32-11.31a8 8 0 0 1 11.31 0l52.69 52.68a8 8 0 0 1 0 11.3zm64-64l-11.31 11.31a8 8 0 0 1-11.32 0L170.35 289a8 8 0 0 1 0-11.31l11.31-11.31a8 8 0 0 1 11.31 0l52.69 52.68a8 8 0 0 1 0 11.31z", "M511.21 39.57a48.12 48.12 0 0 0-37.79-38.26C450.48-3 450.66.79 366.74 54.93A32.15 32.15 0 0 0 352 81.88v33.27L243.81 223.33l44.75 45.6.09.05 173-172.93c.82.06 1.57.35 2.4.35a48 48 0 0 0 47.16-56.83zM129 330.37a8 8 0 0 0-11.31 0l-11.32 11.31a8 8 0 0 0 0 11.31L159 405.67a8 8 0 0 0 11.32 0l11.31-11.31a8 8 0 0 0 0-11.31zm64-64a8 8 0 0 0-11.31 0l-11.31 11.31a8 8 0 0 0 0 11.31L223 341.68a8 8 0 0 0 11.32 0l11.31-11.31a8 8 0 0 0 0-11.31z"]],
    "guitars": [512, 512, [], "f8bf", ["M229.27 300.21A74.51 74.51 0 0 0 237.7 266c0-29.14-17-54.82-43.15-71.17-12.82-8-27.53-12-42.55-13.88v-54.22l16.6-33.21a29 29 0 0 0 3.08-13v-54.1A26.42 26.42 0 0 0 145.25 0h-34.53A26.41 26.41 0 0 0 84.3 26.41v54.08a29.12 29.12 0 0 0 3.07 13L104 126.74V181c-15 1.84-29.74 5.84-42.58 13.83a104 104 0 0 0-18.58 14.67c-15.39 15.39-24.62 35-24.61 56.58a74.36 74.36 0 0 0 8.41 34.2c8 15.65 6 35.59-4.88 48.78C8.11 365.55-.07 385.43 0 407c-.07 58 57.34 105 128 105 39.89 0 75.55-15 99-38.47 1.28-1.27 2.23-2.75 3.43-4.07a111.41 111.41 0 0 1 2.32-80.3L243 361.42a103.64 103.64 0 0 0-8.81-12.42c-10.89-13.16-12.89-33.16-4.92-48.79zm-73 32.08a40 40 0 1 1 0-56.58 40 40 0 0 1 .02 56.58zM424 368h-80a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h80a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zm0-64.12h-80a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h80a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8z", "M505.48 400.82l-26.93-73.45a72.15 72.15 0 0 1 2.57-55.79 72.13 72.13 0 0 0 7-30.94v-28.32a18.47 18.47 0 0 0-34.88-8.47l-10.62 20.55c-5.36 10.37-15.35 17-26.62 19l-8-.1V73.38a34.2 34.2 0 0 0 5.09-3.8 40.77 40.77 0 0 0-51.44-62.75c-16.38 11.15-14 13.35-31.85 96.24a27.3 27.3 0 0 0 7.33 25L360 151v91.66l-8-.11c-11.3-3.11-20.84-11-25-22.37l-13-35.76a17.49 17.49 0 0 0-33.92 6v50.33a72.07 72.07 0 0 0 7 30.93 72.07 72.07 0 0 1 2.53 55.78l-27 73.48C240 453.53 278.54 512 335.76 512h96.41c57.23-.06 95.83-58.59 73.31-111.18zM432 392a8 8 0 0 1-8 8h-80a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h80a8 8 0 0 1 8 8zm0-64.12a8 8 0 0 1-8 8h-80a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h80a8 8 0 0 1 8 8z"]],
    "h-square": [448, 512, [], "f0fd", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-48 336a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-80H160v80a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V144a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v80h128v-80a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16z", "M352 368a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-80H160v80a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V144a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v80h128v-80a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16z"]],
    "h1": [576, 512, [], "f313", ["M304 96h-98.94A13.06 13.06 0 0 0 192 109.06v37.88A13.06 13.06 0 0 0 205.06 160H224v64H96v-64h18.94A13.06 13.06 0 0 0 128 146.94V112a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v34.94A13.06 13.06 0 0 0 13.06 160H32v192H13.06A13.06 13.06 0 0 0 0 365.06V400a16 16 0 0 0 16 16h98.94A13.06 13.06 0 0 0 128 402.94v-37.88A13.06 13.06 0 0 0 114.94 352H96v-64h128v64h-18.94A13.06 13.06 0 0 0 192 365.06V400a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16v-34.94A13.06 13.06 0 0 0 306.94 352H288V160h18.94A13.06 13.06 0 0 0 320 146.94V112a16 16 0 0 0-16-16z", "M560 352h-48V120a24 24 0 0 0-24-24h-40a24 24 0 0 0-21.44 13.26l-24 48A24 24 0 0 0 424 192h24v160h-48a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h160a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "h2": [576, 512, [], "f314", ["M304 96h-98.94A13.06 13.06 0 0 0 192 109.06v37.88A13.06 13.06 0 0 0 205.06 160H224v64H96v-64h18.94A13.06 13.06 0 0 0 128 146.94V112a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v34.94A13.06 13.06 0 0 0 13.06 160H32v192H13.06A13.06 13.06 0 0 0 0 365.06V400a16 16 0 0 0 16 16h98.94A13.06 13.06 0 0 0 128 402.94v-37.88A13.06 13.06 0 0 0 114.94 352H96v-64h128v64h-18.94A13.06 13.06 0 0 0 192 365.06V400a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16v-34.94A13.06 13.06 0 0 0 306.94 352H288V160h18.94A13.06 13.06 0 0 0 320 146.94V112a16 16 0 0 0-16-16z", "M560 352H440.79c17-42.95 135.21-66.57 135.21-159.62C576 132.55 528.33 96 469.14 96c-43.83 0-81.41 21.38-103.42 57a15.66 15.66 0 0 0 4.75 21.4l28.26 18.6a16.15 16.15 0 0 0 21.86-3.83c10.77-14.86 24.94-26 43.85-26s38.22 10.46 38.22 33.84c0 52.18-142.1 73.21-142.1 184.56a155.06 155.06 0 0 0 1.71 20.66A15.94 15.94 0 0 0 378.14 416H560a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "h3": [576, 512, [], "f315", ["M304 96h-98.94A13.06 13.06 0 0 0 192 109.06v37.88A13.06 13.06 0 0 0 205.06 160H224v64H96v-64h18.94A13.06 13.06 0 0 0 128 146.94V112a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v34.94A13.06 13.06 0 0 0 13.06 160H32v192H13.06A13.06 13.06 0 0 0 0 365.06V400a16 16 0 0 0 16 16h98.94A13.06 13.06 0 0 0 128 402.94v-37.88A13.06 13.06 0 0 0 114.94 352H96v-64h128v64h-18.94A13.06 13.06 0 0 0 192 365.06V400a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16v-34.94A13.06 13.06 0 0 0 306.94 352H288V160h18.94A13.06 13.06 0 0 0 320 146.94V112a16 16 0 0 0-16-16z", "M499 217.69l64.4-72.31a15.48 15.48 0 0 0 4-10.31v-23.32A16 16 0 0 0 551.12 96H384a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h85.18c-2.29 2.45-4.65 5-7.19 7.9l-53.1 61.1a18 18 0 0 0-3.83 10.17 18.36 18.36 0 0 0 1.38 6.34l8.41 18.59c2.35 5.21 9 9.42 14.84 9.42h15.95c28.94 0 57.79 10.32 57.79 38.48 0 21.32-19.93 36.79-47.39 36.79-22.08 0-41.18-9.17-57.7-22.83a16.46 16.46 0 0 0-23.87 3.34l-19.75 28.8a15.46 15.46 0 0 0 2.53 20.35C384.9 403.21 422 416 459.51 416c71 0 116.49-48.86 116.49-106.06 0-47.3-32.73-80.89-77-92.25z"]],
    "h4": [576, 512, [], "f86a", ["M304 96h-98.94A13.06 13.06 0 0 0 192 109.06v37.88A13.06 13.06 0 0 0 205.06 160H224v64H96v-64h18.94A13.06 13.06 0 0 0 128 146.94V112a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v34.94A13.06 13.06 0 0 0 13.06 160H32v192H13.06A13.06 13.06 0 0 0 0 365.06V400a16 16 0 0 0 16 16h98.94A13.06 13.06 0 0 0 128 402.94v-37.88A13.06 13.06 0 0 0 114.94 352H96v-64h128v64h-18.94A13.06 13.06 0 0 0 192 365.06V400a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16v-34.94A13.06 13.06 0 0 0 306.94 352H288V160h18.94A13.06 13.06 0 0 0 320 146.94V112a16 16 0 0 0-16-16z", "M560 224h-16V112a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v112h-64V112a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v144a32 32 0 0 0 32 32h96v112a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V288h16a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "hamburger": [512, 512, [], "f805", ["M58.64 224h394.72c34.57 0 54.62-43.9 34.82-75.88C448 83.2 359.55 32.1 256 32c-103.54.1-192 51.2-232.18 116.11C4 180.09 24.07 224 58.64 224zM384 112a16 16 0 1 1-16 16 16 16 0 0 1 16-16zM256 80a16 16 0 1 1-16 16 16 16 0 0 1 16-16zm-128 32a16 16 0 1 1-16 16 16 16 0 0 1 16-16zm352 272H32a16 16 0 0 0-16 16v16a64 64 0 0 0 64 64h352a64 64 0 0 0 64-64v-16a16 16 0 0 0-16-16z", "M512 304a48 48 0 0 1-48 48H48a48 48 0 0 1 0-96h416a48 48 0 0 1 48 48z"]],
    "hammer": [576, 512, [], "f6e3", ["M19.64 405l255.1-238.17a97 97 0 0 0 9.85 12l49.14 49.14a97.23 97.23 0 0 0 11.44 9.41L107 492.36A61.84 61.84 0 1 1 19.64 405z", "M435.56 261.81l11.31-11.31L418 221.6a63.73 63.73 0 0 1-61.61-16.35l-49.14-49.14a64 64 0 0 1-18.75-45.25V92.11L198 46.86a160 160 0 0 1 226.28 0l45.25 45.25a63.73 63.73 0 0 1 16.35 61.61l28.9 28.9 11.31-11.31a16 16 0 0 1 22.63 0l22.63 22.63a16 16 0 0 1 0 22.62l-90.51 90.51a16 16 0 0 1-22.63 0l-22.63-22.63a16 16 0 0 1-.02-22.63z"]],
    "hammer-war": [384, 512, [], "f6e4", ["M384 64v192a32 32 0 0 1-37.26 31.56L192 261.77 37.26 287.55A32 32 0 0 1 0 256V64a32 32 0 0 1 37.26-31.56L192 58.23l154.74-25.78A32 32 0 0 1 384 64z", "M160 52.9V16a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v36.9l-32 5.33zm0 246.64V496a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V299.54l-32-5.33z"]],
    "hamsa": [512, 512, [], "f665", ["M288 352a32 32 0 1 1-32-32 32 32 0 0 1 32 32z", "M509.34 307.25A32 32 0 0 0 480 288h-64V80a40 40 0 0 0-80 0v134a10 10 0 0 1-10 10h-20a10 10 0 0 1-10-10V40a40 40 0 0 0-80 0v174a10 10 0 0 1-10 10h-20a10 10 0 0 1-10-10V80a40 40 0 0 0-80 0v208H32a32 32 0 0 0-23.4 53.83l102.69 110C147 490.08 199.69 512 256 512s109-21.92 144.72-60.14l102.68-110a32 32 0 0 0 5.94-34.61zM256 416c-53 0-96-64-96-64s43-64 96-64 96 64 96 64-43 64-96 64z"]],
    "hand-heart": [448, 512, [], "f4bc", ["M416 112a32.09 32.09 0 0 0-32 32v72a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8V64a32 32 0 0 0-64 0v152a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8V32a32 32 0 0 0-64 0v184a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8V64a32 32 0 0 0-64 0v241l-23.6-32.5a40 40 0 1 0-64.7 47.1l125.6 172.7a48.08 48.08 0 0 0 38.8 19.8h197.6a47.93 47.93 0 0 0 46.7-37l26.5-112.7a201.31 201.31 0 0 0 5.1-42.3V144a32.09 32.09 0 0 0-32-32zm-62.9 261.2l-72.6 71.4a12.2 12.2 0 0 1-17 0l-72.6-71.4a49.59 49.59 0 0 1 3.7-74.2c20.5-16.7 51.1-13.7 70 4.8l7.4 7.3 7.4-7.3c18.8-18.5 49.4-21.5 70-4.8a49.66 49.66 0 0 1 3.67 74.2z", "M194.57 299c20.5-16.7 51.1-13.7 70 4.8l7.4 7.3 7.4-7.3c18.8-18.5 49.4-21.5 70-4.8a49.66 49.66 0 0 1 3.7 74.2l-72.6 71.4a12.2 12.2 0 0 1-17 0l-72.6-71.4a49.59 49.59 0 0 1 3.7-74.2z"]],
    "hand-holding": [576, 512, [], "f4bd", ["M564 377L412.8 498a64.08 64.08 0 0 1-40 14H16a16 16 0 0 1-16-16v-96a16 16 0 0 1 16-16h55.4l46.5-37.7A117.69 117.69 0 0 1 192 320h160a32 32 0 0 1 31.6 37.4c-2.6 15.7-17.4 26.6-33.3 26.6H272a16 16 0 0 0 0 32h118.3a63.67 63.67 0 0 0 40-14l92.4-73.9c12.4-10 30.8-10.7 42.6 0A32 32 0 0 1 564 377z", ""]],
    "hand-holding-box": [576, 512, [], "f47b", ["M352 128V0H224v128l64-32zm213.3 200.1c-11.8-10.7-30.2-10-42.6 0L430.3 402a63.67 63.67 0 0 1-40 14H272a16 16 0 0 1 0-32h78.3c15.9 0 30.7-10.9 33.3-26.6A32 32 0 0 0 352 320H192a117.69 117.69 0 0 0-74.1 26.3L71.4 384H16a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h356.8a64.08 64.08 0 0 0 40-14L564 377a32 32 0 0 0 1.3-48.9z", "M480 16v224a16 16 0 0 1-16 16H112a16 16 0 0 1-16-16V16a16 16 0 0 1 16-16h112v128l64-32 64 32V0h112a16 16 0 0 1 16 16z"]],
    "hand-holding-heart": [576, 512, [], "f4be", ["M564 377L412.8 498a64.08 64.08 0 0 1-40 14H16a16 16 0 0 1-16-16v-96a16 16 0 0 1 16-16h55.4l46.5-37.7A117.69 117.69 0 0 1 192 320h160a32 32 0 0 1 31.6 37.4c-2.6 15.7-17.4 26.6-33.3 26.6H272a16 16 0 0 0 0 32h118.3a63.67 63.67 0 0 0 40-14l92.4-73.9c12.4-10 30.8-10.7 42.6 0A32 32 0 0 1 564 377z", "M404.1 17.52c35.4 30.6 37.2 85.6 5.6 118.8l-108.9 114.2a17.42 17.42 0 0 1-25.5 0l-108.9-114.2c-31.6-33.2-29.7-88.2 5.6-118.8 30.8-26.7 76.7-21.9 104.9 7.8l11.1 11.6 11.2-11.7c28.2-29.6 74.1-34.4 104.9-7.7z"]],
    "hand-holding-magic": [576, 512, [], "f6e5", ["M564 377L412.75 498a64 64 0 0 1-40 14H16a16 16 0 0 1-16-16v-96a16 16 0 0 1 16-16h55.44l46.5-37.73A117.51 117.51 0 0 1 192 320h160a32 32 0 0 1 31.56 37.37C381 373.11 366.22 384 350.28 384H272a16 16 0 0 0 0 32h118.33a64 64 0 0 0 40-14l92.34-73.87c12.45-10 30.8-10.69 42.63 0A32 32 0 0 1 564 377z", "M384 128V96a32 32 0 0 0-32-32H224a32 32 0 0 0-32 32v32c0 14.5 14.28 32 32 32 64 0 96-32 96-32a96.1 96.1 0 0 1-96 96c-51.14 0-96-44.86-96-96V96a96.1 96.1 0 0 1 96-96h128a96.1 96.1 0 0 1 96 96v33.56c-.6 76.16-65.13 137.07-142.18 141.43L288 272l53.91-53.2C366.49 194.54 384 162.3 384 128z"]],
    "hand-holding-seedling": [576, 512, [], "f4bf", ["M564 377L412.8 498a64.08 64.08 0 0 1-40 14H16a16 16 0 0 1-16-16v-96a16 16 0 0 1 16-16h55.4l46.5-37.7A117.69 117.69 0 0 1 192 320h160a32 32 0 0 1 31.6 37.4c-2.6 15.7-17.4 26.6-33.3 26.6H272a16 16 0 0 0 0 32h118.3a63.67 63.67 0 0 0 40-14l92.4-73.9c12.4-10 30.8-10.7 42.6 0A32 32 0 0 1 564 377z", "M160 0H96a160 160 0 0 0 160 160v112a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V160A160 160 0 0 0 160 0zm256 0c-40.7 0-77.5 15.7-105.8 40.8a190.94 190.94 0 0 1 41.6 116C424.9 142 480 77.5 480 0z"]],
    "hand-holding-usd": [576, 512, [], "f4c0", ["M564 377L412.78 498a64 64 0 0 1-40 14H16a16 16 0 0 1-16-16v-96a16 16 0 0 1 16-16h55.4l46.5-37.71A117.65 117.65 0 0 1 192 320h160a32 32 0 0 1 32 31.94 31.2 31.2 0 0 1-.46 5.46C381 373.1 366.19 384 350.29 384H272a16 16 0 0 0 0 32h118.28a63.64 63.64 0 0 0 40-14l92.4-73.9c12.4-10 30.8-10.7 42.6 0A32 32 0 0 1 564 377z", "M329.28 222.4V240c0 8.8-7.77 16-17.26 16h-17.25c-9.48 0-17.25-7.2-17.25-16v-17.7a82.78 82.78 0 0 1-34.28-11.5 11.46 11.46 0 0 1-3.85-15.74 11.64 11.64 0 0 1 2.23-2.66l18.87-17.5c4-3.7 10-4.2 15.2-2a29.62 29.62 0 0 0 11.11 2.2h35.36c5 0 9.06-3.8 9.06-8.4a8.58 8.58 0 0 0-6.58-8.1l-53.91-14.3c-23.93-6.4-43.13-24.7-46.25-47.7-4.31-32 20.48-59.4 53.15-63V16c0-8.8 7.76-16 17.25-16h17.25c9.49 0 17.25 7.2 17.25 16v17.7a82.92 82.92 0 0 1 34.29 11.5 11.48 11.48 0 0 1 1.62 18.4l-18.87 17.5c-4 3.7-10 4.2-15.2 2a29.62 29.62 0 0 0-11.11-2.2h-35.36c-5 0-9.06 3.8-9.06 8.4a8.58 8.58 0 0 0 6.58 8.1l53.91 14.3c23.93 6.4 43.11 24.7 46.24 47.7 4.31 32-20.43 59.4-53.14 63z"]],
    "hand-holding-water": [576, 512, [], "f4c1", ["M564 377L412.8 498a64.08 64.08 0 0 1-40 14H16a16.05 16.05 0 0 1-16-16v-96a16 16 0 0 1 16-16h55.4l46.5-37.71A117.69 117.69 0 0 1 192 320h160a32 32 0 0 1 31.6 37.4c-2.6 15.7-17.4 26.6-33.3 26.6H272a16 16 0 0 0 0 32h118.3a63.67 63.67 0 0 0 40-14l92.4-73.9c12.4-10 30.8-10.7 42.6 0A32 32 0 0 1 564 377z", "M300.8 6.38C326.9 41.27 384 122 384 162c0 51.9-43 94-96 94s-96-42.1-96-94c0-40 57.1-120.71 83.2-155.6a16 16 0 0 1 25.6-.02z"]],
    "hand-lizard": [576, 512, [], "f258", ["M561.17 312.52A96 96 0 0 1 576 363.78V480H384v-61.46a24 24 0 0 0-11.15-20.27L261.1 327.46a48 48 0 0 0-25.69-7.46H88a24 24 0 0 1-24-24v-8a64 64 0 0 1 64-64h123.65a32 32 0 0 0 29.54-19.69l21.41-51.39A18 18 0 0 0 286 128H56A56 56 0 0 1 0 72V56a24 24 0 0 1 24-24h333.54a48 48 0 0 1 40.59 22.37z", ""]],
    "hand-middle-finger": [512, 512, [], "f806", ["", "M479.93,317.16,480,400A112,112,0,0,1,368.05,512h-215a112,112,0,0,1-79.19-32.81L42.93,448.28A37.31,37.31,0,0,1,32,421.89V348.44A37.34,37.34,0,0,1,52.64,315L80,300v76a8,8,0,0,0,16,0V229c0-15.26,12.87-28.38,30.87-31.38l30.68-5.12c17.82-3,34.45,8.39,34.45,23.54v32a8,8,0,0,0,16,0V46.54A48,48,0,0,1,257.44,0h0C283.75.86,304,23.78,304,50V248a8,8,0,0,0,16,0V216c0-15.14,16.63-26.49,34.45-23.53l38.4,6.4C406.31,201.16,416,211,416,222.45V272l35.65,9A37.34,37.34,0,0,1,479.93,317.16Z"]],
    "hand-paper": [448, 512, [], "f256", ["M448 168v150.36a192 192 0 0 1-5.1 44L416.39 475a48 48 0 0 1-46.73 37H172.07a48 48 0 0 1-38.82-19.77L7.65 319.53a40 40 0 0 1 64.7-47.06L104 316V80a40 40 0 0 1 39.22-40C165.64 39.58 184 58.36 184 80.79V256h8V40a40 40 0 0 1 39.22-40C253.64-.42 272 18.36 272 40.79V256h8V79a40 40 0 0 1 39.22-40C341.64 38.58 360 57.36 360 79.79V256h8v-87.21c0-22.43 18.36-41.21 40.78-40.78A40 40 0 0 1 448 168z", ""]],
    "hand-peace": [448, 512, [], "f25b", ["M448 256v80a40.36 40.36 0 0 1-1.06 9.16l-32 136A40 40 0 0 1 376 512H136a40 40 0 0 1-34.73-20.15l-64-112A40 40 0 0 1 47 328.77l31.1-24.88L3.34 113.55a48 48 0 1 1 89.35-35.1L162.43 256H176V48a48 48 0 0 1 96 0v208h8v-32a40 40 0 0 1 80 0v32h8a40 40 0 0 1 80 0z", ""]],
    "hand-point-down": [384, 512, [], "f0a7", ["M383.81 256c0 2.72.19 13.25.19 16 0 50.65-22.12 81.57-71.26 72.6-9.3 18.6-39.49 30.74-62.32 16.45-21.17 24.64-53.89 22.64-70.94 6.3v99.85c0 24.15-20.2 44.8-43.83 44.8-23.28 0-43.82-21.35-43.82-44.8V318a135.83 135.83 0 0 1-24.92 14.15C35.1 345.75 0 322.22 0 288c0-18.62 10.9-32.2 29.09-40 28.29-12.12 64.33-78.65 77.33-107.53A48 48 0 0 1 150.26 112h171.53a24 24 0 0 1 23.7 20.27C352.74 179.11 384 194 383.81 256z", "M328 0H136a24 24 0 0 0-24 24v48a24 24 0 0 0 24 24h192a24 24 0 0 0 24-24V24a24 24 0 0 0-24-24zm-24 68a20 20 0 1 1 20-20 20 20 0 0 1-20 20z"]],
    "hand-point-left": [512, 512, [], "f0a5", ["M400 214.26v171.53a24 24 0 0 1-20.27 23.7C332.89 416.74 318 448 256 447.81c-2.72 0-13.25.19-16 .19-50.65 0-81.57-22.12-72.6-71.26-18.6-9.3-30.74-39.49-16.45-62.32-24.64-21.17-22.64-53.89-6.3-70.94H44.8c-24.15 0-44.8-20.2-44.8-43.83 0-23.28 21.35-43.82 44.8-43.82H194a135.83 135.83 0 0 1-14.15-24.92C166.25 99.1 189.78 64 224 64c18.62 0 32.2 10.9 40 29.09 12.12 28.29 78.65 64.33 107.53 77.33A48 48 0 0 1 400 214.26z", "M488 176h-48a24 24 0 0 0-24 24v192a24 24 0 0 0 24 24h48a24 24 0 0 0 24-24V200a24 24 0 0 0-24-24zm-24 212a20 20 0 1 1 20-20 20 20 0 0 1-20 20z"]],
    "hand-point-right": [512, 512, [], "f0a4", ["M512 199.65c0 23.63-20.65 43.83-44.8 43.83h-99.85c16.34 17 18.34 49.76-6.3 70.94 14.29 22.83 2.15 53-16.45 62.32 9 49.14-22 71.26-72.6 71.26-2.75 0-13.28-.2-16-.19-62 .16-76.89-31.07-123.73-38.32a24 24 0 0 1-20.27-23.7V214.26a48 48 0 0 1 28.47-43.84c28.88-13 95.41-49 107.53-77.33C255.8 74.9 269.38 64 288 64c34.22 0 57.75 35.1 44.12 66.91A135.83 135.83 0 0 1 318 155.83h149.2c23.45 0 44.8 20.54 44.8 43.82z", "M72 176H24a24 24 0 0 0-24 24v192a24 24 0 0 0 24 24h48a24 24 0 0 0 24-24V200a24 24 0 0 0-24-24zM48 388a20 20 0 1 1 20-20 20 20 0 0 1-20 20z"]],
    "hand-point-up": [384, 512, [], "f0a6", ["M0 224c0-34.22 35.1-57.75 66.91-44.12A135.83 135.83 0 0 1 91.83 194V44.8c0-23.45 20.54-44.8 43.82-44.8 23.63 0 43.83 20.65 43.83 44.8v99.85c17.05-16.34 49.76-18.35 70.94 6.3 22.83-14.29 53-2.15 62.32 16.45 49.14-9 71.26 21.95 71.26 72.6 0 2.75-.2 13.28-.2 16 .17 62-31.06 76.89-38.31 123.73a24 24 0 0 1-23.7 20.27H150.26a48 48 0 0 1-43.84-28.47c-13-28.88-49-95.41-77.33-107.53C10.9 256.2 0 242.62 0 224z", "M328 416H136a24 24 0 0 0-24 24v48a24 24 0 0 0 24 24h192a24 24 0 0 0 24-24v-48a24 24 0 0 0-24-24zm-24 68a20 20 0 1 1 20-20 20 20 0 0 1-20 20z"]],
    "hand-pointer": [448, 512, [], "f25a", ["M408 200a40 40 0 0 0-40 40h-8v-24a40 40 0 0 0-80 0v24h-8v-40a40 40 0 0 0-80 0v40h-8V40a40 40 0 0 0-80 0v276l-31.65-43.53a40 40 0 0 0-64.7 47.06l128 176A40 40 0 0 0 168 512h208a40 40 0 0 0 38.94-30.84l32-136A40.36 40.36 0 0 0 448 336v-96a40 40 0 0 0-40-40zM224 400a16 16 0 0 1-32 0v-64a16 16 0 0 1 32 0zm64 0a16 16 0 0 1-32 0v-64a16 16 0 0 1 32 0zm64 0a16 16 0 0 1-32 0v-64a16 16 0 0 1 32 0z", "M272 320a16 16 0 0 0-16 16v64a16 16 0 0 0 32 0v-64a16 16 0 0 0-16-16zm-64 0a16 16 0 0 0-16 16v64a16 16 0 0 0 32 0v-64a16 16 0 0 0-16-16zm128 0a16 16 0 0 0-16 16v64a16 16 0 0 0 32 0v-64a16 16 0 0 0-16-16z"]],
    "hand-receiving": [640, 512, [], "f47c", ["M204.8 230.4a32 32 0 1 0-51.2 38.4l38.1 50.8a16 16 0 0 1-1.5 20.9l-12.8 12.8a15.9 15.9 0 0 1-23.6-1.1L64 244.4V96a32 32 0 0 0-64 0v218.4a48.05 48.05 0 0 0 10.5 30l104.1 134.3a59.69 59.69 0 0 1 10.4 21.7 15.67 15.67 0 0 0 15.3 11.6H272a16 16 0 0 0 16-16V384a128.2 128.2 0 0 0-25.6-76.8zM608 64a32 32 0 0 0-32 32v148.4l-89.8 107.8a16.06 16.06 0 0 1-23.6 1.1l-12.8-12.8a16 16 0 0 1-1.5-20.9l38.1-50.8a32 32 0 1 0-51.2-38.4l-57.6 76.8A128.2 128.2 0 0 0 352 384v112a16 16 0 0 0 16 16h131.7a15.76 15.76 0 0 0 15.3-11.6 59.69 59.69 0 0 1 10.4-21.7l104.1-134.3a48.05 48.05 0 0 0 10.5-30V96a32 32 0 0 0-32-32z", "M201.2 150.4a31.51 31.51 0 0 1 0-44.7l96.4-96.4a31.63 31.63 0 0 1 44.8 0l96.3 96.3a31.63 31.63 0 0 1 0 44.8l-96.4 96.4a31.69 31.69 0 0 1-44.7 0z"]],
    "hand-rock": [512, 512, [], "f255", ["M0 242.41V176a48 48 0 0 1 48.8-48c26.3.5 47.2 22.5 47.2 48.8v48.1l8 7.1V96a48 48 0 0 1 48.8-48c26.3.5 47.2 22.5 47.2 48.8V128h8V80a48 48 0 0 1 48.8-48c26.3.5 47.2 22.5 47.2 48.8V128h8V96a48 48 0 0 1 48.8-48c26.3.5 47.2 22.5 47.2 48.8V128h8a48 48 0 0 1 48.8-48c26.3.4 47.2 22.5 47.2 48.8v133.5a95.58 95.58 0 0 1-7.5 37.3l-49 116.3a97.42 97.42 0 0 0-7.5 37.3v2.9a23.94 23.94 0 0 1-24 24H184a23.94 23.94 0 0 1-24-24v-6.7a48.21 48.21 0 0 0-16.1-35.9L32.2 314.21A96.23 96.23 0 0 1 0 242.41z", ""]],
    "hand-scissors": [512, 512, [], "f257", ["M512 168v240a40 40 0 0 1-30.84 38.94l-136 32A40.36 40.36 0 0 1 336 480h-80a40 40 0 0 1 0-80v-8h-32a40 40 0 0 1 0-80h32v-8H48a48 48 0 0 1 0-96h208v-13.57L78.45 124.69a48 48 0 1 1 35.1-89.35l190.34 74.76L328.77 79a40 40 0 0 1 51.08-9.74l112 64A40 40 0 0 1 512 168z", ""]],
    "hand-spock": [512, 512, [], "f259", ["M511 145.31l-36.3 152.5a97 97 0 0 0-2.6 22.2v42a97 97 0 0 1-4 27.3l-26.2 88.3a47.91 47.91 0 0 1-46 34.4H179.17a47.91 47.91 0 0 1-32.9-13l-133.7-125.9a40 40 0 1 1 54.8-58.2l60.6 57v-79.4L89 120.91a40 40 0 0 1 78-17.8l34.8 152.8h9.8l-47.6-207a40 40 0 1 1 78-17.8L293.67 256h15.1l48.4-193.7a40 40 0 1 1 77.6 19.4L391.17 256h11.1l30.8-129.3a40 40 0 0 1 77.9 18.6z", ""]],
    "hands": [640, 512, [], "f4c2", ["M204.8 230.4a32 32 0 1 0-51.2 38.4l38.1 50.8a16 16 0 0 1-1.5 20.9l-12.8 12.8a15.9 15.9 0 0 1-23.6-1.1L64 244.4V96a32 32 0 0 0-64 0v218.4a48.05 48.05 0 0 0 10.5 30l104.1 134.3a59.69 59.69 0 0 1 10.4 21.7 15.67 15.67 0 0 0 15.3 11.6H272a16 16 0 0 0 16-16V384a128.2 128.2 0 0 0-25.6-76.8zM608 64a32 32 0 0 0-32 32v148.4l-89.8 107.8a16.06 16.06 0 0 1-23.6 1.1l-12.8-12.8a16 16 0 0 1-1.5-20.9l38.1-50.8a32 32 0 1 0-51.2-38.4l-57.6 76.8A128.2 128.2 0 0 0 352 384v112a16 16 0 0 0 16 16h131.7a15.76 15.76 0 0 0 15.3-11.6 59.69 59.69 0 0 1 10.4-21.7l104.1-134.3a48.05 48.05 0 0 0 10.5-30V96a32 32 0 0 0-32-32z", ""]],
    "hands-heart": [640, 512, [], "f4c3", ["M608 64a32 32 0 0 0-32 32v148.4l-89.8 107.8a16.06 16.06 0 0 1-23.6 1.1l-12.8-12.8a16 16 0 0 1-1.5-20.9l38.1-50.8a32 32 0 1 0-51.2-38.4l-57.6 76.8A128.2 128.2 0 0 0 352 384v112a16 16 0 0 0 16 16h131.7a15.76 15.76 0 0 0 15.3-11.6 59.69 59.69 0 0 1 10.4-21.7l104.1-134.3a48.05 48.05 0 0 0 10.5-30V96a32 32 0 0 0-32-32zM204.8 230.42a32 32 0 1 0-51.2 38.4l38.1 50.8a16 16 0 0 1-1.5 20.9l-12.8 12.8a15.9 15.9 0 0 1-23.6-1.1L64 244.42V96a32 32 0 1 0-64 0v218.4a48.05 48.05 0 0 0 10.5 30l104.1 134.3a59.69 59.69 0 0 1 10.4 21.7 15.67 15.67 0 0 0 15.3 11.6H272a16 16 0 0 0 16-16V384a128.2 128.2 0 0 0-25.6-76.8z", "M198.4 136.32c-31.6-33.2-29.7-88.2 5.6-118.8 30.8-26.7 76.7-21.9 104.9 7.8l11.1 11.6 11.1-11.7c28.2-29.6 74.1-34.4 104.9-7.7 35.4 30.6 37.2 85.6 5.7 118.8l-108.9 114.2a17.42 17.42 0 0 1-25.5 0z"]],
    "hands-helping": [640, 512, [], "f4c4", ["M224 248V121.68a31.78 31.78 0 0 1 15-27.1l33.5-20.9A64.48 64.48 0 0 1 306.4 64h102.21L512 4.28A32 32 0 0 1 555.72 16l80 138.6a32 32 0 0 1-11.7 43.7l-80 46.2V216a56 56 0 0 0-56-56H304v88a40 40 0 1 1-80 0z", "M4.32 357.38A31.92 31.92 0 0 1 16 313.68l80-46.2v-47.3a63.86 63.86 0 0 1 31.1-54.8l64.89-39V248a72 72 0 1 0 144 0v-56H488a23.94 23.94 0 0 1 24 24v48a23.94 23.94 0 0 1-24 24h-8v64a32 32 0 0 1-32 32h-16a64.06 64.06 0 0 1-64 64H231.41L128 507.68A32 32 0 0 1 84.32 496z"]],
    "hands-usd": [640, 512, [], "f4c5", ["M608 64a32 32 0 0 0-32 32v148.4l-89.8 107.8a16.06 16.06 0 0 1-23.6 1.1l-12.8-12.8a16 16 0 0 1-1.5-20.9l38.1-50.8a32 32 0 1 0-51.2-38.4l-57.6 76.8A128.2 128.2 0 0 0 352 384v112a16 16 0 0 0 16 16h131.7a15.76 15.76 0 0 0 15.3-11.6 59.69 59.69 0 0 1 10.4-21.7l104.1-134.3a48.05 48.05 0 0 0 10.5-30V96a32 32 0 0 0-32-32zM204.8 230.4a32 32 0 1 0-51.2 38.4l38.1 50.8a16 16 0 0 1-1.5 20.9l-12.8 12.8a15.9 15.9 0 0 1-23.6-1.1L64 244.4V96a32 32 0 0 0-64 0v218.4a48.05 48.05 0 0 0 10.5 30l104.1 134.3a59.69 59.69 0 0 1 10.4 21.7 15.67 15.67 0 0 0 15.3 11.6H272a16 16 0 0 0 16-16V384a128.2 128.2 0 0 0-25.6-76.8z", "M246.7 96.6c-4.1-32 19-59.4 49.3-63V16a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v17.7a73.53 73.53 0 0 1 31.8 11.5c6.2 4.1 6.8 13.1 1.5 18.4l-17.5 17.5c-3.7 3.7-9.3 4.2-14.1 2a25.73 25.73 0 0 0-10.3-2.2h-32.8a8.41 8.41 0 0 0-2.3 16.5l50.1 14.3c22.2 6.4 40 24.7 42.9 47.7a56.14 56.14 0 0 1-49.3 63V240a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-17.7a73.53 73.53 0 0 1-31.8-11.5c-6.2-4.1-6.8-13.1-1.5-18.4l17.5-17.5c3.7-3.7 9.3-4.2 14.1-2a25.73 25.73 0 0 0 10.3 2.2h32.8a8.41 8.41 0 0 0 2.3-16.5l-50.1-14.3c-22.2-6.4-40-24.7-42.9-47.7z"]],
    "handshake": [640, 512, [], "f2b5", ["M0 384h64a32 32 0 0 0 32-32V128.2H0zm48-63.9a16 16 0 1 1-16 16 16 16 0 0 1 16-16zM457.3 73.4a31.77 31.77 0 0 0-22.6-9.4h-85.9a32 32 0 0 0-21.6 8.4l-98.3 90c-.1.1-.2.3-.3.4a39.78 39.78 0 0 0-2.1 56c12.7 13.9 39.4 17.6 56.1 2.7.1-.1.3-.1.4-.2l79.9-73.2a16 16 0 0 1 21.6 23.6l-26.1 23.9L504 313.8a72 72 0 0 1 7.9 7.7V128z", "M544 128.2v223.9a32 32 0 0 0 32 32h64V128.2zm48 223.9a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm-108.1-13.4L334.6 217.5l-30 27.5a72 72 0 0 1-97.3-106.1L289.1 64h-83.8a31.94 31.94 0 0 0-22.6 9.4L128 128v223.9h18.3l90.5 81.9a64 64 0 0 0 90-9.3l.2-.2 17.9 15.5a37.16 37.16 0 0 0 52.3-5.4l31.4-38.6 5.4 4.4a32 32 0 0 0 45-4.7l9.5-11.7a32.06 32.06 0 0 0-4.6-45.1z"]],
    "handshake-alt": [640, 512, [], "f4c6", ["M640 143.9v191.8a16 16 0 0 1-16 16h-97.6a63.36 63.36 0 0 0-22.2-37.9L358.6 195.6l26.1-23.9a16 16 0 0 0-21.6-23.6l-27 24.7-53 48.5c-.1.1-.3.1-.4.2-21.1 18.9-46.5 7.8-56.1-2.7a39.69 39.69 0 0 1 2.1-56c.1-.1.2-.3.3-.4l98.3-90a32 32 0 0 1 21.6-8.4h85.9a31.94 31.94 0 0 1 22.6 9.4L512 128h112a16 16 0 0 1 16 15.9z", "M0 335.9V144a16 16 0 0 1 16-16h112l54.7-54.6a31.94 31.94 0 0 1 22.6-9.4h83.8l-81.8 74.9a72 72 0 0 0-4.4 101.7c14.9 16.3 61.1 41.5 101.7 4.4l30-27.5 149.3 121.2a32.06 32.06 0 0 1 4.6 45.1l-9.5 11.7a32 32 0 0 1-45 4.7l-5.4-4.4-31.4 38.6a37.16 37.16 0 0 1-52.3 5.4L327 424.3l-.2.2a64 64 0 0 1-90 9.3l-90.5-81.9H16a16 16 0 0 1-16-16z"]],
    "hanukiah": [640, 512, [], "f6e6", ["M152 101.33c0 14.72 10.75 26.67 24 26.67s24-11.94 24-26.67S176 48 176 48s-24 38.61-24 53.33zm64 0c0 14.72 10.75 26.67 24 26.67s24-11.94 24-26.67S240 48 240 48s-24 38.61-24 53.33zm-208 0C8 116.05 18.75 128 32 128s24-11.94 24-26.67S32 48 32 48 8 86.61 8 101.33zm80 0C88 116.05 98.75 128 112 128s24-11.94 24-26.67S112 48 112 48s-24 38.61-24 53.33zm208-48C296 68.05 306.75 80 320 80s24-11.94 24-26.67S320 0 320 0s-24 38.61-24 53.33zm208 48c0 14.72 10.75 26.67 24 26.67s24-11.94 24-26.67S528 48 528 48s-24 38.61-24 53.33zM608 48s-24 38.61-24 53.33S594.75 128 608 128s24-11.94 24-26.67S608 48 608 48zm-232 53.33c0 14.72 10.75 26.67 24 26.67s24-11.94 24-26.67S400 48 400 48s-24 38.61-24 53.33zm64 0c0 14.72 10.75 26.67 24 26.67s24-11.94 24-26.67S464 48 464 48s-24 38.61-24 53.33z", "M544 168a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v120h32zm-352 0a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v120h32zm-64 0a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v120h32zm288 0a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v120h32zm64 0a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v120h32zm-224 0a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v120h32zm368-8h-32a16 16 0 0 0-16 16v112a32 32 0 0 1-32 32H352V128a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v192H96a32 32 0 0 1-32-32V176a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v112a96 96 0 0 0 96 96h192v64H112a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H352v-64h192a96 96 0 0 0 96-96V176a16 16 0 0 0-16-16z"]],
    "hard-hat": [512, 512, [], "f807", ["M0 432v-32a16 16 0 0 1 16-16h480a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16z", "M320 80v112l40.81-81.62C430.72 139.08 480 207.75 480 288v64H32v-64c0-80.25 49.28-148.92 119.19-177.62L192 192V80a16 16 0 0 1 16-16h96a16 16 0 0 1 16 16z"]],
    "hashtag": [448, 512, [], "f292", ["M202.46 32.19a11.5 11.5 0 0 0-2.11-.19h-40.63a12 12 0 0 0-11.81 9.89L132.53 128h65l14.62-81.89a12 12 0 0 0-9.69-13.92zM72.19 465.89a12 12 0 0 0 9.7 13.92A11.5 11.5 0 0 0 84 480h40.64a12 12 0 0 0 11.81-9.89L186.11 192h-65zm163.65 0a12 12 0 0 0 9.7 13.92 11.5 11.5 0 0 0 2.11.19h40.63a12 12 0 0 0 11.82-9.89L315.47 384h-65zm130.27-433.7A11.5 11.5 0 0 0 364 32h-40.63a12 12 0 0 0-11.82 9.89L261.89 320h65l48.92-273.89a12 12 0 0 0-9.7-13.92z", "M44.18 191.81a11.5 11.5 0 0 0 2.11.19H285l11-64H53.43a12 12 0 0 0-11.81 9.89l-7.14 40a12 12 0 0 0 9.7 13.92zM7.33 329.89l-7.14 40a12 12 0 0 0 9.7 13.92A11.5 11.5 0 0 0 12 384h75l11-64H19.15a12 12 0 0 0-11.82 9.89zm430.78-201.7A11.5 11.5 0 0 0 436 128h-75l-11 64h78.85a12 12 0 0 0 11.82-9.89l7.14-40a12 12 0 0 0-9.7-13.92zm-34.29 192a11.5 11.5 0 0 0-2.11-.19H163l-11 64h242.57a12 12 0 0 0 11.81-9.89l7.14-40a12 12 0 0 0-9.7-13.92z"]],
    "hat-chef": [512, 512, [], "f86b", ["M416 32a95.17 95.17 0 0 0-57.73 19.74C334.93 20.5 298 0 256 0s-78.93 20.5-102.27 51.74A95.56 95.56 0 0 0 0 128c0 41.74 64 192 64 192h60.09L112 169.25a8 8 0 0 1 7.33-8.61l16-1.28a8 8 0 0 1 8.61 7.34L156.2 320h83.14V168a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v152h84.46l12.27-153.3a8 8 0 0 1 8.61-7.34l16 1.28a8 8 0 0 1 7.33 8.61L387.91 320H448s64-150.26 64-192a96 96 0 0 0-96-96z", "M64 480a32 32 0 0 0 32 32h320a32 32 0 0 0 32-32V352H64z"]],
    "hat-cowboy": [640, 512, [], "f8c0", ["M509.94 318.61C462.5 336.65 399.18 352 320 352c-79 0-142.34-15.44-189.9-33.56.12-.87.24-1.71.35-2.53 2.59-15.31 6.08-35.12 10.62-57.23C180.16 274.28 237.79 288 320 288s139.87-13.71 179-29.3c4.56 22.18 8.05 42 10.64 57.35.06.84.18 1.69.3 2.56z", "M499 258.7C481.92 175.83 450.62 64 401.33 64c-15.75 0-29.81 6.67-41.63 15.7a65.47 65.47 0 0 1-79.4 0c-11.82-9-25.87-15.7-41.63-15.7-49.28 0-80.57 111.82-97.61 194.68C180.16 274.28 237.79 288 320 288s139.87-13.71 179-29.3zm134 1a16 16 0 0 0-19.75 1.5c-1 .9-101.27 90.78-293.16 90.78-190.82 0-292.22-89.94-293.24-90.84A16 16 0 0 0 1 278.53C1.73 280.55 78.32 480 320 480s318.27-199.45 319-201.47a16 16 0 0 0-6.09-18.81z"]],
    "hat-cowboy-side": [640, 512, [], "f8c1", ["M640 400c0 67.24-60.25 80-75.2 80-92.89 0-139.5-37.07-209.87-104.46l-88.21-84.48C241 268.12 211 256 180 256c-69.69 0-128.64 62.72-146.68 156.06-3.19 16.6-.38 33.83 7.71 47.3C48.86 472.47 60.64 480 73.28 480h-42.7a23.86 23.86 0 0 1-21.64-13.63C-3.73 439.33.3 414.1 1.87 406 22.9 297.14 94.47 224 180 224c38.95 0 76.31 14.92 108.89 43.95l88.21 84.48C446.45 418.88 485.18 448 564.8 448c23.82 0 43.2-21.53 43.2-48 0-21.81-20.61-108.08-112.45-124.87L490 242.05C601.87 256 640 355.47 640 400z", "M354.93 375.54l-88.21-84.48C241 268.12 211 256 180 256c-69.69 0-128.64 62.72-146.68 156.06-3.19 16.6-.38 33.83 7.71 47.3C48.86 472.47 60.64 480 73.28 480H564.8c-71.12 0-115.11-21.73-163.41-62.16-14.78-12.38-29.97-26.5-46.46-42.3zm140.62-100.41l-27.16-162c-6.14-33-40.81-54.75-76.36-47.79l-191.18 37.38c-27.09 5.3-47.41 26.07-50.35 51.48l-7.57 74.53A146.73 146.73 0 0 1 180 224c38.95 0 76.31 14.92 108.89 43.95l88.21 84.48C446.45 418.88 485.18 448 564.8 448c23.82 0 43.2-21.53 43.2-48 0-21.81-20.61-108.08-112.45-124.87z"]],
    "hat-santa": [640, 512, [], "f7a7", ["M452.6 352H58.7l89.7-215.5A170 170 0 0 1 435 92.1l53.1 62.7a55.94 55.94 0 0 0-24.2 45.3 54.08 54.08 0 0 0-8.2 11.4L384 192z", "M480 384H32a32 32 0 0 0-32 32v32a32 32 0 0 0 32 32h448a32 32 0 0 0 32-32v-32a32 32 0 0 0-32-32zm160-144c0-12.1-8.2-21.9-19.2-25.2 5.5-10.1 4.4-22.8-4.2-31.4s-21.3-9.7-31.4-4.2c-3.3-11-13.1-19.2-25.2-19.2s-21.9 8.2-25.2 19.2c-10.1-5.5-22.8-4.4-31.4 4.2s-9.7 21.3-4.2 31.4c-11 3.3-19.2 13.1-19.2 25.2s8.2 21.9 19.2 25.2c-5.5 10.1-4.4 22.8 4.2 31.4a25.45 25.45 0 0 0 31.4 4.2c3.3 11 13.1 19.2 25.2 19.2s21.9-8.2 25.2-19.2c4 2.1 8.2 3.6 12.5 3.6a26.9 26.9 0 0 0 18.9-7.8c8.6-8.6 9.7-21.3 4.2-31.4 11-3.3 19.2-13.1 19.2-25.2z"]],
    "hat-winter": [512, 512, [], "f7a8", ["M128 270.1l64 32 64-32 64 32 64-32 64 32 7.2-3.6c-19.7-50.2-55.2-104.9-119-140.5-.4.4-.6.8-1 1.2a58.46 58.46 0 0 1-39.6 17.2 57.79 57.79 0 0 1-79.2 0 58.4 58.4 0 0 1-39.6-17.2c-.4-.4-.6-.8-1-1.2-63.9 35.6-99.4 90.4-119 140.5l7.2 3.6zM496 448H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h480a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M195.2 105.2c-5.5 10.1-4.4 22.8 4.2 31.4a25.45 25.45 0 0 0 31.4 4.2c3.3 11 13.1 19.2 25.2 19.2s21.9-8.2 25.2-19.2c4 2.1 8.2 3.6 12.5 3.6a26.9 26.9 0 0 0 18.9-7.8c8.6-8.6 9.7-21.3 4.2-31.4 11-3.3 19.2-13.1 19.2-25.2s-8.2-21.9-19.2-25.2c5.5-10.1 4.4-22.8-4.2-31.4s-21.3-9.7-31.4-4.2C277.9 8.2 268.1 0 256 0s-21.9 8.2-25.2 19.2c-10.1-5.5-22.8-4.4-31.4 4.2s-9.7 21.3-4.2 31.4C184.2 58.1 176 67.9 176 80s8.2 21.9 19.2 25.2zm270.5 223.9l-17.7 8.8-64-32-64 32-64-32-64 32-64-32-64 32-17.7-8.8C32.2 377.8 32 416 32 416h448s-.2-38.2-14.3-86.9z"]],
    "hat-witch": [576, 512, [], "f6e7", ["M571.21 426.81l-22.67-22.66c-6-6-15.49-6-22-.43A185.1 185.1 0 0 1 405.88 448H170.1a185.14 185.14 0 0 1-120.68-44.28c-6.5-5.53-16-5.61-22 .43L4.78 426.81c-6.44 6.44-6.45 17.25.4 23.25A248.62 248.62 0 0 0 170.1 512h235.78a248.64 248.64 0 0 0 164.93-61.94c6.84-6 6.84-16.81.4-23.25zM320 352h-64v64h64z", "M542.35 114.76L512 192l-14-42.12A32 32 0 0 0 467.59 128H428.4a32 32 0 0 0-30.4 21.87l-6.35 19a64.06 64.06 0 0 0 1.89 45.45l79.6 185.73A152.57 152.57 0 0 1 405.88 416H352v-64a32 32 0 0 0-32-32h-64a32 32 0 0 0-32 32v64h-53.9a152.51 152.51 0 0 1-67.1-15.81l104-233.86a128.08 128.08 0 0 1 53.46-59.15l166.35-103a32 32 0 0 1 38.5 5.16L534.62 82a32 32 0 0 1 7.73 32.76z"]],
    "hat-wizard": [512, 512, [], "f6e8", ["M512 464v32a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h480a16 16 0 0 1 16 16z", "M240 416h208l-86.41-201.63a64 64 0 0 1-1.89-45.45L416 0 228.42 107.19A128 128 0 0 0 175 166.34L64 416h144l-16-32-64-32 64-32 32-64 32 64 64 32-64 32zm48-224l-16 32-16-32-32-16 32-16 16-32 16 32 32 16z"]],
    "haykal": [512, 512, [], "f666", ["M239.69 218L256 166.72 272.29 218l44.95-28.62-20 49.87 52.57 7.38-46.91 25.12 35.61 39.93-51.89-11.3 2 53.79L256 311.68l-32.59 42.49 2-53.79-51.89 11.3 35.6-39.93-46.92-25.17 52.57-7.38-20-49.87z", "M496.25 202.52l-110-15.44 41.82-104.34c6.67-16.64-11.6-32.18-26.59-22.63l-94 59.89-34.13-107.18a18.15 18.15 0 0 0-34.7 0L204.56 120l-94-59.89c-15-9.55-33.25 6-26.59 22.63l41.82 104.34-110 15.43c-17.54 2.46-21.68 26.27-6 34.67l98.16 52.66-74.55 83.55c-10.92 12.25-1.72 30.93 13.29 30.93a18.79 18.79 0 0 0 4.07-.45l108.57-23.65-4.11 112.55A18.32 18.32 0 0 0 173.63 512a17.65 17.65 0 0 0 14.2-7.18L256 415.91l68.18 88.9a17.64 17.64 0 0 0 14.2 7.18 18.32 18.32 0 0 0 18.41-19.22l-4.11-112.55 108.57 23.65c17.36 3.76 29.21-17.2 17.35-30.49l-74.48-83.54 98.16-52.66c15.65-8.39 11.51-32.18-6.03-34.66zM338.51 311.68l-51.89-11.3 2 53.79L256 311.68l-32.59 42.49 2-53.79-51.89 11.3 35.6-39.93-46.92-25.17 52.57-7.38-20-49.87L239.69 218 256 166.72 272.29 218l44.95-28.62-20 49.87 52.57 7.38-46.91 25.12z"]],
    "hdd": [576, 512, [], "f0a0", ["M384 320a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm175.88-88.18L462.25 85.37A48 48 0 0 0 422.31 64H153.69a48 48 0 0 0-39.94 21.37L16.12 231.82A96 96 0 0 0 0 285.07V304a48 48 0 0 1 48-48h480a48 48 0 0 1 48 48v-18.93a96 96 0 0 0-16.12-53.25z", "M528 256H48a48 48 0 0 0-48 48v96a48 48 0 0 0 48 48h480a48 48 0 0 0 48-48v-96a48 48 0 0 0-48-48zM384 384a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm96 0a32 32 0 1 1 32-32 32 32 0 0 1-32 32z"]],
    "head-side": [512, 512, [], "f6e9", ["M509.21 275c-20.94-47.12-48.44-151.73-73.08-186.75A208 208 0 0 0 266.09 0H192C86 0 0 86 0 192a191.28 191.28 0 0 0 64 142.82V512h256v-64h64a64 64 0 0 0 64-64v-64h32a32 32 0 0 0 29.21-45zM320 224a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M320 224a32 32 0 1 1 32-32 32 32 0 0 1-32 32z"]],
    "head-side-brain": [512, 512, [], "f808", ["M509.21 275c-20.94-47.12-48.44-151.73-73.08-186.75A208 208 0 0 0 266.09 0H192C86 0 0 86 0 192a191.28 191.28 0 0 0 64 142.82V512h256v-64h64a64 64 0 0 0 64-64v-64h32a32 32 0 0 0 29.21-45zM336 208h-50.94a47.5 47.5 0 0 1 2.94 16 48 48 0 0 1-48 48 47.5 47.5 0 0 1-16-2.94V320h-64v-50.94a47.5 47.5 0 0 1-16 2.94 48 48 0 0 1-48-48c0-1 .23-1.89.29-2.85A47.88 47.88 0 0 1 112 128a48 48 0 0 1 48-48 47.43 47.43 0 0 1 23.53 6.4 47.76 47.76 0 0 1 80.94 0 47.38 47.38 0 0 1 68.59 25.6H336a48 48 0 0 1 0 96z", "M66.61 160.29A47.89 47.89 0 0 1 112 128a48 48 0 0 1 48-48 47.43 47.43 0 0 1 23.53 6.4 47.76 47.76 0 0 1 80.94 0 47.38 47.38 0 0 1 68.59 25.6H336a48 48 0 0 1 0 96h-50.94a47.5 47.5 0 0 1 2.94 16 48 48 0 0 1-48 48 47.5 47.5 0 0 1-16-2.94V320h-64v-50.94a47.5 47.5 0 0 1-16 2.94 48 48 0 0 1-48-48c0-1 .23-1.89.29-2.85a47.88 47.88 0 0 1-29.68-60.86z"]],
    "head-side-headphones": [512, 512, [], "f8c2", ["M480 320h-32v64a64 64 0 0 1-64 64h-64v64H64V334.81A191.27 191.27 0 0 1 0 192C0 86 86 0 192 0a191.52 191.52 0 0 0-32 2.88V107.2c-37.73 18-64 56.2-64 100.8a112 112 0 0 0 224 0c0-44.61-26.27-82.8-64-100.81V0h10.08a207.87 207.87 0 0 1 170 88.25c24.66 35 52.16 139.63 73.1 186.75A32 32 0 0 1 480 320z", "M256 107.19V0h-64a191.52 191.52 0 0 0-32 2.88V107.2c-37.73 18-64 56.2-64 100.8a112 112 0 0 0 224 0c0-44.61-26.25-82.8-64-100.81zM208 272a64 64 0 1 1 64-64 64 64 0 0 1-64 64zm0-96a32 32 0 1 0 32 32 32 32 0 0 0-32-32z"]],
    "head-side-medical": [512, 512, [], "f809", ["M509.21 275c-20.94-47.12-48.44-151.73-73.08-186.75A208 208 0 0 0 266.09 0H192C86 0 0 86 0 192a191.28 191.28 0 0 0 64 142.82V512h256v-64h64a64 64 0 0 0 64-64v-64h32a32 32 0 0 0 29.21-45zM320 216a8 8 0 0 1-8 8h-56v56a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-56h-56a8 8 0 0 1-8-8v-48a8 8 0 0 1 8-8h56v-56a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8v56h56a8 8 0 0 1 8 8z", "M320 216a8 8 0 0 1-8 8h-56v56a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-56h-56a8 8 0 0 1-8-8v-48a8 8 0 0 1 8-8h56v-56a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8v56h56a8 8 0 0 1 8 8z"]],
    "head-vr": [512, 512, [], "f6ea", ["M509.2 275c-2.47-5.56-5.05-12-7.69-19H308.56a119.09 119.09 0 0 1-80.92-32H35a191.65 191.65 0 0 0 61 110.82V512h224v-64h64a64 64 0 0 0 64-64v-64h32a32 32 0 0 0 29.2-45zM220.94 68.87A112.21 112.21 0 0 1 304 32h72.3A207.36 207.36 0 0 0 266.09 0H224C140.44 0 69.54 53.48 43.16 128h150a112.22 112.22 0 0 1 27.78-59.13z", "M496 64h-48v160h48a16 16 0 0 0 16-16V80a16 16 0 0 0-16-16zm-270.4 64H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h224.84c15.81 19.71 41 32 67.72 32H416V64H304a80 80 0 0 0-78.4 64z"]],
    "heading": [512, 512, [], "f1dc", ["M480 32H320a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h160a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm-288 0H32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h160a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm0 384H32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h160a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm288 0H320a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h160a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M352 96h96v320h-96V288H160v128H64V96h96v128h192z"]],
    "headphones": [512, 512, [], "f025", ["M512 288v48a32 32 0 0 1-17.69 28.62l-14.37 7c0-1.19.06-2.38.06-3.58a111.64 111.64 0 0 0-32-78.37V288c0-105.87-86.13-192-192-192S64 182.13 64 288v1.63A111.64 111.64 0 0 0 32 368c0 1.2 0 2.39.06 3.58l-14.37-7A32 32 0 0 1 0 336v-48C0 146.5 114.52 32 256 32s256 114.52 256 256z", "M168 256h-24a112 112 0 0 0 0 224h24a24 24 0 0 0 24-24V280a24 24 0 0 0-24-24zm200 0h-24a24 24 0 0 0-24 24v176a24 24 0 0 0 24 24h24a112 112 0 0 0 0-224z"]],
    "headphones-alt": [512, 512, [], "f58f", ["M496 416h-16a16 16 0 0 1-16-16V288c0-114.67-93.33-207.8-208-207.82S48 173.33 48 288v112a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16V288C4.57 151.13 112.91 32 256 32s251.43 119.13 256 256v112a16 16 0 0 1-16 16z", "M160 288h-16a64.05 64.05 0 0 0-64 64.12v63.76A64.06 64.06 0 0 0 144 480h16a32 32 0 0 0 32-32.06V320.06A32 32 0 0 0 160 288zm208 0h-16a32 32 0 0 0-32 32.06v127.88A32 32 0 0 0 352 480h16a64.06 64.06 0 0 0 64-64.12v-63.76A64.06 64.06 0 0 0 368 288z"]],
    "headset": [512, 512, [], "f590", ["M192 464a48 48 0 0 1 48-48h32a48 48 0 0 1 48 48h101.72A42.28 42.28 0 0 0 464 421.72s0-163.29-.12-165.72h.12c0-114.69-93.31-208-208-208S48 141.31 48 256v16a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-16C4.58 118.83 113.18 0 256 0s251.42 118.83 256 256v165.72A90.28 90.28 0 0 1 421.72 512H240a48 48 0 0 1-48-48z", "M368 176h-16a32 32 0 0 0-32 32v112a32 32 0 0 0 32 32h16a64 64 0 0 0 64-64v-48a64 64 0 0 0-64-64zm-208 0h-16a64 64 0 0 0-64 64v48a64 64 0 0 0 64 64h16a32 32 0 0 0 32-32V208a32 32 0 0 0-32-32z"]],
    "heart": [512, 512, [], "f004", ["M462.32 62.63C407.5 15.94 326 24.33 275.69 76.23L256 96.53l-19.69-20.3c-50.21-51.9-131.8-60.29-186.61-13.6-62.78 53.6-66.09 149.81-9.88 207.9l193.5 199.79a31.31 31.31 0 0 0 45.28 0l193.5-199.79c56.31-58.09 53-154.3-9.78-207.9zm-52.8 185l-143.1 143.85a15.29 15.29 0 0 1-21.7 0l-140-140.78c-28.37-28.52-33.78-75-8.37-106.23a76.44 76.44 0 0 1 113.77-5.88l45.49 45.7 42.37-42.58c28.38-28.52 74.65-34 105.71-8.45a77.35 77.35 0 0 1 5.83 114.36z", "M244.72 391.48l-140-140.78c-28.37-28.52-33.78-75-8.36-106.23a76.43 76.43 0 0 1 113.76-5.88l45.49 45.7 42.37-42.58c28.38-28.51 74.65-34 105.71-8.45a77.35 77.35 0 0 1 5.87 114.36L266.41 391.48a15.28 15.28 0 0 1-21.69 0z"]],
    "heart-broken": [512, 512, [], "f7a9", ["M473.68 73.78c48.71 49.79 50.8 129.08 7.3 182.08L268.8 474.53a17.82 17.82 0 0 1-25.19.5l-.51-.5L31 256c-43.49-53.1-41.39-132.39 7.3-182.18l2.4-2.4C87 24 159.7 19.6 211.41 57.39L240 143.87l-96 64 144 144-48-128 96-64-34.31-103.39c51.6-36.89 123.59-32.19 169.59 14.8z", "M288 352L144 208l96-64.1-28.59-86.52q16.68 14.15 32 29.81L256 100l11.67-12q16.23-16.64 34-31.6L336 159.87l-96 64z"]],
    "heart-circle": [496, 512, [], "f4c7", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8ZM371.5,280.3,260.9,394.5a17.88,17.88,0,0,1-25.28.62h0c-.21-.2-.42-.41-.62-.62L124.5,280.3c-32.1-33.2-30.2-88.2,5.7-118.8,31.3-26.7,77.9-21.9,106.6,7.7l11.3,11.6,11.3-11.6c28.7-29.6,75.3-34.4,106.6-7.7,35.8,30.6,37.7,85.6,5.5,118.8Z", "M371.5,280.3,260.9,394.5a17.88,17.88,0,0,1-25.28.62h0c-.21-.2-.42-.41-.62-.62L124.5,280.3c-32.1-33.2-30.2-88.2,5.7-118.8,31.3-26.7,77.9-21.9,106.6,7.7l11.3,11.6,11.3-11.6c28.7-29.6,75.3-34.4,106.6-7.7,35.8,30.6,37.7,85.6,5.5,118.8Z"]],
    "heart-rate": [640, 512, [], "f5f8", ["M640 240v32a16 16 0 0 1-16 16H499.78l-55.15 110.3a32 32 0 0 1-59.5-5.89l-61.39-225.12-68.44 319.4A32 32 0 0 1 225.08 512h-1.09a32 32 0 0 1-30.75-23.2L135.86 288H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h144a32 32 0 0 1 30.77 23.2L219.56 348 288.7 25.3a32 32 0 0 1 62.18-1.72l73.95 271.2 26.54-53.09A32 32 0 0 1 480 224h144a16 16 0 0 1 16 16z", ""]],
    "heart-square": [448, 512, [], "f4c8", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-52.5 248.3L236.9 394.5a17.88 17.88 0 0 1-25.9 0L100.5 280.3c-32.1-33.2-30.2-88.2 5.7-118.8 31.3-26.7 77.9-21.9 106.6 7.7l11.3 11.6 11.3-11.6c28.7-29.6 75.3-34.4 106.6-7.7 35.8 30.6 37.7 85.6 5.5 118.8z", "M106.2 161.5c31.3-26.7 77.9-21.9 106.6 7.7l11.3 11.6 11.3-11.6c28.7-29.6 75.3-34.4 106.6-7.7 35.8 30.6 37.7 85.6 5.5 118.8L236.9 394.5a17.88 17.88 0 0 1-25.9 0L100.5 280.3c-32.1-33.2-30.2-88.2 5.7-118.8z"]],
    "heartbeat": [512, 512, [], "f21e", ["M320.21 243.85l-49.7 99.4a16 16 0 0 1-28.9-.6l-56.9-126.3-30 71.7h-94.1l182.5 186.5a17.82 17.82 0 0 0 25.7 0l182.61-186.5H342.31zM473.71 74l-2.4-2.5a131 131 0 0 0-187.39 0L256 100.05l-27.9-28.5a130.83 130.83 0 0 0-187.4 0L38.31 74c-48.7 49.8-50.8 129.1-7.3 182.1h102.41l35.89-86.2a16 16 0 0 1 29.4-.4l58.21 129.3 49-97.9a16 16 0 0 1 28.59 0l27.6 55.2H481c43.51-53.05 41.42-132.35-7.29-182.1z", "M451 288l-.1.05H342.31l-22.1-44.2-49.7 99.4a16 16 0 0 1-28.9-.6l-56.9-126.3-30 71.7H61V288l-29.95-31.95h102.37l35.89-86.2a16 16 0 0 1 29.4-.4l58.21 129.3 49-97.9a16 16 0 0 1 28.59 0l27.6 55.2H481z"]],
    "helicopter": [640, 512, [], "f533", ["M635.37 458.81l-22.15-22.2a16.13 16.13 0 0 0-22.64 0c-7.09 6.77-13.84 11.25-24.64 11.25H240a16 16 0 0 0-16 16V496a16 16 0 0 0 16 16h325.94c14.88 0 35.3-.47 68.45-29.52a16.28 16.28 0 0 0 .98-23.67zM320 128h64V64h176a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16H144a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h176z", "M384 128H112L68.8 70.4A16 16 0 0 0 56 64H16A16 16 0 0 0 .49 83.88L32 192l160 64 86.4 115.2A32 32 0 0 0 304 384h272a32 32 0 0 0 32-32c0-123.71-100.29-224-224-224zm32 192V195.51C478.55 208.3 528 257.44 540.79 320z"]],
    "helmet-battle": [576, 512, [], "f6eb", ["M32 256c17.67 0 32-12.56 32-28.06V0L1 221.13C-4.08 238.84 11.2 256 32 256zm543-34.87L512 0v227.94c0 15.5 14.32 28.06 32 28.06 20.8 0 36.08-17.16 31-34.87z", "M494.82 426.77L320 512V256l96-32v-32H160v32l96 32v256L81.19 426.77C68.46 420.9 61.44 406 64.87 391.53 73.14 356.72 96 293.58 96 210.82 96 90.35 288 0 288 0s192 90.35 192 210.82c0 82.76 22.86 145.9 31.14 180.71 3.43 14.47-3.59 29.37-16.32 35.24z"]],
    "hexagon": [576, 512, [], "f312", ["M553.48 231.8l-112-192A48.08 48.08 0 0 0 400 16H176a48.08 48.08 0 0 0-41.5 23.8l-112 192a48.19 48.19 0 0 0 0 48.4l112 192A48.08 48.08 0 0 0 176 496h224a48.08 48.08 0 0 0 41.5-23.8l112-192a48.19 48.19 0 0 0-.02-48.4zm-87.19 38.86l-76.38 130.91A29.1 29.1 0 0 1 364.78 416H211.22a29.1 29.1 0 0 1-25.13-14.43l-76.38-130.91a29.12 29.12 0 0 1 0-29.32l76.38-130.91A29.08 29.08 0 0 1 211.22 96h153.56a29.08 29.08 0 0 1 25.13 14.43l76.38 130.91a29.12 29.12 0 0 1 0 29.32z", "M466.29 270.66l-76.38 130.91A29.1 29.1 0 0 1 364.78 416H211.22a29.1 29.1 0 0 1-25.13-14.43l-76.38-130.91a29.12 29.12 0 0 1 0-29.32l76.38-130.91A29.08 29.08 0 0 1 211.22 96h153.56a29.08 29.08 0 0 1 25.13 14.43l76.38 130.91a29.12 29.12 0 0 1 0 29.32z"]],
    "highlighter": [544, 512, [], "f591", ["M0 480l99.92 32 35.45-35.45-67-67zM527.92 79.27l-63.2-63.2a54.89 54.89 0 0 0-75.12-2.35l-199 170 169.72 169.74 170-199.06a54.88 54.88 0 0 0-2.4-75.13z", "M75.94 371.84l50.93-50.94-13.05-42.83A36.6 36.6 0 0 1 124.61 240l41.52-35.44 173.34 173.31-35.55 41.64a36.59 36.59 0 0 1-38.15 10.78L223 417.21l-50.86 50.86z"]],
    "hiking": [384, 512, [], "f6ec", ["M368 160h-16a16 16 0 0 0-16 16v320a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16V176a16 16 0 0 0-16-16zM240 0a48 48 0 1 0 48 48 48 48 0 0 0-48-48zM125.08 97.94C81.2 87.42 36.73 113 25.76 155.11L.49 253.24c-2.19 8.42 3.14 16.95 11.92 19.06L76 287.55c8.79 2.1 17.68-3 19.87-11.44L137 117c2.19-8.42-3.14-16.95-11.92-19.06z", "M81 472.23a32 32 0 0 0 62.1 15.53l25.24-101L115.51 334zm162-248l22.43 22.43A32 32 0 0 0 288 256h48v-64h-34.75l-46.78-46.78a58.78 58.78 0 0 0-98.59 27.3L129 280.24a32 32 0 0 0 8.42 30.39L224 397.25V480a32 32 0 0 0 64 0v-82.75A63.58 63.58 0 0 0 269.25 352l-46.82-46.82c.15-.5.49-.89.62-1.41z"]],
    "hippo": [640, 512, [], "f6ed", ["M581.12 96.2c-27.67-.15-52.5 17.58-76.6 26.62A96 96 0 0 0 416 64a95 95 0 0 0-32 5.88V56a24 24 0 0 0-24-24h-16a24 24 0 0 0-24 24v49c-34-25.4-78.76-41-128-41C86 64 0 135.64 0 224v240a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16v-70.79C128.35 407.57 166.72 416 208 416s79.65-8.43 112-22.79V464a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16V288h192a32 32 0 0 0 32-32v-92c0-34.11-24.79-67.61-58.88-67.8zM448 176a16 16 0 1 1 16-16 16 16 0 0 1-16 16z", "M544 288v16a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-16zm-96-144a16 16 0 1 0 16 16 16 16 0 0 0-16-16z"]],
    "history": [512, 512, [], "f1da", ["M141.68 400.23a184 184 0 1 0-11.75-278.3l50.76 50.76c10.08 10.08 2.94 27.31-11.32 27.31H24a16 16 0 0 1-16-16V38.63c0-14.26 17.23-21.4 27.31-11.32l49.38 49.38A247.14 247.14 0 0 1 256 8c136.81 0 247.75 110.78 248 247.53S392.82 503.9 256.18 504a247 247 0 0 1-155.82-54.91 24 24 0 0 1-1.84-35.61l11.27-11.27a24 24 0 0 1 31.89-1.98z", "M288 152v104.35L328.7 288a24 24 0 0 1 4.21 33.68l-9.82 12.62a24 24 0 0 1-33.68 4.21L224 287.65V152a24 24 0 0 1 24-24h16a24 24 0 0 1 24 24z"]],
    "hockey-mask": [448, 512, [], "f6ee", ["M376.61 54.46c-82.95-72.61-222.26-72.61-305.22 0-64 56-102.4 170-38.76 361.54C64.53 512 224 512 224 512s159.47 0 191.37-96C479 224.44 440.64 110.5 376.61 54.46zM288 64a16 16 0 1 1-16 16 16 16 0 0 1 16-16zm-128 0a16 16 0 1 1-16 16 16 16 0 0 1 16-16zm16 400a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm0-64a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm0-64a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm-48-64a64 64 0 0 1-64-64 32 32 0 0 1 32-32h64a32 32 0 0 1 32 32 64 64 0 0 1-64 64zm96-128a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm48 320a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm0-64a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm0-64a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm48-64a64 64 0 0 1-64-64 32 32 0 0 1 32-32h64a32 32 0 0 1 32 32 64 64 0 0 1-64 64z", "M176 432a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm0-64a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm0-64a16 16 0 1 0 16 16 16 16 0 0 0-16-16zM288 64a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm-16 240a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm0 64a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm0 64a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm-48-320a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm-48-32a16 16 0 1 0-16 16 16 16 0 0 0 16-16z"]],
    "hockey-puck": [512, 512, [], "f453", ["M0 160c0-53 114.6-96 256-96s256 43 256 96-114.6 96-256 96S0 213 0 160z", "M0 352V242.2c113.5 82.4 398.6 82.3 512 0V352c0 53-114.6 96-256 96S0 405 0 352z"]],
    "hockey-sticks": [640, 512, [], "f454", ["M233.65 8.93v-.08a16 16 0 0 0-21.49-7.16l-57.26 28.6a16.11 16.11 0 0 0-7.21 21.5l118.66 237L320 181.47zM624 352h-48v160h48a16 16 0 0 0 16-16V368a16 16 0 0 0-16-16zm-223-8.8l-27.26-54.46L320 395.94l40.39 80.66A64.52 64.52 0 0 0 418 512h126V352H416c-6.06 0-12.35-3.39-15.06-8.8zM64 512h32V352H64z", "M485.13 30.29l-57.26-28.6a16 16 0 0 0-21.49 7.16v.08L239.06 343.2c-2.71 5.41-9 8.82-15.06 8.8H96v160h126a64.52 64.52 0 0 0 57.61-35.4L492.34 51.79a16.11 16.11 0 0 0-7.21-21.5zM0 368v128a16 16 0 0 0 16 16h48V352H16a16 16 0 0 0-16 16zm544-16v160h32V352z"]],
    "holly-berry": [448, 512, [], "f7aa", ["M207.86 235.1a15.66 15.66 0 0 0-23.8-13.7c-34.3 20.3-71.4 32.7-108.7 36.2a14.38 14.38 0 0 0-11.6 20.2 247.71 247.71 0 0 1 14.7 43.8 29.59 29.59 0 0 1-20.2 35.1A237.74 237.74 0 0 1 13 365.8 14.45 14.45 0 0 0 1.26 386c15 32.8 22.9 69.5 23 107.7a18.34 18.34 0 0 0 27.6 16c33.2-19 68.9-30.5 104.8-33.9a14.38 14.38 0 0 0 11.6-20.2 247.71 247.71 0 0 1-14.7-43.8 29.59 29.59 0 0 1 20.2-35.1 237.74 237.74 0 0 1 45.3-9.1 14.45 14.45 0 0 0 11.7-20.2c-15.5-34.2-23.3-72.5-22.9-112.3zm227.2 130.5a256.08 256.08 0 0 1-45.3-9.1 29.59 29.59 0 0 1-20.2-35.1 250.47 250.47 0 0 1 14.7-43.8 14.38 14.38 0 0 0-11.6-20.2c-37.3-3.5-74.4-15.9-108.7-36.2a15.72 15.72 0 0 0-23.8 13.7c0 1.6-.2 3.2-.2 4.9.2 33.3 7 65.7 19.9 94a46 46 0 0 1-.6 38.9c4.9 1.2 9.9 2.2 14.8 3.7a29.59 29.59 0 0 1 20.2 35.1 250.47 250.47 0 0 1-14.7 43.8 14.38 14.38 0 0 0 11.6 20.2c35.9 3.4 71.6 14.9 104.8 33.9a18.3 18.3 0 0 0 27.6-16c.2-38.2 8-75 23-107.7 4.3-8.7-1.8-19.1-11.5-20.1z", "M144.06 96a48 48 0 1 0 48 48 48 48 0 0 0-48-48zm160 0a48 48 0 1 0 48 48 48 48 0 0 0-48-48zm-32-48a48 48 0 1 0-48 48 48 48 0 0 0 48-48z"]],
    "home": [576, 512, [], "f015", ["M336 463.59V368a16 16 0 0 0-16-16h-64a16 16 0 0 0-16 16v95.71a16 16 0 0 1-15.92 16L112 480a16 16 0 0 1-16-16V300.06l184.39-151.85a12.19 12.19 0 0 1 15.3 0L480 300v164a16 16 0 0 1-16 16l-112-.31a16 16 0 0 1-16-16.1z", "M573.32 268.35l-25.5 31a12 12 0 0 1-16.9 1.65L295.69 107.21a12.19 12.19 0 0 0-15.3 0L45.17 301a12 12 0 0 1-16.89-1.65l-25.5-31a12 12 0 0 1 1.61-16.89L257.49 43a48 48 0 0 1 61 0L408 116.61V44a12 12 0 0 1 12-12h56a12 12 0 0 1 12 12v138.51l83.6 68.91a12 12 0 0 1 1.72 16.93z"]],
    "home-alt": [576, 512, [], "f80a", ["M336 463.58v-95.64a16 16 0 0 0-16-16h-64a16 16 0 0 0-16 16v95.71a16 16 0 0 1-15.92 16l-112.08.29a16 16 0 0 1-16-16V300.05L280.39 148.2a12.19 12.19 0 0 1 15.3 0L480 299.94v164a16 16 0 0 1-16 16l-112-.31a16 16 0 0 1-16-16.05z", "M530.92 300.94L295.69 107.2a12.19 12.19 0 0 0-15.3 0L45.17 300.94a12 12 0 0 1-16.89-1.64l-25.5-31a12 12 0 0 1 1.61-16.89l253.1-208.47a48 48 0 0 1 61 0l253.13 208.47a12 12 0 0 1 1.66 16.89l-25.5 31a12 12 0 0 1-16.86 1.64z"]],
    "home-heart": [576, 512, [], "f4c9", ["M64.11 311.38V496a16.05 16.05 0 0 0 16 16h416a16.05 16.05 0 0 0 16-16V311.38c-6.7-5.5-44.7-38.31-224-196.4-180.11 158.9-217.6 191.09-224 196.4zm314.1-26.31a60.6 60.6 0 0 1 4.5 89.11L298 459.77a13.94 13.94 0 0 1-19.8 0l-84.7-85.59a60.66 60.66 0 0 1 4.3-89.11c24-20 59.7-16.39 81.6 5.81l8.6 8.69 8.6-8.69c22.01-22.2 57.71-25.81 81.61-5.81z", "M378.21 285.07c-23.9-20-59.6-16.39-81.6 5.81l-8.6 8.69-8.6-8.69c-21.9-22.2-57.6-25.81-81.6-5.81a60.66 60.66 0 0 0-4.3 89.11l84.7 85.59a13.94 13.94 0 0 0 19.8 0l84.7-85.59a60.6 60.6 0 0 0-4.5-89.11zm192.6-48.8l-58.7-51.79V48a16 16 0 0 0-16-16h-64a16 16 0 0 0-16 16v51.7l-101.3-89.43a40 40 0 0 0-53.5 0l-256 226a16 16 0 0 0-1.2 22.61l21.4 23.8a16 16 0 0 0 22.6 1.2l229.4-202.2a16.12 16.12 0 0 1 21.2 0L528 284a16 16 0 0 0 22.6-1.21L572 259a16.11 16.11 0 0 0-1.19-22.73z"]],
    "home-lg": [576, 512, [], "f80b", ["M496 512H368a16 16 0 0 1-16-16V368a16 16 0 0 0-16-16h-96a16 16 0 0 0-16 16v128a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16V311c1.78-1.21 3.85-1.89 5.47-3.35L288 115l218.74 192.9c1.54 1.38 3.56 2 5.26 3.2V496a16 16 0 0 1-16 16z", "M527.92 283.88L298.6 81.61a16 16 0 0 0-21.17 0L48.11 283.89a16 16 0 0 1-22.59-1.21L4.1 258.89a16 16 0 0 1 1.21-22.59l256-226a39.85 39.85 0 0 1 53.45 0L416 99.67V48a16 16 0 0 1 16-16h64a16 16 0 0 1 16 16v136.43l58.69 51.83a16 16 0 0 1 1.22 22.59l-21.4 23.82a16 16 0 0 1-22.59 1.21z"]],
    "home-lg-alt": [576, 512, [], "f80c", ["M352 496V368a16 16 0 0 0-16-16h-96a16 16 0 0 0-16 16v128a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16V311.07c1.78-1.21 3.85-1.89 5.47-3.35L288 115l218.74 192.9c1.54 1.38 3.56 2 5.26 3.2V496a16 16 0 0 1-16 16H368a16 16 0 0 1-16-16z", "M527.92 283.91L298.6 81.64a16 16 0 0 0-21.17 0L48.11 283.92a16 16 0 0 1-22.59-1.21L4.1 258.89a16 16 0 0 1 1.21-22.59l256-226a39.85 39.85 0 0 1 53.45 0l255.94 226a16 16 0 0 1 1.22 22.59l-21.4 23.82a16 16 0 0 1-22.6 1.2z"]],
    "hood-cloak": [576, 512, [], "f6ef", ["M576 480c-.19 16.52-13.46 32-32.33 32h-127.4V320a128 128 0 0 0-256 0v192H32.33C13.46 512 .19 496.52 0 480a31.1 31.1 0 0 1 6.36-19.16C64 383.87 64 320 64 320v-64C64 109.45 192 0 287.6 0h149.11C454.22 0 463 21.17 450.6 33.55L410.85 73.3C465.66 133 512 172 512 256v64s0 63.87 57.67 140.84A31.11 31.11 0 0 1 576 480z", "M416.27 320v192h-256V320a128 128 0 0 1 256 0z"]],
    "horizontal-rule": [640, 512, [], "f86c", ["M640 240.13v31.74A16 16 0 0 1 624.13 288H15.87A16 16 0 0 1 0 271.87v-31.74A16 16 0 0 1 15.87 224h608.26A16 16 0 0 1 640 240.13z", ""]],
    "horse": [576, 512, [], "f6f0", ["M575.94 76.6a31.75 31.75 0 0 0-8.59-21.8c-3.78-4-8.58-9.12-13.69-14.5 11.06-6.84 19.5-17.49 22.18-30.66a8.08 8.08 0 0 0-6.39-9.49 8 8 0 0 0-1.54-.15h-120a128 128 0 0 0-128 128H160a96 96 0 0 0-65.56 166.12l-25.62 68.36a64 64 0 0 0-2.16 38l24.85 99.41A16 16 0 0 0 107 512h66a16 16 0 0 0 15.52-19.88l-26.33-105.26L186 323.27l134 22.31V496a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16V318.22A111.49 111.49 0 0 0 448 240c0-.22-.07-.42-.08-.64V224l.08-32a1.15 1.15 0 0 1-.08.41v-55.52h.08l15.93 7.11 18.9 37.7a32 32 0 0 0 40.49 15.37l32.55-13A32 32 0 0 0 576 154.31zm-64 19.4a16 16 0 1 1 16-16 16 16 0 0 1-16.01 16z", "M0 248v56a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16v-56a39.93 39.93 0 0 1 16.36-32.26A95.65 95.65 0 0 1 88.45 160H88a88 88 0 0 0-88 88zM511.93 64a16 16 0 1 0 16 16 16 16 0 0 0-16-16z"]],
    "horse-head": [512, 512, [], "f7ab", ["M509.8 332.43l-69.9-164.3a123.55 123.55 0 0 0-93-79.2c18-10.6 46.3-35.9 34.2-82.3A9.29 9.29 0 0 0 369.54.39l-.44.14-202.2 75.7C35.9 123.33 0 238.83 0 398.73v81.2a32 32 0 0 0 32 32h236.2a32 32 0 0 0 28.6-46.3l-40.8-81.7v-.7a127.76 127.76 0 0 1-104.3-69.6 7.93 7.93 0 0 1 1.6-9.3l12.1-12.1a8 8 0 0 1 11.31.09 8.14 8.14 0 0 1 1.59 2.31A95.46 95.46 0 0 0 265.7 352c17.2 0 33-5.1 46.8-13.2l46 63.9a31.87 31.87 0 0 0 26 13.3h50.3a31.9 31.9 0 0 0 22.6-9.4l45.3-39.8a32.45 32.45 0 0 0 7.1-34.37zM328 223.93a23.94 23.94 0 1 1 .12 0z", "M178.3 294.63a8 8 0 0 0-12.9-2.4l-12.1 12.1a7.93 7.93 0 0 0-1.6 9.3 127.76 127.76 0 0 0 104.3 69.6v.77l10.66-32h-1a95.46 95.46 0 0 1-87.36-57.37zm149.82-118.58a23.94 23.94 0 1 0-.12 47.88h.12a23.94 23.94 0 0 0 0-47.88z"]],
    "horse-saddle": [576, 512, [], "f8c3", ["M128 160v-26.12C90.8 147.11 64 182.27 64 224a96 96 0 0 0 30.43 70.11l-25.61 68.37a64 64 0 0 0-2.16 38l24.85 99.41A16 16 0 0 0 107 512h66a16 16 0 0 0 15.52-19.88l-26.33-105.26L186 323.27l22 3.66v-72.54A95.83 95.83 0 0 1 128 160zm447.94-83.4a31.75 31.75 0 0 0-8.59-21.8c-3.78-4-8.58-9.12-13.69-14.5 11.06-6.84 19.5-17.49 22.18-30.66a8.08 8.08 0 0 0-6.37-9.49 8 8 0 0 0-1.56-.15h-120A127.94 127.94 0 0 0 320 127.11V160a95.83 95.83 0 0 1-80 94.39v77.87l80 13.32V496a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16V318.22A111.49 111.49 0 0 0 448 240c0-.22-.07-.42-.08-.64V224l.08-32a1.15 1.15 0 0 1-.08.41v-55.52h.08l15.93 7.11 18.9 37.7a32 32 0 0 0 40.49 15.37l32.55-13A32 32 0 0 0 576 154.31zm-64 19.4a16 16 0 1 1 16-16 16 16 0 0 1-16 16z", "M0 248v56a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16v-56a39.93 39.93 0 0 1 16.36-32.26A95.65 95.65 0 0 1 88.45 160H88a88 88 0 0 0-88 88zm160-120c-11.35 0-22 2.5-32 6.17V160a95.83 95.83 0 0 0 80 94.39v72.54l32 5.33v-77.87A95.83 95.83 0 0 0 320 160v-32.93c0 .32-.09.61-.09.93zm351.93-64a16 16 0 1 0 16 16 16 16 0 0 0-16-16z"]],
    "hospital": [448, 512, [], "f0f8", ["M436 480h-20V120a24 24 0 0 0-24-24h-72V24a24 24 0 0 0-24-24H152a24 24 0 0 0-24 24v72H56a24 24 0 0 0-24 24v360H12a12 12 0 0 0-12 12v20h192v-96a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12v96h192v-20a12 12 0 0 0-12-12zM192 340a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm53.33-126.67V152a8 8 0 0 1-8 8h-26.66a8 8 0 0 1-8-8v-34.67H168a8 8 0 0 1-8-8V82.67a8 8 0 0 1 8-8h34.67V40a8 8 0 0 1 8-8h26.66a8 8 0 0 1 8 8v34.67H280a8 8 0 0 1 8 8v26.66a8 8 0 0 1-8 8zM320 340a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12z", "M180 288h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm0-96h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm108-82.67V82.67a8 8 0 0 0-8-8h-34.67V40a8 8 0 0 0-8-8h-26.66a8 8 0 0 0-8 8v34.67H168a8 8 0 0 0-8 8v26.66a8 8 0 0 0 8 8h34.67V152a8 8 0 0 0 8 8h26.66a8 8 0 0 0 8-8v-34.67H280a8 8 0 0 0 8-8zM308 288h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm0-96h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12z"]],
    "hospital-alt": [576, 512, [], "f47d", ["M544 96H416V32a32 32 0 0 0-32-32H192a32 32 0 0 0-32 32v64H32a32 32 0 0 0-32 32v368a16 16 0 0 0 16 16h544a16 16 0 0 0 16-16V128a32 32 0 0 0-32-32zM160 436a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-128a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm160 128a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-128a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm32-182.67a8 8 0 0 1-8 8h-34.67V168a8 8 0 0 1-8 8h-26.66a8 8 0 0 1-8-8v-34.67H232a8 8 0 0 1-8-8V98.67a8 8 0 0 1 8-8h34.67V56a8 8 0 0 1 8-8h26.66a8 8 0 0 1 8 8v34.67H344a8 8 0 0 1 8 8zM480 436a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-128a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12z", "M344 90.67h-34.67V56a8 8 0 0 0-8-8h-26.66a8 8 0 0 0-8 8v34.67H232a8 8 0 0 0-8 8v26.66a8 8 0 0 0 8 8h34.67V168a8 8 0 0 0 8 8h26.66a8 8 0 0 0 8-8v-34.67H344a8 8 0 0 0 8-8V98.67a8 8 0 0 0-8-8zM148 384h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm0-128h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm160 128h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm0-128h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm160 128h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm0-128h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12z"]],
    "hospital-symbol": [512, 512, [], "f47e", ["M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256 256-114.6 256-256S397.4 0 256 0zm112 376a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-88h-96v88a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8V136a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8v88h96v-88a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8z", "M368 376a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-88h-96v88a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8V136a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8v88h96v-88a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8z"]],
    "hospital-user": [640, 512, [], "f80d", ["M320 96h-32V32a32 32 0 0 0-32-32H96a32 32 0 0 0-32 32v64H32a32 32 0 0 0-32 32v368a16 16 0 0 0 16 16h288.31A78.66 78.66 0 0 1 288 464.79a143.1 143.1 0 0 1 41.91-102.34A145.13 145.13 0 0 1 352 344.62V128a32 32 0 0 0-32-32zM144 404a12 12 0 0 1-12 12H92a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-128a12 12 0 0 1-12 12H92a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm53.33-108a8 8 0 0 1-8 8h-26.66a8 8 0 0 1-8-8v-34.67H120a8 8 0 0 1-8-8V98.67a8 8 0 0 1 8-8h34.67V56a8 8 0 0 1 8-8h26.66a8 8 0 0 1 8 8v34.67H232a8 8 0 0 1 8 8v26.66a8 8 0 0 1-8 8h-34.67zM272 404a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-128a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12z", "M528.62 352H528a22.83 22.83 0 0 0-7.06 1.09 124.81 124.81 0 0 1-81.89 0A22.82 22.82 0 0 0 432 352a112 112 0 0 0-112 112v.62c.14 26.26 21.73 47.38 48 47.38h224c26.27 0 47.86-21.12 48-47.38A112 112 0 0 0 528.62 352zM480 320a96 96 0 1 0-96-96 96 96 0 0 0 96 96zM232 90.67h-34.67V56a8 8 0 0 0-8-8h-26.66a8 8 0 0 0-8 8v34.67H120a8 8 0 0 0-8 8v26.66a8 8 0 0 0 8 8h34.67V168a8 8 0 0 0 8 8h26.66a8 8 0 0 0 8-8v-34.67H232a8 8 0 0 0 8-8V98.67a8 8 0 0 0-8-8z"]],
    "hospitals": [640, 512, [], "f80e", ["M608 96V32a32 32 0 0 0-32-32H416a32 32 0 0 0-32 32v64a32 32 0 0 0-32 32v352a32 32 0 0 0 32 32h224a32 32 0 0 0 32-32V128a32 32 0 0 0-32-32zM480 404a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-128a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm2.67-116a8 8 0 0 1-8-8v-34.67H440a8 8 0 0 1-8-8V82.67a8 8 0 0 1 8-8h34.67V40a8 8 0 0 1 8-8h26.66a8 8 0 0 1 8 8v34.67H552a8 8 0 0 1 8 8v26.66a8 8 0 0 1-8 8h-34.67V152a8 8 0 0 1-8 8zM576 404a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-128a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zM200 74.67h-34.67V40a8 8 0 0 0-8-8h-26.66a8 8 0 0 0-8 8v34.67H88a8 8 0 0 0-8 8v26.66a8 8 0 0 0 8 8h34.67V152a8 8 0 0 0 8 8h26.66a8 8 0 0 0 8-8v-34.67H200a8 8 0 0 0 8-8V82.67a8 8 0 0 0-8-8z", "M256 96V32a32 32 0 0 0-32-32H64a32 32 0 0 0-32 32v64a32 32 0 0 0-32 32v352a32 32 0 0 0 32 32h224a32 32 0 0 0 32-32V128a32 32 0 0 0-32-32zM128 404a12 12 0 0 1-12 12H76a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-128a12 12 0 0 1-12 12H76a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm2.67-116a8 8 0 0 1-8-8v-34.67H88a8 8 0 0 1-8-8V82.67a8 8 0 0 1 8-8h34.67V40a8 8 0 0 1 8-8h26.66a8 8 0 0 1 8 8v34.67H200a8 8 0 0 1 8 8v26.66a8 8 0 0 1-8 8h-34.67V152a8 8 0 0 1-8 8zM224 404a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-128a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zM552 74.67h-34.67V40a8 8 0 0 0-8-8h-26.66a8 8 0 0 0-8 8v34.67H440a8 8 0 0 0-8 8v26.66a8 8 0 0 0 8 8h34.67V152a8 8 0 0 0 8 8h26.66a8 8 0 0 0 8-8v-34.67H552a8 8 0 0 0 8-8V82.67a8 8 0 0 0-8-8z"]],
    "hot-tub": [512, 512, [], "f593", ["M304 76.49c-17.37-14.17-28.82-36.75-32-62.15A16.06 16.06 0 0 0 256.23 0h-16.12c-9.51 0-17.09 8.57-16 18.35 4.34 39.11 22.4 74.53 50.13 97.16 17.36 14.17 28.82 36.75 32 62.14A16.07 16.07 0 0 0 322 192h16.12c9.51 0 17.08-8.57 16-18.35-4.38-39.11-22.44-74.53-50.12-97.16zM64 128A64 64 0 1 0 0 64a64 64 0 0 0 64 64zm398.08 45.65c-4.34-39.11-22.4-74.53-50.13-97.16-17.37-14.17-28.82-36.75-32-62.15A16.06 16.06 0 0 0 364.23 0h-16.12c-9.51 0-17.09 8.57-16 18.35 4.34 39.11 22.4 74.53 50.13 97.16 17.36 14.17 28.82 36.75 32 62.14A16.07 16.07 0 0 0 430 192h16.12c9.47 0 17.04-8.57 15.96-18.35zM106.67 160H64a64 64 0 0 0-64 64v32h256l-110.93-83.2a64 64 0 0 0-38.4-12.8z", "M480 256H0v192a64 64 0 0 0 64 64h384a64 64 0 0 0 64-64V288a32 32 0 0 0-32-32zM128 440a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8V328a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8zm96 0a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8V328a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8zm96 0a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8V328a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8zm96 0a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8V328a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8z"]],
    "hotdog": [512, 512, [], "f80f", ["M488.62 23.38a79.86 79.86 0 0 0-112.91 0L24.38 374.72a79.85 79.85 0 1 0 110.94 114.87c.67-.65 1.32-1.3 2-2l351.3-351.3a79.86 79.86 0 0 0 0-112.91zm-50 95.25c-19.6 19.59-37.52 22.67-51.93 25.14C373.74 146 364.38 147.6 352 160s-14 21.76-16.23 34.71c-2.48 14.4-5.55 32.33-25.15 51.92s-37.52 22.67-51.92 25.15c-13 2.22-22.3 3.82-34.7 16.22s-14 21.75-16.23 34.7c-2.47 14.4-5.54 32.33-25.14 51.92s-37.53 22.68-51.93 25.15C117.74 402 108.38 403.6 96 416a16 16 0 1 1-22.63-22.63c19.6-19.59 37.52-22.67 51.92-25.14 13-2.22 22.3-3.82 34.71-16.23s14-21.75 16.22-34.7c2.48-14.4 5.55-32.33 25.15-51.92s37.52-22.67 51.92-25.14c13-2.22 22.3-3.83 34.7-16.23s14-21.76 16.24-34.71c2.47-14.4 5.54-32.33 25.14-51.92s37.52-22.68 51.92-25.15c13-2.23 22.3-3.82 34.71-16.23a16 16 0 0 1 22.63 22.63z", "M310.64 19.89c-25-25-63.85-26.66-86.79-3.72L16.17 223.85c-22.94 22.94-21.27 61.79 3.72 86.78l11.55 11.55L322.18 31.44zm181.47 181.47l-11.55-11.54-290.74 290.74 11.54 11.55c25 25 63.85 26.66 86.79 3.72l207.68-207.68c22.94-22.94 21.27-61.79-3.72-86.79zM224 288c12.4-12.4 21.75-14 34.7-16.22 14.4-2.48 32.32-5.56 51.92-25.15s22.67-37.52 25.15-51.92c2.23-13 3.83-22.31 16.23-34.71s21.76-14 34.7-16.23c14.41-2.47 32.33-5.55 51.93-25.14A16 16 0 0 0 416 96c-12.41 12.41-21.76 14-34.71 16.23-14.4 2.47-32.32 5.56-51.92 25.15s-22.67 37.52-25.14 51.92C302 202.25 300.37 211.61 288 224s-21.7 14-34.7 16.23c-14.4 2.47-32.32 5.55-51.92 25.14s-22.7 37.53-25.18 51.93c-2.2 12.95-3.81 22.29-16.2 34.7s-21.71 14-34.71 16.23c-14.4 2.47-32.32 5.55-51.92 25.14A16 16 0 1 0 96 416c12.4-12.4 21.76-14 34.7-16.23 14.4-2.47 32.33-5.56 51.93-25.15s22.67-37.52 25.14-51.92c2.23-12.95 3.81-22.3 16.23-34.7z"]],
    "hotel": [576, 512, [], "f594", ["M288 288a128 128 0 0 0-128 128h256a128 128 0 0 0-128-128zm-96-44.8v-38.4c0-6.4-6.4-12.8-12.8-12.8h-38.4c-6.4 0-12.8 6.4-12.8 12.8v38.4c0 6.4 6.4 12.8 12.8 12.8h38.4c6.4 0 12.8-6.4 12.8-12.8zM140.8 160h38.4c6.4 0 12.8-6.4 12.8-12.8v-38.4c0-6.4-6.4-12.8-12.8-12.8h-38.4c-6.4 0-12.8 6.4-12.8 12.8v38.4c0 6.4 6.4 12.8 12.8 12.8zm128 96h38.4c6.4 0 12.8-6.4 12.8-12.8v-38.4c0-6.4-6.4-12.8-12.8-12.8h-38.4c-6.4 0-12.8 6.4-12.8 12.8v38.4c0 6.4 6.4 12.8 12.8 12.8zm0-96h38.4c6.4 0 12.8-6.4 12.8-12.8v-38.4c0-6.4-6.4-12.8-12.8-12.8h-38.4c-6.4 0-12.8 6.4-12.8 12.8v38.4c0 6.4 6.4 12.8 12.8 12.8zm166.4 32h-38.4c-6.4 0-12.8 6.4-12.8 12.8v38.4c0 6.4 6.4 12.8 12.8 12.8h38.4c6.4 0 12.8-6.4 12.8-12.8v-38.4c0-6.4-6.4-12.8-12.8-12.8zm0-96h-38.4c-6.4 0-12.8 6.4-12.8 12.8v38.4c0 6.4 6.4 12.8 12.8 12.8h38.4c6.4 0 12.8-6.4 12.8-12.8v-38.4c0-6.4-6.4-12.8-12.8-12.8z", "M560 64a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16H16A16 16 0 0 0 0 16v32a16 16 0 0 0 16 16h16v384H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h240v-96h-96a128 128 0 0 1 256 0h-96v96h240a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-16V64zM192 243.2c0 6.4-6.4 12.8-12.8 12.8h-38.4c-6.4 0-12.8-6.4-12.8-12.8v-38.4c0-6.4 6.4-12.8 12.8-12.8h38.4c6.4 0 12.8 6.4 12.8 12.8zm0-96c0 6.4-6.4 12.8-12.8 12.8h-38.4c-6.4 0-12.8-6.4-12.8-12.8v-38.4c0-6.4 6.4-12.8 12.8-12.8h38.4c6.4 0 12.8 6.4 12.8 12.8zm128 96c0 6.4-6.4 12.8-12.8 12.8h-38.4c-6.4 0-12.8-6.4-12.8-12.8v-38.4c0-6.4 6.4-12.8 12.8-12.8h38.4c6.4 0 12.8 6.4 12.8 12.8zm0-96c0 6.4-6.4 12.8-12.8 12.8h-38.4c-6.4 0-12.8-6.4-12.8-12.8v-38.4c0-6.4 6.4-12.8 12.8-12.8h38.4c6.4 0 12.8 6.4 12.8 12.8zm128 96c0 6.4-6.4 12.8-12.8 12.8h-38.4c-6.4 0-12.8-6.4-12.8-12.8v-38.4c0-6.4 6.4-12.8 12.8-12.8h38.4c6.4 0 12.8 6.4 12.8 12.8zm0-96c0 6.4-6.4 12.8-12.8 12.8h-38.4c-6.4 0-12.8-6.4-12.8-12.8v-38.4c0-6.4 6.4-12.8 12.8-12.8h38.4c6.4 0 12.8 6.4 12.8 12.8z"]],
    "hourglass": [384, 512, [], "f254", ["M192 304c-57.8 0-104 66.54-104 144h208c0-77.48-46.21-144-104-144zm0-96c57.8 0 104-66.54 104-144H88c0 77.48 46.21 144 104 144z", "M360 64a24 24 0 0 0 24-24V24a24 24 0 0 0-24-24H24A24 24 0 0 0 0 24v16a24 24 0 0 0 24 24c0 91 51 167.73 120.84 192C75 280.27 24 357 24 448a24 24 0 0 0-24 24v16a24 24 0 0 0 24 24h336a24 24 0 0 0 24-24v-16a24 24 0 0 0-24-24c0-91-51-167.73-120.84-192C309 231.73 360 155 360 64zm-64 384H88c0-77.46 46.2-144 104-144s104 66.52 104 144zM192 208c-57.79 0-104-66.52-104-144h208c0 77.46-46.2 144-104 144z"]],
    "hourglass-end": [384, 512, [], "f253", ["M296 448H88c0-77.46 46.2-144 104-144s104 66.52 104 144z", "M24 448a24 24 0 0 0-24 24v16a24 24 0 0 0 24 24h336a24 24 0 0 0 24-24v-16a24 24 0 0 0-24-24c0-91-51-167.73-120.84-192C309 231.73 360 155 360 64a24 24 0 0 0 24-24V24a24 24 0 0 0-24-24H24A24 24 0 0 0 0 24v16a24 24 0 0 0 24 24c0 91 51 167.73 120.84 192C75 280.27 24 357 24 448zM88 64h208c0 77.46-46.2 144-104 144S88 141.48 88 64zm104 240c57.79 0 104 66.52 104 144H88c0-77.46 46.2-144 104-144z"]],
    "hourglass-half": [384, 512, [], "f252", ["M284.92 384H99.06A187.69 187.69 0 0 0 88 448h208a187.6 187.6 0 0 0-11.08-64zM192 208c40.83 0 75.86-33.2 92.92-80H99.08c17.06 46.8 52.1 80 92.92 80z", "M360 64a24 24 0 0 0 24-24V24a24 24 0 0 0-24-24H24A24 24 0 0 0 0 24v16a24 24 0 0 0 24 24c0 91 51 167.73 120.84 192C75 280.27 24 357 24 448a24 24 0 0 0-24 24v16a24 24 0 0 0 24 24h336a24 24 0 0 0 24-24v-16a24 24 0 0 0-24-24c0-91-51-167.73-120.84-192C309 231.73 360 155 360 64zm-64 384H88c0-77.46 46.2-144 104-144s104 66.52 104 144zM192 208c-57.79 0-104-66.52-104-144h208c0 77.46-46.2 144-104 144z"]],
    "hourglass-start": [384, 512, [], "f251", ["M296 64c0 77.46-46.2 144-104 144S88 141.48 88 64z", "M360 64a24 24 0 0 0 24-24V24a24 24 0 0 0-24-24H24A24 24 0 0 0 0 24v16a24 24 0 0 0 24 24c0 91 51 167.73 120.84 192C75 280.27 24 357 24 448a24 24 0 0 0-24 24v16a24 24 0 0 0 24 24h336a24 24 0 0 0 24-24v-16a24 24 0 0 0-24-24c0-91-51-167.73-120.84-192C309 231.73 360 155 360 64zm-64 384H88c0-77.46 46.2-144 104-144s104 66.52 104 144zM192 208c-57.79 0-104-66.52-104-144h208c0 77.46-46.2 144-104 144z"]],
    "house-damage": [576, 512, [], "f6f1", ["M512 311.08V496a16 16 0 0 1-16 16H319.82l-39.92-55.26 104.11-64L236 256l60.11 119.2L192 439.18 229.24 512H80a16 16 0 0 1-16-16V311c1.78-1.21 3.85-1.89 5.47-3.35L288 115l218.74 192.9c1.55 1.36 3.57 2.02 5.26 3.18z", "M236 256l60.11 119.2L192 439.18 229.24 512h90.58l-39.92-55.26 104.11-64zm334.7-19.74L512 184.43V48a16 16 0 0 0-16-16h-64a16 16 0 0 0-16 16v51.67L314.76 10.29a39.85 39.85 0 0 0-53.45 0l-256 226a16 16 0 0 0-1.21 22.59l21.41 23.79a16 16 0 0 0 22.59 1.21L277.43 81.61a16 16 0 0 1 21.17 0l229.32 202.27a16 16 0 0 0 22.6-1.2l21.4-23.82a16 16 0 0 0-1.22-22.6z"]],
    "house-flood": [576, 512, [], "f74f", ["M287.94 114.85L96.29 285v99.4c.5 0 .89-.1 1.39-.1A64 64 0 0 1 139 399c12.77 10.6 32.23 16.7 53.38 16.7 20.36 0 39-5.6 51.39-15.4a73.57 73.57 0 0 1 45.4-16.1 64.13 64.13 0 0 1 41.5 14.8c12.78 10.6 32.23 16.7 53.39 16.7 20.15 0 39.41-5.8 51.58-15.6a70 70 0 0 1 43.8-15.4h.1v-99.8zm47.91 125.25v64a16 16 0 0 1-16 16H256a16 16 0 0 1-16-16v-64a16 16 0 0 1 16-16h63.91a16 16 0 0 1 15.91 16z", "M562.2 447.88c-21.51-2.4-42.11-10.51-57.91-22.92a38.76 38.76 0 0 0-48.21 0c-37.91 30.43-107.22 30.43-145.73-1.5-13.5-11.2-33-9.11-46.7 1.8-38 30.13-106.92 30-145.23-1.7-13.5-11.21-33.31-8.91-47.11 2-15.5 12.21-36 20.12-57.71 22.42-7.9.8-13.6 7.81-13.6 15.72v32.22c0 9.1 7.6 16.8 16.7 16 28.81-2.5 56.11-11.41 79.42-25.92 56.48 34.63 137 34.13 192 0 56.48 34.63 137 34.13 192 0a184.87 184.87 0 0 0 79.12 25.83c9.1.81 16.7-6.89 16.7-16V464.2c.06-8.01-5.7-15.42-13.74-16.32zM22 244.05l21.15 24a16 16 0 0 0 22.5 1.45l.05-.05 222.24-197.3 222.31 197.3a16 16 0 0 0 22.55-1.4l21.15-24a16.11 16.11 0 0 0-1.38-22.6v.05l-73-64.8V48.05a16 16 0 0 0-16-16h-31.93a16 16 0 0 0-16 16v52l-101.24-90a39.67 39.67 0 0 0-52.78 0L23.35 221.45A16 16 0 0 0 21.94 244z"]],
    "hryvnia": [384, 512, [], "f6f2", ["M0 224v-32a16 16 0 0 1 16-16h205.38L156 240H16a16 16 0 0 1-16-16zm77.91 92.38L123.27 272H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h46.56a94.82 94.82 0 0 1 15.35-19.62zM368 272H228l-65.4 64H368a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-96h-46.56a94.78 94.78 0 0 1-15.34 19.61L260.74 240H368a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M323.32 84.26c20.07 36.58 12.6 82.17-17.22 111.35L134.81 363.22A21.21 21.21 0 0 0 149.2 400h83.63a24 24 0 0 0 15.36-5.56l11.75-9.8a24 24 0 0 1 33.81 3.07l20.49 24.59a24 24 0 0 1-3.07 33.8l-11.77 9.81A104 104 0 0 1 232.86 480H154c-37.14 0-73.38-17.85-92-49.95-.45-.77-.88-1.54-1.31-2.31-20.07-36.58-12.6-82.18 17.23-111.35l171.28-167.6A21.21 21.21 0 0 0 234.8 112h-83.62a24 24 0 0 0-15.39 5.57l-11.73 9.78a24 24 0 0 1-33.81-3.07L69.76 99.7a24 24 0 0 1 3.07-33.8l11.77-9.81A104 104 0 0 1 151.14 32H230c37.14 0 73.38 17.84 92 50 .46.72.89 1.49 1.32 2.26z"]],
    "humidity": [384, 512, [], "f750", ["M223.9 22.09c-8.7-28.8-53.9-30.1-63.8 0C109.1 179.79 0 222.69 0 333.9 0 432.3 85.9 512 192 512s192-79.7 192-178.1c0-111.71-108.9-153.31-160.1-311.81zM96 288a32 32 0 1 1 32 32 32 32 0 0 1-32-32zm49.5 131.8a7.87 7.87 0 0 1-11.2 1.2l-12.5-10a8 8 0 0 1-1.2-11.2l118-147.51a8 8 0 0 1 11.2-1.2l12.5 10a7.87 7.87 0 0 1 1.2 11.2zM256 416a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M128 256a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm128 96a32 32 0 1 0 32 32 32 32 0 0 0-32-32z"]],
    "hurricane": [384, 512, [], "f751", ["M176 96l24.5-74.79A16.22 16.22 0 0 0 183.1.12C80 12.42 0 101.61 0 208c0 114.9 93.1 208 208 208l-24.5 74.79a16.24 16.24 0 0 0 17.4 21.1C304 499.58 384 410.39 384 304c0-114.9-93.1-208-208-208zm16 256a96 96 0 1 1 96-96 96 96 0 0 1-96 96z", "M236 256a44 44 0 1 1-44-44 44 44 0 0 1 44 44z"]],
    "i-cursor": [256, 512, [], "f246", ["M32 236v40a12 12 0 0 0 12 12h52v-64H43.91A12 12 0 0 0 32 236zm180.09-12H160v64h52a12 12 0 0 0 12-12v-40a12 12 0 0 0-11.91-12z", "M160 400c0 44.94 57.89 48.55 83.85 48.24A12 12 0 0 1 256 460.08v39.8a12 12 0 0 1-11.91 12c-35.09.23-78.36-.62-116.09-37.88-38.47 38-83.62 38.34-116.16 37.93a12 12 0 0 1-11.84-12V460a12 12 0 0 1 12-12h.05c27.87 0 84-3.07 84-48V112.18c0-44.94-57.89-48.73-83.85-48.42A12 12 0 0 1 0 51.91v-39.8a12 12 0 0 1 11.91-12C47-.11 90.27.74 128 38 166.47 0 211.62-.34 244.16.07a12 12 0 0 1 11.84 12v40A12 12 0 0 1 244 64c-27.92 0-84 3.25-84 48.18z"]],
    "ice-cream": [448, 512, [], "f810", ["M367.94,256.19H80.06a48,48,0,0,1-4.16-95.92c1.39-.06,2.77-.06,4.16,0H81a143.94,143.94,0,1,1,286,0h.94a48,48,0,0,1,4.16,95.92c-1.39.06-2.77.06-4.16,0Z", "M195.39,493.69,96.05,288.17H352L252.61,493.69a31.52,31.52,0,0,1-57.22,0Z"]],
    "ice-skate": [576, 512, [], "f7ac", ["M568 416h-32a8 8 0 0 0-8 8v16a23.94 23.94 0 0 1-24 24h-72v-48h-48v48H144v-48H96v48H8a8 8 0 0 0-8 8v32a8 8 0 0 0 8 8h504a64.06 64.06 0 0 0 64-64v-24a8 8 0 0 0-8-8zM264 192h56v-32h-56a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8zm0-64h56V96h-56a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8z", "M78.4 82.7L256 32V16a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v80h-56a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h56v32h-56a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h56l119.3 29.9A96 96 0 0 1 512 315v37a32 32 0 0 1-32 32H64a32 32 0 0 1-32-32V144.2a64 64 0 0 1 46.4-61.5z"]],
    "icicles": [512, 512, [], "f7ad", ["M511.36 37.9l-87.5 467.7c-1.7 8.6-14 8.6-15.7 0l-66.7-363.8-45.8 172.5a8 8 0 0 1-15.3 0l-34.1-133.4-46.5 196.9c-1.9 8.3-13.7 8.3-15.6 0L140 190.5l-36.4 124.1c-2.4 7.2-12.6 7.2-15.1 0L1.36 41.2A32 32 0 0 1 32 0h448a32 32 0 0 1 31.95 32.05 32.83 32.83 0 0 1-.55 5.85z", "M480 0H353.41a32 32 0 0 0-31.47 37.8l86.22 467.8c1.7 8.6 14 8.6 15.7 0l87.5-467.7a32.83 32.83 0 0 0 .55-5.85A32 32 0 0 0 480 0z"]],
    "icons": [512, 512, [], "f86d", ["M137.86 22.44L128 32.58l-9.85-10.14C93.05-3.5 52.25-7.7 24.86 15.64c-31.41 26.78-33 74.85-5 103.88l96.75 99.83a15.68 15.68 0 0 0 22.65 0l96.75-99.83c28.14-29 26.5-77.1-4.91-103.88C203.75-7.7 163-3.5 137.86 22.44zM499.4 352.1h-60.58l22.36-50.75c2.1-6.65-3.94-13.21-12.18-13.21h-75.6c-6.3 0-11.65 3.9-12.49 9.1l-16.8 106.93c-1 6.3 4.88 11.89 12.49 11.89h62.32l-24.2 83c-1.89 6.65 4.2 12.9 12.23 12.9a13.26 13.26 0 0 0 10.92-5.25l92.4-138.91c4.88-6.91-1.16-15.7-10.87-15.7z", "M260.57 319.84h-48l-7.08-14.24a27.39 27.39 0 0 0-25.66-17.78h-71.71a27.39 27.39 0 0 0-25.66 17.78l-7 14.24h-48A27.45 27.45 0 0 0 0 347.3v137.25A27.45 27.45 0 0 0 27.43 512h233.14A27.45 27.45 0 0 0 288 484.55V347.3a27.45 27.45 0 0 0-27.43-27.46zM144 468a52 52 0 1 1 52-52 52 52 0 0 1-52 52zM478.08.33L329.51 23.17C314.87 25.42 304 38.92 304 54.83V161.6a83.25 83.25 0 0 0-16-1.7c-35.35 0-64 21.48-64 48s28.65 48 64 48c35.2 0 63.73-21.32 64-47.66V99.66l112-17.22v47.18a83.25 83.25 0 0 0-16-1.7c-35.35 0-64 21.48-64 48s28.65 48 64 48c35.2 0 63.73-21.32 64-47.66V32c0-19.48-16-34.42-33.92-31.67z"]],
    "icons-alt": [512, 512, [], "f86e", ["M208 96H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h64v48a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-48h64a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-96H16A16 16 0 0 0 0 16v32a16 16 0 0 0 16 16h192a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16zm120 368a40 40 0 1 0-40-40 40 40 0 0 0 40 40zm179.31-52.69l-22.62-22.62a16 16 0 0 0-22.63 0L292.69 462.06a16 16 0 0 0 0 22.63l22.62 22.62a16 16 0 0 0 22.63 0l169.37-169.37a16 16 0 0 0 0-22.63zM472 432a40 40 0 1 0 40 40 40 40 0 0 0-40-40z", "M478.08.33L329.51 23.18C314.87 25.44 304 38.94 304 54.86V161.7a83.25 83.25 0 0 0-16-1.7c-35.35 0-64 21.49-64 48s28.65 48 64 48c35.2 0 63.73-21.33 64-47.69V99.73L464 82.5v47.2a83.25 83.25 0 0 0-16-1.7c-35.35 0-64 21.49-64 48s28.65 48 64 48c35.2 0 63.73-21.33 64-47.69V32c0-19.47-16-34.43-33.92-31.67zM219.59 383.94L197 361.31a16 16 0 0 0-22.63 0l-27.92 27.89-22.7-22.7a64 64 0 1 0-90.7-3.3l-6.92 6.92c-29.59 29.59-35.69 77.63-9.81 110.52A81.31 81.31 0 0 0 138 488.19l8.48-8.49 27.61 27.61a16 16 0 0 0 22.63 0l22.62-22.62a16 16 0 0 0 0-22.63l-27.64-27.61 27.89-27.89a16 16 0 0 0 0-22.62zM80 304a16 16 0 1 1-16 16 16 16 0 0 1 16-16zm12.72 138.94a17.29 17.29 0 1 1-24.45-24.46l8.48-8.48 24.45 24.45z"]],
    "id-badge": [384, 512, [], "f2c1", ["M336 0H48A48 48 0 0 0 0 48v416a48 48 0 0 0 48 48h288a48 48 0 0 0 48-48V48a48 48 0 0 0-48-48zM144 32h96a16 16 0 0 1 0 32h-96a16 16 0 0 1 0-32zm48 128a64 64 0 1 1-64 64 64.06 64.06 0 0 1 64-64zm112 236.8c0 10.6-10 19.2-22.4 19.2H102.4C90 416 80 407.4 80 396.8v-19.2c0-31.8 30.1-57.6 67.2-57.6h5a103 103 0 0 0 79.6 0h5c37.1 0 67.2 25.8 67.2 57.6z", "M192 288a64 64 0 1 0-64-64 64.06 64.06 0 0 0 64 64zm44.8 32h-5a103 103 0 0 1-79.6 0h-5c-37.1 0-67.2 25.8-67.2 57.6v19.2c0 10.6 10 19.2 22.4 19.2h179.2c12.4 0 22.4-8.6 22.4-19.2v-19.2c0-31.8-30.1-57.6-67.2-57.6z"]],
    "id-card": [576, 512, [], "f2c2", ["M0 128v304a48 48 0 0 0 48 48h480a48 48 0 0 0 48-48V128zm176 64a64 64 0 1 1-64 64 64 64 0 0 1 64-64zm93.3 224H82.7c-10.4 0-18.8-10-15.6-19.8A64.09 64.09 0 0 1 128 352h8.2a103 103 0 0 0 79.6 0h8.2a64.09 64.09 0 0 1 60.9 44.2c3.2 9.9-5.2 19.8-15.6 19.8zM512 344a8 8 0 0 1-8 8H360a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h144a8 8 0 0 1 8 8zm0-64a8 8 0 0 1-8 8H360a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h144a8 8 0 0 1 8 8zm0-64a8 8 0 0 1-8 8H360a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h144a8 8 0 0 1 8 8z", "M224 352h-8.2a103 103 0 0 1-79.6 0H128a64.09 64.09 0 0 0-60.9 44.2C63.9 406 72.3 416 82.7 416h186.6c10.4 0 18.8-9.9 15.6-19.8A64.09 64.09 0 0 0 224 352zM528 32H48A48 48 0 0 0 0 80v48h576V80a48 48 0 0 0-48-48zM176 320a64 64 0 1 0-64-64 64 64 0 0 0 64 64z"]],
    "id-card-alt": [576, 512, [], "f47f", ["M528 64H352v64h16a16 16 0 0 1 0 32H208a16 16 0 0 1 0-32h16V64H48a48 48 0 0 0-48 48v352a48 48 0 0 0 48 48h480a48 48 0 0 0 48-48V112a48 48 0 0 0-48-48zM288 224a64 64 0 1 1-64 64 64 64 0 0 1 64-64zm93.3 224H194.7c-10.4 0-18.8-10-15.6-19.8A64 64 0 0 1 240 384h8.2a103 103 0 0 0 79.6 0h8.2a64.09 64.09 0 0 1 60.9 44.2c3.2 9.8-5.2 19.8-15.6 19.8z", "M352 32a32 32 0 0 0-32-32h-64a32 32 0 0 0-32 32v96h128zm-64 320a64 64 0 1 0-64-64 64 64 0 0 0 64 64zm108.9 76.2A64.09 64.09 0 0 0 336 384h-8.2a103 103 0 0 1-79.6 0H240a64 64 0 0 0-60.9 44.2c-3.2 9.8 5.2 19.8 15.6 19.8h186.6c10.4 0 18.8-10 15.6-19.8z"]],
    "igloo": [576, 512, [], "f7ae", ["M384 384v96H192v-96a96 96 0 0 1 192 0z", "M320 33.9a282 282 0 0 0-32-1.9A287.48 287.48 0 0 0 48.6 160H320zM96 192H30.3A286.63 286.63 0 0 0 0 320h96zM352 39.4V160h175.4A287.83 287.83 0 0 0 352 39.4zM480 320h96a286.63 286.63 0 0 0-30.3-128H480zm-64 64v96h128a32 32 0 0 0 32-32v-96H411.5c2.6 10.3 4.5 20.9 4.5 32zm32-192H128v128h49.8c22.2-38.1 63-64 110.2-64s88 25.9 110.2 64H448zM0 448a32 32 0 0 0 32 32h128v-96c0-11.1 1.9-21.7 4.5-32H0z"]],
    "image": [512, 512, [], "f03e", ["M448 384H64v-48l71.51-71.52a12 12 0 0 1 17 0L208 320l135.51-135.52a12 12 0 0 1 17 0L448 272z", "M464 64H48a48 48 0 0 0-48 48v288a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V112a48 48 0 0 0-48-48zm-352 56a56 56 0 1 1-56 56 56 56 0 0 1 56-56zm336 264H64v-48l71.51-71.52a12 12 0 0 1 17 0L208 320l135.51-135.52a12 12 0 0 1 17 0L448 272z"]],
    "image-polaroid": [448, 512, [], "f8c4", ["M416 32H32A32 32 0 0 0 0 64v384a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32V64a32 32 0 0 0-32-32zm-32 320H64V96h320z", "M64 96v256h320V96zm64 32a32 32 0 1 1-32 32 32 32 0 0 1 32-32zM96 320l50.69-76a16 16 0 0 1 26.62 0l20.57 30.85 49.32-65.75a16 16 0 0 1 25.6 0L352 320z"]],
    "images": [576, 512, [], "f302", ["M424.49 120.48a12 12 0 0 0-17 0L272 256l-39.51-39.52a12 12 0 0 0-17 0L160 272v48h352V208zM64 336V128H48a48 48 0 0 0-48 48v256a48 48 0 0 0 48 48h384a48 48 0 0 0 48-48v-16H144a80.09 80.09 0 0 1-80-80z", "M528 32H144a48 48 0 0 0-48 48v256a48 48 0 0 0 48 48h384a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zM208 80a48 48 0 1 1-48 48 48 48 0 0 1 48-48zm304 240H160v-48l55.52-55.52a12 12 0 0 1 17 0L272 256l135.52-135.52a12 12 0 0 1 17 0L512 208z"]],
    "inbox": [576, 512, [], "f01c", ["M376 256l-32 64H232l-32-64H76.92l85.33-128h251.5l85.33 128z", "M567.94 243.91L462.25 85.37A48 48 0 0 0 422.31 64H153.69a48 48 0 0 0-39.94 21.37L8.06 243.91A48 48 0 0 0 0 270.53V400a48 48 0 0 0 48 48h480a48 48 0 0 0 48-48V270.53a48 48 0 0 0-8.06-26.62zM376 256l-32 64H232l-32-64H76.92l85.33-128h251.5l85.33 128z"]],
    "inbox-in": [576, 512, [], "f310", ["M528 512H48a48 48 0 0 1-48-48v-95.2a47.29 47.29 0 0 1 10.7-30l94.4-118a12 12 0 0 1 18.1-.7l27.6 29.5a12 12 0 0 1 .6 15.7L107.6 320H200l32 64h112l32-64h92.3L424 264.6a12.16 12.16 0 0 1 .8-15.9l28.1-28.9a12.12 12.12 0 0 1 18 .9l94.6 118.2a47.77 47.77 0 0 1 10.5 29.9V464a48 48 0 0 1-48 48z", "M171.5 160h61.9V17.1A17.16 17.16 0 0 1 250.5 0h68.6a17.09 17.09 0 0 1 17.1 17.1V160h68.3c17.8 0 26.7 21.5 14.1 34.1l-119.4 120a20 20 0 0 1-28.6-.3L157 193.8c-12.1-12.7-3.1-33.8 14.5-33.8z"]],
    "inbox-out": [576, 512, [], "f311", ["M565.6 338.89a48.27 48.27 0 0 1 10.4 29.9V464a48 48 0 0 1-48 48H48a48 48 0 0 1-48-48v-95.2a48.05 48.05 0 0 1 10.5-30l94.4-118a12 12 0 0 1 18.1-.7l27.6 29.5a12 12 0 0 1 .6 15.7L107.6 320H200l32 64h112l32-64h92.4l-44.3-55.4a11.94 11.94 0 0 1 .8-15.9l28.1-28.9a12 12 0 0 1 18 .9z", "M239.7 302.89V160h-68.3c-17.8 0-26.7-21.5-14.1-34.1l119.4-120a20 20 0 0 1 28.6.3l113.7 120c12.1 12.7 3.1 33.8-14.5 33.8h-61.9v142.9a17.18 17.18 0 0 1-17.2 17.1h-68.6a17.09 17.09 0 0 1-17.1-17.11z"]],
    "indent": [448, 512, [], "f03c", ["M432 416H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm3.17-128H204.83A12.82 12.82 0 0 0 192 300.83v38.34A12.82 12.82 0 0 0 204.83 352h230.34A12.82 12.82 0 0 0 448 339.17v-38.34A12.82 12.82 0 0 0 435.17 288zm0-128H204.83A12.82 12.82 0 0 0 192 172.83v38.34A12.82 12.82 0 0 0 204.83 224h230.34A12.82 12.82 0 0 0 448 211.17v-38.34A12.82 12.82 0 0 0 435.17 160zM432 32H16A16 16 0 0 0 0 48v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z", "M27.31 363.3l96-96a16 16 0 0 0 0-22.62l-96-96C17.27 138.66 0 145.78 0 160v192c0 14.31 17.33 21.3 27.31 11.3z"]],
    "industry": [512, 512, [], "f275", ["M512 184v272a24 24 0 0 1-24 24H136a24 24 0 0 0 24-24V252.31l139.12-88.53A24 24 0 0 1 336 184v68.28l139.12-88.53A24 24 0 0 1 512 184z", "M136 480H24a24 24 0 0 1-24-24V56a24 24 0 0 1 24-24h112a24 24 0 0 1 24 24v400a24 24 0 0 1-24 24z"]],
    "industry-alt": [512, 512, [], "f3b3", ["M148 320h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm128 0h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm128 0h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12z", "M475.12 163.78L336 252.31V184a24 24 0 0 0-36.88-20.25L160 252.31V56a24 24 0 0 0-24-24H24A24 24 0 0 0 0 56v400a24 24 0 0 0 24 24h464a24 24 0 0 0 24-24V184a24 24 0 0 0-36.88-20.22zM160 372a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm128 0a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm128 0a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12z"]],
    "infinity": [640, 512, [], "f534", ["M471.1 96C405 96 353.3 137.3 320 174.6 286.7 137.3 235 96 168.9 96 75.8 96 0 167.8 0 256s75.8 160 168.9 160c66.1 0 117.8-41.3 151.1-78.6 33.3 37.3 85 78.6 151.1 78.6 93.1 0 168.9-71.8 168.9-160S564.2 96 471.1 96zM168.9 320c-40.2 0-72.9-28.7-72.9-64s32.7-64 72.9-64c38.2 0 73.4 36.1 94 64-20.4 27.6-55.9 64-94 64zm302.2 0c-38.2 0-73.4-36.1-94-64 20.4-27.6 55.9-64 94-64 40.2 0 72.9 28.7 72.9 64s-32.7 64-72.9 64z", ""]],
    "info": [192, 512, [], "f129", ["M20 448h152a20 20 0 0 1 20 20v24a20 20 0 0 1-20 20H20a20 20 0 0 1-20-20v-24a20 20 0 0 1 20-20z", "M96 128a64 64 0 1 0-64-64 64 64 0 0 0 64 64zm28 64H20a20 20 0 0 0-20 20v24a20 20 0 0 0 20 20h28v192h96V212a20 20 0 0 0-20-20z"]],
    "info-circle": [512, 512, [], "f05a", ["M256 8C119 8 8 119.08 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm0 110a42 42 0 1 1-42 42 42 42 0 0 1 42-42zm56 254a12 12 0 0 1-12 12h-88a12 12 0 0 1-12-12v-24a12 12 0 0 1 12-12h12v-64h-12a12 12 0 0 1-12-12v-24a12 12 0 0 1 12-12h64a12 12 0 0 1 12 12v100h12a12 12 0 0 1 12 12z", "M256 202a42 42 0 1 0-42-42 42 42 0 0 0 42 42zm44 134h-12V236a12 12 0 0 0-12-12h-64a12 12 0 0 0-12 12v24a12 12 0 0 0 12 12h12v64h-12a12 12 0 0 0-12 12v24a12 12 0 0 0 12 12h88a12 12 0 0 0 12-12v-24a12 12 0 0 0-12-12z"]],
    "info-square": [448, 512, [], "f30f", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-176 86a42 42 0 1 1-42 42 42 42 0 0 1 42-42zm56 254a12 12 0 0 1-12 12h-88a12 12 0 0 1-12-12v-24a12 12 0 0 1 12-12h12v-64h-12a12 12 0 0 1-12-12v-24a12 12 0 0 1 12-12h64a12 12 0 0 1 12 12v100h12a12 12 0 0 1 12 12z", "M224 202a42 42 0 1 0-42-42 42 42 0 0 0 42 42zm44 134h-12V236a12 12 0 0 0-12-12h-64a12 12 0 0 0-12 12v24a12 12 0 0 0 12 12h12v64h-12a12 12 0 0 0-12 12v24a12 12 0 0 0 12 12h88a12 12 0 0 0 12-12v-24a12 12 0 0 0-12-12z"]],
    "inhaler": [640, 512, [], "f5f9", ["M32 448a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm96-144a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm-96-48a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm0 96a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm96 48a32 32 0 1 0 32 32 32 32 0 0 0-32-32zM616.27 38L478.47 1.1a32 32 0 0 0-39.19 22.63l-15.41 57.52L592.61 250 638.9 77.21A32 32 0 0 0 616.27 38z", "M586.15 288.78a32 32 0 0 1 8.33 30.75l-44.22 168.59a32 32 0 0 1-31 23.88H224a32 32 0 0 1-32-32V288a32 32 0 0 1 32-32h122.49l35.91-136.92a16 16 0 0 1 26.79-7.26z"]],
    "integral": [384, 512, [], "f667", ["M377.21 73a32.71 32.71 0 0 1-4.84 45l-24.18 20a30.29 30.29 0 0 1-43.52-5l-28-36.2-79.2 339.11C186.5 485 141.92 517.8 92.1 511.13c-25.36-3.39-47.91-18.58-63.89-39.21L6.79 444.27a32.73 32.73 0 0 1 4.82-45l24.17-20a30.3 30.3 0 0 1 43.53 5l24 30.91 78.11-334.36C190.54 40 221.86 6.41 262.05.89c33.82-4.64 66.38 9.09 87.16 36z", ""]],
    "intersection": [384, 512, [], "f668", ["M384 224v240a16 16 0 0 1-16 16h-64a16 16 0 0 1-16-16V227.79c0-46.43-31.29-89.08-76.87-97.93A96.16 96.16 0 0 0 96 224v240a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16V230.68C0 133.11 70 46 166.74 33.62 283.83 18.6 384 109.82 384 224z", ""]],
    "inventory": [640, 512, [], "f480", ["M624 0h-32a16 16 0 0 0-16 16v144H64V16A16 16 0 0 0 48 0H16A16 16 0 0 0 0 16v496h64v-32h512v32h64V16a16 16 0 0 0-16-16zm-48 416H64V224h512z", "M208 256h-96a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16v-96a16 16 0 0 0-16-16zM464 0h-96a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16zm-96 256h-96a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16v-96a16 16 0 0 0-16-16z"]],
    "island-tropical": [448, 512, [], "f811", ["M284.91 358.8a144 144 0 0 0-43.71-6.8h-45.07c10-42.85 25-122.77 21-202.33L238.89 128h27.39c11.16 48 28.58 142.41 18.63 230.8z", "M241.2 352h-98.4A144 144 0 0 0 .36 474.78C-2.53 494.3 12.39 512 32.12 512h319.76c19.73 0 34.65-17.7 31.76-37.22A144 144 0 0 0 241.2 352zm206.62-238.36C439.69 67.43 393 32 336.53 32c-34.88 0-65.66 13.82-86.3 35.08C235.78 28.29 193.72 0 143.47 0 87 0 40.31 35.43 32.18 81.64a12.37 12.37 0 0 0 10.24 14.2 12.24 12.24 0 0 0 2.18.16H80l16-32 16 32h30.17c-34.21 35-39.62 86.88-14.54 122.58 4.36 6.2 13.14 7.31 18.5 1.95L238.89 128H368l16-32 16 32h35.4a12.38 12.38 0 0 0 12.6-12.18 12.24 12.24 0 0 0-.18-2.18z"]],
    "italic": [320, 512, [], "f033", ["M208 416H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h192a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm96-384H112a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h192a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z", "M158.75 96h82.5l-80 320h-82.5z"]],
    "jack-o-lantern": [576, 512, [], "f30e", ["M495.3 153.12c-27-23.08-65.36-29.75-99.49-20.92 6.09 5.5 12.16 11 17.19 17.8 3.1 4.26 5.46 9.42 8.15 14.17C389.39 140.54 345.54 128 288 128s-101.39 12.54-133.15 36.17c2.69-4.75 5-9.91 8.15-14.17 5-6.79 11.1-12.29 17.19-17.8-34.13-8.83-72.49-2.16-99.49 20.92-107.6 92-107.6 241.73 0 333.75 38.63 33 100.82 33.34 140.12 1.25C238.65 503.51 260.72 512 288 512s49.35-8.49 67.19-23.88c39.3 32.09 101.49 31.78 140.12-1.25 107.59-92.01 107.59-241.73-.01-333.75zM320.85 278L362 211.33c2.33-4.57 8.6-4.42 12 0L415.15 278c1.66 3.25.9 10-6 10h-82.29c-6.86 0-7.7-6.69-6.01-10zm-160 0L202 211.33c2.33-4.57 8.6-4.42 12 0L255.15 278c1.66 3.25.9 10-6 10h-82.29c-6.86 0-7.7-6.69-6.01-10zm309 67.6c-6 17-12.75 28.61-18.7 37-9.38 12.94-21.34 23.8-35.19 33A15.94 15.94 0 0 0 400 400h-16a16 16 0 0 0-16 16v21.48c-23.46 6.88-50.16 10.52-80 10.52s-56.56-3.65-80-10.51V416a16 16 0 0 0-16-16h-16a16 16 0 0 0-15.92 15.62c-13.71-9.08-25.53-19.78-34.75-32.5a146.4 146.4 0 0 1-19-37.46c-4.87-13.89 10.56-26.15 23.24-18.67A308.41 308.41 0 0 0 240 365.83V384a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16v-14.26c58.38 0 112.72-15.74 158.54-42.79 12.68-7.49 28.11 4.76 23.26 18.65z", "M326.86 288h82.29c6.9 0 7.66-6.75 6-10L374 211.33c-3.4-4.42-9.67-4.57-12 0L320.85 278c-1.69 3.31-.85 10 6.01 10zm-160 0h82.29c6.9 0 7.66-6.75 6-10L214 211.33c-3.4-4.42-9.67-4.57-12 0L160.85 278c-1.69 3.31-.85 10 6.01 10zm279.7 39C400.74 354 346.4 369.74 288 369.74V384a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-18.17A308.41 308.41 0 0 1 129.53 327c-12.68-7.48-28.11 4.78-23.24 18.67a146.4 146.4 0 0 0 19 37.46c9.22 12.72 21 23.42 34.75 32.5A16 16 0 0 1 176 400h16a16 16 0 0 1 16 16v21.49c23.46 6.86 50.17 10.51 80 10.51s56.52-3.64 80-10.52V416a16 16 0 0 1 16-16h16a15.94 15.94 0 0 1 15.91 15.54c13.85-9.18 25.81-20 35.19-33 5.95-8.35 12.74-19.92 18.7-37 4.85-13.83-10.58-26.08-23.24-18.54zM352 106.6V35.81a16 16 0 0 0-8.84-14.31l-39.6-19.8a16 16 0 0 0-22 8.37l-36.06 90.15A214 214 0 0 1 288 96a189.94 189.94 0 0 1 64 10.6z"]],
    "jedi": [544, 512, [], "f669", ["M210.69 285.7a8 8 0 0 1 11.36-10.7l30.39 20.66L264 7.67a8 8 0 0 1 16 0l11.53 287.93 30.35-20.6a8 8 0 0 1 11.38 10.71l-20.13 33.77 42.07 8.73a8 8 0 0 1 0 15.66l-42.07 8.72 20.11 33.73a8 8 0 0 1-1.34 9.92 8.24 8.24 0 0 1-10 .8l-27.17-18.47 2.27 63.31a123.4 123.4 0 0 1-22.07 1.95h-6.37a123.38 123.38 0 0 1-21.62-1.95l2.29-63.35L222.06 397a8.34 8.34 0 0 1-10-.75 8 8 0 0 1-1.39-9.94l20.13-33.77-42.07-8.72a8 8 0 0 1 0-15.66l42.07-8.73z", "M543 224c.37 5.76 1 11.46 1 17.27a269.51 269.51 0 0 1-5.13 51.86L480 352h40c-42.63 94.17-137.64 160-248 160q-6.39 0-12.85-.29C155.15 506.94 65.27 442.23 24 352h39.93l-58.6-58.6A263 263 0 0 1 .22 254a272.2 272.2 0 0 1 .5-30h47.21L6.55 182.62a269.74 269.74 0 0 1 108-162.07 16 16 0 0 1 9.27-3 16.35 16.35 0 0 1 13.48 7.25 16 16 0 0 1 1.62 15.09 138.38 138.38 0 0 0-9.84 51.26c0 45.12 21 86.58 57.71 113.74a16.3 16.3 0 0 1 1.21 25.39c-26.55 24-41.17 56.5-41.17 91.58a123.26 123.26 0 0 0 19.76 67.06c22.25 34.48 60.92 54.83 102 54.9h6.37c48.67.09 93.33-28.39 112.38-73.18a119.78 119.78 0 0 0 7.22-23.28A123.5 123.5 0 0 0 356 230.3a16.33 16.33 0 0 1 1.21-25.43c36.66-27.16 57.69-68.61 57.69-113.73a138.21 138.21 0 0 0-9.9-51.31 16 16 0 0 1 1.61-15.09 16.35 16.35 0 0 1 13.49-7.24 16 16 0 0 1 9.25 3 271.22 271.22 0 0 1 107.9 162.26L496 224z"]],
    "joint": [640, 512, [], "f595", ["M487.66 141.63C463.85 125 448 99.34 448 70.31V8a8 8 0 0 0-8-8h-48a8 8 0 0 0-8 8v66.4c0 43.69 24.56 81.63 60.34 106.7A83.55 83.55 0 0 1 480 249.69V280a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8v-30.31a131.49 131.49 0 0 0-56.34-108.06zm65.62-54.54A20.28 20.28 0 0 1 544 70.31V8a8 8 0 0 0-8-8h-48a8 8 0 0 0-8 8v62.31c0 22 10.17 43.41 28.64 55.39a147.47 147.47 0 0 1 67.36 124V280a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8v-30.31a195.36 195.36 0 0 0-86.72-162.6z", "M360.89 352.05c-34.4.06-86.81.15-88.21.17l117.8 137.43A64 64 0 0 0 439.07 512h88.45L409.57 374.4a64 64 0 0 0-48.68-22.35zM195 359A525 525 0 0 0 0 432a526.3 526.3 0 0 0 278.94 80h88.57L254.79 380.49A65 65 0 0 0 195 359zm421-7H432l118 137.65A64 64 0 0 0 598.58 512H616a24 24 0 0 0 24-24V376a24 24 0 0 0-24-24z"]],
    "journal-whills": [448, 512, [], "f66a", ["M96 448c-19.2 0-32-12.8-32-32s16-32 32-32h319.33c-1.93 16.24-1.76 48.38.53 64z", "M96 384h328a24 24 0 0 0 24-24V32a32 32 0 0 0-32-32H96A96 96 0 0 0 0 96v320a96 96 0 0 0 96 96h328a24 24 0 0 0 24-24v-16a24 24 0 0 0-24-24H96c-19.2 0-32-12.8-32-32s16-32 32-32zm37.08-239.61l21.26 21.26a8 8 0 0 0 11.32-11.31l-26.42-26.42a111.86 111.86 0 0 1 46.37-49.26 63 63 0 0 0 14 82.65 55.86 55.86 0 0 0 28.72 93.45l1.36-32.71-10.37 7a4.19 4.19 0 0 1-2.25.69 4 4 0 0 1-3.44-6l8.54-14.31-17.91-3.72a4 4 0 0 1 0-7.84l17.91-3.72-8.54-14.31a4 4 0 0 1 5.69-5.36l12 8.16L236 71.83a4 4 0 1 1 8 0l4.68 112.29 14.2-9.65a4.07 4.07 0 0 1 5 .41 4 4 0 0 1 .69 5L260 194.14l17.91 3.72a4 4 0 0 1 0 7.84L260 209.42l8.54 14.31a4 4 0 0 1-5.69 5.31l-12.68-8.62 1.43 34.28a55.84 55.84 0 0 0 28.71-93.43 63 63 0 0 0 14.09-82.6 111.86 111.86 0 0 1 46.37 49.26l-26.42 26.42a8 8 0 1 0 11.32 11.31l21.26-21.26c3 10.08 5.07 20.6 5.07 31.6 0 .52-.14 1-.15 1.51L314.74 210a8 8 0 1 0 10.52 12l23.59-20.64a111.71 111.71 0 0 1-217.71 0L154.73 222A8 8 0 0 0 166 210.63q-.35-.33-.72-.63l-37.11-32.47c0-.52-.15-1-.15-1.51-.02-11.02 2.08-21.54 5.06-31.63z"]],
    "joystick": [448, 512, [], "f8c5", ["M112 320H80a16 16 0 0 0-16 16v16h64v-16a16 16 0 0 0-16-16zm112-96c-11.2 0-21.8-2.14-32-5.2V352h64V218.8c-10.2 3.06-20.8 5.2-32 5.2z", "M416 352H32a32 32 0 0 0-32 32v96a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32v-96a32 32 0 0 0-32-32zM224 224a112 112 0 1 0-112-112 112 112 0 0 0 112 112zM200 48a24 24 0 1 1-24 24 24 24 0 0 1 24-24z"]],
    "jug": [448, 512, [], "f8c6", ["M144 64h160a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16H144a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zM32 288v128h384V288z", "M448 168a71.72 71.72 0 0 0-126.68-46.35L311 108.77a32 32 0 0 1-7-20V64H144v24.78a32 32 0 0 1-7 20l-76.95 96.16a128 128 0 0 0-28 80V288H416v-3.1a127.59 127.59 0 0 0-11.1-51A72 72 0 0 0 448 168zm-70.62 23.72l-24.09-30.1C356.14 151.54 365 144 376 144a23.88 23.88 0 0 1 1.38 47.72zM32 448a64 64 0 0 0 64 64h256a64 64 0 0 0 64-64v-32H32z"]],
    "kaaba": [576, 512, [], "f66b", ["M117.89 205.81l-80 21.82a8 8 0 0 0-5.89 7.72v16.58a8 8 0 0 0 10.11 7.72l80-21.82a8 8 0 0 0 5.89-7.72v-16.58a8 8 0 0 0-10.11-7.72zm144-39.28l-96 26.18a8 8 0 0 0-5.89 7.72V217a8 8 0 0 0 10.11 7.72l96-26.18a8 8 0 0 0 5.89-7.72v-16.57a8 8 0 0 0-10.11-7.72zm276.22 61.1l-80-21.82a8 8 0 0 0-10.11 7.72v16.58a8 8 0 0 0 5.89 7.72l80 21.82a8 8 0 0 0 10.11-7.72v-16.58a8 8 0 0 0-5.89-7.72zm-128-34.91l-96-26.18a8 8 0 0 0-10.11 7.72v16.58a8 8 0 0 0 5.89 7.72l96 26.18A8 8 0 0 0 416 217v-16.56a8 8 0 0 0-5.89-7.72z", "M301.81 114a47.66 47.66 0 0 0-27.59 0L0 196.3v228.38a32 32 0 0 0 25.06 31.24l242.12 53.8a95.94 95.94 0 0 0 41.65 0L551 455.92a32 32 0 0 0 25-31.24V196.29zM128 230.11a8 8 0 0 1-5.89 7.72l-80 21.82A8 8 0 0 1 32 251.93v-16.58a8 8 0 0 1 5.89-7.72l80-21.82a8 8 0 0 1 10.11 7.72zm144-39.28a8 8 0 0 1-5.89 7.72l-96 26.18A8 8 0 0 1 160 217v-16.57a8 8 0 0 1 5.89-7.72l96-26.18a8 8 0 0 1 10.11 7.72zM416 217a8 8 0 0 1-10.11 7.72l-96-26.18a8 8 0 0 1-5.89-7.72v-16.56a8 8 0 0 1 10.11-7.72l96 26.18a8 8 0 0 1 5.89 7.72zm128 34.91a8 8 0 0 1-10.11 7.72l-80-21.82a8 8 0 0 1-5.89-7.72v-16.56a8 8 0 0 1 10.11-7.72l80 21.82a8 8 0 0 1 5.89 7.72zM265 83.37L0 162.88v-49a32 32 0 0 1 21.88-30.37L257.65 4.93a96 96 0 0 1 60.71 0l235.76 78.58A32 32 0 0 1 576 113.87v49l-265-79.5a80 80 0 0 0-46 0z"]],
    "kazoo": [640, 512, [], "f8c7", ["M608 128h-95.32C559.55 151.75 592 199.86 592 256s-32.45 104.25-79.32 128H608a32 32 0 0 0 32-32V160a32 32 0 0 0-32-32zM304 256c0-56.14 32.45-104.25 79.32-128H241.93a128.18 128.18 0 0 0-35.16 4.92L23.21 185.37A32 32 0 0 0 0 216.14v79.72a32 32 0 0 0 23.21 30.77l183.56 52.44a127.81 127.81 0 0 0 35.16 4.93h141.39C336.45 360.25 304 312.14 304 256zm240 0a96 96 0 1 0-96 96 96 96 0 0 0 96-96zm-45.09 28.28a8 8 0 0 1 0 11.32l-11.31 11.31a8 8 0 0 1-11.32 0L448 278.63l-28.29 28.28a8 8 0 0 1-11.31 0l-11.31-11.31a8 8 0 0 1 0-11.32L425.38 256l-28.29-28.29a8 8 0 0 1 0-11.31l11.31-11.31a8 8 0 0 1 11.31 0L448 233.37l28.28-28.28a8 8 0 0 1 11.32 0l11.31 11.31a8 8 0 0 1 0 11.31L470.63 256z", "M448 112a144 144 0 1 0 144 144 144 144 0 0 0-144-144zm0 240a96 96 0 1 1 96-96 96 96 0 0 1-96 96z"]],
    "kerning": [640, 512, [], "f86f", ["M416.54 0h-17A8 8 0 0 0 392 5.32l-176.28 496a8 8 0 0 0 7.55 10.68h17a8 8 0 0 0 7.54-5.32l176.28-496A8 8 0 0 0 416.54 0z", "M304 96h-50.62a16 16 0 0 0-15.16 10.89L160 306.68 81.78 106.89A16 16 0 0 0 66.62 96H16A16 16 0 0 0 .85 117.11l105.27 277.2a32 32 0 0 0 30.3 21.69h47.16a32 32 0 0 0 30.3-21.69l105.27-277.2A16 16 0 0 0 304 96zm335.15 298.89l-105.27-277.2A32 32 0 0 0 503.58 96h-47.16a32 32 0 0 0-30.3 21.69l-105.27 277.2A16 16 0 0 0 336 416h50.61a16 16 0 0 0 15.16-10.89L416.31 368h127.38l14.53 37.11A16 16 0 0 0 573.38 416H624a16 16 0 0 0 15.15-21.11zM447.63 288L480 205.32 512.37 288z"]],
    "key": [512, 512, [], "f084", ["M303.06 348.91l.1.09-24 27a24 24 0 0 1-17.94 8H224v40a24 24 0 0 1-24 24h-40v40a24 24 0 0 1-24 24H24a24 24 0 0 1-24-24v-78a24 24 0 0 1 7-17l161.83-161.83-.11-.35a176.24 176.24 0 0 0 134.34 118.09z", "M336 0a176 176 0 1 0 176 176A176 176 0 0 0 336 0zm48 176a48 48 0 1 1 48-48 48 48 0 0 1-48 48z"]],
    "key-skeleton": [512, 512, [], "f6f3", ["M251.31 372.91a16 16 0 0 1 0 22.63l-15.77 15.77a16 16 0 0 1-22.62 0L176 374.4l-30.87 30.86 36.11 36.11a16 16 0 0 1 0 22.63l-43.16 43.17a16 16 0 0 1-22.62 0l-36.12-36.11-36.26 36.25a16 16 0 0 1-22.62 0L4.69 491.54a16 16 0 0 1 0-22.63l255.12-255.12a64.18 64.18 0 0 0 38.4 38.4L214.4 336l36.91 36.91z", "M448 0H320a64 64 0 0 0-64 64v128a64 64 0 0 0 64 64h128a64 64 0 0 0 64-64V64a64 64 0 0 0-64-64zm-73.37 182.63a32 32 0 1 1 0-45.25 32 32 0 0 1 0 45.25zm64-64a32 32 0 1 1 0-45.25 32 32 0 0 1 0 45.25z"]],
    "keyboard": [576, 512, [], "f11c", ["M528 64H48a48 48 0 0 0-48 48v288a48 48 0 0 0 48 48h480a48 48 0 0 0 48-48V112a48 48 0 0 0-48-48zm-176 76a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12v40a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12zm100 84a12 12 0 0 1 12 12v40a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12zm-84 12v40a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm-112-96a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12v40a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12zm16 96v40a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm-112-96a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12v40a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12zm16 96v40a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zM64 140a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12v40a12 12 0 0 1-12 12H76a12 12 0 0 1-12-12zm64 232a12 12 0 0 1-12 12H76a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm288 0a12 12 0 0 1-12 12H172a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h232a12 12 0 0 1 12 12zm96 0a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12zm0-192a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12z", "M164 224h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm96 0h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm96 0h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm108 52v-40a12 12 0 0 0-12-12h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12zm36 44h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm0-192h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm-136 64h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12zm-96 0h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12zm-96 0h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12h-40a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12zm-96 0h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12H76a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12zm40 128H76a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12z"]],
    "keynote": [512, 512, [], "f66c", ["M368 448h-80v-64h-64v64h-80a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h224a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM206.68 82.45A47.73 47.73 0 0 0 240 96h64a48 48 0 0 0 0-96h-64a47.89 47.89 0 0 0-46.31 36C137.77 49.72 96 99.91 96 160h48c0-37.62 26.21-69.06 62.68-77.55z", "M508.62 281.24a32.07 32.07 0 0 1 3.38 14.31V320a32 32 0 0 1-32 32H32a32 32 0 0 1-32-32v-24.45a32 32 0 0 1 3.38-14.31l51.78-103.55A32 32 0 0 1 83.78 160h344.44a32 32 0 0 1 28.62 17.69z"]],
    "khanda": [512, 512, [], "f66d", ["M193.3 68.85a14.25 14.25 0 0 1 3.57-16L255.86 0l59 52.82a14.23 14.23 0 0 1 3.57 16l-5 11L293.27 124l-7.93 17.39a112 112 0 0 0 0 75.56l33.36 73.27a14.16 14.16 0 0 1-2.81 15.28l-44.05 36.09v20.1L256 372.77l-16.08-11.2v-20l-44-36.09a14.19 14.19 0 0 1-2.92-15.24l16.1-35.37 11.62-25.5 5.66-12.37a112 112 0 0 0 0-75.56l-7.86-17.25L198.36 80zm78.55 384.06v-30.1L256 411.75 239.87 423v30c-9.39 5.57-16 15.38-16 27.1a32 32 0 1 0 64 0c-.03-11.8-6.64-21.61-16.02-27.19z", "M291.05 229.51l20 44a112 112 0 0 0 2.33-193.7L293.27 124a63.92 63.92 0 0 1-2.22 105.49zm-90.36 43.89l20.05-44a63.92 63.92 0 0 1-2.22-105.2L198.36 80a112 112 0 0 0 2.33 193.44zM415.81 66a16 16 0 0 0-21.27 22.54 163.69 163.69 0 0 1 25.2 87.46 159.64 159.64 0 0 1-71.27 132.41L256 372.77l-92.52-64.41A159.64 159.64 0 0 1 92.17 176a163.69 163.69 0 0 1 25.2-87.41A16 16 0 0 0 96.1 66C22.39 106.24-15.68 189.85 5.94 273.51c7.25 28.09 22.38 53.57 41.25 75.59l52.51 61.31a16 16 0 0 0 19.65 3.71l79.35-42.23 29.3 20.37-47 32.75a22.72 22.72 0 0 0-5-1 24 24 0 0 0 0 48c12.1 0 21.69-9.11 23.33-20.76l56.67-39.5 56.71 39.49C314.31 462.89 323.9 472 336 472a24 24 0 0 0 0-48 22.72 22.72 0 0 0-5 1l-47-32.75 29.26-20.37 79.35 42.23a16 16 0 0 0 19.65-3.71l52.51-61.31c18.87-22 34-47.5 41.25-75.59 21.57-83.65-16.5-167.26-90.21-207.5z"]],
    "kidneys": [640, 512, [], "f5fb", ["M402.73 199.72l-35.89 18a55.81 55.81 0 0 0-31 50.09v228.21a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16V267.77a8 8 0 0 1 4.47-7.16l23.87-11.94 2.13-7.39c4.92-16.94-3.05-31.56-11.58-41.56zm-98.86 68a55.74 55.74 0 0 0-31-50.09l-35.84-17.92c-8.57 10.12-16.55 25-11.66 42.26l1.82 6.49 24.21 12.11a8 8 0 0 1 4.44 7.16V496a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16v-48z", "M639.9 224c-2.09-74-35.81-146.16-96-199.7a96 96 0 1 0-127.69 143.42c49.6 44.12 26.49 91.15 25.76 93.71C424.49 322 469.62 384 534.29 384a96.07 96.07 0 0 0 92.26-69.46c5.54-19.27 14.54-48.08 13.35-90.54zM96 24.38C36.08 77.85 2.39 150 .13 224-1.15 266 7.6 294.91 13 314.06A96 96 0 0 0 105.37 384c64.31 0 109.65-61.47 92.47-122.11-1-3.7-23.08-50.43 26.07-94.27A96 96 0 1 0 96 24.38z"]],
    "kiss": [496, 512, [], "f596", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8ZM168,240a32,32,0,1,1,32-32A32,32,0,0,1,168,240ZM304,396c0,19.2-28.7,41.5-71.5,44-8.5.8-12.1-11.8-3.6-15.4l17-7.2c13-5.5,20.8-13.5,20.8-21.5s-7.8-16-20.8-21.5l-17-7.2c-6-2.5-6.1-12.2,0-14.8l17-7.2c13-5.5,20.8-13.5,20.8-21.5s-7.8-16-20.8-21.5l-17-7.2c-8.6-3.6-4.8-16.5,3.6-15.4,42.8,2.5,71.5,24.8,71.5,44,0,13-13.4,27.3-35.2,36C290.6,368.7,304,383,304,396Zm24-156a32,32,0,1,1,32-32A32,32,0,0,1,328,240Z", "M328,176a32,32,0,1,0,32,32A32,32,0,0,0,328,176Zm-160,0a32,32,0,1,0,32,32A32,32,0,0,0,168,176Z"]],
    "kiss-beam": [496, 512, [], "f597", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8ZM209,227.9l-9.5-17c-7.7-13.7-19.2-21.6-31.5-21.6s-23.8,7.9-31.5,21.6l-9.5,17c-4.2,7.4-15.6,4-14.9-4.5,3.3-42.1,32.2-71.4,56-71.4s52.7,29.3,56,71.4C224.6,231.9,213.2,235.4,209,227.9ZM304,396c0,19.2-28.7,41.5-71.5,44-8.5.8-12.1-11.8-3.6-15.4l17-7.2c13-5.5,20.8-13.5,20.8-21.5s-7.8-16-20.8-21.5l-17-7.2c-6-2.5-6.1-12.2,0-14.8l17-7.2c13-5.5,20.8-13.5,20.8-21.5s-7.8-16-20.8-21.5l-17-7.2c-8.6-3.6-4.8-16.5,3.6-15.4,42.8,2.5,71.5,24.8,71.5,44,0,13-13.4,27.3-35.2,36C290.6,368.7,304,383,304,396Zm65-168.1-9.5-17c-7.7-13.7-19.2-21.6-31.5-21.6s-23.8,7.9-31.5,21.6l-9.5,17c-4.1,7.3-15.6,4-14.9-4.5,3.3-42.1,32.2-71.4,56-71.4s52.7,29.3,56,71.4C384.6,231.9,373.2,235.4,369,227.9Z", "M384.1,223.4c-3.3-42.1-32.2-71.4-56-71.4s-52.7,29.3-56,71.4c-.7,8.5,10.8,11.8,14.9,4.5l9.5-17c7.7-13.7,19.2-21.6,31.5-21.6s23.8,7.9,31.5,21.6l9.5,17C373.2,235.4,384.6,231.9,384.1,223.4ZM168.1,152c-23.8,0-52.7,29.3-56,71.4-.7,8.5,10.7,11.9,14.9,4.5l9.5-17c7.7-13.7,19.2-21.6,31.5-21.6s23.8,7.9,31.5,21.6l9.5,17c4.2,7.5,15.6,4,15.1-4.5C220.8,181.3,191.9,152,168.1,152Z"]],
    "kiss-wink-heart": [504, 512, [], "f598", ["M332.49,338.8c29.7-46.3,98.7-45.5,127.8,4.3a81.91,81.91,0,0,1,18.6,2.9A246.65,246.65,0,0,0,496,256C496,119,385,8,248,8S0,119,0,256,111,504,248,504a246.15,246.15,0,0,0,99.4-20.9c-.3-.7-23.9-84.6-23.9-84.6A74.25,74.25,0,0,1,332.49,338.8ZM168,240a32,32,0,1,1,32-32A32,32,0,0,1,168,240ZM288,396c0,19.2-28.7,41.5-71.49,44-8.5.8-12.1-11.8-3.6-15.4l17-7.2c13-5.5,20.8-13.5,20.8-21.5s-7.8-16-20.8-21.5l-17-7.2c-6-2.5-5.7-12.3,0-14.8l17-7.2c13-5.5,20.8-13.5,20.8-21.5s-7.8-16-20.8-21.5l-17-7.2c-8.8-3.7-4.6-16.6,3.6-15.4,42.79,2.5,71.49,24.8,71.49,44,0,13-13.4,27.3-35.2,36C274.59,368.7,288,383,288,396Zm16-179c-8.3,7.4-21.6.4-19.8-10.8,4-25.2,34.2-42.1,59.9-42.1S400,181,404,206.2A12,12,0,0,1,384.2,217l-9.5-8.5c-14.8-13.2-46.2-13.2-61,0Z", "M501.09,402.5c-8-20.8-31.5-31.5-53.1-25.9l-8.4,2.2-2.3-8.4c-5.9-21.4-27-36.5-49-33a41.87,41.87,0,0,0-34,52.6l22.9,82.6a10.23,10.23,0,0,0,12.4,7.1l83-21.5a41.75,41.75,0,0,0,28.5-55.72ZM384.19,217A12,12,0,0,0,404,206.2c-4-25.2-34.2-42.1-59.9-42.1s-55.9,16.9-59.9,42.1c-1.8,11.2,11.5,18.2,19.8,10.8l9.7-8.5c14.8-13.2,46.2-13.2,61,0ZM168,176a32,32,0,1,0,32,32A32,32,0,0,0,168,176Z"]],
    "kite": [640, 512, [], "f6f4", ["M72 251l24 15.87L120 251v-27a88 88 0 0 0-88-88H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h16a40 40 0 0 1 40 40zM630.63 9.37L475.1 164.9l153.82 153.82A32 32 0 0 0 640 294.5V32a31.9 31.9 0 0 0-9.37-22.63zm-309.36 1.74a32 32 0 0 0-7 13.69l-80.09 347.09-87.54 87.54a15.6 15.6 0 0 1-26.63-11V325L96 309.16 72 325v118.31c0 16.55 5 33 15.7 45.71 26.48 31.53 69 28.26 92.87 4.34l87.55-87.55-6.7 1.55a24 24 0 0 1-22.36-6.42L475 165z", "M154.69 228L96 266.84 37.31 228c-16-10.55-37.31.79-37.31 19.8v80.32c0 19 21.36 30.35 37.31 19.8L96 309.16 154.69 348c15.95 10.55 37.31-.79 37.31-19.8v-80.36c0-19.01-21.36-30.35-37.31-19.84zM630.63 9.37A31.9 31.9 0 0 0 608 0H345.5a32.08 32.08 0 0 0-24.23 11.11L475 165 239.06 400.94a24 24 0 0 0 22.36 6.42L615.2 325.7a31.76 31.76 0 0 0 13.72-7L475.1 164.9z"]],
    "kiwi-bird": [576, 512, [], "f535", ["M144 410v54a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-73.69A190.9 190.9 0 0 0 144 410zm432-186a112 112 0 0 1-102.62 111.61l72.54 136.05A16 16 0 0 0 560 480a16.2 16.2 0 0 0 3.95-.5A16 16 0 0 0 576 464V224zM208 415.32V464a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16v-58.95a191 191 0 0 1-48 10.27z", "M464 112h-15.74a260.23 260.23 0 0 1-147.74-46.24q-6.09-4.22-12.52-7.94v-.13A191.08 191.08 0 0 0 192 32C86 32 0 118 0 224s86 192 192 192a191.08 191.08 0 0 0 96-25.69v-.2c2.83-1.61 5.61-3.28 8.33-5.05C342 355.33 393.58 336.1 448 336h16a112 112 0 0 0 0-224zm0 136a24 24 0 1 1 24-24 24 24 0 0 1-24 24z"]],
    "knife-kitchen": [576, 512, [], "f6f5", ["M4.87 469.83L267.52 216.6l129.09 124.45a15.6 15.6 0 0 1 0 22.63l-61 58.85c-84.89 81.81-210.41 110.38-324.25 73.79-11.71-3.75-15.21-18.08-6.49-26.49z", "M566.28 43.31L531.07 9.38a34.07 34.07 0 0 0-46.94 0L291.82 194.77l112.1 108.08 34.35-27.7a31.47 31.47 0 0 0 9.73-22.64V208L566.28 88.57a31.2 31.2 0 0 0 0-45.26zm-122 106.36a17 17 0 0 1-23.47 0 15.6 15.6 0 0 1 0-22.63 17 17 0 0 1 23.47 0 15.6 15.6 0 0 1-.04 22.63zm60.52-58.36a17 17 0 0 1-23.47 0 15.59 15.59 0 0 1 0-22.62 17 17 0 0 1 23.47 0 15.59 15.59 0 0 1-.04 22.62z"]],
    "lambda": [448, 512, [], "f66e", ["M194.62 243.73l-95 221.72A24 24 0 0 1 77.54 480H25.31a24 24 0 0 1-22.06-33.45l132.88-310.06z", "M448 408v48a24 24 0 0 1-24 24h-81.5a32 32 0 0 1-28.1-16.68L131.5 128H24a24 24 0 0 1-24-24V56a24 24 0 0 1 24-24h145.5a32 32 0 0 1 28.1 16.68L380.5 384H424a24 24 0 0 1 24 24z"]],
    "lamp": [448, 512, [], "f4ca", ["M158.31 288h131.4C327 325.2 352 386.8 352 428.8c0 28.4-11.5 54.2-30.5 74.3-5.7 6-13.9 8.9-22.2 8.9H148.71c-8.3 0-16.5-2.9-22.2-8.9-19-20-30.5-45.9-30.5-74.3-.01-42 24.99-103.6 62.3-140.8z", "M93.61 17.7c5.2-10.9 15.6-17.7 27-17.7h219.8c12 0 22.9 7.6 27.6 19.4l77.5 192c8.6 21.1-6 44.6-27.6 44.6H30.21c-22.4 0-37-25-27-46.3z"]],
    "landmark": [512, 512, [], "f66f", ["M496 448H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h480a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-16-80a16 16 0 0 0-16-16h-16V192h-64v160h-96V192h-64v160h-96V192H64v160H48a16 16 0 0 0-16 16v48h448z", "M10.38 92.11L244.77 2a32 32 0 0 1 22.47 0l234.38 90.11a16 16 0 0 1 10.38 15V144a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-36.91a16 16 0 0 1 10.38-14.98z"]],
    "landmark-alt": [512, 512, [], "f752", ["M0 496v-32a16 16 0 0 1 16-16h16v-16a16 16 0 0 1 16-16h16V288h64v128h96V288h64v128h96V288h64v128h16a16 16 0 0 1 16 16v16h16a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16z", "M288 16v18.9A191.88 191.88 0 0 1 445.1 192H464a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16H48a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h18.9A191.88 191.88 0 0 1 224 34.9V16a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16z"]],
    "language": [640, 512, [], "f1ab", ["M168.1 236.2c-3.5-12.1-7.8-33.2-7.8-33.2h-.5s-4.3 21.1-7.8 33.2l-11.1 37.5H179zM0 120v272.12A23.94 23.94 0 0 0 24 416h296V96H23.88A23.94 23.94 0 0 0 0 120zm74.62 216.19l57.65-168.14A12 12 0 0 1 143.7 160h32.58a12.23 12.23 0 0 1 11.43 8.05l57.64 168.14a11.7 11.7 0 0 1 .65 3.93A12 12 0 0 1 233.92 352H211a12 12 0 0 1-11.53-8.55L190 311.73h-60.34l-9.12 31.62A12.11 12.11 0 0 1 109 352H86a12.07 12.07 0 0 1-11.43-15.81zM564 188h-64v-16a12 12 0 0 0-12-12h-16a12 12 0 0 0-12 12v16h-64a12 12 0 0 0-12 12v16a12 12 0 0 0 12 12h114.3c-6.2 14.3-16.5 29-30 43.19a191 191 0 0 1-17.4-20.89 12.09 12.09 0 0 0-16-3.4l-7.3 4.3-6.5 3.89-.64.41a12 12 0 0 0-3.06 16.69 231.81 231.81 0 0 0 21 25.69 284.34 284.34 0 0 1-26.1 18 12 12 0 0 0-4.2 16.2l7.9 13.89.2.34a12 12 0 0 0 16.5 4 352.44 352.44 0 0 0 35.4-24.89 348.11 348.11 0 0 0 35.4 24.89 3.79 3.79 0 0 0 .34.2 12 12 0 0 0 16.36-4.5l7.9-14.01a12 12 0 0 0-4.1-16.2 310.64 310.64 0 0 1-26.1-18c21-22.49 35.8-46.28 42.7-69.88H564a12 12 0 0 0 12-12V200a12 12 0 0 0-12-12z", "M616.12 96H320v320h296a23.94 23.94 0 0 0 24-23.88V120a23.94 23.94 0 0 0-23.88-24zM576 216a12 12 0 0 1-12 12h-11.4c-6.9 23.6-21.7 47.39-42.7 69.88a310.64 310.64 0 0 0 26.1 18 12 12 0 0 1 4.1 16.2l-7.9 13.89a12 12 0 0 1-16.36 4.5 3.79 3.79 0 0 1-.34-.2 348.11 348.11 0 0 1-35.4-24.89 352.44 352.44 0 0 1-35.4 24.89 12 12 0 0 1-16.5-4l-.2-.34-7.9-13.93a12 12 0 0 1 4.2-16.2 284.34 284.34 0 0 0 26.1-18 231.81 231.81 0 0 1-21-25.69 12 12 0 0 1 3.06-16.69l.64-.41 6.5-3.89 7.3-4.3a12.09 12.09 0 0 1 16 3.4 191 191 0 0 0 17.4 20.89c13.5-14.2 23.8-28.89 30-43.19H396a12 12 0 0 1-12-12V200a12 12 0 0 1 12-12h64v-16a12 12 0 0 1 12-12h16a12 12 0 0 1 12 12v16h64a12 12 0 0 1 12 12zm-388.29-47.95a12.23 12.23 0 0 0-11.43-8.05H143.7a12 12 0 0 0-11.43 8.05L74.62 336.19A12.07 12.07 0 0 0 86.05 352h23a12.11 12.11 0 0 0 11.53-8.65l9.12-31.62H190l9.42 31.72A12 12 0 0 0 211 352h23a12 12 0 0 0 12-11.88 11.7 11.7 0 0 0-.65-3.93zM140.9 273.7l11.1-37.5c3.5-12.1 7.8-33.2 7.8-33.2h.5s4.3 21.1 7.8 33.2l10.9 37.5z"]],
    "laptop": [640, 512, [], "f109", ["M528 0H112a48.14 48.14 0 0 0-48 48v336h512V48a48.14 48.14 0 0 0-48-48zm-16 320H128V64h384z", "M512 64H128v256h384zm112 352H381.54c-.74 19.81-14.71 32-32.74 32H288c-18.69 0-33-17.47-32.77-32H16a16 16 0 0 0-16 16v16a64.19 64.19 0 0 0 64 64h512a64.19 64.19 0 0 0 64-64v-16a16 16 0 0 0-16-16z"]],
    "laptop-code": [640, 512, [], "f5fc", ["M528 0H112a48.14 48.14 0 0 0-48 48v336h512V48a48.14 48.14 0 0 0-48-48zm-16 320H128V64h384z", "M624 416H381.54c-.74 19.81-14.71 32-32.74 32H288c-18.69 0-33-17.47-32.77-32H16a16 16 0 0 0-16 16v16a64.19 64.19 0 0 0 64 64h512a64.19 64.19 0 0 0 64-64v-16a16 16 0 0 0-16-16zM512 64H128v256h384zM289 250.34l-11.31 11.31a16 16 0 0 1-22.63 0l-58.35-58.34a16 16 0 0 1 0-22.63L255 122.34a16 16 0 0 1 22.63 0L289 133.65a16 16 0 0 1 0 22.63L253.25 192 289 227.71a16 16 0 0 1 0 22.63zm154.35-47L385 261.66a16 16 0 0 1-22.63 0L351 250.35a16 16 0 0 1 0-22.63L386.75 192 351 156.29a16 16 0 0 1 0-22.63l11.31-11.31a16 16 0 0 1 22.63 0l58.34 58.34a16 16 0 0 1 .04 22.63z"]],
    "laptop-medical": [640, 512, [], "f812", ["M528 0H112a48.14 48.14 0 0 0-48 48v336h512V48a48.14 48.14 0 0 0-48-48zm-16 320H128V64h384z", "M624 416H381.54c-.74 19.81-14.71 32-32.74 32H288c-18.69 0-33-17.47-32.77-32H16a16 16 0 0 0-16 16v16a64.19 64.19 0 0 0 64 64h512a64.19 64.19 0 0 0 64-64v-16a16 16 0 0 0-16-16zM512 64H128v256h384zm-96 152a8 8 0 0 1-8 8h-56v56a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-56h-56a8 8 0 0 1-8-8v-48a8 8 0 0 1 8-8h56v-56a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8v56h56a8 8 0 0 1 8 8z"]],
    "lasso": [576, 512, [], "f8c8", ["M178.13 384.21a68.83 68.83 0 0 1 2.58 17.53 45.9 45.9 0 0 1-45.77 46.5H48a16 16 0 0 0-16 15.94v31.88A16 16 0 0 0 48 512h86.94c59.38 0 108.8-47.23 109.76-106.38a134.89 134.89 0 0 0-6.57-45.28c-14.24 14.12-35.65 23.35-60 23.87zM288 0C126.5 0 0 79.64 0 181.3c0 49.78 30.22 95.84 85 129.7 3.54 2.17 7.41 4.31 11.37 6.45 1.39-22.07 16.73-41 39.25-51.59-5.91-3-11.92-6-16.9-9.07C98.31 244.17 64 217.57 64 181.3c0-62.61 104.69-117.54 224-117.54s224 54.93 224 117.54-104.69 117.52-224 117.52c-12.82 0-25.42-.8-37.88-2a52.39 52.39 0 0 1 5.88 23.8c0 14.93-6.7 28.47-17.48 39.34a470.13 470.13 0 0 0 49.48 2.62c161.5 0 288-79.64 288-181.28S449.5 0 288 0z", "M256 320.62c0 35.21-35.82 63.76-80 63.76s-80-28.55-80-63.76 35.82-63.76 80-63.76 80 28.55 80 63.76z"]],
    "laugh": [496, 512, [], "f599", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8Zm80,152a32,32,0,1,1-32,32A32,32,0,0,1,328,160Zm-160,0a32,32,0,1,1-32,32A32,32,0,0,1,168,160ZM398.9,306A144.12,144.12,0,0,1,256,432H240A144.12,144.12,0,0,1,97.1,306a16.06,16.06,0,0,1,14-17.88A15,15,0,0,1,113,288H383a16,16,0,0,1,16,16A16.64,16.64,0,0,1,398.9,306Z", "M328,160a32,32,0,1,0,32,32A32,32,0,0,0,328,160Zm-160,0a32,32,0,1,0,32,32A32,32,0,0,0,168,160Z"]],
    "laugh-beam": [496, 512, [], "f59a", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8Zm24,199.4c3.3-42.1,32.2-71.4,56-71.4s52.7,29.3,56,71.4c.7,8.6-10.8,11.9-14.9,4.5l-9.5-17c-7.7-13.7-19.2-21.6-31.5-21.6s-23.8,7.9-31.5,21.6l-9.5,17C282.9,219.3,271.3,216,272,207.4Zm-160,0c3.3-42.1,32.2-71.4,56-71.4s52.7,29.3,56,71.4c.7,8.6-10.8,11.9-14.9,4.5l-9.5-17c-7.7-13.7-19.2-21.6-31.5-21.6s-23.8,7.9-31.5,21.6l-9.5,17C122.8,219.3,111.3,215.9,112,207.4ZM398.9,306A144.12,144.12,0,0,1,256,432H240A144.12,144.12,0,0,1,97.1,306a16.06,16.06,0,0,1,14-17.88A15,15,0,0,1,113,288H383a16,16,0,0,1,16,16A16.64,16.64,0,0,1,398.9,306Z", "M384,207.4c-3.3-42.1-32.2-71.4-56-71.4s-52.7,29.3-56,71.4c-.7,8.6,10.9,11.9,15.1,4.5l9.5-17c7.7-13.7,19.2-21.6,31.5-21.6s23.8,7.9,31.5,21.6l9.5,17C373.2,219.3,384.7,216,384,207.4ZM168,136c-23.8,0-52.7,29.3-56,71.4-.7,8.5,10.8,11.9,15.1,4.5l9.5-17c7.7-13.7,19.2-21.6,31.5-21.6s23.8,7.9,31.5,21.6l9.5,17c4.1,7.4,15.6,4.1,14.9-4.5C220.7,165.3,191.8,136,168,136Z"]],
    "laugh-squint": [496, 512, [], "f59b", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8Zm33.8,161.7,80-48c11.6-6.9,24,7.7,15.4,18L343.6,180l33.6,40.3c8.7,10.4-3.9,24.8-15.4,18l-80-48a12.07,12.07,0,0,1,0-20.6Zm-147.6-48,80,48a12,12,0,0,1,0,20.6l-80,48c-11.5,6.8-24-7.6-15.4-18L152.4,180l-33.6-40.3C110.2,129.4,122.6,114.8,134.2,121.7ZM398.9,306A144.12,144.12,0,0,1,256,432H240A144.12,144.12,0,0,1,97.1,306a16.06,16.06,0,0,1,14-17.88A15,15,0,0,1,113,288H383a16,16,0,0,1,16,16A16.64,16.64,0,0,1,398.9,306Z", "M377.2,220.3,343.6,180l33.6-40.3c8.6-10.3-3.8-24.9-15.4-18l-80,48a12.07,12.07,0,0,0,0,20.6l80,48C373.3,245.1,385.9,230.7,377.2,220.3Zm-163-50.6-80-48c-11.6-6.9-24,7.7-15.4,18L152.4,180l-33.6,40.3c-8.6,10.4,3.9,24.8,15.4,18l80-48a12,12,0,0,0,0-20.6Z"]],
    "laugh-wink": [496, 512, [], "f59c", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8Zm20.1,198.1c4-25.2,34.2-42.1,59.9-42.1s55.9,16.9,59.9,42.1c1.7,11.1-11.4,18.3-19.8,10.8l-9.5-8.5c-14.8-13.2-46.2-13.2-61,0L288,217a12.08,12.08,0,0,1-19.9-10.9ZM168,160a32,32,0,1,1-32,32A32,32,0,0,1,168,160ZM398.9,306A144.12,144.12,0,0,1,256,432H240A144.12,144.12,0,0,1,97.1,306a16.06,16.06,0,0,1,14-17.88A15,15,0,0,1,113,288H383a16,16,0,0,1,16,16A16.64,16.64,0,0,1,398.9,306Z", "M387.9,206.1c-4-25.2-34.2-42.1-59.9-42.1s-55.9,16.9-59.9,42.1A12.08,12.08,0,0,0,288,217l9.6-8.6c14.8-13.2,46.2-13.2,61,0l9.5,8.5c8.4,7.5,21.5.3,19.8-10.8ZM168,160a32,32,0,1,0,32,32A32,32,0,0,0,168,160Z"]],
    "layer-group": [512, 512, [], "f5fd", ["M12.41 236.31L70.51 210l161.63 73.27a57.64 57.64 0 0 0 47.72 0L441.5 210l58.09 26.33c16.55 7.5 16.55 32.5 0 40L266.64 381.9a25.68 25.68 0 0 1-21.29 0L12.41 276.31c-16.55-7.5-16.55-32.5 0-40z", "M12.41 148l232.94 105.7a25.61 25.61 0 0 0 21.29 0L499.58 148c16.55-7.51 16.55-32.52 0-40L266.65 2.32a25.61 25.61 0 0 0-21.29 0L12.41 108c-16.55 7.5-16.55 32.52 0 40zm487.18 216.11l-57.87-26.23-161.86 73.37a57.64 57.64 0 0 1-47.72 0L70.29 337.88l-57.88 26.23c-16.55 7.5-16.55 32.5 0 40L245.35 509.7a25.68 25.68 0 0 0 21.29 0l233-105.59c16.5-7.5 16.5-32.5-.05-40z"]],
    "layer-minus": [512, 512, [], "f5fe", ["M12.41 236.3l233-105.58a25.68 25.68 0 0 1 21.29 0L499.59 236.3c16.55 7.5 16.55 32.5 0 40L266.64 381.89a25.68 25.68 0 0 1-21.29 0L12.41 276.3c-16.55-7.5-16.55-32.5 0-40z", "M499.59 364.1l-58.09-26.33L279.87 411a57.64 57.64 0 0 1-47.72 0L70.51 337.77l-58.1 26.33c-16.55 7.5-16.55 32.5 0 40l232.94 105.59a25.68 25.68 0 0 0 21.29 0l233-105.59c16.5-7.5 16.5-32.5-.05-40zM304 64h192a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16H304a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16z"]],
    "layer-plus": [512, 512, [], "f5ff", ["M400 288c16.73 0 32.68-2.91 48-7.29v18.58l-181.36 82.2a25.68 25.68 0 0 1-21.29 0L12.41 275.9c-16.55-7.5-16.55-32.5 0-40l213.87-97C239.28 223.32 312 288 400 288z", "M499.59 364.1l-58.54-26.53-161.19 73.06a57.64 57.64 0 0 1-47.72 0L71 337.57 12.41 364.1c-16.55 7.5-16.55 32.5 0 40l232.94 105.59a25.68 25.68 0 0 0 21.29 0l233-105.59c16.5-7.5 16.5-32.5-.05-40zM304 144h64v64a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-64h64a16 16 0 0 0 16-16V96a16 16 0 0 0-16-16h-64V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v64h-64a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16z"]],
    "leaf": [576, 512, [], "f06c", ["M576 154.31c0 172.38-110.51 313.17-267.53 324.57A199 199 0 0 1 288 480v-.55h-.25a191.66 191.66 0 0 1-165.63-95.07l.77-.85c29.58-32.23 62.28-57.84 97.18-76.12a297.55 297.55 0 0 1 139.4-34.05 24.69 24.69 0 0 0 0-49.37 345.79 345.79 0 0 0-162.94 40.1c-33.77 17.81-65.56 41.48-94.77 70.49A192.06 192.06 0 0 1 96 287.72C96 181.83 181.86 96 287.77 96H368c63.4 0 118.91-33.59 149.91-87.49 6.7-11.8 22.71-11.3 28.31 1.2C565.2 52.12 576 104.11 576 154.31z", "M24.5 512a24.32 24.32 0 0 1-9.5-1.95 24.73 24.73 0 0 1-13-32.3c1.08-2.6 27.24-64.33 83.81-126.43 33.47-36.75 70.75-66.09 110.81-87.22A345.79 345.79 0 0 1 359.49 224a24.69 24.69 0 0 1 0 49.37 297.55 297.55 0 0 0-139.4 34.05c-34.9 18.28-67.6 43.89-97.18 76.12-51.25 55.85-75.58 112.83-75.82 113.4A24.54 24.54 0 0 1 24.5 512z"]],
    "leaf-heart": [576, 512, [], "f4cb", ["M546.2 9.72c-5.6-12.5-21.61-13-28.31-1.2C486.89 62.42 431.38 96 368 96h-80.25C181.86 96 96 181.83 96 287.72a192.06 192.06 0 0 0 5.78 46.87q-8.16 8.1-16 16.73C29.17 413.42 3 475.15 1.93 477.75A24.73 24.73 0 0 0 15 510.05a24.41 24.41 0 0 0 32.11-13.11c.24-.57 24.33-57 75.05-112.55a191.66 191.66 0 0 0 165.63 95.07h.21v.54a199 199 0 0 0 20.45-1.12C465.49 467.48 576 326.69 576 154.31c0-50.2-10.8-102.19-29.8-144.59zm-115.65 284.7L345.85 380a13.94 13.94 0 0 1-19.8 0l-84.7-85.6a60.65 60.65 0 0 1 4.3-89.1c24-20 59.6-16.4 81.6 5.8l8.6 8.7 8.6-8.7c22-22.2 57.7-25.8 81.6-5.8a60.58 60.58 0 0 1 4.5 89.12z", "M245.65 205.32c24-20 59.6-16.4 81.6 5.8l8.6 8.7 8.6-8.7c22-22.2 57.7-25.8 81.6-5.8a60.58 60.58 0 0 1 4.5 89.1L345.85 380a13.94 13.94 0 0 1-19.8 0l-84.7-85.6a60.65 60.65 0 0 1 4.3-89.08z"]],
    "leaf-maple": [512, 512, [], "f6f6", ["M504 195.56l-140.83 89.59L428 268.57a17.33 17.33 0 0 1 20.57 21.12l-13.8 25.72 51.31 45.3a17.34 17.34 0 0 1 0 27.07l-51.31 45.3 13.8 25.72A17.33 17.33 0 0 1 428 479.92l-160.19-33L251.94 484c-6 14-25.86 14-31.88 0l-49.14-108 141.86-141.91a24.65 24.65 0 1 0-34.86-34.87L136.06 341.1 28 291.94c-14-6-14-25.87 0-31.87l37.08-15.89L32.08 84a17.34 17.34 0 0 1 21.13-20.59l25.73 13.81 45.3-51.33a17.33 17.33 0 0 1 27.06 0l45.3 51.33 25.73-13.82A17.33 17.33 0 0 1 243.45 84l-16.58 64.84L316.46 8a17.35 17.35 0 0 1 29.5.39l22.33 37.23 88.77-9.86a17.34 17.34 0 0 1 19.15 19.14l-9.87 88.78 37.24 22.34a17.35 17.35 0 0 1 .42 29.54z", "M24.67 512a24.61 24.61 0 0 1-17.43-42l270.68-270.78a24.65 24.65 0 1 1 34.86 34.87L42.1 504.82A24.51 24.51 0 0 1 24.67 512z"]],
    "leaf-oak": [512, 512, [], "f6f7", ["M498.05 232.79c-6.27 6.76-14.7 11.71-22.66 16.65-12.63 7.82-25.7 14.94-39.93 23.13 5.51 6.72 9.75 11.65 13.73 16.77 22.23 28.61 16 59.63-15.4 77.62-22.74 13.04-47.07 11.64-71.79 8.47-12.84-1.65-25.76-2.69-42.31-4.38 4.27 6.14 6.24 8.58 7.78 11.27 14.94 26.1 4.3 55.32-24.64 63.17a80.79 80.79 0 0 1-37.58.86c-17.31-3.93-33.46-12.87-50.66-17.61-9.41-2.6-21-3.91-29.81-.72-16.38 6-42.38 15.09-68.62 2.7l196.62-196.63a24.65 24.65 0 1 0-34.86-34.87L81.31 395.87C68.88 369.61 78 343.58 84 327.19c3.19-8.77 1.88-20.4-.72-29.81-4.74-17.2-13.68-33.35-17.61-50.66a80.79 80.79 0 0 1 .86-37.58c7.85-28.94 37.07-39.58 63.17-24.64 2.69 1.54 5.13 3.51 11.27 7.78-1.69-16.55-2.73-29.47-4.38-42.31C133.4 125.28 132 101 145 78.21c18-31.36 49-37.63 77.62-15.4 5.12 4 10.05 8.22 16.77 13.73 8.19-14.23 15.31-27.3 23.13-39.93 4.94-8 9.89-16.39 16.65-22.66C303-8.1 338.37-3.38 357 23.6a75.46 75.46 0 0 1 7.36 12.47c3.19 7.33 11.8 10.35 19.56 8.06 33.07-9.76 57-2.91 71.5 12.43 15.34 14.49 22.18 38.43 12.43 71.5-2.29 7.76.73 16.37 8.06 19.56A75.46 75.46 0 0 1 488.4 155c26.98 18.63 31.7 54 9.65 77.79z", "M24.67 512a24.61 24.61 0 0 1-17.43-42l270.68-270.78a24.65 24.65 0 1 1 34.86 34.87L42.1 504.82A24.51 24.51 0 0 1 24.67 512z"]],
    "lemon": [512, 512, [], "f094", ["M489 23C465.94-.13 434.65-5.93 414 6.13 355 40.44 232.7-46.95 92.87 92.88S40.44 355 6.13 413.94C-5.93 434.65-.13 465.94 23 489s54.39 28.89 75.1 16.83c58.9-34.27 181.2 53.17 321-86.7S471.56 157 505.87 98.06c12.06-20.71 6.26-52-16.87-75.06zM243.88 95.52c-58.19 14.55-133.81 90.16-148.36 148.36a16 16 0 0 1-31-7.76c17.38-69.69 101.8-154.19 171.6-171.64a16 16 0 0 1 7.76 31z", "M243.88 95.48c-58.19 14.55-133.81 90.16-148.36 148.36a16 16 0 0 1-31-7.76c17.38-69.65 101.8-154.15 171.6-171.6a16 16 0 0 1 7.76 31z"]],
    "less-than": [384, 512, [], "f536", ["M381 400.39l-13.56 29.08A32.09 32.09 0 0 1 324.79 445L18.48 302.16a32 32 0 0 1-18.48-29v-34.24a32 32 0 0 1 18.48-29L324.94 67a32 32 0 0 1 42.53 15.48l13.52 29A32 32 0 0 1 365.51 154L147 255.9l218.46 101.85A32.08 32.08 0 0 1 381 400.39z", ""]],
    "less-than-equal": [448, 512, [], "f537", ["M24 400h400a24 24 0 0 1 24 24v48a24 24 0 0 1-24 24H24a24 24 0 0 1-24-24v-48a24 24 0 0 1 24-24z", "M392.77 107.69l-175.56 68.09 175.44 68.05c18.39 6 27.89 24.39 21.21 41l-12.09 30.08c-6.67 16.61-27 25.18-45.38 19.15L55 214.19c-13.79-4.52-23-16.61-23-30.19v-16c0-13.57 9.21-25.66 23-30.18l301.71-120c18.29-6 38.51 2.53 45.15 19.06l12 29.92c6.65 16.62-2.8 34.89-21.09 40.89z"]],
    "level-down": [352, 512, [], "f149", ["M59.51 76.48l-56-56A12 12 0 0 1 12 0h196a24 24 0 0 1 24 24v348.71l-40 43.21-40-43.23V80H68a12 12 0 0 1-8.49-3.52z", "M345 367.28L209.09 504.87l-.09.13a24.08 24.08 0 0 1-33.95 0l-.14-.14L39 367.28a24.22 24.22 0 0 1 0-34l22-22.17a23.91 23.91 0 0 1 33.81-.11l.13.13c.21.21.42.43.62.65L192 415.92l96.45-104.21c.2-.22.41-.44.62-.65a23.92 23.92 0 0 1 33.82-.13l.12.13 22 22.17a24.22 24.22 0 0 1 0 34z"]],
    "level-down-alt": [320, 512, [], "f3be", ["M152 352V80H68a12 12 0 0 1-8.48-3.52l-56-56A12 12 0 0 1 12 0h196a24 24 0 0 1 24 24v328z", "M296 352c20.87 0 31.85 25 17.58 40.33l-104 112a24 24 0 0 1-33.91 1.26c-.44-.4-.86-.83-1.26-1.26l-104-112C56.25 377 67.07 352 88 352z"]],
    "level-up": [352, 512, [], "f148", ["M68,432h84V139.31l40-43.23,40,43.21V488a24,24,0,0,1-24,24H12a12,12,0,0,1-8.48-20.48l56-56A12,12,0,0,1,68,432Z", "M345,178.76l-22,22.17a23.93,23.93,0,0,1-33.83.13l-.12-.13c-.21-.21-.42-.43-.62-.65L192,96.08,95.53,200.29c-.2.22-.41.44-.62.65a23.93,23.93,0,0,1-33.83.13.53.53,0,0,0-.13-.13L39,178.76a24.22,24.22,0,0,1,0-34L174.91,7.13a.93.93,0,0,0,.14-.14A24.1,24.1,0,0,1,209,7l.14.14L345,144.72a24.22,24.22,0,0,1,0,34Z"]],
    "level-up-alt": [320, 512, [], "f3bf", ["M232 160v328a24 24 0 0 1-24 24H12a12 12 0 0 1-8.48-20.48l56-56A12 12 0 0 1 68 432h84V160z", "M88 160c-20.94 0-31.76-25-17.6-40.33l104-112c.4-.43.82-.86 1.26-1.26a24 24 0 0 1 33.91 1.26l104 112C327.82 135 316.84 160 296 160z"]],
    "life-ring": [512, 512, [], "f1cd", ["M292.08 167l-.41-.17zm-66.62-2a96.5 96.5 0 0 1 61.08 0l112-112a248 248 0 0 0-285 0zm68.67 2.92l.52.22zm2.49 1.12l.46.21zM186.25 322l-.19-.21zm-5.51-6.36l.21.26zm1.65 2c.12.14.23.28.35.41-.12-.15-.23-.29-.35-.43zm1.74 2l.36.4zm135.51-135.51l.4.36zM177.51 311.29l-.1-.15zM304.18 173l.34.19zm11.42 7.78l.26.21zm6.36 5.51l-.21-.19zm-3.96-3.55l-.42-.35zm-11.6-8.43l.47.29zm4.68 3.09l.17.12zm-2-1.35l-.43-.29zm-9.71-5.68l-.1-.05zm-123.61 32.91c.1-.14.19-.28.28-.42-.04.14-.18.28-.28.42zm-1.45 2.28l.29-.46zm-1.31 2.25l.19-.32zm-2.6 4.77zm10.38-16.18l.21-.26zm2-2.43c-.12.13-.23.27-.35.41.08-.14.19-.28.31-.38zm-5.33 6.89l.1-.15zm-8.2 14.07c-.07.14-.13.29-.2.43.03-.14.09-.29.16-.43zm5.39 92l-.29-.46zm-4.27-7.53v.05zm2.82 5.14l-.19-.32zm2.61 4.21c.1.14.19.28.28.42-.08-.17-.22-.31-.32-.45zm-6.8-12.11c.07.14.13.29.2.43-.06-.14-.12-.29-.2-.43zm-2-76.7c0 .13-.1.25-.16.38.07-.13.16-.25.16-.38zm1.09-2.58c-.07.17-.15.34-.22.5.13-.16.13-.33.23-.5zm-.22 76.78c.07.16.15.33.22.5-.09-.17-.09-.34-.21-.5zm-1-2.46c.06.13.11.25.16.38-.03-.13-.12-.25-.18-.38zm172-84.19l.19.32zM327.51 320l.36-.4zm-1.57 1.71l-.19.21zM325.75 190l.19.21zm3.51 128c.12-.13.23-.27.35-.41-.12.17-.23.31-.35.41zm2-121.63l-.21-.26zm0 119.2l-.21.26zm-1.65-121.22c-.12-.14-.23-.28-.35-.41.12.16.23.3.35.44zm-1.74-2l-.36-.4zm6.62 8.35l.1.15zm.1 110.43l-.1.15zM398.49 53q2 1.41 4 2.85-2-1.43-4-2.85zM343.9 294.64c.07-.17.15-.34.22-.5-.07.16-.12.33-.22.5zm1.09-2.58c.05-.13.1-.25.16-.38-.06.13-.15.25-.15.38zm-3.35 7.36v-.05zm-5.4 9.3l-.28.42zm1.45-2.28l-.29.46zm1.35-2.25l-.19.32zm3.75-7.12c.07-.14.13-.29.2-.43-.07.14-.13.29-.2.43zM449 100.21q-1.41-1.75-2.85-3.46 1.39 1.71 2.85 3.46zM445.49 96c-1-1.18-2-2.35-3-3.51 1 1.19 2.01 2.36 3 3.51zm6.87 8.5q-1.36-1.74-2.76-3.5 1.4 1.76 2.76 3.53zm3.36 4.44c-.91-1.23-1.83-2.44-2.75-3.65.92 1.24 1.84 2.45 2.75 3.71zm-119.48 94.34l-.28-.42zm66.76-147q1.85 1.36 3.66 2.76-1.78-1.39-3.66-2.76zm12.23 9.62q-1.72-1.44-3.47-2.85 1.77 1.41 3.5 2.85zM411 62.4q-1.74-1.4-3.51-2.77Q409.24 61 411 62.4zm8.5 7.13q-1.74-1.53-3.51-3 1.75 1.47 3.49 3zm-75.38 148.33c-.07-.16-.15-.33-.22-.5.1.17.15.34.22.5zM184.49 192l-.36.4zM343 215.36c-.07-.14-.13-.29-.2-.43.06.14.12.29.2.43zm113.16-105.8c1 1.31 1.9 2.62 2.84 3.94-.95-1.32-1.89-2.63-2.85-3.94zM337.4 205.1l.29.46zm82.53-135.18a248.82 248.82 0 0 1 22.14 22.15 250.17 250.17 0 0 0-22.14-22.15zm-74.78 150.4a6.15 6.15 0 0 1-.16-.38c.01.13.1.25.16.38zM459 398.49a248 248 0 0 0 0-285L347 225.46a96.5 96.5 0 0 1 0 61.08zM341.67 212.63zM220.33 345.15l-.41-.17zm-2.46-1l-.52-.22zm-5.3-2.49l.1.05zM322 325.75l-.21.19zM309.14 336l-.43.29zm2-1.35l.17-.12zm4.48-3.34l.26-.21zm4-3.39l.4-.36zm-1.6 1.39l-.42.35zM215.38 343l-.46-.21zm-19-11.74l-.26-.21zm-4-3.39l-.4-.36zm-6.3-137.62l.19-.21zm4 135.5l.21.19zm15.52 11.94l-.47-.29zm2.26 1.35l-.34-.19zm78.72 8a96.5 96.5 0 0 1-61.08 0L113.51 459a248 248 0 0 0 285 0zM202.86 336l.43.29zm-2-1.35l-.17-.12zM416 445.49q1.77-1.49 3.51-3-1.77 1.51-3.51 3zm43-47c-.93 1.33-1.88 2.64-2.84 3.95.95-1.31 1.9-2.62 2.84-3.95zM411.79 449q1.74-1.41 3.47-2.85-1.72 1.39-3.47 2.85zm-4.32 3.42q1.77-1.38 3.51-2.77-1.74 1.35-3.51 2.72zM455.72 403q-1.37 1.85-2.76 3.66 1.4-1.78 2.76-3.66zm-10.23 13c-1 1.18-2 2.35-3 3.51 1-1.19 2.01-2.36 3-3.51zm3.46-4.18q-1.41 1.74-2.85 3.47 1.44-1.75 2.9-3.5zm.65-.81q1.39-1.74 2.77-3.51-1.37 1.74-2.77 3.5zm-150.17-69.38a.31.31 0 0 1-.1.05.31.31 0 0 0 .1-.05zm-5.3 2.49l.52-.22zm12.31-6.43l.47-.29zm-9.82 5.31l.46-.21zm7.56-4l.34-.19zm137.9 80.89a248.94 248.94 0 0 1-22.15 22.15 248.94 248.94 0 0 0 22.15-22.11zm-39.63 36.21q-2 1.44-4 2.85 2.04-1.37 4-2.81zM292.08 345l-.41.17zM403 455.72q1.85-1.37 3.66-2.76-1.78 1.4-3.66 2.76zM194 329.26l.42.35zM69.93 92.07a248.82 248.82 0 0 1 22.14-22.15 250.17 250.17 0 0 0-22.14 22.15zm30.28-29q-1.74 1.41-3.47 2.85 1.73-1.46 3.47-2.87zm90 123l-.21.19zm4.13-3.67l-.42.35zM109.55 55.86q2-1.44 4-2.85-2.03 1.41-4 2.85zM196.14 181l.26-.21zM104.53 59.63Q102.76 61 101 62.4q1.76-1.4 3.53-2.77zm.78-.59q1.81-1.4 3.66-2.76-1.84 1.37-3.66 2.72zm87.05 125.09l-.4.36zm22.56-14.92l.46-.21zm-2.25 1.11l-.1.05zm4.68-2.22l.52-.22zm2.57-1.08l.41-.17zm-17.06 9l.43-.29zm5-3.09l-.34.19zm-7.11 4.56l.17-.12zm4.38-2.92l.47-.29zM96.74 446.1q1.73 1.44 3.47 2.85-1.74-1.41-3.47-2.85zm-33.69-34.31q1.41 1.74 2.85 3.47-1.44-1.72-2.85-3.47zm3.46 4.21c1 1.18 2 2.35 3 3.51-1-1.19-2.01-2.36-3-3.51zm-10.23-13q1.36 1.85 2.76 3.66-1.39-1.78-2.76-3.66zm3.35 4.44q1.37 1.8 2.77 3.56-1.4-1.76-2.77-3.53zm32.89 35q1.74 1.53 3.51 3-1.77-1.44-3.51-2.97zM105.31 453q1.81 1.4 3.66 2.76-1.84-1.4-3.66-2.76zm8.2 6q-2-1.41-4-2.85 2.01 1.43 4 2.85zM101 449.6q1.74 1.39 3.51 2.77-1.75-1.37-3.51-2.77zm-45.15-47.16c-1-1.31-1.9-2.62-2.84-3.95.99 1.33 1.88 2.64 2.84 3.95zM65.9 96.75q-1.44 1.71-2.85 3.46 1.41-1.75 2.85-3.46zM56.29 109c.9-1.23 1.82-2.45 2.74-3.65-.92 1.17-1.84 2.39-2.74 3.65zm6.11-8q-1.4 1.74-2.76 3.51Q61 102.76 62.4 101zm7.12-8.5c-1 1.16-2 2.33-3 3.51.98-1.16 1.99-2.33 3-3.49zm23-23q1.74-1.53 3.51-3-1.77 1.5-3.51 3.03zm-.45 372.55a248.94 248.94 0 0 1-22.15-22.15 248.94 248.94 0 0 0 22.15 22.18zM165 286.54a96.5 96.5 0 0 1 0-61.08L53 113.51a248 248 0 0 0 0 285zm-109.11-177q-1.44 2-2.84 3.93 1.36-1.95 2.8-3.9z", "M347 225.46l112-111.95A249.4 249.4 0 0 0 398.49 53L286.54 165A96.26 96.26 0 0 1 347 225.46zm-182 61.08l-112 112a249.4 249.4 0 0 0 60.5 60.5L225.46 347A96.26 96.26 0 0 1 165 286.54zm-112-173l112 112a96.26 96.26 0 0 1 60.5-60.5L113.51 53A249.4 249.4 0 0 0 53 113.51zM286.54 347l112 112a249.4 249.4 0 0 0 60.5-60.5L347 286.54A96.26 96.26 0 0 1 286.54 347z"]],
    "lightbulb": [352, 512, [], "f0eb", ["M175.45 0C73.44.31 0 83 0 176a175 175 0 0 0 43.56 115.78c16.52 18.85 42.36 58.22 52.21 91.45 0 .26.07.52.11.78h160.24c0-.26.07-.51.11-.78 9.85-33.22 35.69-72.6 52.21-91.45A175.9 175.9 0 0 0 175.45 0zm.55 96a80.09 80.09 0 0 0-80 80 16 16 0 0 1-32 0A112.12 112.12 0 0 1 176 64a16 16 0 0 1 0 32z", "M96.06 454.35L96 416h160v38.35a32 32 0 0 1-5.41 17.65l-17.09 25.73A32 32 0 0 1 206.86 512h-61.71a32 32 0 0 1-26.64-14.28L101.42 472a32 32 0 0 1-5.36-17.65z"]],
    "lightbulb-dollar": [352, 512, [], "f670", ["M175.45 0C73.44.31 0 83 0 176a175 175 0 0 0 43.56 115.78c16.52 18.85 42.36 58.22 52.21 91.45 0 .26.07.52.11.78h160.24c0-.26.07-.51.11-.78 9.85-33.22 35.69-72.6 52.21-91.45A175.9 175.9 0 0 0 175.45 0zM192 255.88V272a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-16.29a57.26 57.26 0 0 1-31.37-11.35 8 8 0 0 1-.57-12.14L139.81 221a8.21 8.21 0 0 1 10.13-.73 24.08 24.08 0 0 0 12.82 3.73h28.11c6.5 0 11.8-5.92 11.8-13.19 0-5.95-3.61-11.19-8.77-12.73l-45-13.5c-18.59-5.58-31.58-23.42-31.58-43.39 0-24.52 19.05-44.44 42.67-45.07V80a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v16.29a57.18 57.18 0 0 1 31.37 11.35 8 8 0 0 1 .57 12.14L212.18 131a8.21 8.21 0 0 1-10.13.73 24 24 0 0 0-12.82-3.73h-28.11c-6.5 0-11.8 5.92-11.8 13.19 0 5.95 3.61 11.19 8.77 12.73l45 13.5c18.59 5.58 31.58 23.42 31.58 43.39 0 24.53-19.05 44.44-42.67 45.07z", "M96 416v38.35a32 32 0 0 0 5.42 17.65l17.09 25.69A32 32 0 0 0 145.15 512h61.71a32 32 0 0 0 26.64-14.28L250.59 472a32 32 0 0 0 5.41-17.65V416zm52.9-231.42l45 13.5c5.16 1.54 8.77 6.78 8.77 12.73 0 7.27-5.3 13.19-11.8 13.19h-28.11a24.08 24.08 0 0 1-12.82-3.72 8.21 8.21 0 0 0-10.13.73l-11.75 11.21a8 8 0 0 0 .57 12.14A57.26 57.26 0 0 0 160 255.71V272a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-16.12c23.62-.63 42.67-20.54 42.67-45.07 0-20-13-37.81-31.58-43.39l-45-13.5c-5.16-1.54-8.77-6.78-8.77-12.73 0-7.27 5.3-13.19 11.8-13.19h28.11a24 24 0 0 1 12.82 3.72 8.21 8.21 0 0 0 10.13-.73l11.75-11.21a8 8 0 0 0-.57-12.14A57.18 57.18 0 0 0 192 96.29V80a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v16.12c-23.62.63-42.67 20.55-42.67 45.07-.01 19.97 12.98 37.81 31.57 43.39z"]],
    "lightbulb-exclamation": [352, 512, [], "f671", ["M175.45 0C73.44.31 0 83 0 176a175 175 0 0 0 43.56 115.78c16.52 18.85 42.36 58.22 52.21 91.45 0 .26.07.52.11.78h160.24c0-.26.07-.51.11-.78 9.85-33.22 35.69-72.6 52.21-91.45A175.9 175.9 0 0 0 175.45 0zm.55 320a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm38.24-238.41l-12.8 128A16 16 0 0 1 185.52 224h-19a16 16 0 0 1-15.92-14.41l-12.8-128A16 16 0 0 1 153.68 64h44.64a16 16 0 0 1 15.92 17.59z", "M176 256a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm-25.44-46.41A16 16 0 0 0 166.48 224h19a16 16 0 0 0 15.92-14.41l12.8-128A16 16 0 0 0 198.32 64h-44.64a16 16 0 0 0-15.92 17.59zM96 416v38.35a32 32 0 0 0 5.42 17.65l17.09 25.69A32 32 0 0 0 145.15 512h61.71a32 32 0 0 0 26.64-14.28L250.59 472a32 32 0 0 0 5.41-17.65V416z"]],
    "lightbulb-on": [640, 512, [], "f672", ["M319.45 0C217.44.31 144 83 144 176a175 175 0 0 0 43.56 115.78c16.52 18.85 42.36 58.23 52.21 91.45 0 .26.07.52.11.78h160.24c0-.26.07-.51.11-.78 9.85-33.22 35.69-72.6 52.21-91.45A175.9 175.9 0 0 0 319.45 0zm.55 96a80.09 80.09 0 0 0-80 80 16 16 0 0 1-32 0A112.12 112.12 0 0 1 320 64a16 16 0 0 1 0 32z", "M112.81 160H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h101.78a209.51 209.51 0 0 1-4.97-64zM40.73 67.71l80.88 46.69a203.27 203.27 0 0 1 28.12-57.66l-77-44.46a16 16 0 0 0-21.86 5.86l-16 27.71a16 16 0 0 0 5.86 21.86zm91 196l-91 52.55a16 16 0 0 0-5.86 21.86l16 27.71a16 16 0 0 0 21.86 5.86l94.42-54.51c-.88-1.06-1.83-2.27-2.64-3.18a207.68 207.68 0 0 1-32.76-50.26zm467.52 52.55l-91.49-52.82c-8.24 17.65-18.23 34.52-31.28 49.4-1.1 1.26-2.36 2.85-3.59 4.37l94.36 54.48a16 16 0 0 0 21.86-5.86l16-27.71a16 16 0 0 0-5.84-21.83zm0-248.58a16 16 0 0 0 5.86-21.86l-16-27.71a16 16 0 0 0-21.86-5.86l-77.08 44.5a207.31 207.31 0 0 1 28.46 57.47zM240.06 454.35a32 32 0 0 0 5.36 17.65l17.09 25.69A32 32 0 0 0 289.15 512h61.71a32 32 0 0 0 26.64-14.28L394.59 472a32 32 0 0 0 5.41-17.65V416H240zM624 160h-96.81c1.12 14.55 2.18 31.7-5.53 64H624a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "lightbulb-slash": [640, 512, [], "f673", ["M163.75 94.79C192.16 39.71 249 .2 319.45 0a175.9 175.9 0 0 1 133 291.78c-3.86 4.41-8.24 9.94-12.79 16.25l-197-152.29A80.16 80.16 0 0 1 320 96a16 16 0 1 0 0-32 112.16 112.16 0 0 0-104.22 71zm0 161.77a176 176 0 0 0 23.83 35.22c16.52 18.85 42.36 58.23 52.21 91.45 0 .26.07.52.11.78h88.74zM240 416v38.35a32 32 0 0 0 5.41 17.65l17.09 25.69A32 32 0 0 0 289.14 512h61.71a32 32 0 0 0 26.64-14.28L394.58 472a32 32 0 0 0 5.36-17.69V439.1L370 416z", "M3.37 31.45L23 6.18a16 16 0 0 1 22.47-2.81L633.82 458.1a16 16 0 0 1 2.82 22.45L617 505.82a16 16 0 0 1-22.46 2.81L6.18 53.9a16 16 0 0 1-2.81-22.45z"]],
    "lights-holiday": [640, 512, [], "f7b2", ["M147 236.07c-14.66-5.5-69.17-20-93.77 45.56-18.61 49.62 13 129.22 26.53 134.28s89.65-34 108.3-83.71c26.17-69.79-34.06-93.46-41.06-96.13zm173 20c-15.67 0-71.8 5.54-71.8 75.59 0 53 57.6 116.41 72 116.41s72-63.3 72-116.41c.01-74.59-64.67-75.59-72.2-75.59zm266.8 25.59c-24.6-65.59-79.11-51.06-93.8-45.59-7 2.64-67.24 26.31-41.06 96.13 18.65 49.73 94.81 88.77 108.3 83.71s45.18-84.63 26.57-134.25z", "M632.59 121.75c-38.09 22.4-81.09 40-127 53l20.35 56.14a82.79 82.79 0 0 0-60.2 22.28l-23.15-63.82a701.58 701.58 0 0 1-90.4 9.8v63.37a82.78 82.78 0 0 0-64 0v-63.37a699.63 699.63 0 0 1-90.4-9.8l-23.14 63.82a85.87 85.87 0 0 0-27.47-17.1 84.92 84.92 0 0 0-32.73-5.21l20.35-56.14c-45.89-13-88.89-30.6-127-53-7.9-4.6-10.1-15.1-5.2-22.9l17.5-27.4a16 16 0 0 1 21.8-5.1C118 110.75 216 135.07 320 135.07s202-24.3 278.1-68.7a16 16 0 0 1 21.79 5.1l17.5 27.4c4.9 7.78 2.7 18.28-4.8 22.88z"]],
    "line-columns": [512, 512, [], "f870", ["M496 288H304a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h192a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0 128H304a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h192a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-256H304a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h192a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-128H304a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h192a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z", "M208 288H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h192a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0 128H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h192a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-384H16A16 16 0 0 0 0 48v32a16 16 0 0 0 16 16h192a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm0 128H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h192a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "line-height": [640, 512, [], "f871", ["M626.29 224H269.71c-7.57 0-13.71 7.16-13.71 16v32c0 8.84 6.14 16 13.71 16h356.58c7.57 0 13.71-7.16 13.71-16v-32c0-8.84-6.14-16-13.71-16zm0 160H269.71c-7.57 0-13.71 7.16-13.71 16v32c0 8.84 6.14 16 13.71 16h356.58c7.57 0 13.71-7.16 13.71-16v-32c0-8.84-6.14-16-13.71-16zm0-320H269.71C262.14 64 256 71.16 256 80v32c0 8.84 6.14 16 13.71 16h356.58c7.57 0 13.71-7.16 13.71-16V80c0-8.84-6.14-16-13.71-16z", "M176 144c14.31 0 21.33-17.31 11.31-27.31l-80-80a16 16 0 0 0-22.62 0l-80 80C-4.64 126 .36 144 16 144h48v224H16c-14.29 0-21.31 17.31-11.29 27.31l80 80a16 16 0 0 0 22.62 0l80-80C196.64 386 191.64 368 176 368h-48V144z"]],
    "link": [512, 512, [], "f0c1", ["M44.45 252.59l37.11-37.1c9.84-9.84 26.78-3.3 27.29 10.6a184.45 184.45 0 0 0 9.69 52.72 16.08 16.08 0 0 1-3.78 16.61l-13.09 13.09c-28 28-28.9 73.66-1.15 102a72.07 72.07 0 0 0 102.32.51L270 343.79A72 72 0 0 0 270 242a75.64 75.64 0 0 0-10.34-8.57 16 16 0 0 1-6.95-12.6A39.86 39.86 0 0 1 264.45 191l21.06-21a16.06 16.06 0 0 1 20.58-1.74A152.05 152.05 0 0 1 327 400l-.36.37-67.2 67.2c-59.27 59.27-155.7 59.26-215 0s-59.26-155.72.01-214.98z", "M410.33 203.49c28-28 28.9-73.66 1.15-102a72.07 72.07 0 0 0-102.32-.49L242 168.21A72 72 0 0 0 242 270a75.64 75.64 0 0 0 10.34 8.57 16 16 0 0 1 6.94 12.6A39.81 39.81 0 0 1 247.55 321l-21.06 21.05a16.07 16.07 0 0 1-20.58 1.74A152.05 152.05 0 0 1 185 112l.36-.37 67.2-67.2c59.27-59.27 155.7-59.26 215 0s59.27 155.7 0 215l-37.11 37.1c-9.84 9.84-26.78 3.3-27.29-10.6a184.45 184.45 0 0 0-9.69-52.72 16.08 16.08 0 0 1 3.78-16.61z"]],
    "lips": [640, 512, [], "f600", ["M639.88 224a63 63 0 0 1-4.88 28.05C607 318.51 522.4 480 360.71 480h-81.43C117.59 480 33 318.51 5 252.06A62.88 62.88 0 0 1 .12 224H64s85.34 96 256 96 256-96 256-96z", "M.12 224a61.44 61.44 0 0 1 8.74-28.32C60.53 110 173.69 32 222.28 32c0 0 32.57 0 97.72 50 65.15-50 97.72-50 97.72-50 48.59 0 161.75 78 213.42 163.68a61.6 61.6 0 0 1 8.74 28.32H576s-64-32-160-32l-35.38 8.84A252.29 252.29 0 0 1 320 208a252.29 252.29 0 0 1-60.62-7.16L224 192c-96 0-160 32-160 32z"]],
    "lira-sign": [384, 512, [], "f195", ["M0 232.82v41a11.71 11.71 0 0 0 .29 2.63 12 12 0 0 0 14.31 9.11l49.4-11V209L9.4 221.11A12 12 0 0 0 0 232.82zm0-96v41a11.71 11.71 0 0 0 .29 2.63 12 12 0 0 0 14.31 9.11l49.4-11V113L9.4 125.11A12 12 0 0 0 0 136.82zm287.71-61.24a12 12 0 0 0-14.31-9.12L144 95.22v65.56l134.6-29.88a12 12 0 0 0 9.4-11.72v-41a11.91 11.91 0 0 0-.29-2.6zm-14.31 86.88L144 191.22v65.56l134.6-29.89a12 12 0 0 0 9.4-11.71v-41a12 12 0 0 0-14.6-11.72z", "M64 468V44a12 12 0 0 1 12-12h56a12 12 0 0 1 12 12v372c86.18 0 168-48 168-148.75 0-6.34 5.64-11.25 12-11.25h48a12 12 0 0 1 12 12v.42C378.84 402.17 289.67 480 155.58 480H76a12 12 0 0 1-12-12z"]],
    "list": [512, 512, [], "f03a", ["M496 384H176a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-320H176a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16V80a16 16 0 0 0-16-16zm0 160H176a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M80 368H16a16 16 0 0 0-16 16v64a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16v-64a16 16 0 0 0-16-16zm0-320H16A16 16 0 0 0 0 64v64a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16V64a16 16 0 0 0-16-16zm0 160H16a16 16 0 0 0-16 16v64a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16v-64a16 16 0 0 0-16-16z"]],
    "list-alt": [512, 512, [], "f022", ["M464 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zM128 392a40 40 0 1 1 40-40 40 40 0 0 1-40 40zm0-96a40 40 0 1 1 40-40 40 40 0 0 1-40 40zm0-96a40 40 0 1 1 40-40 40 40 0 0 1-40 40zm288 168a12 12 0 0 1-12 12H204a12 12 0 0 1-12-12v-32a12 12 0 0 1 12-12h200a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12H204a12 12 0 0 1-12-12v-32a12 12 0 0 1 12-12h200a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12H204a12 12 0 0 1-12-12v-32a12 12 0 0 1 12-12h200a12 12 0 0 1 12 12z", "M128 200a40 40 0 1 0-40-40 40 40 0 0 0 40 40zm0 16a40 40 0 1 0 40 40 40 40 0 0 0-40-40zm0 96a40 40 0 1 0 40 40 40 40 0 0 0-40-40z"]],
    "list-music": [512, 512, [], "f8c9", ["M272 192H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h256a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-128H16A16 16 0 0 0 0 80v32a16 16 0 0 0 16 16h256a16 16 0 0 0 16-16V80a16 16 0 0 0-16-16zM144 320H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M192 432c0 44.18 50.14 80 112 80s112-35.82 112-80V148.15l73-21.39a32 32 0 0 0 23-30.71V32a32 32 0 0 0-41.06-30.67l-96.53 28.51A32 32 0 0 0 352 60.34V360a148.76 148.76 0 0 0-48-8c-61.86 0-112 35.82-112 80z"]],
    "list-ol": [512, 512, [], "f0cb", ["M496 224H176a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-160H176a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16V80a16 16 0 0 0-16-16zm0 320H176a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M61.77 401l17.5-20.15a19.92 19.92 0 0 0 5.07-14.19v-3.31C84.34 356 80.5 352 73 352H16a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h22.83a157.41 157.41 0 0 0-11 12.31l-5.61 7c-4 5.07-5.25 10.13-2.8 14.88l1.05 1.93c3 5.76 6.29 7.88 12.25 7.88h4.73c10.33 0 15.94 2.44 15.94 9.09 0 4.72-4.2 8.22-14.36 8.22a41.54 41.54 0 0 1-15.47-3.12c-6.49-3.88-11.74-3.5-15.6 3.12l-5.59 9.31c-3.72 6.13-3.19 11.72 2.63 15.94 7.71 4.69 20.38 9.44 37 9.44 34.16 0 48.5-22.75 48.5-44.12-.03-14.38-9.12-29.76-28.73-34.88zM16 160h64a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8H64V40a8 8 0 0 0-8-8H32a8 8 0 0 0-7.14 4.42l-8 16A8 8 0 0 0 24 64h8v64H16a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8zm-3.91 160H80a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8H41.32c3.29-10.29 48.34-18.68 48.34-56.44 0-29.06-25-39.56-44.47-39.56-21.36 0-33.8 10-40.46 18.75-4.37 5.59-3 10.84 2.8 15.37l8.58 6.88c5.61 4.56 11 2.47 16.12-2.44a13.44 13.44 0 0 1 9.46-3.84c3.33 0 9.28 1.56 9.28 8.75C51 248.19 0 257.31 0 304.59v4C0 316 5.08 320 12.09 320z"]],
    "list-ul": [512, 512, [], "f0ca", ["M496 384H176a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-320H176a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16V80a16 16 0 0 0-16-16zm0 160H176a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h320a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M48 48a48 48 0 1 0 48 48 48 48 0 0 0-48-48zm0 160a48 48 0 1 0 48 48 48 48 0 0 0-48-48zm0 160a48 48 0 1 0 48 48 48 48 0 0 0-48-48z"]],
    "location": [512, 512, [], "f601", ["M344 256a88 88 0 1 1-88-88 88 88 0 0 1 88 88z", "M496 224h-50.88A191.86 191.86 0 0 0 288 66.88V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v50.88A191.86 191.86 0 0 0 66.88 224H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h50.88A191.86 191.86 0 0 0 224 445.12V496a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-50.88A191.86 191.86 0 0 0 445.12 288H496a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM256 384a128 128 0 1 1 128-128 128 128 0 0 1-128 128z"]],
    "location-arrow": [512, 512, [], "f124", ["M461.91 0a45 45 0 0 0-17.4 3.52L28.73 195.42c-48 22.39-32 92.75 19.19 92.75h175.91v175.91c0 30 24.21 47.94 48.74 47.94 17.3 0 34.76-8.91 44-28.75L508.48 67.49C522.06 34.89 494.14 0 461.91 0zM303.83 320V208.17H192l207.67-95.85z", "M399.68 112.32L303.83 320V208.17H192l207.67-95.85"]],
    "location-circle": [496, 512, [], "f602", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8ZM358.24,177.74,262.29,385.63c-11.2,24-46.38,16-46.38-9.59V288H128c-25.59,0-33.58-35.18-9.59-46.38L326.3,145.71c19.15-8,39.94,12.84,31.94,32Z", "M118.36,241.7l207.89-95.95c19.2-8,40,12.8,32,32l-96,207.88c-11.2,24-46.38,16-46.38-9.59V288H128c-25.64,0-33.63-35.14-9.64-46.34Z"]],
    "location-slash": [640, 512, [], "f603", ["M189.36 115.58A191.34 191.34 0 0 1 288 66.88V16a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v50.88A191.86 191.86 0 0 1 509.12 224H560a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16h-50.88a190.53 190.53 0 0 1-20.3 59l-51.51-39.81A128 128 0 0 0 240.87 155.4zM320 384a127.93 127.93 0 0 1-125.55-103.7L121.61 224H80a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h50.88A191.86 191.86 0 0 0 288 445.12V496a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-50.88c14.07-2.37 27.35-6.75 40.19-12l-64.57-49.9c-2.57.16-5.01.78-7.62.78zm0-216a87.6 87.6 0 0 0-46 13l130.2 100.63A88 88 0 0 0 320 168z", "M3.37 32.45L23 7.18a16 16 0 0 1 22.47-2.81L633.82 459.1a16 16 0 0 1 2.82 22.45L617 506.82a16 16 0 0 1-22.46 2.81L6.18 54.9a16 16 0 0 1-2.81-22.45z"]],
    "lock": [448, 512, [], "f023", ["M152 224H72v-72C72 68.2 140.2 0 224 0s152 68.2 152 152v72h-80v-72a72 72 0 0 0-144 0z", "M448 272v192a48 48 0 0 1-48 48H48a48 48 0 0 1-48-48V272a48 48 0 0 1 48-48h352a48 48 0 0 1 48 48z"]],
    "lock-alt": [448, 512, [], "f30d", ["M152 225H72v-72C72 69.2 140.2 1 224 1s152 68.2 152 152v72h-80v-72a72 72 0 0 0-144 0z", "M400 225H48a48 48 0 0 0-48 48v192a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V273a48 48 0 0 0-48-48zM264 392a40 40 0 0 1-80 0v-48a40 40 0 0 1 80 0z"]],
    "lock-open": [576, 512, [], "f3c1", ["M576 152v80a23.94 23.94 0 0 1-24 24h-32a23.94 23.94 0 0 1-24-24v-80a72.11 72.11 0 0 0-72.7-72c-39.6.4-71.3 33.3-71.3 72.9V224h-80v-70.5C272 69.5 339.5.3 423.5 0S576 68 576 152z", "M448 272v192a48 48 0 0 1-48 48H48a48 48 0 0 1-48-48V272a48 48 0 0 1 48-48h352a48 48 0 0 1 48 48z"]],
    "lock-open-alt": [576, 512, [], "f3c2", ["M576 152v80a23.94 23.94 0 0 1-24 24h-32a23.94 23.94 0 0 1-24-24v-80a72.11 72.11 0 0 0-72.7-72c-39.6.4-71.3 33.3-71.3 72.9V224h-80v-70.5C272 69.5 339.5.3 423.5 0S576 68 576 152z", "M400 224H48a48 48 0 0 0-48 48v192a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V272a48 48 0 0 0-48-48zM264 392a40 40 0 0 1-80 0v-48a40 40 0 0 1 80 0z"]],
    "long-arrow-alt-down": [256, 512, [], "f309", ["M168.11 44v301.94h-80V44a12 12 0 0 1 12-12h56a12 12 0 0 1 12 12z", "M231.17 386.94L145.08 473a24 24 0 0 1-33.94 0l-86.06-86.09c-15.12-15.12-4.41-41 17-41h172.09c21.38.03 32.09 25.88 17 41.03z"]],
    "long-arrow-alt-left": [448, 512, [], "f30a", ["M436.13 296H134.19v-80h301.94a12 12 0 0 1 12 12v56a12 12 0 0 1-12 12z", "M93.19 359.07L7.13 273a24 24 0 0 1 0-33.94L93.22 153c15.12-15.12 41-4.41 41 17v172.09c-.03 21.36-25.88 32.07-41.03 16.98z"]],
    "long-arrow-alt-right": [448, 512, [], "f30b", ["M12.1 216H314v80H12.1a12 12 0 0 1-12-12v-56a12 12 0 0 1 12-12z", "M355 153l86.06 86.09a24 24 0 0 1 0 33.94L355 359.05c-15.12 15.12-41 4.41-41-17V170c0-21.42 25.89-32.13 41-17z"]],
    "long-arrow-alt-up": [256, 512, [], "f30c", ["M88.12 468V166.09h80V468a12 12 0 0 1-12 12h-56a12 12 0 0 1-12-12z", "M25.06 125.09L111.15 39a24 24 0 0 1 33.94 0l86.06 86.09c15.12 15.12 4.41 41-17 41H42.06c-21.38 0-32.06-25.85-17-41z"]],
    "long-arrow-down": [320, 512, [], "f175", ["M124 351.93V56a24 24 0 0 1 24-24h24a24 24 0 0 1 24 24v295.93l-36 35.67z", "M313 337.46L177.48 473l-.06.06a25.23 25.23 0 0 1-34.84 0l-.06-.06L7 337.46a24 24 0 0 1 0-33.94l17-17a24 24 0 0 1 33.94 0L160 387.6l102-101.08a24 24 0 0 1 33.94 0l17 17a24 24 0 0 1 .06 33.94z"]],
    "long-arrow-left": [448, 512, [], "f177", ["M128.09 220H424a24 24 0 0 1 24 24v24a24 24 0 0 1-24 24H128.09l-35.66-36z", "M142.56 409L7 273.5v-.06a25.23 25.23 0 0 1 0-34.84l.06-.06 135.5-135.49a24 24 0 0 1 33.94 0l17 17a24 24 0 0 1 0 33.94L92.43 256 193.5 358a24 24 0 0 1 0 33.94l-17 17a24 24 0 0 1-33.94.06z"]],
    "long-arrow-right": [448, 512, [], "f178", ["M319.91 292H24a24 24 0 0 1-24-24v-24a24 24 0 0 1 24-24h295.91l35.66 36z", "M305.44 103.05L441 238.54l.06.06a25.23 25.23 0 0 1 0 34.84l-.06.06L305.44 409a24 24 0 0 1-33.94 0l-17-17a24 24 0 0 1 0-33.94L355.57 256 254.5 154a24 24 0 0 1 0-33.94l17-17a24 24 0 0 1 33.94-.01z"]],
    "long-arrow-up": [320, 512, [], "f176", ["M196 160.11V456a24 24 0 0 1-24 24h-24a24 24 0 0 1-24-24V160.11l36-35.66z", "M7 174.58L142.52 39l.06-.06a25.23 25.23 0 0 1 34.84 0l.06.06L313 174.58a24 24 0 0 1 0 33.94l-17 17a24 24 0 0 1-33.94 0L160 124.45 58 225.52a24 24 0 0 1-33.94 0l-17-17A24 24 0 0 1 7 174.58z"]],
    "loveseat": [512, 512, [], "f4cc", ["M160 288v-64a64.06 64.06 0 0 0-64-64H64a96 96 0 0 1 96-96h192a96 96 0 0 1 96 96h-32a64.06 64.06 0 0 0-64 64v64z", "M512 256a63.84 63.84 0 0 1-32 55.1V432a16 16 0 0 1-16 16h-64a16 16 0 0 1-16-16v-16H128v16a16 16 0 0 1-16 16H48a16 16 0 0 1-16-16V311.1A63.79 63.79 0 0 1 64 192h32a32 32 0 0 1 32 32v96h256v-96a32 32 0 0 1 32-32h32a64.06 64.06 0 0 1 64 64z"]],
    "low-vision": [576, 512, [], "f2a8", ["M320 192a32 32 0 0 0 60.57 14.41A105 105 0 0 1 372 319L256.19 155.91a105.27 105.27 0 0 1 81.4 7.52A32 32 0 0 0 320 192zm249.34 39.63C513 136 407.81 72 288 72a329.94 329.94 0 0 0-83.75 10.74l33.31 46.92A135.86 135.86 0 0 1 288 120a135.93 135.93 0 0 1 136 136 135.47 135.47 0 0 1-33.38 89.27l43.16 60.79a324.33 324.33 0 0 0 135.56-125.69A47.88 47.88 0 0 0 576 256a47.88 47.88 0 0 0-6.66-24.37zm-398.9-85.94L142.25 106A324.78 324.78 0 0 0 6.68 231.61a48 48 0 0 0 0 48.74 324.92 324.92 0 0 0 172.83 141.4L55.32 244.33a272.12 272.12 0 0 1 28.29-35.91L203 379l40.63 58a329.89 329.89 0 0 0 78.94 1.17l-190-271.4a277.74 277.74 0 0 1 37.87-21.08z", "M469.76 498.48l-13.11 9.18a24 24 0 0 1-33.43-5.9L100.34 46.94a24 24 0 0 1 5.9-33.42l13.11-9.18a24 24 0 0 1 33.43 5.9l322.88 454.82a24 24 0 0 1-5.9 33.42z"]],
    "luchador": [448, 512, [], "f455", ["M372 160h-68c-37.9 0-69.3 28.3-77.5 66.2-.9-.7-4.2-.7-5.1 0C213.3 188.3 182 160 144 160H76a12 12 0 0 0-12 12v30.7c0 47.1 35.8 85.3 80 85.3h22.4a177.85 177.85 0 0 0-15.8 32.9A63.87 63.87 0 0 0 96 384c0 35.5 29.4 64 64.9 64H287c35.5 0 64.9-28.5 64.9-64a63.87 63.87 0 0 0-54.6-63.1 174.87 174.87 0 0 0-15.8-32.9H304c44.2 0 80-38.2 80-85.3V172a12 12 0 0 0-12-12zM224 266.7c20.2 19.9 31.9 38.5 38.7 53.3h-77.4c6.8-14.8 18.5-33.4 38.7-53.3zM144 256c-26.5 0-48-23.9-48-53.3V192h48c26.5 0 48 23.9 48 53.3v7.47a3.19 3.19 0 0 1-.85 2.17 3.21 3.21 0 0 1-2.36 1zm144 96a32 32 0 0 1 0 64H160a32 32 0 0 1 0-64zm64-149.3c0 29.4-21.5 53.3-48 53.3h-44.77a3.21 3.21 0 0 1-2.36-1 3.19 3.19 0 0 1-.85-2.17v-7.53c0-29.4 21.5-53.3 48-53.3h48z", "M224 0C100.3 0 0 100.3 0 224v128a160 160 0 0 0 160 160h128a160 160 0 0 0 160-160V224C448 100.3 347.7 0 224 0zm160 202.7c0 47.1-35.8 85.3-80 85.3h-22.5a174.87 174.87 0 0 1 15.8 32.9 63.87 63.87 0 0 1 54.6 63.1c0 35.5-29.4 64-64.9 64H160.9c-35.5 0-64.9-28.5-64.9-64a63.87 63.87 0 0 1 54.6-63.1 177.85 177.85 0 0 1 15.8-32.9H144c-44.2 0-80-38.2-80-85.3V172a12 12 0 0 1 12-12h68c38 0 69.3 28.3 77.4 66.2.9-.7 4.2-.7 5.1 0 8.2-37.9 39.6-66.2 77.5-66.2h68a12 12 0 0 1 12 12z"]],
    "luggage-cart": [640, 512, [], "f59d", ["M480 48a48 48 0 0 0-48-48h-96a48 48 0 0 0-48 48v272h192zm-48 48h-96V48h96zm-240 32v160a32 32 0 0 0 32 32h32V96h-32a32 32 0 0 0-32 32zm352-32h-32v224h32a32 32 0 0 0 32-32V128a32 32 0 0 0-32-32zm-93.26 352a48 48 0 1 0 90.52 0zm-288 0a48 48 0 1 0 90.52 0z", "M624 384H128V16a16 16 0 0 0-16-16H16A16 16 0 0 0 0 16v32a16 16 0 0 0 16 16h48v368a16 16 0 0 0 16 16h544a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM288 96h-32v224h32zm224 0h-32v224h32z"]],
    "lungs": [640, 512, [], "f604", ["M170.16 373.57L256 316.34v87.49c0 41.15-29.08 77.32-71.26 88.62l-59.5 15.95C62.48 525.22 0 481 0 419.78a114.68 114.68 0 0 1 3.89-29.63 821.31 821.31 0 0 1 102-231C128 124.56 142 96 186 96c38.64 0 70 29.42 70 65.71v60.11l-128 85.33a16 16 0 0 0-4.44 22.19l8.88 13.31a16 16 0 0 0 17.77 6.5 8 8 0 0 0 0 8.89l8.88 13.31a8 8 0 0 0 11.07 2.22zm466 16.58a821.31 821.31 0 0 0-102-231C512 124.56 498 96 454.05 96 415.36 96 384 125.42 384 161.71v60.11l128 85.33a16 16 0 0 1 4.44 22.19l-8.88 13.31a16 16 0 0 1-17.78 6.49 8 8 0 0 1 0 8.89l-8.88 13.31a8 8 0 0 1-11.08 2.22L384 316.34v87.49c0 41.15 29.08 77.31 71.26 88.62l59.5 15.95C577.52 525.22 640 481 640 419.78a114.68 114.68 0 0 0-3.89-29.63z", "M516.45 329.34l-8.88 13.31a16 16 0 0 1-22.19 4.44L320 236.84 154.63 347.09a16 16 0 0 1-22.19-4.44l-8.88-13.31a16 16 0 0 1 4.44-22.19L288.88 199.9a16 16 0 0 0 7.12-13.31V16a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v170.59a16 16 0 0 0 7.12 13.31L512 307.15a16 16 0 0 1 4.45 22.19z"]],
    "mace": [512, 512, [], "f6f8", ["M215.92 341.35l-166 166a16 16 0 0 1-22.63 0l-22.6-22.66a16 16 0 0 1 0-22.63l166-166a161.12 161.12 0 0 0 45.23 45.29z", "M501 195l-75-23.8a127.4 127.4 0 0 0-87.67-85.95L313.05 10.8C308.13-3.7 295.59-3.57 291 11l-23.8 75a127.43 127.43 0 0 0-86 87.67L106.8 199c-14.5 4.92-14.37 17.46.22 22.08l75 23.77a127.43 127.43 0 0 0 87.67 86l25.26 74.44c4.92 14.5 17.46 14.37 22.08-.22l23.77-75a127.4 127.4 0 0 0 85.95-87.67l74.44-25.26c14.51-5.01 14.38-17.55-.19-22.14zm-197 45a32 32 0 1 1 32-32 32 32 0 0 1-32 32z"]],
    "magic": [512, 512, [], "f0d0", ["M80 0L53.34 53.33 0 80l53.34 26.67L80 160l26.66-53.33L160 80l-53.34-26.67zm192 48l-32-16-16-32-16 32-32 16 32 16 16 32 16-32zm186.66 293.33L432 288l-26.66 53.33L352 368l53.34 26.67L432 448l26.66-53.33L512 368zM399 243.07l86.6-86.55 17-17a32 32 0 0 0 0-45.26l-17-17-50.86-50.86-17-17a32 32 0 0 0-45.25 0l-17 17L269 112.94l-39.62 39.6 39.61 39.61 50.91 50.91 39.59 39.58zm-90.5-90.52L395.14 66l50.91 50.91-86.6 86.55z", "M359.44 282.64l-220 220a32 32 0 0 1-45.25 0L9.38 417.77a32 32 0 0 1 0-45.25l220-220z"]],
    "magnet": [512, 512, [], "f076", ["M476.1 20h-104a36 36 0 0 0-36 36v80a12 12 0 0 0 12 12h152a11.89 11.89 0 0 0 12-11.9V56a36 36 0 0 0-36-36zm-336.1.1H36a36 36 0 0 0-36 36v80a12 12 0 0 0 12 12h152.1a11.89 11.89 0 0 0 11.9-12v-80a36 36 0 0 0-36-36z", "M512 192.2c-.2 20.2-.6 40.4 0 53.2 0 150.7-134.5 246.7-255.1 246.7S.1 396.1.1 245.5c.6-13 .1-31.9 0-53.3a12 12 0 0 1 12-12.1h152a12 12 0 0 1 12 12v52c0 127.9 160 128.1 160 0v-52a12 12 0 0 1 12-12H500a12 12 0 0 1 12 12.1z"]],
    "mail-bulk": [576, 512, [], "f674", ["M288 256H32a32 32 0 0 0-32 32v16c25.6 19.2 22.4 19.2 115.2 86.4 9.6 6.4 28.8 25.6 44.8 25.6s35.2-19.2 44.8-22.4c92.8-67.2 89.6-67.2 115.2-86.4V288a32 32 0 0 0-32-32zM160 448c-25.6 0-51.2-22.4-64-32-64-44.8-83.2-60.8-96-70.4V480a32 32 0 0 0 32 32h256a32 32 0 0 0 32-32V345.6c-12.8 9.6-32 25.6-96 70.4-12.8 9.6-38.4 32-64 32zm288-224v64h64v-64z", "M544 160H224a32 32 0 0 0-32 32v32h96a64.09 64.09 0 0 1 63.71 57.82l.29-.22V416h192a32 32 0 0 0 32-32V192a32 32 0 0 0-32-32zm-32 128h-64v-64h64zm-64-160V32a32 32 0 0 0-32-32H96a32 32 0 0 0-32 32v192h96v-32a64.07 64.07 0 0 1 64-64z"]],
    "mailbox": [576, 512, [], "f813", ["M432 64H144a144 144 0 0 1 144 144v208a32 32 0 0 1-32 32h288a32 32 0 0 0 32-32V208A144 144 0 0 0 432 64zm80 208a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-48h-56a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h104a16 16 0 0 1 16 16z", "M143.93 64C64.2 64 0 129.65 0 209.38V416a32 32 0 0 0 32 32h224a32 32 0 0 0 32-32V208A144 144 0 0 0 143.93 64zM224 240a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h128a16 16 0 0 1 16 16zm272-48H392a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h56v48a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-64a16 16 0 0 0-16-16z"]],
    "male": [192, 512, [], "f183", ["M32 64a64 64 0 1 1 64 64 64 64 0 0 1-64-64z", "M48 144h11.36a87.91 87.91 0 0 0 73.28 0H144a48 48 0 0 1 48 48v136a24 24 0 0 1-24 24h-16v136a24 24 0 0 1-24 24H64a24 24 0 0 1-24-24V352H24a24 24 0 0 1-24-24V192a48 48 0 0 1 48-48z"]],
    "mandolin": [512, 512, [], "f6f9", ["M278.63 278.63l-45.25-45.25 41.19-41.19C90.39 190.67 46 241 30.73 256.28c-46.8 46.79-39.51 150.36 17.54 207.45s160.66 64.34 207.45 17.53c15.28-15.26 65.6-59.64 64.08-243.8zM176 384a48 48 0 1 1 48-48 48 48 0 0 1-48 48z", "M509.56 70.48l-40.07 64a32 32 0 0 1-19.11 14L394.28 163 278.63 278.63l-45.25-45.25L349 117.74l14.51-56.12a32 32 0 0 1 14-19.11l64-40.07a16 16 0 0 1 19.81 2.25l46 46a16 16 0 0 1 2.24 19.79z"]],
    "map": [576, 512, [], "f279", ["M192 32l192 64v384l-192-64z", "M0 117.66V464a16 16 0 0 0 21.94 14.86L160 416V32L20.12 88A32 32 0 0 0 0 117.66zm554.06-84.5L416 96v384l139.88-55.95A32 32 0 0 0 576 394.34V48a16 16 0 0 0-21.94-14.84z"]],
    "map-marked": [576, 512, [], "f59f", ["M288 359.67a47.78 47.78 0 0 1-36.51-17C231.83 319.51 210.92 293.09 192 266v182l192 64V266c-18.92 27.09-39.82 53.52-59.49 76.72A47.8 47.8 0 0 1 288 359.67zM20.12 216A32 32 0 0 0 0 245.66V496a16 16 0 0 0 21.94 14.86L160 448V214.92a302.84 302.84 0 0 1-21.25-46.42zm533.94-54.79L416 224v288l139.88-55.95A32 32 0 0 0 576 426.34V176a16 16 0 0 0-21.94-14.84z", "M414 126c0 56.26-82.35 158.8-113.9 196a15.77 15.77 0 0 1-24.2 0C244.35 284.8 162 182.26 162 126a126 126 0 0 1 252 0z"]],
    "map-marked-alt": [576, 512, [], "f5a0", ["M554.06 161.16L416 224v288l139.88-55.95A32 32 0 0 0 576 426.34V176a16 16 0 0 0-21.94-14.84zM20.12 216A32 32 0 0 0 0 245.66V496a16 16 0 0 0 21.94 14.86L160 448V214.92a302.84 302.84 0 0 1-21.25-46.42zM288 359.67a47.78 47.78 0 0 1-36.51-17C231.83 319.51 210.92 293.09 192 266v182l192 64V266c-18.92 27.09-39.82 53.52-59.49 76.72A47.8 47.8 0 0 1 288 359.67z", "M288 0a126 126 0 0 0-126 126c0 56.26 82.35 158.8 113.9 196a15.77 15.77 0 0 0 24.2 0C331.65 284.8 414 182.26 414 126A126 126 0 0 0 288 0zm0 168a42 42 0 1 1 42-42 42 42 0 0 1-42 42z"]],
    "map-marker": [384, 512, [], "f041", ["M384 192c0 77.41-27 99-172.27 309.67a24 24 0 0 1-39.46 0C27 291 0 269.41 0 192 0 86 86 0 192 0s192 86 192 192z", ""]],
    "map-marker-alt": [384, 512, [], "f3c5", ["M192 0C86 0 0 86 0 192c0 77.41 27 99 172.27 309.67a24 24 0 0 0 39.46 0C357 291 384 269.41 384 192 384 86 298 0 192 0zm0 288a96 96 0 1 1 96-96 96 96 0 0 1-96 96z", "M192 256a64 64 0 1 1 64-64 64 64 0 0 1-64 64z"]],
    "map-marker-alt-slash": [640, 512, [], "f605", ["M157.4 89.88A191.85 191.85 0 0 1 320 0c106 0 192 86 192 192 0 46.83-9.88 73.25-49.83 133.43l-79.06-61.1a96 96 0 1 0-149-115.17zM300.8 502.4a24 24 0 0 0 38.4 0c18.6-26.69 35.23-50.32 50.14-71.47L131.47 231.62c10.71 52.55 50.15 99.78 169.33 270.78zM320 128a64 64 0 0 0-59.84 41.3L357 244.18A64 64 0 0 0 320 128z", "M3.37 31.45L23 6.18a16 16 0 0 1 22.47-2.81L633.82 458.1a16 16 0 0 1 2.82 22.45L617 505.82a16 16 0 0 1-22.46 2.81L6.18 53.9a16 16 0 0 1-2.81-22.45z"]],
    "map-marker-check": [384, 512, [], "f606", ["M192 0C86.4 0 0 86.4 0 192c0 76.8 25.6 99.2 172.8 310.4a24 24 0 0 0 38.4 0C358.4 291.2 384 268.8 384 192 384 86.4 297.6 0 192 0zm114.08 163.83l-131 130a11 11 0 0 1-15.55-.06l-75.76-76.34a11 11 0 0 1 .06-15.56l26-25.82a11 11 0 0 1 15.56.06l42.15 42.49 97.2-96.42a11 11 0 0 1 15.55.06l25.82 26a11 11 0 0 1-.03 15.59z", "M306.08 163.83l-131 130a11 11 0 0 1-15.55-.06l-75.76-76.34a11 11 0 0 1 .06-15.56l26-25.82a11 11 0 0 1 15.56.06l42.15 42.49 97.2-96.42a11 11 0 0 1 15.55.06l25.82 26a11 11 0 0 1-.03 15.59z"]],
    "map-marker-edit": [384, 512, [], "f607", ["M192 0C86.4 0 0 86.4 0 192c0 76.8 25.6 99.2 172.8 310.4a24 24 0 0 0 38.4 0C358.4 291.2 384 268.8 384 192 384 86.4 297.6 0 192 0zm-43.17 283.15L106 288a9 9 0 0 1-10-9.95l4.8-42.83 85.54-85.54 48 48zm133.91-133.9l-28.26 28.26-48-48 28.26-28.26a18 18 0 0 1 25.41 0l22.57 22.57a18 18 0 0 1 .02 25.43z", "M282.74 123.84l-22.57-22.57a18 18 0 0 0-25.41 0l-28.26 28.26 48 48 28.26-28.26a18 18 0 0 0-.02-25.43zM100.85 235.17L96.05 278a9 9 0 0 0 9.95 10l42.83-4.8 85.54-85.54-48-48z"]],
    "map-marker-exclamation": [384, 512, [], "f608", ["M192 0C86.4 0 0 86.4 0 192c0 76.8 25.6 99.2 172.8 310.4a24 24 0 0 0 38.4 0C358.4 291.2 384 268.8 384 192 384 86.4 297.6 0 192 0zm0 336a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm38.24-238.41l-12.8 128A16 16 0 0 1 201.52 240h-19a16 16 0 0 1-15.92-14.41l-12.8-128A16 16 0 0 1 169.68 80h44.64a16 16 0 0 1 15.92 17.59z", "M192 272a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm22.32-192h-44.64a16 16 0 0 0-15.92 17.59l12.8 128A16 16 0 0 0 182.48 240h19a16 16 0 0 0 15.92-14.41l12.8-128A16 16 0 0 0 214.32 80z"]],
    "map-marker-minus": [384, 512, [], "f609", ["M192 0C86.4 0 0 86.4 0 192c0 76.8 25.6 99.2 172.8 310.4a24 24 0 0 0 38.4 0C358.4 291.2 384 268.8 384 192 384 86.4 297.6 0 192 0zm112 200a16 16 0 0 1-16 16H96a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h192a16 16 0 0 1 16 16z", "M304 184v16a16 16 0 0 1-16 16H96a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h192a16 16 0 0 1 16 16z"]],
    "map-marker-plus": [384, 512, [], "f60a", ["M192 0C86.4 0 0 86.4 0 192c0 76.8 25.6 99.2 172.8 310.4a24 24 0 0 0 38.4 0C358.4 291.2 384 268.8 384 192 384 86.4 297.6 0 192 0zm112 200a16 16 0 0 1-16 16h-72v72a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-72H96a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h72V96a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v72h72a16 16 0 0 1 16 16z", "M304 200a16 16 0 0 1-16 16h-72v72a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-72H96a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h72V96a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v72h72a16 16 0 0 1 16 16z"]],
    "map-marker-question": [384, 512, [], "f60b", ["M192 0C86.4 0 0 86.4 0 192c0 76.8 25.6 99.2 172.8 310.4a24 24 0 0 0 38.4 0C358.4 291.2 384 268.8 384 192 384 86.4 297.6 0 192 0zm0 352a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm26.67-113.27v1.43A15.84 15.84 0 0 1 202.83 256h-16.32a15.84 15.84 0 0 1-15.84-15.84V224A24.09 24.09 0 0 1 184 202.5c30.61-15.31 50.67-26.54 50.67-42.5 0-19.39-14-40-40-40a40.06 40.06 0 0 0-38.2 28.12C154.32 155 148.36 160 141.14 160H124.3a15.92 15.92 0 0 1-15.44-19.55A88.14 88.14 0 0 1 194.67 72c55.08 0 88 44.75 88 88 0 41-32.75 62.47-64 78.73z", "M192 288a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm2.67-216a88.14 88.14 0 0 0-85.81 68.45A15.92 15.92 0 0 0 124.3 160h16.84c7.22 0 13.18-5 15.33-11.88a40.06 40.06 0 0 1 38.2-28.12c26 0 40 20.61 40 40 0 16-20.06 27.19-50.67 42.5a24.09 24.09 0 0 0-13.33 21.5v16.16A15.84 15.84 0 0 0 186.51 256h16.32a15.84 15.84 0 0 0 15.84-15.84v-1.43c31.25-16.26 64-37.78 64-78.73 0-43.25-32.92-88-88-88z"]],
    "map-marker-slash": [640, 512, [], "f60c", ["M157.4 89.88A191.85 191.85 0 0 1 320 0c106 0 192 86 192 192 0 46.83-9.88 73.25-49.83 133.43zM300.8 502.4a24 24 0 0 0 38.4 0c18.6-26.69 35.23-50.32 50.14-71.47L131.47 231.62c10.71 52.55 50.15 99.78 169.33 270.78z", "M3.37 31.45L23 6.18a16 16 0 0 1 22.47-2.81L633.82 458.1a16 16 0 0 1 2.82 22.45L617 505.82a16 16 0 0 1-22.46 2.81L6.18 53.9a16 16 0 0 1-2.81-22.45z"]],
    "map-marker-smile": [384, 512, [], "f60d", ["M192 0C86.4 0 0 86.4 0 192c0 76.8 25.6 99.2 172.8 310.4a24 24 0 0 0 38.4 0C358.4 291.2 384 268.8 384 192 384 86.4 297.6 0 192 0zm64 117.16A26.84 26.84 0 1 1 229.16 144 26.84 26.84 0 0 1 256 117.16zm-128 0A26.84 26.84 0 1 1 101.16 144 26.84 26.84 0 0 1 128 117.16zm164.17 141a132.31 132.31 0 0 1-200.33 0 16 16 0 0 1 24.32-20.78 100.31 100.31 0 0 0 151.67 0 16 16 0 1 1 24.34 20.79z", "M256 170.84A26.84 26.84 0 1 0 229.16 144 26.84 26.84 0 0 0 256 170.84zm-128 0A26.84 26.84 0 1 0 101.16 144 26.84 26.84 0 0 0 128 170.84zm162.39 64.72a16 16 0 0 0-22.56 1.78 100.31 100.31 0 0 1-151.67 0 16 16 0 0 0-24.32 20.78 132.31 132.31 0 0 0 200.33 0 16 16 0 0 0-1.78-22.56z"]],
    "map-marker-times": [384, 512, [], "f60e", ["M192 0C86.4 0 0 86.4 0 192c0 76.8 25.6 99.2 172.8 310.4a24 24 0 0 0 38.4 0C358.4 291.2 384 268.8 384 192 384 86.4 297.6 0 192 0zm84.85 242.91a16 16 0 0 1 0 22.63l-11.31 11.31a16 16 0 0 1-22.63 0L192 225.94l-50.91 50.91a16 16 0 0 1-22.63 0l-11.31-11.31a16 16 0 0 1 0-22.63L158.06 192l-50.91-50.91a16 16 0 0 1 0-22.63l11.31-11.31a16 16 0 0 1 22.63 0L192 158.06l50.91-50.91a16 16 0 0 1 22.63 0l11.31 11.31a16 16 0 0 1 0 22.63L225.94 192z", "M276.85 242.91a16 16 0 0 1 0 22.63l-11.31 11.31a16 16 0 0 1-22.63 0L192 225.94l-50.91 50.91a16 16 0 0 1-22.63 0l-11.31-11.31a16 16 0 0 1 0-22.63L158.06 192l-50.91-50.91a16 16 0 0 1 0-22.63l11.31-11.31a16 16 0 0 1 22.63 0L192 158.06l50.91-50.91a16 16 0 0 1 22.63 0l11.31 11.31a16 16 0 0 1 0 22.63L225.94 192z"]],
    "map-pin": [288, 512, [], "f276", ["M144 320a175.77 175.77 0 0 0 32-3.06v156.69l-22 33a12 12 0 0 1-20 0l-22-33V316.94a175.77 175.77 0 0 0 32 3.06z", "M144 0a144 144 0 1 0 144 144A144 144 0 0 0 144 0zm0 76a68.07 68.07 0 0 0-68 68 12 12 0 0 1-24 0 92.11 92.11 0 0 1 92-92 12 12 0 0 1 0 24z"]],
    "map-signs": [512, 512, [], "f277", ["M224 496a16 16 0 0 0 16 16h32a15.88 15.88 0 0 0 5.71-1.07l.52-.19.1-.05a16.08 16.08 0 0 0 5-3.38A15.91 15.91 0 0 0 288 496V384h-64zM272 0h-32a16 16 0 0 0-16 16v16h64V16a16 16 0 0 0-16-16zm-48 224h64v-32h-64z", "M456 224H70.63A32 32 0 0 0 48 233.37L4.69 276.69a16 16 0 0 0 0 22.63L48 342.63A32 32 0 0 0 70.63 352H456a24 24 0 0 0 24-24v-80a24 24 0 0 0-24-24zm51.31-139.31L464 41.37A32 32 0 0 0 441.37 32H56a24 24 0 0 0-24 24v80a24 24 0 0 0 24 24h385.37a32 32 0 0 0 22.63-9.37l43.31-43.31a16 16 0 0 0 0-22.63z"]],
    "marker": [512, 512, [], "f5a1", ["M169.36 214.63l128 128L222 418.05a327 327 0 0 1-195.34 93.8A24 24 0 0 1 .15 485.34v-.23A327 327 0 0 1 94 290z", "M485.5 154.53L320 320 192 192l98.48-98.47-19.6-19.59-87.15 87.15a16 16 0 0 1-22.63 0l-22.62-22.62a16 16 0 0 1 0-22.63L242.6 11.72a40 40 0 0 1 56.56 0l36.56 36.55 21.76-21.76a90.52 90.52 0 0 1 128 128z"]],
    "mars": [384, 512, [], "f222", ["M143.9 384a80 80 0 1 1 80-80 80 80 0 0 1-80 80z", "M371.9 64h-79a12 12 0 0 0-8.5 20.5l16.9 16.9-80.7 80.7a143.94 143.94 0 1 0 45.2 45.2l80.7-80.7 16.9 16.9a12 12 0 0 0 20.5-8.5V76a12 12 0 0 0-12-12zm-228 320a80 80 0 1 1 80-80 80 80 0 0 1-80 80z"]],
    "mars-double": [512, 512, [], "f227", ["M380.7 246l48.7-48.7-16.9-16.9a12 12 0 0 1 8.5-20.5h79a12.06 12.06 0 0 1 12 12.1v79a12 12 0 0 1-12.1 12 11.73 11.73 0 0 1-8.4-3.5l-16.9-16.9-48.7 48.7a144 144 0 1 1-265.1 91.8 174.49 174.49 0 0 0 63.3-18.4c-.1 1-.1 2.1-.1 3.2a80 80 0 1 0 80-80c-1 0-2.1.1-3.2.1a176.47 176.47 0 0 0 18.4-63.3 144.29 144.29 0 0 1 61.5 21.3z", "M340 0h-79a12 12 0 0 0-8.5 20.5l16.9 16.9-48.7 48.7a143.94 143.94 0 1 0 45.2 45.2l48.7-48.7 16.9 16.9A12 12 0 0 0 352 91V12a12 12 0 0 0-12-12zM144 288a80 80 0 1 1 80-80 80.11 80.11 0 0 1-80 80z"]],
    "mars-stroke": [384, 512, [], "f229", ["M144 384a80 80 0 1 1 80-80 80 80 0 0 1-80 80z", "M372 64h-79a12 12 0 0 0-8.5 20.5l16.9 16.9-17.5 17.5-14.1-14.1a12 12 0 0 0-17 0L224.5 133a12 12 0 0 0 0 17l14.1 14.1-18 18a143.3 143.3 0 0 0-76.7-22.1C64.5 160 0 224.5 0 304a144 144 0 1 0 265.9-76.7l18-18 14.1 14.1a12 12 0 0 0 17 0l28.3-28.3a12 12 0 0 0 0-17L329.2 164l17.5-17.5 16.9 16.9a12 12 0 0 0 20.5-8.5V76A12.19 12.19 0 0 0 372 64zM144 384a80 80 0 1 1 80-80 80 80 0 0 1-80 80z"]],
    "mars-stroke-h": [480, 512, [], "f22b", ["M200.54 312.58a80.06 80.06 0 1 1 0-113.2 80.09 80.09 0 0 1 0 113.2z", "M476.41 247.44l-56-55.93A12 12 0 0 0 399.9 200v24h-23.74v-20a12 12 0 0 0-12-12h-40a12 12 0 0 0-12 12v20h-27.69a144 144 0 1 0 0 64h27.63v20a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-20h23.93v23.91a12 12 0 0 0 20.52 8.51l55.95-55.93a12.12 12.12 0 0 0-.09-17.05zm-275.87 65.14a80.06 80.06 0 1 1 0-113.2 80.09 80.09 0 0 1 0 113.2z"]],
    "mars-stroke-v": [288, 512, [], "f22a", ["M200.58 408.27a80.12 80.12 0 1 1-.05-113.5l.05.05a80.45 80.45 0 0 1 0 113.45z", "M284.38 319.45a144.66 144.66 0 0 0-38.56-70.08A143 143 0 0 0 176 210.63v-25.45h20a12 12 0 0 0 12-12V133a12 12 0 0 0-12-12h-20V96.09h24a12 12 0 0 0 8.5-20.57l-55.89-56a12 12 0 0 0-17 0l-56 56.09A12 12 0 0 0 88.1 96.2h24V121h-20a12 12 0 0 0-12 12v40.13a12 12 0 0 0 12 12h20v25.45C34.52 228.34-14 305.76 3.62 383.56S98.42 510.07 176 492.37s126-95.13 108.38-172.92zm-83.8 88.82a80.12 80.12 0 1 1-.05-113.5l.05.05a80.45 80.45 0 0 1 0 113.45z"]],
    "mask": [640, 512, [], "f6fa", ["M320.67 64c-442.6 0-357.57 384-158.46 384 39.9 0 77.47-20.69 101.42-55.86l25.73-37.79c15.66-23 47-23 62.63 0l25.73 37.79C401.66 427.31 439.23 448 479.13 448 669 448 769.76 64 320.67 64zm-56.59 203.31c-12.32 15.4-39 41.05-80.08 41.05s-67.76-25.66-80.08-41.05a18.28 18.28 0 0 1 0-22.63c12.32-15.4 39-41.05 80.08-41.05s67.76 25.66 80.08 41.05a18.28 18.28 0 0 1 0 22.63zm272 0c-12.32 15.4-39 41.05-80.08 41.05s-67.76-25.66-80.08-41.05a18.28 18.28 0 0 1 0-22.63c12.32-15.4 39-41.05 80.08-41.05s67.76 25.66 80.08 41.05a18.28 18.28 0 0 1 0 22.63z", "M184 203.63c-41.08 0-67.76 25.65-80.08 41.05a18.28 18.28 0 0 0 0 22.63c12.32 15.39 39 41.05 80.08 41.05s67.76-25.65 80.08-41.05a18.28 18.28 0 0 0 0-22.63c-12.32-15.39-39-41.05-80.08-41.05zm352.08 41.05c-12.32-15.39-39-41.05-80.08-41.05s-67.76 25.65-80.08 41.05a18.28 18.28 0 0 0 0 22.63c12.32 15.39 39 41.05 80.08 41.05s67.76-25.65 80.08-41.05a18.28 18.28 0 0 0 0-22.63z"]],
    "meat": [512, 512, [], "f814", ["M376.27 136.1c-14.72-14.71-34.57-18.64-44.42-8.87s-5.85 29.67 8.88 44.37 34.61 18.68 44.42 8.87 5.85-29.66-8.88-44.37zM128 312v-2.11l-8.51 8.5c-9.71 9.69-24 11.07-36.79 6a60.33 60.33 0 0 0-65 98.72c15.3 15.28 36.51 19.59 56.13 15.1-4.49 19.6-.18 40.83 15.11 56.1a60.36 60.36 0 0 0 98.83-65c-5.1-12.73-3.72-27 6-36.75l8.57-8.56H200a72 72 0 0 1-72-72z", "M444 68.52C399.41 24.05 345.07 0 299.13 0c-23.64 0-44.77 6.79-61.47 20a41.75 41.75 0 0 0-7.3 5.82C191.64 64.5 128.1 139.6 128.1 209.42v100.37l-.1.1V312a72 72 0 0 0 72 72h102.84c69.89 0 145.07-63.46 183.8-102.15a40.45 40.45 0 0 0 6.66-9c37.42-49.43 17.37-137.66-49.3-204.33zm8.73 179.39c-9.76 9.75-24.3 11.8-34.79 11.8-34.72 0-77.19-20.87-110.82-54.47-27.19-27.16-46.31-60.32-52.45-91-4.74-23.7-1.19-43.56 9.74-54.48C274.09 50.05 288.65 48 299.14 48c34.72 0 77.18 20.87 110.82 54.46 53.88 53.84 67 121.19 42.7 145.45z"]],
    "medal": [512, 512, [], "f5a2", ["M127.18 0H16A16 16 0 0 0 2.92 25.18l111.27 159a207 207 0 0 1 109.56-53.39L154.62 15.54A32 32 0 0 0 127.18 0zM496 0H384.82a32 32 0 0 0-27.44 15.54l-69.13 115.21a207 207 0 0 1 109.56 53.38L509.08 25.18A16 16 0 0 0 496 0z", "M256 160a176 176 0 1 0 176 176 176 176 0 0 0-176-176zm92.52 157.26l-37.93 37 9 52.22a11.48 11.48 0 0 1-16.65 12.09L256 393.88l-46.9 24.65a11.48 11.48 0 0 1-16.65-12.09l9-52.22-37.93-37a11.49 11.49 0 0 1 6.35-19.59l52.4-7.63 23.43-47.52a11.5 11.5 0 0 1 20.61 0L289.74 290l52.43 7.64a11.49 11.49 0 0 1 6.35 19.62z"]],
    "medkit": [512, 512, [], "f0fa", ["M384 128v352h64V128zM64 480h64V128H64z", "M336 32H176a48 48 0 0 0-48 48v400h256V80a48 48 0 0 0-48-48zM192 96h128v32H192zm160 224a16 16 0 0 1-16 16h-48v48a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-48h-48a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h48v-48a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v48h48a16 16 0 0 1 16 16zM0 176v256a48 48 0 0 0 48 48h16V128H48a48 48 0 0 0-48 48zm464-48h-16v352h16a48 48 0 0 0 48-48V176a48 48 0 0 0-48-48z"]],
    "megaphone": [576, 512, [], "f675", ["M480 64L64 192v128l101.72 31.3a96 96 0 1 0 183.33 56.41L480 448zM256 432a48 48 0 0 1-44.27-66.54L303 393.55A48.07 48.07 0 0 1 256 432z", "M560 32h-32a16 16 0 0 0-16 16v416a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zM32 160a32 32 0 0 0-32 32v128a32 32 0 0 0 64 0V192a32 32 0 0 0-32-32z"]],
    "meh": [496, 512, [], "f11a", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8ZM168,176a32,32,0,1,1-32,32A32,32,0,0,1,168,176ZM344,368H152c-21.2,0-21.2-32,0-32H344C365.2,336,365.2,368,344,368ZM328,240a32,32,0,1,1,32-32A32,32,0,0,1,328,240Z", "M328,176a32,32,0,1,0,32,32A32,32,0,0,0,328,176Zm-160,0a32,32,0,1,0,32,32A32,32,0,0,0,168,176Z"]],
    "meh-blank": [496, 512, [], "f5a4", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8ZM168,240a32,32,0,1,1,32-32A32,32,0,0,1,168,240Zm160,0a32,32,0,1,1,32-32A32,32,0,0,1,328,240Z", "M168,176a32,32,0,1,0,32,32A32,32,0,0,0,168,176Zm160,0a32,32,0,1,0,32,32A32,32,0,0,0,328,176Z"]],
    "meh-rolling-eyes": [496, 512, [], "f5a5", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8ZM88,224a64,64,0,1,1,64,64A64,64,0,0,1,88,224ZM312,400H184c-21.2,0-21.2-32,0-32H312C333.2,368,333.2,400,312,400Zm32-112a64,64,0,1,1,64-64A64,64,0,0,1,344,288Z", "M375,168a64,64,0,0,0-62,0,32,32,0,1,0,62,0Zm-223-8a63.66,63.66,0,0,0-31,8,32,32,0,1,0,62,0A63.66,63.66,0,0,0,152,160Z"]],
    "memory": [640, 512, [], "f538", ["M640 130.94V96a32 32 0 0 0-32-32H32A32 32 0 0 0 0 96v34.94A47.86 47.86 0 0 1 32 176a47.86 47.86 0 0 1-32 45.06V320h640v-98.94a47.73 47.73 0 0 1 0-90.12zM224 256h-64V128h64zm128 0h-64V128h64zm128 0h-64V128h64z", "M224 128h-64v128h64zm128 0h-64v128h64zm128 0h-64v128h64zM0 352v96h64v-26.67a16 16 0 0 1 32 0V448h128v-26.67a16 16 0 1 1 32 0V448h128v-26.67a16 16 0 1 1 32 0V448h128v-26.67a16 16 0 1 1 32 0V448h64v-96z"]],
    "menorah": [640, 512, [], "f676", ["M480 64a32 32 0 0 0 64 0c0-17.67-32-64-32-64s-32 46.33-32 64zm-96 0a32 32 0 0 0 64 0c0-17.67-32-64-32-64s-32 46.33-32 64zM0 64a32 32 0 0 0 64 0C64 46.33 32 0 32 0S0 46.33 0 64zm288 0a32 32 0 0 0 64 0c0-17.67-32-64-32-64s-32 46.33-32 64zm-96 0a32 32 0 0 0 64 0c0-17.67-32-64-32-64s-32 46.33-32 64zm-96 0a32 32 0 0 0 64 0c0-17.67-32-64-32-64S96 46.33 96 64zM608 0s-32 46.33-32 64a32 32 0 0 0 64 0c0-17.67-32-64-32-64z", "M160 144a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v144h64zm288 0a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v144h64zm-192 0a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v144h64zm288 0a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v144h64zm80-16h-32a16 16 0 0 0-16 16v144a32 32 0 0 1-32 32H352V144a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v176H96a32 32 0 0 1-32-32V144a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v144a96 96 0 0 0 96 96h192v64H112a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H352v-64h192a96 96 0 0 0 96-96V144a16 16 0 0 0-16-16z"]],
    "mercury": [288, 512, [], "f223", ["M143 288a80 80 0 1 1 80-80 80 80 0 0 1-80 80z", "M287 208a143.64 143.64 0 0 0-51.2-110.1c2.5-1.8 4.9-3.8 7.2-5.8 24.7-21.2 39.8-48.8 43.2-78.8A11.89 11.89 0 0 0 275.83.08a12.79 12.79 0 0 0-1.52-.08h-40.5A12 12 0 0 0 222 9.8c-2.4 12.5-9.6 24.3-20.69 33.8C186 56.8 165.32 64 143 64s-43-7.2-58.4-20.4C73.5 34.1 66.4 22.3 63.9 9.8A12 12 0 0 0 52.23 0h-40.5a11.88 11.88 0 0 0-12 11.76 13.08 13.08 0 0 0 .09 1.54C3.23 43.4 18.23 71 43 92.2c2.3 2 4.7 3.9 7.2 5.8A143.9 143.9 0 0 0 111 348.4V400H75a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h36v36a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-36h36a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12h-36v-51.6A144 144 0 0 0 287 208zm-144 80a80 80 0 1 1 80-80 80 80 0 0 1-80 80z"]],
    "meteor": [512, 512, [], "f753", ["M491.14.7C452.44 12.3 379.34 35 303.44 62c-2.1-7-4-13.5-5.6-18.6a16.06 16.06 0 0 0-20-10.69 16.6 16.6 0 0 0-2.86 1.19C232.54 56 122.14 116.5 60.54 176.4c-1.1 1-2.5 2-3.5 3C-19 255.5-19 378.87 57.09 455s199.48 76 275.55-.1c1-1 2-2.4 3-3.5C395.44 389.8 456 279.3 478.14 237a16.05 16.05 0 0 0-6.64-21.72 15.52 15.52 0 0 0-2.86-1.18c-5.2-1.6-11.6-3.5-18.6-5.6 27-76 49.7-149 61.3-187.7A16.17 16.17 0 0 0 491.14.7zM191.94 448a128 128 0 1 1 128-128 128 128 0 0 1-128 128z", "M191.94 192a128 128 0 1 0 128 128 128 128 0 0 0-128-128zm-32 128a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm48 64a16 16 0 1 1 16-16 16 16 0 0 1-16 16z"]],
    "microchip": [512, 512, [], "f2db", ["M24 190v6H6a6 6 0 0 0-6 6v12a6 6 0 0 0 6 6h18v6a6 6 0 0 0 6 6h42v-48H30a6 6 0 0 0-6 6zm0-96v6H6a6 6 0 0 0-6 6v12a6 6 0 0 0 6 6h18v6a6 6 0 0 0 6 6h42V88H30a6 6 0 0 0-6 6zm482 6h-18v-6a6 6 0 0 0-6-6h-42v48h42a6 6 0 0 0 6-6v-6h18a6 6 0 0 0 6-6v-12a6 6 0 0 0-6-6zm0 192h-18v-6a6 6 0 0 0-6-6h-42v48h42a6 6 0 0 0 6-6v-6h18a6 6 0 0 0 6-6v-12a6 6 0 0 0-6-6zm0-96h-18v-6a6 6 0 0 0-6-6h-42v48h42a6 6 0 0 0 6-6v-6h18a6 6 0 0 0 6-6v-12a6 6 0 0 0-6-6zm0 192h-18v-6a6 6 0 0 0-6-6h-42v48h42a6 6 0 0 0 6-6v-6h18a6 6 0 0 0 6-6v-12a6 6 0 0 0-6-6zm-482-6v6H6a6 6 0 0 0-6 6v12a6 6 0 0 0 6 6h18v6a6 6 0 0 0 6 6h42v-48H30a6 6 0 0 0-6 6zm0-96v6H6a6 6 0 0 0-6 6v12a6 6 0 0 0 6 6h18v6a6 6 0 0 0 6 6h42v-48H30a6 6 0 0 0-6 6z", "M144 512a48 48 0 0 1-48-48V48a48 48 0 0 1 48-48h224a48 48 0 0 1 48 48v416a48 48 0 0 1-48 48z"]],
    "microphone": [352, 512, [], "f130", ["M80 256V96a96 96 0 0 1 192 0v160a96 96 0 0 1-192 0z", "M352 256c0 88.9-66.29 162.47-152 174.23V464h56a16 16 0 0 1 16 16v16a16 16 0 0 1-16 16H96a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h56v-34.15C64 417.71 0 337.8 0 248.16V208a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v42.3c0 66.81 48.71 126.59 115.21 133.08A128.15 128.15 0 0 0 304 256v-48a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16z"]],
    "microphone-alt": [352, 512, [], "f3c9", ["M80 256V96a96 96 0 0 1 192 0h-85.33c-5.89 0-10.67 3.58-10.67 8v16c0 4.42 4.78 8 10.67 8H272v32h-85.33c-5.89 0-10.67 3.58-10.67 8v16c0 4.42 4.78 8 10.67 8H272v32h-85.33c-5.89 0-10.67 3.58-10.67 8v16c0 4.42 4.78 8 10.67 8H272a96 96 0 0 1-192 0z", "M186.67 128H272V96h-85.33c-5.89 0-10.67 3.58-10.67 8v16c0 4.42 4.78 8 10.67 8zm0 64H272v-32h-85.33c-5.89 0-10.67 3.58-10.67 8v16c0 4.42 4.78 8 10.67 8zM336 192h-16a16 16 0 0 0-16 16v48a128.15 128.15 0 0 1-140.79 127.38C96.71 376.89 48 317.11 48 250.3V208a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v40.16c0 89.64 64 169.55 152 181.69V464H96a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h160a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16h-56v-33.77C285.71 418.47 352 344.9 352 256v-48a16 16 0 0 0-16-16zm-149.33 64H272v-32h-85.33c-5.89 0-10.67 3.58-10.67 8v16c0 4.42 4.78 8 10.67 8z"]],
    "microphone-alt-slash": [640, 512, [], "f539", ["M437.52 306.66A127.18 127.18 0 0 0 448 256v-48a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v48a174.64 174.64 0 0 1-19.69 80.76zm-26.38-20.46A95.78 95.78 0 0 0 416 256h-43.79zM400 464h-56v-33.78a175.69 175.69 0 0 0 34-8.08l-50.4-39c-6.71.4-13.41.87-20.35.2-55.85-5.45-98.74-48.63-111.18-101.85l-52-40.22v6.85c0 89.64 64 169.55 152 181.69V464H240a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h160a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm-69-240h85v-32h-85.33c-5.89 0-10.67-3.58-10.67-8v-16c0-4.42 4.78-8 10.67-8H416v-32h-85.33c-5.89 0-10.67-3.58-10.67-8v-16c0-4.42 4.78-8 10.67-8H416a96 96 0 0 0-192 0v45z", "M3.37 31.45L23 6.18a16 16 0 0 1 22.47-2.81L633.82 458.1a16 16 0 0 1 2.82 22.45L617 505.82a16 16 0 0 1-22.46 2.81L6.18 53.9a16 16 0 0 1-2.81-22.45z"]],
    "microphone-slash": [640, 512, [], "f131", ["M436.61 306.45A127.25 127.25 0 0 0 447 256v-48a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v48a174.58 174.58 0 0 1-19.54 80.47zM399 464h-56v-33.78a175.69 175.69 0 0 0 34-8.08l-50.4-39c-6.71.4-13.41.87-20.35.2-55.85-5.45-98.74-48.63-111.18-101.85l-52-40.22v6.85c0 89.64 64 169.55 152 181.69V464H239a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h160a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm11.2-178a95.94 95.94 0 0 0 4.8-30V96a96 96 0 0 0-192 0v45.35z", "M2.37 31.45L22 6.18a16 16 0 0 1 22.47-2.81L632.82 458.1a16 16 0 0 1 2.82 22.45L616 505.82a16 16 0 0 1-22.46 2.81L5.18 53.9a16 16 0 0 1-2.81-22.45z"]],
    "microphone-stand": [512, 512, [], "f8cb", ["M6.73 423.18a26.67 26.67 0 0 0 1.08 36.57l44.44 44.44a26.67 26.67 0 0 0 36.57 1.07L344 280 232 168zM314.34 35.72l-22.62 22.62 161.94 161.94 22.62-22.63z", "M289.54 60.53c-23.84 23.84-34.56 55.55-33 86.77L364.7 255.44c31.21 1.58 62.93-9.14 86.77-33l2.19-2.18L291.72 58.34zm188.92-27a114.49 114.49 0 0 0-161.93 0l-2.19 2.18 161.94 161.94 2.18-2.18a114.49 114.49 0 0 0 0-161.93zM224 512h64V329.44l-64 56.49z"]],
    "microscope": [512, 512, [], "f610", ["M104 384h208a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8H104a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8z", "M464 448h-1.29A191 191 0 0 0 512 320c0-105.88-86.12-192-192-192v64a128 128 0 0 1 0 256H48a48 48 0 0 0-48 48 16 16 0 0 0 16 16h480a16 16 0 0 0 16-16 48 48 0 0 0-48-48zM160 320h12v16a16 16 0 0 0 16 16h40a16 16 0 0 0 16-16v-16h12a32 32 0 0 0 32-32V64a32 32 0 0 0-32-32V16a16 16 0 0 0-16-16h-64a16 16 0 0 0-16 16v16a32 32 0 0 0-32 32v224a32 32 0 0 0 32 32z"]],
    "mind-share": [640, 512, [], "f677", ["M467.14 118.15A59.61 59.61 0 0 0 408.47 45c-.71 0-1.36.18-2.07.21A60.14 60.14 0 0 0 288 60v324c12.64-57.14 64-102.33 122.42-110.89a124.7 124.7 0 0 1 18.64-1.11H480v-15.2a48.87 48.87 0 0 1 29-44.8c2.81-7.74 4.84-15.83 4.84-24.54a75 75 0 0 0-46.7-69.31zM256 60a60.14 60.14 0 0 0-118.4-14.79c-.7 0-1.36-.21-2.07-.21a60.12 60.12 0 0 0-60.23 60 59.46 59.46 0 0 0 1.56 13.16 75 75 0 0 0-46.74 69.34A74 74 0 0 0 38 220.23c-22.59 13-38 37-38 64.77a75 75 0 0 0 46.52 69.27A67.36 67.36 0 0 0 113 435a67 67 0 0 0 11.32-1.14A67.62 67.62 0 0 0 256 412.5z", "M635 364.21l-96 95.19c-10.12 10-27 2.6-27-12.21V400h-64c-65.85 0-69.27 68.95-60.28 95.52 3.77 11.13-8 20.9-17.82 14.38-35-23.3-56.08-67-48.29-113.67 7.84-46.92 46.39-84.56 93.45-91.46a113.79 113.79 0 0 1 17-.77H512v-47.19c0-14.82 16.88-22.23 27-12.21l96 95.19a17.38 17.38 0 0 1 0 24.42z"]],
    "minus": [448, 512, [], "f068", ["M448 240v32a32 32 0 0 1-32 32H32a32 32 0 0 1-32-32v-32a32 32 0 0 1 32-32h384a32 32 0 0 1 32 32z", ""]],
    "minus-circle": [512, 512, [], "f056", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm144 276a12 12 0 0 1-12 12H124a12 12 0 0 1-12-12v-56a12 12 0 0 1 12-12h264a12 12 0 0 1 12 12z", "M400 284a12 12 0 0 1-12 12H124a12 12 0 0 1-12-12v-56a12 12 0 0 1 12-12h264a12 12 0 0 1 12 12z"]],
    "minus-hexagon": [576, 512, [], "f307", ["M553.48 231.8l-112-192A48.11 48.11 0 0 0 400 16H176a48.11 48.11 0 0 0-41.5 23.8l-112 192a48.19 48.19 0 0 0 0 48.4l112 192A48.11 48.11 0 0 0 176 496h224a48.11 48.11 0 0 0 41.5-23.8l112-192a48.12 48.12 0 0 0 0-48.4zM432 284a12 12 0 0 1-12 12H156a12 12 0 0 1-12-12v-56a12 12 0 0 1 12-12h264a12 12 0 0 1 12 12z", "M432 228v56a12 12 0 0 1-12 12H156a12 12 0 0 1-12-12v-56a12 12 0 0 1 12-12h264a12 12 0 0 1 12 12z"]],
    "minus-octagon": [512, 512, [], "f308", ["M497.9 150.5L361.4 14.1A48 48 0 0 0 327.5 0H184.4a48 48 0 0 0-33.9 14.1L14.1 150.6A48 48 0 0 0 0 184.5v143.1a48 48 0 0 0 14.1 33.9l136.5 136.4a48 48 0 0 0 33.9 14.1h143.1a48 48 0 0 0 33.9-14.1l136.4-136.5a48 48 0 0 0 14.1-33.9V184.4a48 48 0 0 0-14.1-33.9zM400 284a12 12 0 0 1-12 12H124a12 12 0 0 1-12-12v-56a12 12 0 0 1 12-12h264a12 12 0 0 1 12 12z", "M400 228v56a12 12 0 0 1-12 12H124a12 12 0 0 1-12-12v-56a12 12 0 0 1 12-12h264a12 12 0 0 1 12 12z"]],
    "minus-square": [448, 512, [], "f146", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-32 252a12 12 0 0 1-12 12H92a12 12 0 0 1-12-12v-56a12 12 0 0 1 12-12h264a12 12 0 0 1 12 12z", "M368 228v56a12 12 0 0 1-12 12H92a12 12 0 0 1-12-12v-56a12 12 0 0 1 12-12h264a12 12 0 0 1 12 12z"]],
    "mistletoe": [576, 512, [], "f7b4", ["M554 394.1c-33.3 33.3-92.7 27.9-132.7-12.1-26-26-38.6-89.6-44.2-130.9l-65.2-65.2v96.3c28.4 32.7 72 89.2 72 127.3 0 56.6-43 102.4-96 102.4s-96-45.8-96-102.4c0-8.6 2.5-18.2 6.2-28.1a69.54 69.54 0 0 0 17.8 2.5 71.75 71.75 0 0 0 48-125.3v-72.8l-65.1 65.3c-.83 6.11-1.81 12.71-3 19.6a42.62 42.62 0 0 0-16 65.58c-6.46 18.72-14.75 35.26-25.2 45.72-40 40-99.4 45.4-132.7 12.1s-28-92.7 12-132.7c26-26 89.6-38.6 130.9-44.2l99.13-99.1V16a16 16 0 0 1 16-16h16a16 16 0 0 1 16 16v16.3a74.59 74.59 0 0 0-13.3 42.4 73.84 73.84 0 0 0 13.3 42.4l99.2 100.1c41.3 5.6 104.9 18.2 130.9 44.2 39.97 40 45.4 99.4 11.97 132.7z", "M373.23 32a42.65 42.65 0 1 0 42.7 42.6 42.68 42.68 0 0 0-42.7-42.6zm-160 235a42.65 42.65 0 1 0 42.7 42.6 42.68 42.68 0 0 0-42.7-42.6z"]],
    "mitten": [448, 512, [], "f7b5", ["M368 416a16 16 0 0 1 16 16v64a16 16 0 0 1-16 16H48a16 16 0 0 1-16-16v-64a16 16 0 0 1 16-16z", "M433.12 297l-72.5 87h-309L3.72 176.42a144 144 0 0 1 107.9-172.7c77.4-17.9 154.8 30.5 172.8 108L314 240.12l20.9-25a63.94 63.94 0 1 1 98.2 81.9z"]],
    "mobile": [320, 512, [], "f10b", ["M0 384v80a48 48 0 0 0 48 48h224a48 48 0 0 0 48-48v-80zm160 96a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M0 384V48A48 48 0 0 1 48 0h224a48 48 0 0 1 48 48v336z"]],
    "mobile-alt": [320, 512, [], "f3cd", ["M272 0H48A48 48 0 0 0 0 48v416a48 48 0 0 0 48 48h224a48 48 0 0 0 48-48V48a48 48 0 0 0-48-48zM160 480a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm112-108a12 12 0 0 1-12 12H60a12 12 0 0 1-12-12V60a12 12 0 0 1 12-12h200a12 12 0 0 1 12 12z", "M272 372a12 12 0 0 1-12 12H60a12 12 0 0 1-12-12V60a12 12 0 0 1 12-12h200a12 12 0 0 1 12 12z"]],
    "mobile-android": [320, 512, [], "f3ce", ["M0 384v80a48 48 0 0 0 48 48h224a48 48 0 0 0 48-48v-80zm208 68a12 12 0 0 1-12 12h-72a12 12 0 0 1-12-12v-8a12 12 0 0 1 12-12h72a12 12 0 0 1 12 12z", "M0 384V48A48 48 0 0 1 48 0h224a48 48 0 0 1 48 48v336z"]],
    "mobile-android-alt": [320, 512, [], "f3cf", ["M272 0H48A48 48 0 0 0 0 48v416a48 48 0 0 0 48 48h224a48 48 0 0 0 48-48V48a48 48 0 0 0-48-48zm-64 452a12 12 0 0 1-12 12h-72a12 12 0 0 1-12-12v-8a12 12 0 0 1 12-12h72a12 12 0 0 1 12 12zm64-80a12 12 0 0 1-12 12H60a12 12 0 0 1-12-12V60a12 12 0 0 1 12-12h200a12 12 0 0 1 12 12z", "M272 372a12 12 0 0 1-12 12H60a12 12 0 0 1-12-12V60a12 12 0 0 1 12-12h200a12 12 0 0 1 12 12z"]],
    "money-bill": [640, 512, [], "f0d6", ["M101.22 112A112.5 112.5 0 0 1 48 165.22v181.56A112.5 112.5 0 0 1 101.22 400h437.56A112.5 112.5 0 0 1 592 346.78V165.22A112.5 112.5 0 0 1 538.78 112zM320 352c-44.19 0-80-43-80-96s35.82-96 80-96 80 43 80 96-35.83 96-80 96z", "M616 64H24A24 24 0 0 0 0 88v336a24 24 0 0 0 24 24h592a24 24 0 0 0 24-24V88a24 24 0 0 0-24-24zm-24 282.78A112.5 112.5 0 0 0 538.78 400H101.22A112.5 112.5 0 0 0 48 346.78V165.22A112.5 112.5 0 0 0 101.22 112h437.56A112.5 112.5 0 0 0 592 165.22z"]],
    "money-bill-alt": [640, 512, [], "f3d1", ["M101.22 112A112.5 112.5 0 0 1 48 165.22v181.56A112.5 112.5 0 0 1 101.22 400h437.56A112.5 112.5 0 0 1 592 346.78V165.22A112.5 112.5 0 0 1 538.78 112zM320 368c-53 0-96-50.16-96-112s43-112 96-112 96 50.14 96 112-43 112-96 112z", "M616 64H24A24 24 0 0 0 0 88v336a24 24 0 0 0 24 24h592a24 24 0 0 0 24-24V88a24 24 0 0 0-24-24zm-24 282.78A112.5 112.5 0 0 0 538.78 400H101.22A112.5 112.5 0 0 0 48 346.78V165.22A112.5 112.5 0 0 0 101.22 112h437.56A112.5 112.5 0 0 0 592 165.22zM352 288h-16v-88a8 8 0 0 0-8-8h-13.58a24 24 0 0 0-13.31 4l-15.33 10.22a8 8 0 0 0-2.22 11.08l8.88 13.31a8 8 0 0 0 11.08 2.22l.47-.31V288H288a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h64a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8z"]],
    "money-bill-wave": [640, 512, [], "f53a", ["M545.58 371.77a112.42 112.42 0 0 1 46.43-41V133.21a112.4 112.4 0 0 1-52.16-51.09 283.47 283.47 0 0 0-35.1-2.12c-55.6 0-112.61 14.43-173 29.7-63.39 16-128.95 32.64-196.51 32.64a385.14 385.14 0 0 1-40.83-2.12 112.42 112.42 0 0 1-46.42 41v197.57a112.42 112.42 0 0 1 52.15 51.09 283.47 283.47 0 0 0 35.1 2.12c55.6 0 112.62-14.43 173-29.71 63.4-16.05 129-32.64 196.53-32.64a385 385 0 0 1 40.81 2.12zM320 352c-44.19 0-80-43-80-96s35.82-96 80-96 80 43 80 96-35.83 96-80 96z", "M621.16 54.46C582.37 38.19 543.55 32 504.75 32c-123.19 0-246.34 62.34-369.5 62.34-30.89 0-61.76-3.92-92.65-13.72A34.19 34.19 0 0 0 32.25 79C15 79 0 92.32 0 110.81v317.26c0 12.63 7.23 24.6 18.84 29.46C57.63 473.81 96.45 480 135.25 480c123.17 0 246.34-62.35 369.51-62.35 30.89 0 61.76 3.92 92.65 13.72a34.19 34.19 0 0 0 10.35 1.63C625 433 640 419.67 640 401.18V83.93c0-12.64-7.23-24.6-18.84-29.47zM308.23 402.29C247.87 417.57 190.85 432 135.25 432a283.47 283.47 0 0 1-35.1-2.12A112.42 112.42 0 0 0 48 378.79V181.21a112.42 112.42 0 0 0 46.42-41 385.14 385.14 0 0 0 40.83 2.12c67.56 0 133.12-16.59 196.51-32.64C392.11 94.43 449.12 80 504.72 80a283.47 283.47 0 0 1 35.1 2.12A112.4 112.4 0 0 0 592 133.21v197.58a112.42 112.42 0 0 0-46.43 41 385 385 0 0 0-40.82-2.12c-67.56-.02-133.12 16.57-196.52 32.62z"]],
    "money-bill-wave-alt": [640, 512, [], "f53b", ["M320 352c-44.19 0-80-43-80-96s35.82-96 80-96 80 43 80 96-35.83 96-80 96z", "M621.16 54.46C582.37 38.19 543.55 32 504.75 32c-123.19 0-246.34 62.34-369.5 62.34-30.89 0-61.76-3.92-92.65-13.72A34 34 0 0 0 32.25 79C15 79 0 92.32 0 110.81v317.26c0 12.63 7.23 24.6 18.84 29.46C57.63 473.81 96.45 480 135.25 480c123.17 0 246.34-62.35 369.51-62.35 30.89 0 61.76 3.92 92.65 13.72a34.34 34.34 0 0 0 10.35 1.63C625 433 640 419.67 640 401.18V83.93c0-12.64-7.23-24.6-18.84-29.47zM320 352c-44.19 0-80-43-80-96s35.82-96 80-96 80 43 80 96-35.83 96-80 96z"]],
    "money-check": [640, 512, [], "f53c", ["M0 448a32 32 0 0 0 32 32h576a32 32 0 0 0 32-32V128H0zm448-208a16 16 0 0 1 16-16h96a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16h-96a16 16 0 0 1-16-16zm0 120a8 8 0 0 1 8-8h112a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8H456a8 8 0 0 1-8-8zM64 264a8 8 0 0 1 8-8h304a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8H72a8 8 0 0 1-8-8zm0 96a8 8 0 0 1 8-8h176a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8H72a8 8 0 0 1-8-8z", "M568 352H456a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h112a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zm-192-96H72a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h304a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zm-128 96H72a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h176a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zM624 32H16A16 16 0 0 0 0 48v48h640V48a16 16 0 0 0-16-16z"]],
    "money-check-alt": [640, 512, [], "f53d", ["M608 32H32A32 32 0 0 0 0 64v384a32 32 0 0 0 32 32h576a32 32 0 0 0 32-32V64a32 32 0 0 0-32-32zM176 327.88V344a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-16.29a57.26 57.26 0 0 1-31.37-11.35 8 8 0 0 1-.57-12.14L123.81 293a8.21 8.21 0 0 1 10.13-.73 24.08 24.08 0 0 0 12.82 3.73h28.11c6.5 0 11.8-5.92 11.8-13.19 0-5.95-3.61-11.19-8.77-12.73l-45-13.5c-18.59-5.58-31.58-23.42-31.58-43.39 0-24.52 19.05-44.44 42.67-45.07V152a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v16.29a57.18 57.18 0 0 1 31.37 11.35 8 8 0 0 1 .57 12.14L196.18 203a8.21 8.21 0 0 1-10.13.73 24 24 0 0 0-12.82-3.73h-28.11c-6.5 0-11.8 5.92-11.8 13.19 0 5.95 3.61 11.19 8.77 12.73l45 13.5c18.59 5.58 31.58 23.42 31.58 43.39 0 24.53-19.05 44.44-42.67 45.07zM416 312a8 8 0 0 1-8 8H296a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h112a8 8 0 0 1 8 8zm160 0a8 8 0 0 1-8 8h-80a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h80a8 8 0 0 1 8 8zm0-96a8 8 0 0 1-8 8H296a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h272a8 8 0 0 1 8 8z", "M144 168.12V152a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v16.29a57.18 57.18 0 0 1 31.37 11.35 8 8 0 0 1 .57 12.14L196.18 203a8.21 8.21 0 0 1-10.13.73 24 24 0 0 0-12.82-3.73h-28.11c-6.5 0-11.8 5.92-11.8 13.19 0 5.95 3.61 11.19 8.77 12.73l45 13.5c18.59 5.58 31.58 23.42 31.58 43.39 0 24.53-19 44.44-42.67 45.07V344a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-16.29a57.26 57.26 0 0 1-31.37-11.35 8 8 0 0 1-.57-12.14L123.81 293a8.21 8.21 0 0 1 10.13-.73 24.08 24.08 0 0 0 12.82 3.73h28.11c6.5 0 11.8-5.92 11.8-13.19 0-5.95-3.61-11.19-8.77-12.73l-45-13.5c-18.59-5.58-31.58-23.42-31.58-43.39 0-24.52 19.05-44.44 42.68-45.07z"]],
    "money-check-edit": [640, 512, [], "f872", ["M640 192v288a32 32 0 0 1-32 32H32a32 32 0 0 1-32-32V192a32 32 0 0 1 32-32h171.06L331 288H104a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h259l64 64H104a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h456a16 16 0 0 0 16-16v-74.46a64 64 0 0 0-18.74-45.26L437 160h171a32 32 0 0 1 32 32z", "M534.64 302.91L303.18 71.47l-71.7 71.7 231.39 231.45a32 32 0 0 0 22.64 9.38H528a16 16 0 0 0 16-16v-42.46a32 32 0 0 0-9.36-22.63zM238.78 7a24.1 24.1 0 0 0-33.9 0L167 44.87a24 24 0 0 0 0 33.8l41.9 41.9 71.7-71.8z"]],
    "money-check-edit-alt": [640, 512, [], "f873", ["M608 160H437l120.27 120.25A64 64 0 0 1 576 325.51V400a16 16 0 0 1-16 16H264a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h163l-64-64h-99a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h67L203 160H32a32 32 0 0 0-32 32v288a32 32 0 0 0 32 32h576a32 32 0 0 0 32-32V192a32 32 0 0 0-32-32zM144 415.85V432a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-16.32a57.32 57.32 0 0 1-31.37-11.35 8 8 0 0 1-.57-12.14L91.81 381a8.19 8.19 0 0 1 10.13-.73 24.06 24.06 0 0 0 12.82 3.73h28.11c6.5 0 11.8-5.92 11.8-13.19 0-5.95-3.61-11.19-8.77-12.73l-45-13.5c-18.59-5.58-31.58-23.45-31.58-43.42 0-24.52 19.05-44.44 42.67-45.07V240a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v16.29a57.17 57.17 0 0 1 31.37 11.35 8 8 0 0 1 1.4 11.22 7.26 7.26 0 0 1-.83.92L164.18 291a8.22 8.22 0 0 1-10.13.73 24 24 0 0 0-12.82-3.73h-28.11c-6.5 0-11.8 5.92-11.8 13.19 0 5.95 3.61 11.19 8.77 12.73l45 13.5c18.59 5.58 31.58 23.42 31.58 43.39 0 24.5-19.05 44.41-42.67 45.04z", "M238.78 7a24.1 24.1 0 0 0-33.9 0L167 44.84a24 24 0 0 0 0 33.8l41.9 41.9 71.7-71.8zm295.86 295.88L303.18 71.44l-71.7 71.7 231.4 231.46a32 32 0 0 0 22.62 9.4H528a16 16 0 0 0 16-16v-42.49a32 32 0 0 0-9.36-22.63zm-379.55 24.51l-45-13.5c-5.16-1.54-8.77-6.78-8.77-12.73 0-7.27 5.3-13.19 11.8-13.19h28.11a24 24 0 0 1 12.82 3.73 8.22 8.22 0 0 0 10.13-.73l11.75-11.22a7.26 7.26 0 0 0 .83-.92 8 8 0 0 0-1.4-11.22A57.17 57.17 0 0 0 144 256.26V240a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v16.12c-23.62.63-42.67 20.55-42.67 45.07 0 20 13 37.81 31.58 43.39l45 13.5c5.16 1.54 8.77 6.78 8.77 12.73 0 7.27-5.3 13.19-11.8 13.19h-28.12a24.06 24.06 0 0 1-12.82-3.73 8.19 8.19 0 0 0-10.13.73l-11.75 11.19a8 8 0 0 0 .57 12.14A57.32 57.32 0 0 0 112 415.68V432a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-16.15c23.62-.63 42.67-20.54 42.67-45.07 0-19.97-12.99-37.78-31.58-43.39z"]],
    "monitor-heart-rate": [576, 512, [], "f611", ["M512 64v384H64V288h118.11l27.58 55.16a16 16 0 0 0 28.62 0L288 243.78 310.11 288H400a16 16 0 0 0 0-32h-70.11l-27.58-55.16a16 16 0 0 0-28.62 0L224 300.22l-19.9-39.8A8 8 0 0 0 197 256H64V64z", "M528 0H48A48 48 0 0 0 0 48v416a48 48 0 0 0 48 48h480a48 48 0 0 0 48-48V48a48 48 0 0 0-48-48zm-16 448H64V64h448z"]],
    "monkey": [640, 512, [], "f6fb", ["M549.47 267.22A127 127 0 0 1 480 288c-56.67 0-104.29-37.26-121.08-88.38C262.91 224.9 192 312.05 192 416v32a32 32 0 0 1-32-32V176a80 80 0 0 0-160 0v48a32 32 0 0 0 64 0v-48a16 16 0 0 1 32 0v240a96.1 96.1 0 0 0 96 96h240a16 16 0 0 0 16-16v-16a32 32 0 0 0-32-32h-64l155.68-103.79 34.68 104 1.64 10.13V496a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-37.61a96 96 0 0 0-4.94-30.39zM592 64h-21.88C556.9 26.8 521.74 0 480 0s-76.9 26.8-90.12 64H368a48 48 0 0 0 0 96h16a96 96 0 0 0 192 0h16a48 48 0 0 0 0-96zm-32 48a48 48 0 0 1-32 45.26V176a48 48 0 0 1-48 48 48 48 0 0 1-48-48v-18.74A48 48 0 0 1 400 112a48 48 0 0 1 48-48h64a48 48 0 0 1 48 48z", "M512 64h-64a48 48 0 0 0-48 48 48 48 0 0 0 32 45.26V176a48 48 0 0 0 48 48 48 48 0 0 0 48-48v-18.74A48 48 0 0 0 560 112a48 48 0 0 0-48-48zm-72 56a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm80 0a16 16 0 1 1 16-16 16 16 0 0 1-16 16z"]],
    "monument": [384, 512, [], "f5a6", ["M384 464v32a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h352a16 16 0 0 1 16 16z", "M289.14 100.74a32 32 0 0 0-9.21-19.44L203.31 4.69a16 16 0 0 0-22.63 0l-76.6 76.61a32 32 0 0 0-9.21 19.44L64 416h256zM240 307.2c0 6.4-6.4 12.8-12.8 12.8h-70.4c-6.4 0-12.8-6.4-12.8-12.8v-38.4c0-6.4 6.4-12.8 12.8-12.8h70.4c6.4 0 12.8 6.4 12.8 12.8z"]],
    "moon": [512, 512, [], "f186", ["", "M32,256C32,114.51,144.29,0,282.64,0a246.91,246.91,0,0,1,45.8,4.28c10.77,2,13.16,16.72,3.67,22.23-61.52,35.76-99.37,102.17-99.37,174.39,0,125.38,111.67,220.61,233.28,197,10.69-2.08,18.24,10.64,11.32,19.35C430.56,476.08,360,512,282.64,512,144.11,512,32,397.31,32,256Z"]],
    "moon-cloud": [576, 512, [], "f754", ["M574.1 377a191.7 191.7 0 0 1-271.7 26.7c29.5-16.4 49.7-47.5 49.7-83.6a96 96 0 0 0-106.7-95.4 109.19 109.19 0 0 0-6.9-12.6C258.4 127.2 334.3 64 425.1 64a196.43 196.43 0 0 1 35 3.2c8.2 1.6 10.1 12.6 2.8 16.7a150.3 150.3 0 0 0-76.1 130.8c0 94 85.4 165.4 178.5 147.7 8.2-1.6 14 8 8.8 14.6z", "M320 320a64.06 64.06 0 0 1-64 64H64a64 64 0 0 1 0-128c.6 0 1.1.2 1.6.2a79.75 79.75 0 0 1 157.7 9A63.72 63.72 0 0 1 320 320z"]],
    "moon-stars": [512, 512, [], "f755", ["M320 32L304 0l-16 32-32 16 32 16 16 32 16-32 32-16zm138.7 149.3L432 128l-26.7 53.3L352 208l53.3 26.7L432 288l26.7-53.3L512 208z", "M332.2 426.4c8.1-1.6 13.9 8 8.6 14.5a191.18 191.18 0 0 1-149 71.1C85.8 512 0 426 0 320c0-120 108.7-210.6 227-188.8 8.2 1.6 10.1 12.6 2.8 16.7a150.3 150.3 0 0 0-76.1 130.8c0 94 85.4 165.4 178.5 147.7z"]],
    "mortar-pestle": [512, 512, [], "f5a7", ["M501.54 60.91L402.46 160H251.09L454.9 7.14a35.68 35.68 0 0 1 46.64 53.77z", "M16 192h480a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16h-16c0 81-50.2 150.11-121.13 178.32A128.08 128.08 0 0 1 383.82 493a16.43 16.43 0 0 1-16.07 19h-223.5a16.43 16.43 0 0 1-16.07-19 128.29 128.29 0 0 1 24.95-58.69C82.2 406.11 32 337 32 256H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16z"]],
    "mosque": [640, 512, [], "f678", ["M64 0S0 32 0 96v32h128V96c0-64-64-96-64-96zm456.08 106.19c-41.94-26.47-80.63-57.77-112-96.22L400 0l-8.12 10c-31.33 38.45-70 69.76-112 96.22-46.13 29.11-87.92 70-87.92 122.9 0 21.57 11 41.52 28.84 58.91h358.36C597 270.61 608 250.66 608 229.09c0-52.86-41.79-93.79-87.92-122.9z", "M0 480a32 32 0 0 0 32 32h64a32 32 0 0 0 32-32V160H0zm608-160H192a32 32 0 0 0-32 32v128a32 32 0 0 0 32 32h32v-64a32 32 0 0 1 64 0v64h64v-72c0-48 48-72 48-72s48 24 48 72v72h64v-64a32 32 0 0 1 64 0v64h32a32 32 0 0 0 32-32V352a32 32 0 0 0-32-32z"]],
    "motorcycle": [640, 512, [], "f21c", ["M252 352a127.94 127.94 0 1 1-87.42-154.7l-24 43.69A80 80 0 1 0 201.3 352zm260-160a127.81 127.81 0 0 0-41.46 6.87l25.61 42.71a80.22 80.22 0 1 1-42 23.26l-25.26-42.17A128 128 0 1 0 512 192z", "M175.83 176.8c-9.1-13.9-23.3-24.8-47.8-24.8H72a24 24 0 0 1-24-23.5C47.73 115 59 104 72.53 104H128c55 0 82.2 16.9 99.9 40h153.7l-19.2-32H296a16 16 0 0 1-16-16V80a16 16 0 0 1 16-16h80a24.16 24.16 0 0 1 20.6 11.6l22.8 38 37.5-41.7a24 24 0 0 1 17.8-7.9H520a23.94 23.94 0 0 1 24 24v32a23.94 23.94 0 0 1-24 24h-82.4l107.1 178.6a16.07 16.07 0 0 1-5.5 22l-13.7 8.2a16.07 16.07 0 0 1-22-5.5l-87.1-145.4a151.48 151.48 0 0 0-56.2 125 24 24 0 0 1-24 25.1H120a24 24 0 0 1-21-35.6z"]],
    "mountain": [640, 512, [], "f6fc", ["M256 242.75l-66.66-66.67L293.08 14.7a32 32 0 0 1 53.84 0L460.9 192H306.75l-9.37 9.37z", "M636.09 495.33A32 32 0 0 1 608 512H32a32 32 0 0 1-26.92-49.3l166.55-259.07L256 288l64-64h161.47l153.45 238.7a32 32 0 0 1 1.17 32.63z"]],
    "mountains": [640, 512, [], "f6fd", ["M611.14 448h-69.72L357.48 159.68l32.84-50.37c11.57-17.75 39.8-17.75 51.37 0l194 297.6c11.77 18-2.05 41.09-24.55 41.09z", "M338.33 189.07L503.5 448H30.92C6.81 448-8 422.81 4.58 403.18l207.9-324.66c12.4-19.36 42.64-19.36 55 0z"]],
    "mouse": [384, 512, [], "f8cc", ["M176 0h-16A160 160 0 0 0 0 160v32h176zm48 0h-16v192h176v-32A160 160 0 0 0 224 0zM0 352a160 160 0 0 0 160 160h64a160 160 0 0 0 160-160V224H0z", "M384 192v32H0v-32h176V0h32v192z"]],
    "mouse-alt": [384, 512, [], "f8cd", ["M224 0h-64A160 160 0 0 0 0 160v192a160 160 0 0 0 160 160h64a160 160 0 0 0 160-160V160A160 160 0 0 0 224 0zm0 160a32 32 0 0 1-64 0v-32a32 32 0 0 1 64 0z", "M224 160a32 32 0 0 1-64 0v-32a32 32 0 0 1 64 0z"]],
    "mouse-pointer": [320, 512, [], "f245", ["M302.19 329.13H196.1l55.84 136a18.58 18.58 0 0 1-9.45 24l-49.16 21.42c-9.17 4-19.45-.57-23.34-9.71l-53.05-129.15-86.66 89.14C18.73 472.71 0 463.55 0 448V18.3C0 1.9 19.92-6.1 30.28 5.44L314.69 298c11.47 11.16 3.01 31.13-12.5 31.13z", ""]],
    "mp3-player": [384, 512, [], "f8ce", ["M336 0H48A48 48 0 0 0 0 48v416a48 48 0 0 0 48 48h288a48 48 0 0 0 48-48V48a48 48 0 0 0-48-48zM192 448a96 96 0 1 1 96-96 96 96 0 0 1-96 96zm128-256H64V64h256z", "M64 64v128h256V64zm128 192a96 96 0 1 0 96 96 96 96 0 0 0-96-96zm0 128a32 32 0 1 1 32-32 32 32 0 0 1-32 32z"]],
    "mug": [576, 512, [], "f874", ["M448 64h-32v288-32h32a128 128 0 0 0 0-256zm0 192h-32V128h32a64 64 0 0 1 0 128z", "M416 352a96 96 0 0 1-96 96H128a96 96 0 0 1-96-96V87.88A23.94 23.94 0 0 1 56 64h360v288z"]],
    "mug-hot": [512, 512, [], "f7b6", ["M139.3 67.3a94.83 94.83 0 0 1-26.4-53.5A16.11 16.11 0 0 0 96.8 0H80.4a16.31 16.31 0 0 0-16.3 18 145.36 145.36 0 0 0 40.6 84.4 81.22 81.22 0 0 1 22.4 44.1 16.23 16.23 0 0 0 16 13.5h16.5c9.8 0 17.6-8.5 16.3-18a130.72 130.72 0 0 0-36.6-74.7zM287.9 142a130.72 130.72 0 0 0-36.6-74.7 94.83 94.83 0 0 1-26.4-53.5A16.11 16.11 0 0 0 208.8 0h-16.4c-9.8 0-17.5 8.5-16.3 18a145.36 145.36 0 0 0 40.6 84.4 81.22 81.22 0 0 1 22.4 44.1 16.23 16.23 0 0 0 16 13.5h16.5c9.8 0 17.6-8.5 16.3-18z", "M400 192H32a32 32 0 0 0-32 32v192a96 96 0 0 0 96 96h192a96 96 0 0 0 96-96h16a112 112 0 0 0 0-224zm0 160h-16v-96h16a48 48 0 0 1 0 96z"]],
    "mug-marshmallows": [512, 512, [], "f7b7", ["M200.9 44.79C195 37.5 186.4 32.4 176.3 32.4H64a32 32 0 0 0-32 32v63.89h130.1a63.41 63.41 0 0 1 16.4-61.1zM96 224a32 32 0 0 0 64 0v-64H96zM343.3 89.79L294.8 41.4a32 32 0 0 0-45.26 0L201 89.79c-10.4 10.5-11.5 26.31-4.3 38.61h151c7.2-12.3 6.1-28.11-4.4-38.61z", "M400 160H224v.27h-64v63.5a32 32 0 0 1-64 0v-63.5H32a32 32 0 0 0-32 32v191.81A95.94 95.94 0 0 0 96 480h192a95.94 95.94 0 0 0 96-95.88V384h16a112 112 0 0 0 0-224zm0 160h-16v-96h16a48 48 0 0 1 0 96z"]],
    "mug-tea": [640, 512, [], "f875", ["M595.6 416H12.35c-25 0-11.59 64 36 64h511.36c47.69 0 60.89-64 35.89-64zM192 256h64a32 32 0 0 0 32-32v-66.75a32 32 0 0 0-9.38-22.62L240 96V32h-32v64l-38.63 38.63a32 32 0 0 0-9.37 22.62V224a32 32 0 0 0 32 32z", "M512 32H240v64l38.62 38.63a32 32 0 0 1 9.38 22.62V224a32 32 0 0 1-32 32h-64a32 32 0 0 1-32-32v-66.75a32 32 0 0 1 9.37-22.62L208 96V32h-87.95a23.94 23.94 0 0 0-24 24v232a96 96 0 0 0 96 96H384a96 96 0 0 0 96-96h32a128 128 0 0 0 0-256zm0 192h-32V96h32a64 64 0 0 1 0 128z"]],
    "music": [512, 512, [], "f001", ["M192 214.32V83.72l256-75.6V139.3z", "M128 126.51v261.41A139 139 0 0 0 96 384c-53 0-96 28.66-96 64s43 64 96 64 96-28.66 96-64V83.72L150.41 96A32 32 0 0 0 128 126.51zm342.38-125L448 8.12v315.81a138.4 138.4 0 0 0-32-3.93c-53 0-96 28.66-96 64s43 64 96 64 96-28.65 96-64V32a32 32 0 0 0-41.62-30.49z"]],
    "music-alt": [384, 512, [], "f8cf", ["M352 32v64a32 32 0 0 1-23 30.71l-73 21.39V17.56l54.94-16.23A32 32 0 0 1 352 32z", "M256 432c0 44.18-50.14 80-112 80S32 476.18 32 432s50.14-80 112-80a148.76 148.76 0 0 1 48 8V60.34a32 32 0 0 1 22.41-30.5L256 17.56z"]],
    "music-alt-slash": [640, 512, [], "f8d0", ["M272 352c-61.86 0-112 35.82-112 80s50.14 80 112 80 112-35.82 112-80v-5.18l-94.92-73.36A143.68 143.68 0 0 0 272 352zM438.94 1.33L342.4 29.84a32 32 0 0 0-22.4 30.5v155.22L384 265V148.15l73-21.39a32 32 0 0 0 23-30.71V32a32 32 0 0 0-41.06-30.67z", "M633.82 458.1L45.47 3.39A16 16 0 0 0 23 6.2L3.37 31.47a16 16 0 0 0 2.81 22.45l588.35 454.71a16 16 0 0 0 22.47-2.81l19.63-25.27a16 16 0 0 0-2.81-22.45z"]],
    "music-slash": [640, 512, [], "f8d1", ["M192 387.92a139 139 0 0 0-32-3.92c-53 0-96 28.66-96 64s43 64 96 64 96-28.66 96-64V327.88l-64-49.46zM534.38 1.51L214.41 96a31.87 31.87 0 0 0-21 21.73l107.82 83.32L512 139.3v184.62a139 139 0 0 0-32-3.92 136.93 136.93 0 0 0-22.15 2.11l110.91 85.71c4.51-7.37 7.24-15.35 7.24-23.82V32a32 32 0 0 0-41.62-30.49z", "M633.82 458.1L45.47 3.39A16 16 0 0 0 23 6.2L3.37 31.47a16 16 0 0 0 2.81 22.45l588.35 454.71a16 16 0 0 0 22.47-2.81l19.63-25.27a16 16 0 0 0-2.81-22.45z"]],
    "narwhal": [640, 512, [], "f6fe", ["M544 192c-243 0-315.29 224-380.12 224A35.92 35.92 0 0 1 128 380.11v-98l49.75-30.51A32 32 0 0 0 192 225v-81a16 16 0 0 0-24.88-13.31L96 178.11l-71.12-47.42A16 16 0 0 0 0 144v81a32 32 0 0 0 14.25 26.6L64 282.12v98A100 100 0 0 0 163.88 480H576a64 64 0 0 0 64-64V288a96.11 96.11 0 0 0-96-96zM432 360a24 24 0 1 1 24-24 24 24 0 0 1-24 24z", "M634.6 33.32a10.48 10.48 0 0 0-14.25 4.07L535 192l.37.1c2.85-.1 5.73-.1 8.63-.1a95.55 95.55 0 0 1 56.9 18.73l38.83-165.87a10.49 10.49 0 0 0-5.13-11.54zM432 312a24 24 0 1 0 24 24 24 24 0 0 0-24-24z"]],
    "network-wired": [640, 512, [], "f6ff", ["M624 232H344v-40h-48v40H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h104v40h48v-40h304v40h48v-40h104a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16z", "M224 192h192a32 32 0 0 0 32-32V32a32 32 0 0 0-32-32H224a32 32 0 0 0-32 32v128a32 32 0 0 0 32 32zm32-128h128v64H256zm320 256H416a32 32 0 0 0-32 32v128a32 32 0 0 0 32 32h160a32 32 0 0 0 32-32V352a32 32 0 0 0-32-32zm-32 128h-96v-64h96zM224 320H64a32 32 0 0 0-32 32v128a32 32 0 0 0 32 32h160a32 32 0 0 0 32-32V352a32 32 0 0 0-32-32zm-32 128H96v-64h96z"]],
    "neuter": [288, 512, [], "f22c", ["M144 256a80 80 0 1 1 80-80 80 80 0 0 1-80 80z", "M284.37 144A144 144 0 1 0 112 316.41V468a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12V316.41A144 144 0 0 0 284.37 144zM144 256a80 80 0 1 1 80-80 80 80 0 0 1-80 80z"]],
    "newspaper": [576, 512, [], "f1ea", ["M544 64H96a32 32 0 0 0-32 32v322.21c0 .36-.05.73-.09 1.09 0 .21 0 .42-.08.63s-.08.66-.13 1-.08.46-.12.68-.1.61-.16.91-.11.46-.16.69-.13.59-.21.87-.13.46-.19.69l-.24.84-.24.68c-.09.28-.18.55-.28.82s-.17.45-.26.67-.21.53-.32.79-.2.45-.3.67-.23.51-.35.76l-.33.65c-.13.25-.25.49-.39.74l-.36.63-.42.72-.39.61c-.15.23-.3.46-.46.69l-.42.6-.48.66c-.15.2-.3.39-.46.58s-.33.43-.51.64l-.48.55-.54.61-.51.53c-.18.2-.37.39-.57.59l-.53.5-.6.56-.55.48-.62.52-.58.46-.65.49-.6.43-.68.46c-.2.14-.41.27-.62.4l-.69.43-.65.37c-.23.13-.47.27-.71.39l-.67.34c-.24.13-.48.25-.73.36l-.69.31-.74.32-.71.28-.77.29-.72.24-.78.25-.75.21-.79.21-.76.17-.81.17-.77.14-.82.12-.79.1-.83.09-.81.06h-1.65H528a48 48 0 0 0 48-48V96a32 32 0 0 0-32-32zM304 372a12 12 0 0 1-12 12H140a12 12 0 0 1-12-12v-8a12 12 0 0 1 12-12h152a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12H140a12 12 0 0 1-12-12v-8a12 12 0 0 1 12-12h152a12 12 0 0 1 12 12zm208 96a12 12 0 0 1-12 12H348a12 12 0 0 1-12-12v-8a12 12 0 0 1 12-12h152a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12H348a12 12 0 0 1-12-12v-8a12 12 0 0 1 12-12h152a12 12 0 0 1 12 12zm0-96a12 12 0 0 1-12 12H140a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h360a12 12 0 0 1 12 12z", "M292 352H140a12 12 0 0 0-12 12v8a12 12 0 0 0 12 12h152a12 12 0 0 0 12-12v-8a12 12 0 0 0-12-12zm0-96H140a12 12 0 0 0-12 12v8a12 12 0 0 0 12 12h152a12 12 0 0 0 12-12v-8a12 12 0 0 0-12-12zm208 96H348a12 12 0 0 0-12 12v8a12 12 0 0 0 12 12h152a12 12 0 0 0 12-12v-8a12 12 0 0 0-12-12zm0-96H348a12 12 0 0 0-12 12v8a12 12 0 0 0 12 12h152a12 12 0 0 0 12-12v-8a12 12 0 0 0-12-12zM0 128v287.33c0 17.44 13.67 32.18 31.1 32.67A32 32 0 0 0 64 416V96H32a32 32 0 0 0-32 32z"]],
    "not-equal": [448, 512, [], "f53e", ["M35.59 466.83a16 16 0 0 0 3 22.42L64 508.75a16 16 0 0 0 22.43-3L168.52 400h-81zM162 304h81l74.51-96h-81zM441 22.78L415.61 3.29a16 16 0 0 0-22.43 3L311.11 112h81L444 45.21a16 16 0 0 0-3-22.43z", "M416 304H32a32 32 0 0 0-32 32v32a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32v-32a32 32 0 0 0-32-32zm0-192H32a32 32 0 0 0-32 32v32a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32v-32a32 32 0 0 0-32-32z"]],
    "notes-medical": [384, 512, [], "f481", ["M335 63h-80a64 64 0 0 1 64 64H63a64 64 0 0 1 64-64H47a48 48 0 0 0-48 48v352a48 48 0 0 0 48 48h288a48 48 0 0 0 48-48V111a48 48 0 0 0-48-48zm-47 281a8 8 0 0 1-8 8h-56v56a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-56h-56a8 8 0 0 1-8-8v-48a8 8 0 0 1 8-8h56v-56a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8v56h56a8 8 0 0 1 8 8z", "M255 63a64 64 0 0 0-128 0 64 64 0 0 0-64 64h256a64 64 0 0 0-64-64zm-64 24a24 24 0 1 1 24-24 23.94 23.94 0 0 1-24 24zm89 201h-56v-56a8 8 0 0 0-8-8h-48a8 8 0 0 0-8 8v56h-56a8 8 0 0 0-8 8v48a8 8 0 0 0 8 8h56v56a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8v-56h56a8 8 0 0 0 8-8v-48a8 8 0 0 0-8-8z"]],
    "object-group": [512, 512, [], "f247", ["M500 96a12 12 0 0 0 12-12V44a12 12 0 0 0-12-12h-40a12 12 0 0 0-12 12v20H64V44a12 12 0 0 0-12-12H12A12 12 0 0 0 0 44v40a12 12 0 0 0 12 12h20v320H12a12 12 0 0 0-12 12v40a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-20h384v20a12 12 0 0 0 12 12h40a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12h-20V96zm-84 276a12 12 0 0 1-12 12H236a12 12 0 0 1-12-12v-84H108a12 12 0 0 1-12-12V140a12 12 0 0 1 12-12h168a12 12 0 0 1 12 12v84h116a12 12 0 0 1 12 12z", "M288 140v136a12 12 0 0 1-12 12H108a12 12 0 0 1-12-12V140a12 12 0 0 1 12-12h168a12 12 0 0 1 12 12z"]],
    "object-ungroup": [576, 512, [], "f248", ["M544 224v192h26a6 6 0 0 1 6 6v52a6 6 0 0 1-6 6h-52a6 6 0 0 1-6-6v-26H224v26a6 6 0 0 1-6 6h-52a6 6 0 0 1-6-6v-52a6 6 0 0 1 6-6h26v-96h32v96h288V224H384v-32h128v-26a6 6 0 0 1 6-6h52a6 6 0 0 1 6 6v52a6 6 0 0 1-6 6z", "M384 96v192h26a6 6 0 0 1 6 6v52a6 6 0 0 1-6 6h-52a6 6 0 0 1-6-6v-26H64v26a6 6 0 0 1-6 6H6a6 6 0 0 1-6-6v-52a6 6 0 0 1 6-6h26V96H6a6 6 0 0 1-6-6V38a6 6 0 0 1 6-6h52a6 6 0 0 1 6 6v26h288V38a6 6 0 0 1 6-6h52a6 6 0 0 1 6 6v52a6 6 0 0 1-6 6z"]],
    "octagon": [512, 512, [], "f306", ["M497.9 150.6L361.43 14.1A48 48 0 0 0 327.54 0H184.46a48 48 0 0 0-33.89 14.1L14.1 150.5A48 48 0 0 0 0 184.4v143.1a48 48 0 0 0 14.1 33.9l136.47 136.5a48 48 0 0 0 33.89 14.1h143.08a48 48 0 0 0 33.89-14.1L497.9 361.4a48 48 0 0 0 14.1-33.9v-143a48 48 0 0 0-14.1-33.9zM424.39 323L323 424.38a26 26 0 0 1-18.35 7.62h-97.3a26 26 0 0 1-18.35-7.62L87.61 323A26 26 0 0 1 80 304.62v-97.33a26 26 0 0 1 7.62-18.39L189 87.61A26 26 0 0 1 207.35 80h97.3A26 26 0 0 1 323 87.62L424.39 189a26 26 0 0 1 7.61 18.38v97.24a26 26 0 0 1-7.61 18.38z", "M432 207.38v97.24a26 26 0 0 1-7.61 18.38L323 424.38a26 26 0 0 1-18.35 7.62h-97.3a26 26 0 0 1-18.35-7.62L87.61 323A26 26 0 0 1 80 304.62v-97.33a26 26 0 0 1 7.62-18.39L189 87.61A26 26 0 0 1 207.35 80h97.3A26 26 0 0 1 323 87.62L424.39 189a26 26 0 0 1 7.61 18.38z"]],
    "oil-can": [640, 512, [], "f613", ["M629.81 160.31L416 224l-50.49-25.24A64.2 64.2 0 0 0 336.9 192H176L37.72 166.86A31.93 31.93 0 0 0 0 198.34v95a32 32 0 0 0 26.28 31.48L96 337.46V384a32 32 0 0 0 32 32h274.64a32 32 0 0 0 22.76-9.51l212.26-214.75a8 8 0 0 0 2.34-5.66V168a8 8 0 0 0-10.19-7.69zM96 288.67l-48-8.73v-62.43l48 8.73z", "M592 288s-42.67 61.77-42.67 85.33a42.67 42.67 0 0 0 85.34 0C634.67 349.76 592 288 592 288zM336 96H176a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h56v48h48v-48h56a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16z"]],
    "oil-temp": [640, 512, [], "f614", ["M512 352.16c23.26 19.66 57.36 31.84 96 31.84h16a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-16c-26 0-45.8-8.42-56.09-17.9-8.9-8.21-19.66-14.1-31.77-14.1h-16.3c-12.11 0-22.87 5.89-31.77 14.1-8.24 7.6-22.8 14.3-41.59 16.74a111.54 111.54 0 0 1-31 63.86c5.46.51 10.79 1.3 16.46 1.3 38.66 0 72.76-12.19 96.06-31.84zM624 448h-16c-26 0-45.8-8.42-56.09-17.9-8.9-8.21-19.66-14.1-31.77-14.1h-16.3c-12.11 0-22.87 5.89-31.77 14.1C461.8 439.58 442 448 416 448s-45.8-8.42-56.09-17.9c-8.9-8.21-19.66-14.1-31.77-14.1h-16.3c-12.11 0-22.87 5.89-31.77 14.1C269.8 439.58 250 448 224 448s-45.8-8.42-56.09-17.9c-8.9-8.21-19.66-14.1-31.77-14.1h-16.3c-12.11 0-22.87 5.89-31.77 14.1C77.8 439.58 58 448 32 448H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h16c38.62 0 72.72-12.19 96-31.84 23.28 19.66 57.38 31.84 96 31.84s72.72-12.19 96-31.84c23.28 19.66 57.38 31.84 96 31.84s72.72-12.19 96-31.84c23.28 19.66 57.38 31.84 96 31.84h16a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM16 384h16c38.62 0 72.72-12.19 96-31.84 23.28 19.66 57.38 31.84 96 31.84 5.67 0 11-.79 16.46-1.3a111.47 111.47 0 0 1-31-63.86c-18.79-2.44-33.34-9.14-41.59-16.74-8.9-8.21-19.66-14.1-31.77-14.1h-16.3c-12.11 0-22.87 5.89-31.77 14.1C77.8 311.58 58 320 32 320H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16z", "M416 16v16a16 16 0 0 1-16 16h-48v32h48a16 16 0 0 1 16 16v16a16 16 0 0 1-16 16h-48v32h48a16 16 0 0 1 16 16v16a16 16 0 0 1-16 16h-48v22.75a80 80 0 1 1-64 0V16a16 16 0 0 1 16-16h96a16 16 0 0 1 16 16z"]],
    "om": [512, 512, [], "f679", ["M339 39.37l21.6 21.56a10.43 10.43 0 0 0 14.75 0l21.57-21.56a10.43 10.43 0 0 0 0-14.75L375.35 3.05a10.45 10.45 0 0 0-14.76 0L339 24.61a10.43 10.43 0 0 0 0 14.75zm115.29 27.89c-85.55 65.12-169 2.75-172.58 0a16 16 0 0 0-23.8 20.35c1.61 3 40.37 72.34 118.8 72.34 79.92 0 98.78-31.36 101.75-37.66a15.78 15.78 0 0 0 1.53-6.83V80a16 16 0 0 0-25.7-12.74z", "M224 384a64.07 64.07 0 0 0-64-64h-33a15.92 15.92 0 0 1-13.17-8.55l-16.18-32.18A16.08 16.08 0 0 1 112 256h31.9a48 48 0 1 0-30.27-85.29 15.57 15.57 0 0 1-19.2.21l-26.11-19.64a16.32 16.32 0 0 1-1.12-24.93c25.11-23.74 59.86-34.71 96-28.78 43.16 7.08 79.42 40.64 89.52 83.19A112.69 112.69 0 0 1 245 256h46.84a35.66 35.66 0 0 0 25.38-10.5l24.25-24.25A99.9 99.9 0 0 1 512 291.87V392c0 48.53-47.48 88-96 88-96 0-96-64-96-64v-37.88a8 8 0 0 1 14.2-5C349.31 391.75 376.58 416 416 416c13.24 0 32-10.77 32-24V291.87a35.89 35.89 0 0 0-61.26-25.38l-24.25 24.25A99.26 99.26 0 0 1 291.84 320h-21.69c11 18.9 17.81 40.58 17.81 64 0 70.58-57.43 128-128 128C41.13 512-.09 416 0 361.18c0-8.8 10.26-12.77 14.79-5.22 22.8 38 49.13 92 145.15 92A64.07 64.07 0 0 0 224 384z"]],
    "omega": [512, 512, [], "f67a", ["M512 440v48a24 24 0 0 1-24 24H352a32 32 0 0 1-32-32v-42.92a57.66 57.66 0 0 1 4-21.08h164a24 24 0 0 1 24 24zM24 416a24 24 0 0 0-24 24v48a24 24 0 0 0 24 24h136a32 32 0 0 0 32-32v-42.7a56.91 56.91 0 0 0-4.15-21.3z", "M56.61 416A254 254 0 0 1 0 256C0 104.82 131.74-16.18 286.45 1.77 399.19 14.85 492.12 104.36 509 216.6c11.41 75.72-10.75 146.23-53.64 199.4H324a63 63 0 0 1 22.92-28.62A159.66 159.66 0 0 0 416 256c0-99.51-91.32-178.1-194.56-156.36-62.49 13.16-112.1 65.08-123 128-11.3 65.36 17.46 125.15 65.68 159.07A66.53 66.53 0 0 1 187.85 416H56.61z"]],
    "ornament": [384, 512, [], "f7b8", ["M384.1 320a190.88 190.88 0 0 1-11.2 64H11.2a186.89 186.89 0 0 1 .2-128h361.2a194 194 0 0 1 11.5 64zM136.58 96a64 64 0 1 1 110.84 0zM176 64a16 16 0 1 0 16-16 16 16 0 0 0-16 16z", "M192 512c71 0 132.9-38.7 166.1-96H25.9c33.2 57.3 95.1 96 166.1 96zm96-358.18V112a16 16 0 0 0-16-16H112a16 16 0 0 0-16 16v41.82A193.4 193.4 0 0 0 25.9 224h332.2a193.4 193.4 0 0 0-70.1-70.18z"]],
    "otter": [640, 512, [], "f700", ["M544 192h-22.86l-92.47 49.79.19.39-.86-.18-34.57-70.71L512 112h126.67A96 96 0 0 1 544 192z", "M512 352h-28.22l-54.92-109.82-.86-.18-34.57-70.71L512 112h126.67A97 97 0 0 0 640 96V64a32 32 0 0 0-32-32h-32l-13.25-13.25A64 64 0 0 0 517.49 0H497a64 64 0 0 0-31.75 8.43L312 96h-56C150 96 64 182 64 288v1.61c0 32.75-16 62.14-39.56 84.89a79.91 79.91 0 0 0-23.19 71.8C8 485.1 44.15 512 83.53 512H192a32 32 0 0 0 0-64H80a16 16 0 0 1 0-32h224a16 16 0 0 0 16-16v-16a32 32 0 0 0-32-32h-64l149.49-80.5L448 416h80a16 16 0 0 0 16-16v-16a32 32 0 0 0-32-32zm0-304a16 16 0 1 1-16 16 16 16 0 0 1 16-16z"]],
    "outdent": [448, 512, [], "f03b", ["M432 416H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm3.17-128H204.83A12.82 12.82 0 0 0 192 300.83v38.34A12.82 12.82 0 0 0 204.83 352h230.34A12.82 12.82 0 0 0 448 339.17v-38.34A12.82 12.82 0 0 0 435.17 288zm0-128H204.83A12.82 12.82 0 0 0 192 172.83v38.34A12.82 12.82 0 0 0 204.83 224h230.34A12.82 12.82 0 0 0 448 211.17v-38.34A12.82 12.82 0 0 0 435.17 160zM432 32H16A16 16 0 0 0 0 48v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z", "M100.69 363.29c10 10 27.31 2.93 27.31-11.31V160c0-14.32-17.33-21.31-27.31-11.31l-96 96a16 16 0 0 0 0 22.62z"]],
    "overline": [448, 512, [], "f876", ["M432 0H16A16 16 0 0 0 0 16v32a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16z", "M232.19 128h-16.38A167.81 167.81 0 0 0 48 295.81v48.38A167.81 167.81 0 0 0 215.81 512h16.38A167.81 167.81 0 0 0 400 344.19v-48.38A167.81 167.81 0 0 0 232.19 128zM320 344.19A87.91 87.91 0 0 1 232.19 432h-16.38A87.91 87.91 0 0 1 128 344.19v-48.38A87.91 87.91 0 0 1 215.81 208h16.38A87.91 87.91 0 0 1 320 295.81z"]],
    "page-break": [576, 512, [], "f877", ["M160 64h176v64a16 16 0 0 0 16 16h64v64h64v-76.06a48.16 48.16 0 0 0-14.09-34L382 14.09A48 48 0 0 0 348.09 0H144a48.14 48.14 0 0 0-48 48.07V208h64zm256 384H160v-80H96v96a48 48 0 0 0 48 48h288a48 48 0 0 0 48-48v-96h-64z", "M243.6 256a19.59 19.59 0 0 0-19.6 19.6v24.8a19.59 19.59 0 0 0 19.6 19.6h88.8a19.59 19.59 0 0 0 19.6-19.6v-24.8a19.59 19.59 0 0 0-19.6-19.6zm316.4 0H432a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-400 48v-32a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16z"]],
    "pager": [512, 512, [], "f815", ["M448 224a32 32 0 0 1-32 32H96a32 32 0 0 1-32-32v-64a32 32 0 0 1 32-32h320a32 32 0 0 1 32 32z", "M448 64H64a64 64 0 0 0-64 64v256a64 64 0 0 0 64 64h384a64 64 0 0 0 64-64V128a64 64 0 0 0-64-64zM160 368H80a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h80zm128-16a16 16 0 0 1-16 16h-80v-48h80a16 16 0 0 1 16 16zm160-128a32 32 0 0 1-32 32H96a32 32 0 0 1-32-32v-64a32 32 0 0 1 32-32h320a32 32 0 0 1 32 32z"]],
    "paint-brush": [512, 512, [], "f1fc", ["M512 49.55c0 16.14-6.52 31.64-13.9 46C385.06 306.53 349.06 352 287 352a92 92 0 0 1-22.39-3l-63.82-53.18a92.58 92.58 0 0 1-8.73-38.7c0-53.75 21.27-58 225.68-240.64C428.53 6.71 442.74 0 457.9 0 486 0 512 20.64 512 49.55z", "M255 382.68a86.64 86.64 0 0 1 1 9.13C256 468.23 203.87 512 128 512 37.94 512 0 439.62 0 357.27c9.79 6.68 44.14 34.35 55.25 34.35a15.26 15.26 0 0 0 14.59-10c20.66-54.44 57.07-69.72 97.19-72.3z"]],
    "paint-brush-alt": [512, 512, [], "f5a9", ["M490.92 133L272.11 354.51l-78-65L366 33.1c62-88.4 198.15 19.42 124.92 99.9z", "M167.87 309.29l87.07 72.56a86.87 86.87 0 0 1 1.06 10C256 468.23 203.86 512 128 512 37.93 512 0 439.62 0 357.27c9.79 6.68 44.14 34.35 55.25 34.35a15.26 15.26 0 0 0 14.59-10c20.8-54.8 57.58-69.92 98.03-72.33z"]],
    "paint-roller": [512, 512, [], "f5aa", ["M384 160H32a32 32 0 0 1-32-32V32A32 32 0 0 1 32 0h352a32 32 0 0 1 32 32v96a32 32 0 0 1-32 32z", "M512 128v64a96 96 0 0 1-96 96H256v32a32 32 0 0 1 32 32v128a32 32 0 0 1-32 32h-64a32 32 0 0 1-32-32V352a32 32 0 0 1 32-32v-32a64 64 0 0 1 64-64h160a32 32 0 0 0 32-32V64a64 64 0 0 1 64 64z"]],
    "palette": [512, 512, [], "f53f", ["M204.29 5c-99.4 19.4-179.5 99.29-199.1 198.4-37 187 131.7 326.39 258.8 306.69 41.2-6.4 61.4-54.59 42.5-91.69-23.1-45.4 9.9-98.4 60.9-98.4h79.7c35.8 0 64.8-29.6 64.9-65.31C511.49 97.13 368.09-26.87 204.29 5zM96 320a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm32-128a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm128-64a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm128 64a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M96 256a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm32-128a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm128-64a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm128 64a32 32 0 1 0 32 32 32 32 0 0 0-32-32z"]],
    "pallet": [640, 512, [], "f482", ["M256 0v128l64-32 64 32V0h112a16 16 0 0 1 16 16v224a16 16 0 0 1-16 16H144a16 16 0 0 1-16-16V16a16 16 0 0 1 16-16z", "M624 384a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h48v64H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h608a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-48v-64zm-336 64H128v-64h160zm224 0H352v-64h160zM384 128V0H256v128l64-32z"]],
    "pallet-alt": [640, 512, [], "f483", ["M560 64H400a16 16 0 0 0-16 16v160a16 16 0 0 0 16 16h160a16 16 0 0 0 16-16V80a16 16 0 0 0-16-16zM304 0H80a16 16 0 0 0-16 16v224a16 16 0 0 0 16 16h224a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16z", "M624 384a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h48v64H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h608a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-48v-64zm-336 64H128v-64h160zm224 0H352v-64h160z"]],
    "paper-plane": [512, 512, [], "f1d8", ["M245.53 410.5l-75 92.83c-14 17.1-42.5 7.8-42.5-15.8V358l280.26-252.77c5.5-4.9 13.3 2.6 8.6 8.3L191.72 387.87z", "M511.59 28l-72 432a24.07 24.07 0 0 1-33 18.2l-214.87-90.33 225.17-274.34c4.7-5.7-3.1-13.2-8.6-8.3L128 358 14.69 313.83a24 24 0 0 1-2.2-43.2L476 3.23c17.29-10 39 4.6 35.59 24.77z"]],
    "paperclip": [448, 512, [], "f0c6", ["M171.43 319.93c-4.94 5-5.24 13.43-.65 18.29a10.66 10.66 0 0 0 15.69.16l182.85-186.85a52.37 52.37 0 0 0 0-72.79 48 48 0 0 0-69.15 0L90.39 293.3c-34.76 35.56-35.3 93.12-1.19 128.31a85.28 85.28 0 0 0 123.06.28l172.06-176a16 16 0 0 1 22.62-.26L429.82 268a16 16 0 0 1 .26 22.63L258 466.63a149.21 149.21 0 0 1-214.77-.49c-58.43-60.29-57.35-157.51 1.38-217.58L254.39 34a111.9 111.9 0 0 1 160.67 0c43.89 44.89 43.95 117.33 0 162.28L232.21 383.13a74.61 74.61 0 0 1-108-1c-28.27-30-27.37-77.47 1.45-106.95l143.77-146.84a16 16 0 0 1 22.62-.24l22.86 22.38a16 16 0 0 1 .24 22.63z", ""]],
    "parachute-box": [512, 512, [], "f4cd", ["M487.1 192L350.3 343.9c.7 2.7 1.6 5.2 1.6 8.1v128a32 32 0 0 1-32 32h-128a32 32 0 0 1-32-32V352c0-2.9.9-5.5 1.6-8.1L24.8 192h43.1l116.6 129.5c2.5-.6 4.8-1.5 7.5-1.5h48V192h32v128h48c2.7 0 5 .9 7.5 1.5L444.1 192z", "M.1 175c-1.1 9.1 6.8 17 16 17H96c0-75.1 26-136.3 62.4-175.7C78.5 42.7 9.2 99.5.1 175zM256 0c-59.1 0-128 76.8-128 192h256C384 76.8 315.1 0 256 0zm255.9 175c-9.1-75.6-78.4-132.4-158.3-158.7C390 55.7 416 116.9 416 192h79.8c9.3 0 17.2-7.8 16.1-17z"]],
    "paragraph": [448, 512, [], "f1dd", ["M368 96v368a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V96z", "M432 48v32a16 16 0 0 1-16 16H272v368a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V352h-32a160 160 0 0 1 0-320h240a16 16 0 0 1 16 16z"]],
    "paragraph-rtl": [384, 512, [], "f878", ["M144 224h16v80a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V64h32v240a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V64h16a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16H144C80 0 32 48 32 112s48 112 112 112z", "M368 384H112v-48c0-14.25-17.23-21.39-27.31-11.31l-80 80a16 16 0 0 0 0 22.62l80 80C94 516.64 112 511.64 112 496v-48h256a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "parking": [448, 512, [], "f540", ["M272 224a32.09 32.09 0 0 1-32 32h-48v-64h48a32.09 32.09 0 0 1 32 32zM448 80v352a48 48 0 0 1-48 48H48a48 48 0 0 1-48-48V80a48 48 0 0 1 48-48h352a48 48 0 0 1 48 48zM336 224a96.15 96.15 0 0 0-96-96h-96a16 16 0 0 0-16 16v224a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-48h48a96.15 96.15 0 0 0 96-96z", "M240 128h-96a16 16 0 0 0-16 16v224a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-48h48a96 96 0 0 0 0-192zm0 128h-48v-64h48a32 32 0 0 1 0 64z"]],
    "parking-circle": [496, 512, [], "f615", ["M280,208H232v32h48a16,16,0,0,0,0-32ZM248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8Zm32,296H232v48a16,16,0,0,1-16,16H184a16,16,0,0,1-16-16V160a16,16,0,0,1,16-16h96a80,80,0,0,1,0,160Z", "M280,144H184a16,16,0,0,0-16,16V352a16,16,0,0,0,16,16h32a16,16,0,0,0,16-16V304h48a80,80,0,0,0,0-160Zm0,96H232V208h48a16,16,0,0,1,0,32Z"]],
    "parking-circle-slash": [496, 512, [], "f616", ["M168,352V234.61L257.78,304H232v48a16,16,0,0,1-16,16H184A16,16,0,0,1,168,352ZM360,224a80,80,0,0,0-80-80H184a16,16,0,0,0-15,10.49L238.22,208H280a16,16,0,0,1,0,32h-.38l54.95,42.47A79.75,79.75,0,0,0,360,224Z", "M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8Zm0,432C146.54,440,64,357.46,64,256a182.66,182.66,0,0,1,21.17-85.41L371.56,391.94A183.06,183.06,0,0,1,248,440Zm162.83-98.59L124.44,120.06A183.06,183.06,0,0,1,248,72c101.46,0,184,82.54,184,184a182.66,182.66,0,0,1-21.17,85.41Z"]],
    "parking-slash": [640, 512, [], "f617", ["M106.27 50.36A47.91 47.91 0 0 1 144 32h352a48 48 0 0 1 48 48v308.68L410 285.09A95.93 95.93 0 0 0 336 128h-96a16.06 16.06 0 0 0-15.79 13.52zM336 192h-46.47l69.74 53.9A32 32 0 0 0 336 192zm-48 176a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-64.86L96 204.21V432a48 48 0 0 0 48 48h308.83L288 352.6z", "M3.37 31.45L23 6.18a16 16 0 0 1 22.47-2.81L633.82 458.1a16 16 0 0 1 2.82 22.45L617 505.82a16 16 0 0 1-22.46 2.81L6.18 53.9a16 16 0 0 1-2.81-22.45z"]],
    "passport": [448, 512, [], "f5ab", ["M224 64a128 128 0 1 0 128 128A128 128 0 0 0 224 64zm94.38 112h-39.09c-1.49-27-6.53-51.35-14.21-70.41a95.85 95.85 0 0 1 53.3 70.41zm-188.76 32h39.09c1.49 27 6.53 51.35 14.21 70.41a95.87 95.87 0 0 1-53.3-70.41zm39.09-32h-39.09a95.85 95.85 0 0 1 53.3-70.41C175.25 124.65 170.2 149 168.71 176zM224 286.69c-7.69-7.45-20.77-34.43-23.44-78.69h46.87c-2.66 44.27-15.74 71.24-23.43 78.69zM200.57 176c2.66-44.26 15.74-71.24 23.44-78.69 7.69 7.45 20.77 34.43 23.43 78.69zm64.51 102.41c7.68-19.06 12.72-43.41 14.21-70.41h39.09a95.85 95.85 0 0 1-53.3 70.41z", "M224 286.69c7.69-7.45 20.77-34.42 23.43-78.69h-46.87c2.67 44.26 15.75 71.24 23.44 78.69zM129.62 208a95.87 95.87 0 0 0 53.3 70.41C175.24 259.35 170.2 235 168.71 208zm0-32h39.09c1.49-27 6.54-51.35 14.21-70.41a95.85 95.85 0 0 0-53.3 70.41zm135.46-70.41c7.68 19.06 12.72 43.41 14.21 70.41h39.09a95.85 95.85 0 0 0-53.3-70.41zM200.57 176h46.87c-2.66-44.26-15.74-71.24-23.43-78.69-7.7 7.45-20.78 34.43-23.44 78.69zM416 0H64A64 64 0 0 0 0 64v384a64 64 0 0 0 64 64h352a32 32 0 0 0 32-32V32a32 32 0 0 0-32-32zm-80 416H112a16 16 0 0 1 0-32h224a16 16 0 0 1 0 32zm-112-96a128 128 0 1 1 128-128 128 128 0 0 1-128 128zm41.08-41.59a95.85 95.85 0 0 0 53.3-70.41h-39.09c-1.49 27-6.53 51.35-14.21 70.41z"]],
    "pastafarianism": [640, 512, [], "f67b", ["M638.43 378.65a23.94 23.94 0 0 1-31 13.88c-8.11-3.09-14.34-.19-31.39 11.36-13.55 9.15-30.83 20.84-52.42 20.84a63.85 63.85 0 0 1-23-4.39C468 407.9 460.69 379 455.35 357.9c-2.21-8.72-4-14.49-6-18.87a194.54 194.54 0 0 1-61.62 34.16c10 37 32.28 90.81 60.22 90.81a24 24 0 0 1 0 48c-66.74 0-97.05-88.63-107.42-129.14-6.69.6-13.42 1.14-20.58 1.14s-13.89-.54-20.58-1.14C289.05 423.37 258.74 512 192 512a24 24 0 0 1 0-48c28.08 0 50.3-53.8 60.26-90.8a194.47 194.47 0 0 1-61.64-34.2c-2 4.38-3.74 10.15-6 18.87-5.35 21.11-12.67 50-45.33 62.44a63.85 63.85 0 0 1-23 4.39c-21.59 0-38.87-11.68-52.42-20.84-17.05-11.55-23.23-14.45-31.39-11.36a24 24 0 0 1-17.1-44.85c32.65-12.47 57.34 4.25 75.37 16.45 17.08 11.53 23.3 14.42 31.41 11.36s10.83-9.38 15.89-29.38c3.33-13.15 7.44-29.32 18-42.65-2.24-2.91-4.43-5.78-6.38-8.57C139.53 304.45 126.29 312 108 312c-33.95 0-50.87-25.78-62.06-42.83C35.34 253 30.94 248 24 248a24 24 0 0 1 0-48c34 0 50.88 25.78 62.06 42.83C96.66 259 101.06 264 108 264c17.15 0 37.68-61.56 97.27-101.9l-17.11-34.22c1.27.07 2.55.12 3.84.12a63.93 63.93 0 0 0 53.42-28.76l18.13 36.27a216 216 0 0 1 112.92 0l18.12-36.25A64 64 0 0 0 448 128c1.29 0 2.57 0 3.85-.13l-17.11 34.22C494.52 202.57 514.69 264 532 264c6.94 0 11.34-5 21.94-21.17C565.13 225.78 582.05 200 616 200a24 24 0 0 1 0 48c-6.94 0-11.35 5-21.94 21.17C582.87 286.22 566 312 532 312c-18.29 0-31.53-7.55-41.7-17.12-1.95 2.78-4.14 5.66-6.38 8.57 10.51 13.33 14.62 29.5 17.95 42.65 5.06 20 7.77 26.29 15.89 29.38s14.35.17 31.41-11.36c18-12.2 42.67-29 75.37-16.45a24 24 0 0 1 13.89 30.98z", "M192 0a64 64 0 1 0 64 64 64 64 0 0 0-64-64zm0 80a16 16 0 1 1 16-16 16 16 0 0 1-16 16zM448 0a64 64 0 1 0 64 64 64 64 0 0 0-64-64zm0 80a16 16 0 1 1 16-16 16 16 0 0 1-16 16z"]],
    "paste": [448, 512, [], "f0ea", ["M320 264V160H184a24 24 0 0 0-24 24v304a24 24 0 0 0 24 24h240a24 24 0 0 0 24-24V288H344a24.07 24.07 0 0 1-24-24zm121-31l-66-66a24 24 0 0 0-17-7h-6v96h96v-6.06a24 24 0 0 0-7-16.94z", "M296 32h-80.61a63.94 63.94 0 0 0-110.78 0H24A24 24 0 0 0 0 56v336a24 24 0 0 0 24 24h104V184a56.06 56.06 0 0 1 56-56h136V56a24 24 0 0 0-24-24zM160 88a24 24 0 1 1 24-24 24 24 0 0 1-24 24z"]],
    "pause": [448, 512, [], "f04c", ["M144 31H48A48 48 0 0 0 0 79v352a48 48 0 0 0 48 48h96a48 48 0 0 0 48-48V79a48 48 0 0 0-48-48zm-16 368a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16V111a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16zM400 31h-96a48 48 0 0 0-48 48v352a48 48 0 0 0 48 48h96a48 48 0 0 0 48-48V79a48 48 0 0 0-48-48zm-16 368a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V111a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16z", "M112 95H80a16 16 0 0 0-16 16v288a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V111a16 16 0 0 0-16-16zm256 0h-32a16 16 0 0 0-16 16v288a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V111a16 16 0 0 0-16-16z"]],
    "pause-circle": [512, 512, [], "f28b", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm-16 328a16 16 0 0 1-16 16h-48a16 16 0 0 1-16-16V176a16 16 0 0 1 16-16h48a16 16 0 0 1 16 16zm112 0a16 16 0 0 1-16 16h-48a16 16 0 0 1-16-16V176a16 16 0 0 1 16-16h48a16 16 0 0 1 16 16z", "M224 160h-48a16 16 0 0 0-16 16v160a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V176a16 16 0 0 0-16-16zm112 0h-48a16 16 0 0 0-16 16v160a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V176a16 16 0 0 0-16-16z"]],
    "paw": [512, 512, [], "f1b0", ["M448 424.26c0 34.9-26.81 55.75-71.74 55.75-48.41 0-80.75-25.08-120.26-25.08-39.17 0-71.42 25.08-120.26 25.08C90.82 480 64 459.16 64 424.26 64 346.77 176.6 224 256 224s192 122.77 192 200.26z", "M474.84 161.28c-29.12-7-61.15 15.48-71.56 50.13s4.77 68.38 33.89 75.34 61.15-15.48 71.56-50.13-4.73-68.38-33.89-75.34zm-437.67 0C8.05 168.23-7.12 202 3.28 236.61s42.44 57.09 71.56 50.13 44.29-40.69 33.89-75.34-42.44-57.09-71.56-50.13zm113.4-127.89c-30.94 8.14-46.42 49.94-34.58 93.36s46.53 72 77.46 63.87 46.42-49.94 34.55-93.36-46.49-72.01-77.43-63.87zm210.88 0c-30.94-8.15-65.62 20.45-77.45 63.87s3.64 85.22 34.58 93.36 65.62-20.45 77.46-63.87-3.65-85.21-34.59-93.36z"]],
    "paw-alt": [448, 512, [], "f701", ["M416 384a96 96 0 0 1-96 96c-51.71 1.76-72.19-32-96-32s-44.29 33.75-96 32a95.76 95.76 0 0 1-47.32-179.22c27.05-15.27 46.88-60.87 67.17-97.83C163.59 174.31 193.79 160 224 160s60.41 14.31 76.14 42.95c20 36.42 40.88 83 67.17 97.83A95.32 95.32 0 0 1 416 384z", "M400 144a48 48 0 1 0 48 48 48 48 0 0 0-48-48zM304 32a48 48 0 1 0 48 48 48 48 0 0 0-48-48zM48 144a48 48 0 1 0 48 48 48 48 0 0 0-48-48zm96-112a48 48 0 1 0 48 48 48 48 0 0 0-48-48z"]],
    "paw-claws": [512, 512, [], "f702", ["M448 456.25c0 34.9-26.81 55.75-71.74 55.75-48.41 0-80.75-25.08-120.26-25.08-39.17 0-71.42 25.08-120.26 25.08C90.81 512 64 491.15 64 456.25 64 378.76 176.59 256 256 256s192 122.76 192 200.25z", "M320 0v75c-15.95 11.26-29.49 30.37-36 54.29-11.84 43.42 3.64 85.22 34.58 93.36s65.62-20.45 77.46-63.87c8.44-30.94 3-61.05-12-78.75zm173.51 190.37L448 128v66.94c-19.83 6.55-37.51 24.43-44.72 48.46-10.4 34.65 4.77 68.38 33.89 75.34s61.15-15.48 71.56-50.13a76 76 0 0 0 3.27-21.52 96.28 96.28 0 0 0-18.49-56.72zM192 75V0l-64 80c-15 17.7-20.45 47.82-12 78.75 11.84 43.42 46.53 72 77.46 63.87s46.42-49.94 34.58-93.36C221.49 105.33 208 86.21 192 75zM64 195v-67l-45.51 62.37A96.2 96.2 0 0 0 0 247.09a76.09 76.09 0 0 0 3.28 21.52c10.4 34.65 42.44 57.09 71.56 50.13s44.28-40.7 33.88-75.35c-7.21-24.03-24.89-41.91-44.72-48.46z"]],
    "peace": [496, 512, [], "f67c", ["M409.54,344.25a184.93,184.93,0,0,1-31.43,41.86q-4.2,4.18-8.61,8.07L280,322.58V437.24a186.89,186.89,0,0,1-64,0V322.58l-89.5,71.6q-4.41-3.89-8.61-8.07a184.93,184.93,0,0,1-31.43-41.86L216,240.62V74.76a186.89,186.89,0,0,1,64,0V240.62Z", "M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8ZM378.11,386.11a184,184,0,0,1-260.22,0h0a183.93,183.93,0,0,1,0-260.21c71.74-72,188.25-72.15,260.21-.41s72.16,188.25.41,260.22Z"]],
    "pegasus": [576, 512, [], "f703", ["M64.36 215.74A39.92 39.92 0 0 0 48 248v56a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-56a88 88 0 0 1 88-88h.46a95.62 95.62 0 0 0-24.1 55.74z", "M567.34 54.8c-3.78-4-8.58-9.12-13.69-14.5 11.06-6.84 19.5-17.49 22.18-30.66A8.09 8.09 0 0 0 567.9 0h-120a128 128 0 0 0-128 128c-63.9 0-104.18-36.78-127.64-90.27-3.22-7.35-13.61-7.76-17-.5A158.37 158.37 0 0 0 160 105.1c0 67 51 133.09 128 147.74V256c-82.89 0-143.33-57.52-157-122.86q-1.5.49-3 1v-.7a95.72 95.72 0 0 0-33.46 160.44l-25.72 68.6a63.94 63.94 0 0 0-2.16 38l24.85 99.41A16 16 0 0 0 107 512h66a16 16 0 0 0 15.52-19.88l-26.33-105.26L186 323.27l134 22.33V496a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16V318.22A111.55 111.55 0 0 0 448 240c0-.22-.07-.42-.08-.64V136.89l16 7.11 18.9 37.7a32 32 0 0 0 40.49 15.37l32.55-13A32 32 0 0 0 576 154.31l-.06-77.71a31.76 31.76 0 0 0-8.6-21.8zM511.92 96a16 16 0 1 1 16-16 16 16 0 0 1-16 16z"]],
    "pen": [512, 512, [], "f304", ["M498 142.08l-56.6 56.55-128-128 56.55-56.55a48 48 0 0 1 67.91 0L498 74.17a48 48 0 0 1 0 67.91z", "M12.85 371.11L.15 485.33a24 24 0 0 0 26.49 26.51l114.14-12.6 278-278-128-128z"]],
    "pen-alt": [512, 512, [], "f305", ["M498 74.17a48 48 0 0 1 0 67.91l-56.6 56.55-128-128 56.55-56.55a48 48 0 0 1 67.91 0z", "M336 138.49l82.77 82.77L222 418.05a327 327 0 0 1-195.34 93.8A24 24 0 0 1 .15 485.34v-.23A327 327 0 0 1 94 290l151.52-151.52-22.63-22.62-101.82 101.82a16 16 0 0 1-22.63 0l-22.63-22.63a16 16 0 0 1 0-22.62L194.59 53.64a40 40 0 0 1 56.56 0z"]],
    "pen-fancy": [512, 512, [], "f5ac", ["M163.25 249.87l98.88 98.88-33.07 84.07a32 32 0 0 1-20.24 20.24L32 512l-4.68-4.68 92.89-92.89c2.56.66 5 1.57 7.8 1.57a32 32 0 1 0-32-32c0 2.77.91 5.24 1.57 7.8L4.69 484.69 0 480l58.94-176.82a32 32 0 0 1 20.24-20.24z", "M483.48 142.55L284 325.66l-97.85-97.85 183.1-199.49c74.48-84.26 199.15 39.16 114.23 114.23z"]],
    "pen-nib": [512, 512, [], "f5ad", ["M288 96l128 128-42.79 151.4a64 64 0 0 1-41.35 43.31L52 512l-14.69-14.69L187.42 347.2a48.45 48.45 0 1 0-22.62-22.62L14.69 474.69 0 460l93.29-279.86a64 64 0 0 1 43.31-41.35z", "M497.94 74.17a48 48 0 0 1 0 67.91l-56.55 56.55-128-128 56.55-56.55a48 48 0 0 1 67.91 0z"]],
    "pen-square": [448, 512, [], "f14b", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-97.8 210L166.5 377.7l-57.1 6.3a12.11 12.11 0 0 1-13.3-13.3l6.3-57.1 135.7-135.7a6.13 6.13 0 0 1 8.6.1l55.5 55.5a6.1 6.1 0 0 1 0 8.5zm42.8-43l-23.1 23.1a6.1 6.1 0 0 1-8.5 0l-55.5-55.5a6.1 6.1 0 0 1 0-8.5L281 135a23.9 23.9 0 0 1 33.9 0l30.1 30.1a24.08 24.08 0 0 1 0 33.9z", "M345 165.1L314.9 135a23.9 23.9 0 0 0-33.9 0l-23.1 23.1a6.1 6.1 0 0 0 0 8.5l55.5 55.5a6.1 6.1 0 0 0 8.5 0L345 199a24.08 24.08 0 0 0 0-33.9zM246.7 178a6.13 6.13 0 0 0-8.6-.1L102.4 313.6l-6.3 57.1a12.11 12.11 0 0 0 13.3 13.3l57.1-6.3L302.2 242a6.1 6.1 0 0 0 0-8.5z"]],
    "pencil": [512, 512, [], "f040", ["M96 352H32l-16 64 80 80 64-16v-64H96zM498 74.26l-.11-.11L437.77 14a48.09 48.09 0 0 0-67.9 0l-46.1 46.1a12 12 0 0 0 0 17l111 111a12 12 0 0 0 17 0l46.1-46.1a47.93 47.93 0 0 0 .13-67.74z", "M.37 483.85a24 24 0 0 0 19.47 27.8 24.27 24.27 0 0 0 8.33 0l67.32-16.16-79-79zM412.3 210.78l-111-111a12.13 12.13 0 0 0-17.1 0L32 352h64v64h64v64l252.27-252.25a12 12 0 0 0 .03-16.97z"]],
    "pencil-alt": [512, 512, [], "f303", ["M96 352H32l-16 64 80 80 64-16v-64H96zM498 74.26l-.11-.11L437.77 14a48.09 48.09 0 0 0-67.9 0l-46.1 46.1a12 12 0 0 0 0 17l111 111a12 12 0 0 0 17 0l46.1-46.1a47.93 47.93 0 0 0 .13-67.74z", "M.37 483.85a24 24 0 0 0 19.47 27.8 24.27 24.27 0 0 0 8.33 0l67.32-16.16-79-79zM412.3 210.78l-111-111a12.13 12.13 0 0 0-17.1 0L32 352h64v64h64v64l252.27-252.25a12 12 0 0 0 .03-16.97zm-114.41-24.93l-154 154a14 14 0 1 1-19.8-19.8l154-154a14 14 0 1 1 19.8 19.8z"]],
    "pencil-paintbrush": [512, 512, [], "f618", ["M21.08 133l99.11 100.33L216 137.52 146 33.11C84.06-55.29-52.15 52.53 21.08 133zm435.68 258.63a15.26 15.26 0 0 1-14.59-10c-18.13-47.78-48.4-65.38-82.65-70.71l-101.69 101.7C266.65 476 315.43 512 384 512c90.07 0 128-72.38 128-154.73-9.78 6.73-44.14 34.36-55.24 34.36z", "M19.08 379.68L.33 487.12a21.23 21.23 0 0 0 24.59 24.56l107.44-18.84 296.93-296.93L316.08 82.72zM497.94 59.32l-45.26-45.25a48 48 0 0 0-67.94 0l-46 46 113.2 113.2 46-46a48 48 0 0 0 0-67.95z"]],
    "pencil-ruler": [512, 512, [], "f5ae", ["M138.25 127.05a7.92 7.92 0 0 1-11.2 0l-11.21-11.21a7.92 7.92 0 0 1 0-11.21L177.5 43 143.87 9.3A31.73 31.73 0 0 0 99 9.3L9.29 99a31.74 31.74 0 0 0 0 44.86l100.17 100.19L244 109.49l-44.08-44.12zm364.46 241.1l-33.63-33.64-61.68 61.68a7.92 7.92 0 0 1-11.21 0L385 385a7.92 7.92 0 0 1 0-11.21l61.68-61.68L402.52 268 267.94 402.51l100.21 100.2a31.7 31.7 0 0 0 44.85 0L502.71 413a31.72 31.72 0 0 0 0-44.85z", "M497.94 59.32l-45.25-45.25a48.05 48.05 0 0 0-67.95 0l-46 46 113.21 113.2 46-46a48 48 0 0 0-.01-67.95zM19.08 379.68L.33 487.12a21.23 21.23 0 0 0 24.59 24.56l107.45-18.84 296.92-296.93L316.08 82.72z"]],
    "pennant": [576, 512, [], "f456", ["M128 360.8V112.5a15.8 15.8 0 0 1 16.3-16c43.2 2 95.3 13.2 155.2 42.4 140.6 68.5 223.7 62.9 252.9 57.2 18-3.8 31.3 18.1 18.6 32.4-78.1 88.2-179.8 108.8-184.1 109.6-134.8 26.1-153.3 7.5-237.1 37.5-10.6 3.8-21.8-3.6-21.8-14.8z", "M0 56a56 56 0 1 1 80 50.4V504a8 8 0 0 1-8 8H40a8 8 0 0 1-8-8V106.4A56 56 0 0 1 0 56z"]],
    "people-carry": [640, 512, [], "f4ce", ["M512 0a48 48 0 1 0 48 48 48 48 0 0 0-48-48zM128 0a48 48 0 1 0 48 48 48 48 0 0 0-48-48zm272 128H240a16 16 0 0 0-16 16v171.59c4.63 2.49 11.33 3.95 16 4.32h160c4.67-.37 11.35-1.83 16-4.3V143.7a16 16 0 0 0-16-15.7z", "M637.71 468.1l-44-110-41.09 46.4-2 18.2 27.69 69.2A32 32 0 0 0 608 512a31.09 31.09 0 0 0 11.9-2.3 32 32 0 0 0 17.81-41.6zm-591.4-110l-44 110a32 32 0 0 0 59.4 23.8l27.71-69.2-2-18.2zm150.31-162.2a108.86 108.86 0 0 0-48.1-59.4 61.72 61.72 0 0 0-56.1-3.3 64.81 64.81 0 0 0-37.5 44.9l-18.4 80.2a64 64 0 0 0 14.4 56.7l67.2 75.9 10.09 92.6A32 32 0 0 0 160 512c1.19 0 2.29-.1 3.5-.2a31.94 31.94 0 0 0 28.29-35.3l-10.1-92.8a64 64 0 0 0-15.59-35l-43.31-49 17.61-70.3 6.79 20.4c4.1 12.5 11.91 23.4 24.5 32.6l51.1 32.5c.38.24.78.46 1.19.68V240l-16.06-10.2zm406.9 62.4L585 178.1a64.81 64.81 0 0 0-37.5-44.9 61.7 61.7 0 0 0-56.1 3.3 109.53 109.53 0 0 0-48.11 59.4L432 229.8 416 240v75.6c.42-.23.83-.46 1.21-.7l51.1-32.5c12.61-9.2 20.4-20 24.5-32.6l6.81-20.4 17.59 70.3-43.29 49a63.86 63.86 0 0 0-15.61 35l-10.1 92.8a32 32 0 0 0 28.31 35.3c1.19.1 2.29.2 3.5.2a32 32 0 0 0 31.79-28.5l10.11-92.6 67.19-75.9a64.4 64.4 0 0 0 14.41-56.7z"]],
    "pepper-hot": [512, 512, [], "f816", ["M0 456a56 56 0 0 1 56-56c141.58 0 163.44-181.24 221.92-250.82l52.75 24.22v89.7h107.46l37.05 38.54C426.65 389.11 268.64 512 56 512a56 56 0 0 1-56-56z", "M362.67 152.86L288 118.57c22.34-14 48.34-22.59 76.34-22.59a142.91 142.91 0 0 1 57.16 12c18.45-37.22 8.26-62 1.4-72.32a8.07 8.07 0 0 1 .89-10.23l22.9-23a6.67 6.67 0 0 1 .68-.62A8 8 0 0 1 458.62 3c18.56 23.48 35.3 71.91 3.14 131.75A154 154 0 0 1 512 248.67c0 13.68-2.3 26.69-5.56 39.31l-54.68-56.88h-89.09z"]],
    "percent": [448, 512, [], "f295", ["M336 288a112 112 0 1 0 112 112 111.94 111.94 0 0 0-112-112zm0 160a48 48 0 1 1 48-48 48 48 0 0 1-48 48zM112 0a112 112 0 1 0 112 112A111.94 111.94 0 0 0 112 0zm0 160a48 48 0 1 1 48-48 48 48 0 0 1-48 48z", "M4.7 474.1l368-463.7A24 24 0 0 1 392.3.2l31.6-.1c19.4-.1 30.9 21.8 19.7 37.8L77.4 501.6a24 24 0 0 1-19.6 10.2l-33.4.1c-19.5 0-30.9-21.9-19.7-37.8z"]],
    "percentage": [384, 512, [], "f541", ["M365.25 338.74a64 64 0 1 0 0 90.51 64 64 0 0 0 0-90.51zm-346.51-256a64 64 0 1 0 90.51 0 64 64 0 0 0-90.51 0z", "M363.31 152.56L88.56 427.31a32 32 0 0 1-45.25 0l-22.62-22.62a32 32 0 0 1 0-45.25L295.44 84.69a32 32 0 0 1 45.25 0l22.62 22.62a32 32 0 0 1 0 45.25z"]],
    "person-booth": [576, 512, [], "f756", ["M192 32v160h64V0h-32a32 32 0 0 0-32 32zm0 464a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V320h-64zM64 32a48 48 0 1 0 48 48 48 48 0 0 0-48-48zM544 0h-32v496a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V32a32 32 0 0 0-32-32z", "M288 0v32l31.5 223.1-30.9 154.6c-4.3 21.6 13 38.3 31.4 38.3 15.2 0 28-9.1 32.3-30.4A31.87 31.87 0 0 0 416 416a32 32 0 0 0 64 0V0zm-64 224h-50.9l-45.2-45.3A63.55 63.55 0 0 0 82.7 160H64a64 64 0 0 0-64 64.1L.2 320 0 480a32 32 0 1 0 63.9 0l.1-100.7c.9.5 1.6 1.3 2.5 1.7l29.1 43v56a32 32 0 0 0 64 0v-56.5a64.27 64.27 0 0 0-6.7-28.6l-41.2-61.3V253l20.9 20.9a47.58 47.58 0 0 0 33.9 14.1H224a32 32 0 0 0 0-64z"]],
    "person-carry": [384, 512, [], "f4cf", ["M80 0a48 48 0 1 0 48 48A48 48 0 0 0 80 0zm288 96H208a16 16 0 0 0-16 16v176h176a16 16 0 0 0 16-16V112a16 16 0 0 0-16-16z", "M0 479.9a32 32 0 0 0 64 0v-74.5C48 391.7.6 350.8 0 350.3zM128 288h64v-64h-25.4l-33.3-61.8A63.81 63.81 0 0 0 76.7 128H48a48 48 0 0 0-48 48v103a64.05 64.05 0 0 0 22.4 48.6l76 65.1 14.1 92.5c1 5.7 10.1 30.7 36.8 26.3a32 32 0 0 0 26.3-36.8l-14.1-92.5a64.41 64.41 0 0 0-21.5-38.1l-44-37.7v-78.3z"]],
    "person-dolly": [512, 512, [], "f4d0", ["M511.74 404.81l-8.2-30.9a8 8 0 0 0-9.77-5.71l-154.1 41.3a63.53 63.53 0 0 0-40.9-24.5l-59.4-221.6a8 8 0 0 0-9.77-5.71l-30.9 8.3a8 8 0 0 0-5.71 9.77l58.9 220a63.87 63.87 0 1 0 100 60.1L506 414.58a8 8 0 0 0 5.74-9.77zM288.73 464a16 16 0 1 1 16-16 16 16 0 0 1-16 16zM80 0h-.1a48.05 48.05 0 1 0 .1 0z", "M479 320.9L447.6 204a16 16 0 0 0-19.6-11.3L311 224a16 16 0 0 0-11.3 19.6l31.4 116.9a16 16 0 0 0 19.6 11.3l117-31.3a16 16 0 0 0 11.3-19.6zM0 479.9a32 32 0 0 0 64 0v-74.5C48 391.7.5 350.8 0 350.3zm128-192h94.8l-17.1-64h-39l-33.3-61.8a63.83 63.83 0 0 0-56.7-34.2H48a48 48 0 0 0-48 48v103a64.07 64.07 0 0 0 22.4 48.6l76 65.1 14.1 92.5c1 5.7 10.1 30.7 36.8 26.3a32 32 0 0 0 26.3-36.8l-14.1-92.5A64.4 64.4 0 0 0 140 344l-44-37.7V228z"]],
    "person-dolly-empty": [512, 512, [], "f4d1", ["M80 0h-.1a48.05 48.05 0 1 0 .1 0zm431.74 404.82l-8.2-30.9a8 8 0 0 0-9.77-5.7l-154.1 41.3a63.57 63.57 0 0 0-40.9-24.5l-59.4-221.6a8 8 0 0 0-9.77-5.7l-30.9 8.3a8 8 0 0 0-5.71 9.77l58.9 220a63.87 63.87 0 1 0 100 60.1L506 414.58a8 8 0 0 0 5.74-9.76zM288.73 464a16 16 0 1 1 16-16 16 16 0 0 1-16 16z", "M0 479.9a32 32 0 0 0 64 0v-74.5C48 391.7.5 350.8 0 350.3zm205.7-256h-39l-33.3-61.8a63.83 63.83 0 0 0-56.7-34.2H48a48 48 0 0 0-48 48v103a64.07 64.07 0 0 0 22.4 48.6l76 65.1 14.1 92.5c1 5.7 10.1 30.7 36.8 26.3a32 32 0 0 0 26.3-36.8l-14.1-92.5A64.4 64.4 0 0 0 140 344l-44-37.7V228l32 59.9h94.8z"]],
    "person-sign": [512, 512, [], "f757", ["M144 0a48 48 0 1 0 48 48 48.08 48.08 0 0 0-48-48zm357.5 66.6L321.08 1a16 16 0 0 0-20.5 9.6l-43.8 120.3a16 16 0 0 0 9.6 20.5l180.5 65.6a16 16 0 0 0 20.5-9.6L511 87.1a15.93 15.93 0 0 0-9.52-20.5z", "M321 212l-47.8-16-49.3-49.3a63.47 63.47 0 0 0-45.2-18.8h-62.9a63.63 63.63 0 0 0-57.2 35.4L3.38 273.7a32 32 0 1 0 57.2 28.6L80 263.6v54.8L64.08 476.8a32 32 0 0 0 28.6 35c1.1.1 2.2.2 3.2.2a32.05 32.05 0 0 0 31.8-28.8l13.2-131.2h15.3L192 423.5V480a32 32 0 0 0 64 0v-56.5a64.27 64.27 0 0 0-6.7-28.6l-41.2-82.5v-91.2l20 20a65 65 0 0 0 25 15.5l46.1 15.4-11.2 30.8a16 16 0 0 0 9.6 20.5l15 5.5a16 16 0 0 0 20.5-9.6l46.19-126.87L334 176zM429.68 6.5l-15-5.5a16 16 0 0 0-20.5 9.6l-5.49 15 45.1 16.4 5.49-15a16 16 0 0 0-9.6-20.5z"]],
    "phone": [512, 512, [], "f095", ["M336.23 167.12L406 4.43 389.41.61a24.16 24.16 0 0 0-27.5 13.9l-48 112a23.9 23.9 0 0 0 6.91 28zM154.6 320.71a24 24 0 0 0-28-6.91l-112 48a24.3 24.3 0 0 0-14 27.61l3.8 16.49 162.81-69.77zm338.81-296.1l-55.75-12.87L362 188.23l19.39 15.87A370.59 370.59 0 0 1 204.2 381.3l-15.88-19.4-176.6 75.69 12.89 55.82A24 24 0 0 0 48 512c256.1 0 464-207.49 464-464a24 24 0 0 0-18.59-23.39z", "M406 4.43l-69.77 162.69L362 188.23l75.66-176.49zM4.41 405.9l7.31 31.69 176.6-75.69-21.1-25.77z"]],
    "phone-alt": [512, 512, [], "f879", ["M191.18 154.51a23.9 23.9 0 0 0 6.91-28l-48-112a24.16 24.16 0 0 0-27.5-13.9L106 4.43l69.73 162.69zm153.6 181.62l162.81 69.77 3.8-16.49a24.3 24.3 0 0 0-14-27.61l-112-48a24 24 0 0 0-28 6.91zM0 48c0 256.5 207.9 464 464 464a24 24 0 0 0 23.4-18.59l12.89-55.82-176.61-75.69-15.88 19.4a370.59 370.59 0 0 1-177.21-177.2L150 188.23 74.34 11.74 18.59 24.61A24 24 0 0 0 0 48z", "M74.34 11.74L150 188.23l25.79-21.11L106 4.43zm270.44 324.39l-21.1 25.77 176.6 75.69 7.31-31.69z"]],
    "phone-laptop": [640, 512, [], "f87a", ["M128 64h320v32h64V48a48.1 48.1 0 0 0-47.91-48H111.91A48.1 48.1 0 0 0 64 48v240H16a16 16 0 0 0-16 16v16a64.14 64.14 0 0 0 63.91 64H352v-96H128z", "M604 128H420a36 36 0 0 0-36 36v312a36 36 0 0 0 36 36h184a36 36 0 0 0 36-36V164a36 36 0 0 0-36-36zm-28 320H448V192h128z"]],
    "phone-office": [576, 512, [], "f67d", ["M192 0h-64a32 32 0 0 0-32 32v352a32 32 0 0 0 32 32h64a32 32 0 0 0 32-32V32a32 32 0 0 0-32-32zm304 384h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-128h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM368 384h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-128h-32a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M528 32H256v352a64.07 64.07 0 0 1-64 64h-64a64.07 64.07 0 0 1-64-64V32H48A48 48 0 0 0 0 80v384a48 48 0 0 0 48 48h480a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zM384 432a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16zm0-128a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16zm128 128a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16zm0-128a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16zm0-112H320V96h192z"]],
    "phone-plus": [512, 512, [], "f4d2", ["M144 16v64h64a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16h-64v64a16 16 0 0 1-16 16H96a16 16 0 0 1-16-16v-64H16a16 16 0 0 1-16-16V96a16 16 0 0 1 16-16h64V16A16 16 0 0 1 96 0h32a16 16 0 0 1 16 16z", "M512 48c0 256.5-207.9 464-464 464a24 24 0 0 1-23.4-18.6l-24-104a24.29 24.29 0 0 1 14-27.6l112-48a24 24 0 0 1 28 6.9l49.6 60.6a370.61 370.61 0 0 0 177.2-177.2l-60.6-49.6a23.94 23.94 0 0 1-6.9-28l48-112A24.16 24.16 0 0 1 389.41.61l104 24A24 24 0 0 1 512 48z"]],
    "phone-rotary": [512, 512, [], "f8d3", ["M256 240a72 72 0 1 0 72 72 72 72 0 0 0-72-72zm250.18-117C436.76 65 347.38 32 256 32S75.24 65 5.82 123A16.45 16.45 0 0 0 0 135.64V192a16 16 0 0 0 16 16h70.11a16 16 0 0 0 14.31-8.85L128 128c39.9-17.28 83.2-24 128-24 44.77 0 88.07 6.72 128 24l27.58 71.15a16 16 0 0 0 14.31 8.85H496a16 16 0 0 0 16-16v-56.36a16.45 16.45 0 0 0-5.82-12.64z", "M475.78 376.62L370.43 192.25A64 64 0 0 0 314.86 160H197.14a64 64 0 0 0-55.57 32.25L36.22 376.62A32 32 0 0 0 32 392.5V448a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32v-55.5a32 32 0 0 0-4.22-15.88zM256 384a72 72 0 1 1 72-72 72 72 0 0 1-72 72z"]],
    "phone-slash": [640, 512, [], "f3dd", ["M377.91 126.51l48-112a24.16 24.16 0 0 1 27.5-13.9l104 24A24 24 0 0 1 576 48a462 462 0 0 1-100.17 288l-76-58.76a367.76 367.76 0 0 0 45.6-73.17l-60.6-49.6a23.94 23.94 0 0 1-6.92-27.96zm-109.74 254.9l-49.6-60.6a24 24 0 0 0-28-6.9l-112 48a24 24 0 0 0-13.9 27.5l24 104a24 24 0 0 0 23.4 18.6 461.2 461.2 0 0 0 269.7-86.9l-80-61.8c-10.9 6.5-22.1 12.69-33.6 18.1z", "M3.37 31.41L23 6.21a16.06 16.06 0 0 1 22.5-2.8l588.3 454.7a15.85 15.85 0 0 1 2.9 22.3l-19.6 25.3a16.06 16.06 0 0 1-22.5 2.8L6.17 53.81a15.93 15.93 0 0 1-2.8-22.4z"]],
    "phone-square": [448, 512, [], "f098", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zM94 416a15 15 0 0 1-14.62-11.63l-15-65a15 15 0 0 1 8.7-17.16l70-30a15 15 0 0 1 17.52 4.29l31 37.89a231.87 231.87 0 0 0 110.79-110.78l-37.89-31a15 15 0 0 1-4.29-17.52l30-70a15 15 0 0 1 17.16-8.7l65 15A15 15 0 0 1 384 126c0 160.29-129.95 290-290 290z", "M73.09 322.21l70-30a15 15 0 0 1 17.52 4.29l31 37.89a231.91 231.91 0 0 0 110.78-110.78l-37.89-31a15 15 0 0 1-4.29-17.52l30-70a15 15 0 0 1 17.16-8.7l65 15A15 15 0 0 1 384 126c0 160.29-129.94 290-290 290a15 15 0 0 1-14.62-11.63l-15-65a15 15 0 0 1 8.71-17.16z"]],
    "phone-square-alt": [448, 512, [], "f87b", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-16.38 307.37l-15 65A15 15 0 0 1 354 416C194 416 64 286.29 64 126a15 15 0 0 1 11.63-14.61l65-15a15 15 0 0 1 17.16 8.7l30 70a15 15 0 0 1-4.29 17.52l-37.89 31A231.94 231.94 0 0 0 256.4 334.39l31-37.89a15 15 0 0 1 17.52-4.29l70 30a15 15 0 0 1 8.7 17.16z", "M383.62 339.37l-15 65A15 15 0 0 1 354 416C193.94 416 64 286.29 64 126a15 15 0 0 1 11.63-14.61l65-15a15 15 0 0 1 17.16 8.7l30 70a15 15 0 0 1-4.29 17.52l-37.89 31a231.92 231.92 0 0 0 110.78 110.78l31-37.89a15 15 0 0 1 17.52-4.29l70 30a15 15 0 0 1 8.71 17.16z"]],
    "phone-volume": [384, 512, [], "f2a0", ["M292.94 49.23a12.06 12.06 0 0 0-17.85-1.31l-5.82 5.58A12 12 0 0 0 268 69.43a96.12 96.12 0 0 1 0 117.14 12 12 0 0 0 1.29 15.93l5.82 5.58a12.06 12.06 0 0 0 17.85-1.31 128.18 128.18 0 0 0-.02-157.54zm46-44.94a12 12 0 0 0-17.55-.94l-5.8 5.56a12 12 0 0 0-.93 16.38 160.22 160.22 0 0 1 0 205.42 12 12 0 0 0 .93 16.38l5.8 5.56a12 12 0 0 0 17.55-.94 192.25 192.25 0 0 0-.03-247.42zm-110.5 88.6l-6 5.73a12.09 12.09 0 0 0-2.27 14.38 32 32 0 0 1 0 29.94 12.09 12.09 0 0 0 2.26 14.41l6 5.73a12.05 12.05 0 0 0 18.72-2.58 64.07 64.07 0 0 0 0-65.06 12.05 12.05 0 0 0-18.74-2.55z", "M84.38 182.24a265.55 265.55 0 0 0 0 179.52l55.81-5.58a17.18 17.18 0 0 1 17.67 10.71l32.4 81a17.17 17.17 0 0 1-6.85 20.95l-64.81 40.55A17.2 17.2 0 0 1 97.33 507c-129.87-129.91-129.68-340.29 0-470a17.2 17.2 0 0 1 21.27-2.42l64.81 40.51a17.18 17.18 0 0 1 6.85 21l-32.41 81a17.18 17.18 0 0 1-17.66 10.72z"]],
    "photo-video": [640, 512, [], "f87c", ["M608 0H160a32 32 0 0 0-32 32v96h160V64h192v320h128a32 32 0 0 0 32-32V32a32 32 0 0 0-32-32zM232 103a9 9 0 0 1-9 9h-30a9 9 0 0 1-9-9V73a9 9 0 0 1 9-9h30a9 9 0 0 1 9 9zm352 208a9 9 0 0 1-9 9h-30a9 9 0 0 1-9-9v-30a9 9 0 0 1 9-9h30a9 9 0 0 1 9 9zm0-104a9 9 0 0 1-9 9h-30a9 9 0 0 1-9-9v-30a9 9 0 0 1 9-9h30a9 9 0 0 1 9 9zm0-104a9 9 0 0 1-9 9h-30a9 9 0 0 1-9-9V73a9 9 0 0 1 9-9h30a9 9 0 0 1 9 9z", "M416 160H32a32 32 0 0 0-32 32v288a32 32 0 0 0 32 32h384a32 32 0 0 0 32-32V192a32 32 0 0 0-32-32zM96 224a32 32 0 1 1-32 32 32 32 0 0 1 32-32zm288 224H64v-32l64-64 32 32 128-128 96 96z"]],
    "pi": [512, 512, [], "f67e", ["M128 286.46a169.35 169.35 0 0 1-36.62 105.62c-7.27 9.18-5.71 22.57 2.56 30.85L128.05 457c10.25 10.29 26.95 9 36.12-2.24A264.57 264.57 0 0 0 224 286.46V144h-96zm375 79.79l-37.46-30A24 24 0 0 0 431.8 340L414 361.67a16.84 16.84 0 0 1-30-10.51V144h-96v202.58c0 55 37.32 105.36 91.32 115.42 42.26 7.87 83.62-7.87 109.62-40.34l17.8-21.66a24 24 0 0 0-3.74-33.75z", "M512 72v48a24 24 0 0 1-24 24H16c-14.22 0-21.36-17.23-11.28-27.31l49.94-49.95A64 64 0 0 1 99.91 48H488a24 24 0 0 1 24 24z"]],
    "piano": [512, 512, [], "f8d4", ["M512 384v96a32 32 0 0 1-32 32H32a32 32 0 0 1-32-32v-96h48v80h416v-80z", "M512 327.55V384h-96v40a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-40h-32v40a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-40h-48v40a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-40h-48v40a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-40h-32v40a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-40H0V184.45A184.45 184.45 0 0 1 184.45 0h15.1A184.45 184.45 0 0 1 384 184.45a64 64 0 0 0 35.38 57.24l57.24 28.62A64 64 0 0 1 512 327.55z"]],
    "piano-keyboard": [576, 512, [], "f8d5", ["M576 224v192a32 32 0 0 1-32 32H32a32 32 0 0 1-32-32V224h48v176h480V224z", "M576 96v128H464v80a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-80h-80v80a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-80h-80v80a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-80H0V96a32 32 0 0 1 32-32h512a32 32 0 0 1 32 32z"]],
    "pie": [576, 512, [], "f705", ["M88.75 426.08l-31-92.88c32.91-6.57 51.26-23.5 59.6-29.2h.22c10.17 7 36.21 32 85.34 32 50.09 0 78-27 85.28-32h.08c10.11 7 36.2 32 85.26 32s75.13-25.06 85.25-32h.06c7 4.8 26.35 22.58 59.46 29.2l-31 92.88A32 32 0 0 1 456.94 448H119.07a32 32 0 0 1-30.32-21.92z", "M544 240c-6.44 0-10.37-1.2-14.47-3.52C494.93 136.17 400.07 64 288 64S81 136.21 46.45 236.55c-4.07 2.28-8 3.45-14.45 3.45a32 32 0 0 0 0 64c32 0 50-13.47 61.92-22.39 9.08-6.8 12.83-9.61 23.53-9.61s14.47 2.81 23.55 9.61c11.91 8.92 29.89 22.39 61.91 22.39s50-13.48 61.88-22.41c9-6.78 12.8-9.59 23.45-9.59s14.39 2.81 23.44 9.59c11.89 8.92 29.86 22.41 61.86 22.41s49.95-13.48 61.84-22.41c9.05-6.78 12.8-9.59 23.44-9.59s14.34 2.81 23.38 9.58C494.06 290.52 512 304 544 304a32 32 0 0 0 0-64zm-337.69-88.84l-16 32c-9.44 18.83-38.17 4.79-28.62-14.31l16-32c9.53-18.85 38.09-4.63 28.62 14.31zM304 176c0 21.17-32 21.18-32 0v-32c0-21.17 32-21.18 32 0zm81.69 7.16l-16-32c-9.48-18.95 19.13-33.19 28.62-14.31l16 32c9.53 19.05-19.17 33.15-28.62 14.31z"]],
    "pig": [576, 512, [], "f706", ["M560 192h-29.51a159.88 159.88 0 0 0-37.38-52.46L512 64h-32c-29.4 0-55.39 13.5-73 34.32-7.57-1.1-15.12-2.32-23-2.32H256c-94.82 0-160 78.88-160 160a159.75 159.75 0 0 0 64 128v80a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16v-48h128v48a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16v-80.72A160.37 160.37 0 0 0 511.28 352H560a16 16 0 0 0 16-16V208a16 16 0 0 0-16-16zm-128 64a16 16 0 1 1 16-16 16 16 0 0 1-16 16z", "M51.26 223.52a24 24 0 0 1-18.74-28.3C34.74 183.82 45.4 176 57 176h1a6 6 0 0 0 6-6v-20a6 6 0 0 0-6-6C29.5 144 4.1 164.4.47 192.62a54.64 54.64 0 0 0-.47 7.23A56.08 56.08 0 0 0 56 256h40a155.05 155.05 0 0 1 3.37-32H56a23.63 23.63 0 0 1-4.74-.48zM432 224a16 16 0 1 0 16 16 16 16 0 0 0-16-16z"]],
    "piggy-bank": [576, 512, [], "f4d3", ["M560 224h-29.51a159.88 159.88 0 0 0-37.38-52.46L512 96h-32c-29.4 0-55.39 13.5-73 34.32-7.57-1.1-15.12-2.32-23-2.32H256c-94.82 0-160 78.88-160 160a159.75 159.75 0 0 0 64 128v80a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16v-48h128v48a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16v-80.72A160.37 160.37 0 0 0 511.28 384H560a16 16 0 0 0 16-16V240a16 16 0 0 0-16-16zm-128 64a16 16 0 1 1 16-16 16 16 0 0 1-16 16z", "M51.26 255.52a24 24 0 0 1-18.74-28.3C34.74 215.82 45.4 208 57 208h1a6 6 0 0 0 6-6v-20a6 6 0 0 0-6-6C29.5 176 4.1 196.4.47 224.62a54.64 54.64 0 0 0-.47 7.23A56.08 56.08 0 0 0 56 288h40a155.05 155.05 0 0 1 3.37-32H56a23.63 23.63 0 0 1-4.74-.48zM432 256a16 16 0 1 0 16 16 16 16 0 0 0-16-16zM306.5 0a96 96 0 0 0-88.81 132.51A162.64 162.64 0 0 1 256 128h128a104.31 104.31 0 0 1 12.71.88A96.06 96.06 0 0 0 306.5 0z"]],
    "pills": [576, 512, [], "f484", ["M299.7 226.3a8.21 8.21 0 0 0-12.3.8c-45.3 62.5-40.4 150.1 15.9 206.4s143.9 61.2 206.4 15.9a8.14 8.14 0 0 0 .8-12.3zm229.8-19c-56.3-56.3-143.9-61.2-206.4-15.9a8.14 8.14 0 0 0-.8 12.3l210.8 210.8a8.21 8.21 0 0 0 12.3-.8c45.3-62.6 40.5-150.1-15.9-206.4zM112 32A111.94 111.94 0 0 0 0 144v112h224V144A111.94 111.94 0 0 0 112 32z", "M224 256v112a112 112 0 0 1-224 0V256z"]],
    "pizza": [576, 512, [], "f817", ["M380.61 131.55a175.76 175.76 0 0 0-248.61-.13l-.14.13c-68.68 68.73-68.68 180.17 0 248.9a175.77 175.77 0 0 0 248.58.13l.13-.13L256.25 256zM160.25 280a24 24 0 0 1 0-48 24 24 0 0 1 0 48zm48-96a24 24 0 1 1 24-24 24 24 0 0 1-24 24zm72 184a24 24 0 1 1-24-24 24 24 0 0 1 24 24zm174.94-224.92L342.35 256l112.84 112.93a176.6 176.6 0 0 0 0-225.85zM424.1 288a24 24 0 1 1 24-24 24 24 0 0 1-24 24z", "M256.25 392a24 24 0 1 0-24-24 24 24 0 0 0 24 24zm-48-256a24 24 0 1 0 24 24 24 24 0 0 0-24-24zm195 267.08c-81.87 81.92-215 81.22-296-2.11-77-79.19-77-210.74 0-289.94 81-83.33 214.14-84 296-2.11l22-22.07c6.46-6.46 6.44-17.36-.42-23.39-112.89-99.22-292.24-82.09-382.21 51.37-56.83 84.3-56.83 198.05 0 282.34 90 133.46 269.32 150.59 382.23 51.37 6.86-6 6.88-16.93.42-23.39zm120-302.95c-5.79-7.55-17.22-7.92-23.95-1.19l-21.42 21.44c66.7 77.84 66.7 193.4 0 271.24l21.42 21.44c6.73 6.73 18.16 6.37 23.95-1.19a256.62 256.62 0 0 0-.01-311.74zM160.25 232a24 24 0 1 0 24 24 24 24 0 0 0-24-24zm263.85 8a24 24 0 1 0 24 24 24 24 0 0 0-24-24z"]],
    "pizza-slice": [512, 512, [], "f818", ["M100.39 112.19L.54 491.64a16.2 16.2 0 0 0 20 19.75l379-105.1c-4.27-174.89-123.08-292.14-299.15-294.1zM128 416a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm48-152a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm104 104a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M128 352a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm48-152a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm335.76 145.86C490.88 165.08 340.77 17.32 158.86.15c-16.16-1.52-31.2 8.42-35.33 24.12l-14.81 56.27c187.62 5.46 314.54 130.61 322.48 317l56.94-15.78c15.72-4.36 25.49-19.68 23.62-35.9zM280 304a32 32 0 1 0 32 32 32 32 0 0 0-32-32z"]],
    "place-of-worship": [640, 512, [], "f67f", ["M620.61 366.55L512 320v192h112a16 16 0 0 0 16-16V396a32 32 0 0 0-19.39-29.45zM0 396v100a16 16 0 0 0 16 16h112V320L19.39 366.55A32 32 0 0 0 0 396z", "M416 102.63v115l48.46 29.08A32 32 0 0 1 480 274.12V512h-96v-96a64 64 0 0 0-128 0v96h-96V274.12a32 32 0 0 1 15.54-27.44L224 217.6v-115a32 32 0 0 1 9.38-22.6l75.31-75.31a16 16 0 0 1 22.62 0L406.62 80a32 32 0 0 1 9.38 22.63z"]],
    "plane": [576, 512, [], "f072", ["M214.86 192h150.85L260.61 8.06A16 16 0 0 0 246.71 0h-65.5a16 16 0 0 0-15.38 20.39zm-49 299.6a16 16 0 0 0 15.35 20.4h65.5a16 16 0 0 0 13.89-8.06L365.71 320H214.86z", "M480 320H112l-43.2 57.6A16 16 0 0 1 56 384H16A16 16 0 0 1 .49 364.12L32 256 .49 147.88A16 16 0 0 1 16 128h40a16 16 0 0 1 12.8 6.4L112 192h368c35.35 0 96 28.65 96 64s-60.65 64-96 64z"]],
    "plane-alt": [576, 512, [], "f3de", ["M197.2 200.4c-32.6 1 150.5-.4 150.5-.4l-38.6-72H324a12 12 0 0 0 12-12V76a12 12 0 0 0-12-12h-49.2L243.5 5.7A12.18 12.18 0 0 0 233.3 0h-57.8a11.94 11.94 0 0 0-11.6 15zm0 111.2L163.9 497a12 12 0 0 0 11.6 15h57.8a12 12 0 0 0 10.2-5.7l31.3-58.3H324a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12h-14.9l38.6-72s-183.1-1.4-150.5-.4z", "M576 256c0 30.9-46.6 56-104 56l-274.8-.4a755.21 755.21 0 0 1-89.9-7.8l-39.8 66.4a12.08 12.08 0 0 1-10.3 5.8H14.6a12 12 0 0 1-11.7-14.4l16.5-82.8C6.9 271.9 0 264.1 0 256s6.9-15.9 19.4-22.8L2.8 150.4A12 12 0 0 1 14.6 136h42.6a12.08 12.08 0 0 1 10.3 5.8l39.8 66.4a755.21 755.21 0 0 1 89.9-7.8L472 200c57.4 0 104 25.1 104 56z"]],
    "plane-arrival": [640, 512, [], "f5af", ["M640 464v32a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h608a16 16 0 0 1 16 16z", "M32.23 182.41L32 80.63a16.52 16.52 0 0 1 20.72-15.88l39.73 10.83a16.54 16.54 0 0 1 11 9.93l27.59 67.88 102.2 27.84L185.34 17A16.51 16.51 0 0 1 206.05.58l65.09 17.73a16.62 16.62 0 0 1 11.66 11.91l100.36 191.85 97.51 26.56c26.48 7.21 51.55 20.18 70.83 40 21.64 22.25 27.2 40.46 23.37 55S557.29 371 527.62 379.3c-26.44 7.36-54.52 5.85-81-1.36L159 299.59a62.52 62.52 0 0 1-25.47-13.93l-88.74-80c-6.53-5.91-12.37-14.34-12.56-23.25z"]],
    "plane-departure": [640, 512, [], "f5b0", ["M640 448v32a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h608a16 16 0 0 1 16 16z", "M636.11 59.08c7.23 14.56 5.24 35.17-13.07 63.65-16.31 25.37-40.28 44.74-67 58.31l-291 147.65a65.79 65.79 0 0 1-29.64 7.12l-130.52.19a33 33 0 0 1-24.33-10.71l-76.21-83a18.28 18.28 0 0 1 5.57-28.08L50 193.86a17.8 17.8 0 0 1 16.07 0l72.35 36.47 103.21-52.38L85.45 79.83a18.27 18.27 0 0 1 5.17-28.53l65.75-33.37a17.8 17.8 0 0 1 18 1.11l218.7 82.06 98.51-50c26.74-13.55 56.42-21.41 86.28-19.47 33.51 2.18 51.04 12.88 58.25 27.45z"]],
    "play": [448, 512, [], "f04b", ["M424.41 214.66L72.41 6.55C43.81-10.34 0 6.05 0 47.87V464c0 37.5 40.69 60.09 72.41 41.3l352-208c31.4-18.54 31.5-64.14 0-82.64zM321.89 283.5L112.28 407.35C91 420 64 404.58 64 379.8V132c0-24.78 27-40.16 48.28-27.54l209.61 123.95a32 32 0 0 1 0 55.09z", "M112.28 104.48l209.61 123.93a32 32 0 0 1 0 55.09L112.28 407.35C91 420 64 404.58 64 379.8V132c0-24.76 27-40.14 48.28-27.52z"]],
    "play-circle": [512, 512, [], "f144", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm115.7 272l-176 101c-15.8 8.8-35.7-2.5-35.7-21V152c0-18.4 19.8-29.8 35.7-21l176 107c16.4 9.2 16.4 32.9 0 42z", "M371.7 280l-176 101c-15.8 8.8-35.7-2.5-35.7-21V152c0-18.4 19.8-29.8 35.7-21l176 107c16.4 9.2 16.4 32.9 0 42z"]],
    "plug": [384, 512, [], "f1e6", ["M96 0a32 32 0 0 0-32 32v96h64V32A32 32 0 0 0 96 0zm192 0a32 32 0 0 0-32 32v96h64V32a32 32 0 0 0-32-32z", "M384 176v32a16 16 0 0 1-16 16h-16v32a160.07 160.07 0 0 1-128 156.8V512h-64v-99.2A160.07 160.07 0 0 1 32 256v-32H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h352a16 16 0 0 1 16 16z"]],
    "plus": [448, 512, [], "f067", ["M176 448a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32V304h-96zm64-416h-32a32 32 0 0 0-32 32v144h96V64a32 32 0 0 0-32-32z", "M448 240v32a32 32 0 0 1-32 32H32a32 32 0 0 1-32-32v-32a32 32 0 0 1 32-32h384a32 32 0 0 1 32 32z"]],
    "plus-circle": [512, 512, [], "f055", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm144 276a12 12 0 0 1-12 12h-92v92a12 12 0 0 1-12 12h-56a12 12 0 0 1-12-12v-92h-92a12 12 0 0 1-12-12v-56a12 12 0 0 1 12-12h92v-92a12 12 0 0 1 12-12h56a12 12 0 0 1 12 12v92h92a12 12 0 0 1 12 12z", "M400 284a12 12 0 0 1-12 12h-92v92a12 12 0 0 1-12 12h-56a12 12 0 0 1-12-12v-92h-92a12 12 0 0 1-12-12v-56a12 12 0 0 1 12-12h92v-92a12 12 0 0 1 12-12h56a12 12 0 0 1 12 12v92h92a12 12 0 0 1 12 12z"]],
    "plus-hexagon": [576, 512, [], "f300", ["M553.5 231.8l-112-192A48.14 48.14 0 0 0 400 16H176a48.09 48.09 0 0 0-41.5 23.8l-112 192a48.19 48.19 0 0 0 0 48.4l112 192A48.09 48.09 0 0 0 176 496h224a48.13 48.13 0 0 0 41.5-23.8l112-192a48.19 48.19 0 0 0 0-48.4zM432 284a12 12 0 0 1-12 12h-92v92a12 12 0 0 1-12 12h-56a12 12 0 0 1-12-12v-92h-92a12 12 0 0 1-12-12v-56a12 12 0 0 1 12-12h92v-92a12 12 0 0 1 12-12h56a12 12 0 0 1 12 12v92h92a12 12 0 0 1 12 12z", "M432 284a12 12 0 0 1-12 12h-92v92a12 12 0 0 1-12 12h-56a12 12 0 0 1-12-12v-92h-92a12 12 0 0 1-12-12v-56a12 12 0 0 1 12-12h92v-92a12 12 0 0 1 12-12h56a12 12 0 0 1 12 12v92h92a12 12 0 0 1 12 12z"]],
    "plus-octagon": [512, 512, [], "f301", ["M497.9 150.5L361.4 14.1A48 48 0 0 0 327.5 0H184.4a48 48 0 0 0-33.9 14.1L14.1 150.6A48 48 0 0 0 0 184.5v143.1a48 48 0 0 0 14.1 33.9l136.5 136.4a48 48 0 0 0 33.9 14.1h143.1a48 48 0 0 0 33.9-14.1l136.4-136.5a48 48 0 0 0 14.1-33.9V184.4a48 48 0 0 0-14.1-33.9zM400 284a12 12 0 0 1-12 12h-92v92a12 12 0 0 1-12 12h-56a12 12 0 0 1-12-12v-92h-92a12 12 0 0 1-12-12v-56a12 12 0 0 1 12-12h92v-92a12 12 0 0 1 12-12h56a12 12 0 0 1 12 12v92h92a12 12 0 0 1 12 12z", "M400 284a12 12 0 0 1-12 12h-92v92a12 12 0 0 1-12 12h-56a12 12 0 0 1-12-12v-92h-92a12 12 0 0 1-12-12v-56a12 12 0 0 1 12-12h92v-92a12 12 0 0 1 12-12h56a12 12 0 0 1 12 12v92h92a12 12 0 0 1 12 12z"]],
    "plus-square": [448, 512, [], "f0fe", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-32 252a12 12 0 0 1-12 12h-92v92a12 12 0 0 1-12 12h-56a12 12 0 0 1-12-12v-92H92a12 12 0 0 1-12-12v-56a12 12 0 0 1 12-12h92v-92a12 12 0 0 1 12-12h56a12 12 0 0 1 12 12v92h92a12 12 0 0 1 12 12z", "M80 228a12 12 0 0 1 12-12h92v-92a12 12 0 0 1 12-12h56a12 12 0 0 1 12 12v92h92a12 12 0 0 1 12 12v56a12 12 0 0 1-12 12h-92v92a12 12 0 0 1-12 12h-56a12 12 0 0 1-12-12v-92H92a12 12 0 0 1-12-12z"]],
    "podcast": [448, 512, [], "f2ce", ["M224 0A223.88 223.88 0 0 0 0 224c0 90 52.6 165.65 125.74 201.41a6 6 0 0 0 8.53-6.31c-2.38-15.51-4.34-31-5.4-44.34a6 6 0 0 0-2.68-4.51A176 176 0 0 1 48 222.9c.59-96.24 79.29-174.65 175.53-174.9C320.79 47.75 400 126.8 400 224a176 176 0 0 1-80.65 147.87c-1 14-3.07 30.59-5.62 47.23a6 6 0 0 0 8.53 6.31C395.23 389.73 448 314.19 448 224A223.89 223.89 0 0 0 224 0zm98.45 325A143.63 143.63 0 0 0 368 216.43c-1.86-76.21-63.6-138.21-139.8-140.37C146.87 73.75 80 139.21 80 220a143.62 143.62 0 0 0 45.55 105 6 6 0 0 0 9.45-1.9 66.57 66.57 0 0 1 21.24-25.36 6 6 0 0 0 .63-9.19 96 96 0 1 1 134.26 0 6 6 0 0 0 .63 9.19A66.57 66.57 0 0 1 313 323.1a6 6 0 0 0 9.45 1.9z", "M224 312c-32.86 0-64 8.59-64 43.75 0 33.15 12.93 104.38 20.57 132.81 5.14 19 24.57 23.44 43.43 23.44s38.29-4.43 43.43-23.44c7.7-28.63 20.57-99.86 20.57-132.81 0-35.16-31.14-43.75-64-43.75zm0-24a64 64 0 1 0-64-64 64 64 0 0 0 64 64z"]],
    "podium": [448, 512, [], "f680", ["M384 224l-22.22 240H86.22L64 224z", "M400 464H48a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h352a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm32-320H113.68c6.2-30.29 29.85-54.3 61-61.55A47.72 47.72 0 0 0 208 96h64a48 48 0 0 0 0-96h-64a47.89 47.89 0 0 0-46.31 36C110.81 48.48 71.66 91.15 65 144H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16z"]],
    "podium-star": [448, 512, [], "f758", ["M384 224l-22.22 240H86.22L64 224z", "M400 464H48a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h352a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm-92.63-143a10.05 10.05 0 0 0-8.47-11.43l-45.6-6.7-20.4-41.4a10 10 0 0 0-17.9 0l-20.4 41.4-45.6 6.73a10 10 0 0 0-5.5 17.1l33 32.2-7.8 45.5a10 10 0 0 0 14.5 10.5l40.8-21.5 40.8 21.5a10 10 0 0 0 14.5-10.5l-7.8-45.5 33-32.2a10 10 0 0 0 2.87-5.7zM432 144H113.68c6.2-30.29 29.85-54.3 61-61.55A47.72 47.72 0 0 0 208 96h64a48 48 0 0 0 0-96h-64a47.89 47.89 0 0 0-46.31 36C110.81 48.48 71.66 91.15 65 144H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16z"]],
    "poll": [448, 512, [], "f681", ["M0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48H48A48 48 0 0 0 0 80zm112 304a16 16 0 0 1-16-16V240a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v128a16 16 0 0 1-16 16zm224-96a16 16 0 0 1 16 16v64a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-64a16 16 0 0 1 16-16zm-96-160a16 16 0 0 1 16 16v224a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V144a16 16 0 0 1 16-16z", "M160 368V240a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v128a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16zm128-64v64a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-64a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16zm-96-160v224a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V144a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16z"]],
    "poll-h": [448, 512, [], "f682", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zM96 144a16 16 0 0 1 16-16h128a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16H112a16 16 0 0 1-16-16zm96 224a16 16 0 0 1-16 16h-64a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h64a16 16 0 0 1 16 16zm160-96a16 16 0 0 1-16 16H112a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h224a16 16 0 0 1 16 16z", "M112 192h128a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H112a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm64 128h-64a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm160-96H112a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h224a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "poll-people": [640, 512, [], "f759", ["M616.12 32H248a23.94 23.94 0 0 0-24 23.88V168a23.94 23.94 0 0 0 23.88 24H616a23.94 23.94 0 0 0 24-23.88V56a23.94 23.94 0 0 0-23.88-24zM576 128H288V96h288zm40.12 192H248a23.94 23.94 0 0 0-24 23.88V456a23.94 23.94 0 0 0 23.88 24H616a23.94 23.94 0 0 0 24-23.88V344a23.94 23.94 0 0 0-23.88-24zM576 416H288v-32h288z", "M96 416H64a64.06 64.06 0 0 0-64 64v16a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-16a64.06 64.06 0 0 0-64-64zM80 96a48 48 0 1 0-48-48 48 48 0 0 0 48 48zm48 240a48 48 0 1 0-48 48 48 48 0 0 0 48-48zM288 96v32h224V96zm0 320h128v-32H288zM96 128H64a64.06 64.06 0 0 0-64 64v16a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-16a64.06 64.06 0 0 0-64-64z"]],
    "poo": [512, 512, [], "f2fe", ["M451.4 369.1A71.77 71.77 0 0 0 408 240h-14.1A63.74 63.74 0 0 0 352 128h-5.9a94.61 94.61 0 0 0 5.9-32 96 96 0 0 0-96-96 93.1 93.1 0 0 0-15.1 1.5A79.79 79.79 0 0 1 176 128h-16a63.74 63.74 0 0 0-41.9 112H104a71.77 71.77 0 0 0-43.4 129.1A71.9 71.9 0 0 0 72 512h368a71.9 71.9 0 0 0 11.4-142.9zM320 256a32 32 0 1 1-32 32 32 32 0 0 1 32-32zm-128 0a32 32 0 1 1-32 32 32 32 0 0 1 32-32zm159.5 139C341 422.9 293 448 256 448s-85-25.1-95.5-53a8.2 8.2 0 0 1 7.8-11h175.4a8.2 8.2 0 0 1 7.8 11z", "M320 256a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm-128 0a32 32 0 1 0 32 32 32 32 0 0 0-32-32z"]],
    "poo-storm": [448, 512, [], "f75a", ["M318.4 354l-88 152a12 12 0 0 1-22.1-8.8l23-97.2H172a12 12 0 0 1-11.9-13.6l16-120A12.06 12.06 0 0 1 188 256h68a12 12 0 0 1 11.6 15.1L250.3 336H308a12 12 0 0 1 10.4 18z", "M374.4 224.7c41 3.3 73.6 37.5 73.5 79.3a80.24 80.24 0 0 1-80 80h-30l8.1-14a44 44 0 0 0-38.1-66h-16l6.6-24.7A44 44 0 0 0 256 224h-68a44.26 44.26 0 0 0-43.7 38.2l-16 120a10.82 10.82 0 0 1 0 1.8H80a80.24 80.24 0 0 1-80-80c0-41.8 32.6-76 73.6-79.3A62 62 0 0 1 64 192a64.06 64.06 0 0 1 64-64h16A79.79 79.79 0 0 0 208.9 1.5 93.1 93.1 0 0 1 224 0a96 96 0 0 1 96 96 94.61 94.61 0 0 1-5.9 32h5.9a64.06 64.06 0 0 1 64 64 62 62 0 0 1-9.6 32.7z"]],
    "poop": [512, 512, [], "f619", ["M480 311v2a70.89 70.89 0 0 1-27.34 56 71.2 71.2 0 0 0-11.66-1H71a71.2 71.2 0 0 0-11.66 1A70.89 70.89 0 0 1 32 313v-2a71 71 0 0 1 71-71h306a71 71 0 0 1 71 71z", "M118.05 240H394a63.76 63.76 0 0 0-42-112h-5.88a98.21 98.21 0 0 0 4.36-50.78A94.18 94.18 0 0 0 240.91 1.55 79.78 79.78 0 0 1 176 128h-16a63.76 63.76 0 0 0-42 112zm333.33 129.17l.42-.33A71.12 71.12 0 0 0 441 368H71a70.69 70.69 0 0 0-10.76.84c.14.11.27.23.42.33A71.87 71.87 0 0 0 72 512h368a71.87 71.87 0 0 0 11.36-142.86z"]],
    "popcorn": [512, 512, [], "f819", ["M101.46,118a37.17,37.17,0,0,1,.33-37.43c9.11-16,28-23.66,45.57-20.12.34-16.64,11.46-32,29-37.43a43.36,43.36,0,0,1,38.82,6.08A41.63,41.63,0,0,1,242.5,2c22.27-6.78,46.23,4.42,53.33,25.54a4.22,4.22,0,0,1,.68,1.92A43.29,43.29,0,0,1,335.65,23c17.53,5.43,28.67,20.79,29,37.43C382.2,57,401.09,64.6,410.2,80.6a37.88,37.88,0,0,1,.33,37.43,42.7,42.7,0,0,1,33.09,20.79c3.91,6.75,4.76,14,4.24,21.12H64.13c-.5-7.12.35-14.38,4.27-21.12C75.14,126.67,88,119.31,101.46,118Z", "M64,192h81.56l28,256h45.05L197.05,192H315L293.39,448h45l28-256H448L404.09,484.73A32,32,0,0,1,372.44,512H139.56a32,32,0,0,1-31.65-27.25Z"]],
    "portrait": [384, 512, [], "f3e0", ["M336 0H48A48 48 0 0 0 0 48v416a48 48 0 0 0 48 48h288a48 48 0 0 0 48-48V48a48 48 0 0 0-48-48zM192 128a64 64 0 1 1-64 64 64.06 64.06 0 0 1 64-64zm112 236.8c0 10.6-10 19.2-22.4 19.2H102.4C90 384 80 375.4 80 364.8v-19.2c0-31.8 30.1-57.6 67.2-57.6h5a103 103 0 0 0 79.6 0h5c37.1 0 67.2 25.8 67.2 57.6z", "M192 256a64 64 0 1 0-64-64 64.06 64.06 0 0 0 64 64zm44.8 32h-5a103 103 0 0 1-79.6 0h-5c-37.1 0-67.2 25.8-67.2 57.6v19.2c0 10.6 10 19.2 22.4 19.2h179.2c12.4 0 22.4-8.6 22.4-19.2v-19.2c0-31.8-30.1-57.6-67.2-57.6z"]],
    "pound-sign": [320, 512, [], "f154", ["M8 236v40a12 12 0 0 0 12 12h28v-64H20a12 12 0 0 0-12 12zm204-12h-84v64h84a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12z", "M48 416V158c0-73.26 58-126 139.93-126 48.65 0 85.19 22.56 101.58 34.93a12 12 0 0 1 2.31 16.81 2.56 2.56 0 0 1-.2.26l-28.49 35.51a12 12 0 0 1-15.69 2.69c-11.77-7.35-34-18.85-57.65-18.85-37.23 0-61.79 24.82-61.79 57.08v254.42h122.51V364a12 12 0 0 1 12-12H308a12 12 0 0 1 12 12v104a12 12 0 0 1-12 12H12a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12z"]],
    "power-off": [512, 512, [], "f011", ["M272 0a23.94 23.94 0 0 1 24 24v240a23.94 23.94 0 0 1-24 24h-32a23.94 23.94 0 0 1-24-24V24a23.94 23.94 0 0 1 24-24z", "M504 256c0 136.8-110.8 247.7-247.5 248C120 504.3 8.2 393 8 256.4A248 248 0 0 1 111.8 54.2a24.07 24.07 0 0 1 35 7.7L162.6 90a24 24 0 0 1-6.6 31 168 168 0 0 0 100 303c91.6 0 168.6-74.2 168-169.1a168.07 168.07 0 0 0-68.1-134 23.86 23.86 0 0 1-6.5-30.9l15.8-28.1a24 24 0 0 1 34.8-7.8A247.51 247.51 0 0 1 504 256z"]],
    "pray": [384, 512, [], "f683", ["M256 128a64 64 0 1 1 64-64 64 64 0 0 1-64 64z", "M201.22 269l-34.8 64.87 109.86 109.85C301.77 469.21 282.08 512 248 512H40a40 40 0 0 1 0-80h91.56l-44.81-34.89C43.87 369.73 29.16 317 52.56 273.36l49.37-92c11.12-20.65 32.18-34.44 56.37-36.92 24.78-2.59 48.56 6.94 64 25.33l38.91 46.31 57.44-47A40 40 0 1 1 369.34 231l-88 72a40 40 0 0 1-56-5.22z"]],
    "praying-hands": [640, 512, [], "f684", ["M640 384v96c0 10.82-8.52 32-32 32a32.16 32.16 0 0 1-8.06-1l-179.19-46.65A117.32 117.32 0 0 1 336 352V224a32 32 0 0 1 64 0v80a16 16 0 0 0 32 0v-76.54a95.86 95.86 0 0 0-13.69-49.39L340.56 48.48a31.8 31.8 0 0 1 53.27-34.7c.2.24.61.21.79.48l117.26 175.89A95.66 95.66 0 0 1 528 243.38v80.23l90.12 30A32 32 0 0 1 640 384z", "M32 511.92c-23.48 0-32-21.18-32-32v-96a32 32 0 0 1 21.88-30.35l90.12-30V243.3a95.66 95.66 0 0 1 16.12-53.23l117.26-175.9c.17-.27.59-.25.79-.48a31.8 31.8 0 0 1 53.27 34.7L221.69 178A95.86 95.86 0 0 0 208 227.37v76.55a16 16 0 1 0 32 0v-80a32 32 0 1 1 64 0v128a117.35 117.35 0 0 1-84.75 112.35L40.06 510.89a32 32 0 0 1-8.06 1.03z"]],
    "prescription": [384, 512, [], "f5b1", ["M379.32 274l-78.06 78L256 397.29l-78 78.07a16 16 0 0 1-22.63 0l-22.63-22.63a16 16 0 0 1 0-22.63l201.32-201.38a16 16 0 0 1 22.63 0l22.63 22.63a16 16 0 0 1 0 22.65z", "M379.32 430.09l-78.06-78-45.26 45.2 78.06 78.06a16 16 0 0 0 22.63 0l22.63-22.63a16 16 0 0 0 0-22.63zM172 222.78c47.27-6 84-45.89 84-94.78a96 96 0 0 0-96-96H16A16 16 0 0 0 0 48v256a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-80h18.75l128 128L256 306.78zM64 160V96h96a32 32 0 1 1 0 64z"]],
    "prescription-bottle": [384, 512, [], "f485", ["M32 128h320v352a32.09 32.09 0 0 1-32 32H64a32.09 32.09 0 0 1-32-32v-64h120a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8H32v-64h120a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8H32v-64h120a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8H32z", "M360 0H24A24.07 24.07 0 0 0 0 24v48a24.07 24.07 0 0 0 24 24h336a24.07 24.07 0 0 0 24-24V24a24.07 24.07 0 0 0-24-24zM152 384H32v32h120a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zm0-192H32v32h120a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zm0 96H32v32h120a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8z"]],
    "prescription-bottle-alt": [384, 512, [], "f486", ["M32 480a32.09 32.09 0 0 0 32 32h256a32.09 32.09 0 0 0 32-32V128H32zm64-184a8 8 0 0 1 8-8h56v-56a8 8 0 0 1 8-8h48a8 8 0 0 1 8 8v56h56a8 8 0 0 1 8 8v48a8 8 0 0 1-8 8h-56v56a8 8 0 0 1-8 8h-48a8 8 0 0 1-8-8v-56h-56a8 8 0 0 1-8-8z", "M280 288h-56v-56a8 8 0 0 0-8-8h-48a8 8 0 0 0-8 8v56h-56a8 8 0 0 0-8 8v48a8 8 0 0 0 8 8h56v56a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8v-56h56a8 8 0 0 0 8-8v-48a8 8 0 0 0-8-8zM360 0H24A24.07 24.07 0 0 0 0 24v48a24.07 24.07 0 0 0 24 24h336a24.07 24.07 0 0 0 24-24V24a24.07 24.07 0 0 0-24-24z"]],
    "presentation": [576, 512, [], "f685", ["M480 64h64v256a32 32 0 0 1-32 32H64a32 32 0 0 1-32-32V64h64v224h384z", "M560 0H16A16 16 0 0 0 0 16v32a16 16 0 0 0 16 16h544a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16zM320 386.75V352h-64v34.75l-75.31 75.31a16 16 0 0 0 0 22.63l22.62 22.62a16 16 0 0 0 22.63 0L288 445.25l62.06 62.06a16 16 0 0 0 22.63 0l22.62-22.62a16 16 0 0 0 0-22.63z"]],
    "print": [512, 512, [], "f02f", ["M64 480a32 32 0 0 0 32 32h320a32 32 0 0 0 32-32v-96H64zM368 96a16 16 0 0 1-16-16V0H96a32 32 0 0 0-32 32v192h384V96z", "M368 96h80v-4.58a17.92 17.92 0 0 0-5.25-12.67l-73.43-73.5A18 18 0 0 0 356.57 0H352v80a16 16 0 0 0 16 16zm80 96v32H64v-32a64 64 0 0 0-64 64v112a16 16 0 0 0 16 16h480a16 16 0 0 0 16-16V256a64 64 0 0 0-64-64zm-16 136a24 24 0 1 1 24-24 24 24 0 0 1-24 24z"]],
    "print-search": [672, 512, [], "f81a", ["M366.86 433.14A159.41 159.41 0 0 1 333.33 384H64v96a32 32 0 0 0 32 32h320a32 32 0 0 0 32-32v-3.2a159.82 159.82 0 0 1-81.14-43.66zM368 96a16 16 0 0 1-16-16V0H96a32 32 0 0 0-32 32v192h288a162.84 162.84 0 0 1 14.88-17.14A159.82 159.82 0 0 1 448 163.2V96z", "M368 96h80v-4.58a17.92 17.92 0 0 0-5.25-12.67l-73.43-73.5A18 18 0 0 0 356.57 0H352v80a16 16 0 0 0 16 16zm-16 128H64v-32a64 64 0 0 0-64 64v112a16 16 0 0 0 16 16h317.33c-.24-.57-.5-1.14-.74-1.71A159.92 159.92 0 0 1 352 224zm315.31 238.06l-77.41-77.41A126.65 126.65 0 0 0 608 320a128 128 0 1 0-128 128c23.7 0 45.61-6.88 64.65-18.11l77.41 77.42a16 16 0 0 0 22.63 0l22.62-22.62a16 16 0 0 0 0-22.63zM480 384a64 64 0 1 1 64-64 64 64 0 0 1-64 64z"]],
    "print-slash": [640, 512, [], "f686", ["M176 104.26V48h240v32a16 16 0 0 0 16 16h32v96H289.53L538 384h22a16 16 0 0 0 16-16V256a64 64 0 0 0-64-64V77.25a32 32 0 0 0-9.37-22.63L457.37 9.37A32 32 0 0 0 434.74 0H160a32 32 0 0 0-32 32v35.16zM496 248a24 24 0 1 1-24 24 24 24 0 0 1 24-24zm-64 216l59.29 45.72A31.48 31.48 0 0 1 480 512H160a32 32 0 0 1-32-32v-96H80a16 16 0 0 1-16-16V256a63.83 63.83 0 0 1 29.47-53.75L328 384H176v80z", "M636.64 480.55L617 505.82a16 16 0 0 1-22.46 2.81L6.18 53.9a16 16 0 0 1-2.81-22.45L23 6.18a16 16 0 0 1 22.47-2.81L633.82 458.1a16 16 0 0 1 2.82 22.45z"]],
    "procedures": [640, 512, [], "f487", ["M160 224a64 64 0 1 0 64 64 64 64 0 0 0-64-64zm368 0H272a16 16 0 0 0-16 16v144h384v-48.09A111.93 111.93 0 0 0 528 224z", "M136 96h126.1l27.6 55.2a16 16 0 0 0 28.6 0L368 51.83 390.1 96H512a16 16 0 0 0 0-32H409.9L382.3 8.83a16 16 0 0 0-28.6 0l-49.7 99.4-19.9-39.8a8 8 0 0 0-7.2-4.4H136a8 8 0 0 0-8 8V88a8 8 0 0 0 8 8zm120 288H64V144a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v352a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-48h512v48a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V384z"]],
    "project-diagram": [640, 512, [], "f542", ["M416 128H164.65l91.63 160H256a63.79 63.79 0 0 0-55.12 32L54.78 64H416z", "M384 320H256a32 32 0 0 0-32 32v128a32 32 0 0 0 32 32h128a32 32 0 0 0 32-32V352a32 32 0 0 0-32-32zM160 0H32A32 32 0 0 0 0 32v128a32 32 0 0 0 32 32h128a32 32 0 0 0 32-32V32a32 32 0 0 0-32-32zm448 0H480a32 32 0 0 0-32 32v128a32 32 0 0 0 32 32h128a32 32 0 0 0 32-32V32a32 32 0 0 0-32-32z"]],
    "projector": [640, 512, [], "f8d6", ["M592 192h-95.41C543.47 215.77 576 263.93 576 320c0 61.88-39.44 114.31-94.34 134.64L493 499.88A16 16 0 0 0 508.49 512h39A16 16 0 0 0 563 499.88L576 448h16a48 48 0 0 0 48-48V240a48 48 0 0 0-48-48zm-224.59 0H48a48 48 0 0 0-48 48v160a48 48 0 0 0 48 48h16l13 51.88A16 16 0 0 0 92.49 512h39A16 16 0 0 0 147 499.88L160 448h207.41C320.53 424.23 288 376.07 288 320s32.53-104.23 79.41-128zM96 352a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm96 0a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm325.66-218.35a16 16 0 0 0 22.62 0l67.88-67.88a16 16 0 0 0 0-22.63l-11.32-11.31a16 16 0 0 0-22.62 0l-67.88 67.89a16 16 0 0 0 0 22.62zM440 0h-16a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16zM323.72 133.65a16 16 0 0 0 22.62 0l11.32-11.31a16 16 0 0 0 0-22.62l-67.88-67.89a16 16 0 0 0-22.62 0l-11.32 11.31a16 16 0 0 0 0 22.63z", "M96 288a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm336-112a144 144 0 1 0 144 144 144 144 0 0 0-144-144zm0 240a96 96 0 1 1 96-96 96.14 96.14 0 0 1-96 96z"]],
    "pumpkin": [576, 512, [], "f707", ["M244 103.93l37.55-93.86a16 16 0 0 1 22-8.37l39.6 19.8A16 16 0 0 1 352 35.81v77.4C334.23 102.12 313.16 96 288 96a128.55 128.55 0 0 0-44 7.93z", "M495.31 486.87c-38.63 33-100.82 33.34-140.12 1.25C337.35 503.51 315.28 512 288 512s-49.35-8.49-67.18-23.88c-39.3 32.09-101.49 31.78-140.12-1.25-107.6-92-107.6-241.73 0-333.74 31.61-27 78.8-31.69 116.51-15-3.08 4-6.52 7.38-9.21 11.92-8.33 14.27-14.5 31.77-19.11 51.61a138.4 138.4 0 0 1 12.86-24.11Q215.76 128 288 128t106.25 49.5a138.5 138.5 0 0 1 12.86 24.12C402.5 181.78 396.32 164.27 388 150c-2.69-4.54-6.14-7.95-9.21-11.92 37.71-16.64 84.9-12 116.51 15 107.6 92.06 107.6 241.78.01 333.79z"]],
    "puzzle-piece": [576, 512, [], "f12e", ["M576 354.44C576 388 556.71 416 521.08 416c-39.89 0-50.35-36.15-86.31-36.15-60.55 0-25.83 120.1-25.83 120.1-51.55 0-181.23 35.07-181.23-25.73 0-35.83 36.29-46.25 36.29-86 0-35.5-28.12-54.71-61.79-54.71-34.33 0-63.58 18.89-63.58 56.34 0 41.37 40 59 40 81.47C178.63 541 0 500 0 500V166.76s175.88 41 175.88-28.66c0-22.48-31.71-40.39-31.71-81.75C144.17 18.89 175.88 0 210.54 0 243.88 0 272 19.22 272 54.72c0 39.73-36.29 50.16-36.29 86C235.71 224 432 144 432 144s-54.59 176.24 5.38 176.24c22.56 0 40.54-31.59 82.06-31.59 37.56 0 56.56 31.59 56.56 65.79z", ""]],
    "qrcode": [448, 512, [], "f029", ["M0 480h192V288H0zm64-128h64v64H64zM256 32v192h192V32zm128 128h-64V96h64zM0 224h192V32H0zM64 96h64v64H64z", "M416 480h32v-32h-32zm-64 0h32v-32h-32zm64-192v32h-64v-32h-96v192h64v-96h32v32h96V288z"]],
    "question": [384, 512, [], "f128", ["M182.43 373.46a69.27 69.27 0 1 0 69.28 69.27 69.28 69.28 0 0 0-69.28-69.27z", "M367.92 153.6c0 116-125.27 117.77-125.27 160.63V320a24 24 0 0 1-24 24h-72.47a24 24 0 0 1-24-24v-9.79c0-61.83 46.87-86.54 82.3-106.4 30.38-17 49-28.62 49-51.17 0-29.83-38-49.63-68.82-49.63-39.12 0-57.75 18.07-82.75 49.45a24 24 0 0 1-33.26 4.15L25.51 123.9A24 24 0 0 1 20.34 91c40.59-58.3 92.28-91 172.1-91 84.88 0 175.49 66.26 175.48 153.6z"]],
    "question-circle": [512, 512, [], "f059", ["M256 8C119 8 8 119.08 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm0 422a46 46 0 1 1 46-46 46.05 46.05 0 0 1-46 46zm40-131.33V300a12 12 0 0 1-12 12h-56a12 12 0 0 1-12-12v-4c0-41.06 31.13-57.47 54.65-70.66 20.17-11.31 32.54-19 32.54-34 0-19.82-25.27-33-45.7-33-27.19 0-39.44 13.14-57.3 35.79a12 12 0 0 1-16.67 2.13L148.82 170a12 12 0 0 1-2.71-16.26C173.4 113 208.16 90 262.66 90c56.34 0 116.53 44 116.53 102 0 77-83.19 78.21-83.19 106.67z", "M256 338a46 46 0 1 0 46 46 46 46 0 0 0-46-46zm6.66-248c-54.5 0-89.26 23-116.55 63.76a12 12 0 0 0 2.71 16.24l34.7 26.31a12 12 0 0 0 16.67-2.13c17.86-22.65 30.11-35.79 57.3-35.79 20.43 0 45.7 13.14 45.7 33 0 15-12.37 22.66-32.54 34C247.13 238.53 216 254.94 216 296v4a12 12 0 0 0 12 12h56a12 12 0 0 0 12-12v-1.33c0-28.46 83.19-29.67 83.19-106.67 0-58-60.19-102-116.53-102z"]],
    "question-square": [448, 512, [], "f2fd", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zM224 430a46 46 0 1 1 46-46 46.06 46.06 0 0 1-46 46zm40-131.33V300a12 12 0 0 1-12 12h-56a12 12 0 0 1-12-12v-4c0-41.06 31.13-57.47 54.65-70.66 20.17-11.31 32.54-19 32.54-34 0-19.81-25.27-33-45.7-33-27.19 0-39.44 13.13-57.3 35.79a12 12 0 0 1-16.67 2.13L116.82 170a12 12 0 0 1-2.71-16.26C141.4 113 176.16 90 230.66 90c56.34 0 116.53 44 116.53 102 0 77-83.19 78.21-83.19 106.67z", "M224 338a46 46 0 1 0 46 46 46.05 46.05 0 0 0-46-46zm6.66-248c-54.5 0-89.26 23-116.55 63.76a12 12 0 0 0 2.71 16.24l34.7 26.31a12 12 0 0 0 16.67-2.13c17.86-22.66 30.11-35.79 57.3-35.79 20.43 0 45.7 13.14 45.7 33 0 15-12.37 22.67-32.54 34C215.13 238.53 184 254.94 184 296v4a12 12 0 0 0 12 12h56a12 12 0 0 0 12-12v-1.33c0-28.46 83.19-29.67 83.19-106.67 0-58-60.19-102-116.53-102z"]],
    "quidditch": [640, 512, [], "f458", ["M494.5 351.82a79.9 79.9 0 1 0 79.8 79.9 79.91 79.91 0 0 0-79.8-79.9zM636.5 31L616.7 6a16 16 0 0 0-22.4-2.6L361.8 181.32l39.7 50.1L634 53.52A16 16 0 0 0 636.5 31z", "M93.2 257.72c-21.9 17.5-40.2 55.8-54.6 97.5l60.4-22.1a6 6 0 0 1 6.6 9.5L11 454.82c-7.2 32.3-11 55.4-11 55.4s206.7 13.6 266.6-34.1S343.2 326 343.2 326l-86.7-109.2s-103.4-6.88-163.3 40.92zm342.4 16.6l-107.9-136a11 11 0 0 0-18.6 2.2l-25.3 54.6 86.7 109.2 58.8-12.4a11 11 0 0 0 6.3-17.6z"]],
    "quote-left": [512, 512, [], "f10d", ["M464 256h-80v-64a64.06 64.06 0 0 1 64-64h8a23.94 23.94 0 0 0 24-23.88V56a23.94 23.94 0 0 0-23.88-24H448a160 160 0 0 0-160 160v240a48 48 0 0 0 48 48h128a48 48 0 0 0 48-48V304a48 48 0 0 0-48-48z", "M176 256H96v-64a64.06 64.06 0 0 1 64-64h8a23.94 23.94 0 0 0 24-23.88V56a23.94 23.94 0 0 0-23.88-24H160A160 160 0 0 0 0 192v240a48 48 0 0 0 48 48h128a48 48 0 0 0 48-48V304a48 48 0 0 0-48-48z"]],
    "quote-right": [512, 512, [], "f10e", ["M176 32H48A48 48 0 0 0 0 80v128a48 48 0 0 0 48 48h80v64a64.06 64.06 0 0 1-64 64h-8a23.94 23.94 0 0 0-24 23.88V456a23.94 23.94 0 0 0 23.88 24H64a160 160 0 0 0 160-160V80a48 48 0 0 0-48-48z", "M464 32H336a48 48 0 0 0-48 48v128a48 48 0 0 0 48 48h80v64a64.06 64.06 0 0 1-64 64h-8a23.94 23.94 0 0 0-24 23.88V456a23.94 23.94 0 0 0 23.88 24H352a160 160 0 0 0 160-160V80a48 48 0 0 0-48-48z"]],
    "quran": [448, 512, [], "f687", ["M96 448c-19.2 0-32-12.8-32-32s16-32 32-32h319.33c-1.93 16.24-1.76 48.38.53 64z", "M96 384h328a24 24 0 0 0 24-24V32a32 32 0 0 0-32-32H96A96 96 0 0 0 0 96v320a96 96 0 0 0 96 96h328a24 24 0 0 0 24-24v-16a24 24 0 0 0-24-24H96c-19.2 0-32-12.8-32-32s16-32 32-32zm208-240a3.23 3.23 0 0 1 2.92 1.82l11.18 22.65 25 3.63a3.26 3.26 0 0 1 1.81 5.56l-18.09 17.63 4.27 24.89a3.25 3.25 0 0 1-4.73 3.44L304 211.87l-22.36 11.75a3.25 3.25 0 0 1-4.73-3.44l4.27-24.89-18.09-17.63a3.26 3.26 0 0 1 1.81-5.56l25-3.63 11.19-22.65A3.23 3.23 0 0 1 304 144zm-60.81-67.19a114.69 114.69 0 0 1 40.38 7.41 6.78 6.78 0 1 1 0 13.55 6.85 6.85 0 0 1-2.37-.43c-.67 0-3.09-.21-4.13-.21a94.86 94.86 0 0 0 0 189.72c1 0 3.48-.21 4.13-.21a6.78 6.78 0 0 1 2.18 13.2 115.14 115.14 0 1 1-40.18-223z"]],
    "rabbit": [448, 512, [], "f708", ["M445.56 487.52L352 337.85V272h7.35a56.65 56.65 0 0 0 32.95-102.75l-48.65-34.75c-1.1-.54-2.27-.74-3.38-1.21 7.8-12.49 15.21-29.76 20.54-49.66 11.32-42.24 9.08-79.55-5-83.32s-34.67 27.41-46 69.69A221.91 221.91 0 0 0 304 99.12 223.51 223.51 0 0 0 298.24 70c-11.33-42.28-31.92-73.46-46-69.69s-16.32 41.08-5 83.32c6.94 25.9 17.37 47.54 27.64 59.62-9.11 7.93-15.9 18.5-18 31.55A63.35 63.35 0 0 0 256 185v71h-14A178 178 0 0 0 64 434v12a66 66 0 0 0 66 66h142a16 16 0 0 0 16-16v-16a32 32 0 0 0-32-32h-22.57l74.35-60.18 72.91 116.66a16 16 0 0 0 13.57 7.52H432a16 16 0 0 0 13.54-24.48zM336 208a16 16 0 1 1 16-16 16 16 0 0 1-16 16z", "M64 434a178.22 178.22 0 0 1 5.69-44.81 48 48 0 1 0 .74 85.25A65.57 65.57 0 0 1 64 446zm272-258a16 16 0 1 0 16 16 16 16 0 0 0-16-16z"]],
    "rabbit-fast": [576, 512, [], "f709", ["M135.5 396.68a16 16 0 0 0-7.5 13.57V448a16 16 0 0 0 24.48 13.57l66.69-39.87-47.84-47.85zm416.77-195.42l-56.42-34.62c-.06-13.95-2.29-30.77-7.08-48.67-11.31-42.24-31.9-73.43-46-69.66s-16.33 41.08-5 83.32c.65 2.44 1.44 4.7 2.15 7.06a224.93 224.93 0 0 0-16.32-18.32C392.7 89.45 359.27 72.73 349 83s6.41 43.73 37.33 74.66a198.36 198.36 0 0 0 37.42 29.78 60.18 60.18 0 0 0-6.88 19.32 63.07 63.07 0 0 0-.75 9.31C364.54 179.12 261.59 112 192 112a121.32 121.32 0 0 0-111.51 73.53 61.82 61.82 0 0 0 13.1 68.06l165.82 165.82a43 43 0 0 0 30.4 12.59H432a16 16 0 0 0 16-16v-16a32 32 0 0 0-32-32h-96v-55.58a80.3 80.3 0 0 0-58-76.91l-42.4-12.11a16 16 0 0 1 8.78-30.78l42.39 12.11A112.46 112.46 0 0 1 352 312.42V336l64-32h103.33a56.66 56.66 0 0 0 32.94-102.75zM496 240a16 16 0 1 1 16-16 16 16 0 0 1-16 16z", "M17.46 154.94A48 48 0 0 0 78.54 229a61.77 61.77 0 0 1 1.95-43.5 121.83 121.83 0 0 1 9.18-17.35 47 47 0 0 0-4.67-6.72 48 48 0 0 0-67.54-6.49zM496 208a16 16 0 1 0 16 16 16 16 0 0 0-16-16z"]],
    "racquet": [640, 512, [], "f45a", ["M6.65 431.11A16.1 16.1 0 0 0 3 453.41l36.8 51.8a16 16 0 0 0 22.2 3.9l120.7-82.6-56.7-80S6.75 431.21 6.65 431.11zM486 64c-106.4 0-178.6 90-195 141.1-21.3 66.2 13.3 112.8 83.9 112.8 84.1 0 171.1-66.8 195-141.1C591.15 110.71 556.55 64 486 64z", "M615.55 59.81c-55.2-77.9-182.9-78.9-283.4-7.7-57.3 40.6-94.6 96.4-106.8 151.1-11 49.5-35 94.5-67.7 132.7l45.7 64.5c87.4-33.7 144.3-18.6 171.9-18.6 49.6 0 104.4-17.2 153.5-52 102.25-72.4 141.1-193.3 86.8-270zM210.15 347a355.28 355.28 0 0 0 26.2-41c9.2 18 9.5 17.4 21.2 29.7a379.24 379.24 0 0 0-47.4 11.3zm359.7-170.2c-23.9 74.3-110.9 141.1-195 141.1-70.6 0-105.2-46.6-83.9-112.8C307.35 154 379.55 64 486 64c70.55 0 105.15 46.71 83.85 112.81z"]],
    "radiation": [496, 512, [], "f7b9", ["M296,255.82a48,48,0,1,1-48-48A48,48,0,0,1,296,255.82Z", "M125.23,452c-4.8,7.7-2.4,18.1,5.6,22.4a246.73,246.73,0,0,0,234.36,0c8-4.3,10.4-14.8,5.6-22.4L290.41,323.52a78.67,78.67,0,0,1-84.78,0Zm-109-196.18H167.82c0-28.59,15.2-53.49,37.8-67.69L125.23,59.74c-4.8-7.7-15.3-10.2-22.7-4.8C44.44,96.94,5.14,163.33,0,239.12c-.6,9,7.1,16.7,16.2,16.7Zm312,0H479.79c9.1,0,16.79-7.7,16.2-16.8-5.1-75.79-44.4-142.18-102.49-184.18-7.4-5.3-17.9-2.9-22.7,4.8L290.41,188c22.6,14.3,37.79,39.2,37.79,67.79Z"]],
    "radiation-alt": [496, 512, [], "f7ba", ["M248,288a32,32,0,1,0-32-32A32,32,0,0,0,248,288Zm0,216c137,0,248-111,248-248S385,8,248,8,0,119,0,256,111,504,248,504Zm0-432c101.5,0,184,82.5,184,184S349.5,440,248,440,64,357.5,64,256,146.5,72,248,72Z", "M104.9,256H184a63.76,63.76,0,0,1,30.2-54.1l-41.7-66.8a16.2,16.2,0,0,0-22.37-5h0a17,17,0,0,0-1.61,1.17A159.25,159.25,0,0,0,89,239.1C87.9,248.3,95.7,256,104.9,256ZM312,256h79.1c9.2,0,16.9-7.7,16-16.8-4.6-43.6-27-81.8-59.5-107.8a16.22,16.22,0,0,0-22.83,2.19,18.34,18.34,0,0,0-1.17,1.61L281.9,202A63.64,63.64,0,0,1,312,256ZM172.4,377c-4.9,7.8-2.4,18.4,5.8,22.5a156.1,156.1,0,0,0,139.7,0c8.2-4.1,10.6-14.7,5.8-22.5l-41.8-66.9a62.82,62.82,0,0,1-67.7,0Z"]],
    "radio": [512, 512, [], "f8d7", ["M448 128H64a64 64 0 0 0-64 64v256a64 64 0 0 0 64 64h384a64 64 0 0 0 64-64V192a64 64 0 0 0-64-64zM80 248a8 8 0 0 1 8-8h112a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8H88a8 8 0 0 1-8-8zm128 144a8 8 0 0 1-8 8H88a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h112a8 8 0 0 1 8 8zm16-64a8 8 0 0 1-8 8H72a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h144a8 8 0 0 1 8 8zm222.37 8.13a96 96 0 1 1 0-32.26 80.62 80.62 0 0 1 0 32.26z", "M511.4 27.05l-4.33-15.38A16 16 0 0 0 487.33.6L64 128h147.5l288.83-81.21a16 16 0 0 0 11.07-19.74zM352 224a96 96 0 1 0 96 96 96 96 0 0 0-96-96zm0 144a48 48 0 1 1 48-48 48.05 48.05 0 0 1-48 48z"]],
    "radio-alt": [512, 512, [], "f8d8", ["M448 128H64a64 64 0 0 0-64 64v256a64 64 0 0 0 64 64h384a64 64 0 0 0 64-64V192a64 64 0 0 0-64-64zM224 424a8 8 0 0 1-8 8H104a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h112a8 8 0 0 1 8 8zm32-64a8 8 0 0 1-8 8H72a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h176a8 8 0 0 1 8 8zm112 104a80 80 0 1 1 80-80 80 80 0 0 1-80 80zm80-208H64v-64h384z", "M511.4 27.05l-4.33-15.38A16 16 0 0 0 487.33.6L64 128h147.5l288.83-81.21a16 16 0 0 0 11.07-19.74zM64 256h384v-64H64zm304 48a80 80 0 1 0 80 80 80 80 0 0 0-80-80zm0 112a32 32 0 1 1 32-32 32 32 0 0 1-32 32z"]],
    "rainbow": [576, 512, [], "f75b", ["M287.83 224a96.24 96.24 0 0 0-18.93 1.9c-45.6 8.9-76.9 51.5-76.9 97.9V464a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V320a32 32 0 0 1 64 0v144a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V320a96.11 96.11 0 0 0-96.17-96zM268.3 32.67C115.4 42.87 0 176.87 0 330.17V464a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V320C64 186.8 180.9 80.3 317.5 97.9 430.4 112.37 512 214 512 327.77V464a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V320c0-165.33-140-298.63-307.7-287.33z", "M480 320v144a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V325.69c0-66.89-48.7-126.58-115.2-133.08C224.5 185.21 160 245.2 160 320v144a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V326.69c0-97.58 70-184.69 166.7-197.07C379.8 114.62 480 205.81 480 320z"]],
    "raindrops": [448, 512, [], "f75c", ["M169.3 38.9c-2.5-9-15.7-9.4-18.6 0-14.9 49.3-46.7 62.7-46.7 97.4a56 56 0 0 0 112 0c0-34.9-31.8-47.9-46.7-97.4zm-122.6 192C31.8 280.2 0 293.6 0 328.3a56 56 0 0 0 112 0c0-34.9-31.8-47.9-46.7-97.4-2.5-9-15.7-9.4-18.6 0z", "M341.2 143.2C375.4 252.1 448 280.7 448 357.6c0 67.6-57.2 122.4-128 122.4s-128-54.7-128-122.4c0-76.5 72.7-106 106.7-214.4 6.5-20.7 36.7-19.8 42.5 0z"]],
    "ram": [640, 512, [], "f70a", ["M488.14 303.26a58.45 58.45 0 0 1-7.44 51.21 53.12 53.12 0 0 1-43.45 23.3c-1.11 0-2.22 0-3.33-.11-7.84 21.52-27.89 36.18-50.23 36.18a51.08 51.08 0 0 1-30.4-10.18 51.46 51.46 0 0 1-65.62 1 51.74 51.74 0 0 1-32.21 11.2 50.43 50.43 0 0 1-31.86-11.17 50.77 50.77 0 0 1-31.34 10.57 55.21 55.21 0 0 1-34.18-11.78 52.9 52.9 0 0 1-30.58 9.86c-22.73 0-42.32-14.45-50-36.42-1.11.07-2.23.11-3.34.11-16.93 0-33.07-8.7-43.17-23.27a58.55 58.55 0 0 1-7.42-51.28C8.92 292.3 0 274.74 0 255.8c0-19.24 8.86-36.49 23.86-46.86a58.59 58.59 0 0 1 7.48-51.28c10.09-14.57 26.27-23.28 43.27-23.28q1.74 0 3.48.12c7.85-21.5 27.91-36.12 50.2-36.12a51.2 51.2 0 0 1 30.49 10.21A56 56 0 0 1 193 96.91a49.43 49.43 0 0 1 31 10.56 52 52 0 0 1 64.26 0A52 52 0 0 1 304 98.71a96 96 0 0 0 173 54.56 56.5 56.5 0 0 1 4 5.07 58.58 58.58 0 0 1 7.45 51.32c14.63 10.22 23.55 27.78 23.55 46.72 0 19.24-8.86 36.5-23.86 46.88z", "M622.25 106L576 83.22V64a32 32 0 0 0-32-32h-72.45a96 96 0 1 0 5.5 121.27A57.42 57.42 0 0 1 491.31 192h108.35A25.71 25.71 0 0 0 622 179.06c7.59-13.26 18-33.45 18-44.59A31.8 31.8 0 0 0 622.25 106zM400 144a48 48 0 1 1 48-48 48.05 48.05 0 0 1-48 48zm112-32a16 16 0 1 1 16-16 16 16 0 0 1-16 16zM193.46 418.86l1.37-3.64c-.86 0-1.71.07-2.57.07a55.21 55.21 0 0 1-34.18-11.78 52.9 52.9 0 0 1-30.58 9.86 51.69 51.69 0 0 1-30.12-9.6 64 64 0 0 0 .54 28.7l16.85 67.41A16 16 0 0 0 130.29 512h66a16 16 0 0 0 15.52-19.88zm240.46-41.2c-7.84 21.52-27.89 36.18-50.23 36.18a51.08 51.08 0 0 1-30.4-10.18c-.42.36-.86.7-1.29 1V496a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16V376.59a50.8 50.8 0 0 1-10.75 1.18c-1.11 0-2.25-.04-3.33-.11z"]],
    "ramp-loading": [384, 512, [], "f4d4", ["M355.4 383.3L321 314.5a13 13 0 0 0-1-1.5V64H64v249c-.3.5-.7.9-1 1.5l-34.4 68.8C12.6 381.5 0 368.5 0 352V32A32 32 0 0 1 32 0h320a32 32 0 0 1 32 32v320c0 16.4-12.6 29.5-28.6 31.3z", "M292.4 328.8l80 160a16 16 0 0 1-14.3 23.2H25.9a16 16 0 0 1-14.3-23.2l80-160a15.92 15.92 0 0 1 14.3-8.8h172.2a15.92 15.92 0 0 1 14.3 8.8z"]],
    "random": [512, 512, [], "f074", ["M505 359l-80-80c-15-15-41-4.47-41 17v40h-32l-52.78-56.55-53.33 57.14 70.55 75.6a12 12 0 0 0 8.77 3.81H384v40c0 21.46 26 32 41 17l80-80a24 24 0 0 0 0-34zM122.79 96H12a12 12 0 0 0-12 12v56a12 12 0 0 0 12 12h84l52.78 56.55 53.33-57.14-70.55-75.6a12 12 0 0 0-8.77-3.81z", "M505 119a24 24 0 0 1 0 34l-80 80c-15 15-41 4.48-41-17v-40h-32L131.56 412.19a12 12 0 0 1-8.77 3.81H12a12 12 0 0 1-12-12v-56a12 12 0 0 1 12-12h84L316.44 99.81a12 12 0 0 1 8.78-3.81H384V56c0-21.44 25.94-32 41-17z"]],
    "receipt": [384, 512, [], "f543", ["M358.4 3.23L320 48 265.6 3.23a15.9 15.9 0 0 0-19.2 0L192 48 137.6 3.23a15.9 15.9 0 0 0-19.2 0L64 48 25.6 3.23A16 16 0 0 0 0 16v480a16 16 0 0 0 25.6 12.8L64 464l54.4 44.8a15.9 15.9 0 0 0 19.2 0L192 464l54.4 44.8a15.9 15.9 0 0 0 19.2 0L320 464l38.4 44.8A16 16 0 0 0 384 496V16a16 16 0 0 0-25.6-12.77zM320 360a8 8 0 0 1-8 8H72a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h240a8 8 0 0 1 8 8zm0-96a8 8 0 0 1-8 8H72a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h240a8 8 0 0 1 8 8zm0-96a8 8 0 0 1-8 8H72a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h240a8 8 0 0 1 8 8z", "M312 144H72a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h240a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zm0 96H72a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h240a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zm0 96H72a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h240a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8z"]],
    "record-vinyl": [512, 512, [], "f8d9", ["M256 128a128 128 0 1 0 128 128 128 128 0 0 0-128-128zm0 152a24 24 0 1 1 24-24 24 24 0 0 1-24 24z", "M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm0 376a128 128 0 1 1 128-128 128 128 0 0 1-128 128z"]],
    "rectangle-landscape": [512, 512, [], "f2fa", ["M464 64H48a48 48 0 0 0-48 48v288a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V112a48 48 0 0 0-48-48zm-16 304a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16V144a16 16 0 0 1 16-16h352a16 16 0 0 1 16 16z", "M64 368V144a16 16 0 0 1 16-16h352a16 16 0 0 1 16 16v224a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16z"]],
    "rectangle-portrait": [384, 512, [], "f2fb", ["M336 0H48A48 48 0 0 0 0 48v416a48 48 0 0 0 48 48h288a48 48 0 0 0 48-48V48a48 48 0 0 0-48-48zm-16 432a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16V80a16 16 0 0 1 16-16h224a16 16 0 0 1 16 16z", "M64 432V80a16 16 0 0 1 16-16h224a16 16 0 0 1 16 16v352a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16z"]],
    "rectangle-wide": [640, 512, [], "f2fc", ["M592 96H48a48 48 0 0 0-48 48v224a48 48 0 0 0 48 48h544a48 48 0 0 0 48-48V144a48 48 0 0 0-48-48zm-16 240a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16V176a16 16 0 0 1 16-16h480a16 16 0 0 1 16 16z", "M64 336V176a16 16 0 0 1 16-16h480a16 16 0 0 1 16 16v160a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16z"]],
    "recycle": [512, 512, [], "f1b8", ["M497.29 301.1L469.77 257a12 12 0 0 0-16.53-3.83l-33.86 21.16a12 12 0 0 0-3.81 16.54L443.12 335c13.26 21.21-2.06 49-27.14 49H320v64h95.88c75.27 0 121.33-83 81.41-146.9zM148 384H96c-25 0-40.4-27.73-27.12-49l50.87-81.4-54.22-33.89-50.82 81.39C-25.19 365 20.78 448 96.11 448H148a12 12 0 0 0 12-12v-40a12 12 0 0 0-12-12zm230.67-272.86l-41.26-66.08c-37.52-60-125.21-60.17-162.82 0l-18 28.76a12 12 0 0 0 3.81 16.54l33.92 21.19a12 12 0 0 0 16.54-3.78L228.9 79c12.72-20.34 42-19.68 54.26 0l41.29 66.07z", "M184.56 261.88l-25.45-110.23a16 16 0 0 0-19.18-12L29.68 165.11c-13.84 3.19-17 21.61-4.88 29.16L160.48 279c12 7.47 27.3-3.17 24.07-17.17zm108.13 62.79l-80 80a16 16 0 0 0 0 22.63l80 80c10 10 27.31 3 27.31-11.31V336c0-14.23-17.24-21.4-27.31-11.33zm126.67-239l-135.65 84.85c-12 7.53-9 25.95 4.88 29.16l110.24 25.45a16 16 0 0 0 19.19-12l25.41-110.25c3.19-13.88-12-24.72-24.07-17.17z"]],
    "redo": [512, 512, [], "f01e", ["M422.36 422.69a12 12 0 0 1 0 17l-.49.46A247.1 247.1 0 0 1 255.67 504c-136.9 0-247.9-110.93-248-247.81C7.57 119.53 119 8 255.67 8a247.45 247.45 0 0 1 188.9 87.33l3.52 64.43-46.5-2.22A176 176 0 1 0 372 388.15a12 12 0 0 1 16.38.54z", "M512 12v200a12 12 0 0 1-12 12H300a12 12 0 0 1-12-12v-47.32a12 12 0 0 1 12-12h.58l147.54 7.06-7.44-147.19A12 12 0 0 1 452.07 0H500a12 12 0 0 1 12 12z"]],
    "redo-alt": [512, 512, [], "f2f9", ["M422.66 422.66a12 12 0 0 1 0 17l-.49.46A247.11 247.11 0 0 1 256 504C119 504 8 393 8 256 8 119.19 119.65 7.76 256.46 8a247.12 247.12 0 0 1 170.85 68.69l-56.62 56.56A166.73 166.73 0 0 0 257.49 88C165.09 87.21 87.21 162 88 257.45 88.76 348 162.18 424 256 424a166.77 166.77 0 0 0 110.63-41.56A12 12 0 0 1 383 383z", "M504 57.94V192a24 24 0 0 1-24 24H345.94c-21.38 0-32.09-25.85-17-41L463 41c15.15-15.15 41-4.44 41 16.94z"]],
    "registered": [512, 512, [], "f25d", ["M250.43 179.77h-23.37v56.14h29.87c18.6 0 28.43-9.83 28.43-28.44 0-18.93-6.26-27.7-34.93-27.7zM256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm86.39 388h-24.46a24 24 0 0 1-21.19-12.73l-44.13-82.93h-25.55V372a24 24 0 0 1-24 24h-22.57a24 24 0 0 1-24-24V139.68a24 24 0 0 1 24-24h70.67c74 0 105.49 35 105.49 89.25 0 31.48-14.51 59.31-37.94 74.48 1.4 2.37-2-3.82 44.7 81a24 24 0 0 1-21 35.59z", "M363.41 360.41c-46.73-84.82-43.3-78.63-44.7-81 23.43-15.17 37.94-43 37.94-74.48 0-54.25-31.5-89.25-105.49-89.25h-70.67a24 24 0 0 0-24 24V372a24 24 0 0 0 24 24h22.57a24 24 0 0 0 24-24v-71.66h25.55l44.13 82.93A24 24 0 0 0 317.93 396h24.46a24 24 0 0 0 21-35.59zm-106.48-124.5h-29.87v-56.14h23.37c28.67 0 34.93 8.77 34.93 27.7 0 18.61-9.83 28.44-28.43 28.44z"]],
    "remove-format": [640, 512, [], "f87d", ["M160 91.9V48a16 16 0 0 1 16-16h416a16 16 0 0 1 16 16v96a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-32H426.17L377 259.59l-67.06-51.83L341.82 112H224v29.36l-3.18-2.45zM336 416h-11.17l9.26-27.77L267 336.4 240.49 416H208a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M633.82 458.1L45.46 3.38A16 16 0 0 0 23 6.19L3.37 31.46a16 16 0 0 0 2.81 22.45l588.36 454.72a16 16 0 0 0 22.46-2.81l19.64-25.27a16 16 0 0 0-2.82-22.45z"]],
    "repeat": [512, 512, [], "f363", ["M494.84 183.65a159 159 0 0 1 17.16 72c0 88.23-71.77 160-160 160H170.07l34.51 32.42a24 24 0 0 1 .54 34.47l-10.78 10.77a24 24 0 0 1-33.94 0l-92.68-92.65a24 24 0 0 1 0-33.94L160.4 274a24 24 0 0 1 33.94 0l10.78 10.77a24 24 0 0 1-.54 34.47l-34.51 32.41H352a96 96 0 0 0 87.62-135.2 23.77 23.77 0 0 1 4.73-26.63l12.18-12.19a24 24 0 0 1 38.31 6.02z", "M67.65 321.52l-12.18 12.19a24 24 0 0 1-38.31-6A159 159 0 0 1 0 255.68c0-88.22 71.77-160 160-160h181.93l-34.51-32.41a24 24 0 0 1-.54-34.47L317.66 18a24 24 0 0 1 33.94 0l92.68 92.69a24 24 0 0 1 0 33.94l-92.68 92.71a24 24 0 0 1-33.94 0l-10.78-10.77a24 24 0 0 1 .54-34.47l34.51-32.42H160a96 96 0 0 0-87.62 135.21 23.78 23.78 0 0 1-4.73 26.63z"]],
    "repeat-1": [512, 512, [], "f365", ["M494.84 183.65a159 159 0 0 1 17.16 72c0 88.22-71.77 160-160 160H170.07l34.51 32.41a24 24 0 0 1 .54 34.47l-10.78 10.77a24 24 0 0 1-33.94 0l-92.68-92.64a24 24 0 0 1 0-33.94L148 286.45a24 24 0 0 1 33.94 0l10.77 10.77a24 24 0 0 1-.54 34.47l-22.09 20H352a96 96 0 0 0 87.62-135.21 23.78 23.78 0 0 1 4.73-26.63l12.18-12.18a24 24 0 0 1 38.31 5.98z", "M306.13 287.64h-15.49v-84.38c0-7.66-4.09-11.58-11.75-11.58h-12.1c-6.06 0-10 1.61-14.42 5.7l-21.72 19.94c-5.52 5.16-5.88 11-.54 16.38l5.52 6.23c5.16 5.52 11.22 5.34 15.67 1.07a34.35 34.35 0 0 0 2.85-3.74h.35s-.53 5.34-.53 10.5v39.88h-15.13c-7.66 0-11.58 4.1-11.58 11.57v8.9c0 7.48 3.92 11.57 11.58 11.57h67.29c7.65 0 11.57-4.09 11.57-11.57v-8.9c0-7.48-3.92-11.57-11.57-11.57zm138.15-176.92L351.6 18a24 24 0 0 0-33.94 0l-10.78 10.8a24 24 0 0 0 .54 34.47l34.51 32.42H160c-88.23 0-160 71.77-160 160a159 159 0 0 0 17.16 72 24 24 0 0 0 38.31 6l12.18-12.19a23.77 23.77 0 0 0 4.73-26.63A96 96 0 0 1 160 159.69h181.93l-22.09 20a24 24 0 0 0-.54 34.46l10.77 10.78a24 24 0 0 0 33.95 0l80.26-80.27a24 24 0 0 0 0-33.94z"]],
    "repeat-1-alt": [512, 512, [], "f366", ["M493.54 181.5A159 159 0 0 1 512 257.25C511.34 345.4 438.56 416 350.4 416H192v47.5c0 22.5-26.18 32.3-41 17.5l-80-80a24 24 0 0 1 0-33.94l80-80c15.11-15.11 41-4.34 41 17v48h158.87c52.82 0 96.58-42.18 97.12-95a95.53 95.53 0 0 0-9.21-42.06 23.94 23.94 0 0 1 4.8-27.28c4.74-4.71 8.64-8.55 11.87-11.79a24 24 0 0 1 38.09 5.57z", "M441 111.06l-80-80c-15-14.95-41-4.77-41 17.52V96H161.6C73.44 96 .66 166.67 0 254.82a159 159 0 0 0 18.46 75.75 24 24 0 0 0 38.09 5.57c3.23-3.23 7.13-7.08 11.87-11.78a24 24 0 0 0 4.8-27.29A95.46 95.46 0 0 1 64 255c.55-52.82 44.31-95 97.12-95H320v47.51c0 22.37 26.12 32.31 41 17.46l80-80a24 24 0 0 0 0-33.91zM306.13 288h-15.49v-84.4c0-7.65-4.09-11.57-11.75-11.57h-12.1c-6.06 0-10 1.6-14.42 5.7l-21.72 19.94c-5.52 5.16-5.88 11-.54 16.38l5.52 6.23c5.16 5.52 11.22 5.34 15.67 1.06a33.07 33.07 0 0 0 2.84-3.73h.36s-.5 5.39-.5 10.5V288h-15.16c-7.66 0-11.58 4.09-11.58 11.57v8.9c0 7.48 3.92 11.57 11.58 11.57h67.29c7.65 0 11.57-4.09 11.57-11.57v-8.9c0-7.49-3.92-11.57-11.57-11.57z"]],
    "repeat-alt": [512, 512, [], "f364", ["M493.54 181.5A159 159 0 0 1 512 257.25C511.34 345.4 438.56 416 350.4 416H192v47.5c0 22.5-26.18 32.3-41 17.5l-80-80a24 24 0 0 1 0-33.94l80-80c15.11-15.11 41-4.34 41 17v48h158.87c52.82 0 96.58-42.18 97.12-95a95.53 95.53 0 0 0-9.21-42.06 23.94 23.94 0 0 1 4.8-27.28c4.74-4.71 8.64-8.55 11.87-11.79a24 24 0 0 1 38.09 5.57z", "M68.42 324.35c-4.74 4.71-8.64 8.56-11.87 11.79a24 24 0 0 1-38.09-5.57A159 159 0 0 1 0 254.82C.66 166.67 73.44 96 161.6 96H320V48.58c0-22.29 26-32.47 41-17.52l80 80a24 24 0 0 1 0 33.94l-80 80c-14.85 14.85-41 4.91-41-17.46V160H161.12c-52.81 0-96.57 42.18-97.12 95a95.47 95.47 0 0 0 9.22 42 23.94 23.94 0 0 1-4.8 27.35z"]],
    "reply": [512, 512, [], "f3e5", ["M512 322.33c0 61.44-39.58 122.3-83.33 154.13-13.66 9.93-33.11-2.54-28.08-18.63 45.34-145-21.51-183.51-176.59-185.75v-136c160.63 1.83 288 34.02 288 186.25z", "M224 360c0 20.7-24.3 31.45-39.69 18.16l-176-152a24 24 0 0 1 0-36.32l176-152C199.72 24.55 224 35.35 224 56z"]],
    "reply-all": [576, 512, [], "f122", ["M115.39 250.38L224 344.17V360c0 20.7-24.3 31.45-39.69 18.16l-176-152a24 24 0 0 1 0-36.32l176-152C199.72 24.55 224 35.35 224 56v15.83l-108.61 93.79a56 56 0 0 0 0 84.76z", "M576 321.33c0 61.44-39.58 122.3-83.33 154.13-13.66 9.93-33.11-2.54-28.08-18.63 38.51-123.17-3.92-169.49-112.59-182V359c0 20.7-24.3 31.45-39.69 18.16l-176-152a24 24 0 0 1 0-36.32l176-152C327.72 23.55 352 34.35 352 55v82.77C481.18 148 576 190 576 321.33z"]],
    "republican": [640, 512, [], "f75e", ["M0 464V288h544v112a16 16 0 0 0 32 0v-64a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v64a80.14 80.14 0 0 1-88.4 79.6c-41.6-4.2-71.6-42.5-71.6-84.3V352h-32v112a16 16 0 0 1-16 16h-96a16 16 0 0 1-16-16v-80H128v80a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16z", "M384 32H160A160 160 0 0 0 0 192v64h544v-64A160 160 0 0 0 384 32zM176.3 170.4l-19.8 19.3 4.7 27.3a6 6 0 0 1-8.7 6.3L128 210.4l-24.5 12.9a6 6 0 0 1-8.7-6.3l4.7-27.3-19.8-19.3a6 6 0 0 1 3.3-10.2l27.4-4 12.2-24.8a6 6 0 0 1 10.7 0l12.2 24.8 27.4 4a6 6 0 0 1 3.4 10.2zm144 0l-19.8 19.3 4.7 27.3a6 6 0 0 1-8.7 6.3L272 210.4l-24.5 12.9a6 6 0 0 1-8.7-6.3l4.7-27.3-19.8-19.3a6 6 0 0 1 3.3-10.2l27.4-4 12.2-24.8a6 6 0 0 1 10.7 0l12.2 24.8 27.4 4a6 6 0 0 1 3.4 10.2zm144 0l-19.8 19.3 4.7 27.3a6 6 0 0 1-8.7 6.3L416 210.4l-24.5 12.9a6 6 0 0 1-8.7-6.3l4.7-27.3-19.8-19.3a6 6 0 0 1 3.3-10.2l27.4-4 12.2-24.8a6 6 0 0 1 10.7 0l12.2 24.8 27.4 4a6 6 0 0 1 3.4 10.2z"]],
    "restroom": [640, 512, [], "f7bd", ["M112 0a64 64 0 1 0 64 64 64.06 64.06 0 0 0-64-64zm208 0h-32a16 16 0 0 0-16 16v480a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16zm176 0a64 64 0 1 0 64 64 64.06 64.06 0 0 0-64-64z", "M623.3 354.5l-45.6-185.8c-3.3-13.5-15.5-23-29.8-24.2a95 95 0 0 1-104 0c-14.3 1.2-26.5 10.7-29.8 24.2l-45.6 185.8C365 369.6 377 384 393.2 384H448v104a23.94 23.94 0 0 0 24 24h48a23.94 23.94 0 0 0 24-24V384h54.8c16.2 0 28.2-14.4 24.5-29.5zM164.1 144.4a94.8 94.8 0 0 1-104.2 0A47.82 47.82 0 0 0 16 192v136a23.94 23.94 0 0 0 24 24h8v136a23.94 23.94 0 0 0 24 24h80a23.94 23.94 0 0 0 24-24V352h8a23.94 23.94 0 0 0 24-24V192a47.82 47.82 0 0 0-43.9-47.6z"]],
    "retweet": [640, 512, [], "f079", ["M10 202.66a24 24 0 0 1 0-33.94L110.72 68a24 24 0 0 1 33.94 0l100.68 100.71a24 24 0 0 1 0 33.95l-10.82 10.82a24 24 0 0 1-34.42-.48l-40.41-42.8v182.11h187.54a24 24 0 0 1 17 7l16 16c15.12 15.12 4.41 41-17 41H119.69a24 24 0 0 1-24-24V170.19L55.27 213a24 24 0 0 1-34.42.49z", "M259.17 137.28c-15.12-15.12-4.41-41 17-41h243.52a24 24 0 0 1 24 24v222.15l40.41-42.79a24 24 0 0 1 34.42-.49L629.34 310a24 24 0 0 1 0 33.94L528.66 444.6a24 24 0 0 1-33.94 0L394 343.91a24 24 0 0 1 0-33.91l10.82-10.82a24 24 0 0 1 34.42.49l40.42 42.79V160.31H292.14a24 24 0 0 1-17-7z"]],
    "retweet-alt": [640, 512, [], "f361", ["M96 192H48c-21.36 0-32-25.9-17-41l80-80a24 24 0 0 1 34 0l80 80c15.11 15.1 4.35 41-17 41h-48v160h202.08a18.9 18.9 0 0 1 17.67 12.08 55.89 55.89 0 0 0 12.68 19.52c11.95 11.95 3.49 32.4-13.43 32.4H120a24 24 0 0 1-24-24z", "M609 361l-80 80a24 24 0 0 1-33.94 0l-80-80c-15.11-15.11-4.34-41 17-41h48V160H278a18.91 18.91 0 0 1-17.68-12.08 55.72 55.72 0 0 0-12.67-19.52c-12-12-3.49-32.4 13.42-32.4H520a24 24 0 0 1 24 24v200h48c21.39 0 32.06 25.9 17 41z"]],
    "ribbon": [448, 512, [], "f4d6", ["M6 444.29l117.2-130 79.2 87.9-91.8 101.9a24.15 24.15 0 0 1-31.3 3.8L10.54 480A23.91 23.91 0 0 1 6 444.29z", "M89.34 228.69c-48.6-53.8-13-113.5-11.5-116l43.6-73.2a56.71 56.71 0 0 1 16.8-18c44-29.7 130.7-27.6 171.4 0a56.71 56.71 0 0 1 16.8 18l43.7 73.5a97.84 97.84 0 0 1-11.4 115.5l-34.2 38-79.1-87.7s52.7-59 56-64.6c-15.4-8.4-40.2-17.9-77.5-17.9s-62.1 9.5-77.5 17.9c3.4 5.5 295.4 330.1 295.4 330.1a23.76 23.76 0 0 1-4.3 35.6l-68.8 27.9a24 24 0 0 1-31.3-3.8z"]],
    "ring": [512, 512, [], "f70b", ["M64 208c0-44.18 86-80 192-80s192 35.82 192 80c0 21.81-20.95 41.57-54.9 56-34.85-14.81-83.39-24-137.1-24s-102.25 9.19-137.1 24C85 249.57 64 229.81 64 208z", "M256 64C110.06 64 0 125.91 0 208v98.13C0 384.48 114.62 448 256 448s256-63.52 256-141.87V208c0-82.09-110.06-144-256-144zm0 224c-106 0-192-35.82-192-80s86-80 192-80 192 35.82 192 80-86 80-192 80z"]],
    "rings-wedding": [512, 512, [], "f81b", ["M130.92 101.84L96 32l32-32h96l32 32-34.92 69.84a176.91 176.91 0 0 0-90.16 0zM350 160.56a207.16 207.16 0 0 1 29.06 72 111.89 111.89 0 1 1-96.46 4.95q-1.5-4.65-3.4-9.14l-.08-.2c-.39-.9-.78-1.8-1.19-2.69a3.54 3.54 0 0 0-.16-.34c-.41-.9-.84-1.79-1.27-2.68l-.09-.18q-1.44-2.91-3.06-5.73v-.07c-.5-.87-1-1.72-1.52-2.57-.11-.18-.22-.36-.34-.54-.43-.71-.87-1.41-1.33-2.11-.13-.21-.27-.42-.41-.63-.46-.7-.92-1.39-1.4-2.07L268 208q-1.8-2.58-3.74-5l-.48-.59c-.48-.61-1-1.21-1.47-1.81l-.67-.8c-.45-.53-.91-1.06-1.37-1.58l-.72-.83c-.49-.53-1-1.06-1.47-1.59l-.66-.72c-.71-.75-1.44-1.5-2.17-2.24a114.18 114.18 0 0 0-9.1-8.13 176.23 176.23 0 0 0-79.63 198.89A175.18 175.18 0 0 0 184 424.69q1.11 1.91 2.26 3.77c.76 1.24 1.54 2.46 2.34 3.68a.21.21 0 0 0 0 .06q1.18 1.82 2.42 3.6l.05.07q1.23 1.79 2.51 3.54c.85 1.18 1.73 2.35 2.61 3.5q1.33 1.75 2.72 3.46A176 176 0 1 0 350 160.56z", "M199 446.5a176 176 0 1 1 94-43 80.87 80.87 0 0 1-13.56-10.91 79.37 79.37 0 0 1-22.32-43.33 112 112 0 1 0-90.59 34.36A175.41 175.41 0 0 0 199 446.5z"]],
    "road": [576, 512, [], "f018", ["M267.74 192h40.54a12 12 0 0 0 11.93-13.26l-4.6-43.58a8 8 0 0 0-8-7.16h-39.25a8 8 0 0 0-8 7.16l-4.59 43.58A12 12 0 0 0 267.74 192zm5.68-96h29.16a8 8 0 0 0 8-8.84L308.09 64h-40.18l-2.45 23.16a8 8 0 0 0 7.96 8.84zm64.89 254.32A16 16 0 0 0 322.4 336h-68.8a16 16 0 0 0-15.91 14.32L227.38 448h121.24zm-78-46.32h55.29a16 16 0 0 0 15.91-17.68l-5.07-48A16 16 0 0 0 310.57 224h-45.15a16 16 0 0 0-15.91 14.32l-5.07 48A16 16 0 0 0 260.35 304z", "M573.19 402.67l-139.79-320C428.43 71.29 417.6 64 405.68 64h-97.59l2.45 23.16a8 8 0 0 1-8 8.84h-29.12a8 8 0 0 1-8-8.84L267.91 64h-97.59a30.45 30.45 0 0 0-27.73 18.67L2.8 402.67C-6.45 423.86 8.31 448 30.54 448h196.84l10.31-97.68A16 16 0 0 1 253.6 336h68.8a16 16 0 0 1 15.91 14.32L348.62 448h196.84c22.23 0 36.99-24.14 27.73-45.33zM255.81 178.74l4.59-43.58a8 8 0 0 1 8-7.16h39.29a8 8 0 0 1 8 7.16l4.6 43.58A12 12 0 0 1 308.28 192h-40.54a12 12 0 0 1-11.93-13.26zM315.64 304h-55.29a16 16 0 0 1-15.91-17.68l5.07-48A16 16 0 0 1 265.42 224h45.15a16 16 0 0 1 15.91 14.32l5.07 48A16 16 0 0 1 315.64 304z"]],
    "robot": [640, 512, [], "f544", ["M0 256v128a32 32 0 0 0 32 32h32V224H32a32 32 0 0 0-32 32zm608-32h-32v192h32a32 32 0 0 0 32-32V256a32 32 0 0 0-32-32zM192 416h64v-32h-64zm192 0h64v-32h-64zm-96 0h64v-32h-64z", "M464 96H352V32a32 32 0 0 0-64 0v64H176a80 80 0 0 0-80 80v272a64.06 64.06 0 0 0 64 64h320a64.06 64.06 0 0 0 64-64V176a80 80 0 0 0-80-80zM256 416h-64v-32h64zm-32-120a40 40 0 1 1 40-40 40 40 0 0 1-40 40zm128 120h-64v-32h64zm96 0h-64v-32h64zm-32-120a40 40 0 1 1 40-40 40 40 0 0 1-40 40z"]],
    "rocket": [512, 512, [], "f135", ["M383.85 311.19v106a47.92 47.92 0 0 1-26.5 42.9l-98.7 49.39A24 24 0 0 1 224 488V384.16l133.12-59.42q13.68-6.12 26.73-13.55zM187.18 154.6q6.06-13.6 13.41-26.6H94.82A48 48 0 0 0 52 154.49l-49.47 98.8A24 24 0 0 0 24 288h103.79z", "M505 19.1a15.9 15.9 0 0 0-12.2-12.2C460.6 0 435.41 0 410.31 0c-75.56 0-129 29.59-170.3 74a293 293 0 0 0-52.83 80.59L127.79 288l-22.47 22.47a32 32 0 0 0 0 45.25l50.9 50.91a32 32 0 0 0 45.25 0L224 384.16l133.12-59.42a293.28 293.28 0 0 0 80.59-53c44.45-41.4 74.19-94.85 74.19-170.08.1-25.16.1-50.36-6.9-82.56zM384 168a40 40 0 1 1 40-40 40 40 0 0 1-40 40z"]],
    "route": [512, 512, [], "f4d7", ["M512 416a96.15 96.15 0 0 1-96 96H138.2a690.4 690.4 0 0 0 47.3-64H416a32 32 0 0 0 0-64h-96a96 96 0 0 1 0-192h45.24A799.82 799.82 0 0 0 416 256h-96a32 32 0 0 0 0 64h96a96.15 96.15 0 0 1 96 96z", "M96 256a96 96 0 0 0-96 96c0 53 96 160 96 160s96-107 96-160a96 96 0 0 0-96-96zm0 128a32 32 0 1 1 32-32 32 32 0 0 1-32 32zM416 0a96 96 0 0 0-96 96c0 53 96 160 96 160s96-107 96-160a96 96 0 0 0-96-96zm0 128a32 32 0 1 1 32-32 32 32 0 0 1-32 32z"]],
    "route-highway": [448, 512, [], "f61a", ["M428.4 269.21c37.94 56.52 18.55 139.43-38.81 166L224 512 58.41 435.25c-57.36-26.6-76.75-109.51-38.81-166A93.67 93.67 0 0 0 35 224h378a93.55 93.55 0 0 0 15.4 45.21z", "M6.6 113.82a24.73 24.73 0 0 1 1.87-25.13l41.18-58.37c5-7.09 15.67-13.13 27.49-8.61a141.61 141.61 0 0 0 50.25 8.89c29.51 0 59.82-8.47 83.17-26.11a22.36 22.36 0 0 1 26.88 0c23.35 17.64 53.65 26.11 83.16 26.11a141.7 141.7 0 0 0 50.26-8.89c11.73-4.49 22.43 1.43 27.49 8.61l41.18 58.36a24.73 24.73 0 0 1 1.87 25.13c-12.16 25-22.84 51.88-27 78.19H33.58c-4.15-26.31-14.82-53.22-26.98-78.18z"]],
    "route-interstate": [480, 512, [], "f61b", ["M475.24 224c-16.7 107.6-80.3 224.14-235.24 288C85.05 448.14 21.46 331.6 4.76 224z", "M1.1 192c-3.81-51.73 2.64-99.8 14.08-136.87 3.61-11.69 15-19.1 26.18-16a214.52 214.52 0 0 0 58.1 8c49.12 0 93.61-16.07 126.17-42.1a23 23 0 0 1 28.75 0c32.56 26 77.05 42.1 126.17 42.1a214.52 214.52 0 0 0 58.1-8c11.26-3.15 22.58 4.29 26.18 16 11.43 37.09 17.88 85.16 14.07 136.87z"]],
    "router": [576, 512, [], "f8da", ["M566.22 82.05C444.81-27.34 259.26-27.34 137.78 82a16.11 16.11 0 0 0-.71 23.34l22.34 22.34a15.85 15.85 0 0 0 21.86.64c96.45-86.55 244.24-85.85 341.11.42a16 16 0 0 0 21.85-.63l22.7-22.7a16.1 16.1 0 0 0-.71-23.36zm-360.34 83.61a16.12 16.12 0 0 0-.86 23.61L227.73 212a15.94 15.94 0 0 0 21.7.78c58.77-49.84 145.8-49.36 205.14.21a16.07 16.07 0 0 0 21.63-.84l22.8-22.8a16.22 16.22 0 0 0-.84-23.63c-83.83-71.91-208.42-71.91-292.28-.06zM96 384a32 32 0 1 0 32 32 32 32 0 0 0-32-32z", "M528 320H376v-80a16 16 0 0 0-16-16h-16a16 16 0 0 0-16 16v80H48a48 48 0 0 0-48 48v96a48 48 0 0 0 48 48h480a48 48 0 0 0 48-48v-96a48 48 0 0 0-48-48zM96 448a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm96 0a32 32 0 1 1 32-32 32 32 0 0 1-32 32z"]],
    "rss": [448, 512, [], "f09e", ["M303.74 463.21c-8.35-154.6-132.18-278.59-286.95-286.95A16 16 0 0 0 0 192.25v48.07a16 16 0 0 0 14.89 16c111.83 7.28 201.47 96.7 208.77 208.77a16 16 0 0 0 16 14.89h48.07a16 16 0 0 0 16-16.79zM16.5 32A16 16 0 0 0 0 48v48.08a16 16 0 0 0 15.45 16c191.18 7.84 344.63 161.32 352.47 352.47a16 16 0 0 0 16 15.45H432a16 16 0 0 0 16-16.5C439.6 229.68 251.46 40.45 16.5 32z", "M0 416a64 64 0 1 1 64 64 64 64 0 0 1-64-64z"]],
    "rss-square": [448, 512, [], "f143", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zM112 416a48 48 0 1 1 48-48 48 48 0 0 1-48 48zm157.53 0H235.2a11.44 11.44 0 0 1-11.44-10.63A160.07 160.07 0 0 0 74.63 256.24 11.44 11.44 0 0 1 64 244.8v-34.33A11.42 11.42 0 0 1 76 199c110.55 6 199 94.54 205 205a11.42 11.42 0 0 1-11.47 12zm103 0h-34.3a11.45 11.45 0 0 1-11.43-11C321.2 268.43 211.59 158.8 75 153.2a11.45 11.45 0 0 1-11-11.43v-34.33A11.42 11.42 0 0 1 75.79 96C243.62 102 378 237.2 384 404.21A11.42 11.42 0 0 1 372.56 416z", "M112 320a48 48 0 1 0 48 48 48 48 0 0 0-48-48zM75.79 96A11.42 11.42 0 0 0 64 107.44v34.33a11.45 11.45 0 0 0 11 11.43c136.59 5.6 246.2 115.23 251.8 251.8a11.45 11.45 0 0 0 11.43 11h34.33A11.42 11.42 0 0 0 384 404.21C378 237.2 243.62 102 75.79 96zM76 199a11.42 11.42 0 0 0-12 11.43v34.37a11.44 11.44 0 0 0 10.63 11.44 160.07 160.07 0 0 1 149.13 149.13A11.44 11.44 0 0 0 235.2 416h34.33A11.42 11.42 0 0 0 281 404c-6-110.42-94.46-199-205-205z"]],
    "ruble-sign": [384, 512, [], "f158", ["M320 368v32a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h288a16 16 0 0 1 16 16z", "M239.36 32H76a12 12 0 0 0-12 12v206.63H12a12 12 0 0 0-12 12V308a12 12 0 0 0 12 12h52v148a12 12 0 0 0 12 12h58.56a12 12 0 0 0 12-12V320h92.8C324.48 320 384 260.54 384 175.07S324.48 32 239.36 32zM224 250.63h-77.44V100.75h78.72c46.72 0 74.88 29.11 74.88 74.32 0 45.83-28.16 75.56-76.16 75.56z"]],
    "ruler": [640, 512, [], "f545", ["M624.16 210l-496.8 281.9a32.18 32.18 0 0 1-43.5-11.5L4.26 344.77A31.1 31.1 0 0 1 16 302l69-39.1 59.7 101.4a8 8 0 0 0 10.9 2.9l13.8-7.8a7.78 7.78 0 0 0 2.9-10.7l-59.6-101.52 55.19-31.32 27.81 47.34a8 8 0 0 0 10.9 2.9l13.8-7.8a7.76 7.76 0 0 0 2.9-10.7l-27.93-47.4 55.19-31.31 59.7 101.68a8 8 0 0 0 10.9 2.9l13.8-7.8a7.78 7.78 0 0 0 2.9-10.7l-59.8-101.68 55.2-31.29 27.9 47.3a8 8 0 0 0 10.9 2.9l13.8-7.8a7.76 7.76 0 0 0 2.9-10.7l-27.89-47.38L416.06 75l59.7 101.59a8 8 0 0 0 10.9 2.9l13.8-7.8a7.76 7.76 0 0 0 2.9-10.7L443.68 59.31l69-39.14a32.18 32.18 0 0 1 43.5 11.5l79.6 135.5A31 31 0 0 1 624.16 210z", "M112.66 247.15L85 262.87l59.7 101.4a8 8 0 0 0 10.9 2.9l13.8-7.8a7.78 7.78 0 0 0 2.9-10.7zm165.4-93.88l-27.5 15.61 59.7 101.69a8 8 0 0 0 10.9 2.9l13.8-7.8a7.78 7.78 0 0 0 2.9-10.7zm-82.69 46.93l-27.52 15.63 27.81 47.34a8 8 0 0 0 10.9 2.9l13.8-7.8a7.76 7.76 0 0 0 2.9-10.7zm308-39.23l-59.7-101.7L416.06 75l59.7 101.6a8 8 0 0 0 10.9 2.9l13.8-7.8a7.76 7.76 0 0 0 2.9-10.7zm-142.5-54.7L333.26 122l27.9 47.3a8 8 0 0 0 10.9 2.9l13.8-7.8a7.76 7.76 0 0 0 2.9-10.7z"]],
    "ruler-combined": [512, 512, [], "f546", ["M512 384v96a32 32 0 0 1-32 32H32c-2.76 0-5.24-.91-7.8-1.57L182.63 352H224v56a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-56h64v56a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-56h64v56a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-56h32a32 32 0 0 1 32 32zm-352-96h-56a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h56v-64h-56a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h56V96h-56a8 8 0 0 1-8-8V72a8 8 0 0 1 8-8h56V32a32 32 0 0 0-32-32H32A32 32 0 0 0 0 32v448c0 2.77.91 5.24 1.57 7.8L160 329.38z", "M96 264v16a8 8 0 0 0 8 8h56v-32h-56a8 8 0 0 0-8 8zm0-192v16a8 8 0 0 0 8 8h56V64h-56a8 8 0 0 0-8 8zm0 96v16a8 8 0 0 0 8 8h56v-32h-56a8 8 0 0 0-8 8zm320 184v56a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-56zm-192 56a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-56h-32zm96 0a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-56h-32z"]],
    "ruler-horizontal": [576, 512, [], "f547", ["M576 160v192a32 32 0 0 1-32 32H32a32 32 0 0 1-32-32V160a32 32 0 0 1 32-32h48v88a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-88h64v88a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-88h64v88a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-88h64v88a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-88h64v88a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-88h48a32 32 0 0 1 32 32z", "M176 216a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-88h-32zm-96 0a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-88H80zm192 0a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-88h-32zm192-88v88a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-88zm-96 88a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-88h-32z"]],
    "ruler-triangle": [512, 512, [], "f61c", ["M501.65 452.08l-51.16-51.16-38.57 38.57a8 8 0 0 1-11.31 0l-11.31-11.31a8 8 0 0 1 0-11.31l38.57-38.57-56.57-56.57-38.57 38.57a8 8 0 0 1-11.31 0L310.11 349a8 8 0 0 1 0-11.31l38.57-38.57-56.57-56.57-38.57 38.57a8 8 0 0 1-11.31 0l-11.31-11.32a8 8 0 0 1 0-11.31l38.57-38.57-56.57-56.57-38.57 38.57a8 8 0 0 1-11.31 0l-11.31-11.31a8 8 0 0 1 0-11.31l38.57-38.57-56.6-56.59-38.57 38.57a8 8 0 0 1-11.31 0L72.51 111.4a8 8 0 0 1 0-11.31l38.57-38.57-51.17-51.17A34.36 34.36 0 0 0 35.35 0C17.31 0 0 14 0 35.17V476.9A35.09 35.09 0 0 0 35.1 512h441.73c31.27 0 46.93-37.8 24.82-59.92zM128 384V259.46L252.54 384z", "M310.11 337.68l38.57-38.57 22.62 22.62-38.57 38.57a8 8 0 0 1-11.31 0L310.11 349a8 8 0 0 1 0-11.32zM174.35 201.92l38.57-38.57-22.62-22.62-38.57 38.57a8 8 0 0 0 0 11.31L163 201.92a8 8 0 0 0 11.35 0zm-90.53-79.21a8 8 0 0 0 11.31 0l38.57-38.57-22.62-22.62-38.57 38.57a8 8 0 0 0 0 11.31zm208.29 119.83l-11.3-11.29-11.32-11.33-38.57 38.57a8 8 0 0 0 0 11.31l11.31 11.31a8 8 0 0 0 11.31 0zM427.87 378.3l-38.57 38.57a8 8 0 0 0 0 11.31l11.31 11.31a8 8 0 0 0 11.31 0l38.57-38.57z"]],
    "ruler-vertical": [256, 512, [], "f548", ["M160 104v16a8 8 0 0 0 8 8h88v64h-88a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h88v64h-88a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h88v64h-88a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h88v64a32 32 0 0 1-32 32H32a32 32 0 0 1-32-32V32A32 32 0 0 1 32 0h192a32 32 0 0 1 32 32v64h-88a8 8 0 0 0-8 8z", "M160 296v16a8 8 0 0 0 8 8h88v-32h-88a8 8 0 0 0-8 8zm0 96v16a8 8 0 0 0 8 8h88v-32h-88a8 8 0 0 0-8 8zm0-192v16a8 8 0 0 0 8 8h88v-32h-88a8 8 0 0 0-8 8zm8-104a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h88V96z"]],
    "running": [416, 512, [], "f70c", ["M272 96a48 48 0 1 1 48-48 48 48 0 0 1-48 48z", "M384 223.81h-44l-26.06-53.2c-12.5-25.53-35.45-44.2-61.78-50.9l-71.11-21.13a95.65 95.65 0 0 0-80.84 17.12l-39.67 30.39A32 32 0 1 0 99.3 197l.18-.13 39.69-30.39c7.67-5.88 17.44-8 25.27-6.13l14.7 4.36L141.68 252A64.09 64.09 0 0 0 168 332.23l85 50.13L225.53 470a32 32 0 0 0 60.79 20c.1-.3.19-.6.28-.9l31.6-101a48.15 48.15 0 0 0-21.64-54.35l-61.24-36.11 31.31-78.21 20.27 41.39a48.31 48.31 0 0 0 43.1 26.94h54a32 32 0 1 0 0-63.95zm-270.31 93.4l-14.8 34.5H32a32 32 0 1 0 0 63.94h77.45a47.88 47.88 0 0 0 44.11-29.06l8.79-20.5-10.67-6.3a95.23 95.23 0 0 1-38-42.58z"]],
    "rupee-sign": [320, 512, [], "f156", ["M320 144v32a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h288a16 16 0 0 1 16 16z", "M320 44v40a12 12 0 0 1-12 12h-76.26a144 144 0 0 1-114.87 223.91l150.88 139.27a12 12 0 0 1-8.14 20.82h-82.56a12 12 0 0 1-8.14-3.18L3.86 324.46A12 12 0 0 1 0 315.64v-48A12 12 0 0 1 9.13 256H96a79.68 79.68 0 0 0 31.39-6.4 68.32 68.32 0 0 0 6.21-3 80 80 0 0 0-4.83-143.6 71.06 71.06 0 0 0-31.52-7.28H12a12 12 0 0 1-12-12V44a12 12 0 0 1 12-12h296a12 12 0 0 1 12 12z"]],
    "rv": [640, 512, [], "f7be", ["M240 448a64 64 0 1 1-64-64 64 64 0 0 1 64 64zm400-133.5V384a32.09 32.09 0 0 1-32 32h-21.56a96 96 0 0 0-170.5-21.07V192l101.58.2a64.3 64.3 0 0 1 45.39 18.8l58.29 58.3a64.29 64.29 0 0 1 18.8 45.2zM572 288l-43.29-43.3a15.89 15.89 0 0 0-11.3-4.7h-37.48v48zm-76.08 96a64 64 0 1 0 64 64 64 64 0 0 0-64-64z", "M512 32H384V16a16 16 0 0 0-16-16H240a16 16 0 0 0-16 16v16H64A64.07 64.07 0 0 0 0 96v197.54a64 64 0 0 0 18.7 45.31l69.78 69.7a96 96 0 0 1 178 7.45H384V160h192c17.9 0 32.1-14.8 32-32.8A96 96 0 0 0 512 32zM256 208a16 16 0 0 1-16 16H112a16 16 0 0 1-16-16v-64a16 16 0 0 1 16-16h128a16 16 0 0 1 16 16z"]],
    "sack": [512, 512, [], "f81c", ["M192 96h128l47.4-71.12A16 16 0 0 0 354.09 0H157.94a16 16 0 0 0-13.31 24.88zm128 32H192C-10.38 243.4.09 396.64.09 416c0 53 49.11 96 109.68 96h292.48c60.58 0 109.68-43 109.68-96 0-19 9.35-173.24-191.93-288z", "M337 104v16a8 8 0 0 1-8 8H183a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h146a8 8 0 0 1 8 8z"]],
    "sack-dollar": [512, 512, [], "f81d", ["M192 96h128l47.4-71.12A16 16 0 0 0 354.09 0H157.94a16 16 0 0 0-13.31 24.88zm128 32H192C-10.38 243.4.09 396.64.09 416c0 53 49.11 96 109.68 96h292.48c60.58 0 109.68-43 109.68-96 0-19 9.35-173.24-191.93-288zm-46.58 278v17.34a8.68 8.68 0 0 1-8.7 8.62h-17.41a8.69 8.69 0 0 1-8.71-8.62v-17.51a63.14 63.14 0 0 1-34.16-12.17 8.52 8.52 0 0 1-.67-13l12.84-12.06a8.93 8.93 0 0 1 11-.76 26.71 26.71 0 0 0 13.93 4h30.58c7.07 0 12.84-6.35 12.84-14.22 0-6.46-3.92-12.06-9.58-13.67l-49-14.54c-20.24-6-34.39-25.2-34.39-46.74 0-26.38 20.68-47.82 46.46-48.57v-17.48a8.69 8.69 0 0 1 8.75-8.62h17.41a8.68 8.68 0 0 1 8.7 8.62v17.55a63.15 63.15 0 0 1 34.17 12.17 8.54 8.54 0 0 1 1.58 12 8.72 8.72 0 0 1-.92 1l-12.73 12.2a8.91 8.91 0 0 1-11 .75 26.8 26.8 0 0 0-13.93-4h-30.57c-7.07 0-12.84 6.35-12.84 14.21 0 6.46 3.92 12.06 9.57 13.68l49 14.54c20.24 6 34.38 25.2 34.38 46.74-.14 26.4-20.92 47.94-46.6 48.54z", "M285.64 310.72l-49-14.54c-5.65-1.62-9.57-7.22-9.57-13.68 0-7.86 5.77-14.21 12.84-14.21h30.56a26.8 26.8 0 0 1 13.93 4 8.91 8.91 0 0 0 11-.75l12.73-12.2a8.72 8.72 0 0 0 .92-1 8.54 8.54 0 0 0-1.56-12 63.15 63.15 0 0 0-34.17-12.17v-17.55a8.68 8.68 0 0 0-8.7-8.62H247.2a8.69 8.69 0 0 0-8.74 8.62v17.48c-25.78.75-46.46 22.19-46.46 48.57 0 21.54 14.15 40.74 34.39 46.74l49 14.54c5.66 1.61 9.58 7.21 9.58 13.67 0 7.87-5.77 14.22-12.84 14.22h-30.58a26.71 26.71 0 0 1-13.93-4 8.93 8.93 0 0 0-11 .76l-12.84 12.06a8.52 8.52 0 0 0 .67 13 63.14 63.14 0 0 0 34.16 12.17v17.51a8.69 8.69 0 0 0 8.71 8.62h17.41a8.68 8.68 0 0 0 8.7-8.62V406c25.68-.6 46.46-22.14 46.6-48.54-.03-21.54-14.15-40.74-34.39-46.74zM329 96H183a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h146a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8z"]],
    "sad-cry": [496, 512, [], "f5b3", ["M365,474.72l2.52-1.37Zm-2.2,1.16-2.46,1.28Zm-13.92,6.74,2.51-1.13Zm7.32-3.4-2.46,1.17ZM496,256A247.82,247.82,0,0,1,375.82,468.57l.18-.1V288a16,16,0,0,0-32,0V484.74a248.88,248.88,0,0,1-192,0V288a16,16,0,0,0-32,0V468.47h.06A247.81,247.81,0,0,1,0,256C0,119,111,8,248,8S496,119,496,256ZM192.2,233A12,12,0,0,0,212,222.2c-4-25.2-34.2-42.1-59.9-42.1S96.2,197,92.2,222.2A12,12,0,0,0,112,233l9.5-8.5c14.8-13.2,46.2-13.2,61,0ZM296,352c0-35.3-21.5-64-48-64s-48,28.7-48,64,21.5,64,48,64S296,387.3,296,352ZM404,222.2c-4-25.2-34.2-42.1-59.9-42.1s-55.9,16.9-59.9,42.1A12,12,0,0,0,304,233l9.6-8.6c14.8-13.2,46.2-13.2,61,0l9.5,8.5a11.92,11.92,0,0,0,13.7,1.6,12.36,12.36,0,0,0,6.2-12.3ZM344,484.74l2.42-1ZM128.48,473.35l2.52,1.37Zm4.72,2.53,2.46,1.28Zm-6.81-3.7c-.83-.47-1.67-.93-2.5-1.41C124.72,471.25,125.56,471.71,126.39,472.18Zm13.42,7c.81.4,1.63.78,2.45,1.17-.82-.35-1.64-.73-2.45-1.13Zm232.3-8.45c-.83.48-1.67.94-2.5,1.41.83-.43,1.67-.89,2.5-1.37Zm-227.5,10.72,2.51,1.13ZM152,484.7l-2.42-1Z", "M152.1,180.1c-25.7,0-55.9,16.9-59.9,42.1A12,12,0,0,0,112,233l9.5-8.5c14.8-13.2,46.2-13.2,61,0l9.7,8.5A12,12,0,0,0,212,222.2C208,197,177.8,180.1,152.1,180.1ZM404,222.2c-4-25.2-34.2-42.1-59.9-42.1s-55.9,16.9-59.9,42.1A12,12,0,0,0,304,233l9.6-8.6c14.8-13.2,46.2-13.2,61,0l9.5,8.5a11.92,11.92,0,0,0,13.7,1.6,12.36,12.36,0,0,0,6.2-12.3ZM360,272a16,16,0,0,0-16,16V484.74a247.25,247.25,0,0,0,32-16.27V288A16,16,0,0,0,360,272Zm-224,0a16,16,0,0,0-16,16V468.47a247.25,247.25,0,0,0,32,16.27V288A16,16,0,0,0,136,272Z"]],
    "sad-tear": [496, 512, [], "f5b4", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8Zm80,168a32,32,0,1,1-32,32A32,32,0,0,1,328,176ZM152,416c-26.5,0-48-21-48-47,0-20,28.5-60.4,41.6-77.8a8,8,0,0,1,11.2-1.6,7.58,7.58,0,0,1,1.6,1.6C171.5,308.6,200,349,200,369,200,395,178.5,416,152,416Zm16-176a32,32,0,1,1,32-32A32,32,0,0,1,168,240ZM338.2,394.2A117.35,117.35,0,0,0,248,352c-21.2,0-21.2-32,0-32a148.8,148.8,0,0,1,114.7,53.8c13.8,16.4-11.2,36.5-24.5,20.4Z", "M328,176a32,32,0,1,0,32,32A32,32,0,0,0,328,176ZM145.6,291.2C132.5,308.6,104,349,104,369c0,26,21.5,47,48,47s48-21,48-47c0-20-28.5-60.4-41.6-77.8a8,8,0,0,0-11.2-1.6,7.58,7.58,0,0,0-1.6,1.6ZM168,176a32,32,0,1,0,32,32A32,32,0,0,0,168,176Z"]],
    "salad": [512, 512, [], "f81e", ["M416 96c2.65 0 5.12.62 7.73.78C406.14 76.87 380.69 64 352 64a95.2 95.2 0 0 0-25.15 3.75 111.94 111.94 0 0 0-205.7 0A95.2 95.2 0 0 0 96 64a96 96 0 0 0 0 192h73.37l-87-87a8 8 0 0 1 0-11.31l11.32-11.29a8 8 0 0 1 11.31 0l103 103V104a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v152h52.54a126.78 126.78 0 0 1-4.54-32A128.14 128.14 0 0 1 416 96zm33.25 38a95.3 95.3 0 0 0-123.37 122h169.29a48.23 48.23 0 0 1 10.57 1.24A95.86 95.86 0 0 0 449.25 134z", "M384 468.52V480a32 32 0 0 1-32 32H160a32 32 0 0 1-32-32v-11.28C58.27 444.26 6.69 381.24.06 304.87-.74 295.75 7 288 16.17 288h479c9.15 0 16.89 7.72 16.1 16.84C504.66 381 453.4 443.9 384 468.52z"]],
    "sandwich": [512, 512, [], "f81f", ["M512 271.07v32.14c0 .47 0 .93-.08 1.4a16.27 16.27 0 0 1-17.78 14.6c-28.52-2.6-45.94-11.36-60.41-18.6S408.54 288 384.12 288s-35 5.3-49.64 12.62c-17.26 8.63-38.7 19.38-78.26 19.38s-61.08-10.73-78.34-19.38C163.2 293.3 152.58 288 128.11 288S93 293.3 78.36 300.63s-31.93 16-60.51 18.59c-.47 0-.94.07-1.41.08A16.26 16.26 0 0 1 0 303.22v-32.14a15.93 15.93 0 0 1 14.1-15.79c15.16-1.67 24.16-6.17 35.67-11.91C67 234.73 88.53 224 128.11 224s61.08 10.75 78.36 19.38C221.14 250.7 231.8 256 256.22 256s35-5.3 49.64-12.62c17.26-8.63 38.72-19.38 78.26-19.38s61 10.75 78.27 19.39c11.51 5.73 20.43 10.22 35.51 11.9a15.94 15.94 0 0 1 14.1 15.78z", "M480 352h-64l-96 48-96-48H32a32 32 0 0 0-32 32v64a32 32 0 0 0 32 32h448a32 32 0 0 0 32-32v-64a32 32 0 0 0-32-32zm0-320H32A32 32 0 0 0 0 64v96a32 32 0 0 0 32 32h448a32 32 0 0 0 32-32V64a32 32 0 0 0-32-32z"]],
    "satellite": [512, 512, [], "f7bf", ["M111.93 377.4l-17.8 17.8c-2.6-.7-5-1.6-7.8-1.6a32 32 0 1 0 32 32c0-2.8-.9-5.2-1.6-7.8l17.8-17.8zm390.79-112.31l-.09-.09-80.38-80.42-33.95 34-107.8 107.8 80.35 80.35a31.87 31.87 0 0 0 45 0l96.7-96.7a31.78 31.78 0 0 0 .17-44.94zM247 9.3A32 32 0 0 0 224.43 0a31.61 31.61 0 0 0-22.5 9.3l-96.7 96.7a32 32 0 0 0 0 45.1l80.33 80.33 141.7-141.84z", "M470.13 136.8l-199.5 199.45a190.46 190.46 0 0 1-5.4 168.45c-4.5 8.5-16.4 9.6-23.2 2.8L4.43 270c-6.8-6.8-5.7-18.59 2.8-23.19a190.6 190.6 0 0 1 168.5-5.4l199.4-199.59a33.64 33.64 0 0 1 47.5 0l47.5 47.49a33.61 33.61 0 0 1 0 47.49z"]],
    "satellite-dish": [512, 512, [], "f7c0", ["M224 256.15a32 32 0 0 0-32 32c0 2.8.9 5.2 1.6 7.8l-27.4 27.4L188.8 346l27.4-27.4c2.6.7 5 1.6 7.8 1.6a32 32 0 0 0 0-64zM511.9 303C503.4 139.85 372.2 8.65 209 0a16.08 16.08 0 0 0-17 15.2v32.43a15.85 15.85 0 0 0 15 15.9c129.4 7 233.4 112 240.9 241.5a16 16 0 0 0 15.9 15h32.1a16.12 16.12 0 0 0 16-16.18c.03-.27.02-.55 0-.85zM209.3 96a16.12 16.12 0 0 0-17.25 14.91c0 .4-.05.79-.05 1.19v32.1a15.94 15.94 0 0 0 14.8 15.9c76.8 6.3 138 68.2 144.9 145.2a16.08 16.08 0 0 0 15.9 14.7h32.2a16.19 16.19 0 0 0 16.14-16.25v-1C407.5 192.65 319.4 104.55 209.3 96z", "M302.4 487.55c-77.7 41.8-176.7 29.9-242.3-35.7s-77.5-164.5-35.7-242.3c4.9-9.1 17.7-10.3 25-3l256 256c7.4 7.3 6.2 20.1-3 25z"]],
    "sausage": [512, 512, [], "f820", ["M416 64a96 96 0 0 0-96 96c0 88.22-71.78 160-160 160a96 96 0 0 0 0 192 351.79 351.79 0 0 0 352-352 96 96 0 0 0-96-96zM160 400a16 16 0 0 1 0-32c114.69 0 208-93.31 208-208a16 16 0 0 1 32 0c0 132.34-107.66 240-240 240z", "M24.18 369A18.36 18.36 0 0 0 1 380.59a18.11 18.11 0 0 0-1 5.79v59.24A18.38 18.38 0 0 0 24.18 463l45.26-15.08a96.4 96.4 0 0 1 0-63.88zM451.41 1a18.11 18.11 0 0 0-5.79-1h-59.24a18.36 18.36 0 0 0-18.33 18.39 18.68 18.68 0 0 0 .95 5.79l15.08 45.26a96.4 96.4 0 0 1 63.88 0l15-45.27A18.36 18.36 0 0 0 451.41 1zM384 144a16 16 0 0 0-16 16c0 114.69-93.31 208-208 208a16 16 0 0 0 0 32c132.34 0 240-107.66 240-240a16 16 0 0 0-16-16z"]],
    "save": [448, 512, [], "f0c7", ["M288 352a64 64 0 1 1-64-64 64 64 0 0 1 64 64z", "M433.94 129.94l-83.88-83.88A48 48 0 0 0 316.12 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V163.88a48 48 0 0 0-14.06-33.94zM224 416a64 64 0 1 1 64-64 64 64 0 0 1-64 64zm96-204a12 12 0 0 1-12 12H76a12 12 0 0 1-12-12V108a12 12 0 0 1 12-12h228.52a12 12 0 0 1 8.48 3.52l3.48 3.48a12 12 0 0 1 3.52 8.48z"]],
    "sax-hot": [640, 512, [], "f8db", ["M635.28 100.69L608 73.37A32 32 0 0 0 585.34 64h-46.83a64 64 0 0 0-45.26 18.74L210 366a25.41 25.41 0 0 1-39.76-31l47.39-79H240a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v16a15.91 15.91 0 0 0 15.21 15.84C7.48 288.56 0 326.72 0 352c0 61.4 35 114.09 85.73 140.92A150 150 0 0 0 160 512c77.1 0 116.46-51.33 128-64l246.39-308a32 32 0 0 1 25-12H624c14.22 0 21.36-17.23 11.28-27.31zM88 392a24 24 0 1 1 24-24 24 24 0 0 1-24 24zm32-88a24 24 0 1 1 24-24 24 24 0 0 1-24 24z", "M320 212.69L308.69 224a16 16 0 0 0 0 22.63L319 257l34-34-10.35-10.34a16 16 0 0 0-22.65.03zM177.77 25.6a301.94 301.94 0 0 0-28.1 30A387.31 387.31 0 0 0 100 0C50.88 45.58 16 105 16 140.8a117 117 0 0 0 5.89 35.2h61.34A60.88 60.88 0 0 1 72 140.8c0-7.62 8.66-30.3 28.46-57.54q2 2.61 3.89 5.22L147 147.26l27.06-33.08c6.07 12.1 9.54 22.24 9.92 26.62a60.88 60.88 0 0 1-11.21 35.2h61.34a117 117 0 0 0 5.89-35.2c0-26.63-26-81.57-62.23-115.2zM368 164.69L356.69 176a16 16 0 0 0 0 22.63L367 209l34-34-10.35-10.34a16 16 0 0 0-22.65.03zm70.62-48a16 16 0 0 0-22.62 0L404.69 128a16 16 0 0 0 0 22.63L415 161l34-34z"]],
    "saxophone": [640, 512, [], "f8dc", ["M635.28 68.69L608 41.37A32 32 0 0 0 585.34 32h-46.83a64 64 0 0 0-45.26 18.74L210 334a25.41 25.41 0 0 1-39.76-31l76.16-127H272a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h11.46C18.65 207.92 0 280.13 0 320c0 61.4 35 114.09 85.73 140.92A150 150 0 0 0 160 480c77.1 0 116.46-51.33 128-64l246.39-308a32 32 0 0 1 25-12H624c14.22 0 21.36-17.23 11.28-27.31zM96 344a24 24 0 1 1 24-24 24 24 0 0 1-24 24zm32-96a24 24 0 1 1 24-24 24 24 0 0 1-24 24z", "M320 180.69L308.69 192a16 16 0 0 0 0 22.63L319 225l34-34-10.34-10.34a16 16 0 0 0-22.66.03zm118.63-96a16 16 0 0 0-22.63 0L404.69 96a16 16 0 0 0 0 22.63L415 129l34-34zm-70.63 48L356.69 144a16 16 0 0 0 0 22.63L367 177l34-34-10.34-10.34a16 16 0 0 0-22.66.03zM96 296a24 24 0 1 0 24 24 24 24 0 0 0-24-24zm32-96a24 24 0 1 0 24 24 24 24 0 0 0-24-24z"]],
    "scalpel": [512, 512, [], "f61d", ["M176 320h105.6v8c0 38.39-15.35 76.61-46.72 102.32l-.59.48C170.28 482.82 87 512.07 0 512z", "M199.9 288a16 16 0 0 1-12.19-26.47l201.5-235.46C412.52-1.18 453.5-9 482.7 11.85c33.76 24.08 38.9 71.69 12.53 102.49l-139 162.44A32.08 32.08 0 0 1 331.84 288z"]],
    "scalpel-path": [640, 512, [], "f61e", ["M234.29 430.84C170.28 482.82 87 512.07 0 512l176-192h105.6v8c0 38.39-15.35 76.61-46.72 102.32z", "M482.71 11.85c-29.2-20.83-70.18-13-93.49 14.22l-201.5 235.46A16 16 0 0 0 199.91 288h131.94a32.08 32.08 0 0 0 24.37-11.22l139-162.44c26.38-30.8 21.24-78.41-12.51-102.49zM632 480h-80a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h80a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zm-160 0h-80a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h80a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zm-160 0h-80a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h80a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8z"]],
    "scanner": [640, 512, [], "f488", ["M256 448a32 32 0 0 0 32-32V304.27L205 448zM368 64H96a95.91 95.91 0 0 0-1.7 191.79L6.44 408A48 48 0 0 0 24 473.53l55.4 32A48 48 0 0 0 145 488l134-232h89.09a16 16 0 0 0 16-16V80a16 16 0 0 0-16.03-16z", "M632 448H456a8 8 0 0 0-8 8v48a8 8 0 0 0 8 8h176a8 8 0 0 0 8-8v-48a8 8 0 0 0-8-8zm0-96H456a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h176a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zm0-64H456a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h176a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zm0-224H456a8 8 0 0 0-8 8v48a8 8 0 0 0 8 8h176a8 8 0 0 0 8-8V72a8 8 0 0 0-8-8zm0 96H456a8 8 0 0 0-8 8v48a8 8 0 0 0 8 8h176a8 8 0 0 0 8-8v-48a8 8 0 0 0-8-8zm0-160H456a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h176a8 8 0 0 0 8-8V8a8 8 0 0 0-8-8z"]],
    "scanner-image": [640, 512, [], "f8f3", ["M0 320v128a32 32 0 0 0 32 32h576a32 32 0 0 0 32-32V288H32a32 32 0 0 0-32 32zm120 80a8 8 0 0 1-8 8H80a8 8 0 0 1-8-8v-32a8 8 0 0 1 8-8h32a8 8 0 0 1 8 8zm96 0a8 8 0 0 1-8 8h-32a8 8 0 0 1-8-8v-32a8 8 0 0 1 8-8h32a8 8 0 0 1 8 8z", "M617.84 220.84L36.31 32.83a16 16 0 0 0-20.25 10.1L.83 88.46a16 16 0 0 0 10.1 20.25L566.88 288H640v-36.71a32 32 0 0 0-22.16-30.45zM112 360H80a8 8 0 0 0-8 8v32a8 8 0 0 0 8 8h32a8 8 0 0 0 8-8v-32a8 8 0 0 0-8-8z"]],
    "scanner-keyboard": [576, 512, [], "f489", ["M400 96H16a16 16 0 0 0-16 16v137.4a16 16 0 0 0 4.7 11.3L32 288v176a48 48 0 0 0 48 48h256a48 48 0 0 0 48-48V288l27.3-27.3a16 16 0 0 0 4.7-11.3V112a16 16 0 0 0-16-16zM192 440a8 8 0 0 1-8 8h-80a8 8 0 0 1-8-8v-48a8 8 0 0 1 8-8h80a8 8 0 0 1 8 8zm0-96a8 8 0 0 1-8 8h-80a8 8 0 0 1-8-8v-48a8 8 0 0 1 8-8h80a8 8 0 0 1 8 8zm128 96a8 8 0 0 1-8 8h-80a8 8 0 0 1-8-8v-48a8 8 0 0 1 8-8h80a8 8 0 0 1 8 8zm0-96a8 8 0 0 1-8 8h-80a8 8 0 0 1-8-8v-48a8 8 0 0 1 8-8h80a8 8 0 0 1 8 8zm32-128a8 8 0 0 1-8 8H72a8 8 0 0 1-8-8v-48a8 8 0 0 1 8-8h272a8 8 0 0 1 8 8z", "M568 0h-48a8 8 0 0 0-8 8v272a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8V8a8 8 0 0 0-8-8zM320 8a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v56h32zm-64 0a8 8 0 0 0-8-8h-48a8 8 0 0 0-8 8v56h64zm152-8h-48a8 8 0 0 0-8 8v56h64V8a8 8 0 0 0-8-8zm64 0h-16a8 8 0 0 0-8 8v272a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8V8a8 8 0 0 0-8-8zM344 160H72a8 8 0 0 0-8 8v48a8 8 0 0 0 8 8h272a8 8 0 0 0 8-8v-48a8 8 0 0 0-8-8z"]],
    "scanner-touchscreen": [576, 512, [], "f48a", ["M400 96H16a16 16 0 0 0-16 16v137.4a16 16 0 0 0 4.7 11.3L32 288v176a48 48 0 0 0 48 48h256a48 48 0 0 0 48-48V288l27.3-27.3a16 16 0 0 0 4.7-11.3V112a16 16 0 0 0-16-16zm-80 336a16 16 0 0 1-16 16H112a16 16 0 0 1-16-16V176a16 16 0 0 1 16-16h192a16 16 0 0 1 16 16z", "M312 0h-16a8 8 0 0 0-8 8v56h32V8a8 8 0 0 0-8-8zm-56 8a8 8 0 0 0-8-8h-48a8 8 0 0 0-8 8v56h64zm152-8h-48a8 8 0 0 0-8 8v56h64V8a8 8 0 0 0-8-8zm160 0h-48a8 8 0 0 0-8 8v272a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8V8a8 8 0 0 0-8-8zm-96 0h-16a8 8 0 0 0-8 8v272a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8V8a8 8 0 0 0-8-8zM304 160H112a16 16 0 0 0-16 16v256a16 16 0 0 0 16 16h192a16 16 0 0 0 16-16V176a16 16 0 0 0-16-16z"]],
    "scarecrow": [448, 512, [], "f70d", ["M216.84 414.2L192 401v95a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-95l-24.87 13.2a15.08 15.08 0 0 1-14.29 0zM224 0a96 96 0 1 0 96 96 96 96 0 0 0-96-96zm-32 96a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm64 16a16 16 0 1 1 16-16 16 16 0 0 1-16 16z", "M445.75 186.39l-.08-.09-26.39-26.3 18.29-18.3a8 8 0 0 0-5.7-13.7H314.48a96 96 0 0 1-181 0H16a8 8 0 0 0-5.7 13.7L28.72 160 2.34 186.3a8 8 0 0 0 0 11.3L28.72 224l-18.3 18.3a8 8 0 0 0 5.7 13.7h106.09l-26 141.3a16 16 0 0 0 22.9 16.9l32.71-24.2a16 16 0 0 1 17.08-1.3l47.91 25.5a15.08 15.08 0 0 0 14.29 0l47.9-25.5a16 16 0 0 1 17.1 1.3l32.7 24.2a15.93 15.93 0 0 0 22.89-16.9L325.88 256h106.06a8.05 8.05 0 0 0 5.69-13.7L419.28 224l26.29-26.3a8 8 0 0 0 .18-11.31zM256 112a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm-64-16a16 16 0 1 0-16-16 16 16 0 0 0 16 16z"]],
    "scarf": [512, 512, [], "f7c1", ["M509.72 395.71l-117.39-117.1-22.61 22.6L487 418.31a8 8 0 0 0 11.3 0L509.62 407a7.92 7.92 0 0 0 .1-11.29zm-207.89-26.8l-22.61 22.6 117.4 117.2a8 8 0 0 0 11.3 0l11.3-11.3a8 8 0 0 0 0-11.3zM166 323.71L47.62 441.91a8 8 0 0 0 0 11.3l11.3 11.3a8 8 0 0 0 11.3 0l118.4-118.2zm-45.31-45.1L2.33 396.71a8 8 0 0 0 0 11.3l11.29 11.3a8 8 0 0 0 11.3 0l118.41-118.2zM347 323.71l-22.61 22.6 117.41 117.2a8 8 0 0 0 11.29 0l11.3-11.3a8 8 0 0 0 0-11.3zM92.92 487.11a8 8 0 0 0 0 11.3l11.3 11.3a8 8 0 0 0 11.31 0l118.39-118.2-22.59-22.6z", "M279.12 120.51l19.5-19.4a185.4 185.4 0 0 0-84.4-.2L369.62 256 256.53 369.11l-135.1-140.7c-48.6-53.7-13-113.3-11.5-115.8l43.6-73.1a56.71 56.71 0 0 1 16.8-18c44-29.7 130.7-27.6 171.3-.1a56.71 56.71 0 0 1 16.8 18l43.7 73.4c7.2 12 33.4 65.6-13.2 117.3z"]],
    "school": [640, 512, [], "f549", ["M360 176h-24v-40a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v64a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zM0 224v272a16 16 0 0 0 16 16h80V192H32a32 32 0 0 0-32 32zm608-32h-64v320h80a16 16 0 0 0 16-16V224a32 32 0 0 0-32-32z", "M497.75 112l-160-106.63a32 32 0 0 0-35.5 0L142.25 112A32 32 0 0 0 128 138.66V512h128V368a16 16 0 0 1 16-16h96a16 16 0 0 1 16 16v144h128V138.67A32 32 0 0 0 497.75 112zM320 256a80 80 0 1 1 80-80 80 80 0 0 1-80 80z"]],
    "screwdriver": [512, 512, [], "f54a", ["M448 0l64 64-96 128h-62.07l-83 83A98.45 98.45 0 0 0 237 241.09l83-83V96z", "M63.61 501.08l-52.7-52.7a37.28 37.28 0 0 1 0-52.71L128 278.59A74.54 74.54 0 0 1 233.4 384L116.32 501.08a37.26 37.26 0 0 1-52.71 0z"]],
    "scroll": [640, 512, [], "f70e", ["M544 96v288H304a16 16 0 0 0-16 16v32a80 80 0 0 1-160 0V65A65 65 0 0 0 63 0h385a96.1 96.1 0 0 1 96 96z", "M64 0A64 64 0 0 0 0 64v48a16 16 0 0 0 16 16h112V65A65 65 0 0 0 64 0zm128 512h16c-2.59 0-5.14-.13-7.66-.37-2.75.24-5.53.37-8.34.37zm432-128H304a16 16 0 0 0-16 16v32a80 80 0 0 1-80 80h320a112 112 0 0 0 112-112.06A16 16 0 0 0 624 384z"]],
    "scroll-old": [640, 512, [], "f70f", ["M539.31 228.69L512 256l27.31 27.31a16 16 0 0 1 4.69 11.32V384h-89.37a16 16 0 0 0-11.32 4.69L416 416l-27.31-27.31a16 16 0 0 0-11.32-4.69H304a16 16 0 0 0-16 16v32a80 80 0 0 1-80.61 80c-44.11-.33-79.39-36.89-79.39-81V262.63a16 16 0 0 1 4.69-11.32L160 224l-27.31-27.31a16 16 0 0 1-4.69-11.32V65A65 65 0 0 0 63 0h385a96.1 96.1 0 0 1 95.68 88.2 16.15 16.15 0 0 1-4.63 12.8L512 128l27.31 27.31a16 16 0 0 1 4.69 11.32v50.74a16 16 0 0 1-4.69 11.32z", "M192 512h16c-2.59 0-5.14-.13-7.66-.37-2.75.24-5.53.37-8.34.37zM64 0A64 64 0 0 0 0 64v48a16 16 0 0 0 16 16h112V65A65 65 0 0 0 64 0zm560 384H454.63a16 16 0 0 0-11.32 4.69L416 416l-27.31-27.31a16 16 0 0 0-11.32-4.69H304a16 16 0 0 0-16 16v32a80 80 0 0 1-80 80h320a112 112 0 0 0 112-112.06A16 16 0 0 0 624 384z"]],
    "scrubber": [496, 512, [], "f2f8", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8Zm0,312a64,64,0,1,1,64-64A64,64,0,0,1,248,320Z", "M248,320a64,64,0,1,1,64-64A64,64,0,0,1,248,320Z"]],
    "scythe": [640, 512, [], "f710", ["M549.87 0L510 192H0C64 64 192 0 338.87 0z", "M639.44 38l-96.27 461a16 16 0 0 1-15.72 13H496a16 16 0 0 1-16-16 16.16 16.16 0 0 1 .27-2.94l29.26-141H400a16 16 0 0 1-16-16V304a16 16 0 0 1 16-16h122.81L582.55 0H608a32 32 0 0 1 31.44 38z"]],
    "sd-card": [384, 512, [], "f7c2", ["M112 160h48V64h-48zm80 0h48V64h-48zm80-96v96h48V64z", "M320 0H128L0 128v320a64.06 64.06 0 0 0 64 64h256a64.06 64.06 0 0 0 64-64V64a64.06 64.06 0 0 0-64-64zM160 160h-48V64h48zm80 0h-48V64h48zm80 0h-48V64h48z"]],
    "search": [512, 512, [], "f002", ["M208 80a128 128 0 1 1-90.51 37.49A127.15 127.15 0 0 1 208 80m0-80C93.12 0 0 93.12 0 208s93.12 208 208 208 208-93.12 208-208S322.88 0 208 0z", "M504.9 476.7L476.6 505a23.9 23.9 0 0 1-33.9 0L343 405.3a24 24 0 0 1-7-17V372l36-36h16.3a24 24 0 0 1 17 7l99.7 99.7a24.11 24.11 0 0 1-.1 34z"]],
    "search-dollar": [512, 512, [], "f688", ["M208 80a128 128 0 1 1-90.51 37.49A127.15 127.15 0 0 1 208 80m0-80C93.12 0 0 93.12 0 208s93.12 208 208 208 208-93.12 208-208S322.88 0 208 0z", "M235.13 199.42l-45-13.5c-5.16-1.55-8.77-6.78-8.77-12.73 0-7.27 5.3-13.19 11.8-13.19h28.11a24 24 0 0 1 12.82 3.72 8.21 8.21 0 0 0 10.13-.73L256 151.78a8 8 0 0 0-.57-12.14A57.26 57.26 0 0 0 224 128.29V112a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v16.12c-23.63.63-42.68 20.55-42.68 45.07 0 20 13 37.81 31.58 43.39l45 13.5c5.16 1.55 8.77 6.78 8.77 12.73 0 7.27-5.3 13.19-11.8 13.19H194.8a24 24 0 0 1-12.8-3.72 8.21 8.21 0 0 0-10.13.73l-11.77 11.21a8 8 0 0 0 .57 12.14A57.26 57.26 0 0 0 192 287.71V304a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-16.12c23.63-.63 42.68-20.54 42.68-45.07.04-19.97-12.95-37.81-31.55-43.39zM505 442.7L405.3 343a24 24 0 0 0-17-7H372l-36 36v16.3a24 24 0 0 0 7 17l99.7 99.7a23.9 23.9 0 0 0 33.9 0l28.3-28.3a24.11 24.11 0 0 0 .1-34z"]],
    "search-location": [512, 512, [], "f689", ["M208 80a128 128 0 1 1-90.51 37.49A127.15 127.15 0 0 1 208 80m0-80C93.12 0 0 93.12 0 208s93.12 208 208 208 208-93.12 208-208S322.88 0 208 0z", "M208 112a73.83 73.83 0 0 0-73.84 73.83c0 33 48.26 93 66.75 114.86a9.22 9.22 0 0 0 13 1.16 8.55 8.55 0 0 0 1.17-1.16c18.49-21.81 66.75-81.89 66.75-114.86A73.83 73.83 0 0 0 208 112zm0 96a24 24 0 1 1 24-24 24 24 0 0 1-24 24zm297 234.7L405.3 343a24 24 0 0 0-17-7H372l-36 36v16.3a24 24 0 0 0 7 17l99.7 99.7a23.9 23.9 0 0 0 33.9 0l28.3-28.3a24.11 24.11 0 0 0 .1-34z"]],
    "search-minus": [512, 512, [], "f010", ["M208 80a128 128 0 1 1-90.51 37.49A127.15 127.15 0 0 1 208 80m0-80C93.12 0 0 93.12 0 208s93.12 208 208 208 208-93.12 208-208S322.88 0 208 0z", "M292 180H124a12 12 0 0 0-12 12v32a12 12 0 0 0 12 12h168a12 12 0 0 0 12-12v-32a12 12 0 0 0-12-12zm213 262.7L405.3 343a24 24 0 0 0-17-7H372l-36 36v16.3a24 24 0 0 0 7 17l99.7 99.7a23.9 23.9 0 0 0 33.9 0l28.3-28.3a24.11 24.11 0 0 0 .1-34z"]],
    "search-plus": [512, 512, [], "f00e", ["M208 80a128 128 0 1 1-90.51 37.49A127.15 127.15 0 0 1 208 80m0-80C93.12 0 0 93.12 0 208s93.12 208 208 208 208-93.12 208-208S322.88 0 208 0z", "M292 180h-56v-56a12 12 0 0 0-12-12h-32a12 12 0 0 0-12 12v56h-56a12 12 0 0 0-12 12v32a12 12 0 0 0 12 12h56v56a12 12 0 0 0 12 12h32a12 12 0 0 0 12-12v-56h56a12 12 0 0 0 12-12v-32a12 12 0 0 0-12-12zm213 262.7L405.3 343a24 24 0 0 0-17-7H372l-36 36v16.3a24 24 0 0 0 7 17l99.7 99.7a23.9 23.9 0 0 0 33.9 0l28.3-28.3a24.11 24.11 0 0 0 .1-34z"]],
    "seedling": [512, 512, [], "f4d8", ["M512 32c0 115.9-88 211.1-200.7 222.8a256.38 256.38 0 0 0-59-107.6C290.6 78.5 363.8 32 448 32z", "M288 320v144a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V320C100.3 320 0 219.7 0 96h64c123.7 0 224 100.3 224 224z"]],
    "send-back": [640, 512, [], "f87e", ["M608 256H416a32 32 0 0 0-32 32v192a32 32 0 0 0 32 32h192a32 32 0 0 0 32-32V288a32 32 0 0 0-32-32zm-32 192H448V320h128zM224 0H32A32 32 0 0 0 0 32v192a32 32 0 0 0 32 32h192a32 32 0 0 0 32-32V32a32 32 0 0 0-32-32zm-32 192H64V64h128z", "M384 416H208a48 48 0 0 1-48-48V256h64a32 32 0 0 0 32-32V96h176a48 48 0 0 1 48 48v112h-64a32 32 0 0 0-32 32z"]],
    "send-backward": [514, 512, [], "f87f", ["M464,160H208a48,48,0,0,0-48,48V464a48,48,0,0,0,48,48H464a48,48,0,0,0,48-48h0V208A48,48,0,0,0,464,160ZM448,448H224V224H448Z", "M160,352H48A48,48,0,0,1,0,304V48A48,48,0,0,1,48,0H304a48,48,0,0,1,48,48V160H208a48,48,0,0,0-48,48Z"]],
    "server": [512, 512, [], "f233", ["M432 120a24 24 0 1 0-24-24 24 24 0 0 0 24 24zm0 272a24 24 0 1 0 24 24 24 24 0 0 0-24-24zm48-200H32a32 32 0 0 0-32 32v64a32 32 0 0 0 32 32h448a32 32 0 0 0 32-32v-64a32 32 0 0 0-32-32zm-112 88a24 24 0 1 1 24-24 24 24 0 0 1-24 24zm64 0a24 24 0 1 1 24-24 24 24 0 0 1-24 24z", "M456 256a24 24 0 1 0-24 24 24 24 0 0 0 24-24zm24-224H32A32 32 0 0 0 0 64v64a32 32 0 0 0 32 32h448a32 32 0 0 0 32-32V64a32 32 0 0 0-32-32zm-112 88a24 24 0 1 1 24-24 24 24 0 0 1-24 24zm64 0a24 24 0 1 1 24-24 24 24 0 0 1-24 24zm48 232H32a32 32 0 0 0-32 32v64a32 32 0 0 0 32 32h448a32 32 0 0 0 32-32v-64a32 32 0 0 0-32-32zm-112 88a24 24 0 1 1 24-24 24 24 0 0 1-24 24zm64 0a24 24 0 1 1 24-24 24 24 0 0 1-24 24z"]],
    "shapes": [512, 512, [], "f61f", ["M128 256a128 128 0 1 0 128 128 128 128 0 0 0-128-128zm379.51-80l-95-160c-12.67-21.33-44.35-21.33-57 0l-95 160c-12.67 21.33 3.17 48 28.51 48H479c25.34 0 41.18-26.67 28.51-48z", "M512 320v160a32 32 0 0 1-32 32H320a32 32 0 0 1-32-32V320a32 32 0 0 1 32-32h160a32 32 0 0 1 32 32z"]],
    "share": [512, 512, [], "f064", ["M288 136.08v136c-155.08 2.24-221.93 40.73-176.59 185.75 5 16.09-14.42 28.56-28.08 18.63C39.58 444.64 0 383.78 0 322.34c0-152.23 127.37-184.42 288-186.26z", "M506.16 223.7a24 24 0 0 1-2.47 2.47l-176 152C312.3 391.46 288 380.71 288 360V56c0-20.66 24.28-31.46 39.69-18.16l176 152a24 24 0 0 1 2.47 33.86z"]],
    "share-all": [576, 512, [], "f367", ["M567.69 226.16l-176 152C376.3 391.44 352 380.69 352 360v-15.83l108.61-93.79a56 56 0 0 0 0-84.76L352 71.83V56c0-20.66 24.28-31.46 39.69-18.16l176 152a24 24 0 0 1 0 36.32z", "M439.69 226.16l-176 152C248.3 391.44 224 380.69 224 360v-84.19c-108.67 12.53-151.1 58.85-112.59 182 5 16.09-14.42 28.56-28.08 18.63C39.58 444.63 0 383.77 0 322.33 0 191 94.82 149 224 138.78V56c0-20.66 24.28-31.46 39.69-18.16l176 152a24 24 0 0 1 0 36.32z"]],
    "share-alt": [448, 512, [], "f1e0", ["M155.79 180.9l102.49-64.06a95.93 95.93 0 0 0 33.93 54.26l-102.49 64.06a95.93 95.93 0 0 0-33.93-54.26zm136.42 160l-102.49-64.06a95.93 95.93 0 0 1-33.93 54.26l102.49 64.06a95.93 95.93 0 0 1 33.93-54.26z", "M96 160a96 96 0 1 0 96 96 96 96 0 0 0-96-96zm256 32a96 96 0 1 0-96-96 96 96 0 0 0 96 96zm0 128a96 96 0 1 0 96 96 96 96 0 0 0-96-96z"]],
    "share-alt-square": [448, 512, [], "f1e1", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-96 376a56 56 0 0 1-54.26-69.9l-68-40.77a56 56 0 1 1 0-82.66l68-40.77a56 56 0 1 1 16.48 27.43l-68 40.77a56.39 56.39 0 0 1 0 27.8l68 40.77A56 56 0 1 1 304 408z", "M360 352a56 56 0 1 1-110.26-13.9l-68-40.77a56 56 0 1 1 0-82.66l68-40.77a56 56 0 1 1 16.48 27.43l-68 40.77a56.39 56.39 0 0 1 0 27.8l68 40.77A56 56 0 0 1 360 352z"]],
    "share-square": [576, 512, [], "f14d", ["M0 464V112a48 48 0 0 1 48-48h121c12.55 0 16.68 16.83 5.55 22.63a195.1 195.1 0 0 0-51 37.68 12 12 0 0 1-8.64 3.69H64v320h320v-68.87a12 12 0 0 1 13.8-11.86 71.73 71.73 0 0 0 34.2-3.38 12 12 0 0 1 16 11.3V464a48 48 0 0 1-48 48H48a48 48 0 0 1-48-48z", "M424.48 6.56l144 136a24 24 0 0 1 0 34.9l-144 136C409.3 327.77 384 317.14 384 296v-72c-144.58 1-205.57 35.12-164.78 171.36 4.49 15-12.84 26.56-25 17.33-39-29.6-74.22-86.22-74.22-143.37C120 125.4 237.6 96.84 384 96V24c0-21.16 25.32-31.76 40.48-17.44z"]],
    "sheep": [640, 512, [], "f711", ["M320.09 96a50.51 50.51 0 0 0-31.8 11.46 52 52 0 0 0-64.26 0 49.43 49.43 0 0 0-31-10.56 56 56 0 0 0-34.25 11.68 51.2 51.2 0 0 0-30.49-10.21C106 98.38 85.94 113 78.09 134.5q-1.74-.12-3.48-.12c-17 0-33.18 8.71-43.27 23.28a58.59 58.59 0 0 0-7.48 51.28C8.86 219.31 0 236.56 0 255.8c0 18.94 8.92 36.5 23.53 46.71A58.55 58.55 0 0 0 31 353.79c10.1 14.57 26.24 23.27 43.17 23.27 1.11 0 2.23 0 3.34-.11 7.72 22 27.31 36.42 50 36.42a52.9 52.9 0 0 0 30.58-9.86 55.21 55.21 0 0 0 34.18 11.78 50.77 50.77 0 0 0 31.34-10.57 50.43 50.43 0 0 0 31.86 11.17 51.74 51.74 0 0 0 32.21-11.2 51.46 51.46 0 0 0 65.62-1 51.08 51.08 0 0 0 30.4 10.18c22.34 0 42.39-14.66 50.23-36.18 1.11.07 2.22.11 3.33.11a53.12 53.12 0 0 0 43.45-23.3 58.45 58.45 0 0 0 7.44-51.21c15-10.38 23.85-27.64 23.86-46.88 0-18.94-8.92-36.5-23.53-46.72a58.58 58.58 0 0 0-7.48-51.35c-10.09-14.55-26.2-23.24-43.09-23.24-1.13 0-2.27 0-3.4.11-7.7-21.7-27.73-36.51-50.14-36.51a52.51 52.51 0 0 0-30.4 9.9A53.08 53.08 0 0 0 320.09 96z", "M433.92 377.66c-7.84 21.52-27.89 36.18-50.23 36.18a51.08 51.08 0 0 1-30.4-10.18c-.42.36-.86.7-1.29 1V496a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16V376.59a50.8 50.8 0 0 1-10.75 1.18c-1.11 0-2.25-.04-3.33-.11zm-240.46 41.2l1.37-3.64c-.86 0-1.71.07-2.57.07a55.21 55.21 0 0 1-34.18-11.78 52.9 52.9 0 0 1-30.58 9.86 51.69 51.69 0 0 1-30.12-9.6 64 64 0 0 0 .54 28.7l16.85 67.41A16 16 0 0 0 130.29 512h66a16 16 0 0 0 15.52-19.88zM622.25 106L576 83.22V64a32 32 0 0 0-32-32h-64a32 32 0 0 0-64 0v77.6a55.82 55.82 0 0 1 18.53 25.61c1.13-.07 2.27-.11 3.4-.11 16.89 0 33 8.69 43.09 23.24A58.11 58.11 0 0 1 491.31 192h108.35A25.71 25.71 0 0 0 622 179.06c7.59-13.26 18-33.45 18-44.59A31.8 31.8 0 0 0 622.25 106zM512 112a16 16 0 1 1 16-16 16 16 0 0 1-16 16z"]],
    "shekel-sign": [448, 512, [], "f20b", ["M200 176v224h112a56 56 0 0 0 56-56V48a16 16 0 0 1 16-16h48a16 16 0 0 1 16 16v296a136 136 0 0 1-136 136H144a24 24 0 0 1-24-24V176a16 16 0 0 1 16-16h48a16 16 0 0 1 16 16z", "M328 168v168a16 16 0 0 1-16 16h-48a16 16 0 0 1-16-16V168a56 56 0 0 0-56-56H80v352a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16V56a24 24 0 0 1 24-24h168a136 136 0 0 1 136 136z"]],
    "shield": [512, 512, [], "f132", ["M256 224v288a48.12 48.12 0 0 0 18.41-3.68c72.34-30.14 180.16-123 212.09-284.29zM237.59 3.67l-192 80A47.92 47.92 0 0 0 16 128a485.36 485.36 0 0 0 9.63 96H256V0a57.58 57.58 0 0 0-18.41 3.67z", "M237.5 508.32A48 48 0 0 0 256 512V224H25.63C55.11 370.52 148.77 471.34 237.5 508.32zm229-424.64l-192-80A57.34 57.34 0 0 0 256.06 0H256v224h230.5a491.56 491.56 0 0 0 9.5-96 48 48 0 0 0-29.5-44.32z"]],
    "shield-alt": [512, 512, [], "f3ed", ["M496 128c0 221.29-135.9 344.6-221.6 380.32A48.29 48.29 0 0 1 256 512V0a48.18 48.18 0 0 1 18.5 3.67l192 80A48 48 0 0 1 496 128z", "M256 0v512a48.18 48.18 0 0 1-18.5-3.67C130.5 463.72 16 326.52 16 128a48 48 0 0 1 29.6-44.32l192-80A48.29 48.29 0 0 1 256 0z"]],
    "shield-check": [512, 512, [], "f2f7", ["M466.5 83.67l-192-80a48.15 48.15 0 0 0-36.9 0l-192 80A48 48 0 0 0 16 128c0 198.5 114.5 335.69 221.5 380.29a48.15 48.15 0 0 0 36.9 0C360.1 472.58 496 349.27 496 128a48 48 0 0 0-29.5-44.33zm-47.2 114.21l-184 184a16.06 16.06 0 0 1-22.6 0l-104-104a16.07 16.07 0 0 1 0-22.61l22.6-22.6a16.07 16.07 0 0 1 22.6 0l70.1 70.1 150.1-150.1a16.07 16.07 0 0 1 22.6 0l22.6 22.6a15.89 15.89 0 0 1 0 22.61z", "M419.3 197.88l-184 184a16.06 16.06 0 0 1-22.6 0l-104-104a16.07 16.07 0 0 1 0-22.61l22.6-22.6a16.07 16.07 0 0 1 22.6 0l70.1 70.1 150.1-150.1a16.07 16.07 0 0 1 22.6 0l22.6 22.6a15.89 15.89 0 0 1 0 22.61z"]],
    "shield-cross": [448, 512, [], "f712", ["M192 501.06V224H8.76C34.6 361.89 113.71 459.21 192 501.06zM0 128c0 10.86.34 21.52 1 32h191V10.28L27.57 83.69C10.88 91.14 0 108.62 0 128zm420.43-44.31L256 10.28V160h191.08q.9-15.65.92-32c0-19.38-10.88-36.86-27.57-44.31zM256 501c66.65-36.25 155.84-126.92 183.48-277H256z", "M447.08 160a517.11 517.11 0 0 1-7.6 64H256v277c-5.06 2.75-10 5.2-14.77 7.33a42.07 42.07 0 0 1-34.46 0c-4.91-2.19-9.84-4.62-14.77-7.25V224H8.76A509.43 509.43 0 0 1 1 160h191V10.28l14.77-6.59a42.07 42.07 0 0 1 34.46 0L256 10.28V160z"]],
    "ship": [640, 512, [], "f21a", ["M594.3,447.89c-21.53-2.4-42.13-10.51-57.93-22.92a38.77,38.77,0,0,0-48.22,0c-37.91,30.43-107.24,30.43-145.75-1.5-13.5-11.21-33-9.11-46.71,1.8-38,30.13-106.93,30-145.25-1.7-13.5-11.21-33.31-8.91-47.12,2-15.5,12.21-36,20.12-57.72,22.42-7.9.8-13.6,7.81-13.6,15.72v32.23c0,9.11,7.6,16.81,16.7,16,28.81-2.5,56.12-11.41,79.44-25.92,56.52,34.63,137,34.13,192,0,56.51,34.63,137,34.13,192,0a184.89,184.89,0,0,0,79.14,25.82c9.1.8,16.7-6.9,16.7-16V464.21c.16-8-5.64-15.42-13.74-16.32ZM192,128H448v87.53l64,20.58V96a32,32,0,0,0-32-32H416V24A24,24,0,0,0,392,0H248a24,24,0,0,0-24,24V64H160a32,32,0,0,0-32,32V236.11l64-20.58Z", "M574.56,289.82a32.13,32.13,0,0,1-7.84,12.83l-92.5,89.25A83.19,83.19,0,0,1,417,415.61h-.5c-21.23,0-40.79-6.12-53.64-16.77A64.17,64.17,0,0,0,321.29,384a73.55,73.55,0,0,0-45.5,16.19c-12.38,9.8-31.12,15.42-51.44,15.42h-.51a85,85,0,0,1-58.48-24.22l-92-88.74a32,32,0,0,1,12.85-53.09l224-72a31.94,31.94,0,0,1,19.58,0l224,72a32,32,0,0,1,20.7,40.25h0Z"]],
    "shipping-fast": [640, 512, [], "f48b", ["M248 160H40a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h208a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zm-24 88v-16a8 8 0 0 0-8-8H8a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h208a8 8 0 0 0 8-8zm-48 104a80 80 0 1 0 80 80 80 80 0 0 0-80-80zm288 0a80 80 0 1 0 80 80 80 80 0 0 0-80-80zM280 96H8a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h272a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8z", "M624 352h-16V243.9a48 48 0 0 0-14.1-33.9L494 110.1A48 48 0 0 0 460.1 96H416V48a48 48 0 0 0-48-48H112a48 48 0 0 0-48 48v48h216a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8H64v32h184a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8H64v32h152a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8H64v112a47.74 47.74 0 0 0 7 25 112 112 0 0 1 215.86 23h66.28a112 112 0 0 1 221.72 0H624a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-64-96H416V144h44.1l99.9 99.9z"]],
    "shipping-timed": [640, 512, [], "f48c", ["M464 352a80 80 0 1 0 80 80 80 80 0 0 0-80-80zm-288 0a80 80 0 1 0 80 80 80 80 0 0 0-80-80zm72-208h-24V88a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v80a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8z", "M624 352h-16V243.9a48 48 0 0 0-14.1-33.9L494 110.1A48 48 0 0 0 460.1 96H416V48a48 48 0 0 0-48-48H48A48 48 0 0 0 0 48v320a48 48 0 0 0 48 48h18.16C74 361.93 119.78 320 176 320s102.54 41.86 110.38 96h67.24c7.85-54.14 54.1-96 110.38-96s102 41.93 109.84 96H624a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-416-80a112 112 0 1 1 112-112 111.94 111.94 0 0 1-112 112zm352-16H416V144h44.1l99.9 99.9z"]],
    "shish-kebab": [512, 512, [], "f821", ["M511.21 84.07c-3.78-29.71-21.06-55.68-47.42-71.21a95.15 95.15 0 0 0-97.93 1.43C323.2 41 307.71 94 330 138.88c1.44 2.93 2.28 7.16 0 9.49l-24.47 24.45 33.93 33.93 24.48-24.46c16.72-16.73 20.28-42.14 9.09-64.72-9.62-19.43-6-48.25 19.61-63.36a45.55 45.55 0 0 1 45.92-.53c14.22 8 23.15 21 25.13 36.45a47.82 47.82 0 0 1-6 30.09c-3.71 6.39-3.31 14.32 1.91 19.55l12.29 12.29c6.72 6.72 18.17 6.09 23.54-1.75a95.27 95.27 0 0 0 15.78-66.24zM4.55 473.52a15.5 15.5 0 0 0 0 21.91l12 12a15.49 15.49 0 0 0 21.91 0l61.78-61.73-33.92-33.91z", "M126.55 255.59a30.61 30.61 0 0 0-43.28 0L41 297.89a30.59 30.59 0 0 0 0 43.27L170.82 471a30.61 30.61 0 0 0 43.28 0l42.3-42.3a30.61 30.61 0 0 0 0-43.28zm238.05 21.65L234.77 147.38a30.62 30.62 0 0 0-43.29 0l-42.3 42.3a30.62 30.62 0 0 0 0 43.28L279 362.82a30.61 30.61 0 0 0 43.28 0l42.3-42.3a30.61 30.61 0 0 0 .02-43.28z"]],
    "shoe-prints": [640, 512, [], "f54b", ["M0 416a64 64 0 0 0 64 64h32V352H64a64 64 0 0 0-64 64zm337.46-128c-34.91 0-76.16 13.12-104.73 32-24.79 16.38-44.52 32-104.73 32v128l57.53 16c26.21 7.28 53 13.12 80.31 15 32.69 2.31 65.6.67 97.58-6.2C472.9 481.3 512 429.22 512 384c0-64-84.18-96-174.54-96z", "M128 96a64 64 0 0 0 64 64h32V32h-32a64 64 0 0 0-64 64zM491.42 7.19c-32-6.87-64.89-8.52-97.58-6.2-27.3 1.93-54.1 7.77-80.31 15L256 32v128c60.2 0 79.94 15.62 104.73 32 28.57 18.88 69.82 32 104.73 32C555.82 224 640 192 640 128c0-45.22-39.1-97.3-148.58-120.81z"]],
    "shopping-bag": [448, 512, [], "f290", ["M.06 160v-.13l96 .06v-32C96.12 57.35 153.57 0 224.15 0s128 57.49 127.92 128.07V160h-64v-32a64 64 0 0 0-128-.08v32h64z", "M.06 159.87l-.16 272a80 80 0 0 0 79.95 80.05l288 .16a80 80 0 0 0 80-80l.16-272zM128 247.94a24 24 0 1 1 24-24 24 24 0 0 1-24 24zm192 .12a24 24 0 1 1 24-24 24 24 0 0 1-24 24z"]],
    "shopping-basket": [576, 512, [], "f291", ["M242.82 38.12a32 32 0 0 0-44.7 7.06L91.34 192h79.14l79.4-109.18a32 32 0 0 0-7.06-44.7zm135.06 7.06a32 32 0 1 0-51.76 37.64L405.52 192h79.14z", "M552 192H24a24 24 0 0 0-24 24v16a24 24 0 0 0 24 24h8l26.11 182.79A48 48 0 0 0 105.63 480h364.74a48 48 0 0 0 47.52-41.21L544 256h8a24 24 0 0 0 24-24v-16a24 24 0 0 0-24-24zM200 392a24 24 0 0 1-48 0V280a24 24 0 0 1 48 0zm112 0a24 24 0 0 1-48 0V280a24 24 0 0 1 48 0zm112 0a24 24 0 0 1-48 0V280a24 24 0 0 1 48 0z"]],
    "shopping-cart": [576, 512, [], "f07a", ["M552 64H159.21l52.36 256h293.15a24 24 0 0 0 23.4-18.68l47.27-208a24 24 0 0 0-18.08-28.72A23.69 23.69 0 0 0 552 64z", "M218.12 352h268.42a24 24 0 0 1 23.4 29.32l-5.52 24.28a56 56 0 1 1-63.6 10.4H231.18a56 56 0 1 1-67.05-8.57L93.88 64H24A24 24 0 0 1 0 40V24A24 24 0 0 1 24 0h102.53A24 24 0 0 1 150 19.19z"]],
    "shovel": [512, 512, [], "f713", ["M500.28 96.39l-84.67-84.68a40 40 0 0 0-56.56 0l-32.67 32.67a98.91 98.91 0 0 0-18.77 114.77L197.35 269.4l45.26 45.23 110.25-110.24a98.88 98.88 0 0 0 114.75-18.76L500.28 153a40 40 0 0 0 0-56.57zm-77.91 44a35.89 35.89 0 0 1-50.75-50.75l15.7-15.7 50.75 50.75z", "M287.87 405.13L220 473c-50 50-181 45.3-203.66 22.65S-11 342 39 292l67.85-67.88a32 32 0 0 1 45.25 0l135.77 135.76a32 32 0 0 1 0 45.25z"]],
    "shovel-snow": [512, 512, [], "f7c3", ["M203.72 244.36a15.88 15.88 0 0 0-22.45-.13l-.12.13-79.9 79.9a16 16 0 0 0 21.46 23.68 14.53 14.53 0 0 0 1.11-1.11l79.9-79.9a16 16 0 0 0 0-22.57zm41.34 63.92l-79.89 79.9a16 16 0 0 0 21.46 23.68c.38-.35.76-.72 1.11-1.11l79.89-79.9a16 16 0 1 0-22.57-22.57zm258.17-236.1L439.81 8.76a30 30 0 0 0-42.34 0L373 33.23a74.58 74.58 0 0 0-20.38 67.65 77.16 77.16 0 0 0 6.4 18.37l-99.18 99.16 33.86 33.87 99.17-99.18a76.19 76.19 0 0 0 18.38 6.39A74.41 74.41 0 0 0 478.76 139l24.47-24.47a30 30 0 0 0 0-42.35zm-58.29 33a26.9 26.9 0 0 1-45.34-13.79 27.18 27.18 0 0 1 7.29-24.28l11.79-11.78 38.05 38.06z", "M342.66 301.9l-132.5-132.5a31.77 31.77 0 0 0-41.9-2.71L12.36 287a31.69 31.69 0 0 0-5.78 44.45 33.3 33.3 0 0 0 2.78 3.15l168 168a31.77 31.77 0 0 0 44.93 0 29.52 29.52 0 0 0 2.67-3l120.4-155.81a31.73 31.73 0 0 0-2.7-41.89zm-220 46a16 16 0 0 1-21.46-23.68l79.9-79.9.12-.13a16 16 0 0 1 22.45 22.7l-79.9 79.9a14.53 14.53 0 0 1-1.06 1.15zm144.92-17.09l-79.89 79.9c-.35.39-.73.76-1.11 1.11a16 16 0 0 1-21.46-23.68l79.89-79.9a16 16 0 1 1 22.57 22.57z"]],
    "shower": [512, 512, [], "f2cc", ["M496 192a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm-128 32a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm32 64a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm-32-32a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm32 0a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm-32 64a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm-32-64a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm-32 96a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm160-128a16 16 0 1 0 16 16 16 16 0 0 0-16-16zM304 384a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm128-128a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm-96 96a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm0-64a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm-32 0a16 16 0 1 0-16-16 16 16 0 0 0 16 16zm128-64a16 16 0 1 0-16-16 16 16 0 0 0 16 16z", "M389.66 101.66a24 24 0 0 1 0 33.94L231.6 293.66a24 24 0 0 1-33.94 0l-11.32-11.32a24 24 0 0 1 0-33.94l.11-.11a112.21 112.21 0 0 1-3.39-140.38A77.72 77.72 0 0 0 64 173.76V480H0V173.76C0 95.59 63.59 32 141.76 32a141.22 141.22 0 0 1 95.86 37.42 112.23 112.23 0 0 1 106.67 21l.11-.11a24 24 0 0 1 33.94 0z"]],
    "shredder": [512, 512, [], "f68a", ["M448 96v128H64V32A32 32 0 0 1 96 0h256v80a16 16 0 0 0 16 16zM232 416h48v80a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16zm-96 0h48v80a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16zm-96 0h48v80a16 16 0 0 1-16 16H56a16 16 0 0 1-16-16zm288 0h48v80a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16zm96 0h48v80a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16z", "M368 96h80v-4.58a17.92 17.92 0 0 0-5.25-12.67l-73.43-73.5A18 18 0 0 0 356.57 0H352v80a16 16 0 0 0 16 16zm80 96v32H64v-32a64 64 0 0 0-64 64v112a16 16 0 0 0 16 16h480a16 16 0 0 0 16-16V256a64 64 0 0 0-64-64zm-16 136a24 24 0 1 1 24-24 24 24 0 0 1-24 24z"]],
    "shuttle-van": [640, 512, [], "f5b6", ["M160 320a80 80 0 1 0 80 80 80 80 0 0 0-80-80zm320 0a80 80 0 1 0 80 80 80 80 0 0 0-80-80z", "M628.88 210.65L494.39 49.27A48 48 0 0 0 457.52 32H32A32 32 0 0 0 0 64v288a32 32 0 0 0 32 32h17.14a112 112 0 0 1 221.72 0h98.28a112 112 0 0 1 221.72 0H608a32 32 0 0 0 32-32V241.38a48.05 48.05 0 0 0-11.12-30.73zM160 192H64V96h96zm160 0h-96V96h96zm64 0V96h66l80 96z"]],
    "shuttlecock": [512, 512, [], "f45b", ["M181.05 481a106.07 106.07 0 0 1-150-150l2.6-2.6 150 150z", "M512 220v54.6a28.15 28.15 0 0 1-16.2 25.4L245.45 416.5l-39.2 39.2-150-150 39.2-39.2L212 16.2A28.09 28.09 0 0 1 237.35 0H292a28.08 28.08 0 0 1 28 28v20c-12.3 0-56.6-1.3-71.1 44.7l-28.8 91.2-45.4 26.4-36.3 78 25.7 25.7 70.8-70.8 44.5-140.8A32 32 0 0 1 309.85 80H404a28 28 0 0 1 28 28v94.1a32.08 32.08 0 0 1-22.4 30.5l-140.8 44.5-70.8 70.8 25.7 25.8 78-36.3 26.4-45.4 91.2-28.8c49-15.5 44.7-65.2 44.7-71.2h20a28.08 28.08 0 0 1 28 28z"]],
    "sickle": [512, 512, [], "f822", ["M203.37 382.05a16 16 0 0 1 0 22.63l-22.62 22.62a16 16 0 0 1-22.62 0l-2.74-2.74-82.76 82.75a16 16 0 0 1-22.62 0L4.69 462.06a16 16 0 0 1 0-22.63l82.74-82.74-2.74-2.75a16 16 0 0 1 0-22.63l22.62-22.62a16 16 0 0 1 22.63 0l73.43 73.36z", "M511.82 155.39c1.65 8.41-9.06 13.38-14.14 6.48a148.08 148.08 0 0 0-47.33-41.42c-44.47-24.9-101-23.24-144 4-70.76 44.73-85.41 131.8-46.88 196L224 355.87l-31.71-30.09c-45.7-45.69-70.15-111.2-56.41-174.34C153.75 69.31 224 0 320 0c128 0 181.17 100.72 191.82 155.39z"]],
    "sigma": [384, 512, [], "f68b", ["M360 352h-48a24 24 0 0 0-24 23.44V480h64a32 32 0 0 0 32-32v-72a24 24 0 0 0-24-24zm-8-320h-64v104.56A24 24 0 0 0 312 160h48a24 24 0 0 0 24-24V64a32 32 0 0 0-32-32z", "M288 136v-8H142.24l109.09 128-109.09 128H288v-8.56V480H52a52 52 0 0 1-42-82.64L132.65 256 10 114.6A52 52 0 0 1 52 32h236v104z"]],
    "sign": [512, 512, [], "f4d9", ["M0 80a16 16 0 0 1 16-16h48V16A16 16 0 0 1 80 0h32a16 16 0 0 1 16 16v48h368a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16H128v368a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16V128H16a16 16 0 0 1-16-16z", "M160 384V160h320v224z"]],
    "sign-in": [512, 512, [], "f090", ["M512 160v192a96 96 0 0 1-96 96h-84a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h84a32 32 0 0 0 32-32V160a32 32 0 0 0-32-32h-84a12 12 0 0 1-12-12V76a12 12 0 0 1 12-12h84a96 96 0 0 1 96 96z", "M215.6 295.9H24a23.94 23.94 0 0 1-24-24v-32a23.94 23.94 0 0 1 24-24h191.5l-77.6-71.1a23.84 23.84 0 0 1-.7-34.5l21.9-21.9a24.08 24.08 0 0 1 33.9-.1L344.9 239a24 24 0 0 1 0 34.1L193 423.7a24 24 0 0 1-33.9-.1l-21.9-21.9a24 24 0 0 1 .8-34.7z"]],
    "sign-in-alt": [512, 512, [], "f2f6", ["M512 160v192a96 96 0 0 1-96 96h-84a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h84a32 32 0 0 0 32-32V160a32 32 0 0 0-32-32h-84a12 12 0 0 1-12-12V76a12 12 0 0 1 12-12h84a96 96 0 0 1 96 96z", "M369 273L201 441c-15 15-41 4.5-41-17v-96H24a23.94 23.94 0 0 1-24-24v-96a23.94 23.94 0 0 1 24-24h136V88c0-21.5 26-32 41-17l168 168a24.2 24.2 0 0 1 0 34z"]],
    "sign-language": [448, 512, [], "f2a7", ["M448 256.2l-5-152.45a28.57 28.57 0 1 0-57.11 1.87l1.24 38.4L283.56 11a28.57 28.57 0 0 0-39.65-5.33c-12.83 9.6-14.93 28.24-5.08 40.88l76.88 98.75-4.5 3.51-94.79-121.7a28.57 28.57 0 0 0-39.66-5.32c-12.82 9.6-14.93 28.24-5.08 40.88L266.12 184l-4.51 3.51-77.67-99.8a28.6 28.6 0 0 0-39.66-5.33c-12.82 9.6-14.93 28.24-5.08 40.89l57.56 72.83a28.58 28.58 0 0 1 31.47 1.42l123.36 89.71A34.29 34.29 0 0 1 365.71 315v23l69.07-53.62A34.31 34.31 0 0 0 448 256.2zm-259.68-52.38a28 28 0 0 1 3.63-4.1l-18.2-22.79c-9.84-12.64-28.43-15.17-40.88-5.08a28.56 28.56 0 0 0-4.55 39.75l42.76 54.74h54.63l-31.09-22.61a28.55 28.55 0 0 1-6.3-39.91z", "M365.71 315v141.07a34.28 34.28 0 0 1-26.43 33.37l-80.47 18.93A136.78 136.78 0 0 1 227.4 512H120a28.57 28.57 0 0 1-28.57-28c-.31-16 13.11-29.13 29.13-29.13h62.3v-5.72H57C41 449.16 27.56 436 27.86 420a28.57 28.57 0 0 1 28.57-28h126.43v-5.71H29.14c-16 0-29.44-13.12-29.13-29.13a28.56 28.56 0 0 1 28.56-28h154.29v-5.71H57.71c-16 0-29.44-13.11-29.13-29.13a28.56 28.56 0 0 1 28.56-28h168.57l-31.09-22.61a28.57 28.57 0 1 1 33.61-46.21l123.36 89.71A34.29 34.29 0 0 1 365.71 315z"]],
    "sign-out": [512, 512, [], "f08b", ["M180 448H96a96 96 0 0 1-96-96V160a96 96 0 0 1 96-96h84a12 12 0 0 1 12 12v40a12 12 0 0 1-12 12H96a32 32 0 0 0-32 32v192a32 32 0 0 0 32 32h84a12 12 0 0 1 12 12v40a12 12 0 0 1-12 12z", "M353 88.3l151.9 150.6a24 24 0 0 1 0 34.1l-152 150.8a24.08 24.08 0 0 1-33.9-.1l-21.9-21.9a24.07 24.07 0 0 1 .8-34.7l77.6-71.1H184a23.94 23.94 0 0 1-24-24v-32a23.94 23.94 0 0 1 24-24h191.5l-77.6-71.1a24 24 0 0 1-.7-34.6l21.9-21.9a24 24 0 0 1 33.9-.1z"]],
    "sign-out-alt": [512, 512, [], "f2f5", ["M64 160v192a32 32 0 0 0 32 32h84a12 12 0 0 1 12 12v40a12 12 0 0 1-12 12H96a96 96 0 0 1-96-96V160a96 96 0 0 1 96-96h84a12 12 0 0 1 12 12v40a12 12 0 0 1-12 12H96a32 32 0 0 0-32 32z", "M288 424v-96H152a23.94 23.94 0 0 1-24-24v-96a23.94 23.94 0 0 1 24-24h136V88c0-21.4 25.9-32 41-17l168 168a24.2 24.2 0 0 1 0 34L329 441c-15 15-41 4.52-41-17z"]],
    "signal": [640, 512, [], "f012", ["", "M216 288h-48a16 16 0 0 0-16 16v192a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V304a16 16 0 0 0-16-16zM88 384H40a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16v-96a16 16 0 0 0-16-16zm256-192h-48a16 16 0 0 0-16 16v288a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V208a16 16 0 0 0-16-16zM600 0h-48a16 16 0 0 0-16 16v480a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16zM472 96h-48a16 16 0 0 0-16 16v384a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V112a16 16 0 0 0-16-16z"]],
    "signal-1": [640, 512, [], "f68c", ["M216 288h-48a16 16 0 0 0-16 16v192a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V304a16 16 0 0 0-16-16zm128-96h-48a16 16 0 0 0-16 16v288a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V208a16 16 0 0 0-16-16zM600 0h-48a16 16 0 0 0-16 16v480a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16zM472 96h-48a16 16 0 0 0-16 16v384a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V112a16 16 0 0 0-16-16z", "M104 400v96a16 16 0 0 1-16 16H40a16 16 0 0 1-16-16v-96a16 16 0 0 1 16-16h48a16 16 0 0 1 16 16z"]],
    "signal-2": [640, 512, [], "f68d", ["M344 192h-48a16 16 0 0 0-16 16v288a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V208a16 16 0 0 0-16-16zm128-96h-48a16 16 0 0 0-16 16v384a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V112a16 16 0 0 0-16-16zM600 0h-48a16 16 0 0 0-16 16v480a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16z", "M88 384H40a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16v-96a16 16 0 0 0-16-16zm128-96h-48a16 16 0 0 0-16 16v192a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V304a16 16 0 0 0-16-16z"]],
    "signal-3": [640, 512, [], "f68e", ["M472 96h-48a16 16 0 0 0-16 16v384a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V112a16 16 0 0 0-16-16zM600 0h-48a16 16 0 0 0-16 16v480a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16z", "M88 384H40a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16v-96a16 16 0 0 0-16-16zm256-192h-48a16 16 0 0 0-16 16v288a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V208a16 16 0 0 0-16-16zm-128 96h-48a16 16 0 0 0-16 16v192a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V304a16 16 0 0 0-16-16z"]],
    "signal-4": [640, 512, [], "f68f", ["M616 16v480a16 16 0 0 1-16 16h-48a16 16 0 0 1-16-16V16a16 16 0 0 1 16-16h48a16 16 0 0 1 16 16z", "M216 288h-48a16 16 0 0 0-16 16v192a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V304a16 16 0 0 0-16-16zM88 384H40a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16v-96a16 16 0 0 0-16-16zm256-192h-48a16 16 0 0 0-16 16v288a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V208a16 16 0 0 0-16-16zm128-96h-48a16 16 0 0 0-16 16v384a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V112a16 16 0 0 0-16-16z"]],
    "signal-alt": [640, 512, [], "f690", ["", "M96 384H64a32 32 0 0 0-32 32v64a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32v-64a32 32 0 0 0-32-32zm160-128h-32a32 32 0 0 0-32 32v192a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32V288a32 32 0 0 0-32-32zm160-128h-32a32 32 0 0 0-32 32v320a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32V160a32 32 0 0 0-32-32zM576 0h-32a32 32 0 0 0-32 32v448a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32V32a32 32 0 0 0-32-32z"]],
    "signal-alt-1": [640, 512, [], "f691", ["M576 0h-32a32 32 0 0 0-32 32v448a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32V32a32 32 0 0 0-32-32zM416 128h-32a32 32 0 0 0-32 32v320a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32V160a32 32 0 0 0-32-32zM256 256h-32a32 32 0 0 0-32 32v192a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32V288a32 32 0 0 0-32-32z", "M128 416v64a32 32 0 0 1-32 32H64a32 32 0 0 1-32-32v-64a32 32 0 0 1 32-32h32a32 32 0 0 1 32 32z"]],
    "signal-alt-2": [640, 512, [], "f692", ["M576 0h-32a32 32 0 0 0-32 32v448a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32V32a32 32 0 0 0-32-32zM416 128h-32a32 32 0 0 0-32 32v320a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32V160a32 32 0 0 0-32-32z", "M96 384H64a32 32 0 0 0-32 32v64a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32v-64a32 32 0 0 0-32-32zm160-128h-32a32 32 0 0 0-32 32v192a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32V288a32 32 0 0 0-32-32z"]],
    "signal-alt-3": [640, 512, [], "f693", ["M608 32v448a32 32 0 0 1-32 32h-32a32 32 0 0 1-32-32V32a32 32 0 0 1 32-32h32a32 32 0 0 1 32 32z", "M96 384H64a32 32 0 0 0-32 32v64a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32v-64a32 32 0 0 0-32-32zm160-128h-32a32 32 0 0 0-32 32v192a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32V288a32 32 0 0 0-32-32zm160-128h-32a32 32 0 0 0-32 32v320a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32V160a32 32 0 0 0-32-32z"]],
    "signal-alt-slash": [640, 512, [], "f694", ["M512 364V32a32 32 0 0 1 32-32h32a32 32 0 0 1 32 32v406.14zm-64-49.47V160a32 32 0 0 0-32-32h-32a32 32 0 0 0-32 32v80.28zM96 384H64a32 32 0 0 0-32 32v64a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32v-64a32 32 0 0 0-32-32zm96-96v192a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32V352.6l-94.33-72.9c-.74 2.71-1.67 5.36-1.67 8.3zm160 192a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32v-3.73l-96-74.2z", "M636.64 480.55L617 505.82a16 16 0 0 1-22.46 2.81L6.18 53.9a16 16 0 0 1-2.81-22.45L23 6.18a16 16 0 0 1 22.47-2.81L633.82 458.1a16 16 0 0 1 2.82 22.45z"]],
    "signal-slash": [640, 512, [], "f695", ["M290.71 192.91A16 16 0 0 1 296 192h48a16 16 0 0 1 16 16v38.47zM88 384H40a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16v-96a16 16 0 0 0-16-16zm400-38.6V112a16 16 0 0 0-16-16h-48a16 16 0 0 0-16 16v171.57zm128 98.93V16a16 16 0 0 0-16-16h-48a16 16 0 0 0-16 16v366.5zM408 496a16 16 0 0 0 16 16h48a15.72 15.72 0 0 0 13-7.15l-77-59.5zm-128 0a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16v-87.75l-80-61.83zM168 288a16 16 0 0 0-16 16v192a16 16 0 0 0 16 16h48a16 16 0 0 0 16-16V309.32L204.41 288z", "M636.63 480.54L617 505.81a15.77 15.77 0 0 1-14.93 5.77 14.47 14.47 0 0 1-2.07.42h-2.56a15.42 15.42 0 0 0-2.9-3.37L6.18 53.9a16 16 0 0 1-2.81-22.45L23 6.18a16 16 0 0 1 22.47-2.81L633.82 458.1a16 16 0 0 1 2.81 22.44z"]],
    "signal-stream": [576, 512, [], "f8dd", ["M198.27 168.37l-22.76-22.23a16.44 16.44 0 0 0-24 1.31 168.77 168.77 0 0 0 0 217.1 16.44 16.44 0 0 0 24 1.31l22.76-22.22a15.12 15.12 0 0 0 1.45-20.32 107.39 107.39 0 0 1 0-134.64 15.11 15.11 0 0 0-1.45-20.31zm226.19-20.92a16.44 16.44 0 0 0-24-1.31l-22.76 22.23a15.12 15.12 0 0 0-1.45 20.31 107.39 107.39 0 0 1 0 134.64 15.14 15.14 0 0 0 1.45 20.32l22.76 22.22a16.44 16.44 0 0 0 24-1.31 168.77 168.77 0 0 0 0-217.1z", "M288 200a56 56 0 1 0 56 56 56 56 0 0 0-56-56zM64 256a214.3 214.3 0 0 1 55.42-144.06c5.59-6.22 4.91-15.74-1.08-21.59L96 68.53a16.41 16.41 0 0 0-23.56 1C25.59 121 0 186.56 0 256s25.59 135 72.44 186.52a16.41 16.41 0 0 0 23.56 1l22.34-21.82c6-5.85 6.67-15.37 1.08-21.59A214.3 214.3 0 0 1 64 256zM503.56 69.48a16.41 16.41 0 0 0-23.56-1l-22.34 21.87c-6 5.85-6.67 15.37-1.08 21.59a214.95 214.95 0 0 1 0 288.12c-5.59 6.22-4.91 15.74 1.08 21.59L480 443.47a16.41 16.41 0 0 0 23.56-1C550.41 391 576 325.44 576 256s-25.59-135-72.44-186.52z"]],
    "signature": [640, 512, [], "f5b7", ["M639.77 208.21v32.1c0 8.5-6.7 15.1-15.2 15.8-39.4 3.2-105.4 51-138.4 65.8-34.3 15.4-66.7 30-102.3 30-28.2 0-50.2-8.5-65.5-25.3-22.7-24.9-22.8-55.3-20.6-83.8-56.5 45.1-169 153.6-211.2 195.8A31.63 31.63 0 0 1 64 448c-27 0-36.5-27-29.7-43.9l98.2-245.6c8-19.9-14.3-38.8-32.7-27.1l-58 38.9a15.91 15.91 0 0 1-22.1-4.9l-17.2-27a16.08 16.08 0 0 1 4.9-22.1l54.9-36.9c76.5-48.7 160.1 26.9 129.7 102.8l-41.5 103.7c105.2-101.2 144.4-124.5 169.5-126 54.4-3.1 43.8 68.1 42.7 76.1-4.7 35.7-1.3 51.9 21.3 51.9 21.9 0 47-11.3 76.1-24.4 37.4-16.8 111.3-68 163.1-71.5 9.07-.59 16.8 7.11 16.57 16.21z", ""]],
    "sim-card": [384, 512, [], "f7c4", ["M128 192H96a32 32 0 0 0-32 32v32h64zM64 416a32 32 0 0 0 32 32h32v-64H64zm160-224h-64v64h64zm32 256h32a32 32 0 0 0 32-32v-32h-64zm-96 0h64v-64h-64zm128-256h-32v64h64v-32a32 32 0 0 0-32-32zM64 352h256v-64H64z", "M256 0H64A64.06 64.06 0 0 0 0 64v384a64.06 64.06 0 0 0 64 64h256a64.06 64.06 0 0 0 64-64V128zm64 416a32 32 0 0 1-32 32H96a32 32 0 0 1-32-32V224a32 32 0 0 1 32-32h192a32 32 0 0 1 32 32z"]],
    "sitemap": [640, 512, [], "f0e8", ["M104 320H56v-57.59A38.45 38.45 0 0 1 94.41 224H296v-64h48v64h201.59A38.46 38.46 0 0 1 584 262.41V320h-48v-48H344v48h-48v-48H104z", "M128 352H32a32 32 0 0 0-32 32v96a32 32 0 0 0 32 32h96a32 32 0 0 0 32-32v-96a32 32 0 0 0-32-32zM384 0H256a32 32 0 0 0-32 32v96a32 32 0 0 0 32 32h128a32 32 0 0 0 32-32V32a32 32 0 0 0-32-32zm224 352h-96a32 32 0 0 0-32 32v96a32 32 0 0 0 32 32h96a32 32 0 0 0 32-32v-96a32 32 0 0 0-32-32zm-240 0h-96a32 32 0 0 0-32 32v96a32 32 0 0 0 32 32h96a32 32 0 0 0 32-32v-96a32 32 0 0 0-32-32z"]],
    "skating": [448, 512, [], "f7c5", ["M400 448a16 16 0 0 0-16 16 16 16 0 0 1-16 16h-96a16 16 0 0 0 0 32h96a48 48 0 0 0 48-48 16 16 0 0 0-16-16zm-282.2 8.6a16 16 0 0 1-22.6 0l-67.9-67.9a16 16 0 1 0-22.6 22.6l67.9 67.9a48.16 48.16 0 0 0 67.9 0 16 16 0 1 0-22.7-22.6zM400 0a48 48 0 1 0 48 48 48 48 0 0 0-48-48z", "M360.85 164.3a40 40 0 0 0-28.3-68.3H128a32 32 0 1 0 0 64h105.5l-20.1 17.2a63.94 63.94 0 0 0-3.6 93.8l78.2 78.2V432a32 32 0 0 0 64 0v-89.4a48 48 0 0 0-14.1-33.9l-61-61a16.29 16.29 0 0 0 1.7-1.1zm-187 112.5l-93.7 93.7a32 32 0 0 0 22.6 54.6 31.55 31.55 0 0 0 22.6-9.4l91.9-91.9-30.2-30.2a94 94 0 0 1-13.2-16.8z"]],
    "skeleton": [512, 512, [], "f620", ["M224 224H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h208zM80 128h144V64H80a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm208 0h144a16 16 0 0 0 16-16V80a16 16 0 0 0-16-16H288zm160 176v-32a16 16 0 0 0-16-16H288v64h144a16 16 0 0 0 16-16zm32 128a80 80 0 1 1-158.39-16H190.39A80 80 0 1 1 112 352h288a80 80 0 0 1 80 80zm-336 0a32 32 0 1 0-32 32 32 32 0 0 0 32-32zm288 0a32 32 0 1 0-32 32 32 32 0 0 0 32-32zM64 272v32a16 16 0 0 0 16 16h144v-64H80a16 16 0 0 0-16 16zm432-112H288v64h208a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M224 16a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v336h-64z"]],
    "ski-jump": [512, 512, [], "f7c7", ["M400 96a48 48 0 1 0-48-48 48 48 0 0 0 48 48zm110.7 94.2a24 24 0 0 0-47.4 8c3.3 19.3-6 38.9-22.1 48.1L13 466.7A24 24 0 0 0 24.1 512a24.14 24.14 0 0 0 11-2.7l429.2-220.9a95.42 95.42 0 0 0 46.4-98.2z", "M113.7 414.8a31.85 31.85 0 0 1-7.3-35c60.4-146.9 56.8-138.9 60.2-143.3l58.9-76.5H128a32 32 0 0 1 0-64h184a40 40 0 0 1 28.3 68.3L218.9 274.8l-44.9 109z"]],
    "ski-lift": [512, 512, [], "f7c8", ["M488 288a24.07 24.07 0 0 0-24 24 33.54 33.54 0 0 1-21.8 31.3L111.65 465.5a24 24 0 1 0 16.6 45l330.5-122.1A81.87 81.87 0 0 0 512 312a24 24 0 0 0-24-24zM112 128a48 48 0 1 0-48-48 48 48 0 0 0 48 48zm79.6 253.4a24 24 0 1 0-15.2-45.6L158 342a40 40 0 0 1-48.7-20.7l-63.6-133A24 24 0 1 0 2.35 209L66 342a88.31 88.31 0 0 0 79.5 50c12.55 0 16.95-.9 46.05-10.6zM256 0h-32v184l32-8z", "M307.65 222.8a31.61 31.61 0 0 0-27.5-5.8l-68.3 17-24.1-53.7a48 48 0 1 0-87.6 39.4L128 287.8c7.9 19.1 22.7 27.6 39.8 23.3L256 289v123.2l64-23.7V248a31.69 31.69 0 0 0-12.35-25.2z"]],
    "skiing": [512, 512, [], "f7c9", ["M432 96a48 48 0 1 0-48-48 48 48 0 0 0 48 48zm73 356.1a23.9 23.9 0 0 0-33.9 0c-12.1 12.1-30.5 15.4-45.1 8.7L35 258.7a24 24 0 1 0-22 42.6l391.9 202.5a88.06 88.06 0 0 0 37.1 8.1 89 89 0 0 0 63-26 24 24 0 0 0 0-33.8zM120 91.6l-11.5 22.5a39.15 39.15 0 0 0 42.8-4.8l216.28 109.75a47.52 47.52 0 0 1-16-22.65l-10.76-29-175.92-87A38.77 38.77 0 0 0 144 44.8l-11.1 21.7h-.2l-34.4-7a5.11 5.11 0 0 0-5 1.7 5.23 5.23 0 0 0 .5 7.4z", "M293 215.7l-107-53.1a63.8 63.8 0 0 0 17.7 54.4l75.1 75.2-45.9 68.8 57.3 29.6 49.2-73.8a48 48 0 0 0-6-60.6zm169.3-20.3l-52.1-26.1-17.1-51.2c-8.1-24.2-40.9-56.6-84.5-39.2l-81.43 32.28 113.67 56.18 10.76 29a47.6 47.6 0 0 0 24 27.7l58.1 29a32.2 32.2 0 0 0 28.6-57.7z"]],
    "skiing-nordic": [576, 512, [], "f7ca", ["M336 96a48 48 0 1 0-48-48 48 48 0 0 0 48 48zm216 320a24 24 0 0 0-24 24 24.07 24.07 0 0 1-24 24h-69.5L460 285.67a31.85 31.85 0 0 1-12 2.33h-20.7l-25.2 176H99.5l52.21-260.94a32 32 0 0 1-30.88-9L66.9 464H24a24 24 0 0 0 0 48h480a72.08 72.08 0 0 0 72-72 24.07 24.07 0 0 0-24-24z", "M186.2 332.2L123.7 464h70.9l43.1-91-22-13a95.84 95.84 0 0 1-29.5-27.8zM448 224h-43.9L378 170.8c-12.5-25.5-35.5-44.2-61.8-50.9L245 98.7a95.74 95.74 0 0 0-80.8 17.1l-39.7 30.4a32.17 32.17 0 1 0 42.21 48.35l36.49-28c7.7-5.9 17.4-8 25.3-6.1l14.7 4.4-37.5 87.4A64.18 64.18 0 0 0 232 332.6l85 50.2-25.5 81.2h67l23.6-75.5a48.25 48.25 0 0 0-21.6-54.4L299.3 298l31.3-78.3 20.3 41.4A48.35 48.35 0 0 0 394 288h54a32 32 0 0 0 32-32 32 32 0 0 0-32-32z"]],
    "skull": [512, 512, [], "f54c", ["M256 0C114.6 0 0 100.3 0 224c0 70.1 36.9 132.6 94.5 173.7 9.6 6.9 15.2 18.1 13.5 29.9l-9.4 66.2a15.87 15.87 0 0 0 13.37 18 16.49 16.49 0 0 0 2.33.17H192V456a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v56h64v-56a8 8 0 0 1 8-8h16a8 8 0 0 1 8 8v56h77.7a15.87 15.87 0 0 0 15.87-15.87 16.49 16.49 0 0 0-.17-2.33l-9.4-66.2c-1.7-11.7 3.8-23 13.5-29.9C475.1 356.6 512 294.1 512 224 512 100.3 397.4 0 256 0zm-96 320a64 64 0 1 1 64-64 64 64 0 0 1-64 64zm192 0a64 64 0 1 1 64-64 64 64 0 0 1-64 64z", "M160 192a64 64 0 1 0 64 64 64 64 0 0 0-64-64zm192 0a64 64 0 1 0 64 64 64 64 0 0 0-64-64z"]],
    "skull-cow": [640, 512, [], "f8de", ["M60.07,113.24C43.35,89.15,56.88,37.69,63,21.58a16,16,0,0,0-26.21-17C13.05,27.82,0,60.17,0,95.67,0,166.12,57.43,224,128,224h32V160a63.33,63.33,0,0,1,8.88-32H96C78.61,128,66.87,123,60.07,113.24ZM603.26,4.57a16,16,0,0,0-26.21,17c6.07,16.11,19.6,67.57,2.88,91.66C573.13,123,561.39,128,544,128H471.12A63.32,63.32,0,0,1,480,160v64h32c70.59,0,128-57.88,128-128.33C640,60.17,627,27.82,603.26,4.57Z", "M416,96H224a64,64,0,0,0-64,64V288a64,64,0,0,0,64,64L250.8,486.27A32,32,0,0,0,282.19,512h75.53a32,32,0,0,0,31.38-25.72L416,352a64,64,0,0,0,64-64V160A64,64,0,0,0,416,96ZM240,288a32,32,0,1,1,32-32A32,32,0,0,1,240,288Zm160,0a32,32,0,1,1,32-32A32,32,0,0,1,400,288Z"]],
    "skull-crossbones": [448, 512, [], "f714", ["M368 128C368 57.31 303.51 0 224 0S80 57.31 80 128c0 46.53 28.21 86.87 70 109.28l-5.48 25.87C141.84 275.77 149.93 288 161 288h126c11 0 19.12-12.22 16.45-24.84L298 237.28c41.76-22.41 70-62.75 70-109.28zm-200 48a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm112 0a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M280 176a32 32 0 1 0-32-32 32 32 0 0 0 32 32zm159.15 277.05l-142-69.05 142-69.06a16 16 0 0 0 7.15-21.46L432 264.85a16 16 0 0 0-21.46-7.15L224 348.4 37.47 257.69A16 16 0 0 0 16 264.85L1.69 293.47a16 16 0 0 0 7.16 21.46l142 69.06-142 69.06a16 16 0 0 0-7.15 21.47L16 503.15a16 16 0 0 0 21.47 7.13L224 419.58l186.51 90.72a16 16 0 0 0 21.49-7.15l14.33-28.63a16 16 0 0 0-7.18-21.47zM168 176a32 32 0 1 0-32-32 32 32 0 0 0 32 32z"]],
    "slash": [640, 512, [], "f715", ["M636.63 480.55L617 505.82a16 16 0 0 1-22.46 2.81L6.18 53.9a16 16 0 0 1-2.81-22.45L23 6.18a16 16 0 0 1 22.47-2.81L633.82 458.1a16 16 0 0 1 2.81 22.45z", ""]],
    "sledding": [512, 512, [], "f7cb", ["M400 128a48 48 0 1 0-48-48 48 48 0 0 0 48 48zm105 292.1a23.9 23.9 0 0 0-33.9 0c-12.1 12.1-30.5 15.4-45.1 8.7L35 226.6a24 24 0 0 0-22 42.7l391.9 202.6A88.06 88.06 0 0 0 442 480a89 89 0 0 0 63-26 24.08 24.08 0 0 0 0-33.9z", "M384.1 288v96c0 7.5-3 14-7.2 19.4L320 374v-54H215.47l-54.77-28.3a31.93 31.93 0 0 1 1.8-15.9 30.52 30.52 0 0 1 6.9-10.4l73.4-73.4H160a32 32 0 0 1 0-64h153.5a48 48 0 0 1 33.9 81.9L301.3 256h50.8a32 32 0 0 1 32 32z"]],
    "sleigh": [640, 512, [], "f7cc", ["M639.9 411.7c-2.2 39-36.9 68.3-75.9 68.3H48a16 16 0 0 1-16-16v-16a16 16 0 0 1 16-16h519.3a24.61 24.61 0 0 0 15.4-43.8l-9.3-7.4a16 16 0 0 1-2.5-22.5l10-12.5a16 16 0 0 1 22.5-2.5l9.3 7.4a72.06 72.06 0 0 1 27.2 61z", "M0 64a32 32 0 0 1 32-32h20.7A173.75 173.75 0 0 1 208 128a173.64 173.64 0 0 0 155.3 96H384a64.06 64.06 0 0 0 64-64V96h96a32 32 0 0 1 0 64v96a96 96 0 0 1-96 96v48h-64v-48H192v48h-64v-52.5C72.9 333.2 32 283.6 32 224V96A32 32 0 0 1 0 64z"]],
    "sliders-h": [512, 512, [], "f1de", ["M496 64H288v64h208a16 16 0 0 0 16-16V80a16 16 0 0 0-16-16zM16 128h176V64H16A16 16 0 0 0 0 80v32a16 16 0 0 0 16 16zm0 160h304v-64H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm480-64h-80v64h80a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0 160H160v64h336a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM0 400v32a16 16 0 0 0 16 16h48v-64H16a16 16 0 0 0-16 16z", "M272 32h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm128 160h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-96a16 16 0 0 0-16-16zM144 352h-32a16 16 0 0 0-16 16v96a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-96a16 16 0 0 0-16-16z"]],
    "sliders-h-square": [448, 512, [], "f3f0", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-16 324a12 12 0 0 1-12 12h-52v24a23.94 23.94 0 0 1-24 24h-16a23.94 23.94 0 0 1-24-24v-24H76a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h180v-24a23.94 23.94 0 0 1 24-24h16a23.94 23.94 0 0 1 24 24v24h52a12 12 0 0 1 12 12zm0-160a12 12 0 0 1-12 12H192v24a23.94 23.94 0 0 1-24 24h-16a23.94 23.94 0 0 1-24-24v-24H76a12 12 0 0 1-12-12v-40a12 12 0 0 1 12-12h52v-24a23.94 23.94 0 0 1 24-24h16a23.94 23.94 0 0 1 24 24v24h180a12 12 0 0 1 12 12z", "M168 256a23.94 23.94 0 0 0 24-24V120a23.94 23.94 0 0 0-24-24h-16a23.94 23.94 0 0 0-24 24v112a23.94 23.94 0 0 0 24 24zm112 160h16a23.94 23.94 0 0 0 24-24V280a23.94 23.94 0 0 0-24-24h-16a23.94 23.94 0 0 0-24 24v112a23.94 23.94 0 0 0 24 24z"]],
    "sliders-v": [448, 512, [], "f3f1", ["M80 0H48a16 16 0 0 0-16 16v80h64V16A16 16 0 0 0 80 0zm112 496a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-48h-64zm-160 0a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V192H32zM240 0h-32a16 16 0 0 0-16 16v336h64V16a16 16 0 0 0-16-16zm112 496a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V320h-64zM400 0h-32a16 16 0 0 0-16 16v208h64V16a16 16 0 0 0-16-16z", "M112 96H16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm320 128h-96a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM272 352h-96a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "sliders-v-square": [448, 512, [], "f3f2", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zM200 224h-24v180a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12V224H88a23.94 23.94 0 0 1-24-24v-16a23.94 23.94 0 0 1 24-24h24v-52a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12v52h24a23.94 23.94 0 0 1 24 24v16a23.94 23.94 0 0 1-24 24zm184 104a23.94 23.94 0 0 1-24 24h-24v52a12 12 0 0 1-12 12h-40a12 12 0 0 1-12-12v-52h-24a23.94 23.94 0 0 1-24-24v-16a23.94 23.94 0 0 1 24-24h24V108a12 12 0 0 1 12-12h40a12 12 0 0 1 12 12v180h24a23.94 23.94 0 0 1 24 24z", "M224 184a23.94 23.94 0 0 0-24-24H88a23.94 23.94 0 0 0-24 24v16a23.94 23.94 0 0 0 24 24h112a23.94 23.94 0 0 0 24-24zm136 104H248a23.94 23.94 0 0 0-24 24v16a23.94 23.94 0 0 0 24 24h112a23.94 23.94 0 0 0 24-24v-16a23.94 23.94 0 0 0-24-24z"]],
    "smile": [496, 512, [], "f118", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8Zm80,168a32,32,0,1,1-32,32A32,32,0,0,1,328,176Zm-160,0a32,32,0,1,1-32,32A32,32,0,0,1,168,176ZM362.8,346.2a149.38,149.38,0,0,1-229.6,0c-13.6-16.3,11-36.7,24.6-20.5a117.5,117.5,0,0,0,180.4,0C351.6,309.5,376.3,329.9,362.8,346.2Z", "M328,176a32,32,0,1,0,32,32A32,32,0,0,0,328,176Zm-160,0a32,32,0,1,0,32,32A32,32,0,0,0,168,176Z"]],
    "smile-beam": [496, 512, [], "f5b8", ["M245.47,8C108.5,9.43-1.36,121.56,0,258.53S113.56,505.36,250.53,504,497.36,390.44,496,253.47,382.44,6.64,245.47,8ZM112,223.4c3.3-42.1,32.2-71.38,56-71.38s52.7,29.28,56,71.38c.7,8.6-10.8,11.9-14.9,4.5l-9.5-17c-7.7-13.7-19.2-21.6-31.5-21.6s-23.78,7.9-31.48,21.6l-9.5,17C122.82,235.3,111.32,231.9,112,223.4ZM363.69,345a149.34,149.34,0,0,1-229.54,2.35c-13.67-16.17,10.62-36.81,24.37-20.75a117.57,117.57,0,0,0,180.39-1.84c13.41-16.32,38.08,3.93,24.78,20.24ZM369,227.9l-9.5-17c-7.7-13.7-19.18-21.6-31.48-21.6s-23.8,7.9-31.5,21.6l-9.5,17c-4.1,7.3-15.6,4-14.9-4.5,3.3-42.1,32.2-71.38,56-71.38s52.68,29.28,56,71.38c.58,8.6-11,11.9-15.11,4.5Z", "M168,152c-23.78,0-52.68,29.28-56,71.38-.7,8.5,10.8,11.9,15.1,4.5l9.5-17c7.7-13.7,19.18-21.6,31.48-21.6s23.8,7.9,31.5,21.6l9.5,17c4.1,7.4,15.6,4.1,14.9-4.5C220.7,181.3,191.8,152,168,152ZM384.08,223.4c-3.3-42.1-32.2-71.38-56-71.38s-52.7,29.28-56,71.38c-.7,8.5,10.8,11.8,14.9,4.5l9.5-17c7.7-13.7,19.2-21.6,31.5-21.6s23.78,7.9,31.48,21.6l9.5,17c4.11,7.4,15.71,4.1,15.11-4.5Z"]],
    "smile-plus": [640, 512, [], "f5b9", ["M208 96C93.1 96 0 189.1 0 304s93.1 208 208 208 208-93.1 208-208S322.9 96 208 96zm64 133.2a26.8 26.8 0 1 1-26.8 26.8 26.8 26.8 0 0 1 26.8-26.8zm-128 0a26.8 26.8 0 1 1-26.8 26.8 26.8 26.8 0 0 1 26.8-26.8zm164.2 140.9a132.32 132.32 0 0 1-200.4 0 16 16 0 1 1 24.3-20.7 100.23 100.23 0 0 0 151.6-.1 16.07 16.07 0 0 1 24.5 20.8z", "M624 80h-64V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v64h-64a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h64v64a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-64h64a16 16 0 0 0 16-16V96a16 16 0 0 0-16-16zM272 229.2a26.8 26.8 0 1 0 26.8 26.8 26.8 26.8 0 0 0-26.8-26.8zm-128 0a26.8 26.8 0 1 0 26.8 26.8 26.8 26.8 0 0 0-26.8-26.8z"]],
    "smile-wink": [496, 512, [], "f4da", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8ZM168,176a32,32,0,1,1-32,32A32,32,0,0,1,168,176ZM362.8,346.3a149.48,149.48,0,0,1-229.6-.1c-13.5-16.3,11.2-36.7,24.6-20.4a117.5,117.5,0,0,0,180.4,0C351.8,309.6,376.3,330,362.8,346.3ZM368.2,233l-9.7-8.5c-14.8-13.2-46.2-13.2-61,0L288,233c-8.3,7.4-21.6.4-19.8-10.8,4-25.2,34.2-42.1,59.9-42.1S384,197,388,222.2c1.7,11.1-11.4,18.3-19.8,10.8Z", "M388,222.2c-4-25.2-34.2-42.1-59.9-42.1s-55.9,16.9-59.9,42.1c-1.8,11.2,11.5,18.2,19.8,10.8l9.5-8.5c14.8-13.2,46.2-13.2,61,0l9.7,8.5c8.4,7.5,21.5.3,19.8-10.8ZM168,176a32,32,0,1,0,32,32A32,32,0,0,0,168,176Z"]],
    "smog": [640, 512, [], "f75f", ["M624 368H80a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h544a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm-480 96H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm416 0H224a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h336a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16z", "M0 144a143.73 143.73 0 0 1 248-99.2A143.18 143.18 0 0 1 352 0c54.8 0 102 31 126.3 76.1A110.53 110.53 0 0 1 528 64a112 112 0 0 1 0 224h-60.1c-22.6 19.7-51.6 32-83.9 32s-61.4-12.3-83.9-32H144A144 144 0 0 1 0 144z"]],
    "smoke": [640, 512, [], "f760", ["M512 96c-46.8 0-87.3 25.3-109.6 62.8-22.3-18.9-50.8-30.8-82.4-30.8-51.7 0-95.9 30.8-116.1 74.8a174.6 174.6 0 0 1 44.1 23.4 174.7 174.7 0 0 1 243 34.9 136.5 136.5 0 0 1 37-5.1c35.5 0 67.6 13.4 92.7 34.8A127.39 127.39 0 0 0 512 96zm-192 0a157.94 157.94 0 0 1 75.1 19.2c9.3-10.2 20.2-18.4 31.6-25.8A127.93 127.93 0 0 0 320 32c-31.6 0-60.1 11.9-82.4 30.8C215.3 25.3 174.8 0 128 0A128 128 0 0 0 0 128c0 38.2 17.1 72.1 43.7 95.6a174 174 0 0 1 129.4-29.1C197.2 136.8 253.7 96 320 96z", "M640 400a111.94 111.94 0 0 1-112 112H144a144 144 0 1 1 104-243.2A143.18 143.18 0 0 1 352 224c54.8 0 102 31 126.3 76.1A110.53 110.53 0 0 1 528 288a111.94 111.94 0 0 1 112 112z"]],
    "smoking": [640, 512, [], "f48d", ["M553.3 87.1a20.29 20.29 0 0 1-9.3-16.8V8a8 8 0 0 0-8-8h-48a8 8 0 0 0-8 8v62.3c0 22 10.2 43.4 28.6 55.4a147.29 147.29 0 0 1 67.4 124V280a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8v-30.3a195.28 195.28 0 0 0-86.7-162.6zm-65.6 54.5C463.8 125 448 99.3 448 70.3V8a8 8 0 0 0-8-8h-48a8 8 0 0 0-8 8v66.4c0 43.7 24.6 81.6 60.3 106.7a83.62 83.62 0 0 1 35.7 68.6V280a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8v-30.3a131.59 131.59 0 0 0-56.3-108.1z", "M536 352h-48a8 8 0 0 0-8 8v144a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8V360a8 8 0 0 0-8-8zm96 0h-48a8 8 0 0 0-8 8v144a8 8 0 0 0 8 8h48a8 8 0 0 0 8-8V360a8 8 0 0 0-8-8zm-200 0H48a48 48 0 0 0-48 48v64a48 48 0 0 0 48 48h384a16 16 0 0 0 16-16V368a16 16 0 0 0-16-16z"]],
    "smoking-ban": [512, 512, [], "f54d", ["M96 240a16 16 0 0 1 16-16h21.5l96 96H112a16 16 0 0 1-16-16zm224.6-80a32 32 0 0 1 31.4 25.9 7.74 7.74 0 0 0 7.7 6.1h16.2a8.17 8.17 0 0 0 8-9.4 64.07 64.07 0 0 0-63.3-54.6 32 32 0 0 1-31.4-25.9 7.74 7.74 0 0 0-7.7-6.1h-16.2a8.17 8.17 0 0 0-8 9.4 64.07 64.07 0 0 0 63.3 54.6zm95.4 80a16 16 0 0 0-16-16H269.2l32 32H384v32h-50.8l32 32H400a16 16 0 0 0 16-16z", "M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256 256-114.6 256-256S397.4 0 256 0zm0 448c-105.9 0-192-86.1-192-192a190.67 190.67 0 0 1 35.7-111.1l267.4 267.4A190.67 190.67 0 0 1 256 448zm156.3-80.9L144.9 99.7A190.67 190.67 0 0 1 256 64c105.9 0 192 86.1 192 192a190.67 190.67 0 0 1-35.7 111.1z"]],
    "sms": [512, 512, [], "f7cd", ["M256 32C114.6 32 0 125.1 0 240c0 49.6 21.4 95 57 130.7C44.5 421.1 2.7 466 2.2 466.5a8 8 0 0 0-1.5 8.7A7.83 7.83 0 0 0 8 480c66.3 0 116-31.8 140.6-51.4A305 305 0 0 0 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zM128.2 304H116a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h12.3c6 0 10.4-3.5 10.4-6.6a5.29 5.29 0 0 0-2.1-3.8l-21.9-18.8a37 37 0 0 1-13.3-28.1c0-21.3 19-38.6 42.4-38.6H156a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8h-12.3c-6 0-10.4 3.5-10.4 6.6a5.29 5.29 0 0 0 2.1 3.8l21.9 18.8a37 37 0 0 1 13.3 28.1c.1 21.3-19 38.6-42.4 38.6zm191.8-8a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8v-68.2l-24.8 55.8a8 8 0 0 1-14.3 0L224 227.8V296a8 8 0 0 1-8 8h-16a8 8 0 0 1-8-8V192a16 16 0 0 1 16-16h16a15.92 15.92 0 0 1 14.3 8.8l17.7 35.4 17.7-35.4A16 16 0 0 1 288 176h16a16 16 0 0 1 16 16zm48.3 8H356a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h12.3c6 0 10.4-3.5 10.4-6.6a5.29 5.29 0 0 0-2.1-3.8l-21.9-18.8a37 37 0 0 1-13.3-28.1c0-21.3 19-38.6 42.4-38.6H396a8 8 0 0 1 8 8v16a8 8 0 0 1-8 8h-12.3c-6 0-10.4 3.5-10.4 6.6a5.29 5.29 0 0 0 2.1 3.8l21.9 18.8a37 37 0 0 1 13.3 28.1c.1 21.3-18.9 38.6-42.3 38.6z", "M397.3 237.3l-21.9-18.8a5.29 5.29 0 0 1-2.1-3.8c0-3.1 4.4-6.6 10.4-6.6H396a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8h-12.2c-23.4 0-42.4 17.3-42.4 38.6a37 37 0 0 0 13.3 28.1l21.9 18.8a5.29 5.29 0 0 1 2.1 3.8c0 3.1-4.4 6.6-10.4 6.6H356a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h12.3c23.4 0 42.4-17.3 42.3-38.6a37 37 0 0 0-13.3-28.1zM304 176h-16a16 16 0 0 0-14.3 8.8L256 220.2l-17.7-35.4A15.92 15.92 0 0 0 224 176h-16a16 16 0 0 0-16 16v104a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-68.2l24.9 55.8a8 8 0 0 0 14.3 0l24.8-55.8V296a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8V192a16 16 0 0 0-16-16zm-146.7 61.3l-21.9-18.8a5.29 5.29 0 0 1-2.1-3.8c0-3.1 4.4-6.6 10.4-6.6H156a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8h-12.2c-23.4 0-42.4 17.3-42.4 38.6a37 37 0 0 0 13.3 28.1l21.9 18.8a5.29 5.29 0 0 1 2.1 3.8c0 3.1-4.4 6.6-10.4 6.6H116a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h12.2c23.4 0 42.5-17.3 42.4-38.6a37 37 0 0 0-13.3-28.1z"]],
    "snake": [640, 512, [], "f716", ["M0 320h96v-64H0zm160 64h96v-64h-96zm160 0h96v-64h-96zM0 192h96v-64H0zm160 64h96v-64h-96zm368 0a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm0-32a16 16 0 1 0-16-16 16 16 0 0 0 16 16z", "M160 128a32 32 0 0 0-64 0H0a124.66 124.66 0 0 1 .63-12.52A128.12 128.12 0 0 1 140.79.64C207.29 7.12 256 66.9 256 133.71V192h-96zM0 256h96v-64H0zm0 64a518.51 518.51 0 0 0 33 181.63c5.19 13.84 24.77 13.84 30 0A518.51 518.51 0 0 0 96 320zm160 0h96v-64h-96zm160 64a32 32 0 0 1-64 0h-95.88c2.68 64.48 50.49 121.08 115.09 127.39A128.16 128.16 0 0 0 415.38 396.5q.62-6.22.62-12.49h-96zm320-173.31v60.61a32 32 0 0 1-22.92 30.7l-86.88 25.7c-33.62 9.94-66.9-9.07-78-39.69H448a32 32 0 0 0-32 32h-96A128 128 0 0 1 448 192h4.56c11.54-30.28 44.86-48.81 78.25-38.54l86.59 26.64a32 32 0 0 1 22.6 30.59zM544 272a16 16 0 1 0-16 16 16 16 0 0 0 16-16zm0-64a16 16 0 1 0-16 16 16 16 0 0 0 16-16z"]],
    "snooze": [448, 512, [], "f880", ["M304 176v-32a16 16 0 0 0-16-16h-34.75l57.37-57.38A32 32 0 0 0 320 48V32a32 32 0 0 0-32-32H184a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h42.75l-57.37 57.38A32 32 0 0 0 160 144v16a32 32 0 0 0 32 32h96a16 16 0 0 0 16-16zm144 96v-16a32 32 0 0 0-32-32h-96a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h34.75l-57.37 57.38A32 32 0 0 0 288 368v16a32 32 0 0 0 32 32h104a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-42.75l57.37-57.38A32 32 0 0 0 448 272z", "M192 224H40a24 24 0 0 0-24 24v48a24 24 0 0 0 24 24h50.44L8.08 412.66A32 32 0 0 0 0 433.92V480a32 32 0 0 0 32 32h152a24 24 0 0 0 24-24v-48a24 24 0 0 0-24-24h-50.44l82.36-92.66a32 32 0 0 0 8.08-21.26V256a32 32 0 0 0-32-32z"]],
    "snow-blowing": [640, 512, [], "f761", ["M540.3 320H361.72a32.4 32.4 0 0 0-17.81 5.4l-44 29.3c-13.2 8.8-7 29.3 8.91 29.3H542.2c15.9 0 30.81 10.9 33.41 26.6a32.06 32.06 0 0 1-62 15.5C511.5 419.8 505 416 498.4 416h-32.84a16.06 16.06 0 0 0-15.7 19.1 96.06 96.06 0 0 0 188.28-38.2c-8.71-45.6-51.42-76.9-97.84-76.9zM400 288h144a96.2 96.2 0 0 0 93.81-116.72c-7.6-36.21-36.91-65.52-73.11-73.12a96.23 96.23 0 0 0-114.91 75.52c-1.9 9.6 6.1 18.3 15.8 18.3h32.8c6.7 0 13.1-3.8 15.2-10.1a32.05 32.05 0 0 1 62 15.5C573 213.09 558.22 224 542.22 224H400a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16z", "M291.93 324.1l-11.71 3.1a12.16 12.16 0 0 1-14.9-8.6l-14.9-55.6L200 233.9v56.9l40.4 40.2a12 12 0 0 1 0 17l-8.5 8.5a12 12 0 0 1-17 0l-14.8-14.8V372a12 12 0 0 1-12 12h-24a12 12 0 0 1-12-12v-30.3l-14.8 14.8a12 12 0 0 1-17 0l-8.5-8.5a12 12 0 0 1 0-17l40.2-40.2v-56.9L101.58 263l-14.9 55.6a12.21 12.21 0 0 1-14.9 8.6l-11.71-3.1a12.21 12.21 0 0 1-8.6-14.9L57 288.8l-26.6 15.3a12.13 12.13 0 0 1-16.61-4.4l-12.1-21a12.12 12.12 0 0 1 4.4-16.6l26.51-15.4-20.41-5.5a12.21 12.21 0 0 1-8.6-14.9l3.1-11.7a12.21 12.21 0 0 1 14.9-8.6l55.72 15 50.21-29-50.24-29-55.62 14.9a12.16 12.16 0 0 1-14.9-8.6l-3.1-11.7a12.16 12.16 0 0 1 8.6-14.9l20.41-5.5-26.61-15.3a12.12 12.12 0 0 1-4.4-16.6l12.1-21a12.13 12.13 0 0 1 16.61-4.4l26.5 15.3-5.5-20.4A12.16 12.16 0 0 1 60 59.9l11.71-3.2a12.16 12.16 0 0 1 14.9 8.6l15 55.7L152 150.1V93.2L111.69 53a12 12 0 0 1 0-17l8.5-8.5a12 12 0 0 1 17 0L152 42.3V12a12 12 0 0 1 12-12h24a12 12 0 0 1 12 12v30.3l14.7-14.8a12 12 0 0 1 17 0l8.5 8.5a12 12 0 0 1 0 17L200 93.2v56.9l50.42-29.1 14.9-55.6a12.21 12.21 0 0 1 14.9-8.6l11.71 3.1a12.21 12.21 0 0 1 8.6 14.9L295 95.2l26.6-15.3a12.13 12.13 0 0 1 16.61 4.4l12.1 21a12.12 12.12 0 0 1-4.4 16.6l-26.61 15.3 20.41 5.5a12.21 12.21 0 0 1 8.6 14.9l-3.1 11.7a12.21 12.21 0 0 1-14.9 8.6L274.72 163l-50.21 29 50.21 29 55.62-14.9a12.16 12.16 0 0 1 14.9 8.6l3.1 11.7a12.16 12.16 0 0 1-8.6 14.9l-20.41 5.5 26.61 15.3a12.12 12.12 0 0 1 4.4 16.6l-12.1 21a12.13 12.13 0 0 1-16.61 4.4L295 288.8l5.5 20.4a12.09 12.09 0 0 1-8.57 14.9z"]],
    "snowboarding": [512, 512, [], "f7ce", ["M431.85 96a48 48 0 1 0-48-48 48 48 0 0 0 48 48zm61.9 375.9a24 24 0 0 0-31.9-11.6 38.23 38.23 0 0 1-29.5 1.3L67.55 328.9a38.27 38.27 0 0 1-21.8-20 24 24 0 0 0-43.5 20.3 85.86 85.86 0 0 0 48.9 44.8L416 506.7a87.38 87.38 0 0 0 29.7 5.3 84.89 84.89 0 0 0 36.5-8.2 24 24 0 0 0 11.55-31.9z", "M505.45 243.2a32 32 0 0 1-44.8 6.4l-83.5-62.9-66 30.5 52 39a48.13 48.13 0 0 1 18.1 48.4l-21.9 102a31.72 31.72 0 0 1-17.8 21.9l-42.27-15.36a31 31 0 0 1-2.73-19.84l19.7-92-60.5-45.3v20.5A47.87 47.87 0 0 1 223 322l-85 28.4a29.94 29.94 0 0 1-7.8 1.28L106.25 343a30.48 30.48 0 0 1-8.7-12.9 32 32 0 0 1 20.2-40.5l74.1-24.7v-53.1a63.63 63.63 0 0 1 35.4-57.2l41.2-20.6-16.4-5.5a47.94 47.94 0 0 1-27.7-24l-29.1-58.1a32 32 0 0 1 57.2-28.6l26.1 52.1 63.7 21.2a160.26 160.26 0 0 1 45.4 23.8l111.4 83.5a32 32 0 0 1 6.4 44.8z"]],
    "snowflake": [448, 512, [], "f2dc", ["M138.08 441.66a15.87 15.87 0 0 0 .16 22.44l11.3 11.3a16.06 16.06 0 0 0 22.6 0l19.7-19.7.06-67.86-53.66 53.66zM91.37 83.9l-14.9 4a15.46 15.46 0 0 0-10.9 18.9l7 26 56.67 32.74-19-70.74a15.47 15.47 0 0 0-18.87-10.9zM65.45 405.3a15.46 15.46 0 0 0 10.9 18.9l14.9 4a15.47 15.47 0 0 0 18.89-10.9l19-70.73-56.69 32.73zm355-167.2a15.48 15.48 0 0 0 18.9-10.9l4-14.9a15.47 15.47 0 0 0-10.9-18.9l-26-7-56.7 32.73zM8.67 227.2a15.47 15.47 0 0 0 18.9 10.9l70.77-19-56.72-32.8-25.95 7a15.51 15.51 0 0 0-11 19zm18.87 46.7a15.47 15.47 0 0 0-18.9 10.9l-4 14.9a15.46 15.46 0 0 0 10.9 18.9l26 7 56.76-32.71zm122.2-237.2L138.34 48a1.21 1.21 0 0 0-.16.16 15.87 15.87 0 0 0 .16 22.44L192 124.3V56.4l-19.7-19.7a16.06 16.06 0 0 0-22.56 0zm293.7 263.1l-4-14.9a15.48 15.48 0 0 0-18.9-10.9l-70.67 19 56.69 32.73 26-7a15.47 15.47 0 0 0 10.88-18.93zm-60.9-193a15.47 15.47 0 0 0-10.9-18.9l-14.9-4a15.45 15.45 0 0 0-18.9 10.9l-19 70.74 56.69-32.74zm-7 272.4l-56.67-32.73 19 70.73a15.46 15.46 0 0 0 18.89 10.9l14.9-4a15.47 15.47 0 0 0 10.9-18.9zM256 387.7l-.16 67.94 19.66 19.66a16.06 16.06 0 0 0 22.6 0l11.3-11.3a16.07 16.07 0 0 0 0-22.6zm42.4-351a16.06 16.06 0 0 0-22.6 0L256 56.4v67.9l53.71-53.7a16.07 16.07 0 0 0 0-22.6z", "M446 366.05l-.09.15-15.47 26.8a15.42 15.42 0 0 1-21.06 5.72L256 310.2l-.2 185.8a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16l.1-185.7-153.25 88.5a15.51 15.51 0 0 1-21.1-5.7L2 366.3a15.51 15.51 0 0 1 5.7-21.1L162.16 256 7.87 166.8a15.43 15.43 0 0 1-5.73-21.06L17.67 119a15.41 15.41 0 0 1 21-5.72h.05L192 201.8V16a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v185.8l153.3-88.5a15.51 15.51 0 0 1 21.1 5.7l15.5 26.8a15.51 15.51 0 0 1-5.7 21.1L285.85 256l154.49 89.2a15.29 15.29 0 0 1 5.66 20.85z"]],
    "snowflakes": [640, 512, [], "f7cf", ["M528 120a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8V91.6l28 16.1a8 8 0 0 0 11-2.9l8-13.9a8 8 0 0 0-3-10.9l-27.85-16L604 48a8 8 0 0 0 2.9-10.9l-8-13.9a8 8 0 0 0-10.9-2.9l-28 16.1V8a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v28.4l-28-16.1a8 8 0 0 0-10.91 2.9l-8 13.9A8 8 0 0 0 484 48l28 16-28 16a8 8 0 0 0-2.9 10.9l8 13.9a8 8 0 0 0 10.9 2.9l28-16.1zm108 152l-27.92-16L636 240a8 8 0 0 0 2.9-10.9l-8-13.9a8 8 0 0 0-10.9-2.9l-28 16.1V200a8 8 0 0 0-8-8h-16a8 8 0 0 0-8 8v28.4l-28-16.1a8 8 0 0 0-10.91 2.9l-8 13.9A8 8 0 0 0 516 240l28 16-28 16a8 8 0 0 0-2.9 10.9l8 13.9a8 8 0 0 0 10.9 2.9l28-16.1V312a8 8 0 0 0 8 8h16a8 8 0 0 0 8-8v-28.4l28 16.1a8 8 0 0 0 11-2.9l8-13.9a8 8 0 0 0-3-10.9zM65.45 404.3a15.46 15.46 0 0 0 10.9 18.9l14.9 4a15.47 15.47 0 0 0 18.89-10.9l19-70.73-56.69 32.73zM91.37 82.9l-14.9 4a15.46 15.46 0 0 0-10.9 18.9l7 26 56.67 32.74-19-70.74a15.47 15.47 0 0 0-18.87-10.9zm46.71 357.76a15.87 15.87 0 0 0 .16 22.44l11.3 11.3a16.06 16.06 0 0 0 22.6 0l19.7-19.7.06-67.86-53.66 53.66zM27.54 272.9a15.47 15.47 0 0 0-18.9 10.9l-4 14.9a15.46 15.46 0 0 0 10.9 18.9l26 7 56.76-32.71zM8.67 226.2a15.47 15.47 0 0 0 18.9 10.9l70.77-19-56.72-32.8-25.95 7a15.51 15.51 0 0 0-11 19zm411.77 10.9a15.48 15.48 0 0 0 18.9-10.9l4-14.9a15.47 15.47 0 0 0-10.9-18.9l-26-7-56.7 32.73zm-44.9 141.1l-56.67-32.73 19 70.73a15.46 15.46 0 0 0 18.89 10.9l14.9-4a15.47 15.47 0 0 0 10.9-18.9zm63.9-94.3a15.48 15.48 0 0 0-18.9-10.9l-70.67 19 56.69 32.73 26-7a15.47 15.47 0 0 0 10.9-18.9zm-56.9-178.1a15.47 15.47 0 0 0-10.9-18.9l-14.9-4a15.45 15.45 0 0 0-18.9 10.9l-19 70.74 56.69-32.74zm-84.1-70.1a16.06 16.06 0 0 0-22.6 0L256 55.4v67.9l53.71-53.7a16.07 16.07 0 0 0 0-22.6zM256 386.7l-.16 67.94 19.66 19.66a16.06 16.06 0 0 0 22.6 0l11.3-11.3a16.07 16.07 0 0 0 0-22.6zm-106.3-351L138.34 47a1.21 1.21 0 0 0-.16.16 15.87 15.87 0 0 0 .16 22.44L192 123.3V55.4l-19.7-19.7a16.06 16.06 0 0 0-22.56 0z", "M446 365.05l-.09.15-15.47 26.8a15.42 15.42 0 0 1-21.06 5.72L256 309.2l-.2 185.8a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16l.1-185.7-153.25 88.5a15.51 15.51 0 0 1-21.1-5.7L2 365.3a15.51 15.51 0 0 1 5.7-21.1L162.16 255 7.87 165.8a15.43 15.43 0 0 1-5.73-21.06L17.67 118a15.41 15.41 0 0 1 21-5.72h.05L192 200.8V15a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v185.8l153.3-88.5a15.51 15.51 0 0 1 21.1 5.7l15.5 26.8a15.51 15.51 0 0 1-5.7 21.1L285.85 255l154.49 89.2a15.29 15.29 0 0 1 5.66 20.85z"]],
    "snowman": [512, 512, [], "f7d0", ["M363.76 268.8a108.77 108.77 0 0 0 4.2-28.7v-.1a112.68 112.68 0 0 0-.73-12.8c-.11-1-.24-2-.38-3-.29-2-.62-4-1-6-.2-1-.4-1.95-.62-2.92-.22-1-.45-1.93-.7-2.9-.24-1-.5-1.91-.77-2.85-.27-.95-.55-1.89-.84-2.83-.3-.94-.6-1.87-.92-2.8-.32-.93-.65-1.86-1-2.77-.34-.92-.69-1.83-1.06-2.74-.36-.9-.74-1.8-1.13-2.7-.39-.89-.79-1.78-1.19-2.66-.41-.88-.83-1.76-1.26-2.63q-1.31-2.62-2.73-5.16c-.48-.85-1-1.68-1.46-2.51a112.44 112.44 0 0 0-21.62-26.19 96 96 0 1 0-149.16 0 112.49 112.49 0 0 0-21.68 26.28q-.74 1.23-1.44 2.49c-.48.84-.94 1.69-1.39 2.54-.45.85-.89 1.7-1.32 2.57-.43.87-.85 1.74-1.25 2.62-.41.88-.8 1.76-1.19 2.66-.39.89-.76 1.79-1.12 2.69-.36.91-.71 1.82-1.05 2.74-.34.92-.67 1.84-1 2.76a111.63 111.63 0 0 0-5.22 23.28A113 113 0 0 0 144 240h.06v.1a110.27 110.27 0 0 0 4.2 28.9A151.18 151.18 0 0 0 104 376.1c0 54 28.4 100.9 70.8 127.8 9.3 5.9 20.3 8.2 31.3 8.2h99.2a65.1 65.1 0 0 0 37.2-11.7c46.5-32.3 74.4-89.4 62.9-152.6-5.54-30.2-20.54-57.6-41.64-79zM224 96.1a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm32 272a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm0-64a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm1.7-64.1a15.19 15.19 0 0 1-3.48 0 16 16 0 1 1 3.48 0zm-1.7-87.9s-16-23.2-16-32a16 16 0 1 1 32 0c0 8.8-16 32-16 32zm32-56a16 16 0 1 1 16-16 16 16 0 0 1-16 16z", "M510.86 152.4L505 137.9a16.15 16.15 0 0 0-20.8-8.7L456 140.7v-29a15.84 15.84 0 0 0-16-15.6h-16a15.84 15.84 0 0 0-16 15.6v46.9c0 .5.3 1 .3 1.5l-56.1 22.54a111.21 111.21 0 0 1 15.07 44.56L502 172.7a15.57 15.57 0 0 0 8.86-20.3zm-407.1 6.2v-46.9c.2-8.6-7-15.6-15.8-15.6H72a15.84 15.84 0 0 0-16 15.6v29l-28.1-11.5a16.15 16.15 0 0 0-20.8 8.7l-5.9 14.5a15.48 15.48 0 0 0 8.9 20.3l134.67 54.49a111.3 111.3 0 0 1 15-44.46l-56.31-22.63a8 8 0 0 0 .3-1.5zM256 336.1a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm0-64a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm0-64a16 16 0 1 0 16 16 16 16 0 0 0-16-16z"]],
    "snowmobile": [640, 512, [], "f7d1", ["M240 0a48 48 0 1 0 48 48 48 48 0 0 0-48-48zm259.38 403.11l-7.27 4.89a48 48 0 0 1-26.61 8h-16.25L486 464h-54a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h114.7a88.18 88.18 0 0 0 52.8-17.6l34.1-25.6a16 16 0 0 0 3.2-22.4l-9.6-12.8a15.89 15.89 0 0 0-12.78-6.41 16.05 16.05 0 0 0-9.62 3.21L570.7 456a39.8 39.8 0 0 1-24 8h-.7zM288 448H32a32 32 0 0 0 0 64h256a32 32 0 0 0 0-64z", "M465.5 416a48 48 0 0 0 26.61-8l76.79-51.2a15.94 15.94 0 0 0 7.1-13.3V266a15.94 15.94 0 0 0-8.8-14.3L407.9 172l-41.5-83.1a16 16 0 0 0-28.7 14.3l35.6 71.2L360 192h-58.7L246 136.8a64 64 0 0 0-102.5 16.6l-29.8 59.7a63.27 63.27 0 0 0 13.4 75H96a31.87 31.87 0 0 0-28.6 17.7l-32 64C24.7 391 40.2 416 64 416zM288 288h-24.4l-67-33.5 25.6-51.1 33.9 33.9a63.66 63.66 0 0 0 45.2 18.8H312z"]],
    "snowplow": [640, 512, [], "f7d2", ["M368 352a48 48 0 0 1 0 96H112a48 48 0 0 1 0-96h256m0-64H112a112 112 0 0 0 0 224h256a112 112 0 0 0 0-224z", "M120 376a23.94 23.94 0 1 0 .12 0zm80 0a23.94 23.94 0 1 0 .12 0zm160 0a23.94 23.94 0 1 0 .12 0zm-80 0a23.94 23.94 0 1 0 .12 0zm318.6 49.4a77.16 77.16 0 0 1-22.6-54.6V269.2a77.16 77.16 0 0 1 22.6-54.6l36.7-36.7a16.06 16.06 0 0 0 0-22.6l-22.6-22.6a16.06 16.06 0 0 0-22.6 0l-36.7 36.7a141.23 141.23 0 0 0-41.4 99.9V288h-64v-50.9a64.23 64.23 0 0 0-5.2-25.2L364.5 29.1A48 48 0 0 0 320.3 0H176a48 48 0 0 0-48 48v112h-16a48 48 0 0 0-48 48v90.78A111.63 111.63 0 0 1 112 288h256a112 112 0 0 1 101.22 64H512v18.7a141.23 141.23 0 0 0 41.4 99.9l36.7 36.7a16.06 16.06 0 0 0 22.6 0l22.6-22.6a16.06 16.06 0 0 0 0-22.6zM256 224l-64-64V64h117.8l68.6 160z"]],
    "socks": [512, 512, [], "f696", ["M160 0a32 32 0 0 0-32 32v32h160V32a63.12 63.12 0 0 1 8-30.38C293.39.92 290.84 0 288 0zm-32 272l-86.65 64.6C2 366.15-12.52 421 12.13 463.65A96.77 96.77 0 0 0 96.07 512a95.62 95.62 0 0 0 57.52-19.2l21.86-16.39C145.6 421 161.91 350.55 214.65 311L288 256v-96H128zm0-144h160V96H128zm192-64v32h192V64zm0 96h192v-32H320z", "M288 64H128v32h160zm0 64H128v32h160zm32 144l-86.13 64.6C194.46 366.15 180 421 204.65 463.65a96 96 0 0 0 131 35.67 98 98 0 0 0 9.95-6.54l115.2-86.4A128 128 0 0 0 512 304V160H320zm0-144h192V96H320zM480 0H352a32 32 0 0 0-32 32v32h192V32a32 32 0 0 0-32-32z"]],
    "solar-panel": [640, 512, [], "f5ba", ["M585.2 26.74A32.42 32.42 0 0 0 553.06 0H86.93a32.42 32.42 0 0 0-32.14 26.74C-3.32 369.16 0 348.08 0 352c0 17.32 14.29 32 32.6 32h574.77c18.23 0 32.51-14.56 32.59-31.79.04-4.08 3.35 16.95-54.76-325.47zM259.83 64h120.33l9.77 96H250.06zm-75.17 256H71.09l19-112h106zM201 160H98.24l16.29-96h96.19zm32.82 160l11.4-112h149.6l11.4 112zM429.27 64h96.19l16.29 96H439zm26.06 256l-11.4-112h106l19 112z", "M432 448l-48 .05V416H256v32.21l-48 .05a16 16 0 0 0-16 16V496a16 16 0 0 0 16 16l224-.26a16 16 0 0 0 16-16V464a16 16 0 0 0-16-16zM380.16 64H259.83l-9.77 96h139.87zm161.59 96l-16.29-96h-96.19l9.73 96zm-146.93 48H245.17l-11.4 112h172.45zM90.1 208l-19 112h113.56l11.41-112zM210.72 64h-96.19l-16.29 96H201zM549.9 208h-106l11.4 112h113.61z"]],
    "sort": [320, 512, [], "f0dc", ["M279.05 288.05h-238c-21.4 0-32.07 25.95-17 41l119.1 119 .1.1a23.9 23.9 0 0 0 33.8-.1l119-119c15.1-15.05 4.4-41-17-41zm-238-64h238c21.4 0 32.1-25.9 17-41l-119-119a.94.94 0 0 0-.1-.1 23.9 23.9 0 0 0-33.8.1l-119.1 119c-15.05 15.1-4.4 41 17 41z", ""]],
    "sort-alpha-down": [448, 512, [], "f15d", ["M416 288H288a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h56l-61.26 70.45A32 32 0 0 0 272 446.37V464a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-56l61.26-70.45A32 32 0 0 0 432 321.63V304a16 16 0 0 0-16-16zm31.06-85.38l-59.27-160A16 16 0 0 0 372.72 32h-41.44a16 16 0 0 0-15.07 10.62l-59.27 160A16 16 0 0 0 272 224h24.83a16 16 0 0 0 15.23-11.08l4.42-12.92h71l4.41 12.92A16 16 0 0 0 407.16 224H432a16 16 0 0 0 15.06-21.38zM335.61 144L352 96l16.39 48z", "M176 352h-48V48a16 16 0 0 0-16-16H80a16 16 0 0 0-16 16v304H16c-14.19 0-21.36 17.24-11.29 27.31l80 96a16 16 0 0 0 22.62 0l80-96C197.35 369.26 190.22 352 176 352z"]],
    "sort-alpha-down-alt": [448, 512, [], "f881", ["M288 224h128a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-56l61.26-70.45A32 32 0 0 0 432 65.63V48a16 16 0 0 0-16-16H288a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h56l-61.26 70.45A32 32 0 0 0 272 190.37V208a16 16 0 0 0 16 16zm159.06 234.62l-59.27-160A16 16 0 0 0 372.72 288h-41.44a16 16 0 0 0-15.07 10.62l-59.27 160A16 16 0 0 0 272 480h24.83a16 16 0 0 0 15.23-11.08l4.42-12.92h71l4.41 12.92A16 16 0 0 0 407.16 480H432a16 16 0 0 0 15.06-21.38zM335.61 400L352 352l16.39 48z", "M176 352h-48V48a16 16 0 0 0-16-16H80a16 16 0 0 0-16 16v304H16c-14.19 0-21.36 17.24-11.29 27.31l80 96a16 16 0 0 0 22.62 0l80-96C197.35 369.26 190.22 352 176 352z"]],
    "sort-alpha-up": [448, 512, [], "f15e", ["M416 288H288a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h56l-61.26 70.45A32 32 0 0 0 272 446.37V464a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-56l61.26-70.45A32 32 0 0 0 432 321.63V304a16 16 0 0 0-16-16zm31.06-85.38l-59.27-160A16 16 0 0 0 372.72 32h-41.44a16 16 0 0 0-15.07 10.62l-59.27 160A16 16 0 0 0 272 224h24.83a16 16 0 0 0 15.23-11.08l4.42-12.92h71l4.41 12.92A16 16 0 0 0 407.16 224H432a16 16 0 0 0 15.06-21.38zM335.61 144L352 96l16.39 48z", "M16 160h48v304a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V160h48c14.21 0 21.38-17.24 11.31-27.31l-80-96a16 16 0 0 0-22.62 0l-80 96C-5.35 142.74 1.78 160 16 160z"]],
    "sort-alpha-up-alt": [448, 512, [], "f882", ["M288 224h128a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-56l61.26-70.45A32 32 0 0 0 432 65.63V48a16 16 0 0 0-16-16H288a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h56l-61.26 70.45A32 32 0 0 0 272 190.37V208a16 16 0 0 0 16 16zm159.06 234.62l-59.27-160A16 16 0 0 0 372.72 288h-41.44a16 16 0 0 0-15.07 10.62l-59.27 160A16 16 0 0 0 272 480h24.83a16 16 0 0 0 15.23-11.08l4.42-12.92h71l4.41 12.92A16 16 0 0 0 407.16 480H432a16 16 0 0 0 15.06-21.38zM335.61 400L352 352l16.39 48z", "M16 160h48v304a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V160h48c14.21 0 21.38-17.24 11.31-27.31l-80-96a16 16 0 0 0-22.62 0l-80 96C-5.35 142.74 1.78 160 16 160z"]],
    "sort-alt": [384, 512, [], "f883", ["M379.29 132.69l-80-96a16 16 0 0 0-22.62 0l-80 96C186.65 142.74 193.78 160 208 160h48v304a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V160h48c14.19 0 21.36-17.24 11.29-27.31z", "M176 352h-48V48a16 16 0 0 0-16-16H80a16 16 0 0 0-16 16v304H16c-14.19 0-21.36 17.24-11.29 27.31l80 96a16 16 0 0 0 22.62 0l80-96C197.35 369.26 190.22 352 176 352z"]],
    "sort-amount-down": [512, 512, [], "f160", ["M304 416h-64a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm128-256H240a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h192a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-64 128H240a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM496 32H240a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h256a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z", "M176 352h-48V48a16 16 0 0 0-16-16H80a16 16 0 0 0-16 16v304H16c-14.19 0-21.37 17.24-11.29 27.31l80 96a16 16 0 0 0 22.62 0l80-96C197.35 369.26 190.22 352 176 352z"]],
    "sort-amount-down-alt": [512, 512, [], "f884", ["M240 96h64a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-64a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm0 128h128a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H240a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm256 192H240a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h256a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-256-64h192a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H240a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16z", "M176 352h-48V48a16 16 0 0 0-16-16H80a16 16 0 0 0-16 16v304H16c-14.19 0-21.37 17.24-11.29 27.31l80 96a16 16 0 0 0 22.62 0l80-96C197.35 369.26 190.22 352 176 352z"]],
    "sort-amount-up": [512, 512, [], "f161", ["M304 416h-64a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm128-256H240a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h192a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-64 128H240a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM496 32H240a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h256a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z", "M16 160h48v304a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V160h48c14.21 0 21.38-17.24 11.31-27.31l-80-96a16 16 0 0 0-22.62 0l-80 96C-5.35 142.74 1.77 160 16 160z"]],
    "sort-amount-up-alt": [512, 512, [], "f885", ["M240 96h64a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16h-64a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm0 128h128a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H240a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16zm256 192H240a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h256a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-256-64h192a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16H240a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16z", "M16 160h48v304a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V160h48c14.21 0 21.39-17.24 11.31-27.31l-80-96a16 16 0 0 0-22.62 0l-80 96C-5.35 142.74 1.78 160 16 160z"]],
    "sort-down": [320, 512, [], "f0dd", ["M279.07 224.05h-238c-21.4 0-32.1-25.9-17-41l119-119a23.9 23.9 0 0 1 33.8-.1l.1.1 119.1 119c15.07 15.05 4.4 41-17 41z", "M296.07 329.05L177 448.05a23.9 23.9 0 0 1-33.8.1l-.1-.1-119-119c-15.1-15.1-4.4-41 17-41h238c21.37 0 32.04 25.95 16.97 41z"]],
    "sort-numeric-down": [448, 512, [], "f162", ["M304 96h16v64h-16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-16V48a16 16 0 0 0-16-16h-48a16 16 0 0 0-14.29 8.83l-16 32A16 16 0 0 0 304 96zm26.15 162.91a79 79 0 0 0-55 54.17c-14.25 51.05 21.21 97.77 68.85 102.53a84.07 84.07 0 0 1-20.85 12.91c-7.57 3.4-10.8 12.47-8.18 20.34l9.9 20c2.87 8.63 12.53 13.49 20.9 9.91 58-24.76 86.25-61.61 86.25-132V336c-.02-51.21-48.4-91.34-101.85-77.09zM352 356a20 20 0 1 1 20-20 20 20 0 0 1-20 20z", "M176 352h-48V48a16 16 0 0 0-16-16H80a16 16 0 0 0-16 16v304H16c-14.19 0-21.36 17.24-11.29 27.31l80 96a16 16 0 0 0 22.62 0l80-96C197.35 369.26 190.22 352 176 352z"]],
    "sort-numeric-down-alt": [448, 512, [], "f886", ["M400 416h-16V304a16 16 0 0 0-16-16h-48a16 16 0 0 0-14.29 8.83l-16 32A16 16 0 0 0 304 352h16v64h-16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM330.17 34.91a79 79 0 0 0-55 54.17c-14.27 51.05 21.19 97.77 68.83 102.53a84.07 84.07 0 0 1-20.85 12.91c-7.57 3.4-10.8 12.47-8.18 20.34l9.9 20c2.87 8.63 12.53 13.49 20.9 9.91 58-24.77 86.25-61.61 86.25-132V112c-.02-51.21-48.4-91.34-101.85-77.09zM352 132a20 20 0 1 1 20-20 20 20 0 0 1-20 20z", "M176 352h-48V48a16 16 0 0 0-16-16H80a16 16 0 0 0-16 16v304H16c-14.19 0-21.36 17.24-11.29 27.31l80 96a16 16 0 0 0 22.62 0l80-96C197.35 369.26 190.22 352 176 352z"]],
    "sort-numeric-up": [448, 512, [], "f163", ["M330.17 258.91a79 79 0 0 0-55 54.17c-14.27 51.05 21.19 97.77 68.83 102.53a84.07 84.07 0 0 1-20.85 12.91c-7.57 3.4-10.8 12.47-8.18 20.34l9.9 20c2.87 8.63 12.53 13.49 20.9 9.91 58-24.76 86.25-61.61 86.25-132V336c-.02-51.21-48.4-91.34-101.85-77.09zM352 356a20 20 0 1 1 20-20 20 20 0 0 1-20 20zM304 96h16v64h-16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16h-16V48a16 16 0 0 0-16-16h-48a16 16 0 0 0-14.29 8.83l-16 32A16 16 0 0 0 304 96z", "M107.31 36.69a16 16 0 0 0-22.62 0l-80 96C-5.35 142.74 1.78 160 16 160h48v304a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V160h48c14.21 0 21.38-17.24 11.31-27.31z"]],
    "sort-numeric-up-alt": [448, 512, [], "f887", ["M400 416h-16V304a16 16 0 0 0-16-16h-48a16 16 0 0 0-14.29 8.83l-16 32A16 16 0 0 0 304 352h16v64h-16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zM330.17 34.91a79 79 0 0 0-55 54.17c-14.27 51.05 21.19 97.77 68.83 102.53a84.07 84.07 0 0 1-20.85 12.91c-7.57 3.4-10.8 12.47-8.18 20.34l9.9 20c2.87 8.63 12.53 13.49 20.9 9.91 58-24.77 86.25-61.61 86.25-132V112c-.02-51.21-48.4-91.34-101.85-77.09zM352 132a20 20 0 1 1 20-20 20 20 0 0 1-20 20z", "M107.31 36.69a16 16 0 0 0-22.62 0l-80 96C-5.35 142.74 1.78 160 16 160h48v304a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V160h48c14.21 0 21.38-17.24 11.31-27.31z"]],
    "sort-shapes-down": [448, 512, [], "f888", ["M444.1 182.86L361 45.71c-11.09-18.28-38.81-18.28-49.9 0l-83.2 137.15c-11.08 18.28 2.77 41.14 24.95 41.14h166.3c22.18 0 36.03-22.86 24.95-41.14zM408 288H264a24 24 0 0 0-24 24v144a24 24 0 0 0 24 24h144a24 24 0 0 0 24-24V312a24 24 0 0 0-24-24z", "M176 352h-48V48a16 16 0 0 0-16-16H80a16 16 0 0 0-16 16v304H16c-14.19 0-21.36 17.24-11.29 27.31l80 96a16 16 0 0 0 22.62 0l80-96C197.35 369.26 190.22 352 176 352z"]],
    "sort-shapes-down-alt": [448, 512, [], "f889", ["M444.1 438.86L361 301.71c-11.09-18.28-38.81-18.28-49.9 0l-83.2 137.15c-11.08 18.28 2.77 41.14 24.95 41.14h166.3c22.18 0 36.03-22.86 24.95-41.14zM264 224h144a24 24 0 0 0 24-24V56a24 24 0 0 0-24-24H264a24 24 0 0 0-24 24v144a24 24 0 0 0 24 24z", "M176 352h-48V48a16 16 0 0 0-16-16H80a16 16 0 0 0-16 16v304H16c-14.19 0-21.36 17.24-11.29 27.31l80 96a16 16 0 0 0 22.62 0l80-96C197.35 369.26 190.22 352 176 352z"]],
    "sort-shapes-up": [448, 512, [], "f88a", ["M444.1 182.86L361 45.71c-11.09-18.28-38.81-18.28-49.9 0l-83.2 137.15c-11.08 18.28 2.77 41.14 24.95 41.14h166.3c22.18 0 36.03-22.86 24.95-41.14zM408 288H264a24 24 0 0 0-24 24v144a24 24 0 0 0 24 24h144a24 24 0 0 0 24-24V312a24 24 0 0 0-24-24z", "M107.31 36.69a16 16 0 0 0-22.62 0l-80 96C-5.35 142.74 1.78 160 16 160h48v304a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V160h48c14.21 0 21.39-17.24 11.31-27.31z"]],
    "sort-shapes-up-alt": [448, 512, [], "f88b", ["M444.1 438.86L361 301.71c-11.09-18.28-38.81-18.28-49.9 0l-83.2 137.15c-11.08 18.28 2.77 41.14 24.95 41.14h166.3c22.18 0 36.03-22.86 24.95-41.14zM264 224h144a24 24 0 0 0 24-24V56a24 24 0 0 0-24-24H264a24 24 0 0 0-24 24v144a24 24 0 0 0 24 24z", "M107.31 36.69a16 16 0 0 0-22.62 0l-80 96C-5.35 142.74 1.78 160 16 160h48v304a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V160h48c14.21 0 21.39-17.24 11.31-27.31z"]],
    "sort-size-down": [512, 512, [], "f88c", ["M428 320H276a20 20 0 0 0-20 20v120a20 20 0 0 0 20 20h152a20 20 0 0 0 20-20V340a20 20 0 0 0-20-20zm56-288H284a28 28 0 0 0-28 28v168a28 28 0 0 0 28 28h200a28 28 0 0 0 28-28V60a28 28 0 0 0-28-28z", "M176 352h-48V48a16 16 0 0 0-16-16H80a16 16 0 0 0-16 16v304H16c-14.19 0-21.37 17.24-11.29 27.31l80 96a16 16 0 0 0 22.62 0l80-96C197.35 369.26 190.22 352 176 352z"]],
    "sort-size-down-alt": [512, 512, [], "f88d", ["M275.9 192h152.2a20 20 0 0 0 19.9-20V52a20 20 0 0 0-19.9-20H275.9A20 20 0 0 0 256 52v120a20 20 0 0 0 19.9 20zM484 256H284a28 28 0 0 0-28 28v168a28 28 0 0 0 28 28h200a28 28 0 0 0 28-28V284a28 28 0 0 0-28-28z", "M176 352h-48V48a16 16 0 0 0-16-16H80a16 16 0 0 0-16 16v304H16c-14.19 0-21.37 17.24-11.29 27.31l80 96a16 16 0 0 0 22.62 0l80-96C197.35 369.26 190.22 352 176 352z"]],
    "sort-size-up": [512, 512, [], "f88e", ["M484 32H284a28 28 0 0 0-28 28v168a28 28 0 0 0 28 28h200a28 28 0 0 0 28-28V60a28 28 0 0 0-28-28zm-56 288H276a20 20 0 0 0-20 20v120a20 20 0 0 0 20 20h152a20 20 0 0 0 20-20V340a20 20 0 0 0-20-20z", "M107.31 36.69a16 16 0 0 0-22.62 0l-80 96C-5.35 142.74 1.77 160 16 160h48v304a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V160h48c14.21 0 21.38-17.24 11.31-27.31z"]],
    "sort-size-up-alt": [512, 512, [], "f88f", ["M276 192h152a20 20 0 0 0 20-20V52a20 20 0 0 0-20-20H276a20 20 0 0 0-20 20v120a20 20 0 0 0 20 20zm208 64H284a28 28 0 0 0-28 28v168a28 28 0 0 0 28 28h200a28 28 0 0 0 28-28V284a28 28 0 0 0-28-28z", "M107.31 36.69a16 16 0 0 0-22.62 0l-80 96C-5.35 142.74 1.77 160 16 160h48v304a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V160h48c14.21 0 21.38-17.24 11.31-27.31z"]],
    "sort-up": [320, 512, [], "f0de", ["M41.05 288.05h238c21.4 0 32.1 25.9 17 41l-119 119a23.9 23.9 0 0 1-33.8.1l-.1-.1-119.1-119c-15.05-15.05-4.4-41 17-41z", "M24.05 183.05l119.1-119A23.9 23.9 0 0 1 177 64a.94.94 0 0 1 .1.1l119 119c15.1 15.1 4.4 41-17 41h-238c-21.45-.05-32.1-25.95-17.05-41.05z"]],
    "soup": [512, 512, [], "f823", ["M203.31 67.3a94.84 94.84 0 0 1-26.4-53.5A16.12 16.12 0 0 0 160.81 0h-16.4A16.32 16.32 0 0 0 128 16.23a17.48 17.48 0 0 0 .09 1.77 145.37 145.37 0 0 0 40.6 84.4 81.21 81.21 0 0 1 22.4 44.1 16.23 16.23 0 0 0 16 13.5h16.5c9.8 0 17.6-8.5 16.3-18a130.71 130.71 0 0 0-36.58-74.7zm148.6 74.7a130.71 130.71 0 0 0-36.6-74.7 94.84 94.84 0 0 1-26.4-53.5A16.12 16.12 0 0 0 272.76 0h-16.4c-9.8 0-17.5 8.5-16.3 18a145.37 145.37 0 0 0 40.6 84.4 81.21 81.21 0 0 1 22.4 44.1h.05a16.23 16.23 0 0 0 16 13.5h16.5c9.8 0 17.6-8.5 16.3-18z", "M32 192h448a32 32 0 0 1 32 32c0 94.7-51.56 177.16-128 221.45V480a32 32 0 0 1-32 32H160a32 32 0 0 1-32-32v-34.55C51.56 401.16 0 318.7 0 224a32 32 0 0 1 32-32z"]],
    "spa": [576, 512, [], "f5bb", ["M392.33 206.91a298.84 298.84 0 0 0-60.26 45.17A275.45 275.45 0 0 0 288 302.6a282.66 282.66 0 0 0-45-51.45 294 294 0 0 0-59.22-44.39c16.47-70.45 51.75-132.94 96.74-172.07a12 12 0 0 1 15.14 0c44.95 39.16 80.23 101.72 96.67 172.22z", "M576 199.82c-.23 27.92-7.13 126.14-88.77 199.3C403.19 481 320 480 288 480s-115.21 1-199.23-80.88C7.14 326 .23 227.74 0 199.82A7.6 7.6 0 0 1 7.75 192c29 .13 135 6.16 213.84 83 33.12 29.64 53.41 63.3 66.41 94.86 13.05-31.56 33.29-65.22 66.41-94.85 78.83-76.84 184.8-82.87 213.84-83a7.6 7.6 0 0 1 7.75 7.81z"]],
    "space-shuttle": [640, 512, [], "f197", ["M32 416c0 35.35 21.49 64 48 64h16V352H32zm154.54-232h280.13L376 168C243 140.59 222.45 51.22 128 34.65V160h18.34a45.62 45.62 0 0 1 40.2 24zM32 96v64h64V32H80c-26.51 0-48 28.65-48 64zm114.34 256H128v125.35C222.45 460.78 243 371.41 376 344l90.67-16H186.54a45.62 45.62 0 0 1-40.2 24z", "M592.6 208.24C559.73 192.84 515.78 184 472 184H186.54a45.62 45.62 0 0 0-40.2-24H32c-23.2 0-32 10-32 24v144c0 14 8.82 24 32 24h114.34a45.62 45.62 0 0 0 40.2-24H472c43.78 0 87.73-8.84 120.6-24.24C622.28 289.84 640 272 640 256s-17.72-33.84-47.4-47.76zM488 296a8 8 0 0 1-8-8v-64a8 8 0 0 1 8-8c31.91 0 31.94 80 0 80z"]],
    "spade": [512, 512, [], "f2f4", ["M462.3 387.76c-50.48 39.95-123.38 36-173.87-2.43-.21-3.22-.41-6.44-.43-10V272.14a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v103.15c0 3.57-.2 6.78-.4 10-50.54 38.53-123.41 42.46-173.93 2.49C-13.1 338-16.41 248.58 39.9 194.61L233.4 9a33 33 0 0 1 45.28 0l193.5 185.62c56.21 53.96 52.9 143.38-9.88 193.14z", "M367.31 486.6A32 32 0 0 1 336 512H176a32 32 0 0 1-13-61.29c52.19-23.21 60.91-38.91 61-75.61V272a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v103.1c.19 37.5 9.41 52.61 61 75.61a32.08 32.08 0 0 1 18.31 35.89z"]],
    "sparkles": [512, 512, [], "f890", ["M423.16 186.58L448 127l59.58-24.84a8 8 0 0 0 0-14.32L448 63 423.16 3.42a8 8 0 0 0-14.32 0L384 63l-59.58 24.84a8 8 0 0 0 0 14.32L384 127l24.84 59.58a8 8 0 0 0 14.32 0zm-14.32 136.84L384 383l-59.58 24.84a8 8 0 0 0 0 14.32L384 447l24.84 59.58a8 8 0 0 0 14.32 0L448 447l59.58-24.84a8 8 0 0 0 0-14.32L448 383l-24.84-59.58a8 8 0 0 0-14.32 0z", "M384 254.64a16.06 16.06 0 0 0-8.84-14.33l-112.57-56.39-56.28-112.77c-5.44-10.87-23.19-10.87-28.62 0l-56.28 112.77L8.84 240.31a16 16 0 0 0 0 28.67l112.57 56.39 56.28 112.77a16 16 0 0 0 28.62 0l56.28-112.77L375.16 269a16.07 16.07 0 0 0 8.84-14.36z"]],
    "speaker": [384, 512, [], "f8df", ["M336 0H48A48 48 0 0 0 0 48v416a48 48 0 0 0 48 48h288a48 48 0 0 0 48-48V48a48 48 0 0 0-48-48zM192 64a48 48 0 1 1-48 48 48 48 0 0 1 48-48zm0 384a112 112 0 1 1 112-112 112 112 0 0 1-112 112z", "M192 224a112 112 0 1 0 112 112 112 112 0 0 0-112-112zm0 176a64 64 0 1 1 64-64 64 64 0 0 1-64 64zm0-240a48 48 0 1 0-48-48 48 48 0 0 0 48 48z"]],
    "speakers": [640, 512, [], "f8e0", ["M176 224a111.51 111.51 0 0 1 80 33.78V48a79.24 79.24 0 0 1 16.41-48H48A48 48 0 0 0 0 48v416a48 48 0 0 0 48 48h224.41A79.24 79.24 0 0 1 256 464v-49.78A112 112 0 1 1 176 224zm0-160a48 48 0 1 1-48 48 48 48 0 0 1 48-48zM592 0H336a48 48 0 0 0-48 48v416a48 48 0 0 0 48 48h256a48 48 0 0 0 48-48V48a48 48 0 0 0-48-48zM464 64a48 48 0 1 1-48 48 48 48 0 0 1 48-48zm0 384a112 112 0 1 1 112-112 112 112 0 0 1-112 112z", "M64 336a111.89 111.89 0 0 0 192 78.22V257.78A111.89 111.89 0 0 0 64 336zm176 0a64 64 0 1 1-64-64 64 64 0 0 1 64 64zm224-112a112 112 0 1 0 112 112 112 112 0 0 0-112-112zm0 176a64 64 0 1 1 64-64 64 64 0 0 1-64 64zm0-240a48 48 0 1 0-48-48 48 48 0 0 0 48 48zm-288 0a48 48 0 1 0-48-48 48 48 0 0 0 48 48z"]],
    "spell-check": [576, 512, [], "f891", ["M571.35 276.48l-45.21-45.3a15.88 15.88 0 0 0-22.59 0l-151.5 151.5-55.41-55.5a15.88 15.88 0 0 0-22.59 0l-45.3 45.3a16 16 0 0 0 0 22.59l112 112.21a15.89 15.89 0 0 0 22.6 0l208-208.21a16 16 0 0 0 0-22.59z", "M272 256h91.36c43.2 0 82-32.2 84.51-75.34a79.82 79.82 0 0 0-25.26-63.07 79.81 79.81 0 0 0 9.06-44.91C427.9 30.57 389.3 0 347 0h-75a16 16 0 0 0-16 16v224a16 16 0 0 0 16 16zm40-200h40a24 24 0 0 1 0 48h-40zm0 96h56a24 24 0 0 1 0 48h-56zM155.12 22.25A32 32 0 0 0 124.64 0H99.36a32 32 0 0 0-30.48 22.25L.59 235.73A16 16 0 0 0 16 256h24.93a16 16 0 0 0 15.42-11.73L68.29 208h87.42l11.94 36.27A16 16 0 0 0 183.07 256H208a16 16 0 0 0 15.42-20.27zM89.37 144L112 75.3l22.63 68.7z"]],
    "spider": [576, 512, [], "f717", ["M453.71 88.63L427.82 11A16 16 0 0 0 407.58.83l-15.17 5.06a16 16 0 0 0-10.12 20.24l23.8 71.39-20.29 40.58a99.35 99.35 0 0 1 3.2 11.79l5.23 26.11h4.67l25.93-8.65L452 113.06a32 32 0 0 0 1.71-24.43zM183.59 5.89L168.42.83A16 16 0 0 0 148.18 11l-25.89 77.63a32 32 0 0 0 1.71 24.43l27.15 54.3L177.1 176h4.67l5.23-26.11a99.35 99.35 0 0 1 3.21-11.79l-20.3-40.58 23.8-71.39a16 16 0 0 0-10.12-20.24z", "M573.31 349.39a16 16 0 0 1-4.44 22.18l-13.31 8.88a16 16 0 0 1-22.19-4.45l-48-72h-47.06l60.83 97.33a32.05 32.05 0 0 1 4.86 17V496a16 16 0 0 1-16 16h-16a16 16 0 0 1-16-16v-73.1l-74.08-118.53c1 14.05 2.08 28.11 2.08 42.21C384 399.65 343.24 448 288 448s-96-48.36-96-101.43c0-14.1 1.07-28.16 2.08-42.21L120 422.9V496a16 16 0 0 1-16 16H88a16 16 0 0 1-16-16v-77.7a32 32 0 0 1 4.86-17l60.83-97.3H90.63l-48 72a16 16 0 0 1-22.19 4.44l-13.31-8.86a16 16 0 0 1-4.44-22.19l52.74-79.13A32 32 0 0 1 82.06 256H160l-69-24.34a32 32 0 0 1-16.5-12.61l-53.6-80.41a16 16 0 0 1 4.44-22.19l13.31-8.88A16 16 0 0 1 60.84 112l50.57 75.83L171.9 208H208l10.37-51.85C220.56 145.19 235.74 96 288 96s67.44 49.18 69.63 60.15L368 208h36.1l60.5-20.17L515.16 112a16 16 0 0 1 22.19-4.44l13.31 8.88a16 16 0 0 1 4.44 22.19l-53.6 80.41a32 32 0 0 1-16.5 12.62L416 256h77.94a32 32 0 0 1 26.62 14.25z"]],
    "spider-black-widow": [576, 512, [], "f718", ["M320 272h-64a8 8 0 0 0-6.4 12.8L276 320l-26.4 35.2A8 8 0 0 0 256 368h64a8 8 0 0 0 6.4-12.8L300 320l26.4-35.2A8 8 0 0 0 320 272zM183.59 5.89L168.42.83A16 16 0 0 0 148.18 11l-25.89 77.63a32 32 0 0 0 1.71 24.43l27.15 54.3L177.1 176h4.67l5.23-26.11a99.35 99.35 0 0 1 3.21-11.79l-20.3-40.58 23.8-71.39a16 16 0 0 0-10.12-20.24zm270.12 82.75L427.82 11A16 16 0 0 0 407.58.84L392.41 5.9a16 16 0 0 0-10.12 20.24l23.8 71.38-20.29 40.58a97.47 97.47 0 0 1 3.2 11.79l5.23 26.11h4.67l25.93-8.64L452 113.07a32 32 0 0 0 1.71-24.43z", "M573.31 349.38l-52.75-79.12A32 32 0 0 0 493.94 256H416l69-24.35a32 32 0 0 0 16.51-12.61l53.6-80.41a16 16 0 0 0-4.44-22.19l-13.31-8.88a16 16 0 0 0-22.2 4.44l-50.57 75.83L404.1 208H368l-10.37-51.85C355.44 145.19 340.26 96 288 96s-67.44 49.18-69.63 60.15L208 208h-36.1l-60.5-20.18L60.84 112a16 16 0 0 0-22.19-4.44l-13.31 8.88a16 16 0 0 0-4.44 22.19L74.5 219A32 32 0 0 0 91 231.65L160 256H82.07a32 32 0 0 0-26.63 14.25L2.69 349.38a16 16 0 0 0 4.44 22.19l13.31 8.88A16 16 0 0 0 42.63 376l48-72h47.06l-60.83 97.34a32.05 32.05 0 0 0-4.86 17V496a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16v-73.1l74.08-118.53c-1 14.05-2.08 28.11-2.08 42.21C192 399.65 232.76 448 288 448s96-48.36 96-101.43c0-14.1-1.07-28.16-2.08-42.21L456 422.9V496a16 16 0 0 0 16 16h16a16 16 0 0 0 16-16v-77.7a32.05 32.05 0 0 0-4.86-17L438.31 304h47.06l48 72a16 16 0 0 0 22.19 4.44l13.31-8.88a16 16 0 0 0 4.44-22.18zm-246.91 5.83A8 8 0 0 1 320 368h-64a8 8 0 0 1-6.4-12.8L276 320l-26.4-35.2A8 8 0 0 1 256 272h64a8 8 0 0 1 6.4 12.8L300 320z"]],
    "spider-web": [576, 512, [], "f719", ["M544 280.13H329.36l107.48 188.18-41.68 23.82L288 304.51 180.84 492.13l-41.68-23.82 107.48-188.18H32v-48h214.64L139.16 43.93l41.68-23.83L288 207.72 395.16 20.1l41.68 23.83-107.48 188.18H544z", "M566.63 233.48l-2.79-2.79A444.29 444.29 0 0 1 447.07 24.37v-.12A32 32 0 0 0 408.24 1a497.38 497.38 0 0 1-240.48 0A32 32 0 0 0 129 24.25v.12A444.29 444.29 0 0 1 12.16 230.69l-2.79 2.79a32 32 0 0 0 0 45.28l2.87 2.87A444.25 444.25 0 0 1 129 487.76 32 32 0 0 0 167.76 511a497.14 497.14 0 0 1 240.48 0A32 32 0 0 0 447 487.76a444.25 444.25 0 0 1 116.76-206.13l2.87-2.87a32 32 0 0 0 0-45.28zM393.45 442.23a562.64 562.64 0 0 0-210.9 0A508.29 508.29 0 0 0 76.22 256.11 508.49 508.49 0 0 0 182.58 69.76a562 562 0 0 0 210.84 0 508.49 508.49 0 0 0 106.36 186.35 508.29 508.29 0 0 0-106.33 186.12zm-23.31-328.86a24 24 0 0 0-18.21-2.72 264.41 264.41 0 0 1-127.86 0A24.05 24.05 0 0 0 195 128.18a235.55 235.55 0 0 1-62 109.39l-1.52 1.52a24 24 0 0 0 0 34l1.56 1.57A235.49 235.49 0 0 1 195 383.89a24 24 0 0 0 29.1 17.46 264.41 264.41 0 0 1 127.86 0A24 24 0 0 0 381 383.89a235.49 235.49 0 0 1 61.88-109.28l1.56-1.57a24 24 0 0 0 0-34l-1.44-1.48a235.47 235.47 0 0 1-61.94-109.36 24.06 24.06 0 0 0-10.92-14.83zM341 350a313.11 313.11 0 0 0-106 0 283.59 283.59 0 0 0-53.66-93.94A283.53 283.53 0 0 0 235 162a313.27 313.27 0 0 0 106 0 283.51 283.51 0 0 0 53.68 94.07A283.59 283.59 0 0 0 341 350z"]],
    "spinner": [512, 512, [], "f110", ["M108.92 355.08a48 48 0 1 0 48 48 48 48 0 0 0-48-48zM256 416a48 48 0 1 0 48 48 48 48 0 0 0-48-48zm208-208a48 48 0 1 0 48 48 48 48 0 0 0-48-48zm-60.92 147.08a48 48 0 1 0 48 48 48 48 0 0 0-48-48zm0-198.16a48 48 0 1 0-48-48 48 48 0 0 0 48 48z", "M108.92 60.92a48 48 0 1 0 48 48 48 48 0 0 0-48-48zM48 208a48 48 0 1 0 48 48 48 48 0 0 0-48-48zM256 0a48 48 0 1 0 48 48 48 48 0 0 0-48-48z"]],
    "spinner-third": [512, 512, [], "f3f4", ["M478.71 364.58zm-22 6.11l-27.83-15.9a15.92 15.92 0 0 1-6.94-19.2A184 184 0 1 1 256 72c5.89 0 11.71.29 17.46.83-.74-.07-1.48-.15-2.23-.21-8.49-.69-15.23-7.31-15.23-15.83v-32a16 16 0 0 1 15.34-16C266.24 8.46 261.18 8 256 8 119 8 8 119 8 256s111 248 248 248c98 0 182.42-56.95 222.71-139.42-4.13 7.86-14.23 10.55-22 6.11z", "M271.23 72.62c-8.49-.69-15.23-7.31-15.23-15.83V24.73c0-9.11 7.67-16.78 16.77-16.17C401.92 17.18 504 124.67 504 256a246 246 0 0 1-25 108.24c-4 8.17-14.37 11-22.26 6.45l-27.84-15.9c-7.41-4.23-9.83-13.35-6.2-21.07A182.53 182.53 0 0 0 440 256c0-96.49-74.27-175.63-168.77-183.38z"]],
    "splotch": [512, 512, [], "f5bc", ["M281.69 124.65c10.48 39.59 18.87 97 105.07 126.52-79.24 40.58-77.61 106.16-79.87 135.83-63.13-47.46-83-67.17-186.41-44.6 16.8-33.68 34-85.06-10.86-146.08 103.53 8.09 124.36-22.42 172.07-71.71", "M472.29 195.89l-67.06-22.95c-19.28-6.6-33.54-20.92-38.14-38.3l-16-60.45C344 47.4 316.89 32 289.26 32c-17.5 0-35.21 6.18-48.17 19.57L195 99.24c-12 12.44-29.84 19.53-48.46 19.53-1.91 0-3.82-.07-5.74-.22l-71.88-5.62c-2.05-.16-4.06-.24-6.05-.24-48.59 0-79.75 46.61-52.95 83.07l38.54 52.4c11.03 15.07 12.77 33.84 4.59 50.24l-28.43 57C6.21 392.24 38.89 431 82.13 431a74.78 74.78 0 0 0 15.94-1.74l70-15.28a72.7 72.7 0 0 1 15.51-1.67 69.56 69.56 0 0 1 41.56 13.4l54.32 40.83a68.21 68.21 0 0 0 41.2 13.46c31.15 0 60.91-20 63.25-50.71l4.7-61.86c1.35-17.8 12.8-33.87 30.63-43l62-31.74c44.88-22.97 39.59-80.18-8.95-96.8zM306.89 387c-63.13-47.46-83-67.17-186.41-44.6 16.8-33.68 34-85.06-10.86-146.08 103.53 8.09 124.36-22.42 172.07-71.71 10.48 39.59 18.87 97 105.07 126.52-79.24 40.62-77.61 106.2-79.87 135.87z"]],
    "spray-can": [512, 512, [], "f5bd", ["M288 32a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm96 96a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm96 96a32 32 0 1 0 32 32 32 32 0 0 0-32-32zM384 32a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm96 96a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm0-32a32 32 0 1 0-32-32 32 32 0 0 0 32 32zM160 256a80 80 0 1 0 80 80 80 80 0 0 0-80-80z", "M224 160H96a96 96 0 0 0-96 96v224a32 32 0 0 0 32 32h256a32 32 0 0 0 32-32V256a96 96 0 0 0-96-96zm-64 256a80 80 0 1 1 80-80 80 80 0 0 1-80 80zm64-384a32 32 0 0 0-32-32h-64a32 32 0 0 0-32 32v96h128z"]],
    "square": [448, 512, [], "f0c8", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-16 368a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16V112a16 16 0 0 1 16-16h288a16 16 0 0 1 16 16z", "M64 400V112a16 16 0 0 1 16-16h288a16 16 0 0 1 16 16v288a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16z"]],
    "square-full": [512, 512, [], "f45c", ["M-1 0v512h512V0zm432 417.33A14.67 14.67 0 0 1 416.33 432H93.67A14.67 14.67 0 0 1 79 417.33V94.67A14.67 14.67 0 0 1 93.67 80h322.66A14.67 14.67 0 0 1 431 94.67z", "M431 417.33A14.67 14.67 0 0 1 416.33 432H93.67A14.67 14.67 0 0 1 79 417.33V94.67A14.67 14.67 0 0 1 93.67 80h322.66A14.67 14.67 0 0 1 431 94.67z"]],
    "square-root": [576, 512, [], "f697", ["M576 24v48a24 24 0 0 1-24 24H357l-97.78 374.52C249.38 503 222.21 512 204.94 512c-18.64 0-35.95-8.5-48.44-28.27L67.62 320H24a24 24 0 0 1-24-24v-48a24 24 0 0 1 24-24h81.47a32 32 0 0 1 28 16.57l58.41 106.1 84.82-322.8A32 32 0 0 1 307.65 0H552a24 24 0 0 1 24 24z", ""]],
    "square-root-alt": [576, 512, [], "f698", ["M576 72a24 24 0 0 1-24 24H357l-97.78 374.52C249.38 503 222.21 512 204.94 512c-18.64 0-35.95-8.5-48.44-28.27L67.62 320H24a24 24 0 0 1-24-24v-48a24 24 0 0 1 24-24h81.47a32 32 0 0 1 28 16.57l58.41 106.1 84.82-322.8A32 32 0 0 1 307.65 0H552a24 24 0 0 1 24 24z", "M571.31 366.06a16 16 0 0 1 0 22.63l-22.62 22.62a16 16 0 0 1-22.63 0L480 365.25l-46.06 46.06a16 16 0 0 1-22.63 0l-22.62-22.62a16 16 0 0 1 0-22.63L434.75 320l-46.06-46.06a16 16 0 0 1 0-22.63l22.62-22.62a16 16 0 0 1 22.63 0L480 274.75l46.06-46.06a16 16 0 0 1 22.63 0l22.62 22.62a16 16 0 0 1 0 22.63L525.25 320z"]],
    "squirrel": [512, 512, [], "f71a", ["M263.48 512C175.39 511.58 97.93 443.62 96 355.46c-.82-37.58 11.81-71.87 32.74-99.54-.27 0-.52.08-.79.08A128 128 0 0 1 128 0c86.2 0 184.54 112.89 137.33 254.86l-34.57 103.85a8 8 0 0 0 5.07 10.12l15.17 5.05a8 8 0 0 0 9.57-3.83l-31.22 93.7c-7.8 23.5 9.43 47.98 34.13 48.25z", "M479.84 448h-30.92c18.19-18.4 30.93-42.12 30.93-64 0-26.55-22.08-52.81-47.85-61.09V224h47.85a32.2 32.2 0 0 0 31.43-38.87C500.84 136.42 466.72 96 415.87 96V64c-48 0-74.22 62.73-89.4 108.29l-97.1 291.47c-7.85 23.58 9.54 48.17 34.4 48.24h232.08a16 16 0 0 0 16-16v-16a32 32 0 0 0-32.01-32zm-64-288a16 16 0 1 1 16 16 16 16 0 0 1-15.97-16z"]],
    "staff": [512, 512, [], "f71b", ["M369.9 284.81l32.25 18.62a16 16 0 0 0 21.85-5.86l19.54-33.79zM96 304v44.1l60.13-60.1H112a16 16 0 0 0-16 16z", "M512 80v103.86a80 80 0 0 1-58 76.92l-168.92 48.27a80.11 80.11 0 0 0-34.62 20.37L74.91 505A24 24 0 0 1 41 505L7 471a24 24 0 0 1 0-33.9L156.13 288l26.48-26.48a176.06 176.06 0 0 1 76.11-44.78L416 171.8V96h-50.32l-11.58 23.15a16 16 0 0 1-21.46 7.16l-57.26-28.63a16 16 0 0 1-7.15-21.46l16-32A80 80 0 0 1 355.78 0H432a80 80 0 0 1 80 80z"]],
    "stamp": [512, 512, [], "f5bf", ["M480 416H32a32 32 0 0 1-32-32v-32a96 96 0 0 1 96-96h66.56A29.44 29.44 0 0 0 192 226.56v-.07c0-31.79-10-62.06-23.31-90.91A93.86 93.86 0 0 1 160 96 96.06 96.06 0 0 1 273.25 1.5C312 8.25 343.74 40.17 350.51 79a94.83 94.83 0 0 1-9.05 60.42c-12.58 24.26-21.46 50.3-21.46 77.67v9.46A29.44 29.44 0 0 0 349.43 256H416a96 96 0 0 1 96 96v32a32 32 0 0 1-32 32z", "M480 416v96H32v-96z"]],
    "star": [576, 512, [], "f005", ["M528.53 171.5l-146.36-21.3-65.43-132.39c-11.71-23.59-45.68-23.89-57.48 0L193.83 150.2 47.47 171.5c-26.27 3.79-36.79 36.08-17.75 54.58l105.91 103-25 145.49c-4.52 26.3 23.22 46 46.48 33.69L288 439.56l130.93 68.69c23.26 12.21 51-7.39 46.48-33.69l-25-145.49 105.91-103c19-18.49 8.48-50.78-17.79-54.57zm-90.89 71l-66.05 64.23 15.63 90.86a12 12 0 0 1-17.4 12.66L288 367.27l-81.82 42.94a12 12 0 0 1-17.4-12.66l15.63-90.86-66-64.23A12 12 0 0 1 145 222l91.34-13.28 40.9-82.81a12 12 0 0 1 21.52 0l40.9 82.81L431 222a12 12 0 0 1 6.64 20.46z", "M437.64 242.46l-66.05 64.23 15.63 90.86a12 12 0 0 1-17.4 12.66L288 367.27l-81.82 42.94a12 12 0 0 1-17.4-12.66l15.63-90.86-66-64.23A12 12 0 0 1 145 222l91.34-13.28 40.9-82.81a12 12 0 0 1 21.52 0l40.9 82.81L431 222a12 12 0 0 1 6.64 20.46z"]],
    "star-and-crescent": [512, 512, [], "f699", ["M509 230.85l-55.27 53.87 13.05 76.07a9.93 9.93 0 0 1-14.45 10.49L384 335.37l-68.33 35.91a9.86 9.86 0 0 1-4.64 1.17 10 10 0 0 1-9.81-11.66l13-76.07L259 230.85a10 10 0 0 1 5.52-17l76.38-11.1 34.16-69.21a10 10 0 0 1 17.86 0l34.16 69.21 76.38 11.1a10 10 0 0 1 5.54 17z", "M0 256C0 114.84 114.84 0 256 0a254.82 254.82 0 0 1 89.75 16.48 15.06 15.06 0 0 1-5.28 29.16c-1.48 0-6.86-.46-9.18-.46C215 45.18 120.47 139.75 120.47 256S215 466.82 331.29 466.82c2.29 0 7.73-.46 9.18-.46a15 15 0 0 1 4.85 29.32A254.9 254.9 0 0 1 256 512C114.84 512 0 397.16 0 256z"]],
    "star-christmas": [512, 512, [], "f7d4", ["M359.15 334.15l-19.9 5-5 19.9 68.8 55.1c7.5 6 17.2-3.7 11.2-11.2zm-206.2 0L98 403c-6 7.5 3.7 17.2 11.2 11.2l68.8-55.1-5-19.9zM359.15 178l55.1-68.8c6-7.5-3.7-17.2-11.2-11.2l-68.8 55 5 19.9zM153 178l19.9-5 5-19.9L109.05 98c-7.5-6-17.2 3.7-11.2 11.2z", "M505.25 264.65l-192.6 48.1-48.1 192.5c-2.2 9-15 9-17.2 0l-48.1-192.5-192.5-48.1c-9-2.2-9-15 0-17.2l192.6-48.1 48.1-192.6c2.2-9 15-9 17.2 0l48.2 192.6 192.5 48.1c8.9 2.2 8.9 15-.1 17.2z"]],
    "star-exclamation": [576, 512, [], "f2f3", ["M528.55 171.5l-146.37-21.3-65.43-132.39c-11.72-23.7-45.68-23.8-57.5 0L193.82 150.2 47.45 171.4c-26.25 3.8-36.77 36.1-17.73 54.6l105.9 103-25.05 145.46c-4.51 26.1 23 46 46.49 33.7L288 439.57l130.94 68.69c23.35 12.3 51-7.5 46.49-33.7l-25.05-145.48 105.9-103c19-18.48 8.52-50.78-17.73-54.58zM288 392a40 40 0 1 1 40.07-40A40 40 0 0 1 288 392zm40.17-223.38l-8 112a8 8 0 0 1-8 7.4h-48.11a8 8 0 0 1-8-7.4l-8-112a8 8 0 0 1 7.39-8.58H320.19a8 8 0 0 1 8 8v.63z", "M288 312a40 40 0 1 0 40.07 40A40 40 0 0 0 288 312zm32.16-152H256a8 8 0 0 0-8 8v.62l8 112a8 8 0 0 0 8 7.4h48.09a8 8 0 0 0 8-7.4l8-112a8 8 0 0 0-7.39-8.58z"]],
    "star-half": [576, 512, [], "f089", ["M545.3 226L439.6 329l25 145.5c4.5 26.1-23 46-46.4 33.7l-130.7-68.6V0a31.62 31.62 0 0 1 28.7 17.8l65.3 132.4 146.1 21.2c26.2 3.8 36.7 36.1 17.7 54.6z", "M110.4 474.5l25-145.5L29.7 226c-19-18.5-8.5-50.8 17.7-54.6l146.1-21.2 65.3-132.4A31.62 31.62 0 0 1 287.5 0v439.6l-130.7 68.6c-23.4 12.3-50.9-7.6-46.4-33.7z"]],
    "star-half-alt": [536, 512, [], "f5c0", ["M526.29,226.11l-106,103,25,145.49c3.64,20.77-13,37.4-31.66,37.4a31.75,31.75,0,0,1-14.84-3.71l-131-68.71V385.34l22.39,11.73,102.22,53.59-19.5-113.45-4.29-24.88,18.14-17.62,82.73-80.38L355.07,197.7l-25-3.64-11.26-22.63L267.75,68.14V0a31.92,31.92,0,0,1,28.81,17.81L362,150.2l146.51,21.31c26.28,3.8,36.81,36.1,17.75,54.6Z", "M90.48,474.5l25-145.5L9.7,226c-19-18.5-8.51-50.8,17.72-54.6l146.24-21.2L239,17.8A31.67,31.67,0,0,1,267.75,0V439.6L136.93,508.2C113.51,520.5,86,500.6,90.48,474.5Z"]],
    "star-of-david": [464, 512, [], "f69a", ["M176,344h-.07l-44-73.93L71,168h39.72l33.33-56H37.11c-28.6,0-46.42,30.38-32,54.59l56.6,95.08L91,310.55l-.09.14L110.72,344Zm160.17-80.7L288.12,344h-.07l-33.4,56h.13L232,438.25,209.22,400H144.05L200,494a37.44,37.44,0,0,0,64,0l56-94h-.19L353,344h.3l19.85-33.33L340.52,256ZM426.89,112H209.35L176,168H393l-19.88,33.33L405.68,256l53.21-89.4c14.41-24.19-3.41-54.58-32-54.58Z", "M91,310.55,58.32,256,5.11,345.41C-9.3,369.62,8.52,400,37.11,400H254.57l33.28-56H71Zm36.86-61.83,48-80.7H176l33.39-56h-.13L232,73.78,254.78,112h65.16L264,18a37.44,37.44,0,0,0-64,0L90.88,201.32,123.5,256Zm331.06,96.69L353.28,168H288.07l44,73.93L393,344H353l-33.22,56H426.89c28.6,0,46.42-30.36,32-54.57Z"]],
    "star-of-life": [480, 512, [], "f621", ["M2.14 155.72l32-55.43A16 16 0 0 1 56 94.43l184 106.43L424 94.42a16 16 0 0 1 21.86 5.84l32 55.43a16 16 0 0 1-5.86 21.87L288 284.19V496a16 16 0 0 1-16 16h-64a16 16 0 0 1-16-16V284.18L8 177.57a16 16 0 0 1-5.86-21.85z", "M477.87 356.55l-32 55.43a16 16 0 0 1-21.87 5.86L240 311.41 56 417.85A16 16 0 0 1 34.15 412l-32-55.43A16 16 0 0 1 8 334.7l184-106.62V16.27a16 16 0 0 1 16-16h64a16 16 0 0 1 16 16v211.82L472 334.7a16 16 0 0 1 5.87 21.85z"]],
    "stars": [512, 512, [], "f762", ["M362.69 53.3L336 0l-26.7 53.3L256 80l53.3 26.7L336 160l26.7-53.3L416 80zM480 192l-16-32-16 32-32 16 32 16 16 32 16-32 32-16z", "M377.09 306.5l-75.9 74 17.9 104.6a23 23 0 0 1-33.3 24.2L192 459.9l-93.8 49.4c-16.6 8.9-36.5-5.3-33.3-24.2l18-104.6-75.9-74C-6.7 293.2.9 270 19.7 267.3L124.49 252l46.9-95.2c8.5-17.2 32.8-17 41.2 0l46.9 95.2 104.8 15.3c18.8 2.7 26.4 25.9 12.8 39.2z"]],
    "steak": [576, 512, [], "f824", ["M514.93 76.66C467.93 23.11 416.29 0 368.86 0 298.28 0 237 51.17 214.11 129.39 165 269.33 1.39 212.34 0 351.66c-1.19 121.62 139.26 164.62 256 160 87.78-3.4 187.32-37.09 270.49-131.85C596.78 299.77 591.6 164 514.93 76.66zm-36.53 261c-76.15 86.75-164.32 107.76-224.82 110.1-37.65 1.38-131.52-6.52-171.23-46.62-2.49-2.51-59.44-61.76 38-104.18 71.64-31.19 132.3-71.24 155.23-149.61C290.35 96.71 327 64 368.86 64c32.58 0 66.45 19 98 54.89 55.14 62.84 60.45 163 11.54 218.78z", "M466.86 118.89C435.31 83 401.44 64 368.86 64c-41.86 0-78.51 32.71-93.29 83.37C252.64 225.74 192 265.79 120.34 297c-97.43 42.42-40.48 101.67-38 104.18 39.71 40.1 133.58 48 171.23 46.62 60.5-2.34 148.67-23.35 224.82-110.1 48.91-55.77 43.61-155.97-11.53-218.81zM384 255.92a32 32 0 1 1 32-32 32 32 0 0 1-32 32z"]],
    "steering-wheel": [496, 512, [], "f622", ["M432,256a185.53,185.53,0,0,1-2.76,32H328l-48,64v85.24a186.89,186.89,0,0,1-64,0V352l-48-64H66.76a186.89,186.89,0,0,1,0-64h94.13A63.69,63.69,0,0,1,216,192h64a63.72,63.72,0,0,1,55.12,32h94.11A185.54,185.54,0,0,1,432,256Z", "M248,72A184,184,0,1,1,64,256,184,184,0,0,1,248,72m0-64C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8Z"]],
    "step-backward": [448, 512, [], "f048", ["M144,292.71V464a16,16,0,0,1-16,16H80a16,16,0,0,1-16-16V48A16,16,0,0,1,80,32h48a16,16,0,0,1,16,16V292.7Z", "M384,64V448c0,27.4-31.9,41.7-52.5,24.6L144,298.34V213.65L331.5,39.41C352.1,22.31,384,36.61,384,64Z"]],
    "step-forward": [448, 512, [], "f051", ["M304,219.29V48a16,16,0,0,1,16-16h48a16,16,0,0,1,16,16V464a16,16,0,0,1-16,16H320a16,16,0,0,1-16-16V219.3Z", "M64,448V64c0-27.4,31.9-41.7,52.5-24.6L304,213.66v84.69L116.5,472.59C95.9,489.69,64,475.39,64,448Z"]],
    "stethoscope": [512, 512, [], "f0f1", ["M480 231.42V344c0 92.6-79 168-176 168-95.39 0-173.28-72.78-175.9-163.17h64.1c2.7 55.1 51.9 99.2 111.9 99.2 61.8 0 112-46.7 112-104V231.47c-.1.53 63.9.53 63.9-.05z", "M448 112a64 64 0 1 0 64 64 64 64 0 0 0-64-64zm0 80a16 16 0 1 1 16-16 16 16 0 0 1-16 16zM300.7 13.07L237.8.47a23.94 23.94 0 0 0-28.2 18.8L206.4 35a23.94 23.94 0 0 0 18.8 28.2l30.7 6.1.1 122.7a96 96 0 0 1-192 0l-.1-72V69.37l30.7-6.1a23.94 23.94 0 0 0 18.8-28.2l-3.1-15.7A23.94 23.94 0 0 0 82.1.57L19.3 13A24.09 24.09 0 0 0 0 36.57V192c0 88.22 71.78 160 160 160s160-71.78 160-160V36.57a24 24 0 0 0-19.3-23.5z"]],
    "sticky-note": [448, 512, [], "f249", ["M448 352H336a16 16 0 0 0-16 16v112H24a23.94 23.94 0 0 1-24-23.88V56a23.94 23.94 0 0 1 23.88-24H424a23.94 23.94 0 0 1 24 23.88V352z", "M320 480V368a16 16 0 0 1 16-16h112v6.1a23.9 23.9 0 0 1-7 16.9l-98 98a24 24 0 0 1-17 7z"]],
    "stocking": [384, 512, [], "f7d5", ["M367.29 0h-288a16 16 0 0 0-16 16v64a16 16 0 0 0 16 16h288a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16zM224 368a111.66 111.66 0 0 0 35.42 81.72L280 436a159.58 159.58 0 0 0 71.2-133.1V257a113.64 113.64 0 0 0-15.2-1 112 112 0 0 0-112 112z", "M259.42 449.72l-61.13 40.78a128 128 0 0 1-142-213l39-26V96h255.9v161a113.64 113.64 0 0 0-15.19-1 112 112 0 0 0-76.58 193.72z"]],
    "stomach": [512, 512, [], "f623", ["M384 320c-17.27-17.27-42.62-22.06-65.21-14.06-7.13 52.25-44.66 86.4-77.19 100.08a13.08 13.08 0 0 0-1.5 23.47 144.7 144.7 0 0 0 28.73 12.61c43.37 13.59 98.26 4.59 137.7-34.41a140 140 0 0 0 38.68-72.35c-21.54 6.03-44.96.91-61.21-15.34zM273.13 160H256a64 64 0 0 1-64-64V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v80a128 128 0 0 0 128 128 127.42 127.42 0 0 1 17.13-64z", "M384 96c-17.33 0-76.15 4-110.87 64a127.56 127.56 0 0 0-16.5 51.31C256.07 217 256 222.1 256 224v64a64 64 0 0 1-64 64h-64A128 128 0 0 0 0 480v16a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-16c0-37.63 34-51.21 53.92-51.21 17.11 0 29.59 6.71 41.07 18.2 63.07 63.07 129.84 65 146.71 65h2.66C420.84 512 512 420.83 512 308.35V224A128 128 0 0 0 384 96zm64 211c0 37.73-14.65 74.2-41.48 100.72-39.44 39-94.33 48-137.7 34.41a144.7 144.7 0 0 1-28.73-12.61A13.08 13.08 0 0 1 241.6 406c36.11-15.19 78.4-55.6 78.4-118v-64c.83-21.86 20.15-64 64-64a64.07 64.07 0 0 1 64 64z"]],
    "stop": [448, 512, [], "f04d", ["M400 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zm-16 352a32 32 0 0 1-32 32H96a32 32 0 0 1-32-32V128a32 32 0 0 1 32-32h256a32 32 0 0 1 32 32z", "M64 384V128a32 32 0 0 1 32-32h256a32 32 0 0 1 32 32v256a32 32 0 0 1-32 32H96a32 32 0 0 1-32-32z"]],
    "stop-circle": [512, 512, [], "f28d", ["M256 8C119 8 8 119 8 256s111 248 248 248 248-111 248-248S393 8 256 8zm96 328a16 16 0 0 1-16 16H176a16 16 0 0 1-16-16V176a16 16 0 0 1 16-16h160a16 16 0 0 1 16 16z", "M352 176v160a16 16 0 0 1-16 16H176a16 16 0 0 1-16-16V176a16 16 0 0 1 16-16h160a16 16 0 0 1 16 16z"]],
    "stopwatch": [448, 512, [], "f2f2", ["M224 96C109.12 96 16 189.12 16 304s93.12 208 208 208 208-93.12 208-208S338.88 96 224 96zm32 240a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V208.5a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16z", "M240 192.5h-32a16 16 0 0 0-16 16V336a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V208.5a16 16 0 0 0-16-16zm188.53-48.57l-28.3-28.3a12 12 0 0 0-17 0l-27.45 27.45a209.14 209.14 0 0 1 42.8 47.8l.55-.55 29.4-29.4a12 12 0 0 0 0-17zM280 0H168a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h24v34.45a210 210 0 0 1 64 0V64h24a16 16 0 0 0 16-16V16a16 16 0 0 0-16-16z"]],
    "store": [616, 512, [], "f54e", ["M547.69,286.8a102.1,102.1,0,0,0,16.4-3.6V480a32,32,0,0,1-32,32H84a32,32,0,0,1-32-32V283.2a125.89,125.89,0,0,0,16.4,3.6,135.49,135.49,0,0,0,18,1.2,132.81,132.81,0,0,0,29.51-3.8V384H500V284.2a127.12,127.12,0,0,0,29.51,3.8A138.38,138.38,0,0,0,547.69,286.8Z", "M602,118.6c33.6,53.6,3.8,128-59,136.4a102.9,102.9,0,0,1-13.7.9,99.08,99.08,0,0,1-73.81-33.1A98.83,98.83,0,0,1,316,230.88a96.26,96.26,0,0,1-8.08-8.08,98.9,98.9,0,0,1-139.62,8,97.4,97.4,0,0,1-8-8,98.75,98.75,0,0,1-73.81,33.1,104.6,104.6,0,0,1-13.7-.9C10.12,246.5-19.58,172.1,14,118.6L78.83,15A32,32,0,0,1,106,0H510a32,32,0,0,1,27.07,15Z"]],
    "store-alt": [640, 512, [], "f54f", ["M320 384H128V224H64v256a32 32 0 0 0 32 32h256a32 32 0 0 0 32-32V224h-64zm192-160v272a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V224z", "M634.55 142.2c14.1 21.3-1.1 49.8-26.6 49.8H32.05c-25.6 0-40.8-28.5-26.6-49.8l85.3-128A31.87 31.87 0 0 1 117.35 0h405.2a32.18 32.18 0 0 1 26.7 14.2z"]],
    "stream": [512, 512, [], "f550", ["M512 224v64a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16v-64a16 16 0 0 1 16-16h416a16 16 0 0 1 16 16z", "M432 32H16A16 16 0 0 0 0 48v64a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16zm0 352H16a16 16 0 0 0-16 16v64a16 16 0 0 0 16 16h416a16 16 0 0 0 16-16v-64a16 16 0 0 0-16-16z"]],
    "street-view": [512, 512, [], "f21d", ["M512 416c0 53-114.62 96-256 96S0 469 0 416c0-37.95 58.87-70.66 144.1-86.24a63.94 63.94 0 0 0 15.9 13.65v22.94C93.48 375.7 48 394.4 48 416c0 30.93 93.12 56 208 56s208-25.07 208-56c0-21.6-45.48-40.31-112-49.65v-22.94a63.94 63.94 0 0 0 15.9-13.65C453.13 345.34 512 378.05 512 416z", "M256 128a64 64 0 1 0-64-64 64 64 0 0 0 64 64zm48 16h-11.8a85.9 85.9 0 0 1-72.4 0H208a48 48 0 0 0-48 48v96a32 32 0 0 0 32 32v96a32 32 0 0 0 32 32h64a32 32 0 0 0 32-32v-96a32 32 0 0 0 32-32v-96a48 48 0 0 0-48-48z"]],
    "stretcher": [640, 512, [], "f825", ["M515.78 394.93a62.25 62.25 0 0 0-56.18-7.3l-43-37.63L524 256h-97.2L368 307.48 309.17 256H212l107.4 94-43 37.63a62.25 62.25 0 0 0-56.18 7.3 64.11 64.11 0 1 0 98.53 40.69l49.25-43.1 49.25 43.1a64 64 0 1 0 98.53-40.69zM256 464a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm224 0a16 16 0 1 1 16-16 16 16 0 0 1-16 16z", "M640 160v32a32 32 0 0 1-32 32H177.62a64 64 0 0 1-47.84-21.48l-121.7-128a32 32 0 0 1 2.66-45.17L34.66 8.08a32 32 0 0 1 45.18 2.66L192 128h416a32 32 0 0 1 32 32z"]],
    "strikethrough": [512, 512, [], "f0cc", ["M512 240v32a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h480a16 16 0 0 1 16 16z", "M410.15 320a114.16 114.16 0 0 1 5.27 24.35A123.69 123.69 0 0 1 292.45 480h-68A128 128 0 0 1 110 409.24l-.52-1a16 16 0 0 1 7.15-21.47l42.94-21.47a16 16 0 0 1 21.47 7.16A49.87 49.87 0 0 0 225.66 400h66.79A43.59 43.59 0 0 0 336 356.45 43 43 0 0 0 315.76 320zM293.9 224l-87.17-26.83A43.55 43.55 0 0 1 219.55 112h66.79A49.86 49.86 0 0 1 331 139.57a16 16 0 0 0 21.47 7.16l42.94-21.47a16 16 0 0 0 7.15-21.46l-.52-1A128 128 0 0 0 287.51 32h-68a123.68 123.68 0 0 0-123 135.64c2 20.89 10.1 39.83 21.78 56.36z"]],
    "stroopwafel": [512, 512, [], "f551", ["M188.12 210.74L142.86 256l45.25 45.25L233.37 256zm22.63 113.14L256 369.14l45.26-45.26L256 278.63zm90.5-135.76L256 142.86l-45.25 45.25L256 233.37zM256 0C114.62 0 0 114.62 0 256s114.62 256 256 256 256-114.62 256-256S397.38 0 256 0zm186.68 295.6l-11.31 11.31a8 8 0 0 1-11.31 0l-28.29-28.29-45.25 45.25 33.94 33.94 17-17a8 8 0 0 1 11.31 0l11.31 11.31a8 8 0 0 1 0 11.31l-17 17 17 17a8 8 0 0 1 0 11.31L408.74 420a8 8 0 0 1-11.31 0l-17-17-17 17a8 8 0 0 1-11.31 0l-11.31-11.31a8 8 0 0 1 0-11.31l17-17-33.91-33.89-45.26 45.26L306.93 420a8 8 0 0 1 0 11.31l-11.31 11.31a8 8 0 0 1-11.31 0L256 414.39l-28.29 28.29a8 8 0 0 1-11.31 0l-11.31-11.31a8 8 0 0 1 0-11.31l28.29-28.29-45.25-45.26-33.94 33.94 17 17a8 8 0 0 1 0 11.31L159.85 420a8 8 0 0 1-11.31 0l-17-17-17 17a8 8 0 0 1-11.31 0L92 408.73a8 8 0 0 1 0-11.31l17-17-17-17a8 8 0 0 1 0-11.31l11.31-11.31a8 8 0 0 1 11.31 0l17 17 33.94-33.94-45.25-45.25L92 306.93a8 8 0 0 1-11.31 0L69.32 295.6a8 8 0 0 1 0-11.31L97.61 256l-28.29-28.29a8 8 0 0 1 0-11.31l11.31-11.31a8 8 0 0 1 11.31 0l28.29 28.29 45.25-45.26-33.94-33.94-17 17a8 8 0 0 1-11.31 0L92 159.84a8 8 0 0 1 0-11.31l17-17-17-17a8 8 0 0 1 0-11.31L103.26 92a8 8 0 0 1 11.31 0l17 17 17-17a8 8 0 0 1 11.31 0l11.31 11.31a8 8 0 0 1 0 11.31l-17 17 33.91 33.88 45.26-45.25L205.07 92a8 8 0 0 1 0-11.31l11.31-11.31a8 8 0 0 1 11.31 0L256 97.61l28.29-28.29a8 8 0 0 1 11.31 0l11.31 11.31a8 8 0 0 1 0 11.31l-28.29 28.29 45.26 45.25 33.94-33.94-17-17a8 8 0 0 1 0-11.31L352.16 92a8 8 0 0 1 11.31 0l17 17 17-17a8 8 0 0 1 11.31 0L420 103.26a8 8 0 0 1 0 11.31l-17 17 17 17a8 8 0 0 1 0 11.31l-11.31 11.31a8 8 0 0 1-11.31 0l-17-17-33.88 33.91 45.25 45.26L420 205.07a8 8 0 0 1 11.31 0l11.31 11.31a8 8 0 0 1 0 11.31L414.39 256l28.29 28.28a8 8 0 0 1 0 11.32zm-164-39.6l45.26 45.25 45.2-45.25-45.25-45.26z", "M442.68 284.28L414.39 256l28.27-28.31a8 8 0 0 0 0-11.31l-11.31-11.31a8 8 0 0 0-11.31 0l-28.29 28.29-45.25-45.26 33.94-33.94 17 17a8 8 0 0 0 11.31 0L420 159.82a8 8 0 0 0 0-11.31l-17-17 17-17a8 8 0 0 0 0-11.31L408.72 92a8 8 0 0 0-11.31 0l-17 17-17-17a8 8 0 0 0-11.31 0l-11.31 11.31a8 8 0 0 0 0 11.31l17 17-33.94 33.94-45.26-45.25 28.29-28.29a8 8 0 0 0 0-11.31L295.6 69.32a8 8 0 0 0-11.31 0L256 97.61l-28.31-28.27a8 8 0 0 0-11.31 0l-11.31 11.31a8 8 0 0 0 0 11.31l28.29 28.29-45.26 45.25-33.94-33.94 17-17a8 8 0 0 0 0-11.31L159.82 92a8 8 0 0 0-11.31 0l-17 17-17-17a8 8 0 0 0-11.31 0L92 103.28a8 8 0 0 0 0 11.31l17 17-17 17a8 8 0 0 0 0 11.31l11.31 11.31a8 8 0 0 0 11.31 0l17-17 33.94 33.94-45.25 45.26-28.37-28.32a8 8 0 0 0-11.31 0L69.32 216.4a8 8 0 0 0 0 11.31L97.61 256l-28.29 28.29a8 8 0 0 0 0 11.31l11.34 11.33a8 8 0 0 0 11.31 0l28.29-28.29 45.25 45.25-33.94 33.94-17-17a8 8 0 0 0-11.31 0L92 352.17a8 8 0 0 0 0 11.31l17 17-17 17a8 8 0 0 0 0 11.31L103.29 420a8 8 0 0 0 11.31 0l17-17 17 17a8 8 0 0 0 11.31 0l11.31-11.31a8 8 0 0 0 0-11.31l-17-17 33.94-33.94 45.25 45.26-28.29 28.29a8 8 0 0 0 0 11.31l11.31 11.31a8 8 0 0 0 11.31 0L256 414.39l28.31 28.27a8 8 0 0 0 11.31 0l11.31-11.31a8 8 0 0 0 0-11.31l-28.29-28.29 45.26-45.26 33.94 33.94-17 17a8 8 0 0 0 0 11.31L352.18 420a8 8 0 0 0 11.31 0l17-17 17 17a8 8 0 0 0 11.31 0l11.31-11.31a8 8 0 0 0 0-11.31l-17-17 17-17a8 8 0 0 0 0-11.31l-11.31-11.31a8 8 0 0 0-11.31 0l-17 17-33.94-33.94 45.25-45.25 28.29 28.29a8 8 0 0 0 11.31 0l11.31-11.31a8 8 0 0 0-.03-11.27zM256 142.86l45.25 45.26L256 233.37l-45.25-45.26zm-67.89 158.39L142.86 256l45.26-45.26L233.37 256zM256 369.14l-45.25-45.26L256 278.63l45.26 45.25zm67.89-67.89L278.63 256l45.26-45.26L369.14 256z"]],
    "subscript": [512, 512, [], "f12c", ["M336 32h-67a16 16 0 0 0-13.14 6.87l-79.9 115-79.9-115A16 16 0 0 0 83 32H16A16 16 0 0 0 0 48v48a16 16 0 0 0 16 16h33.48l77.81 112-77.81 112H16a16 16 0 0 0-16 16v48a16 16 0 0 0 16 16h67a16 16 0 0 0 13.14-6.87l79.9-115 79.9 115A16 16 0 0 0 269 416h67a16 16 0 0 0 16-16v-48a16 16 0 0 0-16-16h-33.48l-77.81-112 77.81-112H336a16 16 0 0 0 16-16V48a16 16 0 0 0-16-16z", "M496 416h-16V272a16 16 0 0 0-16-16h-48a16 16 0 0 0-14.29 8.83l-16 32A16 16 0 0 0 400 320h16v96h-16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "subway": [448, 512, [], "f239", ["M176 256a24 24 0 0 0 24-24V120a24 24 0 0 0-24-24H72a24 24 0 0 0-24 24v112a24 24 0 0 0 24 24zM376 96H272a24 24 0 0 0-24 24v112a24 24 0 0 0 24 24h104a24 24 0 0 0 24-24V120a24 24 0 0 0-24-24zm5 401.72L318 448H130l-63 49.72A8 8 0 0 0 72 512h304a8 8 0 0 0 5-14.28z", "M130 448h188c68.4 0 130-44.19 130-96V96c0-53-63-96-128-96H128C64 0 0 43 0 96v256c0 52 61.82 96 130 96zm222-64a48 48 0 1 1 48-48 48 48 0 0 1-48 48zM248 120a24 24 0 0 1 24-24h104a24 24 0 0 1 24 24v112a24 24 0 0 1-24 24H272a24 24 0 0 1-24-24zm-200 0a24 24 0 0 1 24-24h104a24 24 0 0 1 24 24v112a24 24 0 0 1-24 24H72a24 24 0 0 1-24-24zm48 168a48 48 0 1 1-48 48 48 48 0 0 1 48-48z"]],
    "suitcase": [512, 512, [], "f0f2", ["M80 480h48V128H80zm304-352v352h48V128z", "M336 32H176a48 48 0 0 0-48 48v400h256V80a48 48 0 0 0-48-48zm-16 96H192V96h128zm144 0h-32v352h32a48 48 0 0 0 48-48V176a48 48 0 0 0-48-48zM0 176v256a48 48 0 0 0 48 48h32V128H48a48 48 0 0 0-48 48z"]],
    "suitcase-rolling": [384, 512, [], "f5c1", ["M144 48h96v112h48V48a48 48 0 0 0-48-48h-96a48 48 0 0 0-48 48v112h48zM64 496a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-16H64zm192 0a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-16h-64zm56-240H72a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h240a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8zm0 96H72a8 8 0 0 0-8 8v16a8 8 0 0 0 8 8h240a8 8 0 0 0 8-8v-16a8 8 0 0 0-8-8z", "M336 160H48a48 48 0 0 0-48 48v224a48 48 0 0 0 48 48h288a48 48 0 0 0 48-48V208a48 48 0 0 0-48-48zm-16 216a8 8 0 0 1-8 8H72a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h240a8 8 0 0 1 8 8zm0-96a8 8 0 0 1-8 8H72a8 8 0 0 1-8-8v-16a8 8 0 0 1 8-8h240a8 8 0 0 1 8 8z"]],
    "sun": [512, 512, [], "f185", ["M502.42 240.5l-94.7-47.3 33.5-100.4c4.5-13.6-8.4-26.5-21.9-21.9l-100.4 33.5-47.41-94.8a17.31 17.31 0 0 0-31 0l-47.3 94.7L92.7 70.8c-13.6-4.5-26.5 8.4-21.9 21.9l33.5 100.4-94.7 47.4a17.31 17.31 0 0 0 0 31l94.7 47.3-33.5 100.5c-4.5 13.6 8.4 26.5 21.9 21.9l100.41-33.5 47.3 94.7a17.31 17.31 0 0 0 31 0l47.31-94.7 100.4 33.5c13.6 4.5 26.5-8.4 21.9-21.9l-33.5-100.4 94.7-47.3a17.33 17.33 0 0 0 .2-31.1zm-155.9 106c-49.91 49.9-131.11 49.9-181 0a128.13 128.13 0 0 1 0-181c49.9-49.9 131.1-49.9 181 0a128.13 128.13 0 0 1 0 181z", "M352 256a96 96 0 1 1-96-96 96.15 96.15 0 0 1 96 96z"]],
    "sun-cloud": [640, 512, [], "f763", ["M429.4 384H384a95.17 95.17 0 0 1-58.6-20.5c-49.6 32-116.5 26.4-159.9-16.9a128 128 0 0 1 181-181 125.41 125.41 0 0 1 18.1 23.4 112.64 112.64 0 0 1 62.6-54.5l13.9-41.7c4.5-13.6-8.4-26.5-21.9-21.9l-100.4 33.5-47.3-94.8a17.31 17.31 0 0 0-31 0l-47.3 94.7L92.7 70.8c-13.6-4.5-26.5 8.4-21.9 21.9l33.5 100.4-94.7 47.4a17.31 17.31 0 0 0 0 31l94.7 47.3-33.5 100.5c-4.5 13.6 8.4 26.5 21.9 21.9l100.4-33.5 47.3 94.7a17.31 17.31 0 0 0 31 0l47.3-94.7 100.4 33.5c13.6 4.5 26.5-8.4 21.9-21.9zm-92.5-179.3a96.36 96.36 0 1 0-33.8 134.5A95.22 95.22 0 0 1 288 288c0-35.8 19.8-66.8 48.9-83.3z", "M640 288a64.06 64.06 0 0 1-64 64H384a64 64 0 0 1 0-128c.6 0 1.1.2 1.6.2a79.75 79.75 0 0 1 157.7 9A63.72 63.72 0 0 1 640 288z"]],
    "sun-dust": [512, 512, [], "f764", ["M160 256a95.68 95.68 0 0 0 28.1 67.8l135.7-135.7A96 96 0 0 0 160 256zM419.3 70.8l-100.4 33.5-47.4-94.7a17.31 17.31 0 0 0-31 0l-47.3 94.7L92.7 70.8c-13.6-4.5-26.5 8.4-21.9 21.9l33.5 100.4-94.7 47.4a17.31 17.31 0 0 0 0 31l94.7 47.3-33.5 100.5A16.86 16.86 0 0 0 75 437l90.5-90.5a128 128 0 0 1 181-181L437 75a16.86 16.86 0 0 0-17.7-4.2z", "M160 448a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm320-256a32 32 0 1 0-32-32 32 32 0 0 0 32 32zm-96 96a32 32 0 1 0-32 32 32 32 0 0 0 32-32zm-144 64a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm160 0a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm80 96a32 32 0 1 0 32 32 32 32 0 0 0-32-32zm0-192a32 32 0 1 0 32 32 32 32 0 0 0-32-32zM320 448a32 32 0 1 0 32 32 32 32 0 0 0-32-32z"]],
    "sun-haze": [640, 512, [], "f765", ["M471.7 193.1l33.5-100.4c4.5-13.6-8.4-26.5-21.9-21.9l-100.4 33.5-47.4-94.7a17.31 17.31 0 0 0-31 0l-47.3 94.7-100.5-33.5c-13.6-4.5-26.5 8.4-21.9 21.9l33.5 100.4L74.6 240h119c3.4-27.2 15-53.6 35.9-74.5a128.13 128.13 0 0 1 181 0c20.9 20.9 32.5 47.3 35.9 74.5h119zM320 160c-47.5 0-86.7 34.7-94.4 80h188.8c-7.7-45.3-46.9-80-94.4-80z", "M80 336h336a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16H80a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16zm544-48H496a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zM208 464H80a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h128a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm416 0H288a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h336a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zm-48-56v-16a16 16 0 0 0-16-16H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h544a16 16 0 0 0 16-16z"]],
    "sunglasses": [576, 512, [], "f892", ["M574.09 280.38L528.75 98.66a87.94 87.94 0 0 0-113.19-62.14l-15.25 5.08a16 16 0 0 0-10.12 20.25L395.25 77a16 16 0 0 0 20.22 10.13l13.19-4.39c10.87-3.63 23-3.57 33.15 1.73a39.59 39.59 0 0 1 20.38 25.81l38.47 153.83a276.7 276.7 0 0 0-81.22-12.47c-34.75 0-74 7-114.85 26.75h-73.18c-40.85-19.75-80.07-26.75-114.85-26.75a276.75 276.75 0 0 0-81.22 12.45l38.47-153.8a39.61 39.61 0 0 1 20.38-25.82c10.15-5.29 22.28-5.34 33.15-1.73l13.16 4.39A16 16 0 0 0 180.75 77l5.06-15.19a16 16 0 0 0-10.12-20.21l-15.25-5.08A87.95 87.95 0 0 0 47.25 98.65L1.91 280.38A75.35 75.35 0 0 0 0 295.86v70.25C0 429 51.59 480 115.19 480h37.12c60.28 0 110.38-45.94 114.88-105.37l2.93-38.63h35.76l2.93 38.63c4.5 59.43 54.6 105.37 114.88 105.37h37.12C524.41 480 576 429 576 366.13v-70.25a62.67 62.67 0 0 0-1.91-15.5zM203.38 369.8c-2 25.9-24.41 46.2-51.07 46.2h-37.12C87 416 64 393.63 64 366.11v-37.55a217.35 217.35 0 0 1 72.59-12.9 196.51 196.51 0 0 1 69.91 12.9zM512 366.13c0 27.5-23 49.87-51.19 49.87h-37.12c-26.69 0-49.1-20.3-51.07-46.2l-3.12-41.24a196.55 196.55 0 0 1 69.94-12.9A217.41 217.41 0 0 1 512 328.58z", "M64.19 367.9c0-.61-.19-1.18-.19-1.8 0 27.53 23 49.9 51.19 49.9h37.12c26.66 0 49.1-20.3 51.07-46.2l3.12-41.24c-14-5.29-28.31-8.38-42.78-10.42zm404-50l-95.83 47.91.3 4c2 25.9 24.38 46.2 51.07 46.2h37.12C489 416 512 393.63 512 366.13v-37.55a227.76 227.76 0 0 0-43.85-10.66z"]],
    "sunrise": [576, 512, [], "f766", ["M250.9 374.45C230.3 383 214.6 398 204.3 416h167.2c-23.8-41.65-75.1-60.35-120.6-41.55zm260.8-20.1l-106.5-7.6-7.6-106.5a17.5 17.5 0 0 0-28.9-12l-80.7 70-80.7-70a17.5 17.5 0 0 0-28.9 12l-7.6 106.5-106.5 7.6a17.5 17.5 0 0 0-12 28.9L80.7 416h87.6c.2-.5.2-1 .4-1.4 27.3-65.8 102.9-97.2 168.7-69.9a128.68 128.68 0 0 1 70.3 71.3h87.6l28.4-32.7a17.5 17.5 0 0 0-12-28.95z", "M560 464H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h544a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zM190.8 128H256v80a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16v-80h65.2c14.3 0 21.4-17.3 11.2-27.4L300 5a17 17 0 0 0-24 0l-96.4 95.7c-10.2 9.95-3 27.3 11.2 27.3z"]],
    "sunset": [576, 512, [], "f767", ["M250.9 374.5c-20.6 8.5-36.3 23.5-46.6 41.5h167.2c-23.8-41.6-75.1-60.3-120.6-41.5zm260.8-20.1l-106.5-7.6-7.6-106.5a17.5 17.5 0 0 0-28.9-12l-80.7 70-80.7-70a17.5 17.5 0 0 0-28.9 12l-7.6 106.5-106.5 7.6a17.5 17.5 0 0 0-12 28.9L80.7 416h87.6c.2-.5.2-1 .4-1.4 27.3-65.8 102.9-97.2 168.7-69.9a128.68 128.68 0 0 1 70.3 71.3h87.6l28.4-32.7a17.5 17.5 0 0 0-12-28.9z", "M560 464H16a16 16 0 0 0-16 16v16a16 16 0 0 0 16 16h544a16 16 0 0 0 16-16v-16a16 16 0 0 0-16-16zM276 219a17 17 0 0 0 24 0l96.4-95.7c10.1-10.1 3-27.4-11.3-27.4H320V16a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v80h-65.2c-14.3 0-21.4 17.3-11.2 27.4z"]],
    "superscript": [512, 512, [], "f12b", ["M336 96h-67a16 16 0 0 0-13.14 6.87l-79.9 115-79.9-115A16 16 0 0 0 83 96H16a16 16 0 0 0-16 16v48a16 16 0 0 0 16 16h33.48l77.81 112-77.81 112H16a16 16 0 0 0-16 16v48a16 16 0 0 0 16 16h67a16 16 0 0 0 13.14-6.87l79.9-115 79.9 115A16 16 0 0 0 269 480h67a16 16 0 0 0 16-16v-48a16 16 0 0 0-16-16h-33.48l-77.81-112 77.81-112H336a16 16 0 0 0 16-16v-48a16 16 0 0 0-16-16z", "M496 192h-16V48a16 16 0 0 0-16-16h-48a16 16 0 0 0-14.29 8.83l-16 32A16 16 0 0 0 400 96h16v96h-16a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h96a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z"]],
    "surprise": [496, 512, [], "f5c2", ["M248,8C111,8,0,119,0,256S111,504,248,504,496,393,496,256,385,8,248,8ZM136,208a32,32,0,1,1,32,32A32,32,0,0,1,136,208ZM248,416a64,64,0,1,1,64-64A64,64,0,0,1,248,416Zm80-176a32,32,0,1,1,32-32A32,32,0,0,1,328,240Z", "M328,176a32,32,0,1,0,32,32A32,32,0,0,0,328,176Zm-160,0a32,32,0,1,0,32,32A32,32,0,0,0,168,176Z"]],
    "swatchbook": [512, 512, [], "f5c3", ["M64,256h64V192H64Zm370.66-88.29h0L344.5,77.36a31.83,31.83,0,0,0-45-.07h0l-.07.07L224,152.88V424L434.66,212.9A32,32,0,0,0,434.66,167.71ZM64,128h64V64H64ZM480,320H373.09L186.68,506.51c-2.06,2.07-4.5,3.58-6.68,5.49H480a32,32,0,0,0,32-32V352A32,32,0,0,0,480,320Z", "M160,0H32A32,32,0,0,0,0,32V416a96,96,0,0,0,192,0V32A32,32,0,0,0,160,0ZM96,440a24,24,0,1,1,24-24A24,24,0,0,1,96,440Zm32-184H64V192h64Zm0-128H64V64h64Z"]],
    "swimmer": [640, 512, [], "f5c4", ["M538 120L437.68 98.47a112.22 112.22 0 0 0-88.56 18.38L269.1 174a111.54 111.54 0 0 0-26.72 27l-68.63 98a92 92 0 0 1 15.86 11.58c3.54 3.26 15.27 9.42 34.39 9.42s30.86-6.16 34.39-9.42c16-14.77 34.5-22.58 53.46-22.58h16.3c19 0 37.45 7.81 53.46 22.58 3.54 3.26 15.27 9.42 34.39 9.42s30.86-6.16 34.39-9.42c14.86-13.71 31.88-21.12 49.39-22.16l-112.84-80.6 18-12.86a16.22 16.22 0 0 1 12.62-2.61l100.35 21.53A48 48 0 0 0 538 120zM112 96a80 80 0 1 0 80 80 80 80 0 0 0-80-80z", "M640 368v32a16 16 0 0 1-16 16h-16c-38.62 0-72.72-12.18-96-31.84-23.28 19.65-57.38 31.84-96 31.84s-72.72-12.18-96-31.84C296.72 403.81 262.62 416 224 416s-72.72-12.18-96-31.84C104.72 403.81 70.62 416 32 416H16a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h16c26 0 45.8-8.42 56.07-17.9 8.9-8.21 19.66-14.1 31.77-14.1h16.3c12.11 0 22.87 5.89 31.77 14.1C178.2 343.58 198 352 224 352s45.8-8.42 56.07-17.9c8.9-8.21 19.66-14.1 31.77-14.1h16.3c12.11 0 22.87 5.89 31.77 14.1C370.2 343.58 390 352 416 352s45.8-8.42 56.07-17.9c8.9-8.21 19.66-14.1 31.77-14.1h16.3c12.11 0 22.87 5.89 31.77 14.1C562.2 343.58 582 352 608 352h16a16 16 0 0 1 16 16z"]],
    "swimming-pool": [640, 512, [], "f5c5", ["M189.61 374.57A86.6 86.6 0 0 0 160 356.5V128a96 96 0 0 1 192 0v16a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-16a32 32 0 0 0-64 0v96h192v-96a96 96 0 0 1 192 0v16a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-16a32 32 0 0 0-64 0v228.51a86.44 86.44 0 0 0-29.61 18.07c-3.53 3.26-15.27 9.42-34.39 9.42v-96H224v96c-19.12 0-30.86-6.16-34.39-9.43z", "M0 464v-32a16 16 0 0 1 16-16h16c26 0 45.8-8.42 56.07-17.9 8.9-8.21 19.66-14.1 31.77-14.1h16.3c12.11 0 22.87 5.89 31.77 14.1C178.2 407.58 198 416 224 416s45.8-8.42 56.07-17.9c8.9-8.21 19.66-14.1 31.77-14.1h16.3c12.11 0 22.87 5.89 31.77 14.1C370.2 407.58 390 416 416 416s45.8-8.42 56.07-17.9c8.9-8.21 19.66-14.1 31.77-14.1h16.3c12.11 0 22.87 5.89 31.77 14.1C562.2 407.58 582 416 608 416h16a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16h-16c-38.62 0-72.72-12.18-96-31.84-23.28 19.65-57.38 31.84-96 31.84s-72.72-12.18-96-31.84C296.72 467.81 262.62 480 224 480s-72.72-12.18-96-31.84C104.72 467.81 70.62 480 32 480H16a16 16 0 0 1-16-16z"]],
    "sword": [512, 512, [], "f71c", ["M267.88 340.11l-96-96L400 16 493.73.16a16 16 0 0 1 18.1 18.11L496 112z", "M4.06 425a13.91 13.91 0 0 1 0-19.64l17.28-17.29a13.92 13.92 0 0 1 16-2.6l29.31 14.63 53.43-53.43-53.39-80.09a16 16 0 0 1 2-20.19l18.79-18.8a16 16 0 0 1 22.62 0l174.3 174.3a16 16 0 0 1 0 22.63l-18.8 18.79a16 16 0 0 1-20.18 2l-80.09-53.39-53.43 53.43 14.62 29.26a13.85 13.85 0 0 1-2.6 16l-17.29 17.29a13.88 13.88 0 0 1-19.63 0z"]],
    "swords": [512, 512, [], "f71d", ["M153.37 278.63L100 332l-24.69-24.69a16 16 0 0 0-22.62 0l-17.54 17.53a16 16 0 0 0-2.79 18.87l31.64 59-59.31 59.35a16 16 0 0 0 0 22.63l22.62 22.62a16 16 0 0 0 22.63 0L109.25 448l59 31.64a16 16 0 0 0 18.87-2.79l17.53-17.54a16 16 0 0 0 0-22.62L180 412l53.37-53.37zM496.79.14l-78.11 13.2-140 140 80 80 140-140 13.2-78.11A13.33 13.33 0 0 0 496.79.14z", "M389.37 309.38l-296-296L15.22.14A13.32 13.32 0 0 0 .14 15.22l13.2 78.11 296 296.05zm117.94 152.68L448 402.75l31.64-59a16 16 0 0 0-2.79-18.87l-17.54-17.53a16 16 0 0 0-22.63 0L307.31 436.69a16 16 0 0 0 0 22.62l17.53 17.54a16 16 0 0 0 18.87 2.79l59-31.64 59.31 59.31a16 16 0 0 0 22.63 0l22.62-22.62a16 16 0 0 0 .04-22.63z"]],
    "synagogue": [640, 512, [], "f69b", ["M70 196.51L6.67 268.29A26.66 26.66 0 0 0 0 285.93V512h128V239.58l-38-43.07a13.35 13.35 0 0 0-20 0zm563.33 71.78L570 196.51a13.33 13.33 0 0 0-20 0l-38 43.07V512h128V285.93a26.64 26.64 0 0 0-6.67-17.64z", "M468 109.41L340 7a32 32 0 0 0-40 0L172 109.41a32 32 0 0 0-12 25V512h96v-92.57c0-31.88 21.78-61.43 53.25-66.55A64 64 0 0 1 384 416v96h96V134.4a32 32 0 0 0-12-24.99zm-75.94 113.15a4.73 4.73 0 0 1-4 7.24h-38.94l-25.12 40a4.72 4.72 0 0 1-8 0l-25.12-40h-38.94a4.72 4.72 0 0 1-4-7.24l19.2-30.56-19.2-30.56a4.73 4.73 0 0 1 4-7.24h38.94l25.12-40a4.72 4.72 0 0 1 8 0l25.12 40h38.95a4.73 4.73 0 0 1 4 7.24L372.87 192z"]],
    "sync": [512, 512, [], "f021", ["M0 500V299.67a12 12 0 0 1 12-12h200.33a12 12 0 0 1 12 12v47.41a12 12 0 0 1-12.57 12l-101.87-4.88a176.07 176.07 0 0 0 317.25-56.94 12 12 0 0 1 11.67-9.26h49.09a12 12 0 0 1 11.8 14.18C478.07 417.08 377.19 504 256 504a247.43 247.43 0 0 1-188.76-87.17l4.13 82.57a12 12 0 0 1-12 12.6H12a12 12 0 0 1-12-12z", "M12.3 209.82C33.93 94.92 134.81 8 256 8a247.4 247.4 0 0 1 188.9 87.34l-4-82.77A12 12 0 0 1 452.92 0h47.41a12 12 0 0 1 12 12v200.33a12 12 0 0 1-12 12H300a12 12 0 0 1-12-12v-47.41a12 12 0 0 1 12.57-12l101.53 4.88a176.07 176.07 0 0 0-317.24 56.94A12 12 0 0 1 73.19 224H24.1a12 12 0 0 1-11.8-14.18z"]],
    "sync-alt": [512, 512, [], "f2f1", ["M8 454.06V320a24 24 0 0 1 24-24h134.06c21.38 0 32.09 25.85 17 41l-41.75 41.75A166.82 166.82 0 0 0 256.16 424c77.41-.07 144.31-53.14 162.78-126.85a12 12 0 0 1 11.65-9.15h57.31a12 12 0 0 1 11.81 14.18C478.07 417.08 377.19 504 256 504a247.14 247.14 0 0 1-171.31-68.69L49 471c-15.15 15.15-41 4.44-41-16.94z", "M12.3 209.82C33.93 94.92 134.81 8 256 8a247.14 247.14 0 0 1 171.31 68.69L463 41c15.12-15.12 41-4.41 41 17v134a24 24 0 0 1-24 24H345.94c-21.38 0-32.09-25.85-17-41l41.75-41.75A166.8 166.8 0 0 0 255.85 88c-77.46.07-144.33 53.18-162.79 126.85A12 12 0 0 1 81.41 224H24.1a12 12 0 0 1-11.8-14.18z"]],
    "syringe": [512, 512, [], "f48e", ["M266.43 109.83l135.69 135.69-181.89 181.91a79.68 79.68 0 0 1-65.41 23l-63.59-7.11-66.3 66.3a8 8 0 0 1-11.31 0l-11.3-11.3a8 8 0 0 1 0-11.3l66.41-66.4L61.62 357a79.91 79.91 0 0 1 23-65.4L111 265.24l55.81 55.88a8 8 0 0 0 11.3 0l11.31-11.29a8.06 8.06 0 0 0 0-11.31l-55.86-55.85 45.29-45.28 55.76 55.84a8 8 0 0 0 11.31 0l11.3-11.31a8 8 0 0 0 0-11.3l-55.77-55.83z", "M166.82 321.12L111 265.23l22.6-22.5 55.81 55.79a8.06 8.06 0 0 1 0 11.31l-11.31 11.29a8 8 0 0 1-11.28 0zm79.11-67.89l11.3-11.31a8 8 0 0 0 0-11.3l-55.71-55.79-22.59 22.59 55.69 55.81a8 8 0 0 0 11.31 0zM509.72 92.92l-11.3 11.31a8 8 0 0 1-11.3 0l-28.3-28.31-45.3 45.31 73.5 73.5A8 8 0 0 1 487 206l-33.9 34a8 8 0 0 1-11.3 0l-17-17L289.12 87.12l-17-17a8 8 0 0 1 0-11.29L306 24.92a8 8 0 0 1 11.3 0l17 17 56.61 56.6 45.3-45.29-28.3-28.31a8 8 0 0 1 0-11.3l11.3-11.29a8 8 0 0 1 11.29 0l79.21 79.19a8.15 8.15 0 0 1 .01 11.4z"]],
    "table": [512, 512, [], "f0ce", ["M288 160v96h160v-96zm0 256h160v-96H288zM64 256h160v-96H64zm0 160h160v-96H64z", "M464 32H48A48 48 0 0 0 0 80v352a48 48 0 0 0 48 48h416a48 48 0 0 0 48-48V80a48 48 0 0 0-48-48zM224 416H64v-96h160zm0-160H64v-96h160zm224 160H288v-96h160zm0-160H288v-96h160z"]],
    "table-tennis": [512, 512, [], "f45d", ["M496.28 296.48c31.5-77.81 15.8-170.31-47.2-233.4-83.9-84.1-220-84.1-303.9 0l-56 56.09 211.5 211.5c46.1-62.09 131.5-77.4 195.6-34.19zM416.08 320a96 96 0 1 0 96 96 96 96 0 0 0-96-96z", "M5.78 452.77a19.7 19.7 0 0 1 1-28.8l103-89.39L75.28 300c-39-39.09-44.6-98.79-17.3-144.09l220.4 220.29c-3.7 12.71-6.3 25.91-6.2 39.71a142.53 142.53 0 0 0 11 55.09c-25.7-2.8-50.6-13.59-70.3-33.3l-35.7-35.7-89.3 103.3a19.59 19.59 0 0 1-28.7 1z"]],
    "tablet": [448, 512, [], "f10a", ["M0 384v80a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48v-80zm224 96a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M0 384V48A48 48 0 0 1 48 0h352a48 48 0 0 1 48 48v336z"]],
    "tablet-alt": [448, 512, [], "f3fa", ["M400 0H48A48 48 0 0 0 0 48v416a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V48a48 48 0 0 0-48-48zM224 480a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm176-108a12 12 0 0 1-12 12H60a12 12 0 0 1-12-12V60a12 12 0 0 1 12-12h328a12 12 0 0 1 12 12z", "M48 60a12 12 0 0 1 12-12h328a12 12 0 0 1 12 12v312a12 12 0 0 1-12 12H60a12 12 0 0 1-12-12z"]],
    "tablet-android": [448, 512, [], "f3fb", ["M0 384v80a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48v-80zm288 68a12 12 0 0 1-12 12H172a12 12 0 0 1-12-12v-8a12 12 0 0 1 12-12h104a12 12 0 0 1 12 12z", "M0 384V48A48 48 0 0 1 48 0h352a48 48 0 0 1 48 48v336z"]],
    "tablet-android-alt": [448, 512, [], "f3fc", ["M400 0H48A48 48 0 0 0 0 48v416a48 48 0 0 0 48 48h352a48 48 0 0 0 48-48V48a48 48 0 0 0-48-48zM288 452a12 12 0 0 1-12 12H172a12 12 0 0 1-12-12v-8a12 12 0 0 1 12-12h104a12 12 0 0 1 12 12zm112-80a12 12 0 0 1-12 12H60a12 12 0 0 1-12-12V60a12 12 0 0 1 12-12h328a12 12 0 0 1 12 12z", "M48 60a12 12 0 0 1 12-12h328a12 12 0 0 1 12 12v312a12 12 0 0 1-12 12H60a12 12 0 0 1-12-12z"]],
    "tablet-rugged": [448, 512, [], "f48f", ["M439.2 164.4a15.92 15.92 0 0 0 8.8-14.3V73.9a15.92 15.92 0 0 0-8.8-14.3L416 48a48 48 0 0 0-48-48H80a48 48 0 0 0-48 48L8.8 59.6A15.92 15.92 0 0 0 0 73.9v76.2a15.92 15.92 0 0 0 8.8 14.3L32 176v16L8.8 203.6A15.92 15.92 0 0 0 0 217.9v76.2a15.92 15.92 0 0 0 8.8 14.3L32 320v16L8.8 347.6A15.92 15.92 0 0 0 0 361.9v76.2a15.92 15.92 0 0 0 8.8 14.3L32 464a48 48 0 0 0 48 48h288a48 48 0 0 0 48-48l23.2-11.6a15.92 15.92 0 0 0 8.8-14.3v-76.2a15.92 15.92 0 0 0-8.8-14.3L416 336v-16l23.2-11.6a15.92 15.92 0 0 0 8.8-14.3v-76.2a15.92 15.92 0 0 0-8.8-14.3L416 192v-16zM352 432a16 16 0 0 1-16 16H112a16 16 0 0 1-16-16V80a16 16 0 0 1 16-16h224a16 16 0 0 1 16 16z", "M352 432a16 16 0 0 1-16 16H112a16 16 0 0 1-16-16V80a16 16 0 0 1 16-16h224a16 16 0 0 1 16 16z"]],
    "tablets": [640, 512, [], "f490", ["M363 65.71c-3.5-3.5-9.5-3.2-12.3.8-45.4 62.7-40.5 150.4 15.9 206.9s144.2 61.4 206.9 15.9a8.15 8.15 0 0 0 .8-12.3zm230.4-19.1c-56.5-56.5-144.2-61.4-206.9-16a8.15 8.15 0 0 0-.8 12.3L597 254.31c3.5 3.5 9.5 3.2 12.3-.8 45.5-62.7 40.6-150.4-15.9-206.9z", "M311.6 368H8.4c-5 0-9.1 4.5-8.3 9.3C12.5 453.51 78.9 512 160 512s147.5-58.5 159.9-134.7c.8-4.79-3.3-9.3-8.3-9.3zM8.4 336h303.3c5 0 9.1-4.5 8.3-9.3C307.5 250.51 241.1 192 160 192S12.5 250.51.1 326.71c-.8 4.8 3.3 9.29 8.3 9.29z"]],
    "tachometer": [576, 512, [], "f0e4", ["M288 32C128.94 32 0 160.94 0 320a286.5 286.5 0 0 0 39.06 144.8c5.61 9.62 16.3 15.2 27.44 15.2h443c11.14 0 21.83-5.58 27.44-15.2A286.5 286.5 0 0 0 576 320c0-159.06-128.94-288-288-288zm102.77 119.59l-61.33 184A62.8 62.8 0 0 1 343.12 416H232.88a63.34 63.34 0 0 1 51-95.59l61.34-184a24 24 0 0 1 45.53 15.19z", "M283.9 320.41l61.34-184a24 24 0 0 1 45.53 15.19l-61.33 184a62.8 62.8 0 0 1 13.68 80.4H232.88a63.34 63.34 0 0 1 51-95.59z"]],
    "tachometer-alt": [576, 512, [], "f3fd", ["M288 32C128.94 32 0 160.94 0 320a286.5 286.5 0 0 0 39.06 144.8c5.61 9.62 16.3 15.2 27.44 15.2h443c11.14 0 21.83-5.58 27.44-15.2A286.5 286.5 0 0 0 576 320c0-159.06-128.94-288-288-288zm0 64c14.71 0 26.58 10.13 30.32 23.65-1.11 2.26-2.64 4.23-3.45 6.67L305.65 154c-5.13 3.49-11 6-17.64 6a32 32 0 0 1 0-64zM96 384a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm48-160a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm246.77-72.41l-61.33 184A62.8 62.8 0 0 1 343.12 416H232.88a63.34 63.34 0 0 1 51-95.59l61.34-184a24 24 0 0 1 45.53 15.19zm14.66 57.2L421 162.24a31.54 31.54 0 0 1 11-2.24 32 32 0 0 1 0 64c-11.38 0-20.89-6.27-26.57-15.21zM480 384a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M283.9 320.41l61.34-184a24 24 0 0 1 45.53 15.19l-61.33 184a62.8 62.8 0 0 1 13.68 80.4H232.88a63.34 63.34 0 0 1 51-95.59z"]],
    "tachometer-alt-average": [576, 512, [], "f624", ["M288 32C128.94 32 0 160.94 0 320a286.44 286.44 0 0 0 39.06 144.8c5.61 9.62 16.3 15.2 27.44 15.2h443c11.14 0 21.83-5.58 27.44-15.2A286.44 286.44 0 0 0 576 320c0-159.06-128.94-288-288-288zM96 384a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm48-160a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm203.54 183a63 63 0 0 1-4.42 9H232.88A63.36 63.36 0 0 1 255 329.17a62.44 62.44 0 0 1 9-4.42V128a24 24 0 0 1 48 0v196.75A63.36 63.36 0 0 1 347.54 407zM400 192a32 32 0 1 1 32 32 32 32 0 0 1-32-32zm80 192a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M343.12 416H232.88A63.36 63.36 0 0 1 255 329.17a62.44 62.44 0 0 1 9-4.42V128a24 24 0 0 1 48 0v196.75A63.35 63.35 0 0 1 343.12 416z"]],
    "tachometer-alt-fast": [576, 512, [], "f625", ["M288 32C128.94 32 0 160.94 0 320a286.5 286.5 0 0 0 39.06 144.8c5.61 9.62 16.3 15.2 27.44 15.2h443c11.14 0 21.83-5.58 27.44-15.2A286.5 286.5 0 0 0 576 320c0-159.06-128.94-288-288-288zm0 64a32 32 0 1 1-32 32 32 32 0 0 1 32-32zM96 384a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm48-160a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm199.12 192H232.88a63.33 63.33 0 0 1-8.88-32 64 64 0 0 1 64-64 63.14 63.14 0 0 1 16.24 2.34L412.8 177.59a24 24 0 1 1 38.41 28.81L342.65 351.14a62.26 62.26 0 0 1 .47 64.86zM480 384a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M288 320a63.14 63.14 0 0 1 16.24 2.34L412.8 177.59a24 24 0 1 1 38.41 28.81L342.65 351.14a62.26 62.26 0 0 1 .47 64.86H232.88a63.33 63.33 0 0 1-8.88-32 64 64 0 0 1 64-64z"]],
    "tachometer-alt-fastest": [576, 512, [], "f626", ["M288 32C128.94 32 0 160.94 0 320a286.5 286.5 0 0 0 39.06 144.8c5.61 9.62 16.3 15.2 27.44 15.2h443c11.14 0 21.83-5.58 27.44-15.2A286.5 286.5 0 0 0 576 320c0-159.06-128.94-288-288-288zm144 128a32 32 0 1 1-32 32 32 32 0 0 1 32-32zM288 96a32 32 0 1 1-32 32 32 32 0 0 1 32-32zM96 384a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm48-160a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm340 151.67L350 398a66 66 0 0 1-6.9 18H232.88a63.33 63.33 0 0 1-8.88-32 63.85 63.85 0 0 1 118.37-33.39l133.68-22.28a24 24 0 0 1 7.9 47.34z", "M288 320a63.78 63.78 0 0 1 54.37 30.61l133.68-22.28a24 24 0 0 1 7.9 47.34L350 398a66 66 0 0 1-6.9 18H232.88a63.33 63.33 0 0 1-8.88-32 64 64 0 0 1 64-64z"]],
    "tachometer-alt-slow": [576, 512, [], "f627", ["M288 32C128.94 32 0 160.94 0 320a286.5 286.5 0 0 0 39.06 144.8c5.61 9.62 16.3 15.2 27.44 15.2h443c11.14 0 21.83-5.58 27.44-15.2A286.5 286.5 0 0 0 576 320c0-159.06-128.94-288-288-288zm0 64a32 32 0 1 1-32 32 32 32 0 0 1 32-32zM96 384a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm247.12 32H232.88a62.26 62.26 0 0 1 .47-64.86L124.8 206.41a24 24 0 0 1 38.41-28.81l108.56 144.74A63.5 63.5 0 0 1 343.12 416zM400 192a32 32 0 1 1 32 32 32 32 0 0 1-32-32zm80 192a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M343.12 416H232.88a62.26 62.26 0 0 1 .47-64.86L124.8 206.41a24 24 0 0 1 38.41-28.81l108.56 144.74A63.5 63.5 0 0 1 343.12 416z"]],
    "tachometer-alt-slowest": [576, 512, [], "f628", ["M288 32C128.94 32 0 160.94 0 320a286.5 286.5 0 0 0 39.06 144.8c5.61 9.62 16.3 15.2 27.44 15.2h443c11.14 0 21.83-5.58 27.44-15.2A286.5 286.5 0 0 0 576 320c0-159.06-128.94-288-288-288zm0 64a32 32 0 1 1-32 32 32 32 0 0 1 32-32zm-144 64a32 32 0 1 1-32 32 32 32 0 0 1 32-32zm199.12 256H232.88a65.78 65.78 0 0 1-6.9-18L92.05 375.67a24 24 0 0 1 7.9-47.34l133.68 22.28A63.77 63.77 0 0 1 343.12 416zM400 192a32 32 0 1 1 32 32 32 32 0 0 1-32-32zm80 192a32 32 0 1 1 32-32 32 32 0 0 1-32 32z", "M72.33 348.05A24 24 0 0 1 100 328.33l133.68 22.28A63.77 63.77 0 0 1 343.12 416H232.88a65.78 65.78 0 0 1-6.9-18L92.05 375.67a24 24 0 0 1-19.72-27.62z"]],
    "tachometer-average": [576, 512, [], "f629", ["M288 32C128.94 32 0 160.94 0 320a286.5 286.5 0 0 0 39.06 144.8c5.61 9.62 16.3 15.2 27.44 15.2h443c11.14 0 21.83-5.58 27.44-15.2A286.5 286.5 0 0 0 576 320c0-159.06-128.94-288-288-288zm55.12 384H232.88A63.36 63.36 0 0 1 264 324.75V128a24 24 0 0 1 48 0v196.75A63.36 63.36 0 0 1 343.12 416z", "M264 324.75V128a24 24 0 0 1 48 0v196.75A63.36 63.36 0 0 1 343.12 416H232.88A63.36 63.36 0 0 1 264 324.75z"]],
    "tachometer-fast": [576, 512, [], "f62a", ["M288 32C128.94 32 0 160.94 0 320a286.5 286.5 0 0 0 39.06 144.8c5.61 9.62 16.3 15.2 27.44 15.2h443c11.14 0 21.83-5.58 27.44-15.2A286.5 286.5 0 0 0 576 320c0-159.06-128.94-288-288-288zm163.2 174.41L342.65 351.14a62.26 62.26 0 0 1 .47 64.86H232.88a63.33 63.33 0 0 1-8.88-32 64 64 0 0 1 64-64 63.14 63.14 0 0 1 16.24 2.34L412.8 177.59a24 24 0 1 1 38.4 28.82z", "M288 320a63.14 63.14 0 0 1 16.24 2.34L412.8 177.59a24 24 0 1 1 38.4 28.82L342.65 351.14a62.26 62.26 0 0 1 .47 64.86H232.88a63.33 63.33 0 0 1-8.88-32 64 64 0 0 1 64-64z"]],
    "tachometer-fastest": [576, 512, [], "f62b", ["M288 32C128.94 32 0 160.94 0 320a286.5 286.5 0 0 0 39.06 144.8c5.61 9.62 16.3 15.2 27.44 15.2h443c11.14 0 21.83-5.58 27.44-15.2A286.5 286.5 0 0 0 576 320c0-159.06-128.94-288-288-288zm196 343.67L350 398a66 66 0 0 1-6.9 18H232.88a63.33 63.33 0 0 1-8.88-32 63.85 63.85 0 0 1 118.37-33.39l133.68-22.28a24 24 0 0 1 7.9 47.34z", "M484 375.67L350 398a66 66 0 0 1-6.9 18H232.88a63.33 63.33 0 0 1-8.88-32 63.85 63.85 0 0 1 118.37-33.39l133.68-22.28a24 24 0 0 1 7.9 47.34z"]],
    "tachometer-slow": [576, 512, [], "f62c", ["M288 32C128.94 32 0 160.94 0 320a286.5 286.5 0 0 0 39.06 144.8c5.61 9.62 16.3 15.2 27.44 15.2h443c11.14 0 21.83-5.58 27.44-15.2A286.5 286.5 0 0 0 576 320c0-159.06-128.94-288-288-288zm55.12 384H232.88a62.26 62.26 0 0 1 .47-64.86L124.8 206.41a24 24 0 0 1 38.41-28.81l108.56 144.74A63.5 63.5 0 0 1 343.12 416z", "M343.12 416H232.88a62.26 62.26 0 0 1 .47-64.86L124.8 206.41a24 24 0 0 1 38.41-28.81l108.56 144.74A63.5 63.5 0 0 1 343.12 416z"]],
    "tachometer-slowest": [576, 512, [], "f62d", ["M288 32C128.94 32 0 160.94 0 320a286.5 286.5 0 0 0 39.06 144.8c5.61 9.62 16.3 15.2 27.44 15.2h443c11.14 0 21.83-5.58 27.44-15.2A286.5 286.5 0 0 0 576 320c0-159.06-128.94-288-288-288zm55.12 384H232.88a65.78 65.78 0 0 1-6.9-18L92.05 375.67a24 24 0 0 1 7.9-47.34l133.68 22.28A63.77 63.77 0 0 1 343.12 416z", "M343.12 416H232.88a65.78 65.78 0 0 1-6.9-18L92.05 375.67a24 24 0 0 1 7.9-47.34l133.68 22.28A63.77 63.77 0 0 1 343.12 416z"]],
    "taco": [512, 512, [], "f826", ["M256 192C125.82 192 18.14 299.4.32 439.08-2.43 460.66 13 480 32.56 480h446.88c19.56 0 35-19.34 32.24-40.92C493.86 299.4 386.18 192 256 192zM112 416a16 16 0 1 1 16-16 16 16 0 0 1-16 16zm64-64a16 16 0 1 1 16-16 16 16 0 0 1-16 16z", "M112 384a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm64-64a16 16 0 1 0 16 16 16 16 0 0 0-16-16zm332.91-95.71c-7.15-19.06-24.76-29.36-40.31-38.46-9.49-5.54-19.32-11.29-23.71-17.53-4.74-6.69-7.33-18.51-9.83-30-3.95-18.08-8.44-38.58-23.64-50.64-15.69-12.45-36-11-54-9.81-10.79.76-22 1.5-29.18-1.1-6.93-2.51-15.12-10.14-23-17.51-29.05-27.07-50.66-44.51-98.38-.05-7.92 7.37-16.11 15-23 17.51-7.22 2.6-18.39 1.86-29.18 1.1-18-1.24-38.32-2.64-54 9.81C85.48 99.67 81 120.17 77 138.25c-2.5 11.46-5.09 23.28-9.83 30-4.39 6.24-14.22 12-23.71 17.53-15.46 9.1-33.12 19.39-40.27 38.46-6.81 18.08-1 37.7 4.16 55a.21.21 0 0 0 0 .24 129.48 129.48 0 0 1 4.53 28.14C64 218.51 154.91 160 256 160s192 58.52 244.14 147.64a127.84 127.84 0 0 1 4.53-28.09.79.79 0 0 1 .08-.26c5.14-17.29 11-36.94 4.16-55z"]],
    "tag": [512, 512, [], "f02b", ["M497.94 225.94L286.06 14.06A48 48 0 0 0 252.12 0H48A48 48 0 0 0 0 48v204.12a48 48 0 0 0 14.06 33.94l211.88 211.88a48 48 0 0 0 67.88 0l204.12-204.12a48 48 0 0 0 0-67.88zM112 160a48 48 0 1 1 48-48 48 48 0 0 1-48 48z", ""]],
    "tags": [640, 512, [], "f02c", ["M497.94 225.94L286.06 14.06A48 48 0 0 0 252.12 0H48A48 48 0 0 0 0 48v204.12a48 48 0 0 0 14.06 33.94l211.88 211.88a48 48 0 0 0 67.88 0l204.12-204.12a48 48 0 0 0 0-67.88zM112 160a48 48 0 1 1 48-48 48 48 0 0 1-48 48z", "M625.94 293.82L421.82 497.94a48 48 0 0 1-67.88 0l-.36-.36 174.06-174.06a90 90 0 0 0 0-127.28L331.4 0h48.72a48 48 0 0 1 33.94 14.06l211.88 211.88a48 48 0 0 1 0 67.88z"]],
    "tally": [640, 512, [], "f69c", ["M224 253.44V48a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16v184.73zm-64 20.71V48a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v246.86zm256-82.85V48a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v164zm128-41.42V48a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v122.59zM224 320.7V464a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V300zm256-82.85V464a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V217.14zM96 362.12V464a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V341.41zm256-82.85V464a16 16 0 0 0 16 16h32a16 16 0 0 0 16-16V258.56z", "M639.21 169.49a16 16 0 0 1-10.27 20.16L30.84 383.21a16 16 0 0 1-20.16-10.27L.79 342.51a16 16 0 0 1 10.27-20.16l598.1-193.56a16 16 0 0 1 20.16 10.27z"]],
    "tanakh": [448, 512, [], "f827", ["M32.14 448c2.29-15.62 2.46-47.76.53-64H352c16 0 32 12.8 32 32s-12.8 32-32 32z", "M224 87.38l-16.78 28.06h33.58zm-59.11 52.06H130l17.47 29.17zm153.11 0h-34.9l17.48 29.19zM130 244.56h34.9l-17.48-29.19zM352 0H32A32 32 0 0 0 0 32v328a24 24 0 0 0 24 24h328c16 0 32 12.8 32 32s-12.8 32-32 32H24a24 24 0 0 0-24 24v16a24 24 0 0 0 24 24h328a96 96 0 0 0 96-96V96a96 96 0 0 0-96-96zm-9.41 258.43a20.12 20.12 0 0 1-17.5 10.15h-56.3L241.2 314.7a20 20 0 0 1-17.2 9.82 19.66 19.66 0 0 1-17-9.68l-27.7-46.28h-56.39a20 20 0 0 1-17.14-30.29L133.43 192l-27.79-46.43a19.6 19.6 0 0 1-.23-20 20.12 20.12 0 0 1 17.5-10.15h56.3L206.8 69.3a20 20 0 0 1 17.25-9.82 19.67 19.67 0 0 1 17 9.68l27.7 46.28h56.36a20 20 0 0 1 17.14 30.29L314.57 192l27.79 46.43a19.59 19.59 0 0 1 .23 20zm-118.54 38.2l16.78-28.07h-33.58zm59.09-52.07h34.91l-17.47-29.17zm-28-105.14h-62.3L161.41 192l31.47 52.56h62.3L286.59 192z"]],
    "tape": [640, 512, [], "f4db", ["M624 416H380.6A223.47 223.47 0 0 0 448 256c0-123.7-100.3-224-224-224S0 132.3 0 256s100.3 224 224 224h400a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm-400-64a96 96 0 1 1 96-96 96 96 0 0 1-96 96z", "M288 256a64 64 0 1 1-64-64 64.06 64.06 0 0 1 64 64z"]],
    "tasks": [512, 512, [], "f0ae", ["M496 384H208a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h288a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16zm0-320H208a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h288a16 16 0 0 0 16-16V80a16 16 0 0 0-16-16zm0 160H208a16 16 0 0 0-16 16v32a16 16 0 0 0 16 16h288a16 16 0 0 0 16-16v-32a16 16 0 0 0-16-16z", "M139.61 35.5a12 12 0 0 0-17 0L58.93 98.81l-22.7-22.12a12 12 0 0 0-17 0L3.53 92.41a12 12 0 0 0 0 17l47.59 47.4a12.78 12.78 0 0 0 17.61 0l15.59-15.62L156.52 69a12.09 12.09 0 0 0 .09-17zm0 159.19a12 12 0 0 0-17 0l-63.68 63.72-22.7-22.1a12 12 0 0 0-17 0L3.53 252a12 12 0 0 0 0 17L51 316.5a12.77 12.77 0 0 0 17.6 0l15.7-15.69 72.2-72.22a12 12 0 0 0 .09-16.9zM64 368c-26.49 0-48.59 21.5-48.59 48S37.53 464 64 464a48 48 0 0 0 0-96z"]],
    "tasks-alt": [512, 512, [], "f828", ["M488.12 352H23.94A23.94 23.94 0 0 0 0 375.88V456a23.94 23.94 0 0 0 23.88 24h464.18A23.94 23.94 0 0 0 512 456.12V376a23.94 23.94 0 0 0-23.88-24zM464 432H48v-32h416zm24.12-240H23.94A23.94 23.94 0 0 0 0 215.88V296a23.94 23.94 0 0 0 23.88 24h464.18A23.94 23.94 0 0 0 512 296.12V216a23.94 23.94 0 0 0-23.88-24zM464 272H48v-32h416zm24.12-240H23.94A23.94 23.94 0 0 0 0 55.88V136a23.94 23.94 0 0 0 23.88 24h464.18A23.94 23.94 0 0 0 512 136.12V56a23.94 23.94 0 0 0-23.88-24zM464 112H48V80h416z", "M48 80v32h304V80zm112 160H48v32h112zM48 432h240v-32H48z"]],
    "taxi": [512, 512, [], "f1ba", ["M352 64a32 32 0 0 0-32-32H192a32 32 0 0 0-32 32v32h192zM96 368H64a32 32 0 0 0-32 32v48a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32v-48a32 32 0 0 0-32-32zm352 0h-32a32 32 0 0 0-32 32v48a32 32 0 0 0 32 32h32a32 32 0 0 0 32-32v-48a32 32 0 0 0-32-32zm-69.94-195.14c-2-7.38-9.38-12.86-14.85-12.86h-214.4c-5.47 0-12.83 5.48-15.06 13.64L116.55 240h278.9z", "M462 241.55l-22-84.75c-9.6-35.2-41.6-60.8-76.8-60.8H148.8c-35.2 0-67.2 25.6-76.8 60.8l-22 84.75A64 64 0 0 0 0 304v48a64 64 0 0 0 64 64h384a64 64 0 0 0 64-64v-48a64 64 0 0 0-50-62.45zm-328.25-67.91c2.25-8.16 9.59-13.64 15.06-13.64h214.4c5.47 0 12.83 5.48 14.85 12.86L395.45 240h-278.9zM96 352a32 32 0 1 1 32-32 32 32 0 0 1-32 32zm320 0a32 32 0 1 1 32-32 32 32 0 0 1-32 32z"]],
    "teeth": [640, 512, [], "f62e", ["M144 288H80a16 16 0 0 0-16 16v64a48 48 0 0 0 96 0v-64a16 16 0 0 0-16-16zm-32-160a48 48 0 0 0-48 48v64a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16v-64a48 48 0 0 0-48-48zm176 160h-80a16 16 0 0 0-16 16v56a56 56 0 0 0 112 0v-56a16 16 0 0 0-16-16zM248 96a56 56 0 0 0-56 56v88a16 16 0 0 0 16 16h80a16 16 0 0 0 16-16v-88a56 56 0 0 0-56-56zm184 192h-80a16 16 0 0 0-16 16v56a56 56 0 0 0 112 0v-56a16 16 0 0 0-16-16zM392 96a56 56 0 0 0-56 56v88a16 16 0 0 0 16 16h80a16 16 0 0 0 16-16v-88a56 56 0 0 0-56-56zm168 192h-64a16 16 0 0 0-16 16v64a48 48 0 0 0 96 0v-64a16 16 0 0 0-16-16zm-32-160a48 48 0 0 0-48 48v64a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16v-64a48 48 0 0 0-48-48z", "M544 0H96A96 96 0 0 0 0 96v320a96 96 0 0 0 96 96h448a96 96 0 0 0 96-96V96a96 96 0 0 0-96-96zM160 368a48 48 0 0 1-96 0v-64a16 16 0 0 1 16-16h64a16 16 0 0 1 16 16zm0-128a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16v-64a48 48 0 0 1 96 0zm144 120a56 56 0 0 1-112 0v-56a16 16 0 0 1 16-16h80a16 16 0 0 1 16 16zm0-120a16 16 0 0 1-16 16h-80a16 16 0 0 1-16-16v-88a56 56 0 0 1 112 0zm144 120a56 56 0 0 1-112 0v-56a16 16 0 0 1 16-16h80a16 16 0 0 1 16 16zm0-120a16 16 0 0 1-16 16h-80a16 16 0 0 1-16-16v-88a56 56 0 0 1 112 0zm128 128a48 48 0 0 1-96 0v-64a16 16 0 0 1 16-16h64a16 16 0 0 1 16 16zm0-128a16 16 0 0 1-16 16h-64a16 16 0 0 1-16-16v-64a48 48 0 0 1 96 0z"]],
    "teeth-open": [640, 512, [], "f62f", ["M112 96a48 48 0 0 0-48 48v32a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16v-32a48 48 0 0 0-48-48zm136-32a56 56 0 0 0-56 56v56a16 16 0 0 0 16 16h80a16 16 0 0 0 16-16v-56a56 56 0 0 0-56-56zm144 0a56 56 0 0 0-56 56v56a16 16 0 0 0 16 16h80a16 16 0 0 0 16-16v-56a56 56 0 0 0-56-56zm136 32a48 48 0 0 0-48 48v32a16 16 0 0 0 16 16h64a16 16 0 0 0 16-16v-32a48 48 0 0 0-48-48zM144 352H80a16 16 0 0 0-16 16v32a48 48 0 0 0 96 0v-32a16 16 0 0 0-16-16zm144 0h-80a16 16 0 0 0-16 16v24a56 56 0 0 0 112 0v-24a16 16 0 0 0-16-16zm144 0h-80a16 16 0 0 0-16 16v24a56 56 0 0 0 112 0v-24a16 16 0 0 0-16-16zm128 0h-64a16 16 0 0 0-16 16v32a48 48 0 0 0 96 0v-32a16 16 0 0 0-16-16z", "M576 320H64a64 64 0 0 0-64 64v32a96 96 0 0 0 96 96h448a96 96 0 0 0 96-96v-32a64 64 0 0 0-64-64zm-416 80a48 48 0 0 1-96 0v-32a16 16 0 0 1 16-16h64a16 16 0 0 1 16 16zm144-8a56 56 0 0 1-112 0v-24a16 16 0 0 1 16-16h80a16 16 0 0 1 16 16zm144 0a56 56 0 0 1-112 0v-24a16 16 0 0 1 16-16h80a16 16 0 0 1 16 16zm128 8a48 48 0 0 1-96 0v-32a16 16 0 0 1 16-16h64a16 16 0 0 1 16 16zM544 0H96A96 96 0 0 0 0 96v64a64 64 0 0 0 64 64h512a64 64 0 0 0 64-64V96a96 96 0 0 0-96-96zM160 176a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16v-32a48 48 0 0 1 96 0zm144 0a16 16 0 0 1-16 16h-80a16 16 0 0 1-16-16v-56a56 56 0 0 1 112 0zm144 0a16 16 0 0 1-16 16h-80a16 16 0 0 1-16-16v-56a56 56 0 0 1 112 0zm128 0a16 16 0 0 1-16 16h-64a16 16 0 0 1-16-16v-32a48 48 0 0 1 96 0z"]],
    "temperature-frigid": [576, 512, [], "f768", ["M544.06 278.5V112a112 112 0 1 0-224 0v166.5c-19.7 24.6-32 55.5-32 89.5a144 144 0 1 0 288 0c0-34-12.3-64.9-32-89.5zm-112 169.5a79.87 79.87 0 0 1-48-143.8V112a48 48 0 1 1 96 0v192.2a79.87 79.87 0 0 1-48 143.8z", "M200.06 125.2l40.2-40.2a12 12 0 0 0 0-17l-8.5-8.5a12 12 0 0 0-17 0l-14.7 14.8V44a12 12 0 0 0-12-12h-24a12 12 0 0 0-12 12v30.3l-14.8-14.8a12 12 0 0 0-17 0l-8.5 8.5a12 12 0 0 0 0 17L152 125.2v56.9L101.66 153l-15-55.7a12.16 12.16 0 0 0-14.9-8.6l-11.7 3.2a12.16 12.16 0 0 0-8.6 14.9L57 127.2l-26.6-15.3a12.12 12.12 0 0 0-16.6 4.4l-12.1 21a12.12 12.12 0 0 0 4.4 16.6l26.6 15.3-20.4 5.5a12.16 12.16 0 0 0-8.6 14.9l3.1 11.7a12.16 12.16 0 0 0 14.9 8.6L77.36 195l50.2 29-50.2 29-55.7-15a12.21 12.21 0 0 0-14.9 8.6l-3.1 11.7a12.21 12.21 0 0 0 8.6 14.9l20.4 5.5-26.5 15.4a12.12 12.12 0 0 0-4.4 16.6l12.1 21a12.12 12.12 0 0 0 16.6 4.4l26.6-15.3-5.5 20.4a12.21 12.21 0 0 0 8.6 14.9l11.7 3.1a12.21 12.21 0 0 0 14.9-8.6l14.9-55.6 50.4-29.1v56.9l-40.2 40.2a12 12 0 0 0 0 17l8.5 8.5a12 12 0 0 0 17 0l14.8-14.8V404a12 12 0 0 0 12 12h24a12 12 0 0 0 12-12v-30.3L215 388.5a12 12 0 0 0 17 0l8.5-8.5a12 12 0 0 0 0-17l-40.4-40.2v-56.9l68.3 39.5a177 177 0 0 1 19.7-37.5v-7.2L224.66 224l63.4-36.6v-56.1l-88 50.8zm248 197.7V304a16 16 0 0 0-32 0v18.9a48 48 0 1 0 32 0z"]],
    "temperature-high": [512, 512, [], "f769", ["M256 278.5V112a112 112 0 0 0-224 0v166.5C12.3 303.2 0 334 0 368a144 144 0 0 0 288 0c0-34-12.3-64.9-32-89.5zM144 448a79.87 79.87 0 0 1-48-143.8V112a48 48 0 0 1 96 0v192.2A79.87 79.87 0 0 1 144 448z", "M416 0a96 96 0 1 0 96 96 96.15 96.15 0 0 0-96-96zm0 128a32 32 0 1 1 32-32 32 32 0 0 1-32 32zM160 322.9V112a16 16 0 0 0-32 0v210.9a48 48 0 1 0 32 0z"]],
    "temperature-hot": [640, 512, [], "f76a", ["M608 278.5V112C608 50.1 557.9 0 496 0S384 50.1 384 112v166.5c-19.7 24.6-32 55.5-32 89.5 0 79.5 64.5 144 144 144s144-64.5 144-144c0-34-12.3-64.9-32-89.5zM496 448c-44.1.1-79.9-35.6-80-79.7 0-25.2 11.8-48.9 32-64.1V112c0-26.5 21.5-48 48-48s48 21.5 48 48v192.2c35.3 26.4 42.5 76.5 16.1 111.8-15.2 20.2-38.9 32-64.1 32z", "M160 224c0 35.3 28.7 64 64 64s64-28.7 64-64-28.7-64-64-64-64 28.7-64 64zM237.6 8.4c-3.8-7.5-12.9-10.6-20.4-6.8-2.9 1.5-5.3 3.9-6.8 6.8L169 91.2 81.1 61.9c-8-2.6-16.6 1.8-19.2 9.8-1 3.1-1 6.4 0 9.4L91.2 169 8.4 210.4c-7.5 3.7-10.5 12.8-6.8 20.3 1.5 3 3.9 5.4 6.8 6.8L91.2 279l-29.3 87.9c-2.7 7.9 1.6 16.5 9.6 19.2 3.1 1 6.5 1 9.6 0l87.9-29.3 41.4 82.8c3.7 7.5 12.8 10.5 20.3 6.8 3-1.5 5.4-3.9 6.8-6.8l41.4-82.9 41.1 13.7c0-.8-.1-1.6-.1-2.5.1-35.9 11.3-70.8 32.1-100V112c0-16.9 3.5-33 8.9-48.1L279 91.2 237.6 8.4zm54.3 283.5c-37.5 37.4-98.3 37.4-135.8 0-37.5-37.4-37.4-98.4 0-135.8 37.5-37.5 98.3-37.5 135.8 0s37.5 98.3 0 135.8zm220.1 31V112c0-8.8-7.2-16-16-16s-16 7.2-16 16v210.9c-25 8.8-38.1 36.3-29.3 61.3s36.3 38.1 61.3 29.3 38.1-36.3 29.3-61.3c-4.9-13.7-15.6-24.5-29.3-29.3z"]],
    "temperature-low": [512, 512, [], "f76b", ["M256 278.5V112a112 112 0 0 0-224 0v166.5C12.3 303.2 0 334 0 368a144 144 0 0 0 288 0c0-34-12.3-64.9-32-89.5zM144 448a79.87 79.87 0 0 1-48-143.8V112a48 48 0 0 1 96 0v192.2A79.87 79.87 0 0 1 144 448z", "M416 0a96 96 0 1 0 96 96 96.15 96.15 0 0 0-96-96zm0 128a32 32 0 1 1 32-32 32 32 0 0 1-32 32zM160 322.9V304a16 16 0 0 0-32 0v18.9a48 48 0 1 0 32 0z"]],
    "tenge": [384, 512, [], "f7d7", ["M372 160H12a12 12 0 0 0-12 12v56a12 12 0 0 0 12 12h140v228a12 12 0 0 0 12 12h56a12 12 0 0 0 12-12V240h140a12 12 0 0 0 12-12v-56a12 12 0 0 0-12-12z", "M372 32H12A12 12 0 0 0 0 44v56a12 12 0 0 0 12 12h360a12 12 0 0 0 12-12V44a12 12 0 0 0-12-12z"]],
    "tennis-ball": [496, 512, [], "f45e", ["M267,77.5c-.59-19.26,3-63.59,52.93-58.89A247.88,247.88,0,0,0,248,8c-3.61,0-7.19.09-10.76.25C224.55,26.92,218.1,51.32,219,79.1c2.2,71.2-69,149.7-147.9,147.8-27.88-1.19-52.18,5.45-70.85,18.24C.1,248.74,0,252.36,0,256a248.12,248.12,0,0,0,10.72,72.31C5.7,278,50.22,274.51,69.6,275c47.4,1.8,101.6-21.5,138.7-58.8C245.4,179.1,268.5,124.6,267,77.5ZM485.26,183.63c5,50.23-39.65,53.67-58.86,53.27-46.8-1.9-101.5,21.6-138.7,58.8S227.5,387.3,229,434.4c.59,19.39-3.13,63.72-53.34,58.87A248,248,0,0,0,248,504c3.57,0,7.12-.09,10.66-.24,12.79-18.67,19.24-43.08,18.34-70.86-2.4-77.5,76.4-150.5,147.9-147.9,27.83.9,52.27-5.57,70.86-18.31.15-3.54.24-7.11.24-10.69a247.87,247.87,0,0,0-10.74-72.37Z", "M424.9,285c-71.5-2.6-150.3,70.4-147.9,147.9.9,27.9-5.6,52.4-18.5,71.1,121-5.1,231.6-100.1,237.4-237.4C477.3,279.4,452.8,285.9,424.9,285ZM71.1,226.9C150,228.8,221.2,150.3,219,79.1c-.9-27.9,5.6-52.4,18.4-71.1C113.8,13.2,5.8,110.6,0,245.3c18.7-12.9,43.1-19.6,71.1-18.4Zm216.6,68.8c37.2-37.2,91.9-60.7,138.7-58.8,19.4.4,64.8-3.1,58.7-54.8A248.21,248.21,0,0,0,321.8,18.8c-51.7-6-55.4,39.2-54.8,58.7,1.5,47.1-21.6,101.6-58.7,138.7C171.2,253.5,117,276.8,69.6,275c-19.6-.5-64.9,3.1-58.7,55A247.64,247.64,0,0,0,174,493.1c51.8,6,55.6-39.1,55-58.7C227.5,387.3,250.6,332.8,287.7,295.7Z"]],
    "terminal": [640, 512, [], "f120", ["M640 421.34v32a24 24 0 0 1-24 24H312a24 24 0 0 1-24-24v-32a24 24 0 0 1 24-24h304a24 24 0 0 1 24 24z", "M29.7 464.66L7 442a24 24 0 0 1 0-33.9l154-154.76L7 98.6a24 24 0 0 1 0-33.9L29.7 42a24 24 0 0 1 33.94 0L258 236.37a24 24 0 0 1 0 33.94L63.64 464.66a24 24 0 0 1-33.94 0z"]],
    "text": [448, 512, [], "f893", ["M304 416a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16H144a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16z", "M448 48v96a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-32H264v304h-80V112H64v32a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16V48a16 16 0 0 1 16-16h416a16 16 0 0 1 16 16z"]],
    "text-height": [576, 512, [], "f034", ["M320 48v96a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-32h-56v304h40a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16H80a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h40V112H64v32a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16V48a16 16 0 0 1 16-16h288a16 16 0 0 1 16 16z", "M571.31 395.31l-80 80a16 16 0 0 1-22.62 0l-80-80c-10-10-3-27.31 11.31-27.31h48V144h-48c-15.64 0-20.64-18-11.31-27.31l80-80a16 16 0 0 1 22.62 0l80 80c10 10 3 27.31-11.31 27.31h-48v224h48c15.64 0 20.64 18 11.31 27.31z"]],
    "text-size": [640, 512, [], "f894", ["M320 240v64a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-16h-56v128h24a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16H96a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h24V288H64v16a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16v-64a16 16 0 0 1 16-16h288a16 16 0 0 1 16 16z", "M640 48v96a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-32h-88v304h40a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16H368a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h40V112h-88v32a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16V48a16 16 0 0 1 16-16h352a16 16 0 0 1 16 16z"]],
    "text-width": [448, 512, [], "f035", ["M448 48v80a16 16 0 0 1-16 16h-32a16 16 0 0 1-16-16v-16H264v112h24a16 16 0 0 1 16 16v32a16 16 0 0 1-16 16H160a16 16 0 0 1-16-16v-32a16 16 0 0 1 16-16h24V112H64v16a16 16 0 0 1-16 16H16a16 16 0 0 1-16-16V48a16 16 0 0 1 16-16h416a16 16 0 0 1 16 16z", "M443.31 372.69a16 16 0 0 1 0 22.62l-80 80c-10 10-27.31 3-27.31-11.31v-48H112v48c0 15.64-18 20.64-27.31 11.31l-80-80a16 16 0 0 1 0-22.62l80-80c10-10 27.31-3 27.31 11.31v48h224v-48c0-15.64 18-20.64 27.31-11.31z"]],
    "th": [512, 512, [], "f00a", ["M306.67 352H205.33a24 24 0 0 0-24 24v80a24 24 0 0 0 24 24h101.34a24 24 0 0 0 24-24v-80a24 24 0 0 0-24-24zM488 192H386.67a24 24 0 0 0-24 24v80a24 24 0 0 0 24 24H488a24 24 0 0 0 24-24v-80a24 24 0 0 0-24-24zM306.67 32H205.33a24 24 0 0 0-24 24v80a24 24 0 0 0 24 24h101.34a24 24 0 0 0 24-24V56a24 24 0 0 0-24-24zM125.33 192H24a24 24 0 0 0-24 24v80a24 24 0 0 0 24 24h101.33a24 24 0 0 0 24-24v-80a24 24 0 0 0-24-24z", "M488 352H386.67a24 24 0 0 0-24 24v80a24 24 0 0 0 24 24H488a24 24 0 0 0 24-24v-80a24 24 0 0 0-24-24zM306.67 192H205.33a24 24 0 0 0-24 24v80a24 24 0 0 0 24 24h101.34a24 24 0 0 0 24-24v-80a24 24 0 0 0-24-24zM488 32H386.67a24 24 0 0 0-24 24v80a24 24 0 0 0 24 24H488a24 24 0 0 0 24-24V56a24 24 0 0 0-24-24zm-362.67 0H24A24 24 0 0 0 0 56v80a24 24 0 0 0 24 24h101.33a24 24 0 0 0 24-24V56a24 24 0 0 0-24-24zm0 320H24a24 24 0 0 0-24 24v80a24 24 0 0 0 24 24h101.33a24 24 0 0 0 24-24v-80a24 24 0 0 0-24-24z"]],
    "th-large": [512, 512, [], "f009", ["M488 272H296a24 24 0 0 0-24 24v160a24 24 0 0 0 24 24h192a24 24 0 0 0 24-24V296a24 24 0 0 0-24-24zm-272 0H24a24 24 0 0 0-24 24v160a24 24 0 0 0 24 24h192a24 24 0 0 0 24-24V296a24 24 0 0 0-24-24z", "M488 32H296a24 24 0 0 0-24 24v160a24 24 0 0 0 24 24h192a24 24 0 0 0 24-24V56a24 24 0 0 0-24-24zm-272 0H24A24 24 0 0 0 0 56v160a24 24 0 0 0 24 24h192a24 24 0 0 0 24-24V56a24 24 0 0 0-24-24z"]],
    "th-list": [512, 512, [], "f00b", ["M488 352H205.33a24 24 0 0 0-24 24v80a24 24 0 0 0 24 24H488a24 24 0 0 0 24-24v-80a24 24 0 0 0-24-24zm0-320H205.33a24 24 0 0 0-24 24v80a24 24 0 0 0 24 24H488a24 24 0 0 0 24-24V56a24 24 0 0 0-24-24zm0 160H205.33a24 24 0 0 0-24 24v80a24 24 0 0 0 24 24H488a24 24 0 0 0 24-24v-80a24 24 0 0 0-24-24z", "M125.33 192H24a24 24 0 0 0-24 24v80a24 24 0 0 0 24 24h101.33a24 24 0 0 0 24-24v-80a24 24 0 0 0-24-24zm0-160H24A24 24 0 0 0 0 56v80a24 24 0 0 0 24 24h101.33a24 24 0 0 0 24-24V56a24 24 0 0 0-24-24zm0 320H24a24 24 0 0 0-24 24v80a24 24 0 0 0 24 24h101.33a24 24 0 0 0 24-24v-80a24 24 0 0 0-24-24z"]],
    "theater-masks": [640, 512, [], "f630", ["M229.45 303.5l.46-2.61q-4.28.54-8.59 1.29c-40.27 7.08-73.4 26.26-92.56 50-4.21-49.87 31-95.87 82.8-105a102.8 102.8 0 0 1 28-1.07l10.23-57.89a43 43 0 0 1-25.11-31.69 42.49 42.49 0 0 1-.1-13 65.27 65.27 0 0 0 31.94 6.67l4.62-26.14c4.77-27.26 25.39-48.68 51.53-53.9l1.13-.21 1.28-.23h.13c3-.48 5.94-.92 8.92-1.34l1.75-.23c2.38-.32 4.76-.63 7.14-.91l2.57-.3q3.19-.36 6.39-.68l2.82-.26q3.18-.3 6.37-.55l2.59-.2c2.38-.17 4.76-.33 7.14-.46l1.71-.11q8.7-.47 17.39-.61l-.7-4c-4.93-28.09-26.7-50-54-54.34a453.62 453.62 0 0 0-292 51.33C9 70.46-3.89 98.44 1 126.54L32.82 306c15.39 87 156.86 151.86 219.9 140.79 8.52-1.5 17.93-4.81 27.77-9.6-34.29-39.84-58.83-89.61-51.04-133.69zM90.54 182.72a41.87 41.87 0 0 1-.09-13c11.64 6 26.73 8.33 42.5 5.56s29.15-10.12 38-19.71a42.58 42.58 0 0 1 4.38 12.26 43.06 43.06 0 0 1-84.82 14.92z", "M606.8 121.05a452.59 452.59 0 0 0-291.69-51.33c-27.28 4.36-49 26.25-53.94 54.34L229.45 303.5c-15.37 87 95.18 196.19 158.14 207.27S591.85 457 607.22 370L639 190.54c4.88-28.1-8-56.08-32.2-69.49zm-272.95 96.76a40 40 0 1 1 74.64 25.25c-8.24-8.9-20.65-15.74-35.28-18.31s-28.64-.4-39.44 5.17a39 39 0 0 1 .08-12.11zm70.36 198.68c-55.62-9.78-93.42-59.24-88.9-112.85 20.58 25.53 56.15 46.15 99.38 53.76s83.73.37 111.81-16.6c-14.17 51.92-66.64 85.48-122.29 75.69zm134.26-162.67a39.44 39.44 0 0 1-4.06 11.39c-8.24-8.9-20.66-15.74-35.3-18.31s-28.64-.4-39.43 5.17a39 39 0 0 1 .09-12.1 40 40 0 0 1 78.7 13.85z"]],
    "thermometer": [512, 512, [], "f491", ["M484.05 162.6l-254.2 253.3H130l-89 89A24 24 0 0 1 7.05 471l89-89V281.1l45.34-45.64 50.06 50.14a8 8 0 0 0 11.3 0l11.3-11.3a8 8 0 0 0 0-11.3l-50.13-50.21 45.13-45.42 50.3 50.23a8 8 0 0 0 11.3 0L282 206.3a8 8 0 0 0 0-11.3l-50.3-50.37 45.1-45.4 50.4 50.47a8 8 0 0 0 11.3 0l11.3-11.3a8 8 0 0 0 0-11.3l-50.5-50.51 45.7-46c36.4-36.5 94.4-40.9 131.9-10.2C526.25 61.1 519 127.7 484.05 162.6z", "M214.05 263a8 8 0 0 1 0 11.3l-11.3 11.3a8 8 0 0 1-11.3 0l-50.06-50.14 22.53-22.67zm62.7-163.77l50.4 50.47a8 8 0 0 0 11.3 0l11.3-11.3a8 8 0 0 0 0-11.3l-50.5-50.51zm-6.1 118.37L282 206.3a8 8 0 0 0 0-11.3l-50.3-50.37-22.6 22.74 50.3 50.23a8 8 0 0 0 11.25 0z"]],
    "thermometer-empty": [320, 512, [], "f2cb", ["M272 278.5V112a112 112 0 0 0-224 0v166.5C28.3 303.2 16 334 16 368a144 144 0 0 0 288 0c0-34-12.3-64.9-32-89.5zM160 448a79.87 79.87 0 0 1-48-143.8V112a48 48 0 0 1 96 0v192.2A79.87 79.87 0 0 1 160 448z", "M208 368a48 48 0 1 1-48-48 48 48 0 0 1 48 48z"]],
    "thermometer-full": [320, 512, [], "f2c7", ["M272 278.5V112a112 112 0 0 0-224 0v166.5C28.3 303.2 16 334 16 368a144 144 0 0 0 288 0c0-34-12.3-64.9-32-89.5zM160 448a79.87 79.87 0 0 1-48-143.8V112a48 48 0 0 1 96 0v192.2A79.87 79.87 0 0 1 160 448z", "M208 368a48 48 0 1 1-64-45.1V112a16 16 0 0 1 32 0v210.9a47.87 47.87 0 0 1 32 45.1z"]],
    "thermometer-half": [320, 512, [], "f2c9", ["M272 278.5V112a112 112 0 0 0-224 0v166.5C28.3 303.2 16 334 16 368a144 144 0 0 0 288 0c0-34-12.3-64.9-32-89.5zM160 448a79.87 79.87 0 0 1-48-143.8V112a48 48 0 0 1 96 0v192.2A79.87 79.87 0 0 1 160 448z", "M208 368a48 48 0 1 1-64-45.1V208a16 16 0 0 1 32 0v114.9a47.87 47.87 0 0 1 32 45.1z"]],
    "thermometer-quarter": [320, 512, [], "f2ca", ["M272 278.5V112a112 112 0 0 0-224 0v166.5C28.3 303.2 16 334 16 368a144 144 0 0 0 288 0c0-34-12.3-64.9-32-89.5zM160 448a79.87 79.87 0 0 1-48-143.8V112a48 48 0 0 1 96 0v192.2A79.87 79.87 0 0 1 160 448z", "M208 368a48 48 0 1 1-64-45.1V272a16 16 0 0 1 32 0v50.9a47.87 47.87 0 0 1 32 45.1z"]],
    "thermometer-three-quarters": [320, 512, [], "f2c8", ["M272 278.5V112a112 112 0 0 0-224 0v166.5C28.3 303.2 16 334 16 368a144 144 0 0 0 288 0c0-34-12.3-64.9-32-89.5zM160 448a79.87 79.87 0 0 1-48-143.8V112a48 48 0 0 1 96 0v192.2A79.87 79.87 0 0 1 160 448z", "M208 368a48 48 0 1 1-64-45.1V144a16 16 0 0 1 32 0v178.9a47.87 47.87 0 0 1 32 45.1z"]],
    "theta": [384, 512, [], "f69e", ["M288 256a229.75 229.75 0 0 1-4.92 48H100.92a236.61 236.61 0 0 1 0-96h182.16a229.75 229.75 0 0 1 4.92 48z", "M192 104c27.82 0 48.24 18.83 60.46 34.62 10.67 13.78 19.18 30.4 25.3 49.4A221.26 221.26 0 0 1 288 256a221.26 221.26 0 0 1-10.24 68c-6.12 19-14.63 35.62-25.3 49.4C240.24 389.17 219.82 408 192 408s-48.24-18.83-60.46-34.62c-10.67-13.78-19.18-30.4-25.3-49.4A221.26 221.26 0 0 1 96 256a221.26 221.26 0 0 1 10.24-68c6.12-19 14.63-35.62 25.3-49.4C143.76 122.83 164.18 104 192 104m0-96C84.34 8 0 116.94 0 256s84.34 248 192 248 192-108.94 192-248S299.66 8 192 8z"]],
    "thumbs-down": [512, 512, [], "f165", ["M512 277.9c-.16 30.35-26.16 58.1-59.55 58.1H350.72C358 364.34 384 388.13 384 430.55 384 504 336 512 312 512c-20.18 0-29.48-39.29-33.93-57.79-5.21-21.67-10.59-44.07-25.39-58.91-32.47-32.52-49.51-74-89.12-113.11a12 12 0 0 1-3.56-8.52V59.9a12 12 0 0 1 11.78-12c15.83-.29 36.7-9.08 52.66-16.17C256.19 17.6 295.71 0 344 0h2.85c42.78 0 93.36.41 113.77 29.74 8.39 12.05 10.45 27 6.15 44.63 16.31 17 25.06 48.86 16.38 74.76 17.55 23.43 19.15 56.13 9.31 79.46l.11.12C504.45 240.65 512.08 260 512 277.9z", "M104 32H24A24 24 0 0 0 0 56v240a24 24 0 0 0 24 24h80a24 24 0 0 0 24-24V56a24 24 0 0 0-24-24zM64 280a24 24 0 1 1 24-24 24 24 0 0 1-24 24z"]],
    "thumbs-up": [512, 512, [], "f164", ["M163.56 229.81c39.61-39.15 56.65-80.59 89.12-113.11 14.8-14.84 20.18-37.24 25.39-58.91C282.52 39.29 291.82 0 312 0c24 0 72 8 72 81.45 0 42.42-26 66.21-33.28 94.55h101.73c33.39 0 59.39 27.75 59.55 58.1.08 17.94-7.55 37.25-19.44 49.19l-.11.12c9.84 23.33 8.24 56-9.31 79.46 8.68 25.9-.07 57.71-16.38 74.76 4.3 17.6 2.24 32.58-6.15 44.63C440.2 511.59 389.62 512 346.84 512H344c-48.28 0-87.8-17.6-119.56-31.73-16-7.09-36.82-15.88-52.65-16.17a12 12 0 0 1-11.78-12V238.33a12 12 0 0 1 3.55-8.52z", "M104 224H24a24 24 0 0 0-24 24v240a24 24 0 0 0 24 24h80a24 24 0 0 0 24-24V248a24 24 0 0 0-24-24zM64 472a24 24 0 1 1 24-24 24 24 0 0 1-24 24z"]],
    "thumbtack": [384, 512, [], "f08d", ["M384 328a24 24 0 0 1-24 24H224V208a16 16 0 0 0-16-16h-32a16 16 0 0 0-16 16v144H24a24 24 0 0 1-24-24c0-50.74 37.47-91.18 86-113.73L98.21 96H56a24 24 0 0 1-24-24V24A24 24 0 0 1 56 0h272a24 24 0 0 1 24 24v48a24 24 0 0 1-24 24h-42.21L298 214.27c48 22.31 86 62.55 86 113.73z", "M224 208v248a8 8 0 0 1-.84 3.57l-24 48a8 8 0 0 1-14.32 0l-24-48A8 8 0 0 1 160 456V208a16 16 0 0 1 16-16h32a16 16 0 0 1 16 16z"]],
    "thunderstorm": [512, 512, [], "f76c", ["M350 310.5l-98 194a15 15 0 0 1-27.6-11L256 352h-81a15 15 0 0 1-14.9-17l16-130a15.08 15.08 0 0 1 14.9-13h82a15 15 0 0 1 14.5 18.9L264.92 288H337a15 15 0 0 1 13 22.5z", "M512 224a96 96 0 0 1-96 96h-30a46.78 46.78 0 0 0-45-60h-30.5l10.9-40.9A47 47 0 0 0 276 160h-85a47.1 47.1 0 0 0-46.6 40.8L128.5 320H96a96 96 0 0 1-96-96c0-42.5 27.8-78.2 66.1-90.8A113.72 113.72 0 0 1 64 112 111.94 111.94 0 0 1 176 0c43.3 0 80.4 24.8 99 60.8C289.7 43.3 311.4 32 336 32a80 80 0 0 1 80 80 78.09 78.09 0 0 1-1.6 16.2c.5 0 1-.2 1.6-.2a96 96 0 0 1 96 96z"]],
    "thunderstorm-moon": [576, 512, [], "f76d", ["M567.94 223.8c-70.4 13.3-135-40.3-135-110.8a112.62 112.62 0 0 1 57.5-98.1 6.74 6.74 0 0 0-2.1-12.5 146.75 146.75 0 0 0-26.5-2.4c-77.91 0-141.11 61.2-144.41 137.9a111.46 111.46 0 0 1 58.9 61.7 111.82 111.82 0 0 1 70.21 86.8c5.1.5 10 1.5 15.2 1.5a145 145 0 0 0 112.6-53.3c4.2-4.8-.2-12-6.4-10.8zM276 336h-57.68l17.3-64.9A12 12 0 0 0 224 256h-68a12.06 12.06 0 0 0-11.9 10.4l-16 120A12 12 0 0 0 140 400h59.3l-23 97.2a12 12 0 0 0 22.1 8.8l88-152a12 12 0 0 0-10.4-18z", "M350.58 225.5A79.91 79.91 0 0 1 336 384h-30l8.11-14A44 44 0 0 0 276 304h-16l6.6-24.7a44 44 0 0 0-42.55-55.3H156a44.26 44.26 0 0 0-43.71 38.2l-16 120a10.82 10.82 0 0 1 0 1.8H80a80 80 0 0 1-15.8-158.4c0-.5-.2-1.1-.2-1.6a95.85 95.85 0 0 1 173.74-56 79 79 0 0 1 34.31-8 80 80 0 0 1 78.51 65.5z"]],
    "thunderstorm-sun": [576, 512, [], "f76e", ["M322 96.2l8.9-26.7a13 13 0 0 0-16.5-16.4l-75.3 25.1-35.5-71a13 13 0 0 0-23.3 0l-35.5 71-75.3-25.1a13 13 0 0 0-16.4 16.5l25.1 75.3-71 35.5a13 13 0 0 0 0 23.3l71 35.5-25.1 75.3A13.06 13.06 0 0 0 69.6 331l59.2-19.7c-.2-2.4-.7-4.7-.7-7.2a110.52 110.52 0 0 1 6.2-35.9 92.22 92.22 0 0 1-10.2-8.3 96.21 96.21 0 0 1 0-135.8c34.6-34.6 89.1-36.8 126.7-7.4A127.12 127.12 0 0 1 320 96c.7 0 1.3.2 2 .2zM128 192a63.4 63.4 0 0 0 21.1 47.1 112.14 112.14 0 0 1 44.8-37.2 127.52 127.52 0 0 1 31.9-64A63.13 63.13 0 0 0 192 128a64.06 64.06 0 0 0-64 64zm308 144h-57.7l17.3-64.9A12 12 0 0 0 384 256h-68a12.06 12.06 0 0 0-11.9 10.4l-16 120A12 12 0 0 0 300 400h59.3l-23 97.2a12 12 0 0 0 22.1 8.8l88-152a12 12 0 0 0-10.4-18z", "M510.58 225.5A79.91 79.91 0 0 1 496 384h-30l8.11-14A44 44 0 0 0 436 304h-16l6.6-24.7a44 44 0 0 0-42.55-55.3H316a44.26 44.26 0 0 0-43.71 38.2l-16 120a10.82 10.82 0 0 1 0 1.8H240a80 80 0 0 1-15.8-158.4c0-.5-.2-1.1-.2-1.6a95.85 95.85 0 0 1 173.74-56 79 79 0 0 1 34.31-8 80 80 0 0 1 78.51 65.5z"]],
    "ticket": [576, 512, [], "f145", ["M576 208v-96a48 48 0 0 0-48-48H48a48 48 0 0 0-48 48v96a48 48 0 0 1 0 96v96a48 48 0 0 0 48 48h480a48 48 0 0 0 48-48v-96a48 48 0 0 1 0-96zM400 400a16 16 0 1 1 16-16 16